//
//   OP/2 BBS - Copyright (c) 1990 ExcelSoft Software. All rights reserved.
//
//   OS2BBS.H
//
//   Main header file for BBS and child processes or sessions
//
//    9apr90   cab   Version 1.0 locked
//

#ifndef    _OS2BBS_H
#define    _OS2BBS_H

#define DEBUG_SYNC

#ifdef DEBUG_SYNC
  #define SYNCON(a)      DbaseSync(1,a)
  #define SYNCOFF(a)     DbaseSync(0,a)
#else
  #define SYNCON(a)     
  #define SYNCOFF(a)
#endif

#include "os2ver.h"          // version and number of users file

#ifndef EXPAN                // shell routines for main bbs only
   #define TRACKER(a,b)      strcpy(UNHAND->cmodule,a);  UNHAND->cline = b;
#endif

#define TRUE        1        // some useful on/offs
#define FALSE       0
#define YES         1
#define NO          0

#ifndef ON
  #define    ON     1
#endif
#ifndef OFF
  #define    OFF    0
#endif
#define MAXINST     3          // maximum number of instances of the program

#ifndef OS_INCLUDED
   #define  BYTE   unsigned char
   #define  ULONG  unsigned long
   #define  USHORT unsigned short
   #define  SHORT  short
   #define  UCHAR  unsigned char
   #define  CHAR   char
#endif

#ifdef EXPAN
  #define   LOGGED_IN   ( SerConnected(unhand) && UseTm(unhand) && V_USRON )
  #define   LoggedIn()  ( SerConnected(unhand) && UseTm(unhand) && V_USRON )
#else
  #define   LOGGED_IN   ( SerConnected(UNHAND) && UseTm(UNHAND) && V_USRON )
  #define   LoggedIn()  ( SerConnected(UNHAND) && UseTm(UNHAND) && V_USRON )
#endif
#define Forgotten(a,b)     (uurdbit(a,b->uforget))

//
//  Index into lmodemcode[] array for modem results
//
#define OK         0
#define RING       1
#define CNT300     2
#define ARQ300     3
#define CNT1200    4
#define ARQ1200    5
#define CNT2400    6
#define ARQ2400    7
#define CNT4800    8
#define ARQ4800    9
#define CNT9600    10
#define ARQ9600    11

#define NUM_TERMS   2             /* number of terminal types available */
#define NONE        0             /* dumb terminal */
#define ANSI        1             /* ANSI standard terminal */

typedef struct {
   CHAR   tname[6];               /* terminal name */
   SHORT  tnum;                   /* terminal number code */
   SHORT  tcolor;                 /* has color capability */
   SHORT  tcursor;                /* has cursor movement */
} t_types;

#ifdef EXPAN
 #define COLOR(a)   if(PU->u_ttype) TrmColor(a,unhand);
#else
 #define COLOR(a)   if(PU->u_ttype) TrmColor(a,UNHAND);
#endif 

// Attributes and colors:
#define ALLOFF      0
#define BRIGHT      1
#define RED         31
#define GREEN       32
#define YELLOW      33
#define BLUE        34
#define MAGENTA     35
#define CYAN        36
#define WHITE       37

#define BRRED         (31+64)
#define BRGREEN       (32+64)
#define BRYELLOW      (33+64)
#define BRBLUE        (34+64)
#define BRMAGENTA     (35+64)
#define BRCYAN        (36+64)
#define BRWHITE       (37+64)

#define BACKBLACK     (0x2800)
#define BACKRED       (0x2900)
#define BACKGREEN     (0x2A00)
#define BACKYELLOW    (0x2B00)
#define BACKBLUE      (0x2C00)
#define BACKMAGENTA   (0x2D00)
#define BACKCYAN      (0x2E00)
#define BACKWHITE     (0x2F00)

// Priority Values
#define  VERY_LOW    0           /* priorities */
#define  LOW         1
#define  MEDIUM      2
#define  HIGH        3
#define  VERY_HIGH   4

typedef struct {
   CHAR           lname[10];      // port name, i.e. COM1, COM2
   CHAR           linit[30];      // string to initalize port
   CHAR           lans[10];       // modem answer string
   USHORT         lmodemcode[12]; // Return codes, array elements:
                                  // 0= Okay,          1=Ring,
                                  // 2= Cnct 300 bps,  3= Cnct 300 ARQ
                                  // 4= Cnct 1200 bps, 5= Cnct 1200 bps ARQ
                                  // 6= Cnct 2400 bps, 7= Cnct 2400 bps ARQ
                                  // 8= Cnct 4800 bps, 9= Cnct 4800 bps ARQ
                                  // 10=Cnct 9600 bps, 11=Cnct 9600 bps ARQ
                                  //   Note: ARQ=Error Correcting
   USHORT         lon;            // is this port even on or what?
   USHORT         luptime;        // time this port goes up (not currently used)
   USHORT         ldntime;        // time this port goes down (not currently used)
   USHORT         ldte;           // DTE either 'FIXED' or 'NORMAL'
   USHORT         lrfc;           // receiving flow control
   USHORT         ltfc;           // transmitting flow control
   USHORT         lspeed;         // maximum speed, i.e. 2400
   USHORT         ldbits;         // data bits
   USHORT         lparity;        // parity
   USHORT         lstop;          // stop bits
   USHORT         ldumbterm;      // line is a terminal
   CHAR           lEXPAND[80];    // expansion
} LINECTL;


typedef struct {
   LONG       xcalls;
   LONG       xlastcall;
   USHORT     xcallstoday;
   USHORT     xuser;              // next user number
} VARCONFIG;


typedef struct {                  // structure for audit call log
   CHAR   cl_user[14];            // users name
   BYTE   cl_port;
   ULONG  cl_intime;              // time logged in
   ULONG  cl_outtime;             // time logged out
   SHORT  cl_emailwrite;          // mins online
   BYTE   cl_sex;
   BYTE   cl_age;
   BYTE   cl_messwrite;           // messages left while online
   SHORT  cl_messread;            // messages read while online
   BYTE   cl_fldown;              // files downloaded while online
   BYTE   cl_flup;                // files uploaded while online
} CALLLOG;

#ifdef STACKSIZE
  #undef STACKSIZE
#endif
#define STACKSIZE    8192         // BIG stack size for each thread
#define ASYNCSTK     4096         // stack for async thread
#define CBUF          128         // communictions input buffer
#define KEYBUFSIZE     64         // console input buffer size
#define EMAIL           0         // email is always section 0
#define FREEZE_PORT    99
#define GODLEVEL       99         // ultimate sysop level
#define MAXPAGE         6         // maximum waiting pages per user
#define PGSIZE        160
#define NEWUSERLEV      1
#define TCLNLEN       135         // teleconf line length
#define UN            usernum
#define UNHAND        (bport+usernum)   // usernumber record handle
#define DEMO_NUM      9999
#ifdef EXPAN
   #define CREGCOL    (unhand->gis->gisInputColor)
#else
   #define CREGCOL    (syscon.cregcol)
#endif
#define MAXFORUM      100
#define MAXCMD         80         // maximum waiting command buffer size 

// Page types
#define PAGE_SYSOP      1
#define PAGE_SYSTEM     2
#define PAGE_REGULAR    3
#define PAGE_CHAT       4
#define PAGE_LOGIN      5
#define PAGE_LOGOUT     6
#define PAGE_MAIL       7
#define PAGE_SYSOPALL   8
#define PAGE_BIGBEN     9

// Page return codes
#define PERR_OK         0     // page sent okay
#define PERR_FULL       1     // page buffer full
#define PERR_FORGET     2     // paging user has been forgotten
#define PERR_MISCERR    3     // unknown error. Probably no user on line

// Time out flags
#define WARN_TMOUT    300
#define KILL_TMOUT    500
#define DEF_TIMEOUT  1500

                                  // defines to determin access
#define   MSEE     1
#define   MREAD    2
#define   MWRITE   3
#define   MSYSOP   4

#define   FSEE     5
#define   FLIST    6
#define   FDL      7
#define   FUL      8

typedef struct {
   USHORT     m_see    : 1;     // can 'view'
   USHORT     m_rd     : 1;     // can read
   USHORT     m_wt     : 1;     // has write privilage
   USHORT     m_sysop  : 1;     // sysop access to this area
   USHORT     m_qscan  : 1;     // flag for quick scan this area
   USHORT     m_lock   : 1;     // locks access levels for this user     
   USHORT     m_exp    : 10;    // expansion
} MA_REC;                       // message access record 


typedef struct {
   USHORT   f_see    : 1;
   USHORT   f_list   : 1;
   USHORT   f_dload  : 1;
   USHORT   f_upload : 1;
   USHORT   f_sysop  : 1;
   USHORT   f_qscan  : 1;
   USHORT   f_exp    : 10;      // expansion
} FL_REC;

typedef struct {
   SHORT    lforumon;           // is the forum active at all?
   CHAR     lcode[2];           //
   SHORT    lanon;              // anonymous messages allowed
   LONG     lcreate;            // forum creation date
   SHORT    lup;                // uploads go directly to download directory */
   SHORT    lmess_on;           // message section turned on
   SHORT    lfile_on;           // file system turned on
   SHORT    laccess;            // level to have default access to this section */
   SHORT    llowaccess;
   SHORT    lkey;
   SHORT    llowkey;
   CHAR     lkeyflag;
   CHAR     llowkeyflag;
   FL_REC   ldef_fl;            // default file access for this forum
   MA_REC   ldef_ma;            // default message access for this forum 
   FL_REC   llow_fl;            // low level file access for this forum
   MA_REC   llow_ma;            // low level message access for this forum
   CHAR     lmod[14];           // conference moderator */
   CHAR     lname[30];          // name of section */
   CHAR     lpath[30];          // path for files... */
   SHORT    lfileraw;           // Raw file system flag, no data base kept.
   USHORT   lmaxmsg;            // Maximum messages for this forum
   USHORT   lautopack;          // Autopack these messages on startup?
   USHORT   lpackwedge;         // Number of message sockets to free beyond packed
   CHAR     lexpand[12];
} SECSETUP;

// structure for commands used to trigger a "global action"
typedef struct {
   CHAR  cmdstr[15][10];
} GLOBCMDS;

typedef struct {
   LONG      cserialnum;            // system serial number 
   CHAR      cnewuserpw[10];        // password to join system
   SHORT     cclosed;               // flag for closed system, need cnewuserpw to get in
   CHAR      cbbsname[40];          // 1 BBS Name
   CHAR      csysop[20];            // 1 sysop name
   CHAR      cphone[20];            // 1 system phone number
   CHAR      cperpath[30];          // 1 'personal' files path
   CHAR      clogname[30];          // usage log file name and path
   SHORT     cregcol;               // normal menu/system color

   CHAR      EXPAND1[12];           // expansion
   ULONG     cnwkey;                // 2 new user stuff, keys... 
   SHORT     cnwaccess;             // 2 new user access level (1-100)
   SHORT     cshowmail;             // code 1 for email only, 2 for all mail
   SHORT     creadmail;             // sysop func: level needed to read private mail
   SHORT     clogmail;              // set to log public messages to disk.
   SHORT     cmodusr;               // sysop func: level needed to modify users

   CHAR      EXPAND2[2];
   USHORT    csysopin;              // 1 sysop start avail time
   USHORT    csysopout;             // 1 sysop out time 

   MA_REC    cmdef;                 // default access for message areas 
   FL_REC    cfdef;                 // default access for file areas 
   SHORT     cactsec;               // active sections (file, message) 
   SECSETUP  csec[100];             // message/file system array of access levels 
   USHORT    cdaytm[100];           // 2 default time per day for each level 
   USHORT    cmontm[100];           // 2 time per month for each level

   SHORT     cdlratio;              // 2 download to upload ratio
   SHORT     culratio;              // number of uploads required per cdlratio
   ULONG     cbytesdl;              // number of bytes in DL equation
   ULONG     cbytesul;              // number of upload bytes in equation
   SHORT     cdlmethod;             // method of dl ratio calc, number or bytes
   ULONG     csavespace;            // 1 space to save in upload directory/drives

   SHORT     su_name;               // * if these are set, ignore these fields on signup
   SHORT     su_address;
   SHORT     su_citystatezip;
   SHORT     su_phone;
   SHORT     su_company;
   SHORT     su_sex;
   SHORT     su_age;
   SHORT     su_lines;
   SHORT     su_ttype;
   SHORT     su_expert;
   SHORT     su_macro1;
   SHORT     su_macro2;

   SHORT     cauditsuppress;       // suppress auditing
   SHORT     cautospy;             // 1
   CHAR      cmesspath[40];
   CHAR      cusrpath[40];
   USHORT    ctmpercall[100];      // time per call
   SHORT     cbillcode;            // 0=call per day, 1=per month
   SHORT     cnewmesstype;         // 0 for number, 1 for date
   SHORT     cglobcmd;             // 0 to allow, 1 to prohibit
   GLOBCMDS  cglobs;               // global commands
   SHORT     ccallgap;             // minutes user must wait between calls
   SHORT     cverlevel;            // level at which user is considered "verified"
   SHORT     cinetmail;            // allow internet mail
   CHAR      EXPAND3[542];         // temporary expanstion holding
} SYSCONFIG;


//
//  Token for system and user pages 
//
typedef struct {
   SHORT  pwait;           // page active and waiting!
   CHAR   pfrom[14];       // from what user
   SHORT  pfromln;         // from user on what line
   SHORT  pmaskable;       // is this page maskable (turn off pages to ignore)
   SHORT  pgtype;          // System page, rather then a user page 
   LONG   ptm;             // time of this page
   CHAR   *ptext;          // text for this page
} PAGETOK;


//
//   Tokens for teleconferencing
//
typedef struct {                  // token for each message passed
   SHORT  tunum;                  // user number of originator
   SHORT  tsystem;                // expansion - system message is from
   SHORT  tprivate;               // if private, to whome. -1 if to all
   SHORT  tmessage;               // general message.. i.e. so and so just left
   UCHAR  tanon;                  // message anonymous
   CHAR   tfrom[14];              // who the token is from
   CHAR   ttext[TCLNLEN];         // token text
} MESSTOK;

#define MAX_REPLIES 20

//
//  Message header record
//
typedef struct {                    // structure for message header
    ULONG          mnum;            // message number
    USHORT         mbase;           // message base number for this message
    CHAR           mto[14];         // name of receiver
    USHORT         mtoid;           // id of receiver
    CHAR           mfrom[14];       // name of sender
    USHORT         mfromid;         // id of sender
    CHAR           msubject[26];    // subject
    CHAR           mattach[16];     // file name given to the user
    CHAR           mfname[14];      // file name used by file system
    LONG           mattsize;        // file size of attached file
                                    //
    LONG           mdate;           // date and time of message
    LONG           mdaterec;        // date received
    USHORT         mreceive;        // recieved by receivee
    USHORT         mdel;            // true if been deleted
                                    //
    ULONG          mreply[MAX_REPLIES];  // messages replied to this one
    USHORT         mnumreply;       // number of replies
    ULONG          mwasreply;       // message number this was a reply to
    CHAR           mforto[14];      // Forwarded message origionally to mforto
    LONG           mfordate;        // date the message was forwarded
    CHAR           mtocc[14];       // if cc, who was it to origionally
    USHORT         msysid;          // system id of author system. 0 for local
    USHORT         mtoanon;         // hide the recipiant?
    USHORT         manon;           // true if this message is annonymous
    LONG           mstart;          // fpos for start of messege
    USHORT         mlines;          // number of lines to read
    USHORT         mbytes;          // byte count for text portion
    ULONG          mseq;            // sequence of message in history         
    ULONG          mlocseq;         // sequence of message, starting at 1
    CHAR           minet;           // internet flag
    UCHAR          msysfrom[31];    // system name message is from
    CHAR           expand[30];
} MESSREC; 
#define _MESSREC_DEF

//
//  Library header record
//
typedef struct {
   CHAR  fname[14];         // file name
   LONG  fdate;             // the file date (entered)
   LONG  fsize;             // file size
   CHAR  fsdesc[50];        // the file's short description
   SHORT fverified;         // if file is verified for publc access
                            // 
   LONG  fldescptr;         // the location of the long desc in text file
   SHORT fldescsz;          // the size of the long description
   SHORT faccess;           // number of times this file accessed
   LONG  flastacc;          // date/time of last access
   CHAR  fcontrib[13];      // contributer
   CHAR  fdel;              // delete flag
} LIBREC;
#define _LIBREC_DEF

//
//  User record
//
typedef struct {
    CHAR       u_handle[14];      // handle, limited to 12 actual chars.
    CHAR       u_pword[16];       // password
    BYTE       u_age;             // age
    BYTE       u_sex;             // 0=female, 1=male
    CHAR       u_fname[14];       // first name
    CHAR       u_lname[14];       // last name
    CHAR       u_computer[10];    // computer type
    CHAR       u_address[30];     // street address
    CHAR       u_city[16];        // city
    CHAR       u_state[4];        // state
    CHAR       u_zip[6];          // zipcode
    CHAR       u_phone[14];       // telephone  xxx4 xxxxxxx8
                                  // ACCESS INFORMATION 
    USHORT     u_time_day;        // time allowed per day 
    USHORT     u_time_month;      // time allowed per month 
    BYTE       u_deleted;         // user active? 
    BYTE       u_access;          // user access level 
    ULONG      u_keys;            // 32 user keys 
                                  // CONFIGURATION 
    BYTE       u_lf;              // need linefeeds? 
    BYTE       u_expert;          // expert mode 
    BYTE       u_ttype;           // terminal type, 0=nonansi, 1=ansi
    BYTE       u_rows;            // rows on his screen 
    BYTE       u_cols;            // columns on his screen 
    BYTE       u_FILLER;          // to balance uneven bytes 
                                  // USAGE STATISTICS 
    USHORT     u_day_use;         // min used today 
    USHORT     u_mon_use;         // min used this month 
    LONG       u_last_use;        // time of last login 
    ULONG      u_total_use;       // total min online ever 
    USHORT     u_mtd_logins;      // month to date logins 
    USHORT     u_logins;          // total times logged in 
    USHORT     u_uploads;         // number of uploads total 
    USHORT     u_downloads;       // number of downloads total 
    ULONG      u_ulsize;          // bytes of uploaded material 
    ULONG      u_dlsize;          // bytes of downloaded material 
                                  // MESSAGE BASE AND FILE INFO 
    FL_REC     u_file[MAXFORUM];  // 2 bytes for each file section 
    MA_REC     u_mess[MAXFORUM];  // 2 Byte each, info for each message base 

    LONG       u_luse[MAXFORUM];  // time/date last used each forum 
    SHORT      u_lastforum;       // last forum used 
    USHORT     u_sentmess;        // number of messages sent 
    ULONG      u_firstlogin;      // first login

    SHORT      u_fpindex;         // File system preference, index (name or date)
    SHORT      u_fpsort;          // File system preference, direction (ascending, descending)
    SHORT      u_ful;             // default upload protocol
    SHORT      u_fdl;             // default download protocol

    CHAR       u_country[20];     // users country, if not USA
    SHORT      u_desc;            // short or very short file description default
    USHORT     u_sentemail;       // number of email messages sent
    CHAR       u_macro1[20];      // user macro 1
    CHAR       u_macro2[20];      // user macro 2
    CHAR       u_startup[20];     // macro run on startup
    CHAR       u_company[16];     // users company
    BYTE       u_NoTcEcho;        // Turn on to suppress TC echo
    SHORT      u_fShowLogins : 1; // Flag to show users logging in
    SHORT      u_fShowLogouts : 1;// Flag to show users logging out
    SHORT      u_fBigBen : 1;     // Big ben chimer on
    SHORT      u_fSoundOff : 1;   // True if sound is off
    SHORT      u_fNoLnNum : 1;    // true if suppress line numbers
    SHORT      u_fClear : 1;      // Clear screen between messages
    SHORT      u_fSkipFromYou : 1;// Skip messages address FROM you
    SHORT      u_fEXPAND : 9;     // Expansion flags
    SHORT      u_resuread;        // number of times your resume has been read
    ULONG      u_LastLogOff;      // last time the user logged off the system
    CHAR       u_EXPAND2[15];     // expansion

    ULONG      u_LastRead[MAXFORUM];
    USHORT     u_MessScan[16];    // 256 bits. New-scan bit maps
    USHORT     u_FileScan[16];
    USHORT     u_MessWait[16];    // 1 bit/forum for messages waiting
    CHAR       u_EXPAND3[428];
} USER_REC;
#define _USER_REC_DEF

//
//  For Mux Semaphores
//
typedef struct {             // structure for Mux of Sems for input read
   USHORT          SemCount; // number of semephores
   USHORT          res1;     // reserved word 1, must be 0
   USHORT   _far   *ps1;     // pointer to semephore 1
   USHORT          res2;     // reserved word 2, must be 0
   USHORT   _far   *ps2;     // pointer to semaphore number 2
   USHORT          res3;     // reserved word 3, must be 0
   USHORT   _far   *ps3;     // pointer to semaphore 3
} MuxList;       


//
//  System wide data block
//
typedef struct {
   ULONG     ScreenOk;              // Screen write semephore
   ULONG     gisPages;              // Pages on the system since startup
   USHORT    gisMaxusers;           // Max users for the system
   USHORT    gisLogins;             // Logins since system startup
   USHORT    gisInUse;              // Ports in use
   USHORT    gisMessages;           // Messages sent
   SHORT     gisInputColor;         // color used for for text input
   SHORT     gisGlobCmd;            // 0 or 1 to deny or allow global commands
   BYTE      gisBillCode;           // Same as syscon.billcode
   GLOBCMDS  gisGlobs;              // Global command strings
   SHORT     gisVerLevel;           // same as syscon.cverlevel
   CHAR      EXPAND1[347];          // expansion
} GLOBALBLOCK;


//
//  Main System Control Structure
//
typedef struct {
   SHORT     recnum;           // VITAL, key to DLL use 
                               // FLOW CONTROL FLAGS 
   SHORT     v_local;          // console user 
   SHORT     v_spy;            // console sees output and can enter input 
   SHORT     v_commact;        // com port active 
   SHORT     v_usron;          // flag for user online 
   SHORT     v_chat;           // sysop chat flag    
   SHORT     v_reset;          // reset modem flag
   SHORT     v_offhook;        // taking phone off the hook...
                               // Menu system flags
   SHORT     v_quit;           // Quit current menu flag
   SHORT     v_showmenu;       // redisplay current menu

                               // TIME VARS 
   LONG      t_login;          // login time 
   LONG      t_credit;         // sec credited (i.e. sysop chat) 
   LONG      t_offby;          // time in seconds user must be logged off by this call 
                               // USER PAGES 

   PAGETOK   PgBuff[MAXPAGE];
   SHORT     PgWait;           // page waiting flag 
   ULONG     PgSem;            // to block read/write pages 
   LONG      PgLastTm;         // time of last page 
                               // USER RECORD 
   USER_REC  *p_user;          // pointer to user information, this port 
   LINECTL   lnctl;            // Line control information 
   SHORT     inviso;           // flag for if this user is invisable
   USHORT    nolog : 1;        // do NOT enter this login in the recent callers log
   USHORT    sysopflag:1;      // Flag user as being a sysop
   USHORT    limitcall:1;      // indicates that this call limited by "time per call", rather then time per "day/month"
   USHORT    castoff:1;        // "Cast off" incomming pages
   USHORT    FLAGEXP:12;       // expansion flags

   SHORT     remspyusr;        // Remote spy user, -1 if none
   ULONG     remspysem;        // Remote spy semaphore
   void      *remspyptr;       // PORT_REC pointer of spying user
   BYTE      remspyno;         // Locks out remote spy'ers

   CHAR      cmodule[14];      // Debugging
   SHORT     cline;            // Debugging
   
   USHORT    uforget[8];       // 16 byte bit field for users forgotten
   SHORT     ConSecCR;         // consecutive CR/LF sequences sent
   CHAR      ReadStop;         // Flag and clear AbortRead to end a getline
   SHORT     linkrate;         // speed of serial link, can be diff. then bps 
   SHORT     bps;              // bits per second connection rate 
   SHORT     loc;              // location of user on the system 
   SHORT     subloc;           // sublocation.. as in teleconf, room 2 
   USHORT    comtok;           // communications token/handle 
   SHORT     *ncin;            // next com port char in 
   SHORT     *ncout;           // next com port char out 
   SHORT     cbuff[CBUF];      // Com port input ring buffer    
   SHORT     acharin;          // number of chars in the buffer 
   SHORT     lcount;           // current screen line number for output 
   SHORT     lcounton;         // are we checking line counts? 
   ULONG     ReadOk;           // semaphore for okay to read from com port 
   ULONG     KbdIn;            // keyboard input ready semaphore 
   ULONG     AsyncIn;          // Async Input ready semephore 
   ULONG     AbortRead;        // abort read semaphore 
   MuxList   muxs;             // structure for Mux'd above 3 sems 
   ULONG     KeyinBlock;     
   CHAR      keybuff[KEYBUFSIZE];
   CHAR      *keyin;     
   CHAR      *keyout;     
   SHORT     keywait;     
   //////////////////////////// Command buffering 
   CHAR      cmdbuf[MAXCMD]; // waiting command string buffer
   SHORT     cmdwait;        // More commands waiting??
   CHAR      *cmdpoint;      // pointer to next break in cmdbuf 
   //////////////////////////// Btree vars, userbase and message base 
   SHORT     usr_db;         // data base handle for user log
   SHORT     usr_idx;        // index handle for user log    
   //////////////////////////// TELECONFERENCING 
   MESSTOK   *mtok;          // pointer to next text in teleconf
   SHORT     invite;         // room currently invited to join
   ULONG     chatok;         // semephore set while in chat.
   SHORT     chatreq;        // request chat with this user...
   SHORT     chatack;        // chat ack
   USHORT    teleeject : 1;  // eject flag
   USHORT    TEXPAN : 15;    // expansion teleconf flags

   SHORT     threadprty;     // thread priority, 1-5
   USHORT    threadid;       // thread id of processing thread
   USHORT    comthrdid;      // thread id of communications thread
   SHORT     curcolor;       // current displayed color
   SHORT     arqconnect;     // connect with error correcting modem
   USHORT    childpid;       // ID for child process for this user
   USHORT    sessionpid;     // Session ID for this child
   GLOBALBLOCK *gis;         // pointer to global block information
   USHORT    SecReq;         // section (file or message) requester

   SHORT     TmOuts;         // Number of timeout warnings accumulated
   ULONG     LastInput;      // Time of last user keystroke
   USHORT    LastCmd[2];     // Last MCF ordinal number and type
   BYTE      LogoffWarn;     // Warning level before time limit logoff
   BYTE      DebugCode;      // Flag used for debugging purposes
   BYTE      billcode;       // the syscon billing code used
   ULONG     ChatZeroChar;   // Special semaphore for private chat
   CHAR      locstr[26];     // location on the system
   CHAR      EXPAND2[43];    // 'quick expanstion' space
} PORT_REC;


#ifdef EXPAN                   // Use for DLL and expansion APPs
#define USENUM     unhand->recnum
#define PU         unhand->p_user
#define V_LOCAL    unhand->v_local
#define V_SPY      unhand->v_spy
#define V_COMMACT  unhand->v_commact
#define V_USRON    unhand->v_usron
#define V_CHAT     unhand->v_chat
#define V_RESET    unhand->v_reset
#define V_OFFHOOK  unhand->v_offhook
#define V_QUIT     unhand->v_quit
#define V_SHOWMENU unhand->v_showmenu
#define INVISO     unhand->inviso
#define NOLOG      unhand->nolog
#define USR_DB     unhand->usr_db
#define USR_IDX    unhand->usr_idx
#define P_USER     unhand->p_user
#define T_LOGIN    unhand->t_login
#define T_OFFBY    unhand->t_offby
#define T_CREDIT   unhand->t_credit
#define COMTOK     unhand->comtok
#define CMDWAIT    unhand->cmdwait
#define LCOUNT     unhand->lcount
#define LCOUNTON   unhand->lcounton
#define CURCOLOR   unhand->curcolor
#define ARQCONNECT unhand->arqconnect
#define SESSIONPID unhand->sessionpid
#define CHILDPID   unhand->childpid
#define GIS        unhand->gis
#define SECREQ     unhand->SecReq
#define REMSPYUSR  unhand->remspyusr
#define REMSPYSEM  unhand->remspysem
#define REMSPYPTR  unhand->remspyptr
#define REMSPYNO   unhand->remspyno
#else                                  // Used in main BBS code
#define USENUM     (bport+usernum)->recnum
#define PU         (bport+usernum)->p_user
#define V_LOCAL    (bport+usernum)->v_local
#define V_SPY      (bport+usernum)->v_spy
#define V_COMMACT  (bport+usernum)->v_commact
#define V_USRON    (bport+usernum)->v_usron
#define V_CHAT     (bport+usernum)->v_chat
#define V_RESET    (bport+usernum)->v_reset
#define V_OFFHOOK  (bport+usernum)->v_offhook
#define V_QUIT     (bport+usernum)->v_quit
#define V_SHOWMENU (bport+usernum)->v_showmenu
#define INVISO     (bport+usernum)->inviso
#define NOLOG      (bport+usernum)->nolog
#define USR_DB     (bport+usernum)->usr_db
#define USR_IDX    (bport+usernum)->usr_idx
#define P_USER     (bport+usernum)->p_user
#define T_LOGIN    (bport+usernum)->t_login
#define T_OFFBY    (bport+usernum)->t_offby
#define T_CREDIT   (bport+usernum)->t_credit
#define COMTOK     (bport+usernum)->comtok
#define CMDWAIT    (bport+usernum)->cmdwait
#define LCOUNT     (bport+usernum)->lcount
#define LCOUNTON   (bport+usernum)->lcounton
#define CURCOLOR   (bport+usernum)->curcolor
#define MODEMCODE  ((bport+usernum)->lnctl.lmodemcode)
#define ARQCONNECT (bport+usernum)->arqconnect
#define SESSIONPID (bport+usernum)->sessionpid
#define CHILDPID   (bport+usernum)->childpid
#define GIS        (bport+usernum)->gis
#define SECREQ     (bport+usernum)->SecReq
#define REMSPYUSR  ((bport+usernum)->remspyusr)
#define REMSPYSEM  ((bport+usernum)->remspysem)
#define REMSPYPTR  ((bport+usernum)->remspyptr)
#define REMSPYNO   ((bport+usernum)->remspyno)
#endif

#endif

