////////////////////////////////////////////////////////////////////////////
//
//   Omega Point/2 Bulletin Board System
//   Copyright (c) ExcelSoft Software, 1990
//   Version 1.0, cab, 21-Feb-90
//   
//   This file may be freely modified for you own use. You will need
//   the OS/2 Programmer's Toolkit to recompile this module. The .OBJ
//   file has been provided so that you can create expansion programs
//   even if you don't have the Toolkit.
//
//   This file contains several functions that are needed by OP/2
//   BBS expansion programs. This file should be complied and linked
//   with any OP/2 BBS expansion program. The functions in this
//   module are as follows:
//
//     SerWritef() : Just like the 'printf()' functions. Included here
//            rather then in the BBSAPI.LIB because it needs 'C' calling
//            convention.
//
//     UseChildAppInit() : Full initialization function. Sets up the
//            shared memory segments and semaphores needed for correct
//            operation.
//
//     CleanExit() : Insures that when the program ends, for whatever
//            reason, the 'program end' semaphore will be cleared and
//            the main program will resume operation.
//
//   See EXPAND.C and EXPAND.MAK for sample code and make file.
//
//////////////////////////////////////////////////////////////////////////

#define INCL_DOS
#define INCL_SUB
#include <os2.h>

#include <stdio.h>
#include <string.h>
#include <stdarg.h>

#include "os2bbs.h"
#include "bbsapi.h"

#define MAINMODULE
#define NO_INCL_BBS                 
#include "bbsexpan.h"


//
//  UseChildAppInit()
//
//  Intializes OP/2 BBS expansion program
//
UseChildAppInit(char *pstr, char *exename, PORT_REC **anchor, PORT_REC **unhand, void far **sem, int *usernum, int *instance)
{
   USHORT  Selector, Sel2, Sel3, Sel4;
   USHORT  rc;
   char    segname[40];
   char    semname[30], temp[6];

   DosExitList(EXLST_ADD,(PFNEXITLIST)CleanExit);

   if( strlen(pstr) != 4 )
      return(1);

   strcpy(temp,pstr);
   temp[2] = '\0';
   *instance = atoi(temp);
   strcpy(temp,(pstr+2));
   *usernum = atoi(temp);

   sprintf(segname,"\\SHAREMEM\\BPORT%02d.BBS",*instance);
   rc = DosGetShrSeg(segname,&Selector);
   if( rc )
      return(2);

   sprintf(segname,"\\SHAREMEM\\USER%02d.BBS",*instance);
   rc = DosGetShrSeg(segname,&Sel2);
   if( rc ) 
      return(3);

   sprintf(segname,"\\SHAREMEM\\GIS%02d.BBS",*instance);
   rc = DosGetShrSeg(segname,&Sel3);
   if( rc )
      return(4);

   sprintf(segname,"\\SHAREMEM\\PAGE%02d.BBS",*instance);
   rc = DosGetShrSeg(segname,&Sel4);
   if( rc )
      return(6);

   *anchor = (PORT_REC far *)( (unsigned long)Selector<<16 );
   *unhand = (*anchor + (*usernum));

   sprintf(semname,"\\SEM\\PG%02d%02d.BBS",*instance,*usernum);
   rc = DosOpenSem(*(&sem),semname);
   if( rc )
      return(5);
   return(0);
}


//
//  SerWritef()
//
//  Garden variety printf() type function. 
//
SerWritef(PORT_REC *unhand, char *fmt, ...)
{
   char buffer[255];
   va_list arg_ptr;
   va_start(arg_ptr,fmt);
   vsprintf(buffer,fmt,arg_ptr);
   va_end(arg_ptr);
   return(SerWrite(buffer,unhand));
}

//
//  CleanExit()
//
//  Makes sure everything is in order before terminating
//  the program.
//
PFNEXITLIST CleanExit(USHORT code)
{
   fcloseall();
   if( semhand ) {
      DosSemClear(semhand);
      DosCloseSem(semhand);
   }   
   DosExitList(EXLST_EXIT,0);
}

