//
//  BBSDB.H
//
//  Include file for prototyping of DLL database functions
//
#ifndef _BBSDB_H
#define _BBSDB_H

#ifndef NODSDLL
   #define NODSDLL   short far pascal
#endif
#ifndef DSDLL
   #define DSDLL     short far pascal _loadds
#endif

#ifdef INCL_ALL
  #define INCL_USER
  #define INCL_MESS
  #define INCL_FILE
#endif

// Number of indexes for each database type
#define USER_NUM_IDX  (1)
#define FILE_NUM_IDX  (2)
#define MESS_NUM_IDX  (3)

#define SEQ_FIRST  1
#define SEQ_NEXT   2
#define SEQ_PREV   3
#define SEQ_LAST   4

#define FIND_EQL   0
#define FIND_GTE   1
#define FIND_LTE   2
#define FIND_GT    3
#define FIND_LT    4

#define USRIDX_NAME   1
#define USRIDX_AUX    2

#define MESIDX_TO     1
#define MESIDX_NUM    2

#define FILIDX_DATE   1
#define FILIDX_NAME   2

//
// user data base functions
//
#if( defined(INCL_USER) || defined(_USER_REC_DEF) )

DSDLL UdbAddUser(USER_REC *, short);
DSDLL UdbAuxIndex(short, short, short, short);
DSDLL UdbClose(short);
DSDLL UdbFindSeq(USER_REC *, short, short, short);
DSDLL UdbFindUser(USER_REC *, short, void *, short, short);
DSDLL UdbInit(short);
DSDLL UdbOpen(char *, short, short, short *);
DSDLL UdbUpdateUser(USER_REC *, short);

#endif

//
// Message system functions
//
#if( defined(INCL_MESS) || defined(_MESSREC_DEF) )

DSDLL MdbAdd(MESSREC *, char *, short);
DSDLL MdbClose(short);
DSDLL MdbFind(MESSREC *, short, void *, short, short, short);
DSDLL MdbFindSeq(MESSREC *, short, short, short);
DSDLL MdbOpen(char *, short, short, short *);
DSDLL MdbQuery(short, unsigned long, void *, short);
DSDLL MdbQuickAdd(char *, short, char *, char *, char *, char *, short);
DSDLL MdbReadText(MESSREC *, char *, short);
DSDLL MdbUpdate(MESSREC *, short);

#endif

//
//  File database functions
//
#if( defined(INCL_FILE) || defined(_LIBREC_DEF) )

DSDLL FdbOpen(char *, short, short, short *);
DSDLL FdbClose(short);
DSDLL FdbAdd(LIBREC *, char *, short);
DSDLL FdbReadText(LIBREC *, char *, short);
DSDLL FdbFind(LIBREC *, short, void *, short, short, short);
DSDLL FdbFindSeq(LIBREC *, short, short, short);
DSDLL FdbUpdate(LIBREC *, short);

#endif

#endif

