'Mand57 920311 HM
screen 12
column%=80			'textcolumner
color 15,0
defdbl a-z
on error goto Fel
dim col%(32000),id%(4,4)
dim cb%(25)
dim spectrum%(15)
dim c(15),s(15),l(15)
randomize timer
colordata:
'    Reg.       Col.    Sat.    Lum.
data 0,		0,	0,	0.90
data 1,		0.4,	1,	1
data 2,		0.6,	1,	1
data 3,		0.8,	1,	0.9
data 4,		1,	1,	0.9
data 5,		1.25,	1,	0.9
data 6,		1.5,	1,	0.9
data 7,		1.75,	1,	0.97
data 8,		2,	1,	1
data 9,		2.2,	1,	1
data 10,	2.35,	1,	1
data 11,	2.5,	1,	1
data 12,	2.7,	1,	0.94
data 13,	0.1,	1,	0.95
data 14,	0,	0,	0
data 15,	2,	0,	1.2
gosub defaultcol
cls
'color 14
locate 3,2:print "Mandelbrot ver: 5.7, 11/3 1992, Hkan Malmqvist"
locate 4,2:print "287/387 assembler floating point routine."
locate 5,2:print "Assembler pixel drawing routine."
locate 6,2:print "Window plotting, saving and loading."
locate 7,2:print "Picture file extension .MDE"

locate 9,2:print  "Left mouse button  = move zoom box."
locate 10,2:print "Right mouse button = resize zoom box."

locate 12,2:print "Define window with zoom box before pressing S"
locate 13,2:print "if you want to save part of the screen."

locate 15,2:print "Try color factors 1.0 to 1.2 (log palette)."

def seg=0
gmseg=peek(51*4+2)+256*peek(51*4+3)	'Interrupt 33H (51)
gmouse=2+peek(51*4)+256*peek(51*4+1)
def seg=gmseg

'reset
g1%=0
call mustest (g1%)

if not g1% then
    color 11
    locate 10,2:print "Mouse driver not installed!"
    beep
    while not instat
    wend
    goto slut
end if

'set sensitivity
g1%=15
g3%=16
g4%=16
call absolute gmouse(g1%,g2%,g3%,g4%)

colstep%=1:colfac=1
lim=4
Wid%=480
Heig%=480
line (0,0)-(wid%-1,heig%-1),15,b
xlim%=wid%
Dname$="M1"
Exten$=".MDE"
Filename$="M1.MDE"
It%=50
cwid%=wid%/5
cheig%=heig%/5
dim cencol%(cwid%+2,cheig%+2)	
dim count%(1001)
copy%=0
dim tc%(1000),bc%(1000),lc%(1000),rc%(1000)
Realmin=-2
Realmax=1
Imagcen=0
Realbredd=Realmax-Realmin
Startbredd=Realbredd
Imagbredd=Realbredd*Heig%/Wid%
Imagmax=Imagcen+0.5*Imagbredd
Imagmin=Imagcen+0.5*Imagbredd
Realdelta=Realbredd/Wid%
Imagdelta=Realdelta
color 11
locate 1,62:PRINT "  **MANDELBROT**"
color 15
gosub menutext
goto menu

newplot:
gosub raderaruta
locate 2,62:print "Rmin:"
locate 3,62:input;Realmin
locate 4,62:print "Rmax:"
locate 5,62:input;Realmax
locate 6,62:print "Icen:"
locate 7,62:input;Imagcen
if realmax-realmin=0 then
    realmin=-2
    realmax=1
end if
Realbredd=Realmax-Realmin
Imagbredd=Realbredd*Heig%/Wid%
Imagmax=Imagcen+0.5*Imagbredd
Imagmin=Imagcen+0.5*Imagbredd
rmininst=realmin
imaxinst=imagmax
gosub Iteration

start:
T= TIMER
Realdelta=Realbredd/x1%	
Imagdelta=Realdelta

Xreso%=x1%:Yreso%=y1%
Imagconst=Imagmax+3*imagdelta
Reald5=5*Realdelta
Imagd5=5*Imagdelta

'pass 1
j%=0
a$=""
FOR yy%=-3 TO Yreso%+3 step 5
    if a$=chr$(13) then exit for
    Realconst=realmin-3*realdelta
    i%=0
    FOR xx%=-3 TO Xreso%+3 step 5
        if instat then
            a$=inkey$
            if a$=chr$(13) then exit for
            gosub pause
        end if
        z%=Itdeep%
        call mandel (lim,z%,Realconst,Imagconst)
        cencol%(i%,j%)=col%(Z%)
        if xx%<0 or xx%>xreso% or yy%<0 or yy%>yreso% then goto nopoint
'Rita en 5*5 ruta
call square (column%,&b11111000,5,x%+xx%-2,y%+yy%-2,cencol%(i%,j%))
        nopoint:
        incr i%
        Realconst=Realconst+Reald5
     NEXT xx%
     Imagconst=Imagconst-Imagd5
     incr j%
     locate 13,62:print using "Time: ##### s";TIMER -T
NEXT yy%
ni%=i%-2:nj%=j%-2

'pass 2
ya%=y%
imstart=imagmax
restart=realmin
for j%=1 to nj%
    if a$=chr$(13) then exit for
    xa%=x%
    resoff=restart
    for i%=1 to ni%
        if instat then
            a$=inkey$
            if a$=chr$(13) then exit for
	    gosub pause
        end if
        if  cencol%(i%,j%-1)<>cencol%(i%,j%) then goto punkt4
        if  cencol%(i%,j%+1)<>cencol%(i%,j%) then goto punkt4
        if  cencol%(i%+1,j%)<>cencol%(i%,j%) then goto punkt4
        if  cencol%(i%-1,j%)<>cencol%(i%,j%) then goto punkt4
        goto ruta4
        punkt4:
        imcon=imstart
        xmitt%=xa%+2:ymitt%=ya%+2
        for yy%=ya% to ya%+4
            recon=resoff
            for xx%=xa% to xa%+4
                if xx%=xmitt% and yy%=ymitt% then goto klarpunkt4
                z%=Itdeep%
                call mandel (lim,z%,Recon,Imcon)
		call plot (column%,xx%,yy%,col%(z%))
                klarpunkt4:
                recon=recon+realdelta
            next xx%
            imcon=imcon-imagdelta
        next yy%
        ruta4:
        xa%=xa%+5
        resoff=resoff+reald5
    next i%
    ya%=ya%+5
    locate 13,62:print using "Time: ##### s";TIMER -T
    imstart=imstart-imagd5
next j%

passend:
a$=inkey$
locate 13,62:print using "Time: ##### s";TIMER -T

menu:
'enable cursor
g1%=1:call absolute gmouse(g1%,g2%,g3%,g4%)

rmininst=Realmin-x%*realdelta
imaxinst=Imagmax+y%*imagdelta
x%=0:y%=0
x1%=wid%-1:y1%=heig%-1
gosub position
if copy% then beep
do
    x%=0:y%=0
    x1%=wid%-1:y1%=heig%-1
    on error goto fel
    old%=0
    gosub plotwindow
    select case a$
        case "q", "Q" : goto slut
        case chr$(13)
            if copy% then call copypicture (480,320,3,x%,y%,x1%,y1%)
            copy%=-1
            a$="n"
            for row%=8 to 12
                locate row%,62:print spc(18)
            next row%
            locate 10,62:color 11:print "Plot window Y/(N)":color 15
            while not instat
            wend
            a$=inkey$
            if a$="y" or a$="Y" then
                wind%=-1
                gosub plotwindow
                call ecursor (x%,y%,x1%)
            else
                x%=0:y%=0:x1%=wid%:y1%=x1%
            end if
            wind%=0
            exit loop
        case "q", "Q":goto slut
	case "n", "N"
	    copy%=-1
            goto newplot
	case "l", "L"
             if old% then call ecursor (x%,y%,x1%)
             gosub filnamn
             call Loadmandel (x%,y%)
             copy%=-1
             x%=0:y%=0:x1%=wid%:y1%=x1%	'Hela bildens koordinater
             beep
	case "s", "S"
	     if old% then call ecursor (x%,y%,x1%)
             gosub filnamn
             call Savemandel (x%,y%,x1%,y1%)
             beep
	case "c", "C"
	    gosub setpalette
	    gosub menutext
	case "e","E"
	    wind%=0
    end select
    gosub position
loop

gosub Iteration
goto start

plotwindow:
    'enable cursor
    g1%=1:call absolute gmouse(g1%,g2%,g3%,g4%)
    while not instat
        'Read cursor location & button state
        g1%=3:call absolute gmouse(g1%,g2%,g3%,g4%)
        if g2% and 7 then
            'Disable cursor
            g1%=2:call absolute gmouse(g1%,g2%,g3%,g4%)
            call zoomruta (g2%,g3%,g4%,old%)
            'enable cursor
            g1%=1:call absolute gmouse(g1%,g2%,g3%,g4%)
            old%=-1
        end if
    wend
    a$=inkey$
    'Disable cursor
    g1%=2:call absolute gmouse(g1%,g2%,g3%,g4%)
return

pause:
    ttemp=timer-t
    locate 19,62:print "PAUSE..."
    while not instat
    wend
    locate 19,62:print spc(8)
    t=timer-ttemp
    a$=inkey$
return

sub zoomruta (g2%,g3%,g4%,old%)
    shared x%,y%,x1%,y1%,w%,wid%,heig%,wind%
    shared tc%(),bc%(),lc%(),rc%()
    w%=x1%
    'Left button pressed
    if g2%=1 then
        if old% then call ecursor (x%,y%,w%)
        x%=g3%
        y%=g4%
        if x%>wid%-11 then x%=wid%-11
        if y%>heig%-11 then y%=heig%-11
        if x%+w%>wid%-1 then w%=wid%-1-x%:x1%=w%:y1%=w%
        if y%+w%>heig%-1 then w%=heig%-1-y%:x1%=w%:y1%=w%
        call pcursor (x%,y%,w%)
        if not wind% then gosub position
    end if
    'Right button pressed
    if g2%=2 then
        if old% then call ecursor (x%,y%,w%)
        x1%=g3%-x%
        if x1%<10 then x1%=10
        y1%=x1%
        w%=x1%
        if x%>wid%-11 then x%=wid%-11
        if y%>heig%-11 then y%=heig%-11
        if x%+w%>wid%-1 then w%=wid%-1-x%:x1%=w%:y1%=w%
        if y%+w%>heig%-1 then w%=heig%-1-y%:x1%=w%:y1%=w%
        call pcursor (x%,y%,w%)
        if not wind% then gosub position
    end if
end sub

sub pcursor (x%,y%,w%)
    'Plot rectangular cursor
    shared tc%(),bc%(),lc%(),rc%()
    get (x%,y%)-(x%+w%,y%),tc%
    get (x%,y%+w%)-(x%+w%,y%+w%),bc%
    get (x%,y%+1)-(x%,y%+w%-1),lc%
    get (x%+w%,y%+1)-(x%+w%,y%+w%-1),rc%
    line (x%,y%)-(x%+w%,y%+w%),15,b
end sub

sub ecursor (x%,y%,w%)
    'Erase rectangular cursor
    shared tc%(),bc%(),lc%(),rc%()
     put (x%,y%),tc%,pset
     put (x%,y%+w%),bc%,pset
     put (x%,y%+1),lc%,pset
     put (x%+w%,y%+1),rc%,pset
end sub

position:
Realmin=rmininst+Realdelta*x%
Realmax=Realmin+Realdelta*x1%
Imagmax=imaxinst-Imagdelta*y%
Imagmin=Imagmax-Imagdelta*y1%
Realbredd=Realmax-Realmin
Zoom=Startbredd/Realbredd
r1=Realmin:if abs(r1)<1E-15 then r1=0
r2=Realmax:if abs(r2)<1E-15 then r2=0
i1=Imagmin:if abs(i1)<1E-15 then i1=0
i2=Imagmax:if abs(i2)<1E-15 then i2=0
locate 2,62:print       "Real min/max:      "
locate 3,62:print using " +##.##############";r1
locate 4,62:print using " +##.##############";r2
locate 5,62:print       "Imag min/max:      "
locate 6,62:print using " +##.##############";i1
locate 7,62:print using " +##.##############";i2
locate 8,62:print using "Zoom: +#.###^^^^   ";Zoom
return

menutext:
locate 15,62:print "<ENTER>=go,stop"
locate 16,62:print "Load/Save/New/"
locate 17,62:print "Color/Quit"
locate 18,62:print "Any key to pause"
return

slut:
END

Iteration:
locate 9,62:color 11:print using "Iterations <#####>";It%
locate 10,62:print spc(18)
locate 10,62:input Iter%
if iter%>32000 then iter%=32000:
if iter%>0 then It%=iter%
Itdeep%=It%/4
locate 11,62:print using "Col.factor <##.##>";colfac
locate 12,62:print spc(18)
locate 12,62:input newcolfac:color 15
if newcolfac>100 then newcolfac=100
if newcolfac>0 then colfac=newcolfac
i%=0
j%=0
dstep%=colstep%
Att%=1
collim=colstep%
while i%<=Itdeep%
     for j%=1 to int(collim)
         col%(i%)=att%
         incr i%
         if i%>Itdeep% then exit for
     next j%
     incr att%
     if att%>13 then att%=1
     collim=colfac*collim
wend
col%(Itdeep%)=14
return

sub Savemandel (x%,y%,wid%,heig%)
    shared overwrite%,filename$
    gosub Existfilesave
    if overwrite% then
        open filename$ for binary as #1
        gosub savedata
        call savepic (x%,y%,wid%,heig%)
        close #1
    end if
end sub

Savedata:
    put$ #1, mkd$(rmininst)
    put$ #1, mkd$(Realdelta)
    put$ #1, mkd$(imaxinst)
    for Att%=0 to 15
	put$ #1, mki$(spectrum%(Att%))
	put$ #1, mki$(100*c(att%))
	put$ #1, mki$(100*s(att%))
	put$ #1, mki$(100*l(att%))
    next Att%
    Att%=1
return

sub Loadmandel (x%,y%)
    shared filename$,dname$,xlim%
    on error goto Noexistload
    open Filename$ for binary as #1
    gosub loaddata
    call loadpic (x%,y%,xlim%)
    close #1
    goto endload
    Noexistload:
        locate 3,62:print "Can't find file:"
        locate 4,62:print "                "
        locate 4,62:print Dname$
        close #1
        while not instat
        wend
        a$=inkey$
        resume menu:
    endload:
end sub

Loaddata:
    get$ #1,24,coord$
    rmininst=cvd(mid$(coord$,1,8))
    Realdelta=cvd(mid$(coord$,9,8))
    Imagdelta=Realdelta
    imaxinst=cvd(mid$(coord$,17,8))
    rmininst=rmininst-x%*realdelta	'korrigering fr fnster
    imaxinst=imaxinst+y%*imagdelta
    get$ #1,128,spectrum$
    for Att%=0 to 15
	spectrum%(Att%)=cvi(mid$(spectrum$,8*Att%+1,2))
	c(att%)=0.01*cvi(mid$(spectrum$,8*att%+3,2))
	s(att%)=0.01*cvi(mid$(spectrum$,8*att%+5,2))
	l(att%)=0.01*cvi(mid$(spectrum$,8*att%+7,2))
	palette Att%,spectrum%(Att%)
	call setcol (c(att%),s(att%),l(att%),spectrum%(att%))
    next Att%
    Att%=1
return

raderaruta:
    for rad%=2 to 7
        locate rad%,62:print spc(19)
    next rad%
return

Filnamn:
    Newinput:
    gosub raderaruta
    f$=""
    locate 2,62:print "File name:"
    locate 3,62:print "<"+dname$+">"
    locate 4,62:input;f$
    if len(f$)>8 then goto Newinput
    if not f$="" then dname$=f$
    Filename$=Dname$+Exten$
return

Existfilesave:
    Overwrite%=-1
    on error goto Noexistsave
    open filename$ for input as #1
    input #1,dum%
    close #1
    gosub raderaruta
    locate 2,62:print "Overwrite:"
    locate 3,62:print Dname$+" Y/(N)"
    a$="N":overwrite%=0
    locate 4,62:input a$
    if a$="Y" or a$="y" then overwrite%=-1:kill filename$
    Slutexistsave:
    on error goto fel
return

Noexistsave:
close #1
resume Slutexistsave

Fel:
    print "Fel"
    close #1
resume menu

defaultcol:
for i%=0 to 15
    read spectrum%(i%),c(i%),s(i%),l(i%)
    palette i%,i%
    call setcol (c(i%),s(i%),l(i%),i%)
next i%
Att%=1
restore colordata
return

setpalette:
'0=bakgrundsfrg
'1-13=omgivning till Mandelbrotmngden
'14=Mandelbrotmngden
'15=frger fr menu mm.

line (481,16)-(639,479),0,bf
xleft%=550
xright%=630
ytop%=160
c=0:dc=0.01
s=1:ds=0.01
l=1:dl=0.01

locate 3,62:print  "COLOR PALETTE:"
locate 4,62:print  "2,8=attribute "
locate 5,62:print  "4,6=colorreg  "
locate 6,62:print  "D=defaultcol  "
locate 7,62:print  "E=erase screen"
locate 8,62:print  "A=autocycling "
locate 9,62:print  "<ENTER>=return"
locate 10,62:print "Att  Reg      "

for Att%=0 to 15
    locate 11+Att%,62:print Att%
    locate 11+Att%,67:print using "##";spectrum%(Att%)
    line (xleft%,ytop%+16*Att%)-(xright%,ytop%+16*(Att%+1)),Att%,bf
next Att%
Att%=1:Col%=0:csl%=0
locate 11+Att%,80:print "<";

'enable cursor
g1%=1:call absolute gmouse(g1%,g2%,g3%,g4%)

k=1:w%=-4:h%=-4:cvar=1
auto%=-1
pi2=8*atn(1)
brush=2
do
    while not instat
	g1%=3
	g2%=0
	call absolute gmouse(g1%,g2%,g3%,g4%)
	if g2% and 7 then
            g1%=2:call absolute gmouse(g1%,g2%,g3%,g4%)
            if g2%=1 then
                r1=rnd
                r2=brush*r1*r1
                vinkel=pi2*rnd
                xcomp%=r2*cos(vinkel)
                ycomp%=r2*sin(vinkel)
		call plot (column%,g3%+xcomp%,g4%+ycomp%,att%)
'		call square (column%,&b11111000,5,g3%-2,g4%-2,att%)
'                line (g3%,g4%)-(g3%+w%,g4%+h%),att%,bf
            end if
    	    g1%=1:call absolute gmouse(g1%,g2%,g3%,g4%)
	end if
    wend
    a$=inkey$
    g1%=2:call absolute gmouse(g1%,g2%,g3%,g4%)
    select case a$
        locate 11+Att%,80:print " ";
        case "+"
            k=1
            c(att%)=c(att%)+cvar*dc*k
            s(att%)=s(att%)+svar*ds*k
            l(att%)=l(att%)+lvar*dl*k
            gosub vgapalett
        case "-"
            k=-1
            c(att%)=c(att%)+cvar*dc*k
            s(att%)=s(att%)+svar*ds*k
            l(att%)=l(att%)+lvar*dl*k
            gosub vgapalett
        case "p","P"
            brush=brush+k
        case "o","O"
            brush=brush-k
            if brush<1 then brush=1
        case "8"
            decr Att%
            if Att%=-1 then Att%=15
        case "2"
            incr Att%
            if Att%=16 then Att%=0
        case "4"
            decr Col%
            if Col%=-1 then Col%=63
            gosub setcolor
        case "6"
            incr Col%
            if Col%=64 then Col%=0
            gosub setcolor
	case "d","D"
	    gosub defaultcol
	    for i%=0 to 15
	        locate 11+i%,67:print using "##";spectrum%(i%)
	    next i%
	case chr$(13)
	    exit loop
	case "c","C"
	    locate 5+csl%,80:print " "
	    cvar=1:svar=0:lvar=0:csl%=0
	    locate 5+csl%,80:print "<"
	case "s","S"
	    locate 5+csl%,80:print " "
            cvar=0:svar=1:lvar=0:csl%=1
            locate 5+csl%,80:print "<"
	case "l","L"
  	    locate 5+csl%,80:print " "
	    cvar=0:svar=0:lvar=1:csl%=2
	    locate 5+csl%,80:print "<"
	case "a","A"
            locate 5+csl%,80:print " "
	    call autopalett (auto%)
	    locate 5+csl%,80:print "<"
	case "e","E"
	    g1%=2:call absolute gmouse(g1%,g2%,g3%,g4%)
	    line (0,0)-(479,479),att%,bf
	    g1%=1:call absolute gmouse(g1%,g2%,g3%,g4%)
    end select
    locate 5+csl%,80:print "<"
    locate 11+Att%,80:print "<";
    locate 4,62:print spc(19)
    locate 4,62
    if k=-1 then print "decr(-)"
    if k=1 then print  "incr(+)"
    locate 5,62:print using "C=color hue:  #.##";c(att%)
    locate 6,62:print using "S=saturation: #.##";s(att%)
    locate 7,62:print using "L=luminans:   #.##";l(att%)
    g1%=1:call absolute gmouse(g1%,g2%,g3%,g4%)
loop
g1%=2:call absolute gmouse(g1%,g2%,g3%,g4%)
line (480,16)-(639,479),0,bf
g1%=1:call absolute gmouse(g1%,g2%,g3%,g4%)
return

vgapalett:
    if c(att%)>3 then c(att%)=c(att%)-3
    if c(att%)<0 then c(att%)=c(att%)+3
    if s(att%)<0 then s(att%)=0
    if s(att%)>1 then s(att%)=1
    if l(att%)<0 then l(att%)=0
    if l(att%)>1.2 then l(att%)=1.2
    colreg%=spectrum%(att%)
    c=c(att%):s=s(att%):l=l(att%)
    call setcol (c,s,l,colreg%)
return

setcolor:
    spectrum%(Att%)=col%
    palette Att%,col%
    locate 11+Att%,67:print using "##";col%
return

sub copypicture (xins%,yins%,scale%,xcursor%,ycursor%,bx%,by%)
    local x%,y%,xcopy%,ycopy%,col%,xleft%,yleft%,xright%,yright%
    shared Heig%,Wid%,column%
    ycopy%=yins%
    for y%=0 to Heig%-scale% step scale%
        xcopy%=xins%
        for x%=0 to Wid%-scale% step scale%
            col%=point (x%,y%)
	    call plot (column%,xcopy%,ycopy%,col%)
            incr xcopy%
        next x%	
        incr ycopy%
    next y%
    line (xins%,yins%)-(xcopy%-1,ycopy%-1),15,b
    xleft%=xins%+xcursor%/scale%
    yleft%=yins%+ycursor%/scale%
    xright%=xleft%+bx%/scale%
    yright%=yleft%+by%/scale%
    line (xleft%,yleft%)-(xright%,yright%),15,b
end sub

sub col (c)   		'Frgvalr mellan  0 och 3
    shared r,g,b,pif
    while c<0
        c=c+3
    wend
    while c>3
        c=c-3
    wend
    r=0:g=0:b=0
    if c<0.5 then
        r= sqr(1-(c+0.5)*(c+0.5))
        b= sqr(1-(c-0.5)*(c-0.5))
        exit sub
    end if
    if c<1.5 then
        b= sqr(1-(c-0.5)*(c-0.5))
        g= sqr(1-(c-1.5)*(c-1.5))
        exit sub
    end if
    if c<2.5 then
        r=sqr(1-(c-2.5)*(c-2.5))
        g=sqr(1-(c-1.5)*(c-1.5))
        exit sub
    end if
        r= sqr(1-(c-2.5)*(c-2.5))
        b= sqr(1-(c-3.5)*(c-3.5))
end sub

sub sat (s)		'Mttnad 0-1
    shared r,g,b
    if s<0 then s=0
    if s>=0.999 then exit sub
    amp=sqr(r*r+g*g+b*b)
    r=s*r:g=s*g:b=s*b
    add=1-s
    r=r+add:g=g+add:b=b+add
    newamp=sqr(r*r+g*g+b*b)
    k=amp/newamp
    r=r*k:g=g*k:b=b*k
end sub

sub lum (l)		'Ljusstyrka 0-1 (vissa frger >1)
    shared r,g,b,lnew
    if l=1 then exit sub
    if l<0 then l=0
    rtemp=l*r:if rtemp>1 then l=l/rtemp
    gtemp=l*g:if gtemp>1 then l=l/gtemp
    btemp=l*b:if btemp>1 then l=l/btemp
    r=l*r:g=l*g:b=l*b
    lnew=l
end sub

sub colreg (colreg%)   	'register 0-63
    shared r,g,b
    if colreg%<0 then colreg%=0
    if colreg%>63 then colreg%=63
    out &h3C8,colreg%
    out &h3C9,63*r
    out &h3C9,63*g
    out &h3C9,63*b
end sub

sub autopalett (auto%)
    shared r,g,b,colreg%,c(),s(),l()
    f1=5:f2=11:f3=9
    dt=0.017
    k=0.1
    kvar=1
    dtt=k*dt
    tt1=rnd:tt2=rnd:tt3=rnd
    locate 4,62:print spc(19)
    locate 5,62:print spc(19)
    locate 6,62:print spc(19)
    locate 7,62:print "<SPACE>=pause/step"
    do
        locate 4,62
        if kvar=-1 then print "decr(-)"
        if kvar=1 then print  "incr(+)"
        if auto%=0 then
            while not instat
            wend
        end if
        if auto%=-1 then delay 0.2
        a$=inkey$
        select case a$
            case "+"
                dtt=k*dt:kvar=1
            case "-"
                dtt=-k*dt:kvar=-1
            case chr$(13)
                exit loop
            case " "
                auto%=0
            case "a","A"
                auto%=-1
        end select
        tt1=tt1+dtt:tt2=tt2+dtt:tt3=tt3+dtt
        t1=tt1:t2=tt2:t3=tt3
        for i%=1 to 13
            c(i%)=1.5+1.5*sin(f1*t1)+sin(f3*t3)
            s(i%)=0.7+0.3*sin(f2*t2)
            l(i%)=0.9+0.1*sin(f3*t3)
            call setcol (c(i%),s(i%),l(i%),i%)
            t1=t1+dt
            t2=t2+dt
            t3=t3+dt
         next i%
    loop
end sub

sub setcol (col,sat,lum,colreg%)
    call col(col)
    call sat(sat)
    call lum(lum)
    call colreg(colreg%)
end sub

sub savepic (x%,y%,wid%,heig%)
    'Frgattribut 0-14 kan sparas
    shared column%
    for j%=0 to heig%-1
        if (j% mod 10)=0 then
            locate 5,62:print using "Saving line: ###   ";j%
        end if
        pic$=""
        pcol%=-1
        ne%=0
        for i%=0 to wid%-2 step 2
	    call rpix (column%,x%+i%,y%+j%,cH%)
            call rpix (column%,x%+i%+1,y%+j%,cL%)
            if cL%=15 then cL%=14
            if cH%=15 then cH%=14
            cod%=16*cH%+cL%
            if cH%=pcol% and cL%=pcol% then
                incr ne%
                cod1%=cod%
            else
                if ne%=1 then pic$=pic$+chr$(cod1%)
                if ne%>1 then pic$=pic$+chr$(255)+chr$(ne%)
                pic$=pic$+chr$(cod%)
                pcol%=cL%
                ne%=0
            end if
        next i%
        if ne%>0 then
            if ne%=1 then pic$=pic$+chr$(cod1%)
            if ne%>1 then pic$=pic$+chr$(255)+chr$(ne%)
        end if
        put$ #1,mki$(len(pic$))
        put$ #1,pic$
    next j%
end sub

sub loadpic (x%,y%,xlim%)
    shared column%
    j%=0
    while not EOF(1)
        get$ #1,2,buf$
        nmb%=cvi(buf$)
        get$ #1,nmb%,pic$
        i%=0
        k%=1
        while k%<=nmb%
            cod%=asc(mid$(pic$,k%,1))
            if cod%<255 then
                pixL%=cod% mod 16
                pixH%=(cod%-pixL%)/16
		if x%+i%+1<xlim% then
                    call plot (column%,x%+i%,y%+j%,pixH%)
                    call plot (column%,x%+i%+1,y%+j%,pixL%)
                end if
                i%=i%+2
            else
                incr k%
                ne%=asc(mid$(pic$,k%,1))
                for m%=1 to ne%
                     if x%+i%+1<xlim% then
                         call plot (column%,x%+i%,y%+j%,pixL%)
                         call plot (column%,x%+i%+1,y%+j%,pixL%)
                     end if
                    i%=i%+2
                next m%
            end if
            incr k%
        wend
    incr j%
    wend
end sub

sub mandel inline		'Flyttalsrutin fr max n iterationer
    $inline "mandel.bin"        'Coprocessor routine
end sub

sub mustest inline		'Testar om musdrivrutinen finns
    $inline "mustest.bin"       'Tests for mouse
end sub

sub plot inline			'Skriver en pixel p skrmen
    $inline "spix.bin"		'"plot.bin"
end sub                         'Writes a pixel

sub rpix inline			'Lser frgen p en pixel
    $inline "rpix.bin"          'Reads a pixel
end sub

sub square inline		'Ritar en fylld ruta
    $inline "box.bin"           'Paints a square box
end sub

'end

