Message #1243 board "Turbo Pascal Discussion"
Date : 01-26-94  11:04
From : Stephen Braddy
To   : All
Subj : STX FILES

    This source code I wrote  is to rip STM's and STX's out of demos.
I used it to get the music out of FACTS OF LIFE. Actually, this program only
gives you the file positions of all STM/STX headers, and then you use
GRAB.EXE to get the modules out. You have to guess about where to stop
GRABBING, but as a rule of thumb, i'd say about 200k usually does it.


Program RipSTX;


Uses
  DOS, CRT;

Type
  TempSectorType = Array[0..20000] of Byte;

Var
  STXHeader   : String[8];
  FileName    : String[50];
  InFile      : File of TempSectorType;
  TempSector  : TempSectorType;
  ZeroSector  : TempSectorType;
  OneByte     : Byte;
  ByteArray   : Array[0..7] of Byte;
  Position    : LongInt;
  Match       : Boolean;
  SectorCount : LongInt;

Procedure Initialize;
Begin
  WriteLn('STMRIP | Extracts music files composed with Scream Tracker');
  WriteLn('By: Satan''S MutT 1993');
  WriteLn;
  FileName := 'C:\Temp2\life';
  Assign(InFile, FileName);
  Reset(InFile);
  For Position := 0 to 20000 do ZeroSector[Position] := 0;
  Position := 0;
  SectorCount := 0;
  Match := False;
  STXHeader := '!Scream!';
End;

Procedure FindSTX;
Var
  ByteCounter : Byte;

Begin
  {$I-}

  Repeat

    Read(InFile, TempSector);
    Write('');
    Position := 0;


  Repeat

    For ByteCounter := 0 to 7 do
        ByteArray[ByteCounter] := TempSector[Position+ByteCounter];

      If ByteArray[0] = Ord(STXHeader[1]) then
      If ByteArray[0] = Ord(STXHeader[1]) then
      If ByteArray[1] = Ord(STXHeader[2]) then
      If ByteArray[2] = Ord(STXHeader[3]) then
      If ByteArray[3] = Ord(STXHeader[4]) then
      If ByteArray[4] = Ord(STXHeader[5]) then
      If ByteArray[5] = Ord(STXHeader[6]) then
      If ByteArray[6] = Ord(STXHeader[7]) then
      If ByteArray[7] = Ord(STXHeader[8]) then Match := TRUE;

      If Match then
      Begin
        { For ByteCounter := 0 to 7 do Write(Chr(ByteArray[ByteCounter])); }
        WriteLn;
        WriteLn('Found STX header at position -> ',
SectorCount*20000+Position);
        Match := False;
      End;

    Inc(Position);

   Until Position = 20000;


    Move(ZeroSector, TempSector, 20001);

    Inc(SectorCount);

 Until EOF(InFile);

End;


Begin
  Initialize;
  FindStx;
End.



--- TMail v1.31.5
 * Origin: Diablo Valley PCUG-BBS, Walnut Creek, CA 510/943-6238 (1:161/55)
-------------------------------------------------------------------------------
