(* ******************************************************************* *)
(* disxgf.pas For Turbo Pascal - Demonstrates how to display XGF files *)
(*                               that are greater than 64K             *)
(*                                                                     *)
(* Use Raster Clip/Rastport to convert PCX files to XGF format.        *)
(*                                                                     *)
(* ******************************************************************* *)

Program disxgf;
   uses crt,graph;


{$F+}
Function DetectVGA256 : integer;
begin
    DetectVGA256:=0;
end;
{$F-}


Procedure setVGA256;
Var
 gd,gm : Integer;
begin
 gd:=InstallUserDriver('svga256',@detectvga256);
 gd:=Detect;
 Initgraph(gd,gm,'');
end;


Procedure setvga16;
var
 gd,gm : integer;
begin
 gd:=VGA;
 gm:=VGALO;

 initgraph(gd, gm, '');
end;

Procedure dis_xgf(x,y : integer; filename : string);
var
 F : File;
 width,height,bpl,i,error : word;
 scanline : array[1..1030] of word;
begin
{$I-}
 Assign(F,filename);
 Reset(F,1);
 error:=IORESULT;
 if (error=0) then
 begin
   blockread(F,width,2);
   blockread(F,height,2);
   scanline[1]:=width;
   scanline[2]:=0;
   if (getmaxcolor=255) then
   begin
     bpl:=width+1;
   end
   else
   begin
     bpl:=imagesize(0,0,width,0)-6;
   end;
   for i:=0 to (height-1) do
   begin
     blockread(F,scanline[3],bpl);
     putimage(x,y+i,Ptr(seg(scanline),ofs(scanline))^,0);
   end;
   close(F);
 end;
{$I-}
end;

begin
  setvga16;          (* replace with setvga256 for 256 color XGF files *)

  setfillstyle(solidfill,BLUE);
  bar(0,0,getmaxx,getmaxy);
  dis_xgf(0,0,'image.xgf');
  repeat until keypressed;
  closegraph;
end.
