{$G+}
{
  Prototype of Star Wars-like scroller.
  Coded by Mike Shirobokov(MSH) aka Mad Max / Queue Members Group.
  Freeware. 1994.
}
uses CRT;

const
  StartOffset = 30;
  Step  = 2;        { Changes speed of scrolling }
  CharWidth = 16;

var
  MaxLine: Word;
  Strings: array[0..255] of String[20];
  Font:  array[0..255,0..7] of Byte;
  Steps: array[0..199] of LongInt;

procedure SetPalette;
var
  I: Integer;
begin
  for I := StartOffset to 200 do
  begin
    Port[$3C8] := I;
    Port[$3C9] :=
Round(63/(200-StartOffset)*I-63/(200-StartOffset)*StartOffset);
    Port[$3C9] := 0;
    Port[$3C9] := 0;
  end;
end;

procedure GetFont; assembler;
  asm
    push ds
    mov ax,1130h
    mov bh,3
    int 10h
    mov si,bp
    mov ax,ds
    push es
    pop ds
    mov es,ax
    mov di,offset Font
    cld
    mov cx,1024
    rep movsw
    pop ds
  end;

{$I-}
function ReadFile( Name: String ): Boolean;
var
  F: Text;
  S: String;
begin
  Assign( F, Name );
  Reset(F);
  if IOResult <> 0 then
  begin
    ReadFile := False;
    Exit;
  end;
  for MaxLine := 0 to 255 do
  begin
    if Eof(F) then Exit;
    ReadLn( F, S );
    Strings[MaxLine] := Copy( S, 0, 20 );
  end;
  ReadFile := True;
end;

var
  PixLine: Word;

procedure DrawPixLine( N: Integer );
var
  StartOfs,
  RealLen,
  LineLen: Word;
  P:  ^Char;
  Step:  LongInt;
begin
  LineLen := Word(Length(Strings[PixLine shr 4])) * CharWidth * N div 200;
  RealLen := Length(Strings[PixLine shr 4])*8;
  StartOfs := 320*N div 200;
  P := @Strings[PixLine shr 4][1];
  Step := Steps[N-1];
  asm
    mov ax,$A000
    mov es,ax
    mov ax,320
    mul N
    mov di,ax
    mov cx,320
    sub cx,LineLen
    shr cx,1
    push cx
    xor al,al
    rep stosb

    mov dx,PixLine
    and dx,15
    shr dx,1
    mov dh,byte ptr N
    mov si,word ptr P
    xor ax,ax
    xor bx,bx
@str_loop:
    push ax
    push bx
    mov ch,bl
    and ch,7
    mov cl,8
    sub cl,ch
    shr bx,3
    mov bl,[si+bx]
    shl bx,3
    add bl,dl
    adc bh,0
    add bx,offset Font
    mov al,[bx]
    mov bl,1
    shl bl,cl
    test al,bl
    je @no_draw
    mov es:[di],dh
    jmp @end_draw
@no_draw:
    mov byte ptr es:[di],0
@end_draw:
    inc di
    pop bx
    pop ax
    add ax,Step.Word[0]
    adc bx,Step.Word[2]
    cmp bx,RealLen
    jbe @str_loop

    pop cx
    xor al,al
    rep stosb
  end;
end;

var
  I:  Integer;
  StartLine: Word;

begin
  if ParamCount < 1 then
  begin
    WriteLn( 'Usage : STARWAR <text file>' );
    Exit;
  end;
  if not ReadFile( ParamStr(1) ) then Exit;
  asm
    mov ax,13h
    int 10h
  end;
  SetPalette;
  GetFont;
  for I := 0 to 199 do
    Steps[I] := (100 shl 16) div (I+1);
  PixLine := 0;
  StartLine := 0;
  repeat
    PixLine := StartLine;
    for I := 50 to 200 do
    begin
      if PixLine >= (MaxLine shl 4) then PixLine := 0;
      DrawPixLine(I);
      Inc( PixLine );
    end;
    Inc( StartLine, Step );
    if StartLine >= (MaxLine shl 4) then StartLine := 0;
  until KeyPressed;
  asm
    mov ax,3h
    int 10h
  end;
end.


       C U ! Mad Max / Queue Members Group

