(* ******************************************************************** *)
(* disres.pas For Turbo Pascal - Demonstrates how to display XGF images *)
(*                               inside a resource file.                *)
(*                                                                      *)
(* Use the Rastport to create resource files.                           *)
(*                                                                      *)
(* ******************************************************************** *)

Program disres;
   uses crt,graph;


{$F+}
Function DetectVGA256 : integer;
begin
    DetectVGA256:=0;
end;
{$F-}

Procedure setVGA256;
Var
 gd,gm : Integer;
begin
 gd:=InstallUserDriver('svga256',@detectvga256);
 gd:=Detect;
 Initgraph(gd,gm,'');
end;

Procedure setvga16;
var
 gd,gm : integer;
begin
 gd:=VGA;
 gm:=VGALO;

 initgraph(gd, gm, '');
end;

Procedure res_dis_xgf(x,y : integer; filename : string; ri : integer);
var
 F            : File;
 width,height : integer;
 bpl,i,error  : integer;
 scanline     : array[1..1030] of integer;
 rt           : integer;
 rid          : array[1..12] of char;
 offset,size  : longint;

begin
{$I-}
 Assign(F,filename);
 Reset(F,1);
 error:=IORESULT;

 if (error=0) then
 begin
   seek(F,(LongInt(5)+LongInt((ri-1))*Longint(22)));

   blockread(F,rt,2);             (* resource type          *)
   blockread(F,rid,12);           (* resource id            *)
   blockread(F,offset,4);         (* resource offset        *)
   blockread(F,size,4);           (* resource size          *)

   seek(F,offset);
   blockread(F,width,2);
   blockread(F,height,2);

   scanline[1]:=width;
   scanline[2]:=0;

   if (getmaxcolor=255) then
   begin
     bpl:=width+1;
   end
   else
   begin
     bpl:=imagesize(0,0,width,0)-6;
   end;

   for i:=0 to (height-1) do
   begin
     blockread(F,scanline[3],bpl);
     putimage(x,y+i,Ptr(seg(scanline),ofs(scanline))^,0);
   end;

   close(F);
 end;
{$I-}
end;

begin
  setvga16;          (* replace with setvga256 for 256 color XGF files *)

  setfillstyle(solidfill,BLUE);
  bar(0,0,getmaxx,getmaxy);

  res_dis_xgf(0,0,'pics.res',1);
  res_dis_xgf(200,50,'pics.res',2);
  res_dis_xgf(300,100,'pics.res',3);
  res_dis_xgf(200,0,'pics.res',4);
  res_dis_xgf(400,50,'pics.res',5);
  res_dis_xgf(500,100,'pics.res',6);

  repeat until keypressed;
  closegraph;
end.
