Unit Users;
{$I Sys75.Inc}

Interface

Uses
  totdate, Dos, Spuds;

Function  LookUpUser (N: HandleStr; Var RecNum: Word): Boolean;
Function  LookUpUserNum (N: Word; Var RecNum: Word): Boolean;
Function  ReadUserRec (Var U: tUserData; Rec: Word): Boolean;
Procedure UpdateUserRec (Var U: tUserData; W: Word);
procedure initlastcall;
Procedure AddLastCall;
Procedure DefUser;
(*Function  GetNextUserRec: Word;*)
Function  GetNextUserNum: Word;
Procedure UpdateCurUserStat;
Procedure ToggleUserOpt (Option: UserOpt);
Procedure ValidateUser (Var U: tUserData);
Function  pcentLocal (ant: Boolean): Byte;
Procedure LoadSysopRec (oby: boolean; Var u: tUserData);
Procedure MakeSysopRec;
Procedure MakeUserIndex;
procedure newaccount (var u: tuserdata);
(*procedure adduserundel (var u: tuserdata);
procedure undeleteusers (h: handlestr);*)
procedure byeuser;
function  inuserlist (s: string): boolean;

Var
  stayon            : boolean;
  User              : tUserData;
  AddCaller         : Boolean;
  TmpSysop          : Boolean;
  InputTimer        : Boolean;
  SysValidated      : Boolean;
  oldtimeleft       : Word;
  CurTimeOn         : Word;
  ChatTries         : Byte;
  CurStatSet        : SetRec;
  CurMenuSet        : SetRec;
  LoginTime         : DateTimeRec;
  dlc               : LastCallRec;

Implementation

Uses
  TotStr, TotMisc,
  Comm, StatusBar, RemEmu, emu, misc, nuv, emucodes, events,
  filemenu, messages;

Function LookUpUser (N: HandleStr; Var RecNum: Word): Boolean;
Var
  F: File;
  Buf: ^tUserRecArray;
  B: LongInt;
  I: Integer;
Begin
{send (cls);{}

  LookUpUser := False;
  N := SetUpper (Strip ('B', ' ', N));
{comwriteln ('looking for: ' + n);{}
  GetMem (Buf, SizeOf (tUserRecArray));
  If Buf = Nil Then Exit;
{comwriteln ('memory is ok');{}

  if ioresult <> 0 then;
  Assign (F, Uc. DataPath + 'Users.Idx');
  {$I-}
  Reset (F, 1);
  {$IFDEF Debuf}{$I+}{$ENDIF}
  If IoResult <> 0 Then begin
    FreeMem (Buf, SizeOf (tUserRecArray));
    Exit;
  end;
{comwriteln ('opened user index ok');{}

  Repeat
    BlockRead (F, Buf^, SizeOf (Buf^), I);
    For B := 0 To pred (I Div SizeOf (tUserRec)) Do Begin
{comwriteln ('found user: ' + SetUpper (Buf^ [B]. Handle));{}
      If N = SetUpper (Buf^ [B]. Handle) Then Begin
        RecNum := Buf^ [B]. RecNum;
        LookUpUser := True;
        FreeMem (Buf, SizeOf (tUserRecArray));
        Close (F);
{comwriteln ('we found the user we were looking for!');{}
{pressenter;{}
        Exit;
      End;
    End;
  Until I <> SizeOf (tUserRecArray);

  FreeMem (Buf, SizeOf (tUserRecArray));
  Close (F);

{comwriteln ('we did n0t find the user we were looking for?');{}
{pressenter;{}
End;

Function LookUpUserNum (N: Word; Var RecNum: Word): Boolean;
Var
  F: File;
  Buf: ^tUserRecArray;
  B: LongInt;
  I: Integer;
Begin
  LookUpUserNum := False;
  GetMem (Buf, SizeOf (tUserRecArray));
  If Buf = Nil Then Exit;

  if ioresult <> 0 then;
  Assign (F, Uc. DataPath + 'Users.Idx');
  {$I-}
  Reset (F, 1);
  {$IFDEF Debuf}{$I+}{$ENDIF}
  If IoResult <> 0 Then Exit;

  Repeat
    BlockRead (F, Buf^, SizeOf (Buf^), I);
    For B := 0 To pred (I Div SizeOf (tUserRec)) Do Begin
      If N = Buf^ [B]. UserNum Then Begin
        RecNum := Buf^ [B]. RecNum;
        LookUpUserNum := True;
        FreeMem (Buf, SizeOf (tUserRecArray));
        Close (F);
        Exit;
      End;
    End;
  Until I <> SizeOf (tUserRecArray);

  FreeMem (Buf, SizeOf (tUserRecArray));
  Close (F);
End;

Function ReadUserRec (Var U: tUserData; Rec: Word): Boolean;
Var
  T: File of tUserData;
Begin
  ReadUserRec := False;
  If Rec = 0 Then Exit;

  Assign (T, Uc. DataPath + 'Users.Dat');
  {$I-}
  Reset (T);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IoResult <> 0 Then Exit;

  If Rec <= FileSize (T) Then Begin
    Seek (T, Pred (Rec));
    Read (T, U);
    ReadUserRec := True;
  End;
  Close (T);
End;

Procedure UpdateUserRec (Var U: tUserData; W: Word);
Var
  R: File of tUserRec;
  D: File of tUserData;
  u2: tuserdata;
  b: word;
  okd: tUserRec;
Begin
  if w = 0 then exit;
  Assign (d, Uc. DataPath + 'USERS.DAT');
  {$I-}
  reset (d);
  if ioresult = 2 then rewrite (d);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then exit;

  fillchar (u2, sizeof (tuserdata), 0);

  dec (w);

  if w > filesize (d) then for b := 1 to w - filesize (d) do
    write (d, u2);

  Seek (d, w);
  Write (d, U);
  Close (d);

  Assign (r, Uc. DataPath + 'USERS.IDX');
  {$I-}
  reset (r);
  if ioresult = 2 then rewrite (r);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then exit;

  fillchar (okd, sizeof (tuserrec), 0);

  if w > filesize (r) then for B := 1 to w - filesize (r) do
    write (r, okd);

  With okd do Begin
    Handle := Strip ('B', ' ', U. Handle);
    RecNum := succ (W);
    UserNum := succ (W);
  End;

  Seek (r, W);
  Write (r, okd);
  Close (r);
End;

procedure initlastcall;
begin
  With User do Begin
    dlc. caller := handle;
    dlc. node := nodenumber;
    dlc. ac := copy (ph, 1, 3);
    dlc. tcalls := totcalls;
    dlc. datetime := logintime;
    dlc. baud := BaudRate;
  End;
end;

Procedure AddLastCall;
Var
  F: File;
Begin
  Assign (F, Uc. DataPath + 'LastCall.Dat');
  {$I-}
  Reset (F, 1);
  If IoResult = 2 Then ReWrite (F, 1);
  If IoResult <> 0 Then Exit;
  {$IFDEF Debug}{$I+}{$ENDIF}
  If (Uc. MaxCallsInLog <> 0) and (FileSize (F) Div Sizeof (dlc) = Uc. MaxCallsInLog) Then
    RemoveRec (F, 0, Sizeof (dLc));
  Seek (F, FileSize (F));
  dlc. minon := curtimeon;
  BlockWrite (F, dlc, Sizeof (dlc));
  Close (F);
End;

Procedure DefUser;
Begin
  FillChar (User, Sizeof (User), 0);
  with user do begin
    timelimit := 10;
    timeleft := 10;
    options := [litebars, fseditor, male, pause];
    Cols := Uc. Colors;
    PageLen := 24;
    defarctype := 1;
    menuprom := 1;
    statset := 1;
    menuset := 1;
    reclevel := 1;
  end;
End;
(*
Function GetNextUserRec: Word;
Var
  F: File;
  Buf: ^tUserRecArray;
  Lui, B: LongInt;
  I: Integer;
Begin
  getnextuserrec := 1;

  Assign (F, Uc. DataPath + 'Users.Idx');
  {$I-}
  Reset (F, 1);
  {$IFDEF Debuf}{$I+}{$ENDIF}
  If IoResult <> 0 Then exit;

  if filesize (f) = 0 then begin
    close (f);
    exit;
  end;

  GetMem (Buf, SizeOf (tUserRecArray));
  If Buf = Nil Then Exit;

  lui := 0;
  Repeat
    BlockRead (F, Buf^, SizeOf (Buf^), I);
    For B := 0 To pred (I Div SizeOf (tUserRec)) Do Begin
      Inc (Lui);
      If Buf^ [B]. handle = '' then Break;
    End;
    If Buf^ [B]. handle = '' then Break;
  Until I <> SizeOf (tUserRecArray);

  If Buf^ [B]. handle <> '' Then Inc (Lui);

  FreeMem (Buf, SizeOf (tUserRecArray));
  Close (F);

  GetNextUserRec := Lui;
End;
*)
Function GetNextUserNum: Word;
Var
  F: File;
  Buf: ^tUserRecArray;
  Cnt, B: LongInt;
  I: Integer;
  label
    done;
Begin
  getnextusernum := 1;

  Assign (F, Uc. DataPath + 'Users.Idx');
  {$I-}
  Reset (F, 1);
  {$IFDEF Debuf}{$I+}{$ENDIF}
  If IoResult <> 0 Then exit;

  if filesize (f) = 0 then begin
    close (f);
    exit;
  end;

  GetMem (Buf, SizeOf (tUserRecArray));
  If Buf = Nil Then Exit;

  Cnt := 1;
  Repeat
    BlockRead (F, Buf^, SizeOf (Buf^), I);
    For B := 0 To pred (I Div SizeOf (tUserRec)) Do Begin
      with buf^ [b] do
        if handle = '' then begin
          cnt := usernum;
          goto done;
        end else
          if cnt = usernum then inc (cnt);
    End;
  Until I <> SizeOf (tUserRecArray);

  done:
  FreeMem (Buf, SizeOf (tUserRecArray));
  Close (F);

  GetNextUserNum := Cnt;
End;

Procedure UpdateCurUserStat;
Var
  n: datetimerec;
  zebra: word;
  Q: LongInt;
  F: File of SetRec;
Begin
  Now (N);

  With User do Begin
    logintime := n;
    if firston = 0 then firston := logintime. d;

    If N. d <> LastOn. d Then Begin
      TimeLeft := TimeLimit;
      CallsToday := 0;
    End;

    curtimeon := 0;
    oldtimeleft := timeleft;
    zebra := event^. GetNextStrict;
    if (timeleft > zebra) and (zebra <> 0) then timeleft := zebra;

    if online then begin
      Inc (TotCalls);
      Inc (CallsToday);
    end;

    If Not Exist (Uc. DispPath + 'MenuProm.' + IntToStr (MenuProm)) Then
      MenuProm := 1;

    Assign (F, Uc. DataPath + 'MenuSet.Dat');
    Reset (F);
    If IoResult = 0 Then Begin
      if menuset > filesize (f) then menuset := 1 else if menuset = 0 then menuset := 1;
      seek (f, pred (menuset));
      read (f, curmenuset);
      close (f);
    End Else FillChar (CurMenuSet, Sizeof (CurMenuSet), 0);

    Assign (F, Uc. DataPath + 'StatSet.Dat');
    Reset (F);
    If IoResult = 0 Then Begin
      if statset > filesize (f) then statset := 1 else if statset = 0 then statset := 1;
      seek (f, pred (statset));
      read (f, curstatset);
      close (f);
    End Else FillChar (CurStatSet, Sizeof (CurStatSet), 0);
  End;

  initlastcall;
  With LastCaller do Begin
    Name := User. Handle;
    DateTime := LoginTime;
  End;

  with user do begin
    if lastmconf = 0 then inc (lastmconf);
    if lastfconf = 0 then inc (lastfconf);
    if lastarea  = 0 then inc (lastarea);
    if lastbase  = 0 then inc (lastbase);
    curmconf := lastmconf;
    curfconf := lastfconf;
    goarea (lastarea, false);
    gobase (lastbase, false);

    if not reliablepagelen then curpagelen := user. pagelen;
  end;
End;

Procedure ToggleUserOpt (Option: UserOpt);
Begin
  With User do Begin
    If Option In Options Then
      Options := Options - [Option]
    Else
      Options := Options + [Option];
  End;
End;

Procedure ValidateUser (Var U: tUserData);
var
  w: word;
begin
  with u do begin
    timelimit := uc. defuser. timelimit;
    timeleft := uc. defuser. timelimit;

    pcr := uc. defuser. pcr;
    udratio := uc. defuser. udratio;
    udkratio := uc. defuser. udkratio;
    maxdlkperday := uc. defuser. maxdlkperday;

    fp := uc. defuser. fp;
    maxtimesonaday := uc. defuser. maxtimesonaday;
    sl := uc. defuser. sl;
    dsl := uc. defuser. dsl;
    credit := uc. defuser. credit;
    debt := uc. defuser. debt;
    expiration := uc. defuser. expiration;
    expiretosl := uc. defuser. expiretosl;
    expiretodsl := uc. defuser. expiretodsl;

    if sysnote = 'Unvalidated' then
      sysnote := 'Validated ' + currentdate (true);

    nuvweight := 1;
    reclevel := 1;

    if innuv (handle, w) then remnuv (w);
  end;
  updateuserrec (u, u. recnum);
end;

Function pcentLocal (ant: Boolean): Byte;
Var
  u: ^tUserData;
  f: file of tuserdata;
  locals: word;
Begin
  pcentlocal := 0;
  locals := 0;
  assign (f, uc. datapath + 'Users.Dat');
  {$I-}
  reset (f);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then exit;

  getmem (u, sizeof (tuserdata));

  while not eof (f) do begin
    read (f, u^);
    with u^ do
      if (handle <> '') and (handle <> uc. sysopname)
      and (pos (copy (ph, 1, 3), uc. localcodes) <> 0) then
        inc (locals);
  end;

  close (f);
  freemem (u, sizeof (tuserdata));

  if ant then
    pcentlocal := round (succ (locals) / succ (totals. tusers) * 100.0)
  else
    pcentlocal := round (locals / totals. tusers * 100.0);
End;

Procedure LoadSysopRec (oby: boolean; Var u: tUserData);
Var
  Rec: Word;
  F: File;
Begin
  If Not LookUpUser (Uc. SysopName, Rec) Then Begin
    if oby then ComWrite ('|08adding sysop record to user database');
    MakeSysopRec;
    ReadUserRec (u, 1);
    if oby then comwriteln ('');
  End Else Begin
    If Rec <> 1 Then Begin
      if oby then ComWrite ('|08moving sysop record');
      ReadUserRec (u, Rec);
      Assign (F, Uc. DataPath + 'Users.Dat');
      Reset (F, 1);
      RemoveRec (F, Pred (Rec), Sizeof (tUserData));
      Close (F);
      Assign (F, Uc. DataPath + 'Users.Idx');
      Reset (F, 1);
      RemoveRec (F, Pred (Rec), Sizeof (tUserRec));
      Close (F);
      MakeSysopRec;
      UpdateUserRec (u, 1);
      if oby then comwriteln ('');
    End Else ReadUserRec (u, 1);
  End;
End;

Procedure MakeSysopRec;
Var
  f: File;
  tu: tUserData;
  tr: tUserRec;
  n: datetimerec;
Begin
  Totals. tUsers := 1;

  now (n);
  FillChar (tu, sizeof (tu), 0);
  FillChar (tr, sizeof (tr), 0);

  with tu do begin
    RecNum := 1;
    UserNum := 1;
    Handle := Uc. SysopName;
    Name := 'System Operator';
    pw := 'Sysop';
    ph := '800-555-1212';
    reclevel := 2;
    usrnote := 'Da SysGOD';
    occupation := 'So you know who they give me,';
    reference := 'the Dali Llama himself.';
    sysnote := 'System/75 Rules The Planet!!!';
    options := [timelock, litebars, fseditor, privateqwk, male, hotkeys, pause];
    Flags := flagset;

    timelimit := 1440;
    timeleft := 1440;

    fp := 999999;

    pagelen := 24;
    lastmconf := 1;
    lastfconf := 1;
    lastarea := 1;
    lastbase := 1;
    sl := 255;
    dsl := 255;
    nuvweight := 1;

    cols := Uc. colors;

    passwordchanged := n. d - succ (uc. passwordchange);
    lastcolorchange := n. d;
    defarctype := 1;
    defprot := 1;

    FileList := [fl_size, fl_points, fl_desc, fl_scroll];

    expiretosl := 255;
    expiretodsl := 255;

    menuprom := 1;
    statset := 1;
    menuset := 1;
  end;

  with tr do begin
    Handle := Uc. SysopName;
    UserNum := 1;
    RecNum := 1;
  end;

  Assign (f, Uc. DataPath + 'Users.Dat');
  {$I-}
  Reset (f, 1);
  If IoResult = 2 Then Rewrite (f, 1);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IoResult <> 0 Then Exit;
  insertrec (f, 0, sizeof (tUserData));
  Seek (f, 0);
  BlockWrite (f, tu, sizeof (tu));
  Close (f);

  Assign (f, Uc. DataPath + 'Users.Idx');
  {$I-}
  Reset (f, 1);
  If IoResult = 2 Then Rewrite (f, 1);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IoResult <> 0 Then Exit;
  insertrec (f, 0, sizeof (tUserRec));
  Seek (f, 0);
  BlockWrite (f, tr, sizeof (tr));
  Close (f);
End;

Procedure MakeUserIndex;
Var
  rf: File of tUserRec;
  df: File of tUserData;
  tu: tUserData;
  tr: tUserRec;
Begin
  Assign (rf, uc. datapath + 'users.idx');
  rewrite (rf);
  Assign (df, uc. datapath + 'users.dat');
  rewrite (df);
End;

procedure newaccount (var u: tuserdata);
var
  b: byte;
  n: datetimerec;
begin
  now (n);
  with u do begin
    cols := uc. colors;
    options := options + [litebars, fseditor];
    pagelen := 24;
    for b := 1 to 5 do
      infoforms [b] := 0;
    usrnote := 'New User';
    sysnote := 'Unvalidated';
    FileList := [fl_size, fl_points, fl_desc, fl_scroll];
    laston := n;
    firston := n. d;
    passwordchanged := n. d;
    lastcolorchange := n. d;
    menuset := 1;
    statset := 1;
    menuprom := 1;
  end;
end;

(*procedure adduserundel (var u: tuserdata);
var
  f: file of tuserdata;
  qzap: ^tuserdata;
  bpx: handlestr;
begin
  assign (f, uc. datapath + 'users.del');
  {$I-}
  reset (f);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult = 2 then rewrite (f);
  getmem (qzap, sizeof (tuserdata));
  bpx := setupper (u. handle);
  while not eof (f) do begin
    read (f, qzap^);
    if (qzap^. handle = '') or (setupper (qzap^. handle) = bpx) then begin
      seek (f, pred (filepos (f)));
      break;
    end;
  end;
  write (f, u);
  close (f);
  freemem (qzap, sizeof (tuserdata));
end;

procedure undeleteusers (h: handlestr);
var
  f: file of tuserdata;
  z: file;
  tur, qzap: ^tuserdata;
  rec: word;
  Act: byte;
const
  header = '%CR|UI Handle                              |UP:|UI Deleted by%CR';
  skank = '|USNo users to undelete.';
begin
  assign (f, uc. datapath + 'users.del');
  {$I-}
  reset (f);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult = 2 then begin
    comwriteln (skank);
    exit;
  end;
  if filesize (f) = 0 then begin
    close (f);
    comwriteln (skank);
    exit;
  end;

  ComWrite (Cls);
  FillIn1 := 'Undeleting users';
  pFile ('hdr.ans');
  comwriteln ('');

  getmem (qzap, sizeof (tuserdata));
  h := strip ('B', ' ', h);

  repeat
    If h = '' Then Begin
      ComWrite ('|UR%CR|URUndelete which user |UP(|USCr|UP/|USQuit|UP, |US?|UP/|USList|UP):|UI ');
      GetStr (30, False, false, h);
      h := Strip ('B', ' ', h);
    End;

    if hung then break;
    comwriteln ('');

    if h = '' then begin
      close (f);
      freemem (qzap, sizeof (tuserdata));
      comwriteln ('');
      exit;
    end else if h = '?' then begin
      seek (f, 0);
      act := 0;
      comwriteln (header);
      while not eof (f) do begin
        read (f, qzap^);
        inc (act);
        with qzap^ do
          send (attr (user. cols [1]) + ' ' + padleft (handle, 36, ' ') + attr (user. cols [2]) + ' ' + sysnote + ^M^J);
        if act = curpagelen - 3 then begin
          if more (false) = mno then break;
          act := 0;
          comwriteln (header);
        end;
      end;
      h := '';
    end else break;
  until hung;

  comwriteln ('');
  seek (f, 0);
  while not eof (f) do begin
    read (f, qzap^);
    if setupper (qzap^. handle) = setupper (h) then begin
      seek (f, pred (filepos (f)));
      break;
    end;
  end;

  if setupper (qzap^. handle) <> setupper (h) then begin
    comwriteln ('|USCould not find ' + h + '.');
    close (f);
    freemem (qzap, sizeof (tuserdata));
    exit;
  end;

  If LookUpUser (h, Rec) Then Begin
    Send (GoXy (40, _y) + attr (User. Cols [6]) + h + attr (User. Cols [1]) + ' is already in the user data file.');
    comwrite ('Relpace existing information ');
    if litebar (lbNo, false, true) = lbyes then begin
      qzap^. recnum := Rec;
      getmem (tur, sizeof (tuserdata));
      readuserrec (tur^, user. recnum);
      qzap^. usernum := tur^. usernum;
      freemem (tur, sizeof (tuserdata));
      updateuserrec (qzap^, rec);
    end;
  End else begin
    qzap^. recnum := getnextuserrec;
    qzap^. usernum := getnextusernum;
    updateuserrec (qzap^, qzap^. recnum);
  end;

  comwriteln (^M^J'|URSuccessfully undeleted user ' + h + '.');

  rec := filepos (f);
  close (f);
  freemem (qzap, sizeof (tuserdata));

  assign (z, uc. datapath + 'users.del');
  reset (z, 1);
  removerec (z, rec, sizeof (tuserdata));
  close (z);

  inc (totals. tusers);
end;
*)
function inuserlist (s: string): boolean;
var
  b: byte;
begin
  if s = '' then begin
    inuserlist := true;
    exit;
  end else inuserlist := false;
  while s <> '' do begin
    delete (s, 1, 1);
    b := pos ('U', s);
    if b = 0 then
      b := length (s)
    else
      dec (b);
    if strtoint (copy (s, 1, b)) = user. usernum then begin
      inuserlist := true;
      exit;
    end;
    delete (s, 1, b);
  end;
end;

procedure byeuser;
var
  F: File of LastCallNodeRec;
  w: word;
  t: text;
  ba: batchrec;
Begin
  with user do begin
    LastOn := LoginTime;
    lastmconf := curmconf;
    lastfconf := curfconf;
    lastarea := curarea;
    lastbase := curbase;
    UpdateUserRec (User, RecNum);
  end;

  Assign (F, NodeData. NodePath + 'LastCall.Dat');
  {$I-}
  Rewrite (F);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IoResult = 0 Then Begin
    Write (F, LastCaller);
    Close (F);
  End;

  if curtimeon <= oldtimeleft then
    user. timeleft := oldtimeleft - curtimeon
  else
    user. timeleft := 0;

  If AddCaller Then Begin
    AddLastCall;
    Inc (Totals. tCalls);
    Inc (DailyLog. Calls);
  End;

  if vbatch^. totalnodes <> 0 then with vbatch^ do begin
    assign (t, uc. datapath + 'usr' + inttostr (user. usernum) + '.bch');
    rewrite (t);
    jump (1);
    for w := 1 to vbatch^. totalnodes do begin
      get (ba);
      advance (1);
      with ba do
        writeln (t, inttostr (conf) + ' ' + inttostr (area) + ' ' + flname);
    end;
    close (t);
  end;
End;

End.
