Unit TopTen;
{$I Sys75.Inc}

Interface

Uses
  Spuds;

Procedure rTopTen (C: Char; P: Str100);
Procedure ShowLastCallers (Num: Byte);

Implementation

Uses
  TotStr, TotDate, totmisc, dos,
  RemEmu, Menus, Misc, Users;

Var
  lcParsed: Boolean;
  B: Byte;
  Date, Time: String [9];
  L: LastCallRec;

Procedure ParseLastCall (C: Char);
var
  s: string;
Begin
  if lcparsed then begin
    Case C of
      '#': s := IntToStr (B);
      'H': s := L. Caller;
      'N': s := IntToStr (L. Node);
      'A': s := L. ac;
      'C': s := IntToStr (L. tcalls);
      'T': s := Copy (Time, 1, 5);
      'D': s := Copy (Date, 1, 5);
      'M': s := IntToStr (L. MinOn);
      'B': If L. Baud <> 0 Then
             s := IntToStr (L. Baud)
           Else
             s := 'Local';
      Else s := '@' + C;
    End;
    comwrite (padd (s));
    lcparsed := false;
  End else if c = '@' then lcparsed := true else comwritech (c);
End;

Procedure ShowLastCallers (Num: Byte);
Var
  F: File of LastCallRec;
  Path: DirStr;
Begin
  If Exist (CurStatSet. Path + 'LastCall.*') Then
    Path := CurStatSet. Path
  Else
    Path := Uc. DispPath;

  Assign (F, Uc. DataPath + 'LastCall.Dat');
  {$I-}
  Reset (F);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IoResult <> 0 Then Exit;

  ShowFile (Path + 'LastCall.Top', False, True);

  If Num > Uc. MaxCallsInLog Then
    Num := Uc. MaxCallsInLog;

  If Num > FileSize (F) Then
    Num := FileSize (F);

  Seek (F, FileSize (F) - Num);
  lcParsed := false;

  For B := 1 to Num do Begin
    if inputbroke then break;
    {$I-}
    Read (F, L);
    {$IFDEF Debug}{$I+}{$ENDIF}
    If IoResult <> 0 Then Begin
      Close (F);
      Exit;
    End;
    GetDateTimeStr (L. DateTime, Date, Time);
    ShowFileProc (Path + 'LastCall.Mid', ParseLastCall);
  End;
  Close (F);

  if inputbroke then
    comwriteln ('|UR' + ^M^J)
  else
    ShowFile (Path + 'LastCall.Bot', False, True);
End;

Procedure rTopTen (C: Char; P: Str100);
Begin
  Case C of
    'A': Unsupported;
    'B': Unsupported;
    'C': Unsupported;
    'D': Unsupported;
    'E': Unsupported;
    'F': Unsupported;
    'G': Unsupported;
    'H': Unsupported;
    'I': Unsupported;
    'J': Unsupported;
    'K': Unsupported;
    'L': Unsupported;
    'M': Unsupported;
    'N': Unsupported;
    Else rError ('R' + C);
  End;
End;

End.
