Unit OverInit;
{$I Sys75.Inc}
{$O-,D-,I-,L-,Q-,R-,S-}

Interface

Implementation

Uses
  Overlay, {$IFDEF XMS} OverXms, {$ENDIF} Dos, Crt,
  Spuds, TotStr, TotDate, TotFast, ApMisc, opxms;

Const
  Block = '|08[|07|08]';

Var
  SaveExit: Pointer;

Procedure ExitProcSys75; Far;
Var
  F: Text;
  S: String [60];
Begin
  ExitProc := SaveExit;

  If (ExitCode <> 0) And (ExitCode <> ForceExit) Then Begin
    Assign (F, NodeData. NodePath + 'Node_Is.Up');
    {$I-}
    SetFAttr (F, Archive);
    Erase (F);
    {$IFDEF Debug} {$I+} {$ENDIF}
    If IoResult <> 0 Then ;

    if scrbackinst then FreeExtMem (XmsHandle);

    Crt. NoSound;
    Crt. TextMode (Co80);

    If (ExitCode = 208) Or (ExitCode = 209) Then Begin
      Writeln ('Overlay initialization error.');
      Writeln ('The overlays could not be located.');
      Writeln ('Contact Maxwell if you can not fix this!');
      Writeln;
      Halter (7);
    End;

    System. Writeln ('A fatal error has been encountered while System/75 was');
    System. Writeln ('running. To help correct this problem, please read the');
    System. Writeln ('DOX\BUGS.DOX file, and fill out & send the bug report.');
    System. Writeln;
    System. Writeln ('Please include this information in your report:');
    System. Writeln;
    System. Writeln (' Error number ' + IntToStr (ExitCode) + '.');
    S := StatusStr (ExitCode);
    If S <> '' Then System. Writeln (' ' + S + '.');
    System. Writeln (' The error occured at ' + HexPtr (ErrorAddr) + '.');
    System. Writeln;

    Assign (F, 'FATAL.LOG');
    {$I-}
    Append (F);
    If IOResult <> 0 Then Begin
      Rewrite (F);
      If IOResult = 0 Then Begin
        System. WriteLn (F);
        System. WriteLn (F, '                        [] System/75 Fatal Error Log []');
        System. WriteLn (F, '                      ');
        System. WriteLn (F);
      End;
    End;

    If IOResult = 0 Then Begin
      System. Writeln (F, ' Error number ' + IntToStr (ExitCode) + '.');
      S := StatusStr (ExitCode);
      If S <> '' Then System. Writeln (F, ' ' + S + '.');
      System. Writeln (F, ' The error occured at address ' + HexPtr (ErrorAddr) + ', on ' + CurrentDate (True) + ' at ' +
                       CurrentTime (True) + '.');
      System. Writeln (F);
      Close (F);
    End;

    If ExitCode <> 8 Then ExitCode := 6;
    ErrorAddr := Nil;
  End;
End;

Procedure InitMain;
Begin
  SaveExit := ExitProc;
  ExitProc := @ExitProcSys75;

  If InstallHook Then Exit;

  Screen^. PartClear (1, Crt. WhereY, 80, 25, 8 , ' ');
  Screen^. WriteLn (^M + Block + ' |08S|07y|15stem|08/|077|155 |07|08S |08S|07o|15ftware ' + Block);

  New (DosSav, Init);
  If DosSav = Nil Then Exit;
  DosSav^. Save;

  Screen^. WriteLn ('|08    v' + Version + ', ' + VersionDate + ' ');
  Screen^. WriteLn ('   |07B|08rought |07t|08o |07y|08ou |07b|08y |08m|15i|08st |08  ');
  Screen^. WriteLn ('');
End;

Procedure InitOvr;
Begin
  OvrInit ('Sys75.Ovr');
  If OvrResult <> 0 Then Halter (208);

{$IFDEF XMS}
  OvrInitXMS;

  If OvrResult <> 0 Then Begin
{$ENDIF}
    OvrInitEMS;
    If Not InstallHook Then
      If OvrResult <> 0 Then
        Screen^. WriteLn ('|08overlays in conventional memory')
      Else
        Screen^. WriteLn ('|08overlays loaded to ems');
{$IFDEF XMS}
  End Else If Not InstallHook Then
    Screen^. WriteLn ('|08overlays loaded to xms');
{$ENDIF}
End;

Begin
  If ParamStr (1) = WiggedOutTrippinMotherFucker Then
    InstallHook := True
  Else
    InstallHook := False;
  InitMain;
  InitOvr;
End.
