Unit Nuv;
{$I Sys75.Inc}

Interface

Uses
  totdate, Spuds;

Procedure rNuv (C: Char; P: Str100);
function  AddUserToNuv (U: HandleStr): boolean;
Procedure RunNuv;
Procedure NewScanNuv (P: Str100);
Function  InNuv (Handle: HandleStr; Var Rec: Word): Boolean;
Procedure RemNuv (Rec: Word);

Type
  NuvVoteRec = Record                  { vote array record type }
                 Voter: HandleStr;     { person who voted }
                 Vote: Boolean;        { hmmm.... voted yes or no?}
                 Comment: String [30]; { user's comment }
               End;

  NuvType = Record
              Handle: HandleStr;                   { User being voted on }
              Votes: Array [1..100] of NuvVoteRec; { vote array }
              Added: datetimerec;                  { date added to nuv }
            End;

Implementation

Uses
  TotStr, totmisc, dos,
  Users, Comm, Menus, Misc, RemEmu, Infoform, Acs, BlackLst;

Var
  N: NuvType;
  Count: Word;
  Date, Time: Str8;
  tu: tUserData;
  nuvf: file;

Const
  AllowQuit: Boolean = True;
  nuvparsed: Boolean = false;

function AddUserToNuv (U: HandleStr): boolean;
Var
  R: Word;
  p: datetimerec;
Begin
  addusertonuv := false;
  now (p);
  If U = '' Then Begin
    ComWriteLn ('');
    ComWrite (Cs (68));
    GetStr (30, False, false, U);
    U := Strip ('B', ' ', U);
    ComWriteLn ('');
    If hung Or (U = '') Then Exit;
  End;

  If Not LookUpUser (U, R) Then Begin
    ComWriteLn (Cs (9));
    PressEnter;
    Exit;
  End;

  readuserrec (tu, r);
  if not sysopacs and (tu. sl >= user. sl) then Exit;

  Log (2, 'User ' + u + ' added to nuv');
  Assign (nuvf, Uc. DataPath + 'Nuv.Dat');
  {$I-}
  Reset (nuvf, 1);
  If IoResult <> 0 Then Rewrite (nuvf, 1);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IoResult <> 0 Then Exit;

  Seek (Nuvf, filesize (nuvf));

  FillChar (N, Sizeof (N), 0);
  With N do Begin
    Handle := Strip ('B', ' ', U);
    Added := p;
  End;
  blockWrite (nuvf, N, sizeof (n));
  Close (nuvf);

  FillIn1 := U;
  ReadUserRec (tu, R);
  with tu do begin
    VoteYes := 0;
    VoteNo := 0;
    sl := 0;
  End;
  UpdateUserRec (tu, R);
  addusertonuv := true;
End;

Procedure NuvList (C: Char);
var
  s: string;
Begin
  if nuvparsed then begin
    With N do Case C of
      '#': s := IntToStr (Count);
      'H': s := Handle;
      'Y': s := IntToStr (tu. VoteYes);
      'N': s := IntToStr (tu. VoteNo);
      'D': s := Date;
      'T': s := Time;
      Else s := '@' + C;
    End;
    comwrite (padd (s));
    nuvparsed := false;
  End else if c = '@' then nuvparsed := true else comwritech (c);
End;

Procedure ListInNuv (New: Boolean);
Var
  B: Byte;
  Found: Boolean;
  Path: DirStr;
  wowzers, rec: word;
Const
  Katmandu: Array [False..True] of String [8] = ('NuvList', 'NuvNew');
Begin
  If Exist (CurStatSet. Path + Katmandu [New] + '.*') Then
    Path := CurStatSet. Path
  Else
    Path := Uc. DispPath;

  Assign (nuvf, Uc. DataPath + 'Nuv.Dat');
  {$I-}
  Reset (nuvf, 1);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If (IoResult <> 0) Or (FileSize (nuvf) = 0) Then Begin
    {$I-}
    Close (nuvf);
    {$IFDEF Debug}{$I+}{$ENDIF}
    If IoResult <> 0 Then;
    ComWriteLn (^M^J + Cs (70));
    Exit;
  End;

  Found := False;

  Count := 1;
  While not eof (nuvf) do With N do Begin
    if inputbroke then break;
    blockRead (nuvf, N, sizeof (n));
    if not lookupuser (handle, rec) or not ReadUserRec (tu, Rec) then begin
      wowzers := pred (filepos (nuvf));
      close (nuvf);
      RemNuv (wowzers);
      reset (nuvf);
      seek (nuvf, wowzers);
      continue;
    end;
    If New Then For B := 1 to 100 do
      If (Votes [B]. Voter = '') Or (setupper (Votes [B]. Voter) = setupper (user. handle)) Then Break;
    If New And (setupper (Votes [B]. Voter) = setupper (user. handle)) Then Continue;

    If Not Found Then ShowFile (Path + Katmandu [New] + '.Top', False, True);
    Found := True;
    GetDateTimeStr (N. Added, Date, Time);
    nuvParsed := false;
    ShowFileProc (Path + Katmandu [New] + '.Mid', NuvList);

    Inc (count);
  End;

  Close (nuvf);

  if inputbroke then
    comwriteln ('|UR' + ^M^J)
  else
    If Not Found Then
      If New Then
        ComWriteLn (Cs (25))
      Else
        ComWriteLn (Cs (70))
    Else
      ShowFile (Path + Katmandu [New] + '.Bot', False, True);
  Log (0, 'Listed users in nuv');
End;

Procedure VoteUser (Var N: NuvType; Var tu: tUserdata);
Var
  cs27, cs80: String;
  ps: longint;
  b, b2, w: byte;
  hascum, sysval: boolean;
  p: datetimerec;

  Procedure Draw;
  Begin
    FillIn1 := tu. Handle;
    ComWriteln (Cs (83));
    FillIn1 := PadRight (IntToStr (tu. voteyes), 3, ' ');
    FillIn2 := PadRight (IntToStr (uc. yesvote), 3, ' ');
    ComWriteln (Cs (84));
    FillIn1 := PadRight (IntToStr (tu. voteno), 3, ' ');
    FillIn2 := PadRight (IntToStr (uc. novote), 3, ' ');
    ComWriteln (Cs (85));
    FillIn1 := NoYes [N. Votes [B]. Vote];
    If setupper (N. Votes [B]. Voter) = setupper (user. handle) then ComWriteln (Cs (86));
    If hascum then ComWriteln (Cs (5));
    ComWriteln ('');
  End;

  Procedure whatchoowannado (z: boolean);
  const
    qrf = 'V~alidate D~elete C~omments I~nfoform R~eset S~kip';
  var
    w: byte;
    b2: byte;
  begin
    Repeat
      W := LiteString (cs (76), qrf, byte (z) + 1);
      If hung then exit;
      comwriteln ('');

      n. votes [b]. voter := user. handle;
      fillin1 := tu. handle;

      Case w of
        1: Begin
             ps := filepos (nuvf) - sizeof (nuvtype);
             close (nuvf);
             validateuser (tu);
             if exist (uc. datapath + 'nuv.dat') then begin
               reset (nuvf, 1);
               seek (nuvf, ps);
             end;
             comwriteln (cs (82));
             sysval := true;
             Log (2, 'User ' + tu. handle + ' validated by nuv');
             break;
            end;
         2: Begin
              fillchar (tu, sizeof (tuserdata), 0);
              ps := filepos (nuvf);
              removerec (nuvf, pred (filepos (nuvf) div sizeof (n)), sizeof (n));
              seek (nuvf, ps - sizeof (nuvf));
              sysval := true;
              now (p);
              case uc. daysinblist of
                 0:;
                -1: addtoblacklist (tu. handle, tdimmediate, 'NUVDEL.ANS', 0);
                -2: addtoblacklist (tu. handle, tdforever, 'NUVDEL.ANS', 0);
                else addtoblacklist (tu. handle, tddate, 'NUVDEL.ANS', p. d + uc. daysinblist);
              end;
              comwriteln (cs (81));
              comwriteln (^M^J);
              tu. sysnote := 'NUV deletion on ' + CurrentDate (True);
{              adduserundel (tu);}
              tu. handle := '';
              updateuserrec (tu, tu. recnum);
              Log (2, 'User ' + tu. handle + ' deleted by nuv');
              break;
            End;
         3: Begin
              comwriteln ('');
              if (b = 1) and (setupper (n. votes [b]. Voter) <> setupper (user. handle)) then begin
                fillin1 := n. handle;
                comwriteln (cs (79));
                continue;
              end;
              for b2 := 1 to 100 do
                with n. votes [b2] do
                  if (voter <> '') and (comment <> '') then begin
                    fillin1 := voter;
                    fillin2 := comment;
                    comwriteln (cs80);
                    if b2 mod curpagelen = pred (curpagelen) then
                      if more (false) = mno then break;
                  end;
              if hung then break;
            End;
         4: ViewInfoform (uc. nuvform, tu. recnum);
         5: Begin
              with tu do begin
                voteyes := 0;
                voteno := 0;
                updateuserrec (tu, tu. recnum);
                fillchar (n. Votes, sizeof (NuvVoteRec), 0);
              end;
              Log (2, 'User ' + tu. handle + '''s nuv record was reset');
              break;
            End;
         6: break;
      end;
      draw;
    until hung;
  end;

const
  xp1 = '|15T|07h|08is user has been selected f|07o|15r |US';
  xp2 = ' |15b|07y |08the vote|07r|15s|08.'^M^J;
Begin
  if not hasacs (uc. vVoteNuvACS) then exit;
  With N do Begin
    hascum := False;
    For B := 1 to 100 do
      If (Votes [B]. Comment <> '') Then Begin
        hascum := True;
        Break;
      End;

    For B := 1 to 100 do
      If (Votes [B]. Voter = '') Or (setupper (Votes [B]. Voter) = setupper (user. handle)) Then Break;

    cs27 := cs (27);
    cs80 := cs (80);

    Repeat
      comwriteln ('');
      Draw;

      if not spuds. b (uc. options, autonuv) then
        if sysopacs then
          if (tu. voteyes >= uc. yesvote) then begin
            ComWriteLn (xp1 + 'validation' + xp2);
            whatchoowannado (false);
            break;
          end else if (tu. voteno >= uc. novote) then begin
            ComWriteLn (xp1 + 'deletion' + xp2);
            whatchoowannado (true);
            break;
          end
        else exit;

        begin
          W := LiteString (cs (75), cs27, 1);
          If hung then break;
          comwriteln ('');

          Case w of
            1: Begin
                 ComWriteln (^M^J + Cs (28));
                 with votes [b] do begin
                   If (setupper (Voter) = setupper (user. handle)) And (Not Vote) Then
                     If tu. voteno > User. NuvWeight Then
                       dec (tu. voteno, User. NuvWeight)
                     Else
                       tu. voteno := 0;

                   vote := true;

                   if 100 - tu. voteyes >= User. NuvWeight then
                     inc (tu. voteyes, user. nuvweight)
                   else
                     tu. voteyes := 100;

                   if cosysopacs and not (tu. voteyes >= uc. yesvote) then begin
                     comwrite ('|15S|07y|08sop |15P|07r|08ivelege|UP: |USValidate user ');
                     sysval := litebar (lbno, false, true) = lbyes;
                   end else sysval := false;

                   voter := user. handle;
                   fillin1 := handle;

                   if sysval or (spuds. b (uc. options, autonuv) and (tu. voteyes >= uc. yesvote)) then begin
                     ps := filepos (nuvf) - sizeof (nuvtype);
                     close (nuvf);
                     validateuser (tu);
                     if exist (uc. datapath + 'nuv.dat') then begin
                       reset (nuvf, 1);
                       seek (nuvf, ps);
                     end;
                     comwriteln (cs (82));
                     sysval := true;
                     Log (2, 'User ' + tu. handle + ' validated by nuv');
                   end else begin
                     comwrite (cs (77));
                     getstr (30, false, false, comment);
                     if hung then break;
                     comwriteln ('');
                   end;
                 end;
                 comwriteln ('');
                 updateuserrec (tu, tu. recnum);
                 Break;
               End;
            2: Begin
                 ComWriteln (^M^J + Cs (78));
                 with votes [b] do begin
                   If (setupper (Voter) = setupper (user. handle)) And (Vote) Then
                     If tu. voteyes > User. NuvWeight Then
                       dec (tu. voteyes, User. NuvWeight)
                     Else
                       tu. voteyes := 0;

                   vote := false;

                   if 100 - tu. voteno >= User. NuvWeight then
                     inc (tu. voteno, user. nuvweight)
                   else
                     tu. voteno := 100;

                   if cosysopacs and not (tu. voteno >= uc. novote) then begin
                     comwrite ('|15S|07y|08sop |15P|07r|08ivelege|UP: |USDelete user ');
                     sysval := litebar (lbno, false, true) = lbyes;
                   end else sysval := false;

                   voter := user. handle;
                   fillin1 := handle;

                   if sysval or (spuds. b (uc. options, autonuv) and (tu. voteno >= uc. novote)) then begin
                     ps := filepos (nuvf);
                     removerec (nuvf, pred (filepos (nuvf) div sizeof (n)), sizeof (n));
                     seek (nuvf, ps - sizeof (nuvf));
                     sysval := true;
                     now (P);
                     case uc. daysinblist of
                       0:;
                       -1: addtoblacklist (handle, tdimmediate, 'NUVDEL.ANS', 0);
                       -2: addtoblacklist (handle, tdforever, 'NUVDEL.ANS', 0);
                       else addtoblacklist (handle, tddate, 'NUVDEL.ANS', p. d + uc. daysinblist);
                     end;
                     tu. sysnote := 'NUV deletion on ' + CurrentDate (True);
{                     adduserundel (tu);}
                     tu. handle := '';
                     comwriteln (cs (81));
                     Log (2, 'User ' + tu. handle + ' deleted by nuv');
                   end else begin
                     comwrite (cs (77));
                     getstr (30, false, false, comment);
                     if hung then break;
                   end;
                 end;
                 updateuserrec (tu, tu. recnum);
                 comwriteln (^M^J);
                 Break;
               End;
            3: Begin
                 comwriteln ('');
                 if not hascum then begin
                   fillin1 := handle;
                   comwriteln (cs (79));
                 end else for b2 := 1 to 100 do
                   with votes [b2] do
                     if (voter <> '') and (comment <> '') then begin
                       fillin1 := voter;
                       fillin2 := comment;
                       comwriteln (cs80);
                       if b2 mod curpagelen = pred (curpagelen) then
                         if more (false) = mno then break;
                     end;
                 if hung then break;
               End;
            4: ViewInfoform (uc. nuvform, tu. recnum);
            5: If AllowQuit Then Break;
          End;
        end;
    Until hung;
  end;

  if not sysval then begin
    Seek (nuvf, Filepos (nuvf) - sizeof (n));
    blockWrite (nuvf, n, sizeof (n));
  end;
End;

Procedure VoteOnUser (p: str100);
var
  wowzers, rec: word;
begin
  if not hasacs (uc. vVoteNuvACS) then exit;
  if p = '' then exit;
  Assign (nuvf, Uc. DataPath + 'Nuv.Dat');
  {$I-}
  Reset (nuvf, 1);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If (IoResult <> 0) Or (FileSize (nuvf) = 0) Then Begin
    {$I-}
    Close (nuvf);
    {$IFDEF Debug}{$I+}{$ENDIF}
    If IoResult <> 0 Then;
    ComWriteln (cs (26));
    Exit;
  End;

  if innuv (p, rec) then begin
    seek (nuvf, rec * sizeof (nuvtype));
    blockread (nuvf, n, sizeof (nuvtype));
    if not lookupuser (n. handle, rec) or not ReadUserRec (tu, Rec) then begin
      wowzers := pred (filepos (nuvf));
      close (nuvf);
      RemNuv (wowzers);
      exit;
    end;
    VoteUser (n, tu);
  end;
  Close (nuvf);
end;

Procedure RunNuv;
Var
  B: Byte;
  wowzers, rec: word;
Begin
  if not hasacs (uc. vVoteNuvACS) then exit;
  Assign (nuvf, Uc. DataPath + 'Nuv.Dat');
  {$I-}
  Reset (nuvf, 1);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If (IoResult <> 0) Or (FileSize (nuvf) = 0) Then Begin
    {$I-}
    Close (nuvf);
    {$IFDEF Debug}{$I+}{$ENDIF}
    If IoResult <> 0 Then;
    ComWriteln (cs (70));
    Exit;
  End;

  AllowQuit := True;

  While not eof (nuvf) do with n do Begin
    blockRead (nuvf, N, sizeof (n));
    if not lookupuser (handle, rec) or not ReadUserRec (tu, Rec) then begin
      wowzers := pred (filepos (nuvf));
      close (nuvf);
      RemNuv (wowzers);
      reset (nuvf);
      seek (nuvf, wowzers);
      continue;
    end;
    VoteUser (n, tu);
  End;

  {$I-}
  Close (nuvf);
  {$IFDEF Debug}{I+}{$ENDIF}
  If IoResult <> 0 Then ;
End;

Procedure NewScanNuv (P: Str100);
Var
  B: Byte;
  wowzers, rec: word;
  q: boolean;
Begin
  if not hasacs (uc. vVoteNuvACS) then exit;
  q := false;
  P := SetUpper (P);
  Assign (nuvf, Uc. DataPath + 'Nuv.Dat');
  {$I-}
  Reset (nuvf, 1);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If (IoResult <> 0) Or (FileSize (nuvf) = 0) Then Begin
    {$I-}
    Close (nuvf);
    {$IFDEF Debug}{$I+}{$ENDIF}
    If IoResult <> 0 Then;
    If Pos ('Q', P) = 0 Then comwriteln (cs (25));
    Exit;
  End;

  AllowQuit := Pos ('X', P) = 0;

  While not eof (nuvf) do with N do begin
    blockRead (nuvf, N, sizeof (n));

    For B := 1 to 100 do
      If (Votes [B]. Voter = '') Or (setupper (Votes [B]. Voter) = setupper (user. handle)) Then Break;

    If setupper (Votes [B]. Voter) = setupper (user. handle) Then Continue;

    if not lookupuser (handle, rec) or not ReadUserRec (tu, Rec) then begin
      wowzers := pred (filepos (nuvf));
      close (nuvf);
      RemNuv (wowzers);
      reset (nuvf);
      seek (nuvf, wowzers);
      continue;
    end;

    if not q and (Pos ('A', P) <> 0) Then Begin
      ComWrite (Cs (112));
      If LiteBar (lbYes, False, True) = lbNo Then Begin
        Close (nuvf);
        AllowQuit := True;
        Exit;
      End;
    End;

    VoteUser (n, tu);
    q := true;
  End;

  AllowQuit := True;
  {$I-}
  Close (nuvf);
  {$IFDEF Debug}{I+}{$ENDIF}
  If IoResult <> 0 Then ;
  if not q and (Pos ('Q', P) = 0) then comwriteln (cs (25));
End;

Function InNuv (Handle: HandleStr; Var Rec: Word): Boolean;
var
  f: file of nuvtype;
  r: ^nuvtype;
Begin
  getmem (r, sizeof (nuvtype));
  InNuv := false;
  rec := 0;
  handle := Setupper (Strip ('B', ' ', handle));
  assign (f, uc. datapath + 'Nuv.Dat');
  {$I-}
  reset (f);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then exit;
  while not eof (f) do begin
    inc (rec);
    read (f, r^);
    if setupper (r^. handle) = handle then begin
      close (f);
      Innuv := true;
      freemem (r, sizeof (nuvtype));
      exit;
    end;
  end;
  close (f);
  freemem (r, sizeof (nuvtype));
End;

Procedure RemNuv (Rec: Word);
Var
  r: ^NuvType;
  f: File of nuvtype;
Begin
  getmem (r, sizeof (nuvtype));
  assign (f, uc. datapath + 'Nuv.Dat');
  {$I-}
  reset (f);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then exit;

  if rec > filesize (f) then
  else if rec = filesize (f) then begin
    seek (f, pred (rec));
    truncate (f);
  end else begin
    seek (f, pred (filesize (f)));
    read (f, r^);
    seek (f, pred (filesize (f)));
    truncate (f);
    seek (f, pred (rec));
    write (f, r^);
  end;

  {$I-}
  close (f);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then ;
End;

Procedure rNuv (C: Char; P: Str100);
Begin
  Case C of
    'N': NewScanNuv (P);
    'U': VoteOnUser (P);
    'V': RunNuv;
    'L': ListInNuv (Ucase (P [1]) = 'N');
    Else rError ('^' + C);
  End;
End;

End.
