Unit JoinConf;
{$I Sys75.Inc}

Interface

Uses
  totlink,
  Spuds;

Procedure rJoinConferences (C: Char; P: Str100);
procedure listconfs (rel, files: boolean);
procedure joinrel (files: boolean; b: byte);
procedure joinabs (files: boolean; b: byte);
function  getpdconf (p: str80; def: byte; list: pdllobj): byte;
function  getpdchar (p: str80; def: byte; s: string; list: pdllobj): char;
procedure jconf (files: boolean; b: byte);

var
  mconf: confrec;
  fconf: confrec;

Implementation

Uses
  dos, crt,
  TotStr, TotFast, totmisc, totkey,
  Acs, RemEmu, Comm, Menus, StatusBar, Emu, MsgSpon, Messages, FileSpon, FileMenu,
  users, emucodes, misc, fonts;

var
  confparsed: boolean;
  count: word;
  cr: confrec;

Procedure ConfList (C: Char);
var
  s: string;
Begin
  if confparsed then begin
    With cr do Case C of
      '#': s := IntToStr (Count);
      'N': s := desc;
      Else s := '@' + C;
    End;
    comwrite (padd (s));
    confparsed := false;
  End else if c = '@' then confparsed := true else comwritech (c);
End;

procedure listconfs (rel, files: boolean);
var
  cf: file of confrec;
  path: dirstr;
const
  jizz: array [false..true] of char = 'MF';
begin
  count := 1;
  comwriteln ('');

  If Exist (CurStatSet. Path + jizz [files] + 'Confs.*') Then
    Path := CurStatSet. Path
  Else
    Path := Uc. DispPath;

  showfile (path + jizz [files] + 'confs.top', false, true);

  if files then
    assign (cf, uc. datapath + 'FileConf.Dat')
  else
    assign (cf, uc. datapath + 'MsgConf.Dat');
  reset (cf);
  if ioresult <> 0 then exit;

  while not eof (cf) do begin
    read (cf, cr);
    if not rel or (rel and hasacs (cr. acs)) then begin
      confparsed := false;
      showfileproc (path + jizz [files] + 'confs.mid', conflist);
      inc (count);
    end;
  end;
  close (cf);
  showfile (path + jizz [files] + 'confs.bot', false, true);
  comwriteln ('');
  Log (0, 'Listed conferences');
end;

procedure jconf (files: boolean; b: byte);
var
  cf: file of confrec;
begin
  if files then
    assign (cf, uc. datapath + 'FileConf.Dat')
  else
    assign (cf, uc. datapath + 'MsgConf.Dat');
  reset (cf);
  if ioresult <> 0 then exit;
  seek (cf, pred (b));
  read (cf, fconf);
  curfconf := b;
  close (cf);
end;

procedure joinabs (files: boolean; b: byte);
const
  wow: array [false..true] of char = ('m', 'f');
var
  s: pwstr;
  wowz, z: byte;
  cf: file of confrec;
  cr: confrec;
  path: pathstr;
begin
  if files then begin
    fillin1 := 'file';
    z := curfconf;
    assign (cf, uc. datapath + 'FileConf.Dat');
  end else begin
    fillin1 := 'message';
    z := curmconf;
    assign (cf, uc. datapath + 'MsgConf.Dat');
  end;

  reset (cf);
  if ioresult <> 0 then exit;

  if b = 0 then begin
    if exist (curstatset. path + 'pd' + wow [files] + 'conf.ans') then
      path := curstatset. path
    else if exist (uc. disppath + 'pd' + wow [files] + 'conf.ans') then
      path := uc. disppath
    else
      path := '';

    if path <> '' then begin
      new (list, init);
      while not eof (cf) do begin
        read (cf, cr);
        list^. add (cr. pdn, 31);
      end;

      if files then
        b := getpdconf (path + 'pdfconf.ans', curfconf, list)
      else
        b := getpdconf (path + 'pdmconf.ans', curmconf, list);

      dispose (list, done);

      if b = 0 then path := '';
    end;

    if path = '' then begin
      fillin2 := inttostr (z);
      listconfs (false, files);
      repeat
        comwrite (Cs (90));
        b := getqnumstr (False, False, 1, filesize (cf), 0, 0, z, 0, wowz, '?');
        comwriteln ('');
        if b > 0 then break;
        if wowz = 1 then listconfs (false, files);
      until hung;
      if hung then begin
        close (cf);
        exit;
      end;
    end;
  end else if b > filesize (cf) then b := filesize (cf);

  seek (cf, pred (b));
  read (cf, cr);
  close (cf);

  If hung Then Exit;

  comwriteln ('');

  if ((files and not tmpfspons) or (not files and not tmpmspons)) and not hasacs (cr. acs) then begin
    failflag := true;
    Exit;
  end;

  if (cr. pw <> '') and ((files and not tmpfspons) or (not files and not tmpmspons)) then begin
    If not spuds. b (uc. options, localsec) Then begin
      If _y = 1 then
        if statbar = 0 then
          SnapShotOff := currentmode
        else
          SnapShotOff := pred (currentmode)
      else
        SnapShotOff := 1;
      Move (Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], SnapShot, 160);
      Screen^. PartClear (1, SnapShotOff, 80, SnapShotOff, $17, ' ');
      Screen^. WritePlain (1, SnapShotOff, ' Conf pw = ' + cr. pw + '  ' + Replicate (30, ' ') + ' ');
      specialbar := true;
    end;

    ComWrite (Cs (94));
    If hung Then Exit;
    S := '';

    GetPwStr (14 + Length (cr. pw), False, True, S);
    If hung Then Exit;

    If not spuds. b (uc. options, localsec) Then
      Move (SnapShot, Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], 160);

    ComWriteLn ('');

    If S <> SetLower (cr. pw) Then begin
      if files then
        fillin1 := 'file'
      else
        fillin1 := 'message';
      Log (2, 'Entered incorrect password joining ' + fillin1 + ' conference ' + cr. desc);
      Log (2, '  Entered: ' + s);
      failflag := true;
      Exit;
    end;
  end;

  if files then
    curfconf := b
  else
    curmconf := b;

  if files then
    fconf := cr
  else
    mconf := cr;

  fillin1 := cr. desc;
  if files then begin
    fillin2 := 'file';
    fillin3 := inttostr (curfconf);
  end else begin
    fillin2 := 'message';
    fillin3 := inttostr (curmconf);
  end;
  comwriteln (cs (22) + ^M^J);

  if not files then begin
    Log (0, 'Joined message conference ' + cr. desc);
    if curmconf = user. lastmconf then
      gobase (user. lastbase, false)
    else
      gobase (1, false);
    user. lastmconf := curmconf;
  end else begin
    Log (0, 'Joined file conference ' + cr. desc);
    if curfconf = user. lastfconf then
      goarea (user. lastarea, false)
    else
      goarea (1, false);
    user. lastfconf := curfconf;
  end;
end;

procedure joinrel (files: boolean; b: byte);
const
  wow: array [false..true] of char = ('m', 'f');
var
  wowz, z, lui: byte;
  dashit: array [1..255] of byte;
  cf: file of confrec;
  cr: confrec;
  path: pathstr;
  list: pdllobj;
begin
  if files then
    assign (cf, uc. datapath + 'FileConf.Dat')
  else
    assign (cf, uc. datapath + 'MsgConf.Dat');
  reset (cf);
  if ioresult <> 0 then exit;

  lui := 0;
  for z := 1 to filesize (cf) do begin
    read (cf, cr);
    if (files and tmpfspons) or (not files and tmpmspons) or hasacs (cr. acs) then begin
      inc (lui);
      dashit [lui] := z;
    end;
  end;
  close (cf);

  if files then fillin1 := 'file' else fillin1 := 'message';

  if lui = 0 then begin
    comwriteln (^M^J + Cs (93) + ^M^J);
    failflag := true;
    exit;
  end;

  if files then z := curfconf else z := curmconf;

  if b = 0 then begin
    if exist (curstatset. path + 'pd' + wow [files] + 'conf.ans') then
      path := curstatset. path
    else if exist (uc. disppath + 'pd' + wow [files] + 'conf.ans') then
      path := uc. disppath
    else
      path := '';

    if path <> '' then begin
      new (list, init);
      reset (cf);
      while not eof (cf) do begin
        read (cf, cr);
        if hasacs (cr. acs) then list^. add (cr. pdn, 31);
      end;
      close (cf);

      if files then
        b := getpdconf (path + 'pdfconf.ans', curfconf, list)
      else
        b := getpdconf (path + 'pdmconf.ans', curmconf, list);

      dispose (list, done);

      if b = 0 then path := '';
    end;

    if path = '' then begin
      fillin2 := inttostr (z);
      listconfs (true, files);
      repeat
        comwrite (Cs (90));
        b := getqnumstr (False, False, 1, lui, 0, 0, z, 0, wowz, '?');
        comwriteln ('');
        if b > 0 then break;
        if wowz = 1 then listconfs (true, files);
      until hung;
      if hung then exit;
    end;
  end else if b > lui then b := lui;

  joinabs (files, dashit [b]);
end;

type
  pdxys = array [0..255] of axy;
var
  pdcnt: byte;
  pdparsed: boolean;
  pdxy: ^pdxys;

procedure parsepd (c: char);
Var
  Test: Boolean;
Begin
  Test := True;
  If pdParsed Then Begin
    Case C of
      '!': Begin
             inc (pdcnt);
             GetAxy (pdxy^ [pdcnt]);
           End;
      'I': GetAxy (pdxy^ [0]);
      Else Begin
        Comwrite ('@' + C);
        Test := False;
      End;
    End;
    If Test Then Begin
      Inc (_x, 2);
      If _x > Sx2 Then Begin
        _x := _x - Sx2;
        If _y <> Sy2 Then Inc (_y);
      End;
      Send (GoXy (_x, _y));
    End;
    pdParsed := False;
  End Else Begin
    If C = '@' Then
      pdParsed := True
    Else
      ComWriteCh (C);
  End;
end;

function getpdconf (p: str80; def: byte; list: pdllobj): byte;
var
  o: word;
  page,
  top, b: byte;
  s, t: str80;
  saved: axy;

  procedure hi;
  begin
    with list^ do
      getnodedata (nodeptr (b), s);

    if b mod pdcnt = 0 then
      putaxy (pdxy^ [pdcnt])
    else
      putaxy (pdxy^ [b mod pdcnt]);

    comwrite (antipipe (s));
    putaxy (saved);
  end;

  procedure show;
  var
    b: byte;
  begin
    for b := succ (pred (page) * pdcnt) to page * pdcnt do with list^ do begin
      if b > totalnodes then begin
        getnodedata (nodeptr (b - pdcnt), s);
        s := replicate (pipelen (s), ' ');
      end else
        getnodedata (nodeptr (b), s);

      if b mod pdcnt = 0 then
        putaxy (pdxy^ [pdcnt])
      else
        putaxy (pdxy^ [b mod pdcnt]);

      comwrite (s);
    end;
  end;

begin
  getpdconf := 0;
  getmem (pdxy, sizeof (pdxys));
  fillchar (pdxy^, sizeof (pdxys), 0);
  pdcnt := 0;
  pdparsed := false;
  reallyunabortable := true;
  showfileproc (p, parsepd);
  getaxy (saved);
  if pdcnt = 0 then exit;
  if pdcnt >= list^. totalnodes then begin
    pdcnt := list^. totalnodes;
    if def > pdcnt then def := pdcnt;
  end else if def > list^. totalnodes then def := list^. totalnodes;

  top := list^. totalnodes div pdcnt;
  if list^. totalnodes mod pdcnt <> 0 then inc (top);

  with list^ do if totalnodes > pdcnt then begin
    getnodedata (nodeptr (1), s);
    putaxy (pdxy^ [1]);
    comwrite (s);
    s := cs (171);
    s := '|' + padright (inttostr (textattr mod 16), 2, '0') + '|B' + inttostr (textattr div 16) + s;
    t := cs (172);
    t := '|' + padright (inttostr (textattr mod 16), 2, '0') + '|B' + inttostr (textattr div 16) + t;
    for b := 1 to top do begin
      insertbefore (NodePtr (b * pdcnt), s, sizeof (s));
      insertbefore (NodePtr (succ (b * pdcnt)), t, sizeof (t));
    end;

    top := list^. totalnodes div pdcnt;
    if list^. totalnodes mod pdcnt <> 0 then inc (top);

    for b := 1 to top do  {don't fucking change a thing!}
      if b * pdcnt <= def then inc (def, 2);

    b := def;
    page := b div pdcnt;
    if b mod pdcnt <> 0 then inc (page);
  end else begin
    b := def;
    page := 1;
    top := 1;
  end;


  show;
  hi;

  repeat
    o := readarrow;
    if hung then break;
    case o of
      kLeft, kUp: begin
                    if b mod pdcnt = 0 then
                      putaxy (pdxy^ [pdcnt])
                    else
                      putaxy (pdxy^ [b mod pdcnt]);

                    comwrite (s);
                    if b = succ (pred (page) * pdcnt) then begin
                      b := pdcnt * page;
                      if b > list^. totalnodes then b := list^. totalnodes;
                    end else
                      dec (b);
                    hi;
                  end;
      kRight, kDown: begin
                       if b mod pdcnt = 0 then
                         putaxy (pdxy^ [pdcnt])
                       else
                         putaxy (pdxy^ [b mod pdcnt]);

                       comwrite (s);
                       if (b = pdcnt * page) or (b = list^. totalnodes) then
                         b := succ (pred (page) * pdcnt)
                       else
                         inc (b);
                       hi;
                     end;
       13: if pdcnt < list^. totalnodes then begin
             if (b mod pdcnt = 1) and (page <> 1) then begin
               dec (page);
               show;
               b := pred (page) * pdcnt + pdcnt;
               hi;
             end else if (b mod pdcnt = 0) and (page <> top) then begin
               inc (page);
               show;
               inc (b);
               hi;
             end else begin
               dec (b, (pred (page) * 2));
               break;
             end;
           end else break;
    end;
  until hung;
  freemem (pdxy, sizeof (pdxys));
  putaxy (saved);
  getpdconf := b;
end;

function getpdchar (p: str80; def: byte; s: string; list: pdllobj): char;
var
  o: word;
  b: byte;
  t: str80;
  saved: axy;

  procedure hi;
  begin
    with list^ do
      getnodedata (nodeptr (b), t);
    putaxy (pdxy^ [b]);
    comwrite (antipipe (t));
    putaxy (saved);
  end;

begin
  getpdchar := #0;
  getmem (pdxy, sizeof (pdxys));
  fillchar (pdxy^, sizeof (pdxys), 0);
  pdcnt := 0;
  pdparsed := false;
  reallyunabortable := true;
  showfileproc (p, parsepd);
  getaxy (saved);
  if pdcnt = 0 then exit;
  if pdcnt > list^. totalnodes then pdcnt := list^. totalnodes;

  for b := 1 to pdcnt do begin
    with list^ do
      getnodedata (nodeptr (b), t);
    putaxy (pdxy^ [b]);
    comwrite (t);
  end;

  if def > pdcnt then def := pdcnt;
  b := def;

  hi;

  repeat
    o := readarrow;
    if hung then break;
    case o of
      kLeft, kUp: begin
                    putaxy (pdxy^ [b]);
                    comwrite (t);
                    if b = 1 then
                      b := pdcnt
                    else
                      dec (b);
                    hi;
                  end;
      kRight, kDown: begin
                       putaxy (pdxy^ [b]);
                       comwrite (t);
                       if b = pdcnt then
                         b := 1
                       else
                         inc (b);
                       hi;
                     end;
       13: break;
       32:;
       113, 81: begin
                  freemem (pdxy, sizeof (pdxys));
                  putaxy (saved);
                  getpdchar := 'Q';
                  exit;
                end;
       else if pos (ucase (chr (lo (o))), s) <> 0 then begin
         putaxy (pdxy^ [b]);
         comwrite (t);
         b := pos (ucase (chr (lo (o))), s);
         hi;
         break;
      end;
    end;
  until hung;
  freemem (pdxy, sizeof (pdxys));
  putaxy (saved);
  getpdchar := s [b];
end;

Procedure rJoinConferences (C: Char; P: Str100);
var
  b: byte;
Begin
  b := strtoint (strip ('A', ' ', p));
  Case C of
    'F': JoinRel (true, b);
    'M': JoinRel (false, b);
    'S': JoinAbs (true, b);
    'T': JoinAbs (false, b);
    Else rError ('J' + C);
  End;
End;

End.
