Unit FieldInput;
{$I Sys75.Inc}

Interface

Uses
  Dos,
  Spuds,
  TotLink, TotKey, TotDate;

Type
  tiptipe = (tchar, tstring, tbyte, thexb, tinteger, tword, thexw, tlongint, tphone, tdate, ttime, tonoff, tbool, ttoggle);

  toggletype = array [1..10] of string [40];
  toggletypeptr = ^toggletype;

  pitemrec = ^itemrec;
  itemrec = record
    putx, puty: Byte;
    len: longint;
    hindex: longint;
    case tipe: tiptipe of
      tchar : (chart: boolean; cdata: ^char);
      tstring: (watch: byte; sdata: ^string);
      tbyte : (hibr, lobr:byte; bdata: ^byte);
      tword : (hiwr, lowr:word; wdata: ^word);
      thexb : (hbdata: ^byte);
      thexw : (hwdata: ^word);
      tinteger : (hiir, loir:integer; idata: ^integer);
      tlongint : (hilr, lolr:longint; ldata: ^longint);
      tphone: (pdata: ^str12);
      tdate: (ddata: ^date);
      ttime: (tdata: ^time);
      tonoff: (kind: byte; odata: ^longint);
      tbool: (zdata: ^boolean);
      ttoggle: (pnt: toggletypeptr; edata: ^byte);
  end;

  ptablerec = ^tablerec;
  tablerec =
  object
    Constructor Init;
    Procedure   AssignHelpFile (N: PathStr; X, Y, A, L: Byte);
    Procedure   AddItem (px, py: byte; hlpindx, l, l1, l2: longint; tip: tiptipe; data: Pointer);
    function    Run: shortint;
    Procedure   Draw;
    Function    Process (Num: Word): Word;
    Destructor  Done;
  private
    curitem, maxitems: word;
    items: pdllobj;
    MaxTables: Word;
    CurItemRec: ^ItemRec;
    hfile: pathstr;
    hx, hy, ha, hl: byte;
    helpfile: file;
  end;

Implementation

Uses
  TotStr, TotMisc,
  Misc, Emu, RemEmu, EmuCodes, Comm;

Function GetFieldStr (Len: Byte; chart, prop, cap, alpha, path: boolean; Var S: String): Word;
Var
  I: Word;
  C: Char;
  sx, fx, P: Byte;
  ps: String;
Begin
  If Len > 254 then len := 254;
  ps := S;
  S := '';
  P := 1;
  fx := _x;
  sx := _x;
  ComWrite ('|UV'#8' ' + Rep (' ', Succ (Len)));
  Send (GoXy (sx, _y));

  Repeat
    if MacroStr <> '' then begin
      I := Ord (MacroStr [1]);
      Delete (MacroStr, 1, 1);
    end else If ps <> '' Then Begin
      I := Ord (ps [1]);
      Delete (ps, 1, 1);
    End Else
      I := readarrow;
    If hung Then Exit;

    C := Chr (Lo (I));

    Case I of
      kCtlN:
           Begin
             GetFieldStr := kCtlN;
             Break;
           End;
      kCtlb:
           Begin
             GetFieldStr := kCtlb;
             Break;
           End;
      kctlf: if allowflagedit then begin
               flagedit;
               If hung then exit;
               Continue;
             end;
      8: If P <> 1 Then Begin
           If P = Succ (Length (S)) Then Begin
             Dec (S [0]);
             ComWrite (#8' '#8);
           End Else Begin
             Delete (S, Pred (P), 1);
             ComWrite (#8);
             sx := _x;
             Send (Copy (S, Pred (P), 255) + ' ' + GoXy (sx, _y));
           End;
           Dec (P);
         End;
      kEsc, kCtlZ:
           Begin
             GetFieldStr := kCtlZ;
             Break;
           End;
      kUp:
           Begin
             GetFieldStr := kUp;
             Break;
           End;
      13, kDown:
           Begin
             GetFieldStr := kDown;
             Break;
           End;
      24: begin
            send (goxy (fx, _y) + rep (' ', length (s)) + goxy (fx, _y));
            s := '';
            p := 1;
          end;
      kLeft: If P <> 1 Then Begin
               Send (GoXy (Pred (_x), _y));
               Dec (P);
             End;
      kRight:If P <= Length (S) Then Begin
               Send (GoXy (Succ (_x), _y));
               Inc (P);
             End;
      kHome:
             Begin
               P := 1;
               Send (GoXy (fx, _y));
             End;
      kEnd:
             Begin
               P := Succ (Length (S));
               Send (GoXy (Pred (fx + P), _y));
             End;
      kIns: InsertMode := Not InsertMode;
      kDel: If P <> Succ (Length (S)) Then Begin
              Delete (S, P, 1);
              sx := _x;
              Send (Copy (S, P, 255) + ' ' + GoXy (sx, _y));
            End;
      kCtlU: If Chart Then Begin
               ps := ps + ASCii;
               If hung then exit;
               Continue;
             End;
      Else If (I < 256) And (I > 31) Then Begin
        If path and (pos (c, '*?><|/;"][{}') <> 0) then continue;
        if alpha and not (c in ['a'..'z', 'A'..'Z']) then continue;
        if cap then C := uCase (C);
        if prop and ((p = 1) Or (S [pred (P)] In [' ', '-'])) Then C := uCase (C);
        If InsertMode Then Begin
          If Length (S) >= Len Then Continue;
          sx := Succ (_x);
          Send (C + Copy (S, P, 255));
          S := Copy (S, 1, Pred (P)) + C + Copy (S, P, 255);
          If P <> Length (S) Then
            Send (GoXy (sx, _y));
        End Else Begin
          If P > Len Then Continue;
          Send (C);
          S [P] := C;
          If P = Succ (Length (S)) Then Inc (S [0]);
        End;
        Inc (P);
      End;
    End;
  Until hung;
End;

Function GetFieldChar (chart: boolean; Var C: Char): Word;
Var
  i: word;
Begin
  ComWrite ('|UV'#8' ' + C + ' '#8#8);
  If C = ' ' Then C := #0;

  repeat
    if MacroStr <> '' then begin
      I := Ord (MacroStr [1]);
      Delete (MacroStr, 1, 1);
    End Else
      I := readarrow;

    If hung Then Exit;

    Case I of
      24, 8: If C <> #0 Then Begin
           C := #0;
           ComWrite (' '#8);
         End;
      kDel: If C <> #0 Then Begin
           C := #0;
           ComWrite (' '#8);
         End;
      kCtlN:
           Begin
             GetFieldchar := kCtlN;
             Break;
           End;
      kCtlB:
           Begin
             GetFieldchar := kCtlB;
             Break;
           End;
      kEsc, kCtlZ:
           Begin
             GetFieldChar := kCtlZ;
             Break;
           End;
      kUp:
           Begin
             GetFieldChar := kUp;
             Break;
           End;
      13, kDown:
           Begin
             GetFieldChar := kDown;
             Break;
           End;
      kCtlU: If Chart Then Begin
               C := ASCii;
               If hung then exit;
               send (C + #8);
               Continue;
             End;
      Else if i < 256 then Begin
        C := chr (lo (I));
        Send (C + #8);
      End;
    End;
  Until hung;

  If C = #0 Then C := ' ';
End;

Function GetFieldLimStr (Len: Byte; cap: boolean; Limit: String; Var S: String): Word;
Var
  I: Word;
  C: Char;
  sx, fx, P: Byte;
  ps: String;
Begin
  If Len > 254 then len := 254;
  ps := S;
  S := '';
  P := 1;
  fx := _x;
  sx := _x;
  usercol (5);
  ComWrite (#8' ' + Rep (' ', Succ (Len)));
  Send (GoXy (sx, _y));

  Repeat
    if MacroStr <> '' then begin
      I := Ord (MacroStr [1]);
      Delete (MacroStr, 1, 1);
    end else If ps <> '' Then Begin
      I := Ord (ps [1]);
      Delete (ps, 1, 1);
    End Else
      I := readarrow;
    If hung Then Exit;

    C := Chr (Lo (I));

    Case I of
      8: If P <> 1 Then Begin
           If P = Succ (Length (S)) Then Begin
             Dec (S [0]);
             ComWrite (#8' '#8);
           End Else Begin
             Delete (S, Pred (P), 1);
             ComWrite (#8);
             sx := _x;
             Send (Copy (S, Pred (P), 255) + ' ' + GoXy (sx, _y));
           End;
           Dec (P);
         End;
      kCtlN:
           Begin
             GetFieldlimStr := kCtlN;
             Break;
           End;
      kCtlB:
           Begin
             GetFieldlimStr := kCtlB;
             Break;
           End;
      kEsc, kCtlZ:
           Begin
             GetFieldLimStr := kCtlZ;
             Break;
           End;
      kUp:
           Begin
             GetFieldLimStr := kUp;
             Break;
           End;
      24: begin
            send (goxy (fx, _y) + rep (' ', length (s))+goxy (fx, _y));
            s := '';
            p := 1;
          end;
      13, kDown:
           Begin
             GetFieldLimStr := kDown;
             Break;
           End;
      kLeft: If P <> 1 Then Begin
               Send (GoXy (Pred (_x), _y));
               Dec (P);
             End;
      kRight:If P <= Length (S) Then Begin
               Send (GoXy (Succ (_x), _y));
               Inc (P);
             End;
      kHome:
             Begin
               P := 1;
               Send (GoXy (fx, _y));
             End;
      kEnd:
             Begin
               P := Succ (Length (S));
               Send (GoXy (Pred (fx + P), _y));
             End;
      kIns: InsertMode := Not InsertMode;
      kDel: If P <> Succ (Length (S)) Then Begin
              Delete (S, P, 1);
              sx := _x;
              Send (Copy (S, P, 255) + ' ' + GoXy (sx, _y));
            End;
      Else If (I < 256) And (I > 31) Then Begin
        If Pos (C, Limit) = 0 Then Continue;
        if cap then c := uCase (c);
        If InsertMode Then Begin
          If Length (S) >= Len Then Continue;
          sx := Succ (_x);
          Send (C + Copy (S, P, 255));
          S := Copy (S, 1, Pred (P)) + C + Copy (S, P, 255);
          If P <> Length (S) Then
            Send (GoXy (sx, _y));
        End Else Begin
          If P > Len Then Continue;
          Send (C);
          S [P] := C;
          If P = Succ (Length (S)) Then Inc (S [0]);
        End;
        Inc (P);
      End;
    End;
  Until hung;
End;

Function GetFieldNum (Len: Byte; S: LongInt; var new: longint): Word;
Var
  I: Word;
  C: Char;
  sx, fx, P: Byte;
  ps: String;
  T: String;
Begin
  If Len > 254 then len := 254;
  ps := inttostr (S);
  T := '';
  P := 1;
  fx := _x;
  sx := _x;
  usercol (5);
  ComWrite (#8' ' + Rep (' ', Succ (Len)));
  Send (GoXy (sx, _y));

  Repeat
    if MacroStr <> '' then begin
      I := Ord (MacroStr [1]);
      Delete (MacroStr, 1, 1);
    end else If ps <> '' Then Begin
      I := Ord (ps [1]);
      Delete (ps, 1, 1);
    End Else
      I := readarrow;
    If hung Then Exit;

    C := Chr (Lo (I));

    Case I of
      8: If P <> 1 Then Begin
           If P = Succ (Length (T)) Then Begin
             Dec (T [0]);
             ComWrite (#8' '#8);
           End Else Begin
             Delete (T, Pred (P), 1);
             ComWrite (#8);
             sx := _x;
             Send (Copy (T, Pred (P), 255) + ' ' + GoXy (sx, _y));
           End;
           Dec (P);
         End;
      kCtlN:
           Begin
             GetFieldnum := kCtlN;
             Break;
           End;
      kCtlB:
           Begin
             GetFieldnum := kCtlB;
             Break;
           End;
      kEsc, kCtlZ:
           Begin
             GetFieldNum := kCtlZ;
             Break;
           End;
      kUp:
           Begin
             GetFieldNum := kUp;
             Break;
           End;
      24: begin
            send (goxy (fx, _y) + rep (' ', length (t)) + goxy (fx, _y));
            t := '';
            p := 1;
          end;
      13, kDown:
           Begin
             GetFieldNum := kDown;
             Break;
           End;
      kLeft: If P <> 1 Then Begin
               Send (GoXy (Pred (_x), _y));
               Dec (P);
             End;
      kRight:If P <= Length (T) Then Begin
               Send (GoXy (Succ (_x), _y));
               Inc (P);
             End;
      kHome:
             Begin
               P := 1;
               Send (GoXy (fx, _y));
             End;
      kEnd:
             Begin
               P := Succ (Length (T));
               Send (GoXy (Pred (fx + P), _y));
             End;
      kIns: InsertMode := Not InsertMode;
      kDel: If P <> Succ (Length (T)) Then Begin
              Delete (T, P, 1);
              sx := _x;
              Send (Copy (T, P, 255) + ' ' + GoXy (sx, _y));
            End;
      Else If (I < 256) And (I > 31) Then Begin
        If Not (C In ['0'..'9','-','.']) Then Continue;
        If InsertMode Then Begin
          If Length (T) >= Len Then Continue;
          sx := Succ (_x);
          Send (C + Copy (T, P, 255));
          T := Copy (T, 1, Pred (P)) + C + Copy (T, P, 255);
          If P <> Length (T) Then
            Send (GoXy (sx, _y));
        End Else Begin
          If P > Len Then Continue;
          Send (C);
          T [P] := C;
          If P = Succ (Length (T)) Then Inc (T [0]);
        End;
        Inc (P);
      End;
    End;
  Until hung;
  New := StrToInt (T);
End;

Function GetFieldHex (Len: Byte; S: LongInt; var new: longint): Word;
Var
  I: Word;
  C: Char;
  sx, fx, P: Byte;
  ps: String;
  T: String;
Begin
  If Len > 254 then len := 254;
  ps := hexl (S);
  if len < 8 then delete (ps, 1, 8 - len);
  T := '';
  P := 1;
  fx := _x;
  sx := _x;
  usercol (5);
  ComWrite (#8' ' + Rep (' ', Succ (Len)));
  Send (GoXy (sx, _y));

  Repeat
    if MacroStr <> '' then begin
      I := Ord (MacroStr [1]);
      Delete (MacroStr, 1, 1);
    end else If ps <> '' Then Begin
      I := Ord (ps [1]);
      Delete (ps, 1, 1);
    End Else
      I := readarrow;
    If hung Then Exit;

    C := Chr (Lo (I));

    Case I of
      8: If P <> 1 Then Begin
           If P = Succ (Length (T)) Then Begin
             Dec (T [0]);
             ComWrite (#8' '#8);
           End Else Begin
             Delete (T, Pred (P), 1);
             ComWrite (#8);
             sx := _x;
             Send (Copy (T, Pred (P), 255) + ' ' + GoXy (sx, _y));
           End;
           Dec (P);
         End;
      kCtlN:
           Begin
             GetFieldhex := kCtlN;
             Break;
           End;
      kCtlB:
           Begin
             GetFieldhex := kCtlB;
             Break;
           End;
      kEsc, kCtlZ:
           Begin
             GetFieldHex := kCtlZ;
             Break;
           End;
      24: begin
            send (goxy (fx, _y)+rep (' ', length (t))+goxy (fx, _y));
            t := '';
            p := 1;
          end;
      kUp:
           Begin
             GetFieldHex := kUp;
             Break;
           End;
      13, kDown:
           Begin
             GetFieldHex := kDown;
             Break;
           End;
      kLeft: If P <> 1 Then Begin
               Send (GoXy (Pred (_x), _y));
               Dec (P);
             End;
      kRight:If P <= Length (T) Then Begin
               Send (GoXy (Succ (_x), _y));
               Inc (P);
             End;
      kHome:
             Begin
               P := 1;
               Send (GoXy (fx, _y));
             End;
      kEnd:
             Begin
               P := Succ (Length (T));
               Send (GoXy (Pred (fx + P), _y));
             End;
      kIns: InsertMode := Not InsertMode;
      kDel: If P <> Succ (Length (T)) Then Begin
              Delete (T, P, 1);
              sx := _x;
              Send (Copy (T, P, 255) + ' ' + GoXy (sx, _y));
            End;
      Else If (I < 256) And (I > 31) Then Begin
        If Not (C In ['0'..'9', 'A'..'F', 'a'..'f']) Then Continue;
        c := ucase (c);
        If InsertMode Then Begin
          If Length (T) >= Len Then Continue;
          sx := Succ (_x);
          Send (C + Copy (T, P, 255));
          T := Copy (T, 1, Pred (P)) + C + Copy (T, P, 255);
          If P <> Length (T) Then
            Send (GoXy (sx, _y));
        End Else Begin
          If P > Len Then Continue;
          Send (C);
          T [P] := C;
          If P = Succ (Length (T)) Then Inc (T [0]);
        End;
        Inc (P);
      End;
    End;
  Until hung;
  New := HexStrToLong (T);
End;

Function GetFieldToggle (qwe: byte; B1: longint; var B2: LongInt): Word;
Var
  sx: word;
  z: Boolean;
  i: word;
Begin
  z := b (b2, b1);
  sx := pred (_x);
  Repeat
    Send (GoXY (sx, _y));
    usercol (5);
    Case qwe of
      1: Send (' ' + PadLeft (OnOff [z], 4, ' '));
      2: Send (' ' + PadLeft (NoYes [z], 4, ' '));
      3: Send (' ' + PadLeft (TrueFalse [z], 6, ' '));
    End;

    i := readarrow;
    if hung then exit;
    case i of
      kEsc, kCtlZ: break;
      kEnter: begin i := kdown; break; end;
      kSpc: z := not z;
      kCtlN:break;
      kCtlB:break;
      kdown: break;
      kup: break;
      kT, kSftT: if qwe = 3 then z := true;
      kF, kSftF: if qwe = 3 then z := false;
      kY, kSftY: if qwe = 2 then z := true;
      kN, kSftN: if qwe = 2 then z := false;
    end;
  Until hung;
  if hung then exit;

  Send (GoXY (sx, _y));
  usercol (1);
  Case qwe of
    1: Send (' ' + PadLeft (OnOff [z], 4, ' '));
    2: Send (' ' + PadLeft (NoYes [z], 4, ' '));
    3: Send (' ' + PadLeft (TrueFalse [z], 6, ' '));
  End;
  getfieldtoggle := i;
  if z <> b (b2, b1) then b2 := b2 xor b1;
End;

Function GetToggle (pnt: toggletypeptr; max: byte; var B2: Byte): Word;
var
  i: word;
  sx: byte;
Begin
  sx := pred (_x);
  Repeat
    Send (GoXY (sx, _y));
    usercol (5);
    Send (' ' + pnt^ [b2] + ' ');
    usercol (1);
    Send (Rep (' ', 40 - Succ (Length (pnt^ [b2]))) + (GoXY (sx, _y)));

    i := readarrow;
    if hung then exit;
    case i of
      kEnter: begin i := kdown; break; end;
      kSpc: if b2 < max then
              inc (b2)
            else
              b2 := 1;
      kdown,
      kup,
      kctln,
      kCtlB,
      kEsc,
      kCtlZ: break;
    end;
  Until hung;
  if hung then exit;

  Send (GoXY (sx, _y));
  usercol (5);
  Send (' ' + PadLeft (pnt^ [b2], Succ (Length (pnt^ [b2])), ' '));
  gettoggle := i;
End;

function GetFieldBool (var B: Boolean): word;
Var
  sx: word;
  i: word;
Begin
  sx := pred (_x);
  Repeat
    comwriteat (sx, _y, '|UV ' + noyes [b] + ' |UR');

    i := readarrow;
    if hung then exit;
    case i of
      kEnter: begin i := kdown; break; end;
      kSpc: b := not b;
      kY, kSftY: b := true;
      kN, kSftN: b := false;
      kCtlZ,
      kEsc,
      kdown,
      kup,
      kctln,
      kCtlB: break;
    end;
  Until hung;
  getfieldbool := i;
End;

Constructor TableRec. Init;
Begin
  New (Items, Init);
  MaxTables := 0;
  MaxItems := 0;
  ha := 1;
  hx := 1;
  hy := 1;
  hl := 0;
  hfile := '';
End;

Procedure TableRec. AssignHelpFile (N: PathStr; X, Y, A, L: Byte);
Begin
  hfile := N;
  hx := x;
  hy := y;
  ha := a;
  hl := l;
End;

Procedure TableRec. AddItem (px, py: byte; hlpindx, l, l1, l2: longint; tip: tiptipe; data: Pointer);
var
  I: itemrec;
Begin
  with i do begin
    len := l;
    puty := py;
    putx := px;
    tipe := tip;
    hindex := hlpindx;
    case tip of
      tchar : begin
                cdata := data;
                chart := l1 <> 0;
              end;
      tstring:
              begin
                sdata := data;
                watch := l1;
                if watch = 3 then begin
                  sdata^ := fexpand (sdata^);
                  if sdata^ [length (sdata^)] <> '\' then
                    sdata^ := sdata^ + '\';
                end;
              end;
      tbyte:
            begin
              bdata := data;
              lobr := l1;
              hibr := l2;
            end;
      tinteger:
            begin
              idata := data;
              loir := l1;
              hiir := l2;
            end;
      tword:
            begin
              wdata := data;
              lowr := l1;
              hiwr := l2;
            end;
      thexb : hbdata := data;
      thexw : hwdata := data;
      tlongint:
            begin
              ldata := data;
              lolr := l1;
              hilr := l2;
            end;
      tphone: pdata := data;
      tdate: ddata := data;
      ttime: tdata := data;
      tonoff:
            begin
              odata := data;
              kind := l1;
            end;
      tbool: zdata := data;
      ttoggle:
            begin
              edata := data;
              pnt := ptr (l1, l2);
            end;
    end;
  end;

  items^. add (i, sizeof (itemrec));
  Inc (MaxItems);
End;

Procedure TableRec. Draw;
Var
  W: Word;
Begin
  For W := 1 to MaxItems do Begin

    With Items^ do
      GetNodeData (NodePtr (W), CurItemRec^);

    With CurItemRec^ do Begin
      ComWriteAt (pred (putX), putY, '|US');

      Case Tipe of
        tchar   : Send (' ' + cData^ + ' ');
        tString : Send (' ' + PadLeft (sData^, Succ (Len), ' '));
        tPhone  : Send (' ' + PadLeft (pData^, 13, ' '));
        tDate   : Send (' ' + datestr (dData^) + ' ');
        tTime   : Send (' ' + timestr (tData^) + ' ');
        tByte   : Send (' ' + PadLeft (IntToStr (bData^), Succ (Len), ' '));
        tInteger: Send (' ' + PadLeft (IntToStr (iData^), Succ (Len), ' '));
        tWord   : Send (' ' + PadLeft (IntToStr (wData^), Succ (Len), ' '));
        thexb   : Send (' ' + copy (hexw (hbData^), 3, 2));
        thexw   : Send (' ' + hexw (hwData^));
        tLongInt: Send (' ' + PadLeft (IntToStr (lData^), Succ (Len), ' '));
        tOnOff  : Case Kind of
                    1: Send (' ' + PadLeft (OnOff [Len And oData^ = Len], 4, ' '));
                    2: Send (' ' + PadLeft (NoYes [Len And oData^ = Len], 4, ' '));
                    3: Send (' ' + PadLeft (TrueFalse [Len And oData^ = Len], 6, ' '));
                  End;
        tBool   : Send (' ' + PadLeft (NoYes [zData^], 4, ' '));
        tToggle : Send (' ' + PadLeft (pnt^ [edata^], Succ (Length (pnt^ [edata^])), ' '));
      End;
    End;
  End;
End;

Function TableRec. Process (Num: Word): Word;
var
  new: longint;
  b: byte;
  s: string;
Begin
  With Items^ do
    GetNodeData (NodePtr (Num), CurItemRec^);
  With CurItemRec^ do Begin
    if hfile <> '' then begin
      {$I-}
      seek (helpfile, pred (hindex) * succ (hl));
      if ioresult <> 0 then ;
      blockread (helpfile, s[0], succ (hl));
      {$IFDEF Debug}{$I+}{$ENDIF}
      if ioresult = 0 then
        send (goxy (hx, hy) + attr (ha) + S + clr2eol)
      else
        send (goxy (hx, hy) + attr (ha) + clr2eol);
    end;
    Send (GoXy (putx, puty));
    Case Tipe of
      tChar   : Process := GetFieldChar (chart, cData^);
      tString : Case Watch of
                  0: Process := GetFieldStr (Len, false, false, False, false, False, sData^);
                  1: Process := GetFieldStr (Len, false, false, True, false, False, sData^);
                  2: Begin
                       Process := GetFieldStr (Len, false, false, true, true, false, sData^);
                       If hung Then Exit;
                       S := '';
                       For B := 65 to 90 do
                         If Pos (Chr (B), sData^) <> 0 Then
                           S := S + Chr (B);
                       sData^ := S;
                     End;
                  3: Begin
                       Process := GetFieldStr (Len, false, false, true, false, true, sData^);
                       sData^ := fExpand (sData^);
                       if sdata^ [length (sdata^)] <> '\' then
                         sdata^ := sdata^ + '\';
                     End;
                  4: Process := GetFieldStr (Len, false, true, false, false, False, sData^);
                  5: Process := GetFieldStr (Len, true, false, False, false, False, sData^);
                  6: begin
                       allowflagedit := true;
                       Process := GetFieldStr (Len, false, false, True, true, False, sData^);
                       allowflagedit := false;

                       s := '';
                       for b := 1 to length (sdata^) do
                         if pos (sdata^ [b], flagset) <> 0 then s := s + sdata^ [b];

                       sdata^ := '';
                       for b := 1 to 26 do
                         if pos (flagset [b], s) <> 0 then sdata^ := sdata^ + flagset [b];
                     end;
                  7: begin
                       allowflagedit := true;
                       Process := GetFieldStr (Len, false, false, True, false, False, sData^);
                       allowflagedit := false;
                     end;
                End;
      tPhone  :
                Begin
                  Repeat
                    Process := GetFieldLimStr (12, false, '0123456789-', pData^);
                    If hung Then Exit;
                    If ValidPhone (pData^) Then Break;
                    pData^ := '';
                    Send (GoXy (putx, puty));
                  Until hung;
                End;
      tDate   :
                Begin
                  s := datestr (ddata^);
                  Repeat
                    Process := GetFieldLimStr (8, false, '0123456789/', s);
                    If hung Then Exit;
                    If ValidDateStr (s) Then Break;
                    s := '';
                    Send (GoXy (putx, puty));
                  Until hung;
                  ddata^ := dateval (s);
                End;
      tTime   :
                Begin
                  s := timestr (ddata^);
                  Repeat
                    Process := GetFieldLimStr (8, false, '0123456789:', s);
                    If hung Then Exit;
                    If ValidTimeStr (s) Then Break;
                    s := '';
                    Send (GoXy (putx, puty));
                  Until hung;
                  ddata^ := timeval (s);
                End;
      tByte   :
                Begin
                  Process := GetFieldNum (Len, bData^, new);
                  If hung Then Exit;
                  if new > 255 then
                    new := 255
                  else if new < 0 then
                    new := 0;
                  bData^ := new;
                  If bData^ > hibr Then
                    bData^ := hibr
                  Else If bData^ < lobr Then
                    bData^ := lobr;
                End;
      tInteger:
                Begin
                  Process := GetFieldNum (Len, iData^, new);
                  If hung Then Exit;
                  if new > 32767 then
                    new := 32767
                  else if new < -32768 then
                    new := -32768;
                  iData^ := new;
                  If iData^ > hiir Then
                    iData^ := hiir
                  Else If iData^ < loir Then
                    iData^ := loir;
                End;
      tWord   :
                Begin
                  Process := GetFieldNum (Len, wData^, new);
                  If hung Then Exit;
                  if new > 65535 then
                    new := 65535
                  else if new < 0 then
                    new := 0;
                  wData^ := new;
                  If wData^ > hiwr Then
                    wData^ := hiwr
                  Else If wData^ < lowr Then
                    wData^ := lowr;
                End;
      thexb   :
                Begin
                  Process := GetFieldHex (2, hbData^, new);
                  If hung Then Exit;
                  hbData^ := new;
                End;
      thexw   :
                Begin
                  Process := GetFieldHex (4, hwData^, new);
                  If hung Then Exit;
                  hwData^ := new;
                End;
      tLongInt:
                Begin
                  Process := GetFieldNum (Len, lData^, new);
                  If hung Then Exit;
                  lData^ := new;
                  If lData^ > hilr Then
                    lData^ := hilr
                  Else If lData^ < lolr Then
                    lData^ := lolr;
                End;
      tOnOff  : Process := GetFieldToggle (Kind, Len, oData^);
      tBool   : Process := GetFieldBool (zData^);
      tToggle : Process := GetToggle (Pnt, Len, eData^);
    End;

    If hung Then Exit;
    ComWriteAt (Pred (PutX), Puty, '|US');

    Case Tipe of
      tChar   : Send (' ' + cData^ + ' ');
      tString : Send (' ' + PadLeft (sData^, Succ (Len), ' '));
      tPhone  : Send (' ' + PadLeft (pData^, 13, ' '));
      tDate   : Send (' ' + datestr (dData^) + ' ');
      tTime   : Send (' ' + timestr (tData^) + ' ');
      tByte   : Send (' ' + PadLeft (IntToStr (bData^), Succ (Len), ' '));
      tInteger: Send (' ' + PadLeft (IntToStr (iData^), Succ (Len), ' '));
      tWord   : Send (' ' + PadLeft (IntToStr (wData^), Succ (Len), ' '));
      thexb   : Send (' ' + copy (hexw (hbData^), 3, 2) + ' ');
      thexw   : Send (' ' + hexw (hwData^) + ' ');
      tLongInt: Send (' ' + PadLeft (IntToStr (lData^), Succ (Len), ' '));
      tOnOff  : Case Kind of
                  1: Send (' ' + PadLeft (OnOff [Len And oData^ = Len], 4, ' '));
                  2: Send (' ' + PadLeft (NoYes [Len And oData^ = Len], 4, ' '));
                  3: Send (' ' + PadLeft (TrueFalse [Len And oData^ = Len], 6, ' '));
                End;
      tBool   : Send (' ' + PadLeft (NoYes [zData^], 4, ' '));
      tToggle : Send (' ' + PadLeft (pnt^ [edata^], Succ (Length (pnt^ [edata^])), ' '));
    End;
  End;

  With Items^ do
    Change (NodePtr (Num), CurItemRec^, Sizeof (ItemRec));
End;

function TableRec. Run: shortint;
Begin
  If MaxItems = 0 Then Exit;
  GetMem (CurItemRec, Sizeof (ItemRec));
  Draw;
  CurItem := 1;
  if hfile <> '' then begin
    assign (helpfile, hfile);
    {$I-}
    reset (helpfile, 1);
    {$IFDEF Debug}{$I+}{$ENDIF}
    if ioresult <> 0 then hfile := '';
  end;

  run := 0;

  Repeat
    Case Process (CurItem) of
      kDown: If CurItem < MaxItems Then
              Inc (CurItem)
            Else
              CurItem := 1;
      kUp:  If CurItem > 1 Then
              Dec (CurItem)
            Else
              CurItem := MaxItems;
      kEsc, kCtlZ: Break;
      kCtlN: begin run := 1; break; end;
      kCtlB: begin run :=-1; break; end;
    End;
  Until hung;

  FreeMem (CurItemRec, Sizeof (ItemRec));
  if hfile <> '' then
    close (helpfile);
End;

Destructor TableRec. Done;
Begin
  Dispose (Items, Done);
End;

End.