Unit totWIN;
{$I Sys75.INC}

Interface

Uses DOS, CRT, totSYS, totLOOK, totINPUT, totFAST, totMISC;

Type

  StretchWinPtr = ^StretchWinOBJ;
  WinPtrArray  = Array[1..255] of StretchWinPtr;
  pWinPtrArray = ^WinPtrArray;

  pWinManObj = ^tWinManObj;
  tWinManObj = Object
                 Procedure Init;
                 Function  AddWin: Byte;
                 Procedure RemoveWin(WinNum: Byte);
                 Function  WinPntr(WinNum: Byte): StretchWinPtr;
                 Procedure Activate(WinNum: Byte);
                 Procedure Deactivate(WinNum: Byte);
                 Procedure CloseAll;
                 Procedure Done;
               Private
                 vNextWinNum,vNumWindows: Byte;
                 vActiveWin: Byte;
                 vWinPtrArray: pWinPtrArray;
               End;

  WinPtr = ^WinOBJ;
  pWinOBJ = ^WinOBJ;
  WinOBJ = Object
             vBorder: tCoords;
             vOuter: tCoords;
             vClose: Boolean;            {is close icon active}
             vUnderneathPtr: Pointer;    {ptr to saved screen}
             vSavedSize: LongInt;        {amount of memory saved}
             vTitle: String;             {window title}
             vActBorderAttr: Byte;       {active border attribute}
             vUnActBorderAttr: Byte;     {unactive border attribute}
             vActTitleAttr: Byte;        {active title attribute}
             vUnActTitleAttr: Byte;      {unactive title attribute}
             vBodyAttr: Byte;            {main text attribute}
             vActIconsAttr: Byte;        {active close and zoom icon attribute}
             vUnActIconsAttr: Byte;      {unactive close and zoom icon attribute}
             vStyle: Byte;               {border style}
             vRemove: Boolean;           {remove the window when done}
             vCursX: Byte;               {saved cursor location}
             vCursY: Byte;               {saved       -"-      }
             vCursTop: Byte;             {saved cursor size}
             vCursBot: Byte;             {saved     -"-    }
             vOldWin: tByteCoords;       {previous window coords}
             vOldWinConfine: Boolean;    {were window coords active}
             vMVisible: Boolean;         {was mouse visible}
             vFillWin: Boolean;          {clear window core when redrawn}
             vWinRestrict: Boolean;      {are windows coords relative to border}
             vShadow: Boolean;
             Constructor Init;
             Procedure   SetSize (X1, Y1, X2, Y2, Style: Byte);
             Procedure   SetTitle (Title: String);
             Procedure   UpdateTitle (Title: String);
             Procedure   SetColors (ActBorder, UnActBorder, Body, ActTitle,
                                    UnActTitle, ActIcons, UnActIcons: Byte);
             Procedure   SetRemove (On: Boolean);
             Procedure   SetClose (On: Boolean);
             Procedure   SetWinRestrict (On: Boolean);
             Procedure   SetShadow (On: Boolean);
             Procedure   SetWindow;
             Procedure   GetSize (Var X1, Y1, X2, Y2, Style: Byte);
             Function    GetX: Byte;
             Function    GetY: Byte;
             Function    GetStyle: Byte;
             Function    GetBorderAttr(Active:Boolean):Byte;
             Function    GetTitleAttr(Active:Boolean): Byte;
             Function    GetIconsAttr(Active:Boolean): Byte;
             Function    GetBodyAttr: Byte;
             Function    GetRemoveStatus: Boolean;
             Procedure   Save;
             Procedure   PartSave (X1, Y1, X2, Y2: Byte; Var Dest);
             Procedure   PartRestore (X1, Y1, X2, Y2: Byte; Var Source);
             Procedure   ComputeSavedCoords;
             Procedure   DrawCore;
             Procedure   GrowDraw;
             Procedure   Remove;
             Procedure   WinGetKey (Var K: Word; Var X, Y: Byte);
             Procedure   SetBoundary (X1, Y1, X2, Y2: Byte);        Virtual;
             Procedure   WinKey (Var K: Word; Var X, Y: Byte);      Virtual;
             Procedure   Draw;                                      Virtual;
             Destructor  Done;                                      Virtual;
           End; {WinOBJ}

  MoveWinPtr = ^MoveWinOBJ;
  pMoveWinOBJ = ^MoveWinOBJ;
  MoveWinOBJ = Object (WinOBJ)
                 vBoundary: tCoords;       {max area in which window can move}
                 vMoveKey: Word;
                 vAllowMove: Boolean;
                 {methods...}
                 Constructor Init;
                 Procedure   SetMoveKey (K: Word);
                 Procedure   SetAllowMove (On: Boolean);
                 Procedure   BuildBackground (Var BackScr: ScreenOBJ);
                 Procedure   RemoveShadow (Var OriginalScreen: ScreenOBJ);
                 Procedure   RefreshUnderneath (BackScr: ScreenOBJ);
                 Procedure   WMove (UsingMouse: Boolean; OldX, OldY: Byte);
                 Procedure   WinKey (Var K: Word; Var X, Y: Byte);  Virtual;
                 Procedure   SetBoundary (X1, Y1, X2, Y2: Byte);    Virtual;
                 Destructor  Done;                                  Virtual;
               End; {MoveWinOBJ}

  pScrollWinOBJ = ^ScrollWinOBJ;
  ScrollWinOBJ = Object (MoveWinOBJ)
                   vScrollV: Boolean;       {show vertical scroll bar}
                   vScrollH: Boolean;       {show horizontal scroll bar}
                   {methods ...}
                   Constructor Init;
                   Procedure   SetScrollable (Vert, Horiz: Boolean);
                   Procedure   DrawHorizBar (Current, Max: LongInt);
                   Procedure   DrawVertBar (Current, Max: LongInt);
                   Procedure   Winkey (Var K: Word; Var X, Y: Byte);Virtual;
                   Procedure   Draw;                                Virtual;
                   Destructor  Done;                                Virtual;
                 End; {ScrollWinOBJ}

  pStretchWinOBJ = ^StretchWinOBJ;
  StretchWinOBJ = Object (ScrollWinOBJ)
                    vZoomed: Boolean;        {is window zoomed at present}
                    vPreZoom: tCoords;       {size of window in Unzoomed state}
                    vMinWidth: Byte;         {min width of SmartWin}
                    vMinDepth: Byte;         {min depth of SmartWin}
                    vStretchKey: Word;       {keycode for manual stretch}
                    vZoomKey: Word;          {keycode for zoom}
                    vAllowStretch: Boolean;  {is user allowed to stretch}
                    vSmartStretch: Boolean;  {refresh window during stretch}
                    {methods ...}
                    Constructor Init;
                    Procedure   SetMinSize (Width, depth: Byte);
                    Procedure   Stretch (UsingMouse: Boolean; OldX, OldY: Byte);
                    Procedure   SetAllowStretch (On: Boolean);
                    Procedure   ToggleZoom;
                    Procedure   Refresh;
                    Procedure   StretchRefresh;                       Virtual;
                    Procedure   Winkey (Var K: Word; Var X, Y: Byte); Virtual;
                    Procedure   Draw;                                 Virtual;
                    Destructor  Done;                                 Virtual;
                  End; {StretchWinOBJ}

Var
  WinMan: tWinManObj;

Implementation

{|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||}
{                                                               }
{     U N I T   P R O C E D U R E S   &   F U N C T I O N S     }
{                                                               }
{|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||}

Procedure Error (Err: Byte);
Begin
  If Err In [1, 3] Then
    Halt (8)
  Else
    Halt (10);
End;

{||||||||||||||||||||||||||||||||||||}
{                                    }
{    W i n M a n   M E T H O D S     }
{                                    }
{||||||||||||||||||||||||||||||||||||}

Procedure tWinManObj.Init;
Begin
  vNumWindows:=0;
  vActiveWin:=0;
  New(vWinPtrArray);
  FillChar(vWinPtrArray^,1020,0);
End;

Function tWinManObj.AddWin: Byte;
Var
  Temp:Byte;
  Dune: Boolean;
Begin
  Dune:=False;
  If vNumWindows = 255 Then Exit;
  Inc(vNumWindows);
  For Temp := 1 to 255 do
    If vWinPtrArray^[Temp] = Nil Then Begin
      If Not Dune Then Begin
        Dune:=True;
        New(vWinPtrArray^[Temp], Init);
        AddWin:=Temp;
      End;
    End Else Deactivate(Temp);
End;

Procedure tWinManObj.RemoveWin(WinNum: Byte);
Begin
  If vNumWindows = 0 Then Exit;
  Dispose(vWinPtrArray^[WinNum],Done);
  Dec(vNumWindows);
End;

Function tWinManObj.WinPntr(WinNum: Byte): StretchWinPtr;
Begin
  WinPntr := vWinPtrArray^[WinNum];
End;

Procedure tWinManObj.Activate(WinNum: Byte);
Var
  WasOn: Boolean;
  W, D: Byte;
  SmartWinImagePtr : Pointer;
  Procedure CaptureSmartWin;
  {saves image of window}
  Var I : Integer;
  Begin
    With vWinPtrArray^[WinNum]^.vBorder do
    Begin
      GetMem (SmartWinImagePtr, W * D * 2);
      Screen^. PartSave (Succ(X1), Succ(Y1), Pred(X2), Pred(Y2), SmartWinImagePtr^);
    End;
  End; {CaptureSmartWin}

  Procedure RestoreSmartWin;
  {}
  Begin
    With vWinPtrArray^[WinNum]^.vBorder do
      Screen^. PartRestore (Succ(X1), Succ(Y1), Pred(X2), Pred(Y2), SmartWinImagePtr^);
  End; {RestoreSmartWin}

  Procedure DisposeSmartWin;
  {}
  Begin
    FreeMem (SmartWinImagePtr, W * D * 2);
  End; {DisposeSmartWin}

Begin
 With vWinPtrArray^[WinNum]^ do Begin
  With vBorder do
  Begin
    W := Pred (X2 - X1);
    D := Pred (Y2 - Y1);
  End;
  CaptureSmartWin;
  WasOn := Screen^. WindowOff;
  If vClose Then
  Begin
    With vBorder do
    Begin
      Screen^. BoxEngine (X1, Y1, X2, Y2, 4, 4, vActBorderAttr, vActTitleAttr,
                         vBodyAttr, vStyle, True, vTitle);
      Screen^. WriteAT (X1 + 2, Y1, vActBorderAttr, '[ ]');
      Screen^. WriteAT (X1 + 3, Y1, vActIconsAttr, '');
    End;
  End
  Else
    With vBorder do
      Screen^. BoxEngine (X1, Y1, X2, Y2, 0, 4, vActBorderAttr, vActTitleAttr,
                         vBodyAttr, vStyle, True, vTitle);
  If vAllowStretch Then
  Begin
    Screen^. WriteAT (vBorder. X2 - 4, vBorder. Y1, vActBorderAttr, '[ ]');
    If Not vZoomed Then
      Screen^. WriteAT (vBorder. X2 - 3, vBorder. Y1, vActIconsAttr, '')
    Else
      Screen^. WriteAT (vBorder. X2 - 3, vBorder. Y1, vActIconsAttr, '');
  End;
  SetWindow;
  vActiveWin := WinNum;
  RestoreSmartWin;
  DisposeSmartWin;
 End;
End;

Procedure tWinManObj.Deactivate(WinNum: Byte);
Var
  WasOn: Boolean;
  W, D: Byte;
  SmartWinImagePtr : Pointer;
  Procedure CaptureSmartWin;
  {saves image of window}
  Var I : Integer;
  Begin
    With vWinPtrArray^[WinNum]^.vBorder do
    Begin
      GetMem (SmartWinImagePtr, W * D * 2);
      Screen^. PartSave (Succ(X1), Succ(Y1), Pred(X2), Pred(Y2), SmartWinImagePtr^);
    End;
  End; {CaptureSmartWin}

  Procedure RestoreSmartWin;
  {}
  Begin
    With vWinPtrArray^[WinNum]^.vBorder do
      Screen^. PartRestore (Succ(X1), Succ(Y1), Pred(X2), Pred(Y2), SmartWinImagePtr^);
  End; {RestoreSmartWin}

  Procedure DisposeSmartWin;
  {}
  Begin
    FreeMem (SmartWinImagePtr, W * D * 2);
  End; {DisposeSmartWin}

Begin
 With vWinPtrArray^[WinNum]^ do Begin
  With vBorder do
  Begin
    W := Pred (X2 - X1);
    D := Pred (Y2 - Y1);
  End;
  CaptureSmartWin;
  WasOn := Screen^. WindowOff;
  If vClose Then
  Begin
    With vBorder do
    Begin
      Screen^. BoxEngine (X1, Y1, X2, Y2, 4, 4, vUnActBorderAttr, vUnActTitleAttr,
                         vBodyAttr, vStyle, True, vTitle);
      Screen^. WriteAT (X1 + 2, Y1, vUnActBorderAttr, '[ ]');
      Screen^. WriteAT (X1 + 3, Y1, vUnActIconsAttr, '');
    End;
  End
  Else
    With vBorder do
      Screen^. BoxEngine (X1, Y1, X2, Y2, 0, 4, vUnActBorderAttr, vUnActTitleAttr,
                         vBodyAttr, vStyle, True, vTitle);
  If vAllowStretch Then
  Begin
    Screen^. WriteAT (vBorder. X2 - 4, vBorder. Y1, vUnActBorderAttr, '[ ]');
    If Not vZoomed Then
      Screen^. WriteAT (vBorder. X2 - 3, vBorder. Y1, vUnActIconsAttr, '')
    Else
      Screen^. WriteAT (vBorder. X2 - 3, vBorder. Y1, vUnActIconsAttr, '');
  End;
  SetWindow;
  vActiveWin := 0;
  RestoreSmartWin;
  DisposeSmartWin;
 End;
End;

Procedure tWinManObj.CloseAll;
Var
  Temp:Byte;
Begin
  For Temp:=1 to 255 do
    If vWinPtrArray^[Temp] <> Nil Then RemoveWin(Temp);
  vNumWindows:=0;
End;

Procedure tWinManObj.Done;
Begin
  CloseAll;
  Dispose(vWinPtrArray);
End;


{||||||||||||||||||||||||||||||||||||}
{                                    }
{    W i n O B J   M E T H O D S     }
{                                    }
{||||||||||||||||||||||||||||||||||||}

Constructor WinOBJ. Init;
{}
Begin
  SetSize (10, 5, 70, 20, 1);
  SetTitle ('');
  SetRemove (True);
  With LookTOT^ do
    SetColors (WinBorder(True), WinBorder(False), WinBody, WinTitle(True),
               WinTitle(False), WinIcons(True), WinIcons(False));
  vUnderneathPtr := Nil;
  vMVisible := True;
  vClose := True;
  vFillWin := True;
  vWinRestrict := True;
  vShadow := True;
End; {of const WinOBJ.Init}

Procedure WinOBJ. SetSize (X1, Y1, X2, Y2, Style: Byte);
{}
Begin
  {$IFDEF CHECK}
  If (X2 < X1 + 2)
     Or (Y2 < Y1 + 2)
     Or (Y2 > Screen^. Depth)
     Or (X2 > Screen^. Width)
  Then
    Error (2);
  {$ENDIF}
  vBorder. X1 := X1;
  vBorder. Y1 := Y1;
  vBorder. X2 := X2;
  vBorder. Y2 := Y2;
  vStyle := Style;
End; {WinOBJ.SetSize}

Procedure WinOBJ. GetSize (Var X1, Y1, X2, Y2, Style: Byte);
{}
Begin
  X1 := vBorder. X1;
  Y1 := vBorder. Y1;
  X2 := vBorder. X2;
  Y2 := vBorder. Y2;
  Style := vStyle;
End; {WinOBJ.GetSize}

Function WinOBJ. GetX: Byte;
{}
Begin
  GetX := vBorder. X1;
End; {WinOBJ.GetX}

Function WinOBJ. GetY: Byte;
{}
Begin
  GetY := vBorder. Y1;
End; {WinOBJ.GetY}

Function WinOBJ. GetStyle: Byte;
{}
Begin
  GetStyle := vStyle;
End; {WinOBJ.GetStyle}

Function WinOBJ. GetBorderAttr(Active:Boolean):Byte;
{}
Begin
  If Active Then GetBorderAttr := vActBorderAttr
  Else GetBorderAttr := vUnactBorderAttr;
End; {WinOBJ.GetBorderAttr}

Function WinOBJ. GetTitleAttr(Active:Boolean): Byte;
{}
Begin
  If Active Then GetTitleAttr := vActTitleAttr
  Else GetTitleAttr := vUnactTitleAttr;
End; {WinOBJ.GetTitleAttr}

Function WinOBJ. GetBodyAttr: Byte;
{}
Begin
  GetBodyAttr := vBodyAttr;
End; {WinOBJ.GetBodyAttr}

Function WinOBJ. GetIconsAttr(Active:Boolean): Byte;
{}
Begin
  If Active Then GetIconsAttr := vActIconsAttr
  Else GetIconsAttr := vUnactIconsAttr;
End; {WinOBJ.GetIconsAttr}

Procedure WinOBJ. SetRemove (On: Boolean);
{}
Begin
  vRemove := On;
End; {Window.SetRemove}

Procedure WinOBJ. SetClose (On: Boolean);
{}
Begin
  vClose := On;
End; {WinOBJ.SetClose}

Procedure WinOBJ. SetWinRestrict (On: Boolean);
{}
Begin
  vWinRestrict := On;
End; {WinOBJ.SetWinRestrict}

Procedure WinOBJ. SetShadow (On: Boolean);
{}
Begin
  vShadow := On;
End; {WinOBJ.SetWinRestrict}

Function WinOBJ. GetRemoveStatus: Boolean;
{}
Begin
  GetRemoveStatus := vRemove;
End; {WinOBJ.GetRemoveStatus}

Procedure WinOBJ. SetTitle (Title: String);
{}
Begin
  vTitle := Title;
End; {WinOBJ.SetTitle}

Procedure WinOBJ. UpdateTitle (Title: String);
{}
Begin
  vTitle := Title;
  Screen^. SetWinIgnore (True);
  With vBorder do Begin
    Screen^. WriteAt (Succ (X1), Y1, vActBorderAttr, Replicate (X2 - X1 - 2, ''));
    Screen^. WriteBetween (Succ (X1), Pred (X2), Y1, vActTitleAttr, vTitle);
  End;
  Screen^. SetWinIgnore (False);
End; {WinOBJ.UpdateTitle}

Procedure WinOBJ. SetColors (ActBorder, UnActBorder, Body, ActTitle, UnActTitle,
                             ActIcons, UnActIcons: Byte);
Begin
  If ActBorder <> 0 Then
    vActBorderAttr := ActBorder;
  If UnActBorder <> 0 Then
    vUnActBorderAttr := UnActBorder;
  If ActTitle <> 0 Then
    vActTitleAttr := ActTitle;
  If UnActTitle <> 0 Then
    vUnActTitleAttr := UnActTitle;
  If Body <> 0 Then
    vBodyAttr := Body;
  If ActIcons <> 0 Then
    vActIconsAttr := ActIcons;
  If UnActIcons <> 0 Then
    vUnActIconsAttr := UnActIcons;
End; {WinOBJ.SetColors}

Procedure WinOBJ. SetBoundary (X1, Y1, X2, Y2: Byte);
{abstract}
Begin End;

Procedure WinOBJ. ComputeSavedCoords;
{checks shodow position and style and computes saved screen coords}
Begin
  If vShadow Then
    ShadowTOT^. OuterCoords (vBorder, vOuter)
  Else
    vOuter := vBorder;
End; {WinOBJ.ComputeSavedCoords}

Procedure WinOBJ. SetWindow;
{}
Begin
  If vWinRestrict Then {1.00b}
    With vBorder do
      Case vStyle Of
        0: Screen^. SetWindow (X1, Y1, X2, Y2);
        6: Screen^. SetWindow (Succ (X1), Y1 + 3, Pred (X2), Y2);
        Else Screen^. SetWindow (Succ (X1), Succ (Y1), Pred (X2), Pred (Y2) );
      End; {case}
End; {WinOBJ.SetWindow}

Procedure WinOBJ. Save;
{}
Var
  MemoryNeeded: LongInt;
Begin
  ComputeSavedCoords;
  MemoryNeeded := Succ (vOuter. X2 - vOuter. X1) * Succ (vOuter. Y2 - vOuter. Y1) * 2;
  If MaxAvail < MemoryNeeded Then
    Error (1)
  Else Begin
    If vUnderneathPtr <> Nil Then
    Begin
      FreeMem (vUnderneathPtr, vSavedSize);
      vUnderneathPtr := Nil;
    End;
    GetMem (vUnderneathPtr, MemoryNeeded);
    PartSave (vOuter. X1, vOuter. Y1, vOuter. X2, vOuter. Y2, vUnderneathPtr^);
    vSavedSize := MemoryNeeded;
    vCursX := Screen^. WhereX;
    vCursY := Screen^. WhereY;
    Screen^. CursSave;
    vCursTop := Screen^. CursTop;
    vCursBot := Screen^. CursBot;
    Screen^. WindowCoords (vOldWin);
    vOldWinConfine := Screen^. WindowActive;
  End;
End; {WinOBJ.Save}

Procedure WinOBJ. DrawCore;
{}
Begin
  If (vStyle in [1..5] ) And vClose Then
  Begin
    With vBorder do
    Begin
      Screen^. BoxEngine (X1, Y1, X2, Y2, 4, 4, vActBorderAttr, vActTitleAttr,
                         vBodyAttr, vStyle, vFillWin, vTitle);
      Screen^. WriteAT (X1 + 2, Y1, vActBorderAttr, '[ ]');
      Screen^. WriteAT (X1 + 3, Y1, vActIconsAttr, '');
    End;
  End
  Else
    With vBorder do
      Screen^. BoxEngine (X1, Y1, X2, Y2, 0, 0, vActBorderAttr, vActTitleAttr,
                         vBodyAttr, vStyle, vFillWin, vTitle);
  If (vStyle = 6) And vClose Then
    With vBorder do
      Screen^. WriteAT (X1 + 3, Y1, vActIconsAttr, '');
End; {WinOBJ.DrawCore}

Procedure WinOBJ. Draw;
{}
Var WasOn: Boolean;
Begin
  Save;
  WasOn := Screen^. WindowOff;
  If vShadow Then ShadowTOT^. DrawShadow (vBorder);
  DrawCore;
  SetWindow;
End; {WinOBJ.Draw}

Procedure WinOBJ. GrowDraw;
{}
Var
  I, TX1, TY1, TX2, TY2, Ratio : Integer;
  WasOn: Boolean;
Begin
  Save;
  WasOn := Screen^. WindowOff;
  With vBorder do
  Begin
    If 2 * (Y2 - Y1 + 1) > X2 - X1 + 1 Then
      Ratio :=   2
    Else
      Ratio :=  1;
    TX2 := (X2 - X1) Div 2 + X1 + 2;
    TX1 := TX2 - 3;                 {needs a box 3 by 3 minimum}
    TY2 := (Y2 - Y1) Div 2 + Y1 + 2;
    TY1 := TY2 - 3;
    If (X2 - X1) < 3 Then
    Begin
      TX2 := X2;
      TX1 := X1;
    End;
    If (Y2 - Y1) < 3 Then
    Begin
      TY2 := Y2;
      TY1 := Y1;
    End;
    Repeat
      Screen^. PartClear (TX1, TY1, TX2, TY2, vBodyAttr, ' ');
      If TX1 >= X1 + (1 * Ratio) Then
        TX1 := TX1 - (1 * Ratio)
      Else
        TX1 := X1;
      If TY1 > Y1  Then
        TY1 := TY1 - 1;
      If TX2 + (1 * Ratio) <= X2 Then
        TX2 := TX2 + (1 * Ratio)
      Else
        TX2 := X2;
      If TY2 + 1 <= Y2 Then
        TY2 := TY2 + 1;
      Delay (4);
    Until (TX1 = X1) And (TY1 = Y1) And (TX2 = X2) And (TY2 = Y2);
    DrawCore;
  End;
  If vShadow Then ShadowTOT^. DrawShadow (vBorder);
  SetWindow;
End; {WinOBJ.GrowDraw}

Procedure WinOBJ. PartSave (X1, Y1, X2, Y2: Byte; Var Dest);
{}
Var
  I, w : Byte;
  Wid : Word;
  ScreenAdr: Integer;
  Pntr: Pointer;
  Mvisible: Boolean;
Begin
  w := Succ (X2 - X1);
  Pntr := Screen^. ScreenPtr;
  Wid := Monitor^. Width * 2;
  for I :=  Y1 to Y2 do
  Begin
    ScreenAdr := Pred (I) * Wid + Pred (X1) * 2;
    Screen^. MoveFromScreen (Mem [Seg (Pntr^): Ofs (Pntr^) + ScreenAdr],
    Mem [Seg (Dest): Ofs (dest) + (I - Y1) * w * 2], w);
  End;
End; {WinOBJ.PartSave}

Procedure WinOBJ. PartRestore (X1, Y1, X2, Y2: Byte; Var Source);
{}
Var
  I, w : Byte;
  Wid: Word;
  ScreenAdr: Integer;
  Pntr: Pointer;
  Mvisible: Boolean;
Begin
  w := Succ (X2 - X1);
  Pntr := Screen^. ScreenPtr;
  Wid := Monitor^. Width * 2;
  for I :=  Y1 to Y2 do
  Begin
    ScreenAdr := Pred (I) * Wid + Pred (X1) * 2;
    Screen^. MoveToScreen (Mem [Seg (Source): Ofs (Source) + (I - Y1) * w * 2],
    Mem [Seg (Pntr^): Ofs (Pntr^) + ScreenAdr],
    w);
  End;
End; {WinOBJ.PartRestore}

Procedure WinOBJ. Remove;
{}
Begin
  If vUnderneathPtr <> Nil Then
  Begin
    PartRestore (vOuter. X1, vOuter. Y1, vOuter. X2, vOuter. Y2, vUnderneathPtr^);
    FreeMem (vUnderneathPtr, vSavedSize);
    vUnderneathPtr := Nil;
    If vOldWinConfine Then
      With vOldWin do
        Screen^. SetWindow (X1, Y1, X2, Y2)
    Else
      Screen^. ResetWindow;
    Screen^. GotoXY (vCursX, vCursY);
    Screen^. CursSize (vCursTop, vCursBot);
  End;
End; {WinOBJ.Remove}

Procedure WinOBJ. WinGetKey (Var K: Word; Var X, Y: Byte);
{}
Begin
  With key^ do
  Begin
    key^. GetInput;
    K := key^. LastKey;
    WinKey (K, X, Y);
  End;
End; {WinOBJ.WinGetKey}

Procedure WinOBJ. WinKey (Var K: Word; Var X, Y: Byte);
{}
Begin
  If  (K = 513) And (Y = vBorder. Y1)
      And (X = vBorder. X1 + 3) And vClose
  Then
  Begin
    Remove;
    K := 600;  {Closed}
    key^. vLastKey := K;  {1.00e}
  End;
End; {WinOBJ.WinKey}

Destructor WinOBJ. Done;
{}
Begin
  If (vRemove) And (vUnderneathPtr <> Nil)  Then
    Remove;
  If vUnderneathPtr <> Nil Then
    FreeMem (vUnderneathPtr, vSavedSize);
End; {WinOBJ.Done}

{||||||||||||||||||||||||||||||||||||||||||||}
{                                            }
{    M o v e W i n O B J   M E T H O D S     }
{                                            }
{||||||||||||||||||||||||||||||||||||||||||||}

Constructor MoveWinOBJ. Init;
{}
Begin
  WinOBJ. Init;
  vAllowMove := True;
  vMoveKey := LookTOT^. WinMoveKey;
  SetBoundary (1, 1, Monitor^. Width, Monitor^. Depth);
End; {MoveWinOBJ.Init}

Procedure MoveWinOBJ. SetMoveKey (K: Word);
{}
Begin
  vMoveKey := K; {1.00d}
End; {MoveWinOBJ.SetMoveKey}

Procedure MoveWinOBJ. SetBoundary (X1, Y1, X2, Y2: Byte);
{}
Begin
  vBoundary. X1 := X1;
  vBoundary. Y1 := Y1;
  vBoundary. X2 := X2;
  vBoundary. Y2 := Y2;
End; {MoveWinOBJ.SetBoundary}

Procedure MoveWinOBJ. BuildBackground (Var BackScr: ScreenOBJ);
{saves the screen and replaces the contents of the screen
 where the window lies with the image saved behind the window.
}
Var
  I, w : Byte;
  Wid : Word;
  ImageAdr: Integer;
  Pntr: Pointer;
Begin
  BackScr. Save;    {save current screen}
  w := Succ (vOuter. X2 - vOuter. X1);
  Pntr := BackScr. ScreenPtr;
  Wid := Monitor^. Width * 2;
  for I :=  vOuter. Y1 to vOuter. Y2 do
  Begin
    ImageAdr := Pred (I) * Wid + Pred (vOuter. X1) * 2;
    Move (Mem [Seg (vUnderneathPtr^): Ofs (vUnderneathPtr^) + (I - vOuter. Y1) * w * 2],
    Mem [Seg (Pntr^): Ofs (Pntr^) + ImageAdr],
    w * 2);
  End;
End; {MoveWinOBJ.BuildBackground}

Procedure MoveWinOBJ. RefreshUnderneath (BackScr: ScreenOBJ);
{Takes image from saved screen and moves it to the window's saved
 image at UnderneathPtr.
}
Var
  I, w : Byte;
  Wid : Word;
  ImageAdr: Integer;
  Pntr: Pointer;
Begin
  {dispose of window memory, and get required memory}
  FreeMem (vUnderneathPtr, vSavedSize);
  w := Succ (vOuter. X2 - vOuter. X1);
  vSavedSize := Succ (vOuter. Y2 - vOuter. Y1) * W * 2;
  GetMem (vUnderneathPtr, vSavedSize);
  Pntr := BackScr. ScreenPtr;
  Wid := Monitor^. Width * 2;
  for I :=  vOuter. Y1 to vOuter. Y2 do
  Begin
    ImageAdr := Pred (I) * Wid + Pred (vOuter. X1) * 2;
    Move (Mem [Seg (Pntr^): Ofs (Pntr^) + ImageAdr],
    Mem [Seg (vUnderneathPtr^): Ofs (vUnderneathPtr^) + (I - vOuter. Y1) * w * 2],
    w * 2);
  End;
End; {MoveWinOBJ.RefreshUnderneath}

Procedure MoveWinOBJ. RemoveShadow (Var OriginalScreen: ScreenOBJ);
{}
Begin
  If vOuter. X1 < vBorder. X1 Then   {shadowleft}
    OriginalScreen. PartDisplay (vOuter. X1, vOuter. Y1, Pred (vBorder. X1), vOuter. Y2, vOuter. X1, vOuter. Y1);
  If vOuter. X2 > vBorder. X2 Then   {shadowright}
    OriginalScreen. PartDisplay (Succ (vBorder. X2), vOuter. Y1, vOuter. X2, vOuter. Y2, Succ (vBorder. X2), vOuter. Y1);
  If vOuter. Y1 < vBorder. Y1 Then   {shadowUp}
    OriginalScreen. PartDisplay (vOuter. X1, vOuter. Y1, vOuter. X2, Pred (vBorder. Y1), vOuter. X1, vOuter. Y1);
  If vOuter. Y2 > vBorder. Y2 Then  {shadowDown}
    OriginalScreen. PartDisplay (vOuter. X1, Succ (vBorder. Y2), vOuter. X2, vOuter. Y2, vOuter. X1, Succ (vBorder. Y2) );
End; {MoveWinOBJ.RemoveShadow}

Procedure MoveWinOBJ. WMove (UsingMouse: Boolean; OldX, OldY: Byte);
Var
  Mvisible,
  WasOn,
  Left, Center, Right : Boolean;
  X, Y : Byte;
  DeltaX, DeltaY : ShortInt;
  ScrPtr,
  OldPtr,
  SmartWinImagePtr : Pointer;
  Wid: Word;
  CTop, CBot, CX, CY: Byte;
  W, D: Byte;
  OldLocation : tCoords;
  OriginalScreen: ScreenOBJ;

  Procedure CaptureSmartWin;
  {saves image of window}
  Var I : Integer;
  Begin
    With vBorder do
    Begin
      GetMem (SmartWinImagePtr, W * D * 2);
      Screen^. PartSave (X1, Y1, X2, Y2, SmartWinImagePtr^);
    End;
  End; {CaptureSmartWin}

  Procedure RestoreSmartWin;
  {}
  Begin
    With vBorder do
      Screen^. PartRestore (X1, Y1, X2, Y2, SmartWinImagePtr^);
  End; {RestoreSmartWin}

  Procedure DisposeSmartWin;
  {}
  Begin
    FreeMem (SmartWinImagePtr, W * D * 2);
  End; {DisposeSmartWin}

  Procedure FastRestore (X1, Y1, X2, Y2: Byte);
  {}
  Var
    I, w : Byte;
    ScreenAdr: Integer;
  Begin
    If (X1 > X2) Or (Y1 > Y2) Then
      Exit;
    w := Succ (X2 - X1);
    for I :=  Y1 to Y2 do
    Begin
      ScreenAdr := Pred (I) * Wid + Pred (X1) * 2;
      Screen^. MoveToScreen (Mem [Seg (OldPtr^): Ofs (OldPtr^) + ScreenAdr],
      Mem [Seg (ScrPtr^): Ofs (ScrPtr^) + ScreenAdr], w);
    End;
  End; {FastRestore}

Begin
  With vBorder do
  Begin
    W := Succ (X2 - X1);
    D := Succ (Y2 - Y1);
  End;
  If MaxAvail < W * D * 2 + Screen^. Width * Screen^. Depth * 2 Then
  Begin
    Beep;
    Exit;
  End;
  With Screen^ do
  Begin
    CursSave;
    CX := Screen^. WhereX;
    CY := Screen^. WhereY;
    CTop := CursTop;
    CBot := CursBot;
    CursOff;
  End;
  OriginalScreen. Init;
  BuildBackground (OriginalScreen);
  ScrPtr :=  Monitor^. BaseOfScreen;         {1.00a}
  OldPtr := OriginalScreen. ScreenPtr;
  Wid := Monitor^. Width * 2;
  CaptureSmartWin;
  RemoveShadow (OriginalScreen);
  Repeat
    Begin
      With Key^ do
      Begin
        OldX := 20;
        OldY := 20;
        Y := 20;
        X := 20;
        GetInput;
        Case key^. LastKey Of
          328: Dec (Y); {up}
          336: Inc (Y); {down}
          333: Inc (X); {right}
          331: Dec (X); {left}
        End; {case}
        Left := True;
      End;
    End;
    If Left And ( (X <> OldX) Or (Y <> OldY) ) Then  {move window}
    Begin
      OldLocation := vOuter;
      If (X <> OldX) Then
      Begin
        DeltaX := X - OldX;
        If  (DeltaX + vBorder. X1 >= vBoundary. X1)
            And (DeltaX + vBorder. X2 <= vBoundary. X2)
        Then
        Begin
          vBorder. X1 := vBorder. X1 + DeltaX;
          vBorder. X2 := vBorder. X2 + DeltaX;
        End
        Else DeltaX := 0;
      End
      Else
        DeltaX := 0;
      If (Y <> OldY) Then
      Begin
        DeltaY := Y - OldY;
        If  (DeltaY + vBorder. Y1 >= vBoundary. Y1)
            And (DeltaY + vBorder. Y2 <= vBoundary. Y2)
        Then
        Begin
          vBorder. Y1 := vBorder. Y1 + DeltaY;
          vBorder. Y2 := vBorder. Y2 + DeltaY;
        End
        Else
          DeltaY := 0;
      End
      Else
        DeltaY := 0;
      ComputeSavedCoords;
      RestoreSmartWin;
      If DeltaX > 0 Then {viewport moved right}
        FastRestore (OldLocation. X1, vOuter. Y1, Pred (vBorder. X1), vOuter. Y2)
      Else If DeltaX < 0 Then {viewport moved left}
        FastRestore (Succ (vBorder. X2), vBorder. Y1, OldLocation. X2, vOuter. Y2);
      If DeltaY > 0 Then {Viewport moved down}
        FastRestore (OldLocation. X1, OldLocation. Y1, vBorder. X2, Pred (vBorder. Y1) )
      Else If deltaY < 0 Then {Viewport moved up}
        FastRestore (OldLocation. X1, Succ (vBorder. Y2), vBorder. X2, OldLocation. Y2);
      If DeltaX < 0 Then    {moved left}
      Begin
        If (DeltaY > 0) Then
          FastRestore (Succ (vBorder. X1), OldLocation. Y1, Oldlocation. X2, Pred (vBorder. Y1) )
        Else
          FastRestore (Succ (vBorder. X2), Succ (vOuter. Y2), Oldlocation. X2, OldLocation. Y2);
      End;
      OldX := X;
      OldY := Y;
    End; {if}
  Until (UsingMouse And (Left = False) ) Or ( ( (key^. LastKey = 13) Or (key^. LastKey = 27) ) And (UsingMouse = False) );
  WasOn := Screen^. WindowOff;
  ShadowTOT^. DrawShadow (vBorder);
  Screen^. WindowOn;
  {now save new background behind window}
  RefreshUnderneath (OriginalScreen);
  SetWindow;
  Screen^. GotoXY (CX, CY);
  Screen^. CursSize (CTop, CBot);
  OriginalScreen. Done;
  DisposeSmartWin;
End; {MoveWinOBJ.Move}

Procedure MoveWinOBJ. SetAllowMove (On: Boolean);
{}
Begin
  vAllowMove := On;
End; {MoveWinOBJ.SetAllowMove}

Procedure MoveWinOBJ. WinKey (Var K: Word; Var X, Y: Byte);
{}
Begin
  If (K = vMoveKey) And (vAllowMove) Then
    WMove (False, X, Y)
  Else If  (K = 513) And (Y = vBorder. Y1) And
           (X >= vBorder. X1) And (X <= vBorder. X2)
  Then
  Begin
    If (X = vBorder. X1 + 3) And vClose Then
    Begin
      Remove;
      K := 600;  {Closed}
      key^. vLastKey := K;  {1.00e}
    End
    Else If vAllowMove Then
    Begin
      WMove (True, X, Y);
      K := 601;  {Moved}
    End;
  End;
End; {MoveWinOBJ.WinKey}

Destructor MoveWinOBJ. Done;
{}
Begin
  WinOBJ. Done;
End; {MoveWinOBJ.Done}
{||||||||||||||||||||||||||||||||||||||||||||||||}
{                                                }
{    S c r o l l W i n O B J   M E T H O D S     }
{                                                }
{||||||||||||||||||||||||||||||||||||||||||||||||}
Constructor ScrollWinOBJ. Init;
{}
Begin
  MoveWinOBJ. Init;
  vScrollV := False;
  vScrollH := False;
End; {ScrollWinOBJ.Init}

Procedure ScrollWinOBJ. SetScrollable (Vert, Horiz: Boolean);
{}
Begin
  vScrollV := Vert;
  vScrollH := Horiz;
End; {ScrollWinOBJ.SetScrollable}

Procedure ScrollWinOBJ. DrawHorizBar (Current, Max: LongInt);
{}
Var
  WasOn: Boolean;
  CursX, CursY : Byte;
Begin
  If (vStyle in [1..5] ) And (vScrollH) Then
  Begin
    CursX := Screen^. WhereX;
    CursY := Screen^. WhereY;
    WasOn := Screen^. WindowOff;
    With vBorder do
      Screen^. WriteHScrollBar (Succ (X1), Pred (X2), Y2, vActBorderAttr, Current, Max);
    SetWindow;
    Screen^. GotoXY (CursX, CursY);
  End;
End; {ScrollWinOBJ.DrawHorizBar}

Procedure ScrollWinOBJ. DrawVertBar (Current, Max: LongInt);
{}
Var
  WasOn: Boolean;
  CursX, CursY : Byte;
Begin
  If (vStyle in [1..5] ) And (vScrollV) Then
  Begin
    CursX := Screen^. WhereX;
    CursY := Screen^. WhereY;
    WasOn := Screen^. WindowOff;
    With vBorder do
      Screen^. WriteVScrollBar (X2, Succ (Y1), Pred (Y2), vActBorderAttr, Current, Max);
    SetWindow;
    Screen^. GotoXY (CursX, CursY);
  End;
End; {ScrollWinOBJ.DrawVertBar}

Procedure ScrollWinOBJ. WinKey (Var K: Word; Var X, Y: Byte);
{ RetCodes
610 = Scroll Up One
611 = Scroll Down One
612 = Scroll Left one
613 = Scroll Right one
614 = Vertical Scroll Bar
615 = Horizontal Scroll Bar
}
Begin
  If (K = vMoveKey) And (vAllowMove) Then {1.00d}
    WMove (False, X, Y)
  Else If  (K = 513) Then
  Begin
    If (Y = vBorder. Y1) And
       (X >= vBorder. X1) And (X <= vBorder. X2) 
    Then
    Begin
      If (X = vBorder. X1 + 3) And vClose Then
      Begin
        Remove;
        K := 600;  {Closed}
        key^. vLastKey := K;  {1.00e}
      End
      Else If vAllowMove Then {1.00d}
      Begin
        WMove (True, X, Y);
        K := 601;  {Moved}
      End;
    End
    Else If vScrollV And (X = vBorder. X2) Then
    Begin
      If  Y = Succ (vBorder. Y1) Then
        K := 610
      Else If Y =  Pred (vBorder. Y2)  Then
        K := 611
      Else If  (Y > Succ (vBorder. Y1) )
               And (Y < Pred (vBorder. Y2) ) 
      Then {scroll bar}
      Begin
        {adjust X to represent no of characters down scroll bar}
        {adjust Y to return total length of scroll bar}
        K := 614;
        X := Y - Succ (vBorder. Y1);
        Y := vBorder. Y2 - vBorder. Y1 - 3;
      End;
    End
      Else  If vScrollH And (Y = vBorder. Y2) Then
      Begin
        If X = Succ (vBorder. X1) Then
          K := 612
        Else If X = Pred (vBorder. X2) Then
          K := 613
        Else If  (X > Succ (vBorder. X1) )
                 And (X < Pred (vBorder. X2) ) 
        Then
        Begin
          K := 615;
          X := X - Succ (vBorder. X1);
          Y := vBorder. X2 - vBorder. X1 - 3;
        End;
      End;
  End;
End; {ScrollWinOBJ.WinKey}

Procedure ScrollWinOBJ. Draw;
{}
Begin
  If Not (vStyle in [1..5] ) Then
    vStyle := 1;
  MoveWinOBJ. Draw;
End; {ScrollWinOBJ.Draw}

Destructor ScrollWinOBJ. Done;
{}
Begin
  MoveWinOBJ. Done;
End; {ScrollWinOBJ.Done}
{||||||||||||||||||||||||||||||||||||||||||||||||||}
{                                                  }
{    S t r e t c h W i n O B J   M E T H O D S     }
{                                                  }
{||||||||||||||||||||||||||||||||||||||||||||||||||}
Constructor StretchWinOBJ. Init;
{}
Begin
  ScrollWinOBJ. Init;
  vZoomed := False;
  vPreZoom := vBorder;
  vMinWidth := 10;
  vMinDepth := 5;
  vStretchKey := LookTOT^. vWinStretchKey;
  vZoomKey := LookTOT^. vWinZoomKey;
  vAllowStretch := True;
  vSmartStretch := False;
End; {StretchWinOBJ.Init}

Procedure StretchWinOBJ. SetAllowStretch (On: Boolean);
{}
Begin
  vAllowStretch := On;
End; {StretchWinOBJ.SetAllowStretch}

Procedure StretchWinOBJ. SetMinSize (Width, depth: Byte);
{}
Begin
  vMinWidth := width;
  vMinDepth := depth;
End; {StretchWinOBJ.SetMinSize}

Procedure StretchWinOBJ. ToggleZoom;
{zooms or unzooms a window}
Begin
  vZoomed := Not vZoomed;
  Remove;             {remove the window}
  If vUnderneathPtr <> Nil Then
    FreeMem (vUnderneathPtr, Succ (vOuter. X2 - vOuter. X1) * Succ (vOuter. Y2 - vOuter. Y1) * 2);
  If Not vZoomed Then
    vBorder := vPreZoom  {set zone coords back to the old coords}
  Else
  Begin
    vPreZoom := vBorder;  {save the un-zoomed coordinates}
    vBorder := vBoundary; {set window coords to the maximum}
  End;      
  ComputeSavedCoords;
  Draw;        
End; {StretchWinOBJ.ToggleZoom}

Procedure StretchWinOBJ. StretchRefresh;
{abstract} Begin End;

Procedure StretchWinOBJ. Stretch (UsingMouse: Boolean; OldX, OldY: Byte);
{}
Const
  BorderChar = '';
  Col = White;
Var
  Mvisible,
  WasOn: Boolean;
  Left, Center, Right : Boolean;
  CTop, CBot, CX, CY: Byte;
  NewX, NewY,
  X, Y : Byte;
  OriginalScreen: ScreenOBJ;
  BackScreen: ScreenOBJ;
  OldWin: tByteCoords;                   {1.00c}
  OldWinConfine: Boolean;
  
Procedure ChangePerimeter;
     {}
     Var
       I : Integer;
     Begin
       If NewX <> vBorder. X2 Then
         With vBorder do
         Begin
           OriginalScreen. PartDisplay (X2, Y1, X2, Y2, X2, Y1);
           If NewX < X2 Then
           Begin
             OriginalScreen. PartDisplay (Succ (NewX), Y1, X2, Y2, Succ (NewX), Y1);
             OriginalScreen. PartDisplay (Succ (NewX), Y2, X2, Y2, Succ (NewX), Y2);
           End;
         End;
       If NewY <> vBorder. Y2 Then
         With vBorder do
         Begin
           OriginalScreen. PartDisplay (X1, Y2, X2, Y2, X1, Y2);
           If NewY < Y2 Then
           Begin
             OriginalScreen. PartDisplay (X1, Succ (NewY), X2, Y2, X1, Succ (NewY) );
             OriginalScreen. PartDisplay (X2, Succ (NewY), X2, Y2, X2, Succ (NewY) );
           End;
         End;
       {draw new perimiter}
       With vBorder do
       Begin
         X2 := NewX;
         Y2 := NewY;
         Screen^. Box (X1, Y1, X2, Y2, White, Ord (BorderChar) );
       End;
     End;
Begin
  If MaxAvail < 4 * Screen^. Width * Screen^. Depth Then
  Begin
    Beep;
    Exit;
  End;
  WasOn := Screen^. WindowOff;
  OriginalScreen. Init;
  OriginalScreen. Save;
  BackScreen. Init;
  BuildBackground (BackScreen);
  If vSmartStretch Then
    With OriginalScreen do
      Move (Backscreen. ScreenPtr^, ScreenPtr^, Depth * Width * 2);
  If vUnderneathPtr <> Nil Then
  Begin
    FreeMem (vUnderneathPtr, vSavedSize);
    vUnderneathPtr := Nil;
  End;
  OldWin := vOldWin;                    {1.00c}
  OldWinConfine := vOldWinConfine;
  With vBorder do
  Begin
    Screen^. Box (X1, Y1, X2, Y2, col, Ord (BorderChar) );
    OldX := X2;
    OldY := Y2;
  End;
  RemoveShadow (OriginalScreen);
  With Screen^ do
  Begin
    CursSave;
    CX := Screen^. WhereX;
    CY := Screen^. WhereY;
    CTop := CursTop;
    CBot := CursBot;
    CursOff;
  End;
  Repeat
    Begin
      With Key^ do
      Begin
        OldX := vBorder. X2;
        OldY := vBorder. Y2;
        Y := OldY;
        X := OldX;
        GetInput;
        Case key^. LastKey Of
          328: Dec (Y); {up}
          336: Inc (Y); {down}
          333: Inc (X); {right}
          331: Dec (X); {left}
        End; {case}
      End;
      Left := True;
    End;
    If Left And ( (X <> OldX) Or (Y <> OldY) ) Then  {stretch window}
    Begin
      If (Succ (X - vBorder. X1 ) < vMinWidth) Then  {too small}
        NewX := Pred (vBorder. X1 + vMinWidth)
      Else
        If (X > vBoundary. X2) Then                 {out of bounds}
          NewX := vBoundary. X2
        Else
          NewX := X;
      If (Succ (Y - vBorder. Y1 ) < vMinDepth) Then  {too small}
        NewY := Pred (vBorder. Y1 + vMinDepth)
      Else
        If (Y > vBoundary. Y2) Then                 {out of bounds}
          NewY := vBoundary. Y2
        Else
          NewY := Y;
      ChangePerimeter;
      If vSmartStretch Then
        StretchRefresh;
      OldX := NewX;
      OldY := NewY;
    End; {if}
  Until (UsingMouse And (Left = False) ) Or ( ( (key^. LastKey = 13) Or (key^. LastKey = 27) ) And (UsingMouse = False) );
  ComputeSavedCoords;
  { draw the new image }
  BackScreen. Display;
  OriginalScreen. Done;
  BackScreen. Done;
  vZoomed := (vBorder. X1 = vBoundary. X1)
  And (vBorder. Y1 = vBoundary. Y1)
  And (vBorder. X2 = vBoundary. X2)
  And (vBorder. Y2 = vBoundary. Y2);
  SetWindow;
  Draw;
  vOldWin := OldWin;                      {1.00c}
  vOldWinConfine := OldWinConfine;
  Screen^. GotoXY (CX, CY);
  Screen^. CursSize (CTop, CBot);
End; {StretchWinOBJ.Stretch}

Procedure StretchWinOBJ. Winkey (Var K: Word; Var X, Y: Byte);
{}
Begin
  If (K = vStretchKey) And vAllowStretch Then
  Begin
    Stretch (False, X, Y);
    K := 602;
  End
  Else If (K = 513) And (X = vBorder. X2) And (Y = vBorder. Y2) And vAllowStretch Then
  Begin
    Stretch (True, X, Y);
    K := 602;
  End
  Else If ( ( (K = 513) And (X = vBorder. X2 - 3) And (Y = vBorder. Y1) )
            Or (K = vZoomKey) ) And vAllowStretch 
  Then
  Begin
    ToggleZoom;
    K := 602;
  End
  Else
    ScrollWinOBJ. WinKey (K, X, Y);
End; {StretchWinOBJ.Winkey}

Procedure StretchWinOBJ. Refresh;
{}
Var WasOn: Boolean;
Begin
  WasOn := Screen^. WindowOff;
  ShadowTOT^. DrawShadow (vBorder);
  If vClose Then
  Begin
    With vBorder do
    Begin
      Screen^. BoxEngine (X1, Y1, X2, Y2, 4, 4, vActBorderAttr, vActTitleAttr,
                         vBodyAttr, vStyle, True, vTitle);
      Screen^. WriteAT (X1 + 2, Y1, vActBorderAttr, '[ ]');
      Screen^. WriteAT (X1 + 3, Y1, vActIconsAttr, '');
    End;
  End
  Else
    With vBorder do
      Screen^. BoxEngine (X1, Y1, X2, Y2, 0, 4, vActBorderAttr, vActTitleAttr,
                         vBodyAttr, vStyle, True, vTitle);
  If vAllowStretch Then
  Begin
    Screen^. WriteAT (vBorder. X2 - 4, vBorder. Y1, vActBorderAttr, '[ ]');
    If Not vZoomed Then
      Screen^. WriteAT (vBorder. X2 - 3, vBorder. Y1, vActIconsAttr, '')
    Else
      Screen^. WriteAT (vBorder. X2 - 3, vBorder. Y1, vActIconsAttr, '');
  End;
  SetWindow;
End; {StretchWinOBJ.Refresh}

Procedure StretchWinOBJ. Draw;
{}
Begin
  If Not (vStyle in [1..5] ) Then
    vStyle := 1;
  Save;
  Refresh;
End; {StretchWinOBJ.Draw}

Destructor StretchWinOBJ. Done;
{}
Begin
  ScrollWinOBJ. Done;
End; {StretchWinOBJ.Done}

End.
