Unit totSYS;
{$I Sys75.Inc}

Interface

Uses DOS, CRT;

Type
  tVideo = (UnKnown, Mono, CGA, MCGAMono, MCGACol, EGAMono, EGACol, VGAMono, VGACol);
  tOSDate = (USA, Europe, Japan);
  
  pDisplayOBJ = ^DisplayOBJ;
  DisplayOBJ = Object
                 vSnowProne : Boolean;     {does system suffer from snow}
                 vWidth : Byte;            {no. of characters of display}
                 vDepth: Byte;             {no. of lines of display}
                 vBaseOfScreen: Pointer;   {location of video memory}   {5.00a}
                 vDisplayType: tVideo;     {video display type}
                 vForceBW: Boolean;        {uses monochrome color schemes}
                 {methods...}
                 Constructor Init;
                 Function    TestVideo: tVideo;
                 Function    SnowProne: Boolean;
                 Function    GetMode: Byte;
                 Function    ColorOn: Boolean;
                 Function    Width: Byte;
                 Function    Depth: Byte;
                 Function    DisplayType: tVideo;
                 Procedure   SetCondensed;
                 Procedure   SetBW (on: Boolean);
                 Procedure   Set25;
                 Function    BaseOfScreen: Pointer;        {returns ptr to video memory}
                 Destructor  Done;
               End; {DisplayOBJ}
  
  pEquipOBJ = ^EquipOBJ;
  EquipOBJ = Object
               vMainInfo: Word;
               vComputerID: Byte;
               vRomDate: String [8];
               {methods...}
               Constructor Init;
               Function    ComputerID: Byte;
               Function    ParallelPorts: Byte;
               Function    SerialPorts: Byte;
               Function    FloppyDrives: Byte;
               Function    ROMDate: String;
               Function    GameAdapter: Boolean;
               Function    SerialPrinter: Boolean;
               Function    MathChip: Boolean;
               Destructor  Done;
             End; {EquipOBJ}
  
  pMemOBJ = ^MemOBJ;
  MemOBJ = Object
             vMemInfo: Word;
             vMaxExtMem: Word;
             vMaxExpMem: Word;
             vEMMInstalled: Boolean;
             vEMMmajor: Byte;
             vEMMminor: Byte;
             {methods...}
             Constructor Init;
             Function    BaseMemory: Integer;
             Function    EMMInstalled: Boolean;
             Function    EMMVersionMajor: Byte;
             Function    EMMVersionMinor: Byte;
             Function    EMMVersion: String;
             Function    MaxExtMem: Word;
             Function    MaxExpMem: Word;
             Function    ExtMemAvail: Word;
             Function    ExpMemAvail: Word;
             Destructor  Done;
           End; {MemOBJ}
  
  pOSOBJ = ^OSOBJ;
  OSOBJ = Object  {Operating System}
            vMajor: Byte;
            vMinor: Byte;
            vCountry: Word;
            vDateFmt: tOSDate;
            vCurrency: String [5];
            vThousands: Byte;
            vDecimal: Byte;
            vDateSeparator: Byte;
            vTimeSeparator: Byte;
            vTimeFmt: Byte;
            vCurrencyFmt: Byte;
            vCurrencyDecPlaces: Byte;
            {methods...}
            Constructor Init;
            Function OSVersionMajor: Byte;
            Function OSVersionMinor: Byte;
            Function OSVersion: String;
            Function Country: Word;
            Function Currency: String;
            Function DateFmt: tOSDate;
            Function TimeFmt: Byte;
            Function ThousandsSep: Char;
            Function DecimalSep: Char;
            Function DateSep: Char;
            Function TimeSep: Char;
            Function CurrencyFmt: Byte;
            Function CurrencyDecPlaces: Byte;
            Destructor  Done;
          End; {OSOBJ}
  
  Procedure sysINIT;
  
Var
  Monitor: ^DisplayObj;
  
Implementation
{||||||||||||||||||||||||||||||||||||}
{                                    }
{     D I S P L A Y    S T U F F     }
{                                    }
{||||||||||||||||||||||||||||||||||||}
Constructor DisplayObj. Init;
{}
Var
  Mode : Byte;
  Regs: Registers;
Begin
  vDisplayType := TestVideo;
  (* Disabled due to driver conflicts
  with Regs do
  begin
  AX := $2B01;       {1.00a DesqViewTest}
  CX := $4445;
  DX := $5351;
  intr($21,Regs);
  if Al <> $FF then {DesqView present}
  begin
  Ah := $FE;
  Intr($10,Regs);
  vBaseOfScreen := ptr(ES,DI);
  end
  else
  begin
  Mode := GetMode;
  if Mode = 7 then
  vBaseOfScreen := ptr($B000,0)  {Mono}
  else
  vBaseOfScreen := ptr($B800,0); {Color}
  end;
  end;
  *)
  Mode := GetMode;
  {$IFDEF DPMI}                 {1.10}
  If Mode = 7 Then
    vBaseOfScreen := Ptr (SegB000, 0)  {Mono}
  Else
    vBaseOfScreen := Ptr (SegB800, 0); {Color}
  {$ELSE}
  If Mode = 7 Then
    vBaseOfScreen := Ptr ($B000, 0)  {Mono}
  Else
    vBaseOfScreen := Ptr ($B800, 0); {Color}
  {$ENDIF}
  vSnowProne := (vDisplayType = CGA);
  vWidth := 80;
  vDepth := Succ (Hi (WindMax) );
  vForceBW := False;
End; {DisplayObj.Init}

Function DisplayOBJ. TestVideo: tVideo;
{}
Var
  Regs: Registers;
  Equip: Byte;
  Temp: tVideo;
Begin
  With Regs do
  Begin
    AL := $00;
    AH := $1A;   {get VGA info}
    Intr ($10, Regs);
    If AL = $1A Then
      Case BL Of
        $00: Temp := unknown;
        $01: Temp := Mono;
        $04: Temp := EGACol;
        $05: Temp := EGAMono;
        $07: Temp := VGAMono;
        $08: Temp := VGACol;
        $0A,
        $0C: Temp := MCGACol;
        $0B: Temp := MCGAMono;
        Else
          Temp := CGA;
      End {case}
    Else         {more checking needed}
    Begin
      AH := $12;
      BX := $10;  {get EGA data}
      Intr ($10, Regs);
      If BX = $10 Then {EGA or Mono}
      Begin
        Intr ($11, Regs);
        If ( (AL And $30) ShR 4) = 3 Then
          Temp := Mono
        Else
          Temp := CGA;
      End
      Else 
      Begin
        AH := $12;
        BX := $10;  {one more time!}
        Intr ($10, Regs);
        If BH = 0 Then
          Temp := EGACol
        Else
          Temp := EGAMono;
      End;  {if}
    End; {if}
  End; {with}
  TestVideo := Temp;
End; {DisplayOBJ.TestVideo}

Function DisplayObj. GetMode;
{}
Var Regs : Registers;
Begin
  With Regs do
  Begin
    AX := $0F00;
    Intr ($10, Regs);  {get video display mode}
    GetMode := AL;
  End;
End; {DisplayObj.GetMode}

Function DisplayObj. ColorOn: Boolean;
{}
Begin
  If (vForceBW)
     Or (DisplayType in [Mono, MCGAMono, EGAMono, VGAMono] )
     Or (GetMode = 2) 
  Then       {Mode BW80 active}
    ColorOn := False
  Else
    ColorOn := True;
End; {DisplayObj.ColorOn}

Procedure DisplayOBJ. SetBW (On: Boolean);
{}
Begin
  vForceBW := On;
End; {DisplayOBJ.SetBW}

Function DisplayObj. BaseOfScreen: Pointer;
{}
Begin
  BaseofScreen := vBaseOfScreen; {1.00a}
End; {DisplayObj.BaseOfScreen}

Function DisplayObj. SnowProne: Boolean;
{}
Begin
  SnowProne := vSnowProne;
End; {DisplayObj.SnowProne}

Function DisplayObj. Width: Byte;
{}
Begin
  Width := vWidth;
End; {DisplayObj.Width}

Function DisplayObj. Depth: Byte;
{}
Begin
  Depth := vDepth;
End; {DisplayObj.Depth}

Function DisplayObj. DisplayType: tVideo;
{}
Begin
  DisplayType := vDisplayType;
End; {DisplayObj.DisplayType}

Procedure DisplayObj. SetCondensed;
{sets to maximum number od display lines supported by the display system}
Begin
  If vDisplayType in [EGAMono, EGACol, VGAMono, VGACol] Then
  Begin
    TextMode (Lo (LastMode) + Font8X8);
    vDepth := Succ (Hi (WindMax) );
  End;
End; {DisplayObj.SetCondensed}

Procedure DisplayObj. Set25;
{resets display back to 25 lines}
Begin
  If Depth <> 25 Then
  Begin
    TextMode (Lo (LastMode) );
    vDepth := Succ (Hi (WindMax) );
  End;
End; {DisplayObj.Set25}

Destructor DisplayObj. Done;
Begin End;

{||||||||||||||||||||||||||||||||||||}
{                                    }
{       E Q U I P    S T U F F       }
{                                    }
{||||||||||||||||||||||||||||||||||||}

Constructor EquipOBJ. Init;   {1.10}
{}
Var
  Reg: Registers;
  IDPtr: Pointer;
  ROMPtr: Pointer;
Begin
  Intr ($11, Reg);
  vMainInfo := Reg. AX;
  {$IFDEF DPMI}
  vComputerID := 0;
  vRomdate := 'Unknown';
  {$ELSE}
  IDPtr := Ptr ($F000, $FFFE);
  vComputerID := Byte (IDPtr^);
  ROMPtr := Ptr ($F000, $FFF5);
  Move (ROMPtr^, vROMDate [1], 8);
  vROMDate [0] := Chr (8);
  {$ENDIF}
End; {of const EquipOBJ.Init}

Function EquipOBJ. ComputerID: Byte;
{}
Begin
  ComputerID := vComputerID;
End; {EquipOBJ.ComputerID}

Function EquipOBJ. ParallelPorts: Byte;
{}
Begin
  ParallelPorts := Hi (vMainInfo) ShR 6;
End; {EquipOBJ.ParallelPorts}

Function EquipOBJ. SerialPorts: Byte;
{}
Begin
  SerialPorts := Hi (vMainInfo) And $0F ShR 1;
End; {EquipOBJ.SerialPorts}

Function EquipOBJ. FloppyDrives: Byte;
{}
Begin
  FloppyDrives := ( (vMainInfo And $C0) ShR 6) + 1;
End; {EquipOBJ.FloppyDrives}

Function EquipOBJ. ROMDate: String;
{}
Begin
  ROMDate := vROMDate;
End; {EquipOBJ.ROMDate}

Function EquipOBJ. GameAdapter: Boolean;
{}
Begin
  GameAdapter := ( (vMainInfo And $1000) = 1);
End; {EquipOBJ.GameAdapter}

Function EquipOBJ. SerialPrinter: Boolean;
{}
Begin
  SerialPrinter := ( (vMainInfo And $2000) = 1);
End; {EquipOBJ.SerialPrinter}

Function EquipOBJ. MathChip: Boolean;
{}
Begin
  MathChip := ( (vMainInfo And $2) = $2);
End; {EquipOBJ.mathChip}

Destructor EquipOBJ. Done;
Begin End;

{||||||||||||||||||||||||||||||||}
{                                }
{       M E M    S T U F F       }
{                                }
{||||||||||||||||||||||||||||||||}

Constructor MemOBJ. Init;
{}
Const
  FingerPrint: String [8] = 'EMMXXXX0';
Var  
  Regs: Registers;
  ID: String [8];
Begin
  {$IFDEF DPMI}
  vEMMInstalled := False;
  {$ELSE}
  Intr ($12, Regs);
  vMemInfo := Regs. AX;
  With regs do
  Begin
    AH := $35;
    AL := $67;
    Intr ($21, Regs); {ES now points to int $67 segment -- id is 10 bytes on}
    Move (mem [ES:$000A], ID [1], 8);
    ID [0] := Chr (8);
    vEMMInstalled := (ID = FingerPrint);
  End;
  {$ENDIF}
  vEMMMajor := 0;
  vEMMMinor := 0;
  If EMMInstalled Then
  Begin
    {get total expanded memory}
    Regs. AH := $42;
    Intr ($67, Regs);
    vMaxExpMem := Regs. DX * 16;
    {get driver version number}
    Regs. AH := $46;
    Intr ($67, Regs);
    If Regs. AH = 0 Then
    Begin
      vEMMMajor := Regs. AL ShR 4;
      vEMMMinor := Regs. AL And $F;
    End;
  End
  Else
    vMaxExpMem := 0;
End; {of const MemOBJ.Init}

Function MemOBJ. BaseMemory: Integer;
{}
Begin
  BaseMemory := vMemInfo;
End; {MemOBJ.BaseMemory}

Function MemOBJ. EMMInstalled: Boolean;
{}
Begin
  EMmInstalled := vEMMInstalled;
End; {MemOBJ.EMMInstalled}

Function MemOBJ. ExtMemAvail: Word;
{}
Var regs : Registers;
Begin
  Regs. AH := $88;
  Intr ($15, Regs);
  ExtMemAvail := Regs. AX;
End; {MemOBJ.ExtMemAvail}

Function MemOBJ. ExpMemAvail: Word;
{}
Var regs : Registers;
Begin
  If EMMInstalled Then
  Begin
    Regs. AH := $42;
    Intr ($67, Regs);
    ExpMemAvail := Regs. BX * 16;
  End
  Else
    ExpMemAvail := 0;
End; {MemOBJ.NetExpMemory}

Function MemOBJ. MaxExpMem: Word;
{}
Begin
  MaxExpMem := vMaxExpMem
End; {MemOBJ.MaxExpMem}

Function MemOBJ. MaxExtMem: Word;
{}
Begin
  MaxExtMem := vMaxExtMem
End; {MemOBJ.MaxExtMem}

Function MemOBJ. EMMVersionMajor: Byte;
{}
Begin
  EMMVersionMajor := vEMMMajor;
End; {MemOBJ.EMMVersionMajor}

Function MemOBJ. EMMVersionMinor: Byte;
{}
Begin
  EMMVersionMinor := vEMMMinor;
End; {MemOBJ.EMMVersionMinor}

Function MemOBJ. EMMVersion: String;
{}
Begin
  EMMVersion := Chr (EMMVersionMajor + 48) + '.' + Chr (EMMVersionMinor + 48);
End; {MemOBJ.EMMVersion}


Destructor MemOBJ. Done;
Begin End;

{||||||||||||||||||||||||||||||||}
{                                }
{       O. S.    S T U F F       }
{                                }
{||||||||||||||||||||||||||||||||}
Constructor OSObj. Init;
{}
Var
  Regs: Registers;
  CountryBuf: Array [0..$21] Of Byte;
  P: Byte;
  W: Word Absolute CountryBuf;
Begin
  With regs do
  Begin
    AH := $30;
    MsDos (Regs);
    vMajor := AL;
    vMinor := AH;
    AX := $3800;
    DS := Seg (CountryBuf);
    DX := Ofs (CountryBuf);
    Intr ($21, Regs);
    vCountry := Regs. BX;
    If vMajor >= 3 Then
    Begin
      vDateFmt := tOSDate (W);
      vCurrency := '     ';
      Move (CountryBuf [$2], vCurrency [1], 5);
      P := Pos (#0, vCurrency);      {ASCIIZ string form}
      If P > 0 Then
        Delete (vCurrency, P, 5);
      vThousands := CountryBuf [$7];
      vDecimal := CountryBuf [$9];
      vDateSeparator := CountryBuf [$B];
      vTimeSeparator := CountryBuf [$D];
      vTimeFmt := CountryBuf [$11];
      vCurrencyFmt := CountryBuf [$F];
      vCurrencyDecPlaces := CountryBuf [$10];
    End
    Else
    Begin
      vDateFmt := tOSDate (W);
      vCurrency := Chr (CountryBuf [$2] );
      vThousands := CountryBuf [$04];
      vDecimal := CountryBuf [$06];
      vDateSeparator := Ord ('/');   {not avialable before DOS 3}
      vTimeSeparator := Ord (':');
      vTimeFmt := 1;
      vCurrencyFmt := 0;
      vCurrencyDecPlaces := 2;
    End;
  End;
End; {of const OSObj.Init}

Function OSObj. OSVersionMajor: Byte;
{}
Begin
  OSVersionMajor := vMajor;
End; {OSObj.OSVersionMajor}

Function OSObj. OSVersionMinor: Byte;
{}
Begin
  OSVersionMinor := vMinor;
End; {OSObj.OSVersionMinor}

Function OSObj. OSVersion: String;
{}
Begin
  OSVersion := Chr (OSVersionMajor + 48) + '.' + Chr (OSVersionMinor + 48);
End; {OSObj.OSVersion}

Function OSObj. Country: Word;
{}
Begin
  Country := vCountry;
End; {OSObj.Country}

Function OSObj. Currency: String;
{}
Begin
  Currency := vCurrency;
End; {OSObj.Currency}

Function OSObj. DateFmt: tOSDate;
{}
Begin
  DateFmt := vDateFmt;
End; {OSObj.DateFmt}

Function OSObj. ThousandsSep: Char;
{}
Begin
  ThousandsSep := Chr (vThousands);
End; {OSObj.ThousandsSep}

Function OSObj. DecimalSep: Char;
{}
Begin
  DecimalSep := Chr (vDecimal);
End; {OSObj.DecimalSep}

Function OSObj. DateSep: Char;
{}
Begin
  DateSep := Chr (vDateSeparator);
End; {OSObj.DateSep}

Function OSObj. TimeSep: Char;
{}
Begin
  TimeSep := Chr (vTimeSeparator);
End; {OSObj.TimeSep}

Function OSObj. TimeFmt: Byte;
{}
Begin
  TimeFmt := vTimeFmt;
End; {OSObj.TimeFmt}

Function OSObj. CurrencyFmt: Byte;
{}
Begin
  CurrencyFmt := vCurrencyFmt;
End; {OSObj.CurrencyFmt}

Function OSObj. CurrencyDecPlaces: Byte;
{}
Begin
  CurrencyDecPlaces := vCurrencyDecPlaces;
End; {OSObj.CurrencyDecPlaces}

Destructor OSObj. Done;
Begin End;
{|||||||||||||||||||||||||||||||||||||||||||||||}
{                                               }
{     U N I T   I N I T I A L I Z A T I O N     }
{                                               }
{|||||||||||||||||||||||||||||||||||||||||||||||}
Procedure SysInit;
{initilizes objects and global variables}
Begin
  New (Monitor, Init);
End;

{end of unit - add intialization routines below}
Begin
  SysInit;
End.


