Unit totSTR;
{$I Sys75.Inc}

Interface

Uses
  dos, totREAL;

Const
  MaxFixlength = 5;
  DigitSet = ['0'..'9'];
  Digits : array[0..$F] of Char = '0123456789ABCDEF';
Type
  tJust = (JustLeft, JustCenter, JustRight);
  tCase = (Lower, Upper, Proper, Leave);
  tSign = (plusminus, minus, brackets, dbcr);

  LH = record
    L, H : Word;
  end;

  CharProc         = Procedure (W: Word);
  CaseFunc         = Function (CH: Char): Char;
  CharSet = Set Of Char;

Const
  Floating = 255;
  Fmtchars: Set Of Char = ['!', '#', '@', '*'];

Function PicFormat (Input, Picture: String; Pad: Char): String;
Function TruncFormat (Input: String; Start, Len: Byte; Pad: Char): String;
Function Squeeze (L: Char; Str: String; Width: Byte): String;
Function First_Capital_Pos (Str: String): Byte;
Function First_Capital (Str: String): Char;
Function Pad (PadJust: tJust; Str: String; Size: Byte; ChPad: Char): String;
Function PadLeft (Str: String; Size: Byte; ChPad: Char): String;
Function PadCenter (Str: String; Size: Byte; ChPad: Char): String;
Function PadRight (Str: String; Size: Byte; ChPad: Char): String;
Function Last (N: Byte; Str: String): String;
Function First (N: Byte; Str: String): String;
Function AdjCase (NewCase: tCase; Str: String): String;
Function SetUpper (Str: String): String;
Function SetLower (Str: String): String;
Function SetProper (Str: String): String;
Function OverType (N: Byte; StrS, StrT: String): String;
Function Strip (L, C: Char; Str: String): String;
Function LastPos (C: Char; Str: String): Byte;
Function PosAfter (C: Char; Str: String; Start: Byte): Byte;
Function LastPosBefore (C: Char; Str: String; Last: Byte): Byte;
Function PosWord (Wordno: Byte; Str: String): Byte;
Function WordCnt (Str: String): Byte;
Function CharCount (C: Char; Str: String): Byte;
Function ExtractWords (StartWord, NoWords: Byte; Str: String): String;
Function NextParan (S: String): Byte;
Function ValidInt (Str: String): Boolean;
Function ValidHEXInt (Str: String): Boolean;
Function ValidReal (Str: String): Boolean;
Function StrToInt (Str: String): LongInt;
Function HEXStrToLong (Str: String): LongInt;
Function StrToReal (Str: String): Extended;
Function RealToStr (Number: Extended; Decimals: Byte): String;
Function IntToStr (Number: LongInt): String;
Function Decimals (L: Byte): Byte;
Function RealToSciStr (Number: Extended; D: Byte): String;
Function NthNumber (InStr: String; Nth: Byte) : Char;
Function FormatHourMin (TotalSecs: LongInt): String;
Function FormatMinSec (TotalSecs : LongInt) : String;
Function FormatMinTenths (TotalSecs: LongInt): String;
Function PipeLen (S: String): Byte;
Function AntiPipe (S: String): String;
function remchars (rem, s: string): String;
function charpos (var s: string; c: char; t: byte): byte;
Function uCase (CH: Char): Char;
         inline($58/$3C/$61/$72/$39/$3C/$7A/$76/$33/$3C/$84/$75/$02/$B0/$8E
               /$3C/$94/$75/$02/$B0/$99/$3C/$81/$75/$02/$B0/$9A
               /$3C/$87/$75/$02/$B0/$80/$3C/$86/$75/$02/$B0/$BF
               /$3C/$82/$75/$02/$B0/$90/$3C/$91/$75/$02/$B0/$92
               /$3C/$A4/$75/$02/$B0/$A5/$EB/03/90/$2C/$20);
Function lCase (CH: Char): Char;
         inline($58/$3C/$41/$72/$39/$3C/$5A/$76/$33/$3C/$8E/$75/$02/$B0/$B4
               /$3C/$99/$75/$02/$B0/$94/$3C/$9A/$75/$02/$B0/$81
               /$3C/$8D/$75/$02/$B0/$87/$3C/$8F/$75/$02/$B0/$86
               /$3C/$9D/$75/$02/$B0/$82/$3C/$92/$75/$02/$B0/$91
               /$3C/$A5/$75/$02/$B0/$A4/$EB/03/90/$04/$20);

(* APMISC *)
function HexB(B : Byte) : string;
function HexW (W : Word) : string;
function HexL (L : LongInt) : string;
function HexPtr(P : Pointer) : string;

Implementation

Function PicFormat (Input, Picture: String; Pad: Char): String;
{}
Var
  TempStr : String;
  I, J : Byte;
Begin
  J := 0;
  for I := 1 to Length (Picture) do
  Begin
    If Not (Picture [I] in Fmtchars) Then
    Begin
      TempStr [I] := Picture [I] ;  {force any none format charcters into string}
      Inc (J);
    End
    Else    {format character}
    Begin
      If I - J <= Length (Input) Then
        TempStr [I] := Input [I - J]
      Else
        TempStr [I] := Pad;
    End;
  End;
  TempStr [0] := Char (Length (Picture) );  {set initial byte to string length}
  PicFormat := Tempstr;
End; {PicFormat}

Function TruncFormat (Input: String; Start, Len: Byte; Pad: Char): String;
{}
Var
  L : Byte;
Begin
  If Start > 1 Then
    Delete (Input, 1, Pred (Start) );
  L := Length (Input);
  If L = Len Then
    TruncFormat := Input
  Else If L > Len Then
    TruncFormat := Copy (Input, 1, Len)
  Else
    TruncFormat := Padleft (Input, Len, Pad);
End; {TruncFormat}

Function Squeeze (L: Char; Str: String; Width: Byte): String;
{}
Const more: String [1] = #26;
Var temp : String;
Begin
  If Width = 0 Then
  Begin
    Squeeze := '';
    Exit;
  End;
  FillChar (Temp [1], Width, ' ');
  Temp [0] := Chr (Width);
  If Length (Str) < Width Then
    Move (Str [1], Temp [1], Length (Str) )
  Else
  Begin
    If uCase (L) = 'L' Then
    Begin
      Move (Str [1], Temp [1], Pred (width) );
      Move (More [1], Temp [Width], 1);
    End
    Else
    Begin
      Move (More [1], Temp [1], 1);
      Move (Str [Length (Str) - width + 2], Temp [2], Pred (width) );
    End;
  End;
  Squeeze := Temp;
End; {Squeeze}

Function First_Capital_Pos (Str : String): Byte;
{}
Var StrPos : Byte;
Begin
  StrPos := 1;
  While (StrPos <= Length (Str))  And Not (Str [StrPos] In ['A'..'Z']) do
    StrPos := Succ (StrPos);
  If StrPos > Length (Str) Then
    First_Capital_Pos  := 0
  Else
    First_Capital_Pos := StrPos;
End; {First_Capital_Pos}

Function First_capital (Str : String): Char;
{}
Var B : Byte;
Begin
  B := First_Capital_Pos (Str);
  If B > 0 Then
    First_Capital := Str [B]
  Else
    First_Capital := #0;
End; {First_capital}

Function Pad (PadJust: tJust; Str: String; Size: Byte; ChPad: Char): String;
{}
Begin
  Case PadJust Of
    JustLeft:  Pad := PadLeft (Str, Size, ChPad);
    JustCenter: Pad := PadCenter (Str, Size, ChPad);
    JustRight: Pad := PadRight (Str, Size, ChPad);
  End; {case}
End; {Pad}

Function PadLeft (Str: String; Size: Byte; ChPad: Char): String;
Var temp : String;
Begin
  FillChar (Temp [1], Size, ChPad);
  Temp [0] := Chr (Size);
  If Length (Str) <= Size Then
    Move (Str [1], Temp [1], Length (Str) )
  Else
    Move (Str [1], Temp [1], Size);
  PadLeft := Temp;
End;

Function PadCenter (Str: String; Size: Byte; ChPad: Char): String;
Var temp : String;
  L : Byte;
Begin
  FillChar (Temp [1], Size, ChPad);
  Temp [0] := Chr (Size);
  L := Length (Str);
  If L <= Size Then
    Move (Str [1], Temp [ ( (Size - L) Div 2) + 1], L)
  Else
    Temp := Copy (Str, 1, L);
  PadCenter := temp;
End; {center}

Function PadRight (Str: String; Size: Byte; ChPad: Char): String;
Var
  temp : String;
  L : Integer;
Begin
  FillChar (Temp [1], Size, ChPad);
  Temp [0] := Chr (Size);
  L := Length (Str);
  If L <= Size Then
    Move (Str [1], Temp [Succ (Size - L) ], L)
  Else
    Move (Str [1], Temp [1], Size);
  PadRight := Temp;
End;

Function Last (N: Byte; Str: String): String;
Var Temp : String;
Begin
  If N > Length (Str) Then
    Temp := Str
  Else
    Temp := Copy (Str, Succ (Length (Str) - N), N);
  Last := Temp;
End;  {Last}

Function First (N: Byte; Str: String): String;
Var Temp : String;
Begin
  If N > Length (Str) Then
    Temp := Str
  Else
    Temp := Copy (Str, 1, N);
  First := Temp;
End;  {First}

Function AdjCase (NewCase: tCase; Str: String): String;
{}
Begin
  Case Newcase Of
    Upper: Str := SetUpper (Str);
    Lower: Str := SetLower (Str);
    Proper: Str := SetProper (Str);
    Leave:{do nothing} ;
  End;
  AdjCase := Str;
End; {AdjCase}

Function SetUpper (Str: String): String;
Var
  I : Integer;
Begin
  for I := 1 to Length (Str) do
    Str [I] := uCase (Str [I] );
  SetUpper := Str;
End;  {Upper}

Function SetLower (Str: String): String;
Var
  I : Integer;
Begin
  for I := 1 to Length (Str) do
    Str [I] := lCase (Str [I] );
  SetLower := Str;
End;  {Lower}

Function SetProper (Str: String): String;
Var
  I : Integer;
  SpaceBefore: Boolean;
Begin
  SpaceBefore := True;
  Str := SetLower (Str);
  for I := 1 to Length (Str) do
    If SpaceBefore And ((Str [I] ) in ['a'..'z']) Then
    Begin
      SpaceBefore := False;
      Str [I] := uCase (Str [I] );
    End
  Else
    If (SpaceBefore = False) And ((Str [I] = ' ') Or (Str [I] = '.')) Then
      SpaceBefore := True;
  SetProper := Str;
End;

Function OverType (N: Byte; StrS, StrT: String): String;
{Overlays StrS onto StrT at Pos N}
Var
  L : Byte;
  StrN : String;
Begin
  L := N + Pred (Length (StrS) );
  If L < Length (StrT) Then
    L := Length (StrT);
  If L > 255 Then
    Overtype := Copy (StrT, 1, Pred (N) ) + Copy (StrS, 1, 255 - N)
  Else
  Begin
    FillChar (StrN [1], L, ' ');
    StrN [0] := Chr (L);
    Move (StrT [1], StrN [1], Length (StrT) );
    Move (StrS [1], StrN [N], Length (StrS) );
    OverType := StrN;
  End;
End;  {OverType}

Function Strip (L, C: Char; Str: String): String;
{Left, Right, Both, All}
Var
  I :  Byte;
Begin
  Case uCase (L) Of
    'L' :
          Begin       {Left}
            While (Str [1] = C) And (Str [0] <> #0) do
              Delete (Str, 1, 1);
          End;
    'R' :
          Begin       {Right}
            While (Str [Length (Str) ] = C) And (Str [0] <> #0) do
              Dec (Str [0]);
          End;
    'B' :
          Begin       {Both left and right}
            While (Str [1] = C) And (Str [0] <> #0) do
              Delete (Str, 1, 1);
            While (Str [Length (Str) ] = C) And (Str [0] <> #0)  do
              Dec (Str [0]);
          End;
    'A' :
          Begin       {All}
            I := 1;
            Repeat
              If (Str [I] = C) And (Str [0] <> #0) Then
                Delete (Str, I, 1)
              Else
                Inc (I);
            Until (I > Length (Str) ) Or (Str = '');
          End;
  End;
  Strip := Str;
End;  {Strip}

Function LastPos (C: Char; Str: String): Byte;
{}
Var I : Byte;
Begin
  I := Succ (Length (Str) );
  Repeat
    Dec (I);
  Until (I = 0) Or (Str [I] = C);
  LastPos := I;
End;  {LastPos}

Function PosAfter (C: Char; Str: String; Start: Byte): Byte;
{}
Var I : Byte;
Begin
  I := Length (Str);
  If (I = 0) Or (Start > I) Then
    PosAfter := 0
  Else
  Begin
    Dec (Start);
    Repeat
      Inc (Start)
    Until (Start > I) Or (Str [Start] = C);
    If Start > I Then
      PosAfter := 0
    Else
      PosAfter := Start;
  End;
End; {PosAfter}

Function LastPosBefore (C: Char; Str: String; Last: Byte): Byte;
{}
Begin
  Str := Copy (Str, 1, Last);
  LastPosBefore := LastPos (C, Str);
End; {LostPosBefore}

Function LocWord (StartAT, Wordno: Byte; Str: String): Byte;
{local proc used by PosWord and Extract word}
Var
  W, L: Integer;
  Spacebefore: Boolean;
Begin
  If (Str = '') Or (wordno < 1) Or (StartAT > Length (Str) ) Then
  Begin
    LocWord := 0;
    Exit;
  End;
  SpaceBefore := True;
  W := 0;
  L := Length (Str);
  StartAT := Pred (StartAT);
  While (W < Wordno) And (StartAT <= Length (Str) ) do
  Begin
    StartAT := Succ (StartAT);
    If SpaceBefore And (Str [StartAT] <> ' ') Then
    Begin
      W := Succ (W);
      SpaceBefore := False;
    End
    Else
      If (SpaceBefore = False) And (Str [StartAT] = ' ') Then
        SpaceBefore := True;
  End;
  If W = Wordno Then
    LocWord := StartAT
  Else
    LocWord := 0;
End;

Function PosWord (Wordno: Byte; Str: String): Byte;
Begin
  PosWord := LocWord (1, wordno, Str);
End;  {Word}

Function WordCnt (Str: String): Byte;
Var
  W, I: Integer;
  SpaceBefore: Boolean;
Begin
  If Str = '' Then
  Begin
    WordCnt := 0;
    Exit;
  End;
  SpaceBefore := True;
  W := 0;
  for  I :=  1 to Length (Str) do
  Begin
    If SpaceBefore And (Str [I] <> ' ') Then
    Begin
      W := Succ (W);
      SpaceBefore := False;
    End
    Else
      If (SpaceBefore = False) And (Str [I] = ' ') Then
        SpaceBefore := True;
  End;
  WordCnt := W;
End;

Function CharCount (C: Char; Str: String): Byte;
Var
  A, B: Byte;
Begin
  A := 0;
  B := Pos (C, Str);
  While B <> 0 do Begin
    Inc (A);
    Delete (Str, 1, B);
    B := Pos (C, Str);
  End;
  CharCount := A;
End;

function charpos (var s: string; c: char; t: byte): byte;
var
  b: byte;
begin
  for b := 1 to length (s) do
    if s [b] = c then begin
      dec (t);
      if t = 0 then begin
        charpos := b;
        exit;
      end;
    end;
  charpos := 0;
end;

Function ExtractWords (StartWord, NoWords: Byte; Str: String): String;
Var
  Start, finish : Integer;
Begin
  start := wordcnt (str);
  If (Str = '') or (startword > start ) or (nowords = 0)  or (startword = 0) or (nowords > start) Then
  Begin
    ExtractWords := '';
    Exit;
  End;
  Start := LocWord (1, StartWord, Str);
  If Start <> 0 Then
    finish := LocWord (Start, Succ (NoWords), Str)
  Else
  Begin
    ExtractWords := '';
    Exit;
  End;
  If finish = 0 Then
    finish := Succ (Length (Str));
  Repeat
    finish := Pred (finish);
  Until Str [finish] <> ' ';
  ExtractWords := Copy (Str, Start, Succ (finish - Start));
End;  {ExtractWords}

Function ValidInt (Str: String): Boolean;
{}
Var
  Temp : LongInt;
  Code : Integer;

  Function NoLetters: Boolean;
  Var
    I: Integer;
    Bad: Boolean;
  Begin
    NoLetters := True;
    for I := 1 to Length (Str) do
    Begin
      If (Str [I] in ['0'..'9', '+', '-'] ) = False Then  {1.00b}
        NoLetters := False;
    End;
  End;

Begin
  If Length (Str) = 0 Then
    ValidInt := True
  Else
  Begin
    Val (Str, temp, code);
    ValidInt := (Code = 0) And Noletters;
  End;
End; {ValidInt}

Function ValidHEXInt (Str: String): Boolean;
{}
Var
  Temp : LongInt;
  Code : Integer;
Begin
  If Length (Str) = 0 Then
    ValidHEXInt := True
  Else
  Begin
    Val (Str, temp, code);
    ValidHEXInt := (Code = 0);
  End;
End; {ValidHEXInt}

Function IntToStr (Number: LongInt): String;
{}
Var Temp : String;
Begin
  Str (Number, temp);
  IntToStr := temp;
End; {IntToStr}

Function ValidReal (Str: String): Boolean;
{}
Var
  Code : Integer;
  Temp : Extended;
Begin
  If Length (Str) = 0 Then
    ValidReal := True
  Else
  Begin
    If Copy (Str, 1, 1) = '.' Then
      Str := '0' + Str;
    If (Copy (Str, 1, 1) = '-') And (Copy (Str, 2, 1) = '.') Then
      Insert ('0', Str, 2);
    If Str [Length (Str) ] = '.' Then
      Delete (Str, Length (Str), 1);
    Val (Str, temp, code);
    ValidReal := (Code = 0);
  End;
End; {ValidReal}

Function StrToReal (Str: String): Extended;
Var
  code : Integer;
  Temp : Extended;
Begin
  If Length (Str) = 0 Then
    StrToReal := 0
  Else
  Begin
    If Copy (Str, 1, 1) = '.' Then
      Str := '0' + Str;
    If (Copy (Str, 1, 1) = '-') And (Copy (Str, 2, 1) = '.') Then
      Insert ('0', Str, 2);
    If Str [Length (Str) ] = '.' Then
      Delete (Str, Length (Str), 1);
    Val (Str, temp, code);
    If code = 0 Then
      StrToReal := temp
    Else
      StrToReal := 0;
  End;
End; {StrToReal}

Function RealToStr (Number: Extended; Decimals: Byte): String;
Var Temp : String;
Begin
  Str (Number: 20: Decimals, Temp);
  Repeat
    If Copy (Temp, 1, 1) = ' ' Then Delete (Temp, 1, 1);
  Until Copy (temp, 1, 1) <> ' ';
  If Decimals = Floating Then
  Begin
    Temp := Strip ('R', '0', Temp);
    If Temp [Length (temp) ] = '.' Then
      Delete (temp, Length (temp), 1);
  End;
  RealToStr := Temp;
End; {RealToStr}

Function StrToInt (Str: String): LongInt;
Var
  code : Integer;
  Temp : LongInt;
Begin
  If Length (Str) = 0 Then
    StrToInt := 0
  Else
  Begin
    Val (Str, temp, code);
    If code = 0 Then
      StrToInt := temp
    Else
      StrToInt := 0;
  End;
End;

Function HEXStrToLong (Str: String): LongInt;
{}
Begin
  If Str = '' Then
    HEXStrToLong := 0
  Else
  Begin
    If Str [1] <> '$' Then
      Str := '$' + Str;
    HEXStrtoLong := StrToInt (Str);
  End;
End; {HEXStrToLong}

Function Decimals (L: Byte): Byte;
{}
Var
  Expnt: Byte;
  Temp : ShortInt;
Begin
  {$IFDEF FLOAT}
  Expnt := 4;
  {$ELSE}
  {$IFDEF FLOATEM}
  Expnt := 4;
  {$ELSE}
  Expnt := 2;
  {$ENDIF}
  {$ENDIF}
  Temp := L - Expnt - 5;
  If temp > 0 Then
    Decimals := Temp
  Else
    Decimals := 0;
End; {Decimals}

Function RealToSciStr (Number: Extended; D: Byte): String;         {1.00b,1.00c}
{Credits: Michael Harris, Houston.
          Peter Sands, Australia
          Frans van Capelle, Amsterdam
 Thanks!}
Const
  DamnNearUnity = 9.99999999E-01;
Var
  Temp : Extended;
  Power: Integer;
  Value: String;
  Sign : Char;
  Expnt: Byte;
Begin
  If Number = 1.0 Then
    RealToSciStr := '1.000'
  Else If Number = 0.0 Then   {1.00a}
    RealToSciStr := '0.000'
  Else
  Begin
    Temp := Number;
    Power := 0;
    If Abs (Number) > 1.0 Then
    Begin
      While Abs (Temp) >= 10.0 do
      Begin
        Inc (Power);
        Temp := Temp / 10.0;
      End;
      Sign := '+';
    End
    Else
    Begin
      While Abs (Temp) < DamnNearUnity do
      Begin
        Inc (Power);
        Temp := Temp * 10.0;
      End;
      Sign := '-';
    End;
    Value := RealToStr (Temp, D);
    {$IFDEF FLOAT}
    Expnt := 4;
    {$ELSE}
    {$IFDEF FLOATEM}
    Expnt := 4;
    {$ELSE}
    Expnt := 2;
    {$ENDIF}
    {$ENDIF}
    RealToSciStr := Value+ 'E' + Sign + Padright (IntToStr (Power), Expnt, '0');
  End;
End; {RealToSciStr}

Function NthNumber (InStr: String; Nth: Byte) : Char;
{Returns the nth number in an alphanumeric string}
Var
  Counter : Byte;
  B, Len : Byte;
Begin
  Counter := 0;
  B := 0;
  Len := Length (InStr);
  Repeat
    Inc (B);
    If InStr [B] in ['0'..'9'] Then
      Inc (Counter);
  Until (Counter = Nth) Or (B = Len);
  If counter = Nth Then  {1.00}
    NthNumber := InStr [B]
  Else
    NthNumber := #0;
End; {NthNumber}

Function FormatHourMin (TotalSecs: LongInt): String;
Var
  Min, Hore : LongInt;
Begin
  Hore := TotalSecs Div 60;
  Min := TotalSecs Mod 60;
  FormatHourMin := padright (inttoStr (Hore), 2, '0') + ':' + padright (inttoStr (Min), 2, '0');
End;

Function FormatMinSec (TotalSecs: LongInt): String;
Var
  Min, Sec : LongInt;
  S : String;
Begin
  Min := TotalSecs Div 60;
  Sec := TotalSecs Mod 60;
  Str (Sec: 2, S);
  If S [1] = ' ' Then
    S [1] := '0';
  FormatMinSec := inttoStr (Min) + ':' + S;
End;

Function FormatMinTenths (TotalSecs : LongInt) : String;
Var
  Min : Real;
  S : String;
Begin
  Min := TotalSecs / 60;
  Str (Min: 6: 1, S);
  FormatMinTenths := S;
End;

Function NextParan (S: String): Byte;
Var
  A, B: Byte;
Begin
  A := 1;
  For B := 1 to Length (S) do Begin
    If S [B] = '(' Then Inc (A)
    Else If S [B] = ')' Then Begin
      Dec (A);
      If A <> 0 Then Continue;
      NextParan := B;
      Exit;
    End;
  End;
End;

Function AntiPipe (S: String): String;
var
  b: byte;
begin
  b := 1;
  while b <= length (s) do begin
    if (s [b] = '|') and (b + 2 <= length (s)) and ((S [succ (b)] in digitset) or (ucase (S [succ (b)]) = 'B')) and
      (S [b + 2] in digitset) then begin
        delete (s, b, 3);
        dec (b);
      end;
    inc (b);
  end;
  AntiPipe := s;
end;

Function PipeLen (S: String): Byte;
begin
  PipeLen := Length (AntiPipe (S));
end;

  function HexB(B : Byte) : string;
    {-Return hex string for Byte}
  begin
    HexB[0] := #2;
    HexB[1] := Digits[B shr 4];
    HexB[2] := Digits[B and $F];
  end;

  function HexW(W : Word) : string;
    {-Return hex string for word}
  begin
    HexW[0] := #4;
    HexW[1] := Digits[hi(W) shr 4];
    HexW[2] := Digits[hi(W) and $F];
    HexW[3] := Digits[lo(W) shr 4];
    HexW[4] := Digits[lo(W) and $F];
  end;

  function HexL (L: LongInt) : string;
    {-Return hex string for LongInt}
  begin
    with LH (L) do
      HexL := HexW (H) + HexW (L);
  end;

  function HexPtr (P: Pointer) : string;
    {-Return hex string for pointer}
  begin
    HexPtr := HexW (Seg (P^)) + ':' + HexW (Ofs (P^));
  end;

function remchars (rem, s: string): String;
var
  b: byte;
begin
  b := 1;
  while b <= length (s) do begin
    if pos (s [b], rem) <> 0 then begin
      delete (s, b, 1);
      dec (b);
    end;
    inc (b);
  end;
  remchars := s;
end;

End.
