Unit totINPUT;
{$I Sys75.Inc}

Interface

Uses
  DOS, CRT;

Const
  StuffBufferSize = 30;

Type
  InputIdleProc    = Procedure;
  InputPressedProc = Procedure (Var W: Word);

pKeyOBJ = ^KeyOBJ;
KeyOBJ = Object
           vBuffer: Array [1..StuffBufferSize] Of Word;
           vBufferHead: Word;         {next character from buffer}
           vBufferTail: Word;          {last valid character in buffer}
           vLastkey: Word;            {the last key pressed}
           vClick: Boolean;           {click after every keypress?}
           vHorizSensitivity: Byte;   {no of characters}
           vVertSensitivity: Byte;    {      -"-       }
           vWaitForDouble: Boolean;
           vIdleHook: InputIdleProc;
           vPressedHook: InputPressedProc;
           vExtended : Boolean;       {is it an extended keyboard}
           vButtons : Byte;
           vSlowdelay: Integer;       {time to wait for double click}
           vTimeOutCount: LongInt;
           vTimeOut: Word;
           vTimeOutChar: Word;
           {methods...}
           Constructor Init;
           Procedure   SetSlowDelay (Del: Integer);
           Procedure   SetTimeOut (t, c: Word);
           Procedure   AssignIdleHook (PassedProc: InputIdleProc);
           Procedure   AssignPressedHook (PassedProc: InputPressedProc);
           Function    Extended: Boolean;
           Procedure   SetCaps (On: Boolean);
           Procedure   SetNum (On: Boolean);
           Procedure   SetScroll (On: Boolean);
           Function    GetCaps: Boolean;
           Function    GetNum: Boolean;
           Function    GetScroll: Boolean;
           Procedure   SetRepeatRate (Delay, Rate: Byte);
           Procedure   SetFast;
           Procedure   SetSlow;
           Procedure   SetClick (On: Boolean);
           Procedure   SetDouble (On: Boolean);
           Function    GetDouble: Boolean;
           Procedure   Click;
           Procedure   SetHoriz (Sensitivity: Byte);
           Procedure   SetVert (Sensitivity: Byte);
           Procedure   GetInput;
           Function    LastKey: Word;
           Function    LastChar: Char;
           Function    ExtendedKey (Var K: Byte): Boolean;
           Function    ReadKey: Char;
           Function    GetKey: Word;
           Procedure   FlushBuffer;
           Procedure   StuffBuffer (W: Word);
           Procedure   StuffBufferStr (Str: String);
           Function    KeyPressed: Boolean;
           Procedure   DelayKey (Mills: LongInt);
           Function    AltPressed: Boolean;
           Function    CtrlPressed: Boolean;
           Function    LeftShiftPressed: Boolean;
           Function    RightShiftPressed: Boolean;
           Function    ShiftPressed: Boolean;
           Destructor  Done;
         End; {KeyOBJ}

Procedure NoInputIdleHook;
Procedure NoInputPressedHook (Var W: Word);
Function  Altkey (K: Word): Word;
Procedure InputInit;

Var
  Key:   ^KeyOBJ;
  BreakOut : Boolean;

Implementation

Uses
  Spuds;

Var
  KeyStatusBits : ^Word; {1.10}
  BiosTime      : LongInt Absolute $0:$046C;

  {|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||}
  {                                                               }
  {     U N I T   P R O C E D U R E S   &   F U N C T I O N S     }
  {                                                               }
  {|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||}

  {$F+}
  Procedure NoInputIdleHook;
  {empty procs}
Begin End; {NoInputIdleHook}

 Procedure NoInputPressedHook (Var W: Word);
 {empty procs}
 Begin End; {NoInputPressedHook}

Function Altkey (K: Word): Word;
{returns the Alt keycode equivalent of a number or letter}
Var AK: Word;
Begin
  Case K Of
    65: AK := 286; 66: AK := 304; 67: AK := 302; 68: AK := 288; 69: AK := 274; 70: AK := 289;
    71: AK := 290; 72: AK := 291; 73: AK := 279; 74: AK := 292; 75: AK := 293; 76: AK := 294;
    77: AK := 306; 78: AK := 305; 79: AK := 280; 80: AK := 281; 81: AK := 272; 82: AK := 275;
    83: AK := 287; 84: AK := 276; 85: AK := 278; 86: AK := 303; 87: AK := 273; 88: AK := 301;
    89: AK := 277; 90: AK := 300; 48: AK := 385;
    Else If (K >= 49) And (K <= 57) Then
      AK := K + 327
    Else
      AK := 0;
  End; {case}
  AltKey := AK;
End; {AltKey}

{|||||||||||||||||||||||||||||||||||||||}
{                                       }
{     K e y O B J    M e t h o d s      }
{                                       }
{|||||||||||||||||||||||||||||||||||||||}
Constructor KeyOBJ. Init;
{}
Var
  ExtStatus: Pointer;  {1.10}
Begin
  ExtStatus := Ptr ($0000, $0496);
  vExtended := (Byte (ExtStatus) <> 0);
  vIdleHook := NoInputIdleHook;
  vPressedHook := NoInputPressedHook;
  vBufferHead := 1;
  vBufferTail := 1;
  vHorizSensitivity := 1;
  vVertSensitivity := 1;
  vClick := False;
  vLastKey := 0;
  vWaitForDouble := False;
  vButtons := 0;
  vSlowDelay := 350;    {was 200}
  vTimeOut := 0;
  vTimeOutChar := 0;
End; {KeyOBJ.Init}

Procedure KeyOBJ. SetSlowDelay (Del: Integer);  {1.00f}
{}
Begin
  If Del >= 0 Then
    vSlowDelay := Del;
End; {KeyOBJ.SetSlowDelay}

Procedure KeyOBJ. AssignIdleHook (PassedProc: InputIdleProc);
{}
Begin
  vIdleHook := PassedProc;
End; {KeyOBJ.AssignIdleHook}

Procedure KeyOBJ. AssignPressedHook (PassedProc: InputPressedProc);
{}
Begin
  vPressedHook := PassedProc;
End; {KeyOBJ.AssignPressedHook}

Function KeyOBJ. Extended: Boolean;
{}
Begin
  Extended := vExtended;
End; {KeyOBJ.Extended}

Procedure KeyOBJ. SetCaps (On: Boolean);
{}
Begin
  If On Then
    KeyStatusBits^ := (KeyStatusBits^ Or $40)
  Else
    KeyStatusBits^ := (KeyStatusBits^ And $BF);
End; {KeyOBJ.SetCaps}

Procedure KeyOBJ. SetNum (On: Boolean);
{}
Begin
  If On Then
    KeyStatusBits^ := (KeyStatusBits^ Or $20)
  Else
    KeyStatusBits^ := (KeyStatusBits^ And $DF);
End; {KeyOBJ.SetNum}

Procedure KeyOBJ. SetScroll (On: Boolean);
{}
Begin
  If On Then
    KeyStatusBits^  := (KeyStatusBits^  Or $10)
  Else
    KeyStatusBits^  := (KeyStatusBits^  And $EF);
End; {KeyOBJ.SetScroll}

Function KeyOBJ. GetCaps: Boolean;
{}
Var CapsOnW : Word;
Begin
  CapsOnW := System. Swap (KeyStatusBits^ );
  GetCaps := (CapsOnW And $4000) <> 0;
End; {KeyOBJ.GetCaps}

Function KeyOBJ. GetNum: Boolean;
{}
Var NumOnW : Word;
Begin
  NumOnW := System. Swap (KeyStatusBits^ );
  GetNum := (NumOnW And $2000) <> 0;
End; {KeyOBJ.GetNum}

Function KeyOBJ. GetScroll: Boolean;
{}
Var ScrollOnW : Word;
Begin
  ScrollOnW := System. Swap (KeyStatusBits^ );
  GetScroll := (ScrollOnW And $1000) <> 0;
End; {KeyOBJ.GetScroll}

Procedure KeyOBJ. SetRepeatRate (Delay, Rate: Byte);
{}
Var Regs : Registers;
Begin
  With Regs do
  Begin
    AH := 3;
    AL := 5;
    BL := Rate;
    BH := Pred (Delay);
    Intr ($16, Regs);
  End;
End; {KeyOBJ.SetRepeatRate}

Procedure KeyOBJ. SetFast;
{}
Begin
  SetRepeatRate (1, 0);
End; {KeyOBJ.SetFast}

Procedure KeyOBJ. SetSlow;
{}
Begin
  SetRepeatRate (2, $14);
End; {KeyOBJ.SetSlow}

Procedure KeyOBJ. SetHoriz (Sensitivity: Byte);
{}
Begin
  vHorizSensitivity := Sensitivity;
End; {KeyOBJ.SetHoriz}

Procedure KeyOBJ. SetVert (Sensitivity: Byte);
{}
Begin
  vVertSensitivity := Sensitivity;
End; {KeyOBJ.SetHoriz}

Procedure KeyOBJ. SetClick (On: Boolean);
{}
Begin
  vClick := On;
End; {KeyOBJ.SetClick}

Procedure KeyOBJ. SetDouble (On: Boolean);
{}
Begin
  vWaitForDouble := On;
End; {KeyOBJ.SetDouble}

Function KeyOBJ. GetDouble: Boolean;
{}
Begin
  GetDouble := vWaitForDouble;
End; {KeyOBJ.GetDouble}

Procedure KeyOBJ. Click;
{}
Begin
  Sound (1000);
  Sound (50);
  Delay (5);
  NoSound;
End; {KeyOBJ.Click}

Function KeyOBJ. ExtendedKey (Var K: Byte): Boolean;  {1.00d}
Var
  Regs: Registers;
Begin
  With Regs do
  Begin
    If vExtended Then
      AH := $10
    Else
      AH := $0;
    Intr ($16, Regs);
    If AL = 0 Then Begin
      K := AH;
      ExtendedKey := True;
    End Else Begin
      K := AL;
      ExtendedKey := False;
    End;
  End;
End; {KeyOBJ.ExtendedKey}

Function KeyOBJ. ReadKey: Char;
Begin
  ReadKey := Crt. ReadKey;
End; {KeyOBJ.ReadKey}

Procedure KeyOBJ. GetInput;
{waits for a keypress or mouse activity}
Const
  H = 40;
  V = 13;
  QwikDelay = 20;
  LastPress: LongInt = 0;
  ClockTicks = 18.2;
Var
  L, C, R : Boolean;
  Action: Boolean;
  Finished: Boolean;
  ThisPress: LongInt;
  Temp, TempX, TempY, X, Y: Byte;
  CH : Char;
  KeyWord : Word;
  InitDelay: Word;
  LeftPresses, RightPresses, CenterPresses: Word;
  ButtonCombinations: Byte;

   Function ReadFromBuffer: Boolean;  {1.00e}
   Begin
     If vBufferHead <> vBufferTail Then  {read from object buffer}
     Begin
       Keyword := vBuffer [vBufferHead];
       If vBufferHead < StuffBufferSize Then
         Inc (vBufferHead)
       Else
         vBufferHead := 1;
       ReadFromBuffer := True;
     End
     Else
       ReadFromBuffer := False;
   End;

Begin
  vLastKey := 0;
  BreakOut := False;
  If vWaitForDouble Then
    InitDelay := vSlowdelay
  Else
    InitDelay := 100;
  If Not ReadFromBuffer Then
  Begin
    Action := False;
    Finished := False;
    vTimeOutCount := BiosTime;
    Repeat
      vIdleHook;   {call the users idle hook procedure}
      If Hung Then Begin
        Finished := True;
        Keyword := 0;
      End;
      If vTimeOut <> 0 Then if Et (vTimeOutCount) >= vTimeOut Then BreakOut := True;
      If Breakout Then Begin
        Finished := True;
        vPressedHook (Keyword);
        KeyWord := vTimeOutChar;
        vtimeoutchar := 0;
        vTimeOut := 0;
      End;
      If ReadFromBuffer Then Finished := True;
      If Finished Or KeyPressed Then Action := True;
    Until Action;
    If Not finished Then
    Begin
      CH := ReadKey;
      If CH = #0 Then
      Begin
        CH := ReadKey;
        Keyword := 256 + Ord (CH);
        If (KeyWord >= 327) And (Keyword <= 339) Then
        Begin
          If AltPressed Then
            Inc (Keyword, 80)
          Else If (ShiftPressed And vExtended) Then  {1.00c}
            Inc (Keyword, 100)
          Else If CtrlPressed Then
            Inc (Keyword, 120);
        End;
      End
      Else
        KeyWord := Ord (CH);
    End;

  End;
  vPressedHook (Keyword);
  vLastKey := Keyword;
  If vClick Then
    Click;
End; {KeyOBJ.GetInput}

Procedure KeyObj. SetTimeOut (t, c: Word);
Begin
  vTimeOut := t;
  vTimeOutChar := c;
End;

Function KeyOBJ. Lastkey: Word;
{}
Begin
  LastKey := vLastKey;
End; {KeyOBJ.Lastkey}

Function KeyOBJ. GetKey: Word;
{}
Begin
  GetInput;
  GetKey := vLastKey;
End; {KeyOBJ.GetKey}

Function KeyOBJ. LastChar: Char;
{}
Begin
  If vLastKey < 256 Then
    LastChar := Chr (LastKey)
  Else
    LastChar := #0;
End; {KeyOBJ.LastChar}

Procedure KeyOBJ. FlushBuffer;
{}
Var Regs: Registers;
Begin
  vBufferTail := VBufferHead; {empty program buffer}
  With Regs do
  Begin
    AX := ($0c ShL 8) Or 6;
    DX := $00ff;
  End;
  Intr ($21, Regs);
End; {KeyOBJ.FlushBuffer}

Procedure KeyOBJ. StuffBuffer (W: Word);
{adds word to program keyboard buffer}
Begin
  If (vBufferTail + 1 = vBufferHead) 
     Or ( (vBufferTail = StuffBufferSize) And (vBufferHead = 1) ) 
  Then
    Exit; {buffer full}     
  vBuffer [vBufferTail] := W;
  If vBufferTail < StuffBufferSize Then
    Inc (vBufferTail)
  Else
    vBufferTail := 1;
End; {KeyOBJ.StuffBuffer}

Procedure KeyOBJ. StuffBufferStr (Str: String);
{}
Var I, L : Byte;
Begin
  If Str <> '' Then
  Begin
    I := 1;
    L := Length (Str);
    If L > StuffBufferSize Then
      L := StuffBufferSize;
    While I <= L do
    Begin
      StuffBuffer (Ord (Str [I] ) );
      Inc (I);
    End;
  End; 
End; {KeyOBJ.StuffBufferStr}

Function KeyOBJ. KeyPressed: Boolean;   {1.00d}
Var
  Regs: Registers;
Begin
   if (vBufferTail <> vBufferHead) then
      KeyPressed := true
   else
   begin
      if vExtended then
         Regs.Ah := $11
      else
         Regs.Ah := $01;
      intr($16,Regs);
      KeyPressed := (Regs.Flags and FZero) <> $40;
   end;
End; {KeyOBJ.KeyPressed}

Procedure KeyOBJ. DelayKey (Mills: LongInt);
{}
Var
  EndTime: LongInt;
  Now: LongInt;

   Procedure SetNull;
   Begin
     vLastKey := 0;
   End;

Begin
  If Mills <= 0 Then
    SetNull
  Else
  Begin
    {$IFDEF DPMI}
    EndTime := MemL [Seg0040:$006C] + Trunc ( (Mills / 1000) * 18.2);
    Repeat
      Now := MemL [Seg0040:$006C];
    Until KeyPressed Or (Now >= EndTime);
    {$ELSE}
    EndTime := MemL [$40:$6C] + Trunc ( (Mills / 1000) * 18.2);
    Repeat
      Now := MemL [$40:$6C];
    Until KeyPressed Or (Now >= EndTime);
    {$ENDIF}
    If KeyPressed Then
      GetInput
    Else
      SetNull;
  End;
End; {KeyOBJ.DelayKey}

Function KeyOBJ. AltPressed: Boolean;
Var
  AltW : Word;
Begin
  AltW := System. Swap (KeyStatusBits^ );
  AltPressed := (AltW And $0800) <> 0;
End; {KeyOBJ.AltPressed}

Function KeyOBJ. CtrlPressed: Boolean;
Var
  CtrlW : Word;
Begin
  CtrlW := System. Swap (KeyStatusBits^ );
  CtrlPressed := (CtrlW And $0400) <> 0;
End; {KeyOBJ.CtrlPressed}

Function KeyOBJ. LeftShiftPressed: Boolean;
{}
Var LSW : Word;
Begin
  LSW := System. Swap (KeyStatusBits^ );
  LeftShiftPressed := (LSW And $0200) <> 0;
End; {LeftShiftPressed}

Function KeyOBJ. RightShiftPressed: Boolean;
{}
Var RSW : Word;
Begin
  RSW := System. Swap (KeyStatusBits^ );
  RightShiftPressed := (RSW And $0100) <> 0;
End; {RightShiftPressed}

Function KeyOBJ. ShiftPressed: Boolean;
{}
Var SW : Word;
Begin
  SW := System. Swap (KeyStatusBits^ );
  ShiftPressed := ( (SW And $0200) <> 0) Or ( (SW And $0100) <> 0);
End; {ShiftPressed}

Destructor KeyOBJ. Done;
{}
Begin End; {of desc KeyOBJ.Done}
{|||||||||||||||||||||||||||||||||||||||||||||||}
{                                               }
{     U N I T   I N I T I A L I Z A T I O N     }
{                                               }
{|||||||||||||||||||||||||||||||||||||||||||||||}
Procedure InputInit;
{initilizes objects and global variables}
Begin
  {$IFDEF DPMI}
  KeyStatusBits := Ptr (Seg0040, $0017);
  {$ELSE}
  KeyStatusBits := Ptr ($0040, $0017);
  {$ENDIF}
  New(Key, Init);
End;

{end of unit - add intialization routines below}
Begin
  InputInit;
End.
