
 (*                                                                        *)
 (*                       S y s t e m / 7 5     S                        *)
 (*                                                                        *)
 (*                           Version 1.05 eta                            *)
 (*                                                                        *)
 (*                    Compiled Saturday, July 14, 1995                    *)
 (*                                                                        *)
 (*                   Copyright (c) 1995, Spectre Coding                   *)
 (*                                                                        *)
 (*                     Author: Clay McClure (maxwell)                     *)
 (*                                                                        *)

Program System75;
{$I apdefine.inc}
{$I sys75.inc}
{$M 30000, 0, 245760}

Uses
  OverInit, Crt, Dos, Spuds,
  TotFast, TotInput, TotKey, TotStr, TotMisc, TotDate,
  ApMisc, OoCom, ApPort, OoModem,
  Misc, Clocks, Sysop, Nuv, Comm, StatusBar, ScrBack, Archive, ScrSave,
  Emu, RemEmu, Events, Users, MiscSys, InfoForm, BlackLst, fonts, FileMenu,
  DumbTerm, HostMode, Hookers;

 {$O TotReal  } {$O TotMsg    } {$O TotWin   } {$O TotList   }
 {$O TotIo1   } {$O TotMisc   } {$O TotStr   }
 {$O OoXModem } {$O OoYModem  } {$O OoZModem } {$O OoKermit  }
 {$O OoAscii  } {$O OoModem   } {$O OoAbsPcl }
 {$O Acs      } {$O FeedBack  } {$O Clocks   } {$O Comm      }
 {$O ScrSave  } {$O Scripts   } {$O StatusBar} {$O Regs      }
 {$O Misc     } {$O Control   } {$O Matrix   } {$O Login     }
 {$O Crunches } {$O NewScan   } {$O DataArea } {$O TopTen    }
 {$O Fonts    } {$O Main      } {$O Email    } {$O QwkMail   }
 {$O Crc      } {$O Door      } {$O FileMenu } {$O MultNode  }
 {$O Users    } {$O Events    } {$O MsgSpon  } {$O FileSpon  }
 {$O Chats    } {$O Menus     } {$O MiscSys  } {$O Voting    }
 {$O Sysop    } {$O JoinConf  } {$O Nuv      } {$O Messages  }
 {$O InfoForm } {$O Fades     } {$O BlackLst } {$O ScrBack   }
 {$O HostMode } {$O Protocols } {$O DumbTerm } {$O Archive   }

Type
  pSys75 = ^tSys75;
  tSys75 = Object
             Constructor Init;
             Procedure   Run;
             Destructor  Done;
           End;

Var
  Sys75: pSys75;

  Constructor tSys75. Init;
  Begin
    InitVars;
    If Not InstallHook Then Begin
      ParseParams;
      MultiTask;
    End;

    MoreInits;
    ReadConfiguration;
    EvenMoreInits;
    Registration (True);
    With Event^ do Begin
      Load;
      CalcNext;
      SetToggles;
    End;

    Scroll^. Clear;
    ActParams;
    InitCum;

    If Not FrontEnd And Not DosSysAuto Then OpeningScreen;
    IdleTimer := BiosTime;
    inhelp := false;
  End;

  Procedure tSys75. Run;
  Const
    qwe: array [false..true] of byte = (1, 9);
  Var
    N: DateTimeRec;
    F: File of SetRec;
    ndf: file of nodedatatype;

    procedure after1;
    begin
      vDone := True;
      ScrSavProc;
      AllowScrSav (True);

      If currentmode <> 25 Then Setmode (25, true);

      If DumpInfo Then Begin
        {$I-}
        Close (InfoDump);
        {$IFDEF Debug}{$I+}{$ENDIF}
        If IoResult <> 0 Then ;
        DumpInfo := False;
      End;

      If TextTrap Then Begin
        {$I-}
        Close (TrapFile);
        {$IFDEF Debug}{$I+}{$ENDIF}
        If IoResult <> 0 Then ;
        TextTrap := False;
      End;

      copylogs;

      bbs^. resetbbsvars;
      loadsysoprec (false, user);
      BaudRate := 0;
      Online := False;
      Modem^. ConnectSpeed := 0;
      sentata := 0;

      InitEmulation;
      Scroll^. Clear;

      if vbatch <> nil then dispose (vbatch, done);
      if vbatch <> nil then dispose (ubatch, done);
      vbatch := nil;
      ubatch := nil;
    end;

    procedure after2;
    begin
      if not localonly then begin
        uart^. flushinbuffer;
        uart^. flushoutbuffer;
      end;

      If ReInitCum Then Begin
        Assign (ndf, Uc. DataPath + 'Node_' + IntToStr (NodeNumber) + '.Dat');
        reset (ndf);
        read (ndf, nodedata);
        close (ndf);
        LocalOnly := nodedata. port = com0;
        if not localonly then begin
          If Modem <> Nil Then Dispose (Modem, Done);
          If Uart <> Nil Then Dispose (Uart, Done);
          ClrScreen (8);
          InitEmulation;
          ComWriteLn ('|15Reinitializing communications devices|08:'^M^J);
          InitCum;
          iDelay (500);
          ReInitCum := False;
          ReInit := False;
        end;
      End;

      ShowWfc;

      If ReInit Then InitModem (1);
      ReInit := False;

      now (n);
      If Today <> N. d Then NewDay;
    end;

  var
    tmp: word;
  Begin
    Repeat
      Current := Waiting;
      InitParser;
      Key^. AssignIdleHook (MainIdle);
      Key^. AssignPressedHook (MainPressed);
      showtoggles;
      DisplayLocalStats;
      GetIdles;
      Clock^. Change (41, 12, 15);
      Clock^. Show (True);

      If NextEvent. Name <> '' Then
        Screen^. WriteAt (44, 17, 15, FormatHourMin (Event^. TimeTil))
      Else
        Screen^. WriteAt (44, 17, 15, '    ');

      Event^. ShowNext;

      GetFreeSpace;
      Status ('Waiting for calls');
      ReInit := False;

      If Event^. GetNextStrict = 1 Then Begin
        Status ('Waiting for strict event in 1 minute');
        ModemStrFix (NodeData. OffHookStr);
      End;

      Repeat
        Key^. vIdleHook;

        If ForceExit > -1 Then Exit;

        If Not LocalOnly And MonitorRinging Then Begin
          IsRinging := False;
          RingCount := 0;
          SentATA := 0;
          RingTag := False;
          for tmp := 1 to 2000 do begin
            if uart^. checkdcd then break;
            idelay (1);
          end;
          if not uart^. checkdcd and (tmp = 2000) then begin
            status ('DCD signal not present after 2 seconds');
            log (2, 'DCD signal not present after 2 seconds');
            idelay (500);
            recycle;
            break;
          end;
          BBS^. Run (False, True);
          Break;
        End;

        If Key^. KeyPressed Then
          Case Key^. GetKey of
            0: ;
            kA, kSftA, kAltA:
                             If SentATA = 0 Then
                             If Not LocalOnly Then
                               If Not Uart^. CheckDCD Then Begin
                                 RingTag := True;
                                 IsRinging := True;
                                 RingCount := NodeData. MaxRings;
                               End Else
                                 SentATA := 3;
            kB, kSftB, kAltB:
                             If SentATA = 0 Then Begin
                               If Not Prep (True, True, 'Blacklist') Then Break;
                               BlackList;
                               Break;
                             End;
            kC, kSftC, kAltC:
                             If SentATA = 0 Then Begin
                               If Not Prep (True, True, 'Configuration') Then Break;
                               SysConfig (False, False);
                               Break;
                             End;
            kD, kSftD, kAltD: If (SentATA = 0) And Not LocalOnly Then Begin
                                Term^. Run;
                                Break;
                              End;
            kE, kSftE, kAltE:
                             If SentATA = 0 Then Begin
                               If Not Exist (NodeData. NodePath + 'Error.Log') Then Continue;
                               If Not Prep (True, True, 'Error Log') Then Break;
                               ShowErrorLog;
                               Break;
                             End;
            kF, kSftF, kAltF:
                             If SentATA = 0 Then Begin
                               If Not Prep (True, True, 'Edit File Areas') Then Break;
                               editfareas;
                               Break;
                             End;
            kG, kSftG, kAltG:
                             If SentATA = 0 Then Begin
                               If Not Prep (True, True, 'Goto Menu') Then Break;
                               GotoMenu;
                               Break;
                             End;
            kH, kSftH, kAltH: If Not LocalOnly Then Begin
                                iDelay (50);
                                Uart^. PutChar (#27);
                                iDelay (50);
                                ModemStrFix (NodeData. HangupStr);
                                IsRinging := False;
                                RingCount := 0;
                                RingTag := False;
                                SentATA := 0;
                                Status ('Waiting for calls');
                              End;
            kI, kSftI, kAltI:
                             If Not LocalOnly Then Begin
                               InitModem (1);
                               iDelay (250);
                               IsRinging := False;
                               RingCount := 0;
                               RingTag := False;
                               SentATA := 0;
                               Status ('Waiting for calls');
                             End;
            kJ, kAltJ, kSftJ:
                             Begin
                               DosShell (False);
                               Break;
                             End;
            kK, kSftK, kAltK:
                             If SentATA = 0 Then Begin
                               If Not Prep (True, True, 'Make User') Then Break;
                               MakeUser (True);
                               Break;
                             End;
            kL, kSftL, kAltL:
                             If SentATA = 0 Then Begin
                               If Not Prep (True, True, 'Show Logs') Then Break;
                               ShowLogs;
                               Break;
                             End;
            kM, kSftM, kAltM:
                             If SentATA = 0 Then Begin
                               If Not Prep (True, True, 'Menu Editor') Then Break;
                               MenuEditor;
                               Break;
                             End;
            kN, kSftN, kAltN:
                             If SentATA = 0 Then Begin
                               If Not Prep (True, True, 'New User Voting') Then Break;
                               RunNuv;
                               Break;
                             End;
            kO, kSftO, kAltO: If (SentATA = 0) And Not LocalOnly Then ModemStrFix (NodeData. OffHookStr);
            kP, kSftP, kAltP:
                             If SentATA = 0 Then Begin
                               If Not Prep (True, True, 'Menu/Stat Sets') Then Break;
                               SetEditor;
                               Break;
                             End;
            kQ, kSftQ, kAltQ:
                             If SentATA = 0 Then Begin
                               If Not Prep (True, True, 'Edit Message Bases') Then Break;
                               editmbases;
                               Break;
                             End;
            kR, kSftR, kAltR:
                             If SentATA = 0 Then Begin
                               If Not Prep (True, True, 'Conferences') Then Break;
                               ConfEditor;
                               Break;
                             End;
            kS, kSftS, kAltS:
                             If SentATA = 0 Then Begin
                               If Not Prep (True, False, 'Sysop Auto-Login') Then Break;
                               BBS^. Run (True, Not LocalOnly And Uart^. CheckDCD);
                               Break;
                             End;
            kT, kSftT, kAltT:
                             If SentATA = 0 Then Begin
                               If Not Prep (True, True, 'Strings Editor') Then Break;
                               StringsEditor;
                               Break;
                             End;
            kU, kSftU, kAltU:
                             If SentATA = 0 Then Begin
                               If Not Prep (True, True, 'User Editor') Then Break;
                               UserEditor ('');
                               Break;
                             End;
            kV, kSftV, kAltV:
                             If SentATA = 0 Then Begin
                               If Not Prep (True, True, 'Event Editor') Then Break;
                               EventEditor;
                               Break;
                             End;
            kW, kSftW, kAltW:
                             If SentATA = 0 Then Begin
                               If Not Prep (True, True, 'Infoforms') Then Break;
                               ViewInfoForm (0, 0);
                               Break;
                             End;
            kX, kSftX, kAltX:
                             If SentATA = 0 Then Begin
                               Screen^. Clear (0, ' ');
                               Screen^. GotoXY (1, 1);
                               Screen^. Attrib (1, 1, 80, 25, 7);
                               Clock^. Show (False);
                               InitEmulation;
                               loadsysoprec (false, user);
                               highestemu := termavt;

                               Assign (F, Uc. DataPath + 'StatSet.Dat');
                               Reset (F);
                               Seek (F, Pred (User. StatSet));
                               Read (F, CurStatSet);
                               Close (F);

                               fillin1 := 'Exit to OS';
                               pfile ('hdr.ans');
                               comwriteln ('');

                               Screen^. Write ('|09E|01xit |09n|01ow ');

                               If LiteBar (lbYes, false, true) <> lbYes Then Break;

                               If B (Uc. Options, LocalSec) Then Begin
                                 Screen^. CursOn;
                                 With Screen^ Do
                                   UpdateCursor (WhereX, WhereY);
                                 If Not GetSysopPW (False) Then Break;
                                 Screen^. CursOff;
                               End;

                               If not localonly and not uart^. checkdcd and Not GoOffHook (False) Then Break;

                               ForceExit := 0;
                               Exit;
                             End;
            kY, kSftY, kAltY:
                             If SentATA = 0 Then Begin
                               If Not Prep (True, True, 'Archiver Editor') Then Break;
                               ArcEditor;
                               Break;
                             End;
            kZ, kSftZ, kAltZ:
                             If SentATA = 0 Then Begin
                               If Not Prep (True, True, 'Protocol Editor') Then Break;
                               XferProtoEditor;
                               Break;
                             End;
            kSpc:
                             If SentATA = 0 Then Begin
                               If Not Prep (True, False, 'Local Login') Then Break;
                               BBS^. Run (False, Not LocalOnly And Uart^. CheckDCD);
                               Break;
                             End;
            kPlus:
                   Begin
                   End;
            kMinus:
                   Begin
                   End;
            kQuestion:
                   Begin
                     inhelp := true;
                     Clock^. Show (False);
                     ShowScreen (wfchelp);
                     key^. getkey;
                     ShowWfc;
                     Status ('Waiting for calls');
                     showtoggles;
                     DisplayLocalStats;
                     GetIdles;
                     Clock^. Show (True);
                     If NextEvent. Name <> '' Then
                       Screen^. WriteAt (44, 17, 15, FormatHourMin (Event^. TimeTil))
                     Else
                       Screen^. WriteAt (44, 17, 15, '    ');
                     Event^. ShowNext;
                     GetFreeSpace;
                     inhelp := false;
                   End;
            kF1..kF4: If SentATA = 0 Then Begin
                        RunIdle (Key^. LastKey - 314);
                        Break;
                      End;
            kF5: Toggle (ttPrn);
            kF6: Toggle (ttAvail);
            kF7: Toggle (ttSpkr);
            kF8: Toggle (ttMisc);
          End;
      Until False;
      After1;
      If ForceExit <> -1 Then Exit;
      After2;
    Until False;
  End;

  Destructor tSys75. Done;
  Begin
    SaveBoardData;
    ClosingScreen;
    {$I-}
    Close (StrFile);
    {$IFDEF Debug}{$I+}{$ENDIF}
    If IoResult <> 0 Then ;
  End;

Begin
  New (Sys75, Init);
  If (Sys75 <> Nil) And (ForceExit = -1) Then Begin
    If EventsForced Then Begin
      Prep (False, False, 'Checking for missed events to run');
      ComWriteln ('');
      Event^. RunForced;
    End Else If FrontEnd Then
      If Not LocalOnly and Not Uart^. CheckDCD Then Begin
        Screen^. Writeln ('|08carrier dropped');
        Delay (1000);
        ForceExit := 2;
      End Else
        BBS^. Run (False, True)
    Else If DosSysAuto Then Begin
      BBS^. Run (True, False);
      ForceExit := 0;
    End Else
      Sys75^. Run;
    Dispose (Sys75, Done);
  End Else
    If Sys75 = Nil Then Halt (ecOutOfMemory);

  PrepClose;
  CloseTot;
  Halt (ForceExit);
End.
