Unit ScrSave;
{$I Sys75.Inc}
{$D-,I-,L-,Q-,R-,S-}

Interface

Uses
  TotFast;

Type
  ColorValue =  Record
                  Red, Green, Blue: Byte;
                End;
  PaletteType = Array [0..255] Of ColorValue;

Procedure InitScrSav;
Procedure AllowScrSav (A: Boolean);
Procedure ScrSavProc;

Var
   vDone             : Boolean;
   vInScrSave        : Boolean;

Implementation

Uses
  Crt,
  Spuds, multi,
  TotMisc, TotSys,
  comm, Fades, Fonts, StatusBar, Misc, scrback, clocks;

Var
   vAllow            : Boolean;
   ScrSavMode        : Boolean;
   vTimer            : LongInt;
   Scr               : pScreenObj;
   L                 : LongInt;
   Cnt2              : Byte;
   Pal               : PaletteType;
   Pal2              : PaletteType;
   X1, Y1, X2, Y2, DX1, DX2, dy1, dy2 : Integer;
   PutLinePixel: Procedure (X, Y : Integer; Color : Byte);

Const
  MaxX = 319;
  MaxY = 199;
  HalfX = MaxX Div 2;
  HalfY = MaxY Div 2;

{$R-,Q-}
Procedure SetVGApalette;
Var
  I: Word;
Begin
  Port [$3C8] := 0;
  While ((Port [$3DA] And 8) <> 8) Do;
  Asm
    Mov CX, 768
    Mov DX, 3c9h
    Mov SI, Offset Pal
    @Jmp1:
    Lodsb
    Out DX, AL
    Loop @Jmp1
  End;
End;

Procedure ModeVGA; Assembler;
Asm
  Mov   AX, 13h
  Int   10h
End;

Procedure PutPixel (X, Y : Integer; Color : Byte); Far;
Begin
  mem [$A000: X + Y * 320] := Color;
End;

Function GetPixel (a, b : Integer) : Byte;
Begin
  GetPixel := mem [$A000: Word (320 * b + a) ]
End;

Procedure HLine (X1, X2, Y : LongInt; Color : Byte);
var
  q: longint;
Begin
  If X2 < X1 Then begin
    q := x1;
    x1 := x2;
    x2 := q;
  end;
  If X1 < 0 Then X1 := 0;
  If X1 > MaxX Then X1 := MaxX;
  If X2 < 0 Then X2 := 0;
  If X2 > MaxX Then X2 := MaxX;
  If (Y > 0) And (Y < MaxY) Then
    FillChar (mem [$A000: X1 + Y * 320], X2 - X1 + 1, Color);
End;

Procedure VLine (X, Y1, Y2 : LongInt; Color : Byte);
Var
  Y : Integer;
  q: longint;
Begin
  If y2 < y1 Then begin
    q := y1;
    y1 := y2;
    y2 := q;
  end;
  For Y := Y1 To Y2 Do
    PutPixel (X, Y, Color)
End;

Procedure Line (X1, Y1, X2, Y2: Integer; Color: Byte); Assembler;
Var
  diagonal_x_increment,
  diagonal_y_increment,
  short_distance,
  straight_x_increment,
  straight_y_increment,
  straight_count,
  diagonal_count: Integer;
  Asm
    mov AX, $a000
    mov ES, AX
    mov CX, 1
    mov DX, 1
    mov DI, Y2
    sub DI, Y1
    jge @keep_y
    neg DX
    neg DI
    @Keep_Y:
    mov diagonal_y_increment, DX
    mov SI, X2
    sub SI, X1
    jge @keep_x
    neg CX
    neg SI
    @Keep_X:
    mov diagonal_x_increment, CX
    cmp SI, DI
    jge @horz_seg
    mov CX, 0
    xchg SI, DI
    jmp @Save_Values
    @Horz_seg:
    mov DX, 0
    @Save_values:
    mov short_distance, DI
    mov straight_x_increment, CX
    mov straight_y_increment, DX
    mov AX, short_distance
    ShL AX, 1
    mov straight_count, AX
    sub AX, SI
    mov BX, AX
    sub AX, SI
    mov diagonal_count, AX
    mov CX, X1
    mov DX, Y1
    Inc SI
    mov AL, Color
    @Mainloop:
    Dec SI
    jz  @line_finished
    push AX
    push BX
    push CX
    push DX
    push SI

    push CX
    push DX
    push AX
    Call putlinepixel

    pop  SI
    pop  DX
    pop  CX
    pop  BX
    pop  AX
    cmp BX, 0
    jge @diagonal_line
    add CX, straight_x_increment
    add DX, straight_y_increment
    add BX, straight_count
    jmp @Mainloop
    @Diagonal_line:
    add CX, diagonal_x_increment
    add DX, diagonal_y_increment
    add BX, diagonal_count
    jmp @Mainloop
    @Line_Finished:
  End;

Procedure ClearScreen;
Begin
  FillChar (mem [$a000: 0], 64000, 0);
End;

Procedure PutSBobPixel (X, Y : Integer; Color : Byte); Far;
Var
  c : Byte;
Begin
  c := GetPixel (X, Y);
  Inc (c);
  If c > 255 Then c := 0;
  mem [$a000: X +  Y * 320] := c
End;

Procedure Redscale;
Var
  loopcnt : Integer;
Begin
  FillChar (pal, SizeOf (pal), 0);
  For loopcnt := 0 To 31 Do
  Begin
    pal [loopcnt].Red := loopcnt * 2;
    pal [63 - loopcnt].Red := loopcnt * 2;
    pal [loopcnt + 64].Red := loopcnt * 2;
    pal [127 - loopcnt].Red := loopcnt * 2;
    pal [loopcnt + 128].Red := loopcnt * 2;
    pal [191 - loopcnt].Red := loopcnt * 2;
    pal [loopcnt + 192].Red := loopcnt * 2;
    pal [255 - loopcnt].Red := loopcnt * 2;
  End;
  setvgapalette;
End;

Procedure Greenscale;
Var
  loopcnt : Integer;
Begin
  FillChar (pal, SizeOf (pal), 0);
  For loopcnt := 0 To 31 Do
  Begin
    pal [loopcnt].Green := loopcnt * 2;
    pal [63 - loopcnt].Green := loopcnt * 2;
    pal [loopcnt + 64].Green := loopcnt * 2;
    pal [127 - loopcnt].Green := loopcnt * 2;
    pal [loopcnt + 128].Green := loopcnt * 2;
    pal [191 - loopcnt].Green := loopcnt * 2;
    pal [loopcnt + 192].Green := loopcnt * 2;
    pal [255 - loopcnt].Green := loopcnt * 2;
  End;
  setvgapalette;
End;

Procedure Bluescale;
Var
  loopcnt : Integer;
Begin
  FillChar (pal, SizeOf (pal), 0);
  For loopcnt := 0 To 31 Do
  Begin
    pal [loopcnt].Blue := loopcnt * 2;
    pal [63 - loopcnt].Blue := loopcnt * 2;
    pal [loopcnt + 64].Blue := loopcnt * 2;
    pal [127 - loopcnt].Blue := loopcnt * 2;
    pal [loopcnt + 128].Blue := loopcnt * 2;
    pal [191 - loopcnt].Blue := loopcnt * 2;
    pal [loopcnt + 192].Blue := loopcnt * 2;
    pal [255 - loopcnt].Blue := loopcnt * 2;
  End;
  setvgapalette;
End;

Procedure GrayScale;
Var
  loopcnt : Integer;
Begin
  For loopcnt := 0 To 31 Do
  Begin
    pal [loopcnt].Red := loopcnt * 2;
    pal [loopcnt].Green := loopcnt * 2;
    pal [loopcnt].Blue := loopcnt * 2;
    pal [63 - loopcnt].Red := loopcnt * 2;
    pal [63 - loopcnt].Green := loopcnt * 2;
    pal [63 - loopcnt].Blue := loopcnt * 2;
    pal [loopcnt + 64].Red := loopcnt * 2;
    pal [loopcnt + 64].Green := loopcnt * 2;
    pal [loopcnt + 64].Blue := loopcnt * 2;
    pal [127 - loopcnt].Red := loopcnt * 2;
    pal [127 - loopcnt].Green := loopcnt * 2;
    pal [127 - loopcnt].Blue := loopcnt * 2;
    pal [loopcnt + 128].Red := loopcnt * 2;
    pal [loopcnt + 128].Green := loopcnt * 2;
    pal [loopcnt + 128].Blue := loopcnt * 2;
    pal [191 - loopcnt].Red := loopcnt * 2;
    pal [191 - loopcnt].Green := loopcnt * 2;
    pal [191 - loopcnt].Blue := loopcnt * 2;
    pal [loopcnt + 192].Red := loopcnt * 2;
    pal [loopcnt + 192].Green := loopcnt * 2;
    pal [loopcnt + 192].Blue := loopcnt * 2;
    pal [255 - loopcnt].Red := loopcnt * 2;
    pal [255 - loopcnt].Green := loopcnt * 2;
    pal [255 - loopcnt].Blue := loopcnt * 2;
  End;
  setvgapalette;
End;

Procedure InitStuff;
Begin
  X1 := Random (320);
  X2 := Random (320);
  Y1 := Random (200);
  Y2 := Random (200);
  DX1 := 1;
  DX2 := - 1;
  dy1 := 1;
  dy2 := - 1;
  ClearScreen;
End;

Procedure CheckBounds (Var a, b : Integer; c : Integer);
Begin
  If a > c Then
    b := - 1
  Else
    If a < 0 Then
      b := 1;
End;

Procedure RunScrSaveLoop;
Begin
  If Et (L) > 44 Then Begin
    L := BiosTime;
    Inc (Cnt2);
    Case Cnt2 Of
      1:
        Begin
          initstuff;
          grayscale;
        End;
      2:
        Begin
          initstuff;
          redscale;
        End;
      3:
        Begin
          initstuff;
          greenscale;
        End;
      4:
        Begin
          initstuff;
          bluescale;
        End;
      5:
        Begin
          cnt2 := 1;
          Initstuff;
          grayscale;
        End;
    End;
  End;
  Inc (X1, DX1);
  Inc (X2, DX2);
  Inc (Y1, dy1);
  Inc (Y2, dy2);
  CheckBounds (X1, DX1, 319);
  CheckBounds (X2, DX2, 319);
  CheckBounds (Y1, dy1, 199);
  CheckBounds (Y2, dy2, 199);
  Line (X1, Y1, X2, Y2, 1);
End;

Procedure AllowScrSav (A: Boolean);
Begin
  if not a then begin
    vDone := True;
    ScrSavProc;
  end;
  vAllow := A;
End;

procedure dotext;
begin
  Screen^. Clear (0, ' ');
  screen^. writeat (succ (random (67)), succ (random (currentmode)), succ (random (15)), '.screensaver.');
end;

Procedure ScrSavProc;
Begin
  If Not vAllow or (Uc. ScrSaverTime = 0) Then Exit;

  If Not vInScrSave Then Begin
    If vDone Then Begin
      vDone := False;
      vTimer := 0;
      L := BiosTime;
      Exit;
    End;

    If Et (L) < 18 Then Exit;

    L := BiosTime;
    Inc (vTimer);

    If vTimer >= Uc. ScrSaverTime * 60 Then Begin
      vInScrSave := True;
      New (Scr, Init);

      Scr^. Save;
      Screen^. CursOff;
      Clock^. Show (false);
      ScrSavMode := ExDispMode and (multiTasker = NoTasker);

      If ScrSavMode Then Begin
        ModeVGA;
        PutLinePixel := PutSbobPixel;
        Pal := Pal2;
        SetVgaPalette;
        GrayScale;
        InitStuff;
        Cnt2 := 1;
      End Else
        dotext;
    End;
  End Else if vdone then begin
    vDone := False;
    vInScrSave := False;

    If ScrSavMode Then Begin
      Asm
        Mov Ax, 0003h
        Int 10h
      End;
      Setmode (currentmode, false);
    End;

    Scr^. Display;
    Dispose (Scr, Done);
    Clock^. Show (true);

    If Current <> Waiting Then
      Screen^. CursOn
    else
      screen^. cursoff;

    vTimer := 0;
    L := BiosTime;
  End else
    If ScrSavMode Then
      RunScrSaveLoop
    else if et (l) > 54 then begin
      dotext;
      l := biostime;
    end;
End;

Procedure InitScrSav;
Var
  LoopCnt: Byte;
Begin
  vInScrSave := False;
  vDone := False;
  vTimer := 0;
  Cnt2 := 1;
  For LoopCnt := 1 To 255 Do
    GetCol (LoopCnt, Pal2 [LoopCnt].Red, Pal2 [LoopCnt].Green, Pal2 [LoopCnt].Blue);
  L := BiosTime;
End;

End.