Unit ScrBack;
{$I Sys75.Inc}
{$D-,I-,L-,Q-,R-,S-}

Interface

uses
  totfast;

Type
  tScrBack = Object
               Constructor Init (NumLines: Word);
               Procedure   AddLine (B: Byte; Boo: Boolean);
               Procedure   Clear;
               Procedure   Run;
               Destructor  Done;
               Private
                 ScrBackLines,
                 CurLine,
                 LinesSaved: LongInt;
                 SaveScreen: pScreenObj;
             End;

Const
  ScrBackRunnin: Boolean = False;

Var
  Scroll: ^tScrBack;

Implementation

Uses
  OpXms, Spuds, StatusBar, Clocks,
  TotInput, TotKey, TotStr, TotSys,
  DumbTerm, fonts, users;

Constructor tScrBack. Init (NumLines: Word);
Var
  L: LongInt;
  Scrap, Max, W: Word;
Begin
  If ScrBackInst Then Exit;
  If Not XmsInstalled Then Exit;
  If NumLines = 0 Then Exit;

  CurLine := 0;
  LinesSaved := 0;
  ScrBackLines := NumLines + 50;

  If QueryFreeExtMem (Scrap, Max) <> 0 Then Exit;

  L := ScrBackLines;
  L := Succ (L * 160 Div 1024);

  If L > Max Then Begin
    L := Max;
    ScrBackLines := (Pred (L) * 1024) Div 160;
    If ScrBackLines < 26 Then Exit;
    L := ScrBackLines;
    L := Succ (ScrBackLines * 160 Div 1024);
  End;

  If AllocateExtMem (L, XmsHandle) <> 0 Then Exit;

  ScrBackInst := True;
  ScrBackRunnin := False;
End;

Destructor tScrBack. Done;
Begin
  If Not ScrBackInst Then Exit;
  If ScrBackRunnin Then Exit;
  FreeExtMem (XmsHandle);
  ScrBackInst := False;
End;

Procedure tScrBack. AddLine (B: Byte; Boo: Boolean);
Var
  Real, Ext : ExtMemPtr;
Begin
  If Not ScrBackInst Then Exit;

  Real. RealPtr := Ptr (Seg (Screen^. ScreenPtr^), Ofs (Screen^. ScreenPtr^) + Pred (B) * 160);
  Ext. ProtectedPtr := CurLine * 160;
  MoveExtMemBlock (160, 0, Real, XmsHandle, Ext);

  If CurLine < Pred (ScrBackLines) Then
    Inc (CurLine)
  Else
    CurLine := 0;

  If Boo And (LinesSaved < ScrBackLines - 50) Then Inc (LinesSaved);
End;

Procedure tScrBack. Run;
Var
  SaveCurLine,
  SaveLineNumber: Word;
  Top, Bottom: LongInt;
  daScreen: Pointer;

  Procedure ScrollItUp;
  Var
    Real, Ext : ExtMemPtr;
  Begin
    If LinesSaved <= 0 Then
      Exit
    Else
      Dec (LinesSaved);

    If CurLine <= 0 Then
      CurLine := Pred (ScrBackLines)
    Else
      Dec (CurLine);

    If CurLine < Bottom Then
      Ext. ProtectedPtr := (ScrBackLines + CurLine - Bottom) * 160
    Else
      Ext. ProtectedPtr := (CurLine - Bottom) * 160;

    Move (Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^)], Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^)
          + 160], Pred (Bottom) * 160);
    Real. RealPtr := Ptr (Seg (Screen^. ScreenPtr^), Ofs (Screen^. ScreenPtr^));
    MoveExtMemBlock (160, XmsHandle, Ext, 0, Real);
  End;

  Procedure ScrollItDown;
  Var
    Real, Ext: ExtMemPtr;
  Begin
    If LinesSaved >= SaveLineNumber Then
      Exit
    Else
      Inc (LinesSaved);

    Move (Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + 160], Mem [Seg (Screen^. ScreenPtr^):
          Ofs (Screen^. ScreenPtr^)], Pred (Bottom) * 160);
    Real. RealPtr := Ptr (Seg (Screen^. ScreenPtr^), Ofs (Screen^. ScreenPtr^) + Pred (Bottom) * 160);
    Ext. ProtectedPtr := CurLine * 160;
    MoveExtMemBlock (160, XmsHandle, Ext, 0, Real);

    If CurLine >= Pred (ScrBackLines) Then
      CurLine := 0
    Else
      Inc (CurLine);
  End;

  Procedure PageUp;
  Var
    B: Byte;
  Begin
    If LinesSaved <> 0 Then
      For B := 1 to Pred (Bottom) do
        ScrollItUp;
  End;

  Procedure PageDn;
  Var
    B: Byte;
  Begin
    If LinesSaved <> SaveLineNumber Then
      For B := 1 to Pred (Bottom) do
        ScrollItDown;
  End;

  Procedure Home;
  Var
    B: Byte;
    Real, Ext: ExtMemPtr;
  Begin
    If LinesSaved = 0 Then Exit;

    CurLine := Top;

    For B := 0 to Pred (Bottom) do Begin
      Real. RealPtr := Ptr (Seg (Screen^. ScreenPtr^), Ofs (Screen^. ScreenPtr^) + B * 160);
      Ext. ProtectedPtr := CurLine * 160;
      MoveExtMemBlock (160, XmsHandle, Ext, 0, Real);
      If CurLine >= Pred (ScrBackLines) Then
        CurLine := 0
      Else
        Inc (CurLine);
    End;
    LinesSaved := 0;
  End;

  Procedure End_;
  Var
    B: Byte;
    Real, Ext: ExtMemPtr;
  Begin
    If LinesSaved = SaveLineNumber Then Exit;

    CurLine := SaveCurLine;

    For B := 0 to Pred (Bottom) do Begin
      Real. RealPtr := Ptr (Seg (Screen^. ScreenPtr^), Ofs (Screen^. ScreenPtr^) + B * 160);
      Ext. ProtectedPtr := CurLine * 160;
      MoveExtMemBlock (160, XmsHandle, Ext, 0, Real);
      If CurLine >= Pred (ScrBackLines) Then
        CurLine := 0
      Else
        Inc (CurLine);
    End;
    LinesSaved := SaveLineNumber;
  End;

Var
  qwert, q: Byte;
  sbl: string [6];
  O: Word;
  oldinput: boolean;
Begin
  If Not ScrBackInst Then Exit;
  If ScrBackRunnin Then Exit;
  ScrBackRunnin := True;

  SaveCurLine := CurLine;
  oldinput := inputtimer;
  inputtimer := false;

  New (Savescreen, Init);
  Savescreen^. Save;
  Screen^. CursOff;

  case current of
    terminal: If ExDispMode then
                Bottom := 25
              else
                Bottom := 24;
    board: if StatBar = 0 then
             Bottom := currentmode
           else
             Bottom := pred (currentmode);
    other: Bottom := currentmode;
  end;

  For Q := 1 To Bottom Do
    AddLine (Q, False);

  If Current = Terminal Then
    If Bottom = 24 Then Begin
      screen^. PartClear (29, 25, 60, 25, $17, ' ');
      screen^. WritePlain (30, 25, 'Scroll Back');
    End Else Begin
      screen^. PartClear (29, 28, 60, 28, $17, ' ');
      screen^. WritePlain (30, 28, 'Scroll Back');
    End;

  SaveLineNumber := LinesSaved;
  sbl := IntToStr (ScrBackLines - 50);
  qwert := length (sbl);

  If SaveLineNumber <> SaveCurLine Then
    If SaveLineNumber > SaveCurLine Then
      Top := ScrBackLines + SaveCurLine - SaveLineNumber
    Else
      Top := SaveCurLine - SaveLineNumber
  Else
    Top := 0;

  Repeat
    If Current = Terminal Then Begin
      If Bottom = 24 Then
        screen^. WritePlain (43, 25, '[' + PadRight (IntToStr (LinesSaved), Qwert, ' ') + '/' + sbl + ']')
      Else
        screen^. WritePlain (43, 28, '[' + PadRight (IntToStr (LinesSaved), Qwert, ' ') + '/' + sbl + ']');
    End;

    Repeat
      Key^. vIdleHook;
    Until hung or Key^. KeyPressed;
    If Hung Then Break;

    Case Key^. GetKey Of
      kEsc : Break;
      kUp  : ScrollItUp;
      kDown: ScrollItDown;
      kPgUp: PageUp;
      kPgDn: PageDn;
      kHome: Home;
      kEnd : End_;
    End;
  Until False;

  Savescreen^. Display;
  Dispose (Savescreen, Done);

  LinesSaved := SaveLineNumber;
  CurLine := SaveCurLine;
  ScrBackRunnin := False;
  inputtimer := oldinput;
End;


Procedure tScrBack. Clear;
Begin
  If Not ScrBackInst Then Exit;
  If ScrBackRunnin Then Exit;
  CurLine := 0;
  LinesSaved := 0;
End;

End.