Unit RemEmu;
{$I Sys75.INC}
{$O-,F-}
{$D-,I-,L-,Q-,R-,S-}

Interface

Uses
  DOS, Spuds;

Procedure DetectRemTerm;

Procedure Send (S: String);
Procedure ColWriteCh (C: Char);
Procedure ColWrite (S: String);
Procedure ColWriteln (S: String);
Procedure ComWriteCh (C: Char);
Procedure ComWrite (St: String);
Procedure ComWriteLn (St: String);
Procedure ComWriteAt (X, Y: Byte; St: String);
Procedure ShowFile (N: PathStr; Pausing, Pipes: Boolean);
Procedure pFile (N: PathStr);
Procedure mFile (N: PathStr);
Procedure ShowFileProc (N: PathStr; Proc: ParseProc);
Procedure SendColor (A: Byte);
Function  Cs (Num: Word): String;
procedure saveansi (ansionly: boolean; Q: PathStr);
Procedure ModemStrFix (S: String);
Function  PipeSafe (S: String): String;
Function  FixMacro (S: String): String;
Procedure Box (x1, y1, x2, y2, a: byte);
procedure getaxy (var vaxy: axy);
function  putaxy (vaxy: axy): boolean;
procedure getxy (var vxy: xy);
function  putxy (vxy: xy): boolean;
procedure usercol (b: byte);
procedure systcol (b: byte);
function  padd (s: string): string;
procedure refresh;

Var
  MacroStr,
  FillIn1,
  FillIn2,
  FillIn3,
  FillIn4,
  FillIn5: String [80];
  TrapFile: Text;

Const
  padr: byte = 0;
  padl: byte = 0;
  padc: byte = 0;
  allowpads: Boolean = True;
  Unabortable: Boolean = False;
  ReallyUnabortable: Boolean = False;
  InputBroke: Boolean = False;
  OutLock: Boolean = False;
  TextTrap: Boolean = False;
  ReliablePageLen: Boolean = False;
  DetectedEmu: Set of tTermType = [TermTTY];
  highestemu: tTermType = TermTTY;
  curpagelen: byte = 25;
  hexdigits = ['0'..'9', 'A'..'F'];

Implementation

Uses
  Crt,
  TotDate, TotStr, TotFast, TotInput, TotKey, TotMisc,
  OoCom, OoModem,
  Emu, EmuCodes, Comm, Chats, Scripts, Users, Menus, Misc, HostMode,
  InfoForm, joinconf, filemenu, messages, fonts, statusbar;

{$I MCi.Pas}

Procedure Send (S: String);
Begin
  If Online and not localonly And Not OutLock Then Uart^. PutStringTimeOut (S, 540);
  ParseStr (s);
  If TextTrap Then System. Write (TrapFile, S);
  If DumpInfo Then System. Write (InfoDump, S);
End;

Procedure ColWriteCh (C: Char);
Const
  ColorSave: Array [1..2] of Char = #0#0;
  ColorIndex: Byte = 1;
  PipeIndx: Byte = 1;
Var
  A: Str2;
  B: Byte;
Begin
  Case ColorIndex of
    1:
       If (C = '|') Then
         ColorIndex := 2
       Else if (C = '@') Then
         ColorIndex := 5
       Else
         Send (C);
    2:
       Begin
         ColorSave [1] := C;
         PipeIndx := 0;
         If (uCase (C) = 'P') and allowpads then
           ColorIndex := 4
         Else
           ColorIndex := 3;
       End;
    3:
       Begin
         ColorSave [2] := C;
         ColorIndex := 1;
         A := uCase (ColorSave [1]) + uCase (ColorSave [2]);

         If (A [1] In Digitset) And (A [2] In Digitset) Then Begin
           B := StrToInt (A);
           If B <= 15 Then SendColor (B);
         End Else If (A [1] = 'B') And (A [2] In Digitset) Then
           SendColor (fAttr (TextAttr) + (Ord (A [2]) - 48) * 16)
         Else If A = 'UR' Then SendColor (User. Cols [1])
         Else If A = 'US' Then SendColor (User. Cols [2])
         Else If A = 'UP' Then SendColor (User. Cols [3])
         Else If A = 'UI' Then SendColor (User. Cols [4])
         Else If A = 'UV' Then SendColor (User. Cols [5])
         Else If A = 'UB' Then SendColor (User. Cols [6])
         Else If A = 'UX' Then SendColor (User. Cols [7])
         Else If A = 'SR' Then SendColor (Uc. Colors [1])
         Else If A = 'SS' Then SendColor (Uc. Colors [2])
         Else If A = 'SP' Then SendColor (Uc. Colors [3])
         Else If A = 'SI' Then SendColor (Uc. Colors [4])
         Else If A = 'SV' Then SendColor (Uc. Colors [5])
         Else If A = 'SB' Then SendColor (Uc. Colors [6])
         Else If A = 'SX' Then SendColor (Uc. Colors [7])
         Else If (A = 'B+') And (TextAttr < 128) Then SendColor (TextAttr + 128)
         Else If (A = 'B-') And (TextAttr >= 128) Then SendColor (TextAttr - 128)
         Else begin
           Send ('|');
           colwrite (ColorSave [1] + ColorSave [2]);
         end;
       End;
    4:
       Begin
         if (c in digitset) and (pipeindx < 2) then begin
           Inc (PipeIndx);
           ColorSave [PipeIndx] := C;
         end else if ucase (c) = 'L' then begin
            if pipeindx = 1 then
              padl := ord (colorsave [1]) - 48
            else if pipeindx = 2 then
              padl := (ord (colorsave [1]) - 48) * 10 + (ord (colorsave [2]) - 48)
            else
              padl := 0;
            ColorIndex := 1;
         end else if ucase (c) = 'R' then begin
            if pipeindx = 1 then
              padr := ord (colorsave [1]) - 48
            else if pipeindx = 2 then
              padr := (ord (colorsave [1]) - 48) * 10 + (ord (colorsave [2]) - 48)
            else
              padr := 0;
            ColorIndex := 1;
         end else if ucase (c) = 'C' then begin
            if pipeindx = 1 then
              padc := ord (colorsave [1]) - 48
            else if pipeindx = 2 then
              padc := (ord (colorsave [1]) - 48) * 10 + (ord (colorsave [2]) - 48)
            else
              padc := 0;
            ColorIndex := 1;
         end else begin
           send ('|');
           ColorIndex := 1;
           if pipeindx >= 1 then colwritech (colorsave [1]);
           if pipeindx = 2 then colwritech (colorsave [2]);
           colwritech (c);
         end;
       End;
    5:
       Begin
         If C <> 'X' Then Begin
           ColorIndex := 1;
           Send ('@');
           colwritech (c);
         End Else
           ColorIndex := 6;
       End;
    6:
       Begin
         if c in hexdigits then begin
           ColorSave [1] := C;
           inc (colorindex);
         end else begin
           colorindex := 1;
           send ('@X');
           colwritech (c);
         end;
       End;
    7:
       Begin
         if not (c in hexdigits) then begin
           send ('@X');
           colorindex := 1;
           colwrite (colorsave [1] + c);
         end else begin
           inc (colorindex);
           ColorSave [2] := c;
         end;
       end;
    8:
       Begin
         colorindex := 1;
         if c <> '@' then send (c);
         A := ColorSave [1] + ColorSave [2];
         B := HexStrTolong (A);
         SendColor (B);
       end;
  End;
End;

Procedure ColWrite (S: String);
Var
  B: Byte;
Begin
  For B := 1 To Length (S) Do
    ColWriteCh (S [B]);
End;

Procedure ColWriteln (S: String);
Begin
  ColWrite (S + ^M^J);
End;

Procedure ComWriteCh (C: Char);
Begin
  ColWrite (MciPump (C));
End;

Procedure ComWrite (St: String);
Var
  B: Byte;
Begin
  For B := 1 To Length (St) Do
    ComWriteCh (St [B]);
End;

Procedure ComWriteLn (St: String);
Begin
  ComWrite (St + ^M^J);
End;

Procedure ComWriteAt (X, Y: Byte; St: String);
Var
  S: String;
  B: Byte;
Begin
  Send (GoXy (X, Y));
  If TextTrap Then Write (TrapFile, aGoXy (X, Y));
  ComWrite (St);
End;

Procedure ShowFile (N: PathStr; Pausing, Pipes: Boolean);
Const
  BufSize = 8192;
Var
  c: char;
  p, i, Z: Word;
  F  : File;
  Buf: Array [1..BufSize] Of Char;
Begin
  If (Pos ('*', N) <> 0) Or (Pos ('?', N) <> 0) then
    Assign (F, RandomFile (N))
  Else
    Assign (F, N);
  {$I-}
  Reset (F, 1);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IOResult <> 0 Then Exit;
  Unabortable := ReallyUnabortable;
  InputBroke := False;

  TTYPause := Pausing and (pause in user. options);
  nonstop := false;

  Repeat
    BlockRead (F, Buf, BufSize, Z);
    For i := 1 To Z Do Begin
      if inputbroke then break;
      If Buf [i] = ^Z Then Break;
      If hung Then Exit;
      If Pipes Then
        ComWriteCh (Buf [i])
      Else
        Send (Buf [i]);
      If i Mod 64 = 0 Then Begin
        Key^. vIdleHook;
        If hung Then Exit;

        If Not InputBroke And Not Unabortable Then Begin
          if not localonly and uart^. charready then begin
            uart^. peekchar (c, 1);
            p := ord (c);
            if p = kSpc then uart^. getchar (c);
          end else if key^. keypressed then begin
            p := key^. getkey;
            if p <> kSpc then key^. stuffbuffer (p);
          end else p := 256;
          If hung Then Exit;
          If p = kSpc Then InputBroke := True;
        End;

        if inputbroke and ttypause then begin
          inputbroke := false;
          nonstop := false;
        end else If InputBroke And Not Unabortable And ParseThatTitty Then Begin
          Close (F);
          TTYPause := False;
          nonstop := false;
          Exit;
        End;
      End;
    End;
    If Buf [i] = ^Z Then Break;
  Until Z <> BufSize;
  Close (F);
  ReallyUnabortable := False;
  TTYPause := False;
  nonstop := false;
End;

Procedure pFile (N: PathStr);
Const
  BufSize = 8192;
Var
  c: char;
  p, i, Z: Word;
  F  : File;
  Buf: Array [1..BufSize] Of Char;
Begin
  If (CurStatSet. Path <> '') And Exist (CurStatSet. Path + N) Then
    If (Pos ('*', N) <> 0) Or (Pos ('?', N) <> 0) then
      Assign (F, RandomFile (CurStatSet. Path + N))
    Else
      Assign (F, CurStatSet. Path + N)
  Else If (Pos (':', N) <> 0) Or (Pos ('\', N) <> 0) Then
    If (Pos ('*', N) <> 0) Or (Pos ('?', N) <> 0) then
      Assign (F, RandomFile (N))
    Else
      Assign (F, N)
  Else
    If (Pos ('*', N) <> 0) Or (Pos ('?', N) <> 0) then
      Assign (F, RandomFile (Uc. DispPath + N))
    Else
      Assign (F, Uc. DispPath + N);
  {$I-}
  Reset (F, 1);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IOResult <> 0 Then Exit;
  Unabortable := ReallyUnabortable;
  InputBroke := False;

  Repeat
    BlockRead (F, Buf, BufSize, Z);
    For i := 1 To Z Do Begin
      If Buf [i] = ^Z Then Break;
      If hung Then Exit;
      ComWriteCh (Buf [i]);
      If i Mod 64 = 0 Then Begin
        Key^. vIdleHook;
        If hung Then Exit;

         If Not InputBroke And Not Unabortable Then Begin
          if not localonly and uart^. charready then begin
            uart^. peekchar (c, 1);
            p := ord (c);
            if p = kSpc then uart^. getchar (c);
          end else if key^. keypressed then begin
            p := key^. getkey;
            if p <> kSpc then key^. stuffbuffer (p);
          end else p := 256;
          If hung Then Exit;
          If p = kSpc Then InputBroke := True;
        End;

        If InputBroke And Not Unabortable And ParseThatTitty Then Begin
          Close (F);
          TTYPause := False;
          Exit;
        End;
      End;
    End;
    If Buf [i] = ^Z Then Break;
  Until Z <> BufSize;
  Close (F);
  ReallyUnabortable := False;
End;

Procedure mFile (N: PathStr);
Const
  BufSize = 8192;
Var
  c: char;
  p, i, Z: Word;
  F  : File;
  Buf: Array [1..BufSize] Of Char;
Begin
  If (CurMenuSet. Path <> '') And Exist (CurMenuSet. Path + N) Then
    Assign (F, CurMenuSet. Path + N)
  Else
    Assign (F, Uc. DispPath + N);
  {$I-}
  Reset (F, 1);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IOResult <> 0 Then Exit;
  Unabortable := ReallyUnabortable;
  InputBroke := False;

  Repeat
    BlockRead (F, Buf, BufSize, Z);
    For i := 1 To Z Do Begin
      If Buf [i] = ^Z Then Break;
      If hung Then Exit;
      ComWriteCh (Buf [i]);
      If i Mod 64 = 0 Then Begin
        Key^. vIdleHook;
        If hung Then Exit;

        If Not InputBroke And Not Unabortable Then Begin
          if not localonly and uart^. charready then begin
            uart^. peekchar (c, 1);
            p := ord (c);
            if p = kSpc then uart^. getchar (c);
          end else if key^. keypressed then begin
            p := key^. getkey;
            if p <> kSpc then key^. stuffbuffer (p);
          end else p := 256;
          If hung Then Exit;
          If p = kSpc Then InputBroke := True;
        End;

        If InputBroke And Not Unabortable And ParseThatTitty Then Begin
          Close (F);
          TTYPause := False;
          Exit;
        End;
      End;
    End;
    If Buf [i] = ^Z Then Break;
  Until Z <> BufSize;
  Close (F);
  ReallyUnabortable := False;
End;

Procedure ShowFileProc (N: PathStr; Proc: ParseProc);
Const
  BufSize = 8192;
Var
  c: char;
  p, i, Z: Word;
  F: File;
  Buf: Array [1..BufSize] Of Char;
Begin
  If (Pos ('*', N) <> 0) Or (Pos ('?', N) <> 0) then
    Assign (F, RandomFile (N))
  Else
    Assign (F, N);
  {$I-}
  Reset (F, 1);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IOResult <> 0 Then Exit;
  Unabortable := ReallyUnabortable;
  InputBroke := False;

  Repeat
    BlockRead (F, Buf, BufSize, Z);
    For i := 1 To Z Do Begin
      If hung Then Exit;
      Proc (Buf [i]);
      If i Mod 64 = 0 Then Begin
        Key^. vIdleHook;
        If hung Then Exit;

        If Not InputBroke And Not Unabortable Then Begin
          if not localonly and uart^. charready then begin
            uart^. peekchar (c, 1);
            p := ord (c);
            if p = kSpc then uart^. getchar (c);
          end else if key^. keypressed then begin
            p := key^. getkey;
            if p <> kSpc then key^. stuffbuffer (p);
          end else p := 256;
          If hung Then Exit;
          If p = kSpc Then InputBroke := True;
        End;

        If InputBroke And Not Unabortable And ParseThatTitty Then Begin
          Close (F);
          TTYPause := False;
          Exit;
        End;
      End;
    End;
  Until Z <> BufSize;
  Close (F);
  ReallyUnabortable := False;
End;

Procedure DetectRemTerm;
Var
  curmode, W: Byte;
  AvtTemp, Temp: String;
  drt: tTermType;
Begin
  ComWriteLn (^M^J + Cs (1)); { Detecting emulation }
  if localonly then begin
    DetectedEmu := [TermTTY, TermAns, TermAvt, TermRip, TermAte];
    HighestEmu := TermAvt;
    exit;
  end;
  Uart^. DrainOutBuffer (540);
  if hung then exit;

  Temp := '';
  DetectedEmu := [TermTTY];
  HighestEmu := TermTTY;

  delay (100);
  if hung then exit;
  Uart^. FlushInBuffer;
  Uart^. PutString (^M^['[6n'^M'    '^M);
  Uart^. GetStringTimeout (Temp, 255, ['R'], 18);
  If Pos (^['[', Temp) <> 0 Then Begin
    DetectedEmu := DetectedEmu + [TermAns];
    HighestEmu := TermAns;
    ComWriteln (Cs (2)); {ANSi detected}
  End;

  if hung then exit;
  Temp := '';
  delay (100);
  if hung then exit;
  Uart^. FlushInBuffer;
  Uart^. PutString (^M^V^Q^Q^M'   '^M);
  Uart^. GetStringTimeout (Temp, 255, ['0', '1'], 18);
  If Pos ('AVT', Temp) <> 0 Then Begin
    DetectedEmu := DetectedEmu + [TermAvt];
    HighestEmu := TermAvt;
    ComWriteln (Cs (3)); {Avatar detected}
  End;

  if hung then exit;
  If B (Uc. Options, IsRipOn) Then Begin
    Temp := '';
    delay (100);
    Uart^. FlushInBuffer;
    Uart^. PutString (^M^['[!'^M'   '^M);
    Uart^. GetStringTimeout (Temp, 255, ['P'], 18);
    if hung then exit;

    If Pos ('RIP', Temp) <> 0 Then Begin
      DetectedEmu := DetectedEmu + [TermRip];
      ComWriteln (Cs (4)); {Rip detected}
    End;
  End;

  Temp := '';
  if hung then exit;
  delay (100);
  Uart^. FlushInBuffer;
  Uart^. PutString (^M^['[z'^M'   '^M);
  Uart^. GetStringTimeout (Temp, 255, ['Z'], 10);
  if hung then exit;

  If (Pos (^['[', Temp) <> 0) and (Pos ('Z', Temp) <> 0) Then Begin
    delete (temp, 1, succ (Pos (^['[', Temp)));
    delete (temp, Pos ('Z', Temp), 255);
    curpagelen := strtoint (temp);
    if hung then exit;

    if curpagelen <= 25 then
      curmode := 25
    else if curpagelen <= 28 then
      curmode := 28
    else if curpagelen <= 30 then
      curmode := 30
    else if curpagelen <= 43 then
      curmode := 43
    else
      curmode := 50;

    curpagelen := pred (curmode);
    reliablepagelen := true;

    if curmode <> currentmode then begin
      if statbar <> 0 then screen^. partclear (1, currentmode, 80, currentmode, 0, ' ');
      setmode (curmode, true);

      if statbar <> 0 then begin
        newstatbar := true;
        showstatus;
      end;
    end;

    DetectedEmu := DetectedEmu + [TermAte];
    fillin1 := ateverstr;
    ComWriteln (Cs (74)); {ATE detected}
  End else begin
    curmode := 25;
    reliablepagelen := false;
  end;

  if hung then exit;
  If HighestEmu = TermTTY Then Begin
    ComWrite (Cs (87));
    If LiteBar (lbYes, False, true) = lbYes Then Begin
      DetectedEmu := DetectedEmu + [TermANS];
      HighestEmu := TermAns;
    End;
    If Hung Then Exit;

    ComWrite (Cs (40));
    If LiteBar (lbNo, False, true) = lbYes Then Begin
      DetectedEmu := DetectedEmu + [TermAVT];
      HighestEmu := TermAvt;
    End;
    If Hung Then Exit;

    If B (Uc. Options, IsRipOn) Then Begin
      ComWrite (Cs (10));
      If LiteBar (lbNo, False, true) = lbYes Then DetectedEmu := DetectedEmu + [TermRIP];
      If Hung Then Exit;
    End;
  End;

  iDelay (500);
  if hung then exit;
  Uart^. FlushInBuffer;
  Uart^. FlushOutBuffer;
End;

Procedure SendColor (A: Byte);
Begin
  If OnLine and not localonly Then Uart^. PutStringTimeOut (Attr (A), 36);
  SetColor (A);
  If TextTrap Then Write (TrapFile, AnsA (A, textattr));
  If DumpInfo Then Write (InfoDump, AnsA (A, textattr));
End;

Function Cs (Num: Word): String;

  function dostr (s: string): string;
  var
    b: byte;
  begin
    If (S [0] > #2) And (S [1] = '%') And (S [2] = '%') Then Begin
      pFile (Copy (S, 3, 255));
      S := '';
    End Else If (S [0] > #2) And (S [1] = '!') And (S [2] = '!') Then Begin
      RunScript (Uc. ScrpPath + Copy (S, 3, 255));
      S := '';
    End Else If (S [0] > #2) And (S [1] = '#') And (S [2] = '#') Then Begin
      delete (s, 1, 2);
      send (goxy (strtoint (copy (s, 1, pred (pos (',', S)))), strtoint (copy (s, succ (pos (',', S)), pred (pos ('#', S)) -
            pos (',', S)))));
      delete (s, 1, pos ('#', s));
      s := dostr (s);
    End Else If (S [0] > #2) And (S [1] = '^') And (S [2] = 'X') Then Begin
      S := Copy (S, 3, 255);
      FillIn1 := '';
      For B := 1 to Length (S) do
        FillIn1 := FillIn1 + MciPump (S [B]);
      pFile ('hdr.ans');
      S := '';
    End;

    dostr := s;
  end;

var
  S: String;

Begin
  Cs := '';

  if ioresult <> 0 then ;
  {$I-}
  Seek (StrFile, Pred (Num));
  Read (StrFile, S);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IoResult <> 0 Then Begin
    Cs := '';
    Exit;
  End;

  s := dostr (s);
  Cs := S;
End;

procedure saveansi (ansionly: boolean; Q: PathStr);
type
  TCell = Record
            C : Char;
            A : Byte;
          End;
  TScreen = Array [1..50, 1..80] Of TCell;

Var
  Screenz  : ^TSCreen;
  F        : Text;
  a, X, Y  : Byte;
  s, s1    : String;
  x2, blank: byte;
begin
  screenz := ptr (seg (screen^. screenptr^), Ofs (Screen^. ScreenPtr^));
  assign (f, q);
  rewrite (f);
  write (f, ^['[0m'^['[2J');
  a := screenz^ [1, 1]. a + 1;
  for y := sy1 to sy2 do begin
    blank := 0;
    if y = sy2 then
      x2 := pred (sx2)
    else
      x2 := sx2;
    for x := sx1 to x2 do begin
      if a <> screenz^ [y, x]. a then begin
        if (screenz^ [y, x]. a > $10) And (Blank > 0) Then Begin
          s := ^['[' + inttostr (blank) + 'C';
          if length (s) < blank then
            write (f, s)
          else
            if ansionly then
              write (f, replicate (blank, ' '))
            else
              write (f, rep (' ', blank));
          Blank := 0;
        End;
        if ansionly then
          write (f, ansa (screenz^ [y, x]. a, a))
        else
          write (f, attr (screenz^ [y, x]. a));
        a := screenz^ [y, x]. a;
      end;

      if (screenz^ [y, x]. c in [#0, #32, #255]) and (a < $10) then begin
        inc (blank);
      end else begin
        if blank <> 0 then begin
          s := ^['[' + inttostr (blank) + 'C';
          if length (s) < blank then
            write (f, s)
          else
            if ansionly then
              write (f, Replicate (Blank, ' '))
            else
              write (f, rep (' ', blank));
        end;
        write (f, screenz^ [y, x]. c);
        blank := 0;
      end;
    end;
    if (blank <> 0) and (y <> sy2) then write (f, ^M^J);
  end;
  close (f);
End;

Procedure ModemStrFix (S: String);
Var
  B: Byte;
Begin
  if localonly then exit;
  B := 1;
  While B <= Length (S) do Begin
    Case S [B] of
      '|': Uart^. PutChar (^M);
      '~': iDelay (500);
      '^': If B <> Length (S) Then Begin
             Inc (B);
             Uart^. PutChar (Chr (Ord (uCase (S [B])) - 64));
           End Else Uart^. PutChar (S [B]);
      Else Uart^. PutChar (S [B]);
    End;
    Inc (B);
  End;
End;

Function PipeSafe (S: String): String;
Var
  b: Byte;
  s2: String;
Begin
  s2 := '';
  For b:= 1 to length (s) do begin
    s2 := s2 + s [b];
    if (s [b] = '|') or (s [b] = '%') then
      s2 := s2 + s [b];
  End;
  PipeSafe := s2;
End;

Function FixMacro (S: String): String;
Var
  B: Byte;
Begin
  If (S [0] > #2) And (S [1] = '%') And (S [2] = '%') Then Begin
    pFile (Copy (S, 3, 255));
    S := '';
  End Else If (S [0] > #2) And (S [1] = '!') And (S [2] = '!') Then Begin
    RunScript (Uc. ScrpPath + Copy (S, 3, 255));
    S := '';
  End Else If (S [0] > #2) And (S [1] = '^') And (uCase (S [2]) = 'X') Then Begin
    S := Copy (S, 3, 255);
    FillIn1 := '';
    For B := 1 to Length (S) do
      FillIn1 := FillIn1 + MciPump (S [B]);
    pFile ('hdr.ans');
    S := '';
  End Else
    For B := 1 to Length (S) do
      If (S [B] = '^') And (B <> Length (S)) And (uCase (S [Succ (B)]) = 'M') Then Begin
        S [B] := ^M;
        Delete (S, Succ (B), 1);
      End;

  FixMacro := S;
End;

Procedure Box (x1, y1, x2, y2, a: byte);
Const
  Hor = '';
  Ver = '';
  Ur  = '';
  Lr  = '';
  Ul  = '';
  Ll  = '';
Var
  B: Byte;
Begin
  Send (attr (A));
  ComWriteAt (x1, y1, Ul + Rep (Hor, Succ (x2 - x1) - 2) + Ur);
  For B := Succ (y1) to Pred (y2) do Begin
    ComWriteAt (x1, B, Ver);
    ComWriteAt (x2, B, Ver);
  End;
  ComWriteAt (x1, y2, Ll + Rep (Hor, Succ (x2 - x1) - 2) + Lr);
End;

procedure getaxy (var vaxy: axy);
begin
  with vaxy do begin
    x := _x;
    y := _y;
    a := textattr;
  end;
end;

function putaxy (vaxy: axy): boolean;
begin
  if vaxy. x <> 0 then begin
    with vaxy do
      send (goxy (x, y) + attr (a));
    putaxy := true;
  end else putaxy := false;
end;

procedure getxy (var vxy: xy);
begin
  with vxy do
    screen^. wherexy (x, y);
end;

function putxy (vxy: xy): boolean;
begin
  if vxy. x <> 0 then begin
    with vxy do
      send (goxy (x, y));
    putxy := true;
  end else putxy := false;
end;

procedure usercol (b: byte);
begin
  if textattr <> user. cols [b] then
    send (attr (user. cols [b]));
end;

procedure systcol (b: byte);
begin
  if textattr <> uc. colors [b] then
    send (attr (uc. colors [b]));
end;

function padd (s: string): string;
begin
  if padl <> 0 then padd := padleft (s, padl, ' ')
  else if padr <> 0 then padd := padright (s, padr, ' ')
  else if padc <> 0 then padd := padcenter (s, padc, ' ')
  else padd := s;
  padr := 0;  padl := 0;  padc := 0;
end;

procedure refresh;
type
  TCell = Record
            C : Char;
            A : Byte;
          End;
  TScreen = Array [1..50, 1..80] of TCell;
Var
  Screenz  : ^TSCreen;
  a, X, Y  : Byte;
  s, s1    : String;
  x2, blank: byte;
  save: axy;
begin
  if localonly or not online then exit;
  getaxy (save);
  screenz := ptr (seg (screen^. screenptr^), Ofs (Screen^. ScreenPtr^));
  uart^. putstring (^['[0m'^['[2J');
  a := screenz^ [1, 1]. a + 1;
  for y := sy1 to sy2 do begin
    blank := 0;
    if y = sy2 then
      x2 := pred (sx2)
    else
      x2 := sx2;
    for x := sx1 to x2 do begin
      if a <> screenz^ [y, x]. a then begin
        if (screenz^ [y, x]. a > $10) And (Blank > 0) Then Begin
          s := ^['[' + inttostr (blank) + 'C';
          if length (s) < blank then
            uart^. putstring (s)
          else
            uart^. putstring (rep (' ', blank));
          Blank := 0;
        End;
        uart^. putstring (attr (screenz^ [y, x]. a));
        a := screenz^ [y, x]. a;
      end;

      if (screenz^ [y, x]. c in [#0, #32, #255]) and (a < $10) then begin
        inc (blank);
      end else begin
        if blank <> 0 then begin
          s := ^['[' + inttostr (blank) + 'C';
          if length (s) < blank then
            uart^. putstring (s)
          else
            uart^. putstring (rep (' ', blank));
        end;
        uart^. putchar (screenz^ [y, x]. c);
        blank := 0;
      end;
    end;
    if (blank <> 0) and (y <> sy2) then uart^. putstring (^M^J);
  end;
  putaxy (save);
end;

End.