Unit Regs;
{$I Sys75.Inc}
{$D-,I-,L-,Q-,R-,S-}

Interface

Uses
  ApMisc, Spuds;

Type
  tRegRec          = Record
                       Header: array [1..42] of char;
                       Reg3b : Word;
                       Reg1a : Word;
                       Scrap1: Word;
                       Name  : HandleStr;
                       Reg2b : Byte;
                       Scrap2: Word;
                       Reg2a : Byte;
                       BBS   : HandleStr;
                       Reg3a : Word;
                       Scrap3: Word;
                       Reg4b : Byte;
                       Phone : String [12];
                       Reg4a : Byte;
                       Reg1b : Word;
                       Scrap4: Word;
                     End;

  RegRecError = (Unreged, Reged, Hacked, InvalidRegFile);

Const
  Registered: Boolean = False;

  RegRec : tRegRec = (
    Header: 'Unregistered System/75 BBS';
    Reg3b : 0;
    Reg1a : 0;
    Scrap1: 0;
    Name  : '';
    Reg2b : 0;
    Scrap2: 0;
    Reg2a : 0;
    BBS   : '';
    Reg3a : 0;
    Scrap3: 0;
    Reg4b : 0;
    Phone : '';
    Reg4a : 0;
    Reg1b : 0;
    Scrap4: 0);

Procedure MakeRegCode (Var RR: tRegRec);
Function  CheckRegCode: RegRecError;

Implementation

Uses
  TotStr;

Procedure MakeRegCode (Var RR: tRegRec);
Type
  Trick = Record
    Hie, Low: Word;
  End;
Var
  S: String;
  B: Byte;
  W: Word;
  L: LongInt;
Begin
  S := #0#1#235#0#7'Spectre' + RR. Name + 'Coding' + RR. BBS + 'Team' + RR. Phone + '!!!';
  L := $FFFFFFFF;
  For B := 0 To Length (S) Do
    L := UpdateCrc32 (Byte (S [B]), L);
  RR. Reg1a := Trick (L). Hie;
  RR. Reg1b := Trick (L). Low;

  W := $0;
  S := #0#0#254#20#7'Spectre' + RR. BBS + 'Coding' + RR. Phone + 'Team' + RR. Name + '!!!';
  For B := 0 To Length (S) Do
    W := UpdateCrc (Byte (S [B]), W);
  RR. Reg2a := Lo (W);
  RR. Reg2b := Hi (W);

  RR. Reg3a := RR. Reg1a xor $3458;
  RR. Reg3b := RR. Reg1b xor $5349;
  RR. Reg4a := RR. Reg2a xor $23;
  RR. Reg4b := RR. Reg2b xor $65;

  RR. Scrap1 := 0;
  RR. Scrap2 := 0;
  RR. Scrap3 := 0;
  RR. Scrap4 := 0;
End;

Function CheckRegCode: RegRecError;
Var
  T: RegRecError;
  X: tRegRec;
Begin
  X. Name := Uc. SysopName;
  X. Bbs := Uc. BoardName;
  X. Phone := Uc. PhoneNumber;
  MakeRegCode (X);
  T := Reged;
  If (X. Reg1a <> RegRec. Reg1a) Or (X. Reg1b <> RegRec. Reg1b)
  Or (X. Reg2a <> RegRec. Reg2a) Or (X. Reg2b <> RegRec. Reg2b)
  Or (X. Reg3a <> RegRec. Reg3a) Or (X. Reg3b <> RegRec. Reg3b)
  Or (X. Reg4a <> RegRec. Reg4a) Or (X. Reg4b <> RegRec. Reg4b)
  Or (uc. sysopname <> RegRec. name) Or (uc. boardname <> RegRec. bbs)
  Or (uc. phonenumber <> RegRec. phone) Then T := Hacked;
  CheckRegCode := T;
End;

End.
