Unit PdMenus;
{$I Sys75.Inc}

Interface

uses
  spuds,
  totlink;

type
  choiceproc = function (ch: word): Boolean;

  pchoicerec =  ^choicerec;
  choicerec =
  record
    x, y: byte;
    data: str80;
  end;

  pdMenu = ^tpdMenu;
  tpdMenu =
  Object
    constructor init;
    Procedure Clear;
    Procedure AddChoice (px, py: Byte; vdata: str80);
    procedure setcolors (norm, hi: byte);
    procedure setcurchoice (m: word);
    procedure setchoiceproc (c: choiceproc);
    procedure select (num: byte);
    procedure high (num: byte);
    procedure draw;
    procedure inccur;
    procedure deccur;
    procedure run;
    destructor done;
    private
      Choices: Word;
      cnorm,
      chigh: byte;
      pChoice: choiceproc;
      Choice: pDLLobj;
      cur, old: word;
  End;

function Nullchoiceproc (ch: word): boolean; Far;

Implementation

Uses
  TotKey,
  RemEmu, EmuCodes, Comm;

function nullchoiceproc (ch: word): boolean;
begin
  nullchoiceproc := false;
end;

constructor tpdMenu. init;
begin
  Choices := 0;
  SetColors ($08, $1F);
  setchoiceproc (nullchoiceproc);
  new (choice, init);
end;

procedure tpdMenu. setchoiceproc (c: choiceproc);
begin
  pchoice := c;
end;

Procedure tpdMenu. Clear;
begin
  if choice <> nil then choice^. emptylist;
end;

procedure tpdMenu. setcolors (norm, hi: byte);
begin
  cnorm := norm;
  chigh := hi;
end;

procedure tpdMenu. setcurchoice (m: word);
begin
  old := cur;
  cur := m;
end;

Procedure tpdMenu. AddChoice (px, py: Byte; vdata: str80);
var
  e: pchoicerec;
begin
  getmem (e, sizeof (choicerec));
  with e^ do begin
    x := px;
    y := py;
    data := vdata;
  end;

  choice^. add (e^, sizeof (choicerec));
  freemem (e, sizeof (choicerec));
  inc (choices);
end;

procedure tpdMenu. select (num: byte);
begin
  if num <= choices then cur := num;
end;

Procedure tpdMenu. High (Num: Byte);
var
  e: pchoicerec;
begin
  getmem (e, sizeof (choicerec));

  if old <> 0 then begin
    with choice^ do
      getnodedata (nodeptr (old), e^);

    send (attr (cnorm));
    with e^ do
      ComWriteAt (x, y, Data);
  end;

  with choice^ do
    getnodedata (nodeptr (num), e^);

  send (attr (chigh));
  with e^ do
    ComWriteAt (x, y, Data + '|00 '#8);

  Old := Num;
  freemem (e, sizeof (choicerec));
End;

procedure tpdMenu. inccur;
begin
  If Cur < Choices Then
    Inc (Cur)
  Else
    Cur := 1;
end;

procedure tpdMenu. deccur;
begin
  If Cur > 1 Then
    Dec (Cur)
  Else
    Cur := Choices;
end;

procedure tpdMenu. draw;
var
  w: word;
  e: pchoicerec;
begin
  getmem (e, sizeof (choicerec));

  send (attr (cnorm));

  for w := 1 to choices do begin
    with choice^ do
      getnodedata (nodeptr (w), e^);

    with e^ do
      comwriteat (x, y, data);
  end;

  freemem (e, sizeof (choicerec));
end;

procedure tpdMenu. run;
var
  i: word;
begin
  if choices = 0 then exit;
  cur := 1;
  old := 0;

  Draw;
  If hung Then Exit;
  High (Cur);

  Repeat
    I := ReadArrow;
    If hung Then Exit;
    Case I of
      kCtlZ, kEsc, kQ, kSftQ: Break;
      kEnter:
              Begin
                If pChoice (Cur) Then exit;
                Draw;
                High (Cur);
              End;
      kDown, kSpc:
                 Begin
                   IncCur;
                   High (Cur);
                 End;
      kUp:
                 Begin
                   DecCur;
                   High (Cur);
                 End;
    End;
  Until False;
end;

destructor tpdMenu. done;
begin
  dispose (choice, done);
end;

End.