Unit Parsers;
{$I Sys75.Inc}
{$O-,F-}
{$D-,I-,L-,Q-,R-,S-}

Interface

Uses
  Spuds;

Procedure UserConfigProc (C: Char);
Procedure ShowUserEdit (C: Char);

Implementation

Uses
  Emu, RemEmu, EmuCodes, Sysop, Main;

Procedure UserConfigProc (C: Char);
Var
  Test: Boolean;
Begin
  Test := True;
  If ucParsed Then Begin
    Case C of
      'F': GetAxy (ucxys^[ 1]);
      'Y': GetAxy (ucxys^[ 2]);
      'H': GetAxy (ucxys^[ 3]);
      'R': GetAxy (ucxys^[ 4]);
      'D': GetAxy (ucxys^[ 5]);
      '1': GetAxy (ucxys^[ 6]);
      '2': GetAxy (ucxys^[ 7]);
      '3': GetAxy (ucxys^[ 8]);
      '4': GetAxy (ucxys^[ 9]);
      '5': GetAxy (ucxys^[10]);
      '6': GetAxy (ucxys^[11]);
      '7': GetAxy (ucxys^[23]);
      'G': GetAxy (ucxys^[12]);
      'U': GetAxy (ucxys^[13]);
      'P': GetAxy (ucxys^[14]);
      'M': GetAxy (ucxys^[15]);
      'S': GetAxy (ucxys^[16]);
      'A': GetAxy (ucxys^[17]);
      'L': GetAxy (ucxys^[18]);
      'E': GetAxy (ucxys^[19]);
      'C': GetAxy (ucxys^[20]);
      'O': GetAxy (ucxys^[21]);
      'Z': GetAxy (ucxys^[22]);
      Else Begin
        Comwrite ('@' + C);
        Test := False;
      End;
    End;
    If Test Then Begin
      Inc (_x, 2);
      If _x > Sx2 Then Begin
        _x := _x - Sx2;
        If _y <> Sy2 Then Inc (_y) else send (^J);
      End;
      Send (GoXy (_x, _y));
    End;
    ucParsed := False;
  End Else Begin
    If C = '@' Then
      ucParsed := True
    Else
      ComWriteCh (C);
  End;
End;

Procedure ShowUserEdit (C: Char);
Var
  Test: Boolean;
Begin
  Test := True;
  If Not ueParsed Then
    If C = '@' Then
      ueParsed := True
    Else
      ComWriteCh (C)
  Else Begin
    Case C of
      'H': GetAxy (uexys^ [ 1]);
      ';': GetAxy (uexys^ [ 2]);
      '-': GetAxy (uexys^ [ 3]);
      'R': GetAxy (uexys^ [ 4]);
      'N': GetAxy (uexys^ [ 5]);
      'Y': GetAxy (uexys^ [ 6]);
      '(': GetAxy (uexys^ [ 7]);
      'A': GetAxy (uexys^ [ 8]);
      '=': GetAxy (uexys^ [ 9]);
      '^': GetAxy (uexys^ [10]);
      '&': GetAxy (uexys^ [11]);
      'G': GetAxy (uexys^ [12]);
      'X': GetAxy (uexys^ [13]);
      'J': GetAxy (uexys^ [14]);
      'V': GetAxy (uexys^ [15]);
      '@': GetAxy (uexys^ [16]);
      '>': GetAxy (uexys^ [17]);
      'L': GetAxy (uexys^ [18]);
      'F': GetAxy (uexys^ [19]);
      'P': GetAxy (uexys^ [20]);
      'T': GetAxy (uexys^ [21]);
      '$': GetAxy (uexys^ [22]);
      'C': GetAxy (uexys^ [23]);
      'U': GetAxy (uexys^ [24]);
      'D': GetAxy (uexys^ [25]);
      ')': GetAxy (uexys^ [26]);
      '"': GetAxy (uexys^ [27]);
      'E': GetAxy (uexys^ [28]);
      '/': GetAxy (uexys^ [29]);
      '\': GetAxy (uexys^ [30]);
      '#': GetAxy (uexys^ [31]);
      'W': GetAxy (uexys^ [32]);
      'O': GetAxy (uexys^ [33]);
      '.': GetAxy (uexys^ [34]);
      '|': GetAxy (uexys^ [35]);
      'M': GetAxy (uexys^ [36]);
      'K': GetAxy (uexys^ [37]);
      Else Begin
        Comwrite ('@' + C);
        Test := False;
      End;
    End;
    If Test Then Begin
      Inc (_x, 2);
      If _x > Sx2 Then Begin
        _x := _x - Sx2;
        If _y <> Sy2 Then Inc (_y) else send (^J);
      End;
      Send (GoXy (_x, _y));
    End;
    ueParsed := False;
  End;
End;

End.