{$S-,R-,V-,I-,B-,F+,O+,A+,G+}

{Conditional defines that may affect this unit}
{$I APDEFINE.INC}

{Include OPro's define file if UseOPro is specified}
{$IFDEF UseOPro}
{$I OPDEFINE.INC}
{$ENDIF}

{*********************************************************}
{*                  OOKERMIT.PAS 1.12                    *}
{*     Copyright (c) TurboPower Software 1991.           *}
{*                 All rights reserved.                  *}
{*********************************************************}

unit OOKermit;
  {-Provides Kermit receive and transmit functions (using OOP)}

interface

uses
  Dos,
  {$IFDEF UseOPro}
  OpInline,
  OpString,
  OpRoot,
  {$ENDIF}
  {$IFDEF UseTPro}
  TpMemChk,
  TpInline,
  TpString,
  {$ENDIF}
  ApMisc,
  ApPort,
  ApTimer,
  OOCom,
  OOAbsPcl;

const
  {Run-time constants}
  DefMinRepeatCnt : Byte = 4;      {Minimum characters to use repeat prefix}
  FastAbort : Boolean = False;     {Use Error packet for aborting}
  DefHibitPrefix : Char = '&';     {default char for hibit prefixing}   {!!.04}

  {Compile-time constants}
  DiscardChar = 'D';               {For signaling an abort}
  LongPDivisor = 95;               {for calculating long packets size}
  DefLongPSize = 500;              {default size for long packets}      {!!.04}

  {For estimating protocol transfer times}
  KermitOverhead : Word = 20;      {Bytes of overhead for each block}
  KermitTurnDelay : Word = 1000;   {Msecs of turn around delay}
  SWCKermitTurnDelay : Word = 5;   {Msecs of turn around delay on SWC xfers}{!!.04}

  {Packet types}
  KBreak           = 'B';        {Break transmission (EOT)}
  KData            = 'D';        {Data packet}
  KError           = 'E';        {Error packet}
  KFile            = 'F';        {File header packet}
  KKermitCommand   = 'K';        {Kermit command packet}
  KNak             = 'N';        {Negative acknowledge packet}
  KReceiveInit     = 'R';        {Receive initiate}
  KSendInit        = 'S';        {Initial packet (exchange options)}
  KDisplay         = 'X';        {Display text on screen packet}
  KAck             = 'Y';        {Acknowledge packet}
  KEndOfFile       = 'Z';        {End of file packet}
  KTimeout         = #0;         {Psuedo code for showing timeouts}

type
  {Kermit state machine states}
  KermitStateType = (
    KSRecInit,        {0  Entry point for non-server receive command}
    KSRecFile,        {1  Look for a file header or EOT message}
    KSRecData,        {2  Receive data up to end of file}
    KSRecDataWin,     {3  Receive data in SWC mode up to end of file}
    KSSendInit,       {4  Also entry for send command}
    KSOpenFile,       {5  Open file or set up text to send}
    KSSendFile,       {6  Send file or text header}
    KSSendData,       {7  Send contents of file or textual information}
    KSSendDataWin,    {8  Send contents of file in SWC mode}
    KSCheckAckWin,    {9  Check for pending ACK in SWC mode}
    KSSendEof,        {10 Send end of file indicator}
    KSSendEofWin,     {11 Flush outstanding packets and send EOF}
    KSSendBreak,      {12 End of transmission}
    KSComplete,       {13 Successful completion of transaction}
    KSAbort);         {14 Premature termination of transaction}

  {Kermit option record}
  KermitOptionRec = record
    MaxPacketLen : Byte;
    MaxTimeout : Byte;
    PadCount : Byte;
    PadChar : Char;
    Terminator : Char;
    CtlPrefix : Char;
    HibitPrefix : Char;
    Check : Char;
    RepeatPrefix : Char;
    CapabilitiesMask : Byte;
    WindowSize : Byte;
    MaxLongPacketLen : Word;
    SendInitSize : Word;
  end;

 type
   {!!.04}
   BlockDataType   = Array[1..100] of Char;
   OneKermitBlock =
     record
       Len         : Integer;
       Seq         : Integer;
       ACKed       : Boolean;
       Retries     : Byte;
       BlockData   : BlockDataType;
     end;
   KermitWindowPtr = ^KermitWindow;
   KermitWindow    = Array[1..31] of OneKermitBlock;

 const
  {Default kermit options (from the Kermit Protocol Manual}
  DefKermitOptions : KermitOptionRec =
    (MaxPacketLen : 80;                    {80 characters}
     MaxTimeout :  5;                      {5 seconds}
     PadCount : 0;                         {No pad chars}
     PadChar : #0;                         {Null pad char}
     Terminator : cCR;                     {Carriage return}
     CtlPrefix : '#';                      {'#' char}
     HibitPrefix : 'Y';                    {Space means no hibit prefixing}
     Check : '1';                          {1 byte chksum}
     RepeatPrefix : '~';                   {Default repeat prefix}
     CapabilitiesMask : 0;                 {No default extended caps}
     WindowSize : 0;                       {No default windows}
     MaxLongPacketLen : 0;                 {No default long packets}
     SendInitSize : 0);                    {No default sendinit size}

  {!!.03}
  {Default kermit options (from the Kermit Protocol Manual}
  MissingKermitOptions : KermitOptionRec =
    (MaxPacketLen : 80;                    {80 characters}
     MaxTimeout :  5;                      {5 seconds}
     PadCount : 0;                         {No pad chars}
     PadChar : #0;                         {Null pad char}
     Terminator : cCR;                     {Carriage return}
     CtlPrefix : '#';                      {'#' char}
     HibitPrefix : ' ';                    {No hibit prefixing}
     Check : '1';                          {1 byte chksum}
     RepeatPrefix : ' ';                   {Default repeat prefix}
     CapabilitiesMask : 0;                 {No default extended caps}
     WindowSize : 0;                       {No default windows}
     MaxLongPacketLen : 0;                 {No default long packets}
     SendInitSize : 0);                    {No default sendinit size}

type
  {Pointer to a protocol record}
  KermitProtocolPtr = ^KermitProtocol;

  {A Kermit protocol object}
  KermitProtocol = object(AbstractProtocol)
    {General...}
    RetryCnt         : Byte;            {Current number of retries}
    RetryInProgress  : Boolean;         {Indicates retries are in progress}
    DataLen          : Word;            {Length of sent packet data field}
    RecDataLen       : Word;            {Length of recd packet data field} {!!.04}
    ActualDataLen    : Word;            {Length decoded data bytes}
    DataBlock        : ^DataBlockType;  {Standard data block (data field)}

    KermitState      : KermitStateType; {Current state of machine}
    PacketType       : Char;            {Type of last packet}
    KermitOptions    : KermitOptionRec; {Options for this transfer}
    RmtKermitOptions : KermitOptionRec; {Options remote says to use}
    UsingHibit       : Boolean;         {True if prefixing hibit chars}
    UsingRepeat      : Boolean;         {True if using repeat cnt feature}
    MinRepeatCnt     : Byte;            {Min threshold to use repeat feature}
    UseToChar        : Boolean;         {True if the current packet uses ToChar}
    RecBlockNum      : Word;            {Blocknum of last received packet}
    ExpectedAck      : Word;            {Blocknum of next expected Ack}
    BlockCheck2      : Word;            {For holding Crc check value}
    CheckKnown       : Boolean;         {True if we've agreed on check type}
    LPInUse          : Boolean;         {True if we're using "long" packets}{!!.04}
    ReceiveInProgress  : Boolean;       {True if receiving a file}      {!!.04}
    TransmitInProgress : Boolean;       {True if transmitting a file}   {!!.04}

    {Receiving...}
    RcvTimeout       : Word;            {Tics to wait for a response}
    RawDataLen       : Word;            {actual data bytes in recd packet}{!!.04}

    {Transmitting...}
    WorkBlock        : ^DataBlockType;  {Holds transmit temp pool}
    WorkLen          : Word;            {Count of bytes in temp pool}
    LastWorkIndex    : Word;            {For managing data pool}
    WorkEndPending   : Boolean;         {True if no more WorkBlocks}
    EndOfFile        : Boolean;         {True if no more DataBlocks}

    {!!.04 sliding windows}
    SWCInUse         : Boolean;         {True if we're using SWC}
    Next2Send        : Byte;            {SWC: next block to send}
    SwcHead          : Byte;            {SWC: next block to fill (head)}
    SwcTail          : Byte;            {SWC: next block to send (tail)}
    TableTimer       : EventTimer;      {SWC: times ACK when table full}
    TableRetry       : Byte;            {SWC: counts timeout retries}
    NeedAbort        : Boolean;         {SWC: True if receive pending abort}
    SWCBlock         : KermitWindowPtr; {SWC: our sliding-windows buffers}

    {General...}
    constructor Init(APPtr : AbstractPortPtr);
      {-Allocates and initializes a protocol control block}
    constructor InitCustom(APPtr : AbstractPortPtr;
                           KOptions : KermitOptionRec;
                           Options : Word);
      {-Allocates and initializes a protocol control block with options}
    destructor Done; virtual;
      {-Disposes of the protocol record}
    procedure SetKermitOptions(KOptions : KermitOptionRec);
      {-Update the KermitProtocol object to use KOptions}
    procedure SetMaxPacketLen(MaxLen : Byte);
      {-Set the maximum packet length}
    procedure SetMaxLongPacketLen(MaxLen : Word);                      {!!.02}
      {-Set the maximum long packet length}
    procedure SetMaxWindows(MaxNum : Byte);                            {!!.02}
      {-Set the max number of SWC windows to allow}
    procedure SetSWCTurnDelay(TrnDelay : Word);                        {!!.04}
      {-Set the turnaround delay factor for SWC transfers}
    procedure SetMaxTimeoutSecs(MaxTimeout : Byte);
      {-Set the maximum time to wait for a packet}
    procedure SetPacketPadding(C : Char; Count : Byte);
      {-Set the pad character and count}
    procedure SetTerminator(C : Char);
      {-Set the packet terminator}
    procedure SetCtlPrefix(C : Char);
      {-Set the control character quote prefix}
    procedure SetHibitPrefix(C : Char);
      {-Set the hibit quote prefix}
    procedure SetRepeatPrefix(C : Char);
      {-Set the repeat quote prefix}
    procedure SetKermitCheck(CType : Byte);
      {-Set the block check type (bcCheckSum1 (default), bcCheckSum2, bcCrcK)}
    function GetSwcSize : Byte;                                        {!!.04}
      {-Return size of sliding window (0 if not in use)}               {!!.04}
    procedure GetLPStatus(var InUse : Boolean; var PacketSize : Word); {!!.04}
      {-Return status of long packet feature}                          {!!.04}
    procedure ProtocolTransmit; virtual;
      {-Start a Kermit protocol transmit}
    procedure ProtocolReceive; virtual;
      {-Start a KermitProtocol receive}
    function WindowsUsed : Word;                                       {!!.10}
      {-Return number of window slots used}                            {!!.10}

    {$IFDEF UseStreams}
    constructor Load(var S : IdStream);
      {-Load a KermitProtocol object from a stream}
    procedure Store(var S : IdStream);
      {-Store a KermitProtocol object to a stream}
    {$ENDIF}

    {#Z+}
    {++++ Internal methods ++++}
    procedure kpRawInit;
    procedure apUpdateBlockCheck(CurByte: Byte); virtual;
    procedure apSendBlockCheck; virtual;
    function apVerifyBlockCheck : Boolean; virtual;
    procedure apCancel; virtual;
    procedure apAbortProtocol; virtual;
    procedure apResetStatus;
    procedure kpSendTerminator;
    procedure kpGetUnChar(var C : Char);
    procedure kpPutToChar(C : Char);
    procedure kpGetDataChar(var C : Char;
                            var Cnt : Word;
                            var RepeatCnt : Word);
    procedure kpPutHeader(HType : Char; Len : Word);
    procedure kpPutSWCHeader(HType : Char;
                             BNum : Byte;
                             Len : Word);    {!!.04}
    procedure kpCheckForHeader;
    function kpLookForHeader : Boolean;                                 {!!.04}
    procedure kpGetHeader;
    procedure kpGetAckHeader;                                           {!!.04}
    function  kpNextSeq(I : Integer) : Integer;
    procedure kpSendAck(Seq : Byte);
    procedure kpSendNak(Seq : Byte);
    procedure kpProcessOptions;
    procedure kpSendOptions;
    procedure kpSendError(Msg : String);
    function kpCheckRetries : Boolean;
    function kpCheckSWCRetries(LA : Integer) : Boolean;                 {!!.04}
    procedure apFinishWriting; virtual;                                 {!!.03}
    procedure apReceiveBlock(var Block : DataBlockType;
                             var BlockSize : Word;
                             var Handshake : Char); virtual;
    function apWriteProtocolBlock(var Block : DataBlockType;
                                  BlockSize : Word) : Boolean; virtual;
    function apReadProtocolBlock(var Block : DataBlockType;               {!!.03}
                                 var BlockSize : Word) : Boolean; virtual;{!!.03}
    procedure kpReceivePacket;
    function kpReceiveAckPacket : Boolean;                              {!!.04}
    function kpTableFull : Boolean;                                     {!!.04}
    function kpPacketsOutstanding : Boolean;                            {!!.04}
    function SeqInTable(SeqNum : Integer) : Integer;                    {!!.04}
    procedure kpTxRotateTable(LA : Integer);                            {!!.04}
    procedure kpRxRotateTable(LA : Integer);                            {!!.04}
    function kpMostDesired : Integer;                                   {!!.04}
    procedure kpResetTable;                                             {!!.04}
    procedure kpExtractFileInfo;
    procedure kpSendPacket(PT : Char);
    procedure kpSendSWCPacket(N2S : Integer);                           {!!.04}
    procedure kpSendFilePacket;
    procedure kpSendInitialize;
    procedure kpDisplayPacket; virtual;
    procedure apTransmitBlock(var Block : DataBlockType;
                              BLen : Word; BType : Char); virtual;
    procedure kpTransmitSWCBlock(var Block : BlockDataType;             {!!.04}
                                 BLen : Word);
    procedure kpLoadTransmitData;
    procedure kpLoadTransmitDataWin;                                    {!!.04}
    procedure kpProcessKermit;
    {#Z-}
  end;

  {$IFDEF UseStreams}
  procedure KermitProtocolStream(SPtr : IdStreamPtr);
    {-Register all types needed for streams containing kermit objects}
  {$ENDIF}

implementation

uses totmisc, totstr;

const
  {'S' - SendInit packet option index}
  MaxL    = 1;     {Max packet length sender can receive (Def = none)}
  Time    = 2;     {Max seconds to wait before timing out (Def = none)}
  NPad    = 3;     {Number of padding chars before packets (Def = none)}
  PadC    = 4;     {Padding character (Def = Nul)}
  EOL     = 5;     {Packet terminator character (Def = CR)}
  QCtl    = 6;     {Prefix char for control-char encoding (Def = #)}
  QBin    = 7;     {Prefix char for hi-bit encoding (Def = ' ' none)}
  Chkt    = 8;     {1=chksum, 2=2 byte chksum, 3=CRC (Def = 1)}
  Rept    = 9;     {Prefix char for repeat-count encoding (Def = ' ' none)}
  Capa    = 10;    {Advanced capabilities bit masks}
  Windo   = 11;    {Size of the sliding window (in packets)}
  MaxLx1  = 12;    {long packet size div 95}                        {!!.02}
  MaxLx2  = 13;    {Long packet size mod 95}                        {!!.02}
  SendInitLen = 13; {Size of SendInit data block}                   {!!.02}
  MaxKermitOption = 13;

  {Advanced capability bit masks}
  LastMask       = $01;  {Set if more bit masks follow}
  LongPackets    = $02;  {Set if using long packets}
  SlidingWindows = $04;  {Set if using sliding windows}
  FileAttribute  = $08;  {Set if using Attribut packets, not supported}

  {Text strings for various error/abort conditions}
  eRecInitTO = 'Timeout waiting for RecInit packet';
  eFileTO = 'Timeout waiting for File packet';
  eDataTO = 'Timeout waiting for Data packet';
  eSync = 'Failed to syncronize protocol';
  eAsync = 'Blockcheck or other error';
  eCancel = 'Canceled';
  eFileExists = 'Not allowed to overwrite existing file';
  eFileError = 'Error opening or writing file';

  {Check to CheckType conversion array}                                 {!!.02}
  CheckVal : array[1..3] of Byte = (bcChecksum1, bcChecksum2, bcCrcK);  {!!.02}

  {$I OOKERMIT.PA1}   {Kermit part 1}
  {$I OOKERMIT.PA2}   {Kermit part 2}
end.

