Unit Misc;
{$I ApDefine.Inc}
{$I Sys75.INC}

Interface

Uses
  DOS,
  Spuds,
  TotFast, totdate;

Type
  TogType = (ttPrn, ttSpkr, ttMisc, ttAvail);
  Str40 = String [40];

Procedure ShowScreen (B: Byte);
Procedure ReadConfiguration;
Procedure DosShell (Save: Boolean);
Procedure RunIdle (A: Byte);
Function  GoOffHook (Clr: Boolean): Boolean;
Procedure Toggle (What: TogType);
Procedure UpdateDailyLog (NewDay: Boolean);
Procedure DisplayLocalStats;
Procedure Status (Text: StrIng);
Procedure InitCum;
Procedure InitComPort;
Procedure InitModem (S: Byte);
Procedure Recycle;
Procedure ErrorLog (S: String);
Procedure WackRight (C: Char);
Procedure WackRightStr (S: String);
Procedure GetFreeSpace;
Procedure ShowErrorLog;
Function  GetSysopPw (ShowIt: Boolean): Boolean;
Procedure Unsupported;
Procedure ShowWfcCommands;
Function  MonitorRinging: Boolean;
Procedure ShowOnlineHelp;
Procedure WinInfo (S: String; yyz: word);
Procedure DumpScreen;
Procedure GetColor (X, Y: Byte; Var B: Byte);
Procedure WhyNotReg;
Procedure Log (q: Byte; S: String);
Procedure GetIdles;
Procedure SetMode (b: byte; rest: boolean);
Function  makepw (New, askold: Boolean): pwstr;
procedure showwfc;
Function  Prep (gooff, syspwrd: boolean; pr: string): Boolean;
Procedure deleteoldLogs;
Procedure makelogfile;
Procedure showlogs;
Procedure openingscreen;
Procedure ParseParams;
Procedure MultiTask;
Procedure Registration (Show: Boolean);
Procedure InitVars;
Procedure SaveBoardData;
Procedure ClosingScreen;
Procedure PrepClose;
Procedure writecreds;
Procedure bbstexttrap;
Procedure bbsshell;
function  ascii: char;
function  findbottomline: byte;
procedure gotomenu;
Procedure ActParams;
procedure moreinits;
procedure evenmoreinits;
procedure showtoggles;
Procedure DoEach (Var S: String; S2: str30; ndos: boolean);
Procedure ValPaths (var uc2: configtype; var nd2: nodedatatype; Big: Boolean; ndos: boolean);
procedure newday;
function  parsepath (S: PathStr): PathStr;
function  runcomm (exeparams: string; s2: str40; swap, forcedos: boolean): byte;
procedure copylogs;
function  dszlogstr (s: string; var dsz: dszrec): boolean;
procedure stripansi (var s: string);
procedure notice (w: word; s: string);
procedure flagedit;
function  movefile (from, tto: pathstr): shortint;
procedure editmbases;
procedure editfareas;

Var
  RingTime: LongInt;
  RingTag, IsRinging: Boolean;
  CurRing, SentATA, RingCount: Byte;
  StrFile: File of String;
  LogFile: Text;
  Today: date;
  carriertimeout: byte;
  commandchar: byte;

Const
  ConfigMe: Boolean = False;
  AltConfig: PathStr = '';
  ExitNoDrop: Boolean = False;
  uselog: boolean = false;
  flagset: array [1..26] of char = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
  allowflagedit: boolean = false;

Implementation

Uses
  Crt,
  ApPort, ApMisc, ApUart, OoModem, OoCom,
  {$IFDEF UseFossil} ApFossil, {$ENDIF} {$IFDEF UseDigi14} ApDigi14, {$ENDIF}
  TotStr, TotMsg, TotIo1, TotMisc, TotInput, TotSys, TotKey, TotWin,
  Crunches, Clocks, Users, Fades, Fonts, Shell, Sysop, Chats, Acs, RemEmu,
  Comm, Emu, EmuCodes, Events, ScrSave, StatusBar, Multi, Regs, ScrBack,
  Protocols, HostMode, DumbTerm, Menus, MiscSys, BlackLst, Hookers, pdmenus,
  FileMenu, JoinConf, Messages, MsgSpon, FileSpon;

Const
  mEditor : Boolean = False;
  tEditor : Boolean = False;
  uEditor : Boolean = False;
  AltPort : Byte = 255;

Procedure DisplayLocalStats;
Var
  Date, Time: String [8];
  R, T: Real;
  q: datetimerec;
  L: LongInt;
Begin
  Screen^. WriteAt (15, 2, 15, PadLeft (Uc. BoardName, 34, ' '));
  Screen^. WriteAt (15, 3, 15, PadLeft (Uc. SysopName, 34, ' '));
  Screen^. WriteAt (46, 11,15, PadRight (IntToStr (NodeNumber), 3, ' '));

  with totals do begin
    Screen^. WriteAt (17, 7, 15, PadRight (IntToStr (tCalls), 6, ' '));
    Screen^. WriteAt (17, 8, 15, PadRight (IntToStr (tUsers), 6, ' '));
    Screen^. WriteAt (17, 9, 15, PadRight (IntToStr (tUplds), 6, ' '));
    Screen^. WriteAt (17,10, 15, PadRight (IntToStr (tDnlds), 6, ' '));
    Screen^. WriteAt (17,11, 15, PadRight (IntToStr (tFiles), 6, ' '));
    Screen^. WriteAt (17,12, 15, PadRight (IntToStr (tMesgs), 6, ' '));
    Screen^. WriteAt (44, 7, 15, PadRight (IntToStr (DailyLog. TimeOnline), 5, ' '));
  end;

  With LastCaller Do If Name <> '' Then Begin
    GetDateTimeStr (DateTime, Date, Time);
    Screen^. WriteHi (15, 4, 8, 15, PadLeft (Copy (Name, 1, 27) +
    ' ~(~' + Copy (Time, 1, 5) + '~)~', 32, ' '));
  End Else
    Screen^. WriteAt (15, 4, 8, 'No one has called yet');

  With Totals do Begin
    now (q);
    L := Succ (q. d - tFirstDay);
    Screen^. WriteAt (44, 8, 15, PadRight (IntToStr (L), 5, ' '));
    R := tCalls;
    T := L;
    Screen^. WriteAt (44, 9, 15, PadRight (RealToStr (R / T, 1), 5, ' '));
  End;
End;

Procedure Status (Text: StrIng);
Begin
  If Length (Text) > 37 Then Text [0] := #37;
  Screen^. WriteHi (11, 14, 15, 8, '[~' + Text + '~]' + Replicate (37 - Length (Text), ' '))
End;

Procedure InitCum;
Begin
  InitComPort;
  If localonly then exit;
  If Uart^. CheckDCD and not FrontEnd then begin
    ComWriteLn ('');
    ComWriteLn ('|09A c|01arrier |09w|01as |09d|01etected |09o|01n |09t|01he |09c|01om |09p|01ort.');
    ComWrite   ('|09W|01ould |09y|01ou |09l|01ike |09t|01o |09l|01oad |09t|01he |09b|01oard ');
    Key^. FlushBuffer;
    SetInputTimeOut (90, kSftY);
    If LiteBar (lbNo, False, True) = lbYes Then FrontEnd := True;
    comwriteln ('');
  end;
  {$IFDEF EventLogging}
  InitEventLogging (10000);
  {$ENDIF}
  With Modem^ Do Begin
    SetModemDelay (0);
    SetHandleResponses (True);
    if not uart^. checkDCD then begin
      Screen^. WriteLn ('|08initializing modem');
      InitModem (2);
      Screen^. Write ('|08reading modem data|00 '#8);
      carriertimeout := GetModemRegister (7);
      commandchar := GetModemRegister (2);
      Screen^. Writeln ('|08');
    end else
      Screen^. WriteLn ('|08carrier detected');
  End;
  Screen^. CursOff;
End;

procedure BadModemInit;
begin
  Crt. NoSound;
  Crt. TextMode (Co80);
  textattr := 7;
  System. Writeln ('Failed to initialize comport or modem. Check under Communications in the');
  System. Writeln ('config. If everything appears to be right and you still experience this ');
  System. Writeln ('problem, please read DOX\BUGS.DOX, and fill out & send in a bug report.');
  System. Writeln;
  Halter (9)
end;

Procedure InitComPort;
Var
  Errors: Byte;
  CTS_Detected: Boolean;
  Time: LongInt;
  MsgWin : ^PromptOBJ;
  ActionCode: tAction;
  InSize, OutSize: Word;
  rFull, rResume: Real;
  ut: uarttype;
  s: string;
  name, hiver, lover: byte;
Begin
  if localonly then exit;

  With NodeData Do Begin
    case PortType of
(*      {$IFDEF UseUart}
      UartDevice :
      begin
        SetUart (Port, Base, IRQ, Vector);
        New (UartPortPtr (Uart), InitKeep (Port, InSize, OutSize));
      end;
      {$ENDIF}
      {$IFDEF UseFossil}
      FossilDevice :
        New (FossilPortPtr (Uart), InitKeep (Port, InSize, OutSize));
      {$ENDIF}
      {$IFDEF UseDigi14}
      Digi14Device :
        New (Digi14PortPtr (Uart), InitKeep (Port, InSize, OutSize));
      {$ENDIF}*)
    {$IFDEF UseUart}
    UartDevice :
    begin
      SetUart (Port, Base, IRQ, Vector);
      New(UartPortPtr(uart), InitCustom(port,
                                      Baud, Parity, Data, Stop,
                                      inSize, outSize,
                                      DefPortOptions));
    end;
    {$ENDIF}
    {$IFDEF UseFossil}
    FossilDevice :
      New(FossilPortPtr(uart), InitCustom(port,
                                        Baud, Parity, Data, Stop,
                                        inSize, outSize,
                                        DefPortOptions or
                                        DefFossilOptions or
                                        ptTrueOutBuffFree));
    {$ENDIF}
    {$IFDEF UseDigi14}
    Digi14Device :
      New(Digi14PortPtr(uart), InitCustom(port,
                                        Baud, Parity, Data, Stop,
                                        inSize, outSize,
                                        DefPortOptions));
    {$ENDIF}
    end;

    if AsyncStatus <> ecOk Then BadModemInit;
    If Uart = Nil Then Halt (ecOutOfMemory);

    Uart^. SetModem (True, True);

(*    with uart^ do if not checkDCD then case porttype of
      {$IFDEF UseUart}
      UartDevice : begin
                     SetLine (Baud, Parity, Data, Stop);
                     PR^. Flags := DefPortOptions;
                   end;
      {$ENDIF}
      {$IFDEF UseFossil}
      FossilDevice : begin
                       SetLine (Baud, Parity, Data, Stop);
                       PR^. Flags := DefPortOptions or DefFossilOptions or ptTrueOutBuffFree;
                     end;
      {$ENDIF}
      {$IFDEF UseDigi14}
      Digi14Device : begin
                       SetLine (Baud, Parity, Data, Stop);
                       PR^. Flags := DefPortOptions;
                     end;
      {$ENDIF}
    end;*)

    If AsyncStatus <> ecOk Then BadModemInit;
    Screen^. WriteLn ('|08com port initialized');

    Errors := 0;

    if not uart^. checkDCD and (PortType <> FossilDevice) Then Repeat
      CTS_Detected := Uart^. CheckCTS;
      If CTS_Detected Then Break;
      Case Errors of
        0: iDelay (500);
        1: iDelay (1000);
        2:
          Begin
            New (MsgWin, Init (1, ' Modem Error '));
            With MsgWin^ Do Begin
              AddLine ('');
              AddLine (' The CTS line on the modem is low. ');
              AddLine (' Make sure that your modem is on.  ');
              AddLine ('');
              SetDefault (182, Finished);
              SetOption (1, ' ~P~roceed ', 80, Finished);
              SetOption (2, ' ~A~bort ', 65, Escaped);
              Screen^. CursOff;
              Screen^. EnableHighBgd;
              ActionCode := Show;
            End;
            Dispose (MsgWin, Done);
            Screen^. DisableHighBgd;
            Screen^. CursOn;
            iDelay (1000);
          End;
        3: BadModemInit;
      End;
      Inc (Errors);
    Until CTS_Detected;

(*    if not uart^. checkDCD then Uart^. SetModem (True, True); {DTR, RTS}*)

    rFull := NodeData. InSize * BufferFullPercent;
    rResume := NodeData. InSize * BufferResumePercent;
    Uart^. HWFlowEnable (Trunc (rFull), Trunc (rResume), HardwareFlowOn);

    New (Modem, Init (Uart));
    If AsyncStatus <> ecOk Then BadModemInit;
    If Modem = Nil Then Halt (ecOutOfMemory);

    If PortType = UartDevice Then Begin
      ut := ClassifyUart (Uart^. GetBaseAddr, False);
      s := UartTypeString [ut];
      Screen^. WriteLn ('|08' + s [1] + '' + s [2] + '' + copy (s, 3, 255) + ' uart chip detected');
      If ut = U16550A Then
        SetFifoBuffering (Uart^. GetBaseAddr, FifoLevel <> 0, FifoLevel);
    End Else If PortType = FossilDevice Then Begin
      GetDriverVersion (Uart^. PR, name, hiver, lover);
      case name of
        0: s:= 'generic';
        1: s:= 'X00';
        2: s:= 'BNU';
        3: s:= 'SIO';
      end;
      s := s + ' fossil driver';
      Screen^. WriteLn ('|08using ' + S);
    End;
  End;
End;

Procedure InitModem (S: Byte);
Var
  Errors: Byte;
  Time: LongInt;
  T: String;
Begin
  If LocalOnly Then Exit;
  If Uart^. CheckDCD Then Exit;

  Case S Of
    1: Status ('Initializing modem...');
    2: Modem^. SetEcho (True);
  End;

  Errors := 0;

  if s = 2 then Screen^. Write ('|08');

  Repeat
    AsyncStatus := ecOk;
    Uart^. FlushInBuffer;
    Uart^. FlushOutBuffer;
    T := Strip ('A', '|', NodeData. InitStr);
    T := Strip ('A', '~', T);
    If S = 2 Then Screen^. Write ('|08' + T + '|15 ');
    ModemStrFix (NodeData. InitStr);
    Modem^. GetModemResponse (90);
    If AsyncStatus <> ecOk Then iDelay (300);
    If Errors = 3 Then BadModemInit;
    Inc (Errors);
    if s = 2 then screen^. write (' ');
  Until AsyncStatus = ecOk;

  If S = 2 Then Screen^. WriteLn ('');

  Case S Of
    0: ;
    1: Status ('Modem initialized OK');
    2: Modem^. SetEcho (False);
  End;
  WfcInit := 0;
  Modem^. ConnectSpeed := 0;
End;

Procedure Recycle;
Begin
  if localonly then exit;

  If Uart^. CheckDCD Then Begin
    iDelay (150);
    Uart^. FlushInBuffer;
    Uart^. FlushOutBuffer;
    Modem^. HangupModem (mHangup, True);
  End;

  If Uart^. CheckDCD Then Begin
    iDelay (150);
    Uart^. FlushInBuffer;
    Uart^. FlushOutBuffer;
    Modem^. HangupModem (mHangup, False);
  End;

  iDelay (150);
  Uart^. FlushInBuffer;
  Uart^. FlushOutBuffer;
  ModemStrFix (NodeData. HangupStr);

  InitModem (1);
  iDelay (200);
  Status ('Waiting for calls');
End;

Procedure ErrorLog (S: String);
Var
  fErrorLog: Text;
Begin
  Assign (fErrorLog, NodeData. NodePath + 'ERROR.LOG');
  {$I-}
  Append (fErrorLog);
  {$IFDEF Debug} {$I+} {$ENDIF}
  If IOResult = 2 Then Begin
    Rewrite (fErrorLog);
    WriteLn (fErrorLog, Ansa (8, textattr) + ' '+ Replicate (25, '') + Ansa (15, textattr) + '[' + Ansa (8, textattr) +
             'System/75 Error Log File'+ Ansa (15, textattr) + ']' + Ansa (8, textattr) + Replicate (26, '') + '');
    WriteLn (fErrorLog, ' ' + Replicate (77, '') + '');
    WriteLn (fErrorLog);
  End;

  System. WriteLn (fErrorLog, S);
  Close (fErrorLog);
End;

Procedure WackRight (C: Char);
Var
  B: Byte;
Const
  Ca: Array [1..5] Of String [3] = ('|01', '|03', '|09', '|11', '|15');
Begin
  For B := 1 To 5 Do Begin
    Screen^. Write (Ca [B] + C);
    If B <> 5 Then Write (#8);
    Crt. Delay (7);
  End;
End;

Procedure WackRightStr (S: String);
Var
  B: Byte;
Begin
  For B := 1 To Length (S) Do
    WackRight (S [B]);
End;

  Procedure Toggle (What: TogType);
  Begin
    Case What Of
      ttPrn:
          Begin
            vToggles := vToggles Xor 1;
            If Current = Waiting Then
              If B (vToggles, 1) Then Begin
                If ExDispMode Then Begin
                  SetCol (2, 21, 21, 21);
                  Screen^. Attrib (38, 20, 44, 20, 2);
                  Disolve (8, 15, 2, 3);
                End;
                Screen^. Attrib (38, 20, 44, 20, 15);
                If ExDispMode Then SetCol (2, 0, 42, 0);
              End Else Begin
                If ExDispMode Then Begin
                  SetCol (2, 63, 63, 63);
                  Screen^. Attrib (38, 20, 44, 20, 2);
                  Disolve (15, 8, 2, 3);
                End;
                Screen^. Attrib (38, 20, 44, 20, 8);
                If ExDispMode Then SetCol (2, 0, 42, 0);
              End
            Else If Current = Board Then ShowStatus;
          End;
      ttAvail:
            Begin
              vToggles := vToggles XOr 8;
              If Current = Waiting Then
                If B (vToggles, 8) Then Begin
                  If ExDispMode Then Begin
                    SetCol (2, 21, 21, 21);
                    Screen^. Attrib (38, 21, 46, 21, 2);
                    Disolve (8, 15, 2, 3);
                  End;
                  Screen^. Attrib (38, 21, 46, 21, 15);
                  If ExDispMode Then SetCol (2, 0, 42, 0);
                End Else Begin
                  If ExDispMode Then Begin
                    SetCol (2, 63, 63, 63);
                    Screen^. Attrib (38, 21, 46, 21, 2);
                    Disolve (15, 8, 2, 3);
                  End;
                  Screen^. Attrib (38, 21, 46, 21, 8);
                  If ExDispMode Then SetCol (2, 0, 42, 0);
                End
              Else If Current = Board Then ShowStatus;
            End;
      ttSpkr:
           Begin
             vToggles := vToggles Xor 4;
             If Current = Waiting Then
               If B (vToggles, 4) Then Begin
                 If ExDispMode Then Begin
                   SetCol (2, 21, 21, 21);
                   Screen^. Attrib (38, 22, 46, 22, 2);
                   Disolve (8, 15, 2, 3);
                 End;
                 Screen^. Attrib (38, 22, 46, 22, 15);
                 If ExDispMode Then SetCol (2, 0, 42, 0);
               End Else Begin
                 If ExDispMode Then Begin
                   SetCol (2, 63, 63, 63);
                   Screen^. Attrib (38, 22, 46, 22, 2);
                   Disolve (15, 8, 2, 3);
                 End;
                 Screen^. Attrib (38, 22, 46, 22, 8);
                 If ExDispMode Then SetCol (2, 0, 42, 0);
               End
             Else If Current = Board Then ShowStatus;
           End;
      ttMisc:
          Begin
            vToggles := vToggles Xor 2;
            If Current = Waiting Then
              If B (vToggles, 2) Then Begin
                If ExDispMode Then Begin
                  SetCol (2, 21, 21, 21);
                  Screen^. Attrib (38, 23, 44, 23, 2);
                  Disolve (8, 15, 2, 3);
                End;
                Screen^. Attrib (38, 23, 44, 23, 15);
                If ExDispMode Then SetCol (2, 0, 42, 0);
              End Else Begin
                If ExDispMode Then Begin
                  SetCol (2, 63, 63, 63);
                  Screen^. Attrib (38, 23, 44, 23, 2);
                  Disolve (15, 8, 2, 3);
                End;
                Screen^. Attrib (38, 23, 44, 23, 8);
                If ExDispMode Then SetCol (2, 0, 42, 0);
              End
            Else If Current = Board Then ShowStatus;
          End;
    End;
  End;

  Function GoOffHook (Clr: Boolean): Boolean;
  Begin
    GoOffHook := False;

    If Clr Then Begin
      Screen^. Clear (7, ' ');
      Screen^. GotoXY (1, 1);
      Clock^. Show (False);
    End;

{    if not dossysauto then begin}
      Screen^. Write ('|09G|01o |09o|01ff|08-|09h|01ook ');

      Case LiteBar (lbNo, True, True) Of
        lbYes:
              Begin
                ReInit := True;
                ModemStrFix (NodeData. OffHookStr);
                GoOffHook := True;
              End;
        lbNo: GoOffHook := True;
      end;
{    End else
      GoOffHook := True;}
  End;

  Procedure RunIdle (A: Byte);
  Var
    SwapIt, RetVal  : Integer;
    C, P, Path      : String;
    PSR             : PortSaveRec;
  Begin
    Clock^. Show (False);
    With Uc. Idles [A] Do Begin
      If Name = '' Then Exit;
      If Doss Then Begin
        P := '/C ' + Comm + ' ' + Param;
        C := GetEnv ('ComSpec');
      End Else Begin
        P := Param;
        C := Comm;
      End;

      if currentmode <> 25 then setmode (25, false);
      LoadFont ('Dos.Fnt', 25);
      Screen^. Clear (7, ' ');
      SetScreenSize (1, 1, 80, 25);

      if not localonly then begin
        Uart^. SavePort (PSR);
        Uart^. DeactivatePort (True);
      end;

      Path := GetEnv ('TEMP');
      If Path = '' Then Path := GetEnv ('TMP');
      If Path = '' Then Path := '.';

      If Swap Then Begin
        If B (Uc. Options, UseEMS) And B (Uc. Options, UseXMS) Then
          SwapIt := Swap_All
        Else If B (Uc. Options, UseEMS) Then
          SwapIt := Swap_Ems
        Else If B (Uc. Options, UseXMS) Then
          SwapIt := Swap_Xms
        Else
          SwapIt := Swap_Disk;

        Init_Spawno (Path, SwapIt, 20, 0);
        RetVal := Spawn (C, P, 0);
      End Else DOS. Exec (C, P);

      If Pause Then Begin
        With Screen^ Do
          UpdateCursor (WhereX, WhereY);
        PressEnter;
      End;

      if not localonly then begin
        Uart^. RestorePort (PSR);
        Uart^. ActivatePort (True);
        Uart^. FlushInBuffer;
        Uart^. FlushOutBuffer;
      end;

      {$I-}
      ChDir (Copy (Uc. BasePath, 1, Pred (Length (Uc. BasePath))));
      {$IFDEF Debug} {$I+} {$ENDIF}
      If IOResult <> 0 Then Halt (ecPathNotFound);

      setmode (25, false);
    End;
  End;

procedure preprun;
begin
  defuser;
  user. pagelen := 25;
  curpagelen := 25;
  reliablepagelen := true;
  HighestEmu := TermAVT;
  detectedemu := [termtty, termans, termavt];
  hung := False;
  localonly := true;
  statbar := 0;
  uselog := false;
  Current := Other;
  scrbackrunnin := false;
  allowpads := true;
  Screen^. Clear (7, ' ');
  InitEmulation;
  UpdateCursor (1, 1);
  Screen^. CursOn;
  key^. assignpressedhook (slackpressed);
end;

Procedure ReadConfiguration;
Var
  F: File;
  crap, shit, C: LongInt;
  C2: Integer;
  St: String [39];
  n: datetimerec;
  AOK, Big, Error: Boolean;
  TempScr: pScreenObj;
  T: Text;
  L: File Of LastCallNodeRec;
  D: SearchRec;
  eF: File of fEventsRun;
  cf: PathStr;
Begin
  If Not InstallHook Then Begin
    ComWriteLn ('|08opening configuration files');
    New (TempScr, Init);
    TempScr^. Save;
    Error := True;
  End;

  now (n);

  If AltConfig <> '' Then
    cf := AltConfig
  Else
    cf := 'Sys75.Cfg';

  AOK := OpenFile (cf, F);

  error := not AOK or (FileSize (F) <> SizeOf (ConfigType));

  If Not Error Then Begin
    BlockRead (F, Uc, SizeOf (Uc), C2);
    If C2 <> SizeOf (ConfigType) Then
      Error := True
    Else Begin
      ValPaths (uc, nodedata, True, True);
      Seek (F, 0);
      BlockWrite (F, Uc, SizeOf (Uc));
    End;
    Close (F);
  End;

  If error or InstallHook or ConfigMe Then Begin
    preprun;
    if configme and b (uc. options, localsec) then
      if GetSysopPw (False) Then
        SysConfig (False, False)
      else
    else
      SysConfig (installhook, False);

    If Error And Not InstallHook And Not configme Then
      TempScr^. Display
    else if installhook or configme then begin
      If configme Then Begin
        Dispose (TempScr, Done);
        If DosSav <> Nil Then DosSav^. Display;
        Screen^. CursOff;
        If DosSav <> Nil Then Dispose (DosSav, Done);
        WriteCreds;
      End;

      PrepClose;
      CloseTot;
      Halter (0);
    end;
  End;

  If NodeNumber > Uc. NumNodes Then Begin
    ComWriteLn ('|08|12node ' + IntToStr (NodeNumber) + ' is an invalid node number');
    ComWriteLn (^M^J'|08  Use a different node number or load the config and increase');
    ComWriteLn ('  the total number of nodes to be run.|07'^M^J);
    Halter (0);
  End;

  aok := not OpenFile (Uc. DataPath + 'Node_' + IntToStr (NodeNumber) + '.Dat', F);
  If FileSize (F) <> SizeOf (NodeDataType) Then begin
    aok := true;
    DeleteFile (Uc. DataPath + 'Node_' + IntToStr (NodeNumber) + '.Dat');
  End;

  Error := aok;

  If Not Error Then Begin
    BlockRead (F, NodeData, SizeOf (NodeData), C2);
    If C2 <> SizeOf (NodeData) Then
      Error := True
    Else Begin
      ValPaths (uc, nodedata, False, True);
      Seek (F, 0);
      BlockWrite (F, NodeData, SizeOf (NodeData));
    End;
    Close (F);
  End;

  If Error Then Begin
    Beep;
    preprun;
    SysConfig (True, True);
    TempScr^. Display;
  End;

  If OpenFile (Uc. DataPath + 'Totals.Dat', F) Then Begin
    BlockRead (F, Totals, SizeOf (Totals), C2);
    Close (F);
  End Else Begin
    FillChar (Totals, SizeOf (Totals), 0);
    Totals. tUsers := 1;
    Totals. tFirstDay := n. d;
  End;

  {$I-}
  ChDir (Copy (Uc. BasePath, 1, Pred (Length (Uc. BasePath))));
  {$IFDEF Debug} {$I+} {$ENDIF}

  If IOResult <> 0 Then Begin
    TextMode (CO80);
    Writeln ('Could not change to directory ' + Copy (Uc. BasePath, 1, Pred (Length (Uc. BasePath))) + '.');
    Writeln;
    Halter (3);
  End;

  Dispose (TempScr, Done);

  If Not Exist (Uc. DataPath + 'Strings.Dat') Then Begin
    ComWriteLn ('|08creating prompt file');
    SwapVectors;
    Exec (Uc. BasePath + 'MakeStr.Exe', 'qwertyuiop');
    SwapVectors;
    If (DosError <> 0) Or Not Exist (Uc. DataPath + 'Strings.Dat') Then Begin
      ComWriteLn (^M^J'|15Could not create prompt file! Run MakeStr.Exe.|07'^M^J);
      Halter (3);
    End;
  End;

  Assign (StrFile, Uc. DataPath + 'Strings.Dat');
  {$I-}
  Reset (StrFile);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IoResult <> 0 Then Begin
    ComWriteLn (^M^J'|15Unable to read prompt file! Run MakeStr.Exe.|07'^M^J);
    Halter (3);
  End;

  Assign (T, NodeData. NodePath + 'Node_Is.Up');
  {$I-}
  Reset (T);
  {$IFDEF Debug} {$I+} {$ENDIF}
  If IOResult = 0 Then Begin
    Close (T);
    ComWriteLn ('');
    ComWriteLn ('|09I|01t |09l|01ooks |09l|01ike |09n|01ode |15' + IntToStr (NodeNumber) +
                ' |09i|01s |09a|01lready |09r|01unning|15!|07!|08!');
    ComWriteLn ('|09T|01his |09m|01ight |09h|01ave |09b|01een |09c|01aused |09b|01y |09a ' +
                '|09c|01rash |09o|01r |09u|01ntimely |09r|01eboot|08.');
    ComWriteLn ('');
    Beep;
    ComWrite   ('|09W|01ould |09y|01ou |09l|01ike |09t|01o |09r|01eload ' +
                '|09n|01ode |15' + IntToStr (NodeNumber) + ' ');
    Key^. FlushBuffer;
    SetInputTimeOut (90, kSftY);
    If LiteBar (lbNo, False, True) = lbNo Then Halter (0);
    comwriteln ('');
  End Else Begin
    Rewrite (T);
    Close (T);
    SetFAttr (T, Dos. Hidden + Dos. SysFile);
  End;

  ExDispMode := B (Uc. Options, UseExDispMode);

  If Not OpenFile (NodeData. NodePath + 'NodeData.Dat', F) Then Begin
    Rewrite (F, 1);
    FillChar (MiscNodeData, Sizeof (MiscNodeData), 0);
    MiscNodeData. FirstUp := N. d;
    BlockWrite (F, MiscNodeData, SizeOf (MiscNodeData));
  End Else
    BlockRead (F, MiscNodeData, SizeOf (MiscNodeData));

  Close (F);

  If OpenFile (NodeData. NodePath + 'DailyLog.Dat', F) Then Begin
    Seek (F, FileSize (F) - SizeOf (DailyLog));
    BlockRead (F, DailyLog, SizeOf (DailyLog));
    Close (F);
    If DailyLog. jDate <> N. d Then Begin
      UpdateDailyLog (True);
      DeleteOldLogs;
      Event^. ClearRun;
      RemDatedBlacks;
    End;
  End Else Begin
    FillChar (DailyLog, SizeOf (DailyLog), 0);
    DailyLog. jDate := N. d;
    Assign (F, NodeData. NodePath + 'DailyLog.Dat');
    Rewrite (F, 1);
    BlockWrite (F, DailyLog, SizeOf (DailyLog));
    Close (F);
  End;

  Assign (L, NodeData. NodePath + 'LastCall.Dat');
  {$I-}
  Reset (L);
  {$IFDEF Debug} {$I+} {$ENDIF}

  If IOResult = 0 Then Begin
    Read (L, LastCaller);
    Close (L);
  End Else
    FillChar (LastCaller, SizeOf (LastCaller), 0);

  Big := False;
  FindFirst (NodeData. NodePath + 'Event*.Ret', AnyFile - Directory - VolumeID, D);
  While DosError = 0 do Begin
    Assign (F, NodeData. NodePath + D. Name);
    SetFAttr (F, DOS. Archive);
    {$I-}
    Erase (F);
    {$IFDEF Debug}{$I+}{$ENDIF}
    If Not Big Then Begin
      ComWriteLn ('|08returning from event');
      Big := True;
    End;
    If IoResult <> 0 Then ;
    FindNext (D);
  End;

  Crap := fSize (Uc. DataPath + 'Users.Dat') Mod Sizeof (tUserData);
  Shit := fSize (Uc. DataPath + 'Users.Idx') Mod Sizeof (tUserRec );
  If IoResult <> 0 Then ;

  If ((Crap <> -1) and (Crap <> 0)) or ((Shit <> -1) and (Shit <> 0)) Then Begin
    ComWriteln (^M^J + '|07Your user index file is corrupted. Run the System/75 Database Manager');
    ComWriteln ('and choose the "Repair User Database" option.'^M^J);
    Beep;
    Halter (4);
  End;

  If IoResult <> 0 Then ;
  LoadSysopRec (true, User);

  LogonACS := NodeData. LogonACS;

  Assign (eF, NodeData. NodePath + 'EventRun.Dat');
  {$I-}
  Reset (eF);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IoResult = 0 Then
    Read (eF, Event^. er)
  Else Begin
    Rewrite (eF);
    FillChar (Event^. er, sizeof (Event^. er), 0);
    Write (eF, Event^. er);
  End;
  Close (eF);
  If IoResult <> 0 Then ;

  With NodeData Do Begin
    If AltPort <> 255 Then Port := ComNameType (AltPort);
    If (Port = Com0) And (PortType <> FossilDevice) Then Begin
      LocalOnly := True;
      Exit;
    End Else
      LocalOnly := False;
  end;
End;

Procedure UpdateDailyLog (NewDay: Boolean);
Var
  n: datetimerec;
  F: File;
Begin
  now (n);
  If Not OpenFile (NodeData. NodePath + 'DailyLog.Dat', F) Then Exit;

  Seek (F, FileSize (F) - SizeOf (DailyLog));
  BlockWrite (F, DailyLog, SizeOf (DailyLog));

  If NewDay Then Begin
    FillChar (DailyLog, SizeOf (DailyLog), 0);
    DailyLog. jDate := N. d;
    BlockWrite (F, DailyLog, SizeOf (DailyLog));
  End;
  Close (F);
End;

Procedure DosShell (Save: Boolean);
Var
  SS              : ^ScreenObj;
  SwapIt, RetVal  : Integer;
  Prompt          : String;
  PSR             : PortSaveRec;
  T               : Byte;
Begin
  T := TextAttr;
  TextAttr := 7;

  If Save Then Begin
    New (SS, Init);
    SS^. Save;
  End;

  Asm
    Mov  AX, 3
    Int  10h
  End;

  If Not AnsiSysInstalled Then
    Prompt := '[' + Uc. BoardName+ ']$_[$T$H$H$H$H$H$H] [$P] '
  Else
    Prompt := '$E[30;1m[$E[34;0m' + Uc. BoardName+ '$E[30;1m]$_[$E[34;0m$T$H$H$H$H$H$H$E[30;1m] [$E[34;0m$P$E[30;1m]$E[0m ';

  if not localonly then begin
    Uart^. SavePort (PSR);
    Uart^. DeactivatePort (True);
  end;

  Window (1, 1, 80, 25);

{  if scrbackrunnin then with scroll^. ss^ do begin
    WriteLn (Block + ' |15S|07ys|08tem/|157|075 |15S|07he|08ll ' + Block);
    WriteLn ('');
    WriteLn ('|08Type |07EX|15i|07T |08to return to |15S|07ys|08tem/|157|075|08...');
  end else} with screen^ do begin
    WriteLn (Block + ' |15S|07ys|08tem/|157|075 |15S|07he|08ll ' + Block);
    WriteLn ('');
    WriteLn ('|08Type |07EX|15i|07T |08to return to |15S|07ys|08tem/|157|075|08...');
  end;

  If B (Uc. Options, SwapOnShell) Then Begin
    If B (Uc. Options, UseEMS) And B (Uc. Options, UseXMS) Then
      SwapIt := Swap_All
    Else If B (Uc. Options, UseEMS) Then
      SwapIt := Swap_Ems
    Else If B (Uc. Options, UseXMS) Then
      SwapIt := Swap_Xms
    Else
      SwapIt := Swap_Disk;

    Init_Spawno (NodeData. TempPath, SwapIt, 20, 0);
    RetVal := Spawn (GetEnv ('COMSPEC'), '/K PROMPT ' + Prompt, 0);
  End Else
    DOS. Exec (GetEnv ('COMSPEC'), '/K PROMPT ' + Prompt);

  if not localonly then begin
    Uart^. RestorePort (PSR);
    Uart^. ActivatePort (True);
    Uart^. FlushInBuffer;
  end;

  {$I-}
  if current = other then
    ChDir (Copy (Uc2^. BasePath, 1, Pred (Length (Uc2^. BasePath))))
  else
    ChDir (Copy (Uc. BasePath, 1, Pred (Length (Uc. BasePath))));
  {$IFDEF Debug} {$I+} {$ENDIF}
  If IOResult <> 0 Then Halt (ecPathNotFound);

{  if scrbackrunnin then
    scroll^. Ss^. Clear (0, ' ')
  else
 }   Screen^. Clear (0, ' ');

  Setmode (currentmode, false);

  case current of
    board: if statbar = 0 then
             SetScreenSize (1, 1, 80, currentmode)
           else
             SetScreenSize (1, 1, 80, pred (currentmode));
    other: SetScreenSize (1, 1, 80, currentmode);
    terminal: if exdispmode then
                SetScreenSize (1, 1, 80, 25)
              else
                SetScreenSize (1, 1, 80, 24);
  end;

  If Save Then Begin
    SS^. Display;
    Dispose (SS, Done);
  End;

  TextAttr := T;
End;

Procedure GetFreeSpace;
Var
  A, L: LongInt;
  B: Byte;
Begin
  L := 0;
  For B := 1 To Length (Uc. ScanDrives) Do Begin
    A := DiskFree (Ord (Uc. ScanDrives [B]) - 64);
    If A <> - 1 Then Inc (L, A Div 1000000);
    Screen^. WriteAt (44, 10, 15, PadRight (IntToStr (L), 5, ' '));
  End;
End;

Procedure ShowErrorLog;
Begin
  ComWriteLn ('');
  TTYPauser := 1;
  If Exist (NodeData. NodePath + 'Error.Log') Then
    ShowFile (NodeData. NodePath + 'Error.Log', True, True)
  Else
    ComWriteln ('No errors have occured or error log has been deleted.');

  ComWriteLn ('');
  PressEnter;
End;

Function GetSysopPw (ShowIt: Boolean): Boolean;
Var
  S: String;
  SaveSnip: Array [1..160] Of Byte;
Begin
  If Uc. SysopPW <> '' Then Begin
    GetSysopPw := False;
    s := Cs (37);
    if s = '' then s := '|15S|07y|08sop |15p|07as|08sword|UP: |UI';
    ComWrite (s);

    If ShowIt Then begin
      SpecialBar := True;
      If _y = 1 then
        if statbar = 0 then
          SnapShotOff := currentmode
        else
          SnapShotOff := pred (currentmode)
      else
        SnapShotOff := 1;
      Move (Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], SnapShot, 160);
      Screen^. PartClear (1, 1, 80, 1, $17, ' ');
      Screen^. WritePlain (1, 1, ' Sysop pw = ' + Uc. SysopPW + '  ' + Replicate (30, ' ') + ' ');
    end;

    S := '';
    GetPwStr (15 + Length (Uc. SysopPW), False, ShowIt, S);
    If hung Then Exit;

    If ShowIt Then
      Move (SnapShot, Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], 160);

    If S = SetLower (Uc. SysopPW) Then
      GetSysopPw := True
    else if uselog then begin
      Log (2, 'Entered incorrect sysop password');
      Log (2, '  Entered: ' + s);
    end;
    ComWriteLn ('');
  End Else
    GetSysopPW := True;

  SpecialBar := False;
End;

Procedure Unsupported;
Begin
  ComWriteLn ('');
  FillIn1 := '|08That feature is not yet ready.';
  pFile ('hdr.ans');
  ComWriteLn ('');
End;

Procedure ShowWfcCommands;
Begin
End;

    Function MonitorRinging: Boolean;
    const
      rt: longint = 0;
    var
      i: byte;
      wowzers:word;
      rd: boolean;
    Begin
      rd := false;
      MonitorRinging := False;
      Case SentATA Of
        0:
          Begin
            If Not B (NodeData. ModemOpt, AnswerRI) And Uart^. CharReady Then Begin
              Modem^. GetModemResponse (90);
              rd := AsyncStatus mod 10000 = ecRing;
            End;
            If rd or (B (NodeData. ModemOpt, AnswerRI) And Uart^. CheckRI) Then Begin
              vDone := True;
              ScrSavProc;
              If Not RingTag Then Begin
                Inc (RingCount);
                RingTag := True;
                Status ('Incoming call - Ring #' + IntToStr (RingCount));
                RingTime := BiosTime;
              End;
              IsRinging := True;
              If Et (RingTime) >= 180 Then Begin
                Status ('Phone rang for 10 continous seconds!');
                Beep;
                iDelay (1000);
                Halt (ecModemRinging);
              End;
            End Else If IsRinging Then Begin
              If RingTag Then Begin
                RingTime := BiosTime;
                RingTag := False;
                If RingCount >= NodeData. MaxRings Then Begin
                  Status ('Sending answer string to modem');
                  ModemStrFix (NodeData. AnswerStr);
                  rt := 0;
                  iDelay (150);
                  Uart^. DrainOutBuffer (540);
                  Uart^. FlushOutBuffer;
                  Uart^. FlushInBuffer;
                  IsRinging := False;
                  RingCount := 0;
                  RingTag := False;
                  Inc (SentATA);
                  Exit;
                End;
              End;
              If Et (RingTime) >= 100 Then Begin
                Status ('Caller hung up');
                iDelay (150);
                Recycle;
                IsRinging := False;
                RingCount := 0;
                RingTag := False;
              End;
            End;
          End;
        1:
          Begin
            RingCount := carriertimeout;
            Status ('Waiting for carrier (' + inttostr (carriertimeout) + ')');
            Inc (SentATA);
            RingTime := BiosTime;
          End;
        2:
          Begin
            If Et (RingTime) >= 18 Then Begin
              RingTime := BiosTime;
              Dec (RingCount);
              If (RingCount = 0) and not Uart^. CheckDCD Then Begin
                Status ('Timer elapsed, no carrier detected, recycling');
                iDelay (150);
                Recycle;
                IsRinging := False;
                RingCount := 0;
                RingTag := False;
                SentATA := 0;
              End Else Begin
                Status ('Waiting for carrier (' + PadRight (IntToStr (RingCount), 2, ' ') + ')');
              End;
            End;

            If Uart^. CharReady Then Begin
              With Modem^ do Begin
                GetModemResponse (54);
                If (AsyncStatus mod 10000 = ecNoCarrier) Or
                   (AsyncStatus mod 10000  = ecError) Or
                   (AsyncStatus mod 10000  = ecNoDialtone) Or
                   (AsyncStatus mod 10000  = ecNoAnswer)
                Then Begin
                  Status ('Modems failed to connect');
                  iDelay (150);
                  Recycle;
                  IsRinging := False;
                  RingCount := 0;
                  RingTag := False;
                  SentATA := 0;
                End Else if AsyncStatus mod 10000 = ecConnect then begin
                  Status ('Modems connected at ' + inttostr (getconnectspeed));
                  IsRinging := False;
                  RingCount := 0;
                  RingTag := False;
                  SentATA := 0;
                  MonitorRinging := True;
                  Exit;
                end;
              End;
            End;
            If Key^. KeyPressed Then Begin
              wowzers := key^. getkey;
              if wowzers = kEsc Then Begin
                Status ('Sysop aborted answer, recycling');
                iDelay (150);
                IsRinging := False;
                RingCount := 0;
                RingTag := False;
                SentATA := 0;
                Uart^. PutChar (#27);
                iDelay (100);
                Recycle;
                iDelay (50);
              End Else key^. StuffBuffer (Wowzers);
            end;
            If Uart^. CheckDCD Then Begin
              If rt = 0 then rt := BiosTime;
              if et (rt) >= 27 then begin
                Status ('Modems connected, baud unknown');
                MonitorRinging := True;
                IsRinging := False;
                RingCount := 0;
                RingTag := False;
                SentATA := 0;
                Exit;
              end;
            End;
          End;
      End;
    End;

Procedure ShowOnlineHelp;
Var
  S: pScreenObj;
Begin
  New (S, Init);
  S^. Save;

  Screen^. Clear (8, ' ');
  Screen^. CursOff;
  ShowScreen (BBSHelp);
  While KeyPressed Do ReadKey;
  ReadKey;
  
  S^. Display;
  Dispose (S, Done);
End;

Procedure WinInfo (S: String; yyz: word);
Var
  Win: pWinOBJ;
Begin
  New (Win, Init);
  If Win = Nil Then Exit;
  With Win^ Do Begin
    SetSize (38 - (Length (S) Div 2), 10, 42 + (Length (S) Div 2), 14, 1);
    If Current = Waiting Then
      Screen^. EnableHighBgd
    Else
      SetColors ($17, $10, $17, $17, $10, $1F, $17);
    SetTitle (' Info ');
    SetClose (False);
    Draw;
    Screen^. WritePlain (2, 2, S);
    iDelay (yyz);
  End;
  Dispose (Win, Done);
  Screen^. DisableHighBgd
End;

Procedure DumpScreen;
Var
  Num: Word;
  F: Text;
Begin
  Num := Succ (GetFileCnt (NodeData. NodePath + 'Image.*'));

  If Num > 999 Then Num := 999;

  Assign (F, NodeData. NodePath + 'Image.' + IntToStr (Num));
  {$I-}
  SetFAttr (F, Archive);
  {$IFDEF Debug} {$I+} {$ENDIF}
  If IOResult <> 0 Then ;
  SaveANSi (True, NodeData. NodePath + 'Image.' + IntToStr (Num));
  Append (F);
  WriteLn (F, #27'[0m');
  Close (F);
End;

Procedure GetColor (X, Y: Byte; Var B: Byte);
Var
  I: Word;
  a, c: Byte;
Begin
  a := b Mod 16;
  c := b Div 16;
  send (attr (8));

  Repeat
    ComWriteAt (X + a, Pred (Y), '');
    ComWriteAt (X + c, Succ (Y), '');

    I := ReadArrow;
    if hung then break;
    Case I Of
      kCtlZ, kEnter, kSftQ, kQ: Break;
      kK, kSftK, kLeft:
                       Begin
                         ComWriteAt (X + a, Pred (Y), ' ');
                         If a = 0 Then
                           a := 15
                         Else
                           Dec (a);
                         ComWriteAt (X + a, Pred (Y), '');
                       End;
      kL, kSftL, kRight:
                        Begin
                          ComWriteAt (X + a, Pred (Y), ' ');
                          If a = 15 Then
                            a := 0
                          Else
                            Inc (a);
                          ComWriteAt (X + a, Pred (Y), '');
                        End;
      kZ, kSftZ, kUp:
                     Begin
                       ComWriteAt (X + c, Succ (Y), ' ');
                       If c = 7 Then
                         c := 0
                       Else
                         Inc (c);
                       ComWriteAt (X + c, Succ (Y), '');
                     End;
      kA, kSftA, kDown:
                       Begin
                         ComWriteAt (X + c, Succ (Y), ' ');
                         If c = 0 Then
                           c := 7
                         Else
                           Dec (c);
                         ComWriteAt (X + c, Succ (Y), '');
                       End;
    End;
  Until hung;
  ComWriteAt (X + a, Pred (Y), ' ');
  ComWriteAt (X + c, Succ (Y), ' ');
  b := c * 16 + a;
End;

Procedure WhyNotReg;
Var
  B: Byte;
Const
  S: String = 'Register System/75!';
Begin
  If Registered Then Exit;
  ComWrite ('|15');
  For B := 1 to Length (S) do Begin
    Send (S [B]);
    Delay (35);
  End;
  ComWriteln ('');
  iDelay (1000);
  if not localonly then Uart^. FlushInBuffer;
  Key^. FlushBuffer;
  PressEnter;
End;

Procedure Log (q: Byte; S: String);
var
  printer: text;
Begin {0 = no logging} {1 = average} {2 = maximum}
  case user. reclevel of
    0: if q <> 2 then exit;
    1: if q = 0 then exit;
  end;
  {$I-}
  WriteLn (LogFile, '  ', CurrentTime (False), '  ', S);
  If B (vToggles, 1) Then begin
    assign (printer, 'PRN');
    if ioresult <> 0 then exit;
    rewrite (printer);
    if ioresult <> 0 then exit;
    stripansi (S);
    WriteLn (printer, '  ', CurrentTime (False), '  ', s);
    if ioresult <> 0 then exit;
    close (printer);
  end;
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then ;
End;

Procedure GetIdles;
Var
  B: Byte;
Begin
  For B := 0 To 3 Do
    If Uc. Idles [Succ (B)]. Name <> '' Then
      Screen^. WriteAt (11, 20 + B, 15, PadLeft (Uc. Idles [Succ (B)]. Name, 12, ' '))
    Else
      Screen^. WriteAt (11, 20 + B, 8, 'Not used');
End;

Procedure SetMode (b: byte; rest: boolean);
var
  ss: pscreenobj;
  shit: xy;
Begin
  if rest then begin
    new (ss, init);
    ss^. save;
  end;

  if (currentmode = 43) and (b = 50) then LoadFont (uc. basepath + '25.fnt', 25);

  LoadFont (uc. basepath + inttostr (b) + '.fnt', b);
  Monitor^. vDepth := b;
  screen^. resetwindow;
  screen^. clear (8, ' ');

  if rest then begin
    ss^. partdisplay (1, 1, 80, 25, 1, 1);
    dispose (ss, done);
  end;

  shit. x := _x;
  shit. y := _y;
  SetScreenSize (1, 1, 80, pred (b));
  with shit do updatecursor (x, y);
  currentmode := b;
End;

Function makepw (New, askold: Boolean): pwstr;
Var
  check, pw: pwstr;
  n: datetimerec;
Begin
  now (n);
  If New Then Begin
    fillin1 := inttostr (uc. passwordchange);
    comwriteln (cs (62));
  End;

  If askold Then Begin
    check := '';
    ComWrite (Cs (61)); {Enter old password}
    GetPwStr (0, False, False, check);
    If hung Then Exit;
    ComWriteLn ('');
    If check <> setlower (user. pw) Then Exit;
  End;

  Repeat
    pw := '';
    check := '';

    ComWrite (Cs (47)); {Create a password}
    GetPwStr (0, False, False, pw);
    If hung Then Exit;
    ComWriteLn ('');
    If pw = '' Then Continue;
    If New And (pw = user. pw) Then Begin
      comwriteln (cs (63));
      Continue;
    End;

    If Length (pw) < uc. minpwsize Then Begin
      comwriteln (cs (98));
      Continue;
    End;

    ComWrite (Cs (48)); {Reenter password}
    GetPwStr (0, False, False, check);
    If hung Then Exit;
    ComWriteLn ('');

    If check <> pw Then
      ComWriteLn (Cs (49))
    Else
      Break;
  Until hung;
  makepw := pw;
  user. passwordchanged := n. d;
End;

  Function Prep (gooff, syspwrd: boolean; pr: string): Boolean;
  Var
    F: File Of SetRec;
  Begin
    Prep := False;
    Key^. AssignIdleHook (BBSIdle);
    Key^. AssignPressedHook (BBSPressed);
    BBS^. ResetBBSVars;
    InputTimer := False;
    vAllowChat := False;
    InitEmulation;

    If StatBar <> 0 then SetScreenSize (1, 1, 80, 24);

    if gooff then begin
      DetectedEmu := [TermTTY, TermANS, TermAVT, TermRIP];
      HighestEmu := TermAVT;
      LoadSysopRec (false, User);
    end else begin
      defuser;
      DetectedEmu := [TermTTY, TermANS];
      HighestEmu := TermANS;
    end;

    Current := Board;
    Clock^. Show (False);
    Screen^. Clear (7, ' ');
    UpdateCursor (1, 1);
    Screen^. CursOn;
    AddCaller := False;
    makelogfile;

    Assign (F, Uc. DataPath + 'MenuSet.Dat');
    {$I-}
    Reset (F);
    {$IFDEF DEBUG}{$I+}{$ENDIF}
    if ioresult = 0 then begin
      Seek (F, Pred (User. MenuSet));
      Read (F, CurMenuSet);
      Close (F);
    end else begin
      curmenuset. name := 'Invalid menu set specified';
      curmenuset. path := uc. disppath;
    end;

    Assign (F, Uc. DataPath + 'StatSet.Dat');
    {$I-}
    Reset (F);
    {$IFDEF DEBUG}{$I+}{$ENDIF}
    if ioresult = 0 then begin
      Seek (F, Pred (User. StatSet));
      Read (F, CurStatSet);
      Close (F);
    end else begin
      curmenuset. name := 'Invalid menu set specified';
      curmenuset. path := uc. disppath;
    end;

    if pr <> '' then begin
      fillin1 := pr;
      pfile ('hdr.ans');
      comwriteln ('');
    end;

    newstatbar := true;
    ShowStatus;

    If Syspwrd And B (Uc. Options, LocalSec) And Not GetSysopPw (False) Then Exit;
    if gooff then WhyNotReg;

    If not localonly and not uart^. checkdcd and gooff and not GoOffHook (False) Then Exit;
    If not Hung Then Prep := True;

    new (vbatch, init);
    new (ubatch, init);
    fillchar (batch, sizeof (batch), 0);

    AllowScrSav (False);
  End;

Procedure DeleteOldLogs;
Var
  f: File;
  b: Byte;
  dirinfo: SearchRec;
Begin
  If uc. backsysoplogs = 0 Then Exit;
  deletefile (nodedata. nodepath + 'Log.' + IntToStr (uc. backsysoplogs));
  For b := Pred (uc. backsysoplogs) Downto 0 Do Begin
    If b = 0 Then
      Assign (f, nodedata. nodepath + 'Log.')
    Else
      Assign (f, nodedata. nodepath + 'Log.' + IntToStr (b));
    {$I-}
    Reset (f);
    {$IFDEF Debug} {$I+} {$ENDIF}
    If IOResult <> 0 Then Continue;
    Close (f);
    If b = 0 Then
      Rename (f, nodedata. nodepath + 'Log.1')
    Else
      Rename (f, nodedata. nodepath + 'Log.' + IntToStr (Succ (b)));
  End;
End;

Procedure makelogfile;
Begin
  Assign (LogFile, NodeData. NodePath + 'ThisCall.Log');
  Rewrite (LogFile);
End;

Procedure showlogs;
Var
  b: byte;
  nd: byte;
  lui: byte;
  s: String [3];
Begin
  Log (2, 'Displayed sysop logs');

  comwrite ('|URHow many days back |UP[|US0|UP]: |UI');
  lui := getnumstr (False, False, 0, uc. backsysoplogs, 0, uc. backsysoplogs, 0, 0);
  If hung Then Exit;
  comwriteln ('');

  if uc. numnodes <> 1 then begin
    comwrite ('|URView which node|UP[|US' + inttostr (nodenumber) + '|UP]: |UI');
    nd := getnumstr (False, False, 0, uc. numnodes, 0, uc. numnodes, nodenumber, 0);
    if hung Then Exit;
    comwriteln ('');
  end;

  if uselog then Close (logfile);
  usercol (1);

  for b := lui downto 0 do begin
    if b = 0 then
      s := ''
    else
      s := inttostr (b);

    ComWriteLn ('');
    TTYPauser := 1;
    if Exist (NodeData. NodePath + 'Log.' + S) then
      ShowFile (NodeData. NodePath + 'Log.' + S, True, True)
    else
      ComWriteln ('That log doesn''t exist now.');

    ComWriteLn ('');
    if (b <> 0) then if more (false) = mno then begin
      exit;
      if uselog then append (logfile);
    end;
  end;

  if uselog then Append (logfile);
  PressEnter;
End;

    Procedure OpeningScreen;
    Begin
      InitFade;
      If ExDispMode Then FadeOut (3);

      showwfc;
      Status ('Loading');

      If ExDispMode Then Begin
        setmode (25, true);
        Screen^. CursOff;
        FadeIn (2);
      End;
    End;

    procedure showwfc;
    begin
      Screen^. CursOff;
      Screen^. Clear (0, ' ');
      ShowScreen (Wfc);
      ShowWfcCommands;
    end;

    Procedure ParseParams;

      Procedure ShowHelp;
      Begin
        Screen^. Clear (7, ' ');
        ShowScreen (Spuds. Help);
        Screen^. GotoXY (1, 23);
        Halter (0);
      End;

    Var
      B, QT, Num: Byte;
      S: String;
    Begin
      Num := ParamCount;
      If Num = 0 Then Exit;
      B := 1;
      While B <= Num Do Begin
        S := SetUpper (ParamStr (B));
        If S [1] In ['/', '-'] Then Delete (S, 1, 1);
        Case S [1] Of
          'N': Begin
                 While (S [1] In ['A'..'Z']) And (S [0] > #0) do
                   Delete (S, 1, 1);

                 If S = '' Then Begin
                   Inc (B);
                   If B > Num Then ShowHelp;
                   S := ParamStr (B);
                 End;
                 NodeNumber := StrToInt (S);
               End;
          'B': Begin
                 While (S [1] In ['A'..'Z']) And (S [0] > #0) do
                   Delete (S, 1, 1);

                 If S = '' Then Begin
                   Inc (B);
                   If B > Num Then ShowHelp;
                   S := ParamStr (B);
                 End;
                 BaudRate := StrToInt (S);
                 FrontEnd := True;
               End;
          'P': Begin
                 While (S [1] In ['A'..'Z']) And (S [0] > #0) do
                   Delete (S, 1, 1);

                 If S = '' Then Begin
                   Inc (B);
                   If B > Num Then ShowHelp;
                   S := ParamStr (B);
                 End;
                 AltPort := StrToInt (S);
               End;
          'A': Begin
                 Inc (B);
                 If B > Num Then ShowHelp;
                 AltConfig := ParamStr (B);
               End;
          'O': ExitNoDrop := True;
          'E': EventsForced := True;
          'C': ConfigMe := True;
          'L': DosSysAuto := True;
          'M': mEditor := True;
          'U': uEditor := True;
          'S': tEditor := True;
          Else ShowHelp;
        End;
        Inc (B);
      End;
    End;

    Procedure MultiTask;
    Begin
      Case MultiTasker of
        DesqView:ComWriteLn ('|08desqview detected');
        Windows: ComWriteLn ('|08windoze detected');
        DoubleDos: ComWriteLn ('|08double-dos detected');
        OS2: ComWriteLn ('|08os/2 detected');
        NetWare: ComWriteLn ('|08netware detected');
        NoTasker:
             Begin
               ComWriteLn ('|08using dos ' + IntToStr (Lo (DosVersion)) + '.' +
               IntToStr (Hi (DosVersion)));
             End;
      End;

      Screen^. vScreenPtr := Ptr (VideoSeg, VideoOfs);
      SegB800 := VideoSeg;
      Screen^. oWritePtr^. SetScreen (Screen^. vScreenPtr, 80);
    End;

    Procedure ActParams;
    Begin
      If not dossysauto and not mEditor and not uEditor and not tEditor Then exit;

      localonly := true;
      prep (false, b (uc. options, localsec), '');
      loadsysoprec (true, user);
      user. options := user. options + [timelock];

      If mEditor Then MenuEditor
      Else If uEditor Then UserEditor ('')
      Else If tEditor Then StringsEditor
      Else exit;

      If currentmode <> 25 Then Setmode (25, false);
      InitEmulation;

      If DosSav <> Nil Then begin
        DosSav^. Display;
        Dispose (DosSav, Done);
      end;

      Screen^. CursOff;
      WriteCreds;
      PrepClose;
      CloseTot;
      Halter (0);
    End;

    Procedure Registration (Show: Boolean);
    Var
      F: File;
      C2: Integer;
    Begin
      Registered := False;

      If OpenFile ('Sys75.Reg', F) Then Begin
        {$I-}
        BlockRead (F, RegRec, SizeOf (RegRec), C2);
        {$IFDEF Debug} {$I+} {$ENDIF}
        Close (F);
        If C2 <> SizeOf (RegRec) Then Begin
          TextMode (CO80);
          Writeln ('Invalid or hacked registration code.');
          Writeln ('If you have legitimately registered ');
          Writeln ('this copy, read DOX\BUGS.DOX and fill');
          Writeln ('out & send in a big report.');
          Writeln ('');
          Halter (10);
        End;

        If CheckRegCode = Reged Then Begin
          Registered := True;
          Uc. SysopName := RegRec. Name;
          Uc. BoardName := RegRec. BBS;
          Uc. PhoneNumber := RegRec. Phone;
          MaxUsers := rMaxUsers;
        End;
      End;

      If Show Then
        If Registered Then
          ComWriteln ('|08registered to ' + Uc. SysopName)
        Else Begin
{          Screen^. Write ('|08');
          WackRightStr ('register System/75!');
          Screen^. Writeln ('');
          Delay (500);}
          Screen^. Writeln ('');
          Screen^. Write   ('|15This eta Copy is not for you, chump.');
          Screen^. Writeln ('');
          PrepClose;
          CloseTot;
          Halt (0);
        End;
    End;

    Procedure InitVars;
    Begin
      SetCBreak (False);
      ShadowTot^. SetShadowStyle (DownRight, 8, ' ');
      IoTot^. SetColButton ($78, $71, $F8, $F9);
      Randomize;
      AllowIdle := True;
      Modem  := Nil;
      Uart   := Nil;
      Proto  := Nil;
      Clock  := Nil;
      Scroll := Nil;
      BBS    := Nil;
      Term   := Nil;
      HighestEmu := TermAVT;
      DetectedEmu := [TermTTY, TermANS, TermAVT, TermRIP];
      InitEmuVars;
      DefUser;
      Screen^. Wherexy (_x, _y);
      StatScrPtr := Screen;
      InsertMode := True;
    End;

    Procedure SaveBoardData;
    Var
      F: File;
    Begin
      Assign (F, NodeData. NodePath + 'NodeData.Dat');
      Rewrite (F, 1);
      BlockWrite (F, MiscNodeData, SizeOf (MiscNodeData));
      Close (F);

      Assign (F, Uc. DataPath + 'Totals.Dat');
      Rewrite (F, 1);
      BlockWrite (F, Totals, SizeOf (Totals));
      Close (F);

      UpdateDailyLog (False);

      Assign (F, NodeData. NodePath + 'EventRun.Dat');
      Rewrite (F, 1);
      BlockWrite (F, Event^. er, Sizeof (Event^. er));
      Close (F);
    End;

    procedure moreinits;
    begin
      New (Clock, Init);
      If Clock = Nil Then Halt (ecOutOfMemory);
      New (Event, Init);
      If Event = Nil Then Halt (ecOutOfMemory);
      New (Proto, Init);
      If Proto = Nil Then Halt (ecOutOfMemory);

      New (Term, Init);
      If Term = Nil Then Halt (ecOutOfMemory);
      New (BBS, Init);
      If BBS = Nil Then Halt (ecOutOfMemory);

      InitScrSav;
      AllowScrSav (True);
    end;

    procedure evenmoreinits;
    var
      n: datetimerec;
    begin
      now (n);
      New (Scroll, Init (Uc. ScrollBackLines));
      If Scroll = Nil Then Halt (ecOutOfMemory);
      if uc. defstatbar > maxstatbar then uc. defstatbar := 1;
      Today := N. d;
      if not localonly then Uart^. SetWaitCharProc (WaitAP);
      vbatch := nil;
      ubatch := nil;
    end;

    Procedure ClosingScreen;
    Begin
      Key^. AssignIdleHook (NoInputIdlehook);
      If ExDispMode And not dossysauto and (forceexit = 0) Then FadeOut (2);
      Screen^. Clear (0, ' ');
      Screen^. CursOff;

      Crt. Window (1, 1, 80, 25);

      If Registered Then Begin
        If DosSav <> Nil Then DosSav^. Display;
        Screen^. CursOff;
        If DosSav <> Nil Then Dispose (DosSav, Done);
        WriteCreds;
      End Else Begin
        Screen^. Clear (7, ' ');
        ShowScreen (Add);
        Screen^. CursOff;
        Screen^. GotoXY (1, 23);
      End;

      TextAttr := 7;
      Write (#10);
      ClrEol;

      If ExDispMode Then Begin
        LoadFont ('Dos.Fnt', 25);
        Screen^. CursOff;
        If not dossysauto and (forceexit = 0) Then FadeIn (2);
      End;
    End;

    Procedure PrepClose;
    Var
      T: Text;
    Begin
      If (Uart <> Nil) and (Uart^. CheckDCD) Then Uart^. ptOptionsOff (ptRestoreOnClose + ptDropModemOnClose);

      {$IFDEF EventLogging}
      DumpEvents ('D:\PAS\SYS75\EVENTS.LOG');
      {$ENDIF}

      If Proto <> Nil Then Dispose (Proto, Done);
      If Clock <> Nil Then Dispose (Clock, Done);
      If Scroll <> Nil Then Dispose (Scroll, Done);
      If BBS <> Nil Then Dispose (BBS, Done);
      If Term <> Nil Then Dispose (Term, Done);
      If Modem <> Nil Then Dispose (Modem, Done);
      If Uart <> Nil Then Dispose (Uart, Done);

      Assign (T, NodeData. NodePath + 'Node_Is.Up');
      {$I-}
      SetFAttr (T, Archive);
      Erase (T);
      {$IFDEF Debug}{$I+}{$ENDIF}
      if ioresult <> 0 then;

      TextAttr := 7;
      Screen^. CursOn;
    End;

Procedure ShowScreen (B: Byte);
Var
  F: File;
  l: LongInt;
Begin
  Assign (f, uc. basepath + 'screens.dat');
  l := b;
  l := l * 4000;
  {$I-}
  Reset (f, 1);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IOResult <> 0 Then begin
    Assign (f, 'screens.dat');
    {$I-}
    Reset (f, 1);
    {$IFDEF Debug}{$I+}{$ENDIF}
    If IOResult <> 0 Then Exit;
  end;
  Seek (f, l);
  If screen^. screenptr <> Nil Then
    BlockRead (f, mem [Seg (screen^. screenptr^): Ofs (Screen^. ScreenPtr^)], 4000)
  Else
    BlockRead (f, mem [SegB800: 0], 4000);
  Close (f);
End;

Procedure writecreds;
Begin
  Screen^. WriteLn ('');
  Screen^. WriteLn ('     |09C|01oding: |15m|07a|08xwell|15|08m|15i|08st');
  Screen^. WriteLn ('   |09m|01uch |09t|01hanks |092 |15w|07in|08ter|07m|08ute');
  Screen^. WriteLn ('  |09C|01opyright (|09c|01) |09J|01anuary |091|01995');
  Screen^. WriteLn ('   |09b|01y |08m|15i|08st |01& |15s|07p|08ectre |15c|07o|08ding');
  Screen^. WriteLn ('     |09A|01ll |09r|01ites |09p|01reserved|09!');
End;

Procedure bbsshell;
var
  saveit: axy;
Begin
  if not scrbackrunnin then begin
    GetAxy (SaveIt);
    SaveANSi (False, NodeData. TempPath + 'SwapSave.Tmp');
    ComWriteLn (#10#13 + Cs (16)); {Shelled to DOS}
  end;

  DosShell (scrbackrunnin);

  if statbar <> 0 then begin
    NewStatBar := True;
    ShowStatus;
  end;

  if not scrbackrunnin then begin
    ReallyUnabortable := True;
    ShowFile (NodeData. TempPath + 'SwapSave.Tmp', False, False);
    PutAxy (SaveIt);
    DeleteFile (NodeData. TempPath + 'SwapSave.Tmp');
  end;
End;

Procedure bbstexttrap;
Begin
  If TextTrap Then Begin
    WriteLn (TrapFile, ^['[0m');
    Close (TrapFile);
    TextTrap := False;
  End Else Begin
    TextTrap := True;
    Assign (TrapFile, NodeData. NodePath + 'TextTrap.' +
    IntToStr (Succ (GetFileCnt (NodeData. NodePath + 'TextTrap.*'))));
    {$I-}
    SetFAttr (TrapFile, Archive);
    {$IFDEF Debug} {$I+} {$ENDIF}
    Rewrite (TrapFile);
    WriteLn (TrapFile, AnsA (15, textattr) + ' ***  Text Trap File of user ' + AnsA (9, textattr) +
    User. Handle + AnsA (15, textattr) + ', started at ' + AnsA (9, textattr) + CurrentTime (True) + AnsA (15, textattr)
    + ' on ' + AnsA (9, textattr) + CurrentDate (True) + AnsA (15, textattr) + '.' + AnsA (7, textattr));
    WriteLn (TrapFile);
  End;
  ShowStatus;
End;

function ascii: char;
var
  sp: pscreenobj;
  saved: axy;
  o: word;
  b: byte;
begin
  if current = other then begin
    new (sp, init);
    sp^. save;
  end else begin
    getaxy (saved);
    saveansi (false, nodedata. temppath + 'ASCiiSAV.TMP');
  end;

  send (goxy (1, 1) + attr (user. cols [6]));
  for b := 1 to 10 do
    comwriteln (clr2eol);
  box (1, 1, 79, 10, user. cols [6]);
  Comwriteat (26, 2, '|15S|07ys|08tem|15/|077|085 |15B|07B|08S ASC|07ii |08Chart|UR');

  send (goxy (4, 4));
  for b := 33 to 69 do
    send (chr (b) + ' ');
  send (goxy (4, 5));
  for b := 70 to 106 do
    send (chr (b) + ' ');
  send (goxy (4, 6));
  for b := 107 to 143 do
    send (chr (b) + ' ');
  send (goxy (4, 7));
  for b := 144 to 180 do
    send (chr (b) + ' ');
  send (goxy (4, 8));
  for b := 181 to 217 do
    send (chr (b) + ' ');
  send (goxy (4, 9));
  for b := 218 to 254 do
    send (chr (b) + ' ');

  send (goxy (4, 4));
  b := 33;

  repeat
    o := readarrow;
    if hung then break;
    case o of
      kenter: break;
      kleft: if b = 33 then
             else if _x = 4 then begin
               dec (b);
               send (goxy (76, pred (_y)));
             end else begin
               dec (b);
               send (clt + clt);
             end;
      kright: if b = 254 then
              else if _x = 76 then begin
                inc (b);
                send (goxy (4, succ (_y)));
              end else begin
                inc (b);
                send (crit + crit);
              end;
      kup: if _y = 4 then
           else begin
             dec (b, 37);
             send (goxy (_x, pred (_y)));
           end;
      kdown: if _y = 9 then
             else begin
               inc (b, 37);
               send (goxy (_x, succ (_y)));
             end;
       kesc: begin
               b := 0;
               break;
             end;
    end;
  until hung;

  if current <> other then begin
    NewStatBar := True;
    ShowStatus;
    ReallyUnabortable := True;
    if not hung then ShowFile (nodedata. temppath + 'ASCiiSAV.TMP', False, False);
    PutAxy (Saved);
    DeleteFile (nodedata. temppath + 'ASCiiSAV.TMP');
  end else begin
    sp^. display;
    dispose (sp, done);
  end;
  ascii := chr (b);
end;

function findbottomline: byte;
var
  y, x: byte;
  b: boolean;
begin
  b := false;
  for y := pred (sy2) downto pred (sy1) do begin
    for x := 0 to 79 do
      if not (mem [seg (screen^. screenptr^):Ofs (Screen^. ScreenPtr^) + y shl 7 + y shl 5 + x shl 1] in [0,32,255]) then begin
        b := true;
        break;
       end;
    if b then break;
  end;
  if b then
    findbottomline := succ (y)
  else
    findbottomline := sy1;
end;

procedure gotomenu;
var
  s: string;
begin
  ComWrite ('|UR%CRWhich menu to run|UP: |UI');
  S := '';
  GetStr (8, False, False, S);
  S := Strip ('B', ' ', S);
  If Hung or (S = '') Then Exit;
  ComWriteln ('');
  BBS^. Startup;
  LoadSysopRec (false, User);
  Log (2, 'Loaded menu "' + s + '" from WFC');
  RunMenus (S);
  BBS^. Closeup;
end;

procedure showtoggles;
Const
  qwe: Array [False..True] Of Byte = (8, 15);
begin
  Screen^. WriteAt (38, 20, qwe [B (vToggles, 1)], 'Printer');
  Screen^. WriteAt (38, 21, qwe [B (vToggles, 8)], 'Available');
  Screen^. WriteAt (38, 22, qwe [B (vToggles, 4)], 'Speaker');
  Screen^. WriteAt (38, 23, qwe [B (vToggles, 2)], 'Custom');
end;

  Procedure DoEach (Var S: String; S2: str30; ndos: boolean);
  Var
    once: boolean;
  Begin
    once := false;
    Repeat
      if s [length (s)] = '\' then dec (s [0]);
      if existdir (s) then break;

      if ndos then begin
        comwriteln ('');
        ComWriteln ('|US ' + S + '|UR does not exist.' + Clr2Eol);
        ComWrite ('|UP Create it ' + Clr2Eol);
      end else begin
        ComWriteAt (4, 22, '|US' + S + '|UR does not exist.' + Clr2Eol);
        ComWriteAt (4, 23, '|UPCreate it ' + Clr2Eol);
      end;
      If LiteBar (lbYes, False, false) = lbYes Then Begin
        If hung Then Break;
        {$I-}
        MkDir (S);
        {$IFDEF Debug}{$I+}{$ENDIF}
        If IoResult <> 0 Then Begin
          if ndos then
            ComWrite (^M'|04 Could not create directory|08.' + Clr2Eol)
          else
            ComWriteAt (4, 23, '|04Could not create directory|08.' + Clr2Eol);
          if ndos then iDelay (500);
        End;
      End Else Begin
        If hung Then Break;
        once := ndos;
        if ndos then begin
          UpdateCursor (1, Pred (_y));
          ComWriteLn ('|UR Enter a valid ' +  S2 + ' directory now' + Clr2Eol);
          ComWrite ('|UP : |UI' + Clr2Eol);
        end else begin
          ComWriteAt (4, 22, '|UREnter a valid ' +  S2 + ' directory now' + Clr2Eol);
          ComWriteAt (4, 23, '|UP: |UI' + Clr2Eol);
        end;
        GetCapStr (44, 'A', False, false, S);
        If hung Then Break;
      End;
    Until False;
    s := s + '\';
    if once then comwriteln ('');
    if not ndos then begin
      send (goxy (4, 22) + attr (8) + Clr2Eol);
      send (goxy (4, 23) + Clr2Eol);
    end;
  End;

  Procedure ValPaths (var uc2: configtype; var nd2: nodedatatype; Big: Boolean; ndos: boolean);
  Begin
    If Big Then Begin
      DoEach (UC2. BasePath, 'System/75', ndos);
      If hung Then Exit;
      DoEach (UC2. DataPath, 'data', ndos);
      If hung Then Exit;
      DoEach (UC2. NtMlPath, 'net mail', ndos);
      If hung Then Exit;
      DoEach (UC2. FlAtPath, 'file attach', ndos);
      If hung Then Exit;
      DoEach (UC2. MenuPath, 'menu', ndos);
      If hung Then Exit;
      DoEach (UC2. ScrpPath, 'script', ndos);
      If hung Then Exit;
      DoEach (UC2. BordPath, 'board data', ndos);
      If hung Then Exit;
      DoEach (UC2. FilePath, 'file data', ndos);
      If hung Then Exit;
      DoEach (UC2. BadPath,  'bad upload', ndos);
      If hung Then Exit;
      DoEach (UC2. DoorPath, 'door', ndos);
      If hung Then Exit;
      DoEach (UC2. DispPath, 'display file', ndos);
      If hung Then Exit;
      DoEach (UC2. TmUlPath, 'terminal upload', ndos);
      If hung Then Exit;
      DoEach (UC2. TmDlPath, 'terminal download', ndos);
      If hung Then Exit;
      DoEach (UC2. HelpPath, 'help file download', ndos);
      If hung Then Exit;
    End Else Begin
      DoEach (ND2. NodePath, 'node data', ndos);
      If hung Then Exit;
      DoEach (ND2. TempPath, 'temp file', ndos);
      If hung Then Exit;
    End;
  End;

procedure newday;
var
  n: datetimerec;
begin
  UpdateDailyLog (True);
  DisplayLocalStats;
  Close (LogFile);
  DeleteOldLogs;
  MakeLogFile;
  RemDatedBlacks;
  now (n);
  Today := N. d;
end;

Function parsepath (S: PathStr): PathStr;
var
  b: byte;
Begin
  b := 1;
  while b <= length (s) do begin
    if (s [b] = '%') and (b < length (s)) and (ucase (s [succ (b)]) = 'N') then begin
      delete (s, b, 2);
      insert (inttostr (nodenumber), s, b);
    end;
    inc (b);
  end;
  parsepath := s;
End;

function runcomm (exeparams: string; s2: str40; swap, forcedos: boolean): byte;
Var
  SS              : ^ScreenObj;
  SwapIt, RetVal  : Integer;
  T, Said         : Byte;
  exe: string [12];
Begin
  T := TextAttr;
  TextAttr := 7;
  {$I-}
  Close (LogFile);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then ;
  New (SS, Init);
  SS^. Save;

  Screen^. Clear (7, ' ');
  Window (1, 1, 80, 25);
  Screen^. WriteLn (Block + ' |15S|07ys|08tem/|157|075 ' + S2 + ' ' + Block);
  Screen^. WriteLn ('');
  Screen^. WriteLn ('|08Program    : |07' + copy (exeparams, 1, pred (pos (' ', exeparams))));
  Screen^. WriteLn ('|08Parameters : |07');
  Screen^. WriteLn (copy (exeparams, succ (pos (' ', exeparams)), 255));
  Screen^. WriteLn ('|08Free memory: |07' + inttostr (memavail));

  exe := setupper (copy (exeparams, 1, pred (pos (' ', exeparams))));
  delete (exeparams, 1, pos (' ', exeparams));

  If Swap Then Begin
    Screen^. WriteLn ('|08Swapping out of memory...');
    If B (Uc. Options, UseEMS) And B (Uc. Options, UseXMS) Then
      SwapIt := Swap_All
    Else If B (Uc. Options, UseEMS) Then
      SwapIt := Swap_Ems
    Else If B (Uc. Options, UseXMS) Then
      SwapIt := Swap_Xms
    Else
      SwapIt := Swap_Disk;

    Init_Spawno (NodeData. TempPath, SwapIt, 20, 0);
    Screen^. WriteLn ('');
    if forcedos or (pos ('.BAT', exe) <> 0) then
      RetVal := Spawn (GetEnv ('COMSPEC'), '/C ' + exe + ' ' + ExeParams, 0)
    else
      RetVal := Spawn (exe, ExeParams, 0);
    Said := Lo (RetVal);
  End Else Begin
    Screen^. WriteLn ('');
    if forcedos or (pos ('.BAT', exe) <> 0) then
      DOS. Exec (GetEnv ('COMSPEC'), '/C ' + exe + ' ' + ExeParams)
    else
      DOS. Exec (exe, ExeParams);
    Said := DosExitCode;
  End;

  Screen^. Clear (7, ' ');
  Setmode (currentmode, false);

  If statbar = 0 Then
    SetScreenSize (1, 1, 80, currentmode)
  Else begin
    SetScreenSize (1, 1, 80, pred (currentmode));
    newstatbar := true;
    showstatus;
  end;

  SS^. Display;
  Dispose (SS, Done);
  with screen^ do
    updatecursor (wherex, wherey);

  TextAttr := T;
  {$I-}
  Append (LogFile);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then ;
  RunComm := Said;
end;

procedure copylogs;
type
  buftype = array [0..20479] of byte;
var
  t: text;
  rin: word;
  i, o: file;
  buf: ^buftype;
  sdfsdg: longint;
begin
  {$I-}
  writeln (logfile);
  close (logfile);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then;

  getmem (buf, sizeof (buftype));

  assign (t, nodedata. nodepath + 'Log.tmp');
  rewrite (t);
  writeln (t, '                             Sysop Log for ' + datestr (today));
  WriteLn (t);
  close (t);

  assign (o, nodedata. nodepath + 'log.tmp');
  reset (o, 1);
  sdfsdg := filesize (o);
  seek (o, sdfsdg);

  assign (i, nodedata. nodepath + 'thiscall.log');
  {$I-}
  reset (i, 1);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult = 0 then begin
    repeat
      blockread (i, buf^, sizeof (buftype), rin);
      blockwrite (o, buf^, rin);
    until rin <> sizeof (buftype);
    close (i);
    erase (i);
  end;

  assign (i, nodedata. nodepath + 'log.');
  {$I-}
  reset (i, 1);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult = 0 then begin
    seek (i, sdfsdg);
    repeat
      blockread (i, buf^, sizeof (buftype), rin);
      blockwrite (o, buf^, rin);
    until rin <> sizeof (buftype);
    close (i);
    erase (i);
  end;

  close (o);

  {$I-}
  rename (o, nodedata. nodepath + 'log.');
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then ;

  freemem (buf, sizeof (buftype));
end;

function dszlogstr (s: string; var dsz: dszrec): boolean;
begin
  dszlogstr := true;
  fillchar (dsz, sizeof (dsz), 0);
  with dsz do begin
    stat := s [1];

    delete (s, 1, pred (pos (' ', s)));
    s := strip ('L', ' ', s);
    size := strtoint (copy (s, 1, pred (pos (' ', s))));

    delete (s, 1, pred (pos (' ', s)));
    s := strip ('L', ' ', s);
    connect := strtoint (copy (s, 1, pred (pos (' ', s))));
    delete (s, 1, pred (pos (' ', s)));
    s := strip ('L', ' ', s);

    delete (s, 1, pred (pos (' ', s)));
    s := strip ('L', ' ', s);
    avcps := strtoint (copy (s, 1, pred (pos (' ', s))));
    delete (s, 1, pred (pos (' ', s)));
    s := strip ('L', ' ', s);

    delete (s, 1, pred (pos (' ', s)));
    s := strip ('L', ' ', s);
    errcnt := strtoint (copy (s, 1, pred (pos (' ', s))));
    delete (s, 1, pred (pos (' ', s)));
    s := strip ('L', ' ', s);

    delete (s, 1, pred (pos (' ', s)));
    s := strip ('L', ' ', s);
    flcnt := strtoint (copy (s, 1, pred (pos (' ', s))));

    delete (s, 1, pred (pos (' ', s)));
    s := strip ('L', ' ', s);
    block := strtoint (copy (s, 1, pred (pos (' ', s))));

    delete (s, 1, pred (pos (' ', s)));
    s := strip ('L', ' ', s);
    name := setupper (copy (s, 1, pred (pos (' ', s))));

    delete (s, 1, pred (pos (' ', s)));
    s := strip ('L', ' ', s);
    serno := strtoint (copy (s, 1, 255));
  end;
end;

procedure stripansi (var s: string);
var
  b: byte;
begin
  b := 1;
  while b <= length (s) do begin
    case s [b] of
      ^V,^L,^M,^J,^G,^H:
        begin
          dec (b);
          delete (s, b, 1);
        end;
      ^[:
        begin
          delete (s, b, 1);
          if s [b] = '[' then begin
            repeat
              delete (s, b, 1);
              if (pos (s [b], ';?1234567890=') = 0) or (b = length (s)) then break;
            until (b = length (s)) or (pos (s [b], 'mfHABCDJLMP@KnlhsuSz') <> 0);
            delete (s, b, 1);
          end;
          dec (b);
        end;
    end;
    inc (b);
  end;
end;

procedure notice (w: word; s: string);
var
  t: text;
begin
  assign (t, uc. datapath + 'usr' + inttostr (w) + '.not');
  {$i-}
  append (t);
  {$ifdef debug}{$I+}{$endif}
  if ioresult <> 0 then rewrite (t);
  writeln (t, '|UR' + currentdate (false) + ' |US' + currenttime (false) + '|UR  ' + s);
  close (t);
end;

var
  f: file of str30;
  s: str30;

function choicehook (ch: word): boolean;
var
  sp: pscreenobj;
  saveit: axy;
begin
  choicehook := false;

  if ch = 28 then
    choicehook := true
  else if ch = 27 then begin
    if current <> other then begin
      getaxy (saveit);
      saveansi (false, nodedata. temppath + 'flaghelp.tmp');
    end else begin
      new (sp, init);
      sp^. save;
    end;
    send (cls);

    TTYPauser := 1;
    if current = other then
      ShowFile (uc2^. HelpPath + 'acs.hlp', true, true)
    else
      ShowFile (uc. HelpPath + 'acs.hlp', true, true);

    pressenter;

    if current = other then begin
      sp^. display;
      dispose (sp, done);
    end else begin
      ReallyUnabortable := True;
      NewStatBar := True;
      ShowStatus;
      ShowFile (nodedata. temppath + 'flaghelp.Tmp', False, False);
      PutAxy (SaveIt);
      DeleteFile (nodedata. temppath + 'flaghelp.Tmp');
    end;
  end else if ch < 14 then begin
    seek (f, pred (ch));
    read (f, s);
    send (goxy (9, ch + 4));
    usercol (4);
    getstr (30, false, false, s);
    usercol (1);
    seek (f, pred (ch));
    write (f, s);
    send (goxy (9, ch + 4));
    comwrite (padleft (s, 30, ' '));
    if hung then choicehook := true;
  end else begin
    seek (f, pred (ch));
    read (f, s);
    send (goxy (48, ch - 9));
    usercol (4);
    getstr (30, false, false, s);
    usercol (1);
    seek (f, pred (ch));
    write (f, s);
    send (goxy (48, ch - 9));
    comwrite (padleft (s, 30, ' '));
    if hung then choicehook := true;
  end;
end;

procedure flagedit;
var
  b: byte;
  sp: pscreenobj;
  saveit: axy;
  mainmenu: pdMenu;
  path: dirstr;
begin
  if current = other then begin
    new (sp, init);
    sp^. save;
  end else begin
    getaxy (saveit);
    saveansi (false, nodedata. temppath + 'flagedit.tmp');
  end;

  if current = other then begin
    valpaths (uc2^, nd2^, true, false);
    user. cols := uc. colors;
    path := uc2^. datapath;
  end else
    path := uc. datapath;

  ComWrite ('|UB%CS');
  Box (1, 1, 79, 20, User. Cols [6]);
  ComWriteAt (29,1, ' [|15access flag editor|UB] ');
  ComWriteAt (3, 3, '|USflag  description');
  ComWriteAt (42,3, 'flag  description');
  ComWriteAt (16, 19,'|08[        ]');
  ComWriteAt (54, 19,'|08[        ]');

  For B := 5 To 17 Do begin
    ComWriteAt (7, B, ':');
    ComWriteAt (40,B, '');
    ComWriteAt (46, B, ':');
  end;

  usercol (4);

  new (mainmenu, init);
  mainmenu^. SetChoiceProc (ChoiceHook);

  with mainmenu^ do For B := 5 to 17 do
    AddChoice (3, b, ' ' + ucase (flagset [b - 4]) + ' ');

  with mainmenu^ do For B := 5 to 17 do
    AddChoice (42, b, ' ' + ucase (flagset [b + 9]) + ' ');

  mainmenu^. AddChoice (18,19, ' help ');
  mainmenu^. AddChoice (56,19, ' done ');

  assign (f, path + 'flagdesc.dat');
  {$I-}
  reset (f);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then begin
    rewrite (f);
    s := '';
    for b := 1 to 26 do
      write (f, s);
    seek (f, 0);
  end;

  usercol (1);

  for b := 5 to 17 do begin
    read (f, s);
    comwriteat (9, b, s);
  end;

  for b := 5 to 17 do begin
    read (f, s);
    comwriteat (48, b, s);
  end;

  mainmenu^. run;
  dispose (mainmenu, done);

  close (f);

  if current <> other then begin
    NewStatBar := True;
    ShowStatus;
    ReallyUnabortable := True;
    if not hung then ShowFile (nodedata. temppath + 'flagedit.Tmp', False, False);
    PutAxy (SaveIt);
    DeleteFile (nodedata. temppath + 'flagedit.Tmp');
  end else begin
    sp^. display;
    dispose (sp, done);
  end;
end;

function movefile (from, tto: pathstr): shortint;
{Retcodes:     0 file moved
               1 file not found
               2 move failed
}
var
  x: shortint;
  w: word;
  l: longint;
begin
  from := fexpand (from);
  tto  := fexpand (tto );
  if (from [1] = tto [1]) and spuds. b (uc. options, allowfat) then
    movefile := renamefile (from, tto)
  else begin
    x := copyfile (from, tto);
    movefile := x;
    if x <> 0 then exit;

    w := getfileattr (from);
    l := getfiletime (from);
    setfileattr (from, 0);
    if w <> $FFFF then setfileattr (tto, w);
    if l <> $FFFFFFFF then setfiletime (tto, l);

    x := deletefile (from);
    movefile := x;
    if x <> 0 then exit;
  end;
end;

procedure editmbases;
var
  lui,
  wow: byte;
  cf: file of confrec;
  cr: confrec;

  procedure minilist;
  var
    b: byte;
  begin
    fillin1 := 'Message Conferences';
    pfile ('hdr.ans');
    send (^M^J);
    seek (cf, 0);
    b := 1;
    while not eof (cf) do begin
      read (cf, cr);
      comwriteln ('  |UP[|UI' + padright (inttostr (b), 3, ' ') + '|UP]|US  ' + cr. desc);
      inc (b);
    end;
    send (^M^J);
  end;

begin
  assign (cf, uc. datapath + 'msgconf.dat');
  {$I-}
  reset (cf);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then begin
    comwriteln (^M^J'|USCould not open conference data file.');
  end;

  repeat
    comwrite (^M^J'|UREdit bases in which conference [|UI1|UP-|UI' + inttostr (filesize (cf))
              + '|UP, |UIQ|UP/|URquit|UP]: |UI');
    Lui := GetQNumStr (False, False, 1, FileSize (cf), 0, 0, 0, 0, wow, '?Qq');
    if hung then break;
    comwriteln ('');
    if wow = 1 then
      minilist
    else if wow > 1 then
      break
    else if lui <> 0 then begin
      jconf (false, lui);
      gobase (1, false);
      editbase;
    end;
  until hung;
  close (cf);
end;

procedure editfareas;
var
  lui,
  wow: byte;
  cf: file of confrec;
  cr: confrec;

  procedure minilist;
  var
    b: byte;
  begin
    fillin1 := 'File Conferences';
    pfile ('hdr.ans');
    send (^M^J);
    seek (cf, 0);
    b := 1;
    while not eof (cf) do begin
      read (cf, cr);
      comwriteln ('  |UP[|UI' + padright (inttostr (b), 3, ' ') + '|UP]|US  ' + cr. desc);
      inc (b);
    end;
    send (^M^J);
  end;

begin
  assign (cf, uc. datapath + 'fileconf.dat');
  {$I-}
  reset (cf);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then begin
    comwriteln (^M^J'|USCould not open conference data file.');
  end;

  repeat
    comwrite (^M^J'|UREdit areas in which conference [|UI1|UP-|UI' + inttostr (filesize (cf))
              + '|UP, |UIQ|UP/|URquit|UP]: |UI');
    Lui := GetQNumStr (False, False, 1, FileSize (cf), 0, 0, 0, 0, wow, '?Qq');
    if hung then break;
    comwriteln ('');
    if wow = 1 then
      minilist
    else if wow > 1 then
      break
    else if lui <> 0 then begin
      jconf (true, lui);
      farea (1);
      editarea;
    end;
  until hung;
  close (cf);
end;

End.