Unit Messages;
{$I Sys75.Inc}
{$D-,I-,L-,Q-,R-,S-}

Interface

Uses
  dos, Spuds;

Procedure rMessages1 (C: Char; P: Str100);
Procedure rMessages2 (C: Char; P: Str100);
procedure gobase (b: word; stuv: boolean);
function  basefname (conf, base: byte): namestr;

var
  vbase: mbaserec;

Implementation

Uses
  TotStr, TotMisc, totlink,
  comm, RemEmu, Users, Menus, Misc, regs, MsgSpon, JoinConf;

var
  baseparsed: boolean;
  br: mbaserec;
  count: word;

Procedure BaseList (C: Char);
var
  s: string;
Begin
  if baseparsed then begin
    With br do Case C of
      '#': s := IntToStr (Count);
      'N': s := name;
      'S': s := sponsor;
      Else s := '@' + C;
    End;
    comwrite (padd (s));
    baseparsed := false;
  End else if c = '@' then baseparsed := true else comwritech (c);
End;

procedure listbases;
var
  path: dirstr;
  bf: file of mbaserec;
begin
  If Exist (CurStatSet. Path + 'Bases.*') Then
    Path := CurStatSet. Path
  Else
    Path := Uc. DispPath;
  showfile (path + 'bases.top', false, true);
  assign (bf, uc. bordpath + 'msgbases.' + inttostr (curmconf));
  reset (bf);
  for count := 1 to filesize (bf) do begin
    read (bf, br);
    baseparsed := false;
    showfileproc (path + 'bases.mid', baselist);
  end;
  close (bf);
  showfile (path + 'bases.bot', false, true);
  Log (0, 'Listed message bases');
end;

procedure gobase (b: word; stuv: boolean);
var
  bf: file of mbaserec;
  list: pdllobj;
  path: pathstr;
  wow: byte;
begin
  assign (bf, uc. bordpath + 'MsgBases.' + inttostr (curmconf));
  {$I-}
  reset (bf);
  if (ioresult <> 0) or (filesize (bf) = 0) then begin
    if ioresult <> 0 then ;
    close (bf);
    if ioresult <> 0 then ;
    {$IFDEF Debug}{$I+}{$ENDIF}
    curbase := 1;
    makebase;
    gobase (curbase, true);
    exit;
  end;

  if b = 0 then begin
    if exist (curstatset. path + 'pdmbase.' + inttostr (curmconf)) then
      path := curstatset. path + 'pdmbase.' + inttostr (curmconf)
    else if exist (uc. disppath + 'pdmbase.' + inttostr (curmconf)) then
      path := uc. disppath + 'pdmbase.' + inttostr (curmconf)
    else if exist (curstatset. path + 'pdmbase.ans') then
      path := curstatset. path + 'pdmbase.ans'
    else if exist (uc. disppath + 'pdmbase.ans') then
      path := uc. disppath + 'pdmbase.ans'
    else
      path := '';

    if path <> '' then begin
      new (list, init);
      while not eof (bf) do begin
        read (bf, br);
        list^. add (br. pdname, 31);
      end;
      b := getpdconf (path, curarea, list);
      dispose (list, done);
      if b = 0 then path := '';
    end;

    if path = '' then begin
      listbases;
      fillin1 := inttostr (filesize (bf));
      repeat
        comwrite (^M^J + cs (125));
        b := getqnumstr (false, false, 1, filesize (bf), 0, 0, curbase, 0, wow, '?');
        if b > 0 then break;
        if wow = 1 then listbases;
      until hung;
    end;
  end;

  if b > filesize (bf) then begin
    close (bf);
    exit;
  end;

  seek (bf, pred (b));
  read (bf, vbase);
  close (bf);

  curbase := b;
  user. lastbase := b;
  fillin1 := '0';
  fillin2 := '0';
  fillin3 := vbase. sponsor;
  if stuv then begin
    comwriteln (cs (191));
    Log (0, 'Changed to message base "' + vbase. name + '"');
  end;
end;

function basefname (conf, base: byte): namestr;
var
  bf: file of mbaserec;
  br: mbaserec;
begin
  basefname := '';
  if conf = 0 then conf := curmconf;
  if base = 0 then base := curbase;
  assign (bf, uc. bordpath + 'msgbases.' + inttostr (conf));
  {$I-}
  reset (bf);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then exit;
  seek (bf, pred (base));
  read (bf, br);
  basefname := br. fname + '.dat';
  close (bf);
end;

procedure postmessage;
begin
end;

Procedure rMessages1 (C: Char; P: Str100);
Var
  B: Word;
Begin
  b := strtoint (strip ('A', ' ', p));
  Case C of
    'B': Unsupported;
    'C': Unsupported;
    'D': Unsupported;
    'E': Unsupported;
    'F': Unsupported;
    'H': Unsupported;
    'L': ListBases;
    'N': Unsupported;
    'P': postmessage;
    'R': Unsupported;
    'S': GoBase (b, true);
    'T': Unsupported;
    'U': userbase;
    'V': Unsupported;
    'W': Unsupported;
    '[': Unsupported;
    ']': Unsupported;
    '!': Unsupported;
    '#': Unsupported;
    Else rError ('M' + C);
  End;
End;

Procedure rMessages2 (C: Char; P: Str100);
Var
  B: Word;
Begin
  b := strtoint (strip ('A', ' ', p));
  Case C of
    '#': Unsupported;
    'A': Unsupported;
    'B': Unsupported;
    'D': Unsupported;
    'E': Unsupported;
    'F': Unsupported;
    'I': Unsupported;
    'L': Unsupported;
    'N': Unsupported;
    'F': Unsupported;
    'R': Unsupported;
    'T': Unsupported;
    'U': Unsupported;
    'X': Unsupported;
    'Y': Unsupported;
    Else rError ('M' + C);
  End;
End;

End.
