Unit Menus;
{$I Sys75.Inc}

Interface

Uses
  Dos,
  TotLink,
  Spuds;

Type
  Str8  = String [8];

Procedure RunMenus (E: Str30);
Procedure LoadMenu (Name: Str8);
Procedure Process (C: Str2; P: Str100; poz: boolean);
Procedure rError (S: String);
Procedure ShowGenerics (N: NameStr; globes: boolean);

Const
  FailFlag     : Boolean = False;
  NewMenu      : Boolean = False;
  RunFirstCmd  : Boolean = True;
  BadMenu      : Boolean = False;
  MaxInLen     : Byte = 80;
  TopMenu      : Str8 = '';
  CurMenu      : Str8 = '';
  BadCommandStr: String = '';
  InputStr     : String = '';
  WildCardStr  : String = '';

Var
  Menu: MenuRec;
  Command: CommandRec;
  PullDown, List, Global, One, FallBack : pDLLobj;

Implementation

Uses
  TotFast, TotStr, TotMisc, TotSys, TotKey,
  Comm, RemEmu, HostMode, Acs, Users, Misc, EmuCodes, Emu, StatusBar,
  Control, MultNode, Matrix, NewScan, Main, Door, Sysop, Nuv, DataArea, Email,
  FileMenu, JoinConf, Messages, QwkMail, TopTen, MsgSpon, FileSpon, Voting,
  Login, Feedback, fonts;

var
  pulldn: pulldownrec;
  curpd: byte;

Procedure rError (S: String);
Begin
  ComWriteLn ('|15');
  ComWriteLn ('Invalid Menu Command|08: |01' + S);
  ComWriteLn ('|07');
  ErrorLog ('|15Invalid Menu Command|08: |01' + S);
End;

Procedure Process (C: Str2; P: Str100; poz: boolean);
Var
  B: Byte;
  T, D: Char;
Begin
  If Not HasAcs (Command. ACS) Then Exit;
  D := Ucase (C [1]);
  T := Ucase (C [2]);
  P := Strip ('B', ' ', P);

  If P = '*' Then
    P := WildCardStr
  Else If P = '&' Then
    P := InputStr;

  Case D of
    '-': rControl (T, P);
    '{': rMatrix (T, P);
    '[': rMainMenu (T, P);
    'D': rDataArea (T, P);
    'F': rFileMenu (T, P);
    'M': rMessages1 (T, P);
    'N': rMessages2 (T, P);
    'T': rFileSponsor (T, P);
    'S': rMsgSponsor (T, P);
    'E': rEmail (T, P);
    'B': rBatchMenu (T, P);
    'V': rVoting (T, P);
    'L': rLogin (T, P);
    'J': rJoinConferences (T, P);
    '*': rSysop (T, P);
    'Q': rQWKMail (T, P);
    '!': rGlobalNS (T, P);
    '^': rNUV (T, P);
    '&': rMultiNode (T, P);
    '.': rDoor (T, P);
    'R': rTopTen (T, P);
    Else rError (C);
  End;
  If Poz Then PressEnter;
End;

Procedure LoadMenu;
Type
  BufType = Array [0..8191] of byte;
  pBufType = ^BufType;
Var
  F: File;
  S: PwStr;
  tm: MenuRec;
Begin
  BadMenu := True;

  If Not OpenFile (Uc. MenuPath + Name + '.Mnu', F) Then Exit;
  BlockRead (F, tm, Sizeof (tm));
  Close (F);

  If Not HasAcs (tm. Acs) Then Begin
    BadMenu := False;
    Exit;
  End;

  If tm. Password <> '' Then Begin
    If not spuds. b (uc. options, localsec) Then begin
      If _y = 1 then
        if statbar = 0 then
          SnapShotOff := currentmode
        else
          SnapShotOff := pred (currentmode)
      else
        SnapShotOff := 1;
      Move (Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], SnapShot, 160);
      Screen^. PartClear (1, SnapShotOff, 80, SnapShotOff, $17, ' ');
      Screen^. WritePlain (1, SnapShotOff, ' Menu pw = ' + tm. password + '  ' + Replicate (30, ' ') + ' ');
      specialbar := true;
    end;

    ComWrite (Cs (21)); {Password: }
    If hung Then Exit;
    S := '';

    GetPwStr (14 + Length (tm. password), False, True, S);
    If hung Then Exit;

    If not spuds. b (uc. options, localsec) Then
      Move (SnapShot, Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], 160);

    ComWriteLn ('');

    If S <> SetLower (tm. Password) Then begin
      Log (2, 'Entered incorrect password joining menu ' + tm. name);
      Log (2, '  Entered: ' + s);
      Exit;
    end;
  End;

  List^. EmptyList;

  If Not OpenFile (Uc. MenuPath + Name + '.Cmd', F) Then Exit;

  While not Eof (F) do Begin
    BlockRead (F, Command, Sizeof (Command));
    Command. Keys := SetUpper (Command. Keys);
    List^. Add (Command, Sizeof (Command));
  End;
  Close (F);

  One^. EmptyList;
  Move (tm, Menu, Sizeof (Menu));
  Menu. Special := SetUpper (Menu. Special);
  NewMenu := True;
  RunFirstCmd := True;
  CurMenu := SetUpper (Name);
  BadMenu := False;
End;

var
  pdparsed: boolean;

procedure showpd (c: char);
Var
  Test: Boolean;
Begin
  Test := True;
  If pdParsed Then Begin
    Case C of
      '%': Begin
             Send (C);
             Test := False;
           End;
      '!': Begin
             inc (curpd);
             GetAxy (pulldn. vaxy);
             pulldown^. add (pulldn, sizeof (pulldn));
           End;
      Else Begin
        Comwrite ('%' + C);
        Test := False;
      End;
    End;
    If Test Then Begin
      Inc (_x, 2);
      If _x > Sx2 Then Begin
        _x := _x - Sx2;
        If _y <> Sy2 Then Inc (_y);
      End;
      Send (GoXy (_x, _y));
    End;
    pdParsed := False;
  End Else Begin
    If C = '%' Then
      pdParsed := True
    Else
      ComWriteCh (C);
  End;
end;

Procedure RunMenus (E: Str30);
Type
  FastType = Record
    Data: String [2];
    Acs: AcsStr;
  End;
Var
  O, S: String;
  Temp2, MaxPD, PickPD, Z, B: Byte;
  Temp: Integer;
  W: Word;
  Comp: Boolean;
  FastMenu: pDllObj;
  daFast: FastType;
  T: Text;
  saved: axy;
Label
  Abort;
Const
  ynq: Array [lbYes..lbQuit] of Char = ('Y', 'N', 'Q');
  mt: Array [false..true] of String [6] = ('Matrix', 'Top');
Begin
  New (PullDown, Init);
  New (List, Init);
  New (One, Init);
  New (FallBack, Init);
  New (FastMenu, Init);

  { Read //\\ ACS minimums for specific commands }
  Assign (T, Uc. DataPath + 'ACSMIN.TXT');
  {$I-}
  Reset (T);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IoResult = 0 Then Begin
    While Not Eof (T) do Begin
      ReadLn (T, S);
      S := SetUpper (Strip ('B', ' ', S));
      With daFast do Begin
        Data := Copy (S, 1, 2);
        Acs := Strip ('L', ' ', Copy (S, 3, 255));
      End;
      FastMenu^. Add (daFast, Sizeof (daFast));
    End;
    Close (T);
  End;

  Global := Nil;

  LoadMenu ('Global');
  If Hung Then Goto Abort;
  BadMenu := False;
  Global := List;
  List := Nil;
  New (List, Init);

  If E = '' Then E := mt [sysauto];
  LoadMenu (E);

  If BadMenu Then Begin
    ComWriteLn ('|15'^M^J'Error: Missing menu (' + E + ')!');
    ErrorLog ('|15Error|01: |09Missing menu |08(|07' + E + '|08)|15!');
    PressEnter;
    hung := True;
  End;
  If Hung Then Goto Abort;

  Repeat
    NewMenu := False;

    B := 1;
    While B <= List^. TotalNodes do Begin
      List^. GetNodeData (List^. NodePtr (B), Command);
      If Command. Keys = '!ONCE' Then Begin
        List^. DelNode (List^. NodePtr (B));
        If RunFirstCmd Then With Command do
          Process (Data, Param, Pause);
        If NewMenu Then Break;
        if hung then Goto Abort;
      End Else If Command. Keys = '!EACH' Then Begin
        List^. DelNode (List^. NodePtr (B));
        One^. Add (Command, Sizeof (Command));
      End Else
        Inc (B);
    End;

    If NewMenu Then Continue;
    If Menu. Special = 'S' Then Dec (Menu. Prompt [0]);

    Repeat
      For B := 1 to One^. TotalNodes do Begin
        One^. GetNodeData (One^. NodePtr (B), Command);
        With Command do
          Process (Data, Param, Pause);
        If NewMenu then Break;
        if hung then Goto Abort;
      End;

      Comp := False;

      Case Menu. Special [1] of
        'N' :
             Begin
               reallyunabortable := true;
               ShowFile (Uc. DispPath + 'MenuProm.' + IntToStr (User. MenuProm), False, True);
               S := '';
               If(ForceHotKeys In Menu.MenuFlags)Or((HotKeys In User.Options)And Not(ForceNOHotKeys In Menu.MenuFlags)) Then
                 GetHotKeyInput (5, MaxInLen, S, True)
               Else
                 GetArrowStr (MaxInLen, S);
               if hung then Goto Abort;
               ComWriteLn ('');
             End;
        'R': S := Chr (Random (Succ (Ord (Menu. Special [2]) - 65)) + 65);
        'S':
             Begin
               If Menu. HelpFile <> '' Then pFile (Menu. HelpFile);
               ComWrite (Menu. Prompt);
               Case Menu. Prompt [Succ (Length (Menu. Prompt))] of
                 '*':
                      Begin
                        usercol (4);
                        S := '';
                        GetArrowStr (MaxInLen, S);
                      End;
                 '/': S := ynq [LiteBar (lbNo, False, false)];
                 '\': S := ynq [LiteBar (lbYes, False, false)];
                 '=': S := ynq [LiteBar (lbYes, True, false)];
                 '|': S := ynq [LiteBar (lbNo, True, false)];
                 '@': S := ynq [LiteBar (lbQuit, True, false)];
                 ':':
                      Begin
                        ComWrite ('|UP:|UI ');
                        S := '';
                        GetArrowStr (MaxInLen, S);
                      End;
                 '#': GetHotKeyInput (5, MaxInLen, S, False);
                 ')':
                      Begin
                        usercol (4);
                        GetHotKeyInput (5, MaxInLen, S, True);
                      End;
                 '(': S := InputStr;
               End;
               if hung then Goto Abort;
               ComWriteLn ('|UR');
             End;
        'P':
        Begin
          ReallyUnabortable := True;
          PullDown^. EmptyList;
          pdparsed := false;
          curpd := 0;

          If (Pos ('\', Menu. HelpFile) = 0) And (Pos (':', Menu. HelpFile) = 0) Then
            If (CurMenuSet. Path <> '') And Exist (CurMenuSet. Path + Menu. HelpFile) Then
              ShowFileProc (CurMenuSet. Path + Menu. HelpFile, showpd)
            Else
              ShowFileProc (Uc. DispPath + Menu. HelpFile, showpd)
          Else
            ShowFileProc (Menu. HelpFile, showpd);

          getaxy (saved);
          if hung then Goto Abort;
          maxpd := pulldown^. totalnodes;

          If MaxPd = 0 Then Begin
            ComWriteLn ('|15'^M^J'Error: Bad or missing pulldown menu ansi ' + Menu. HelpFile + '.');
            ErrorLog ('|15Error|01: |09Bad or missing pulldown menu ansi ' + Menu. HelpFile + '|15!');
            PressEnter;
            if (setupper (menu. name) = 'MATRIX') or (setupper (menu. name) = 'TOP') then
              hung := True
            else begin
              With FallBack^ do Begin
                If TotalNodes <> 0 Then begin
                  GetNodeData (NodePtr (TotalNodes), S);
                  DelNode (NodePtr (TotalNodes));
                  LoadMenu (S);
                end Else
                  hung := true;
              End;
            end;
          End;

          for z := 1 to maxpd do begin
            with pulldown^ do
              getnodedata (nodeptr (z), pulldn);
            With List^ do for B := 1 to TotalNodes do Begin
              GetNodeData (NodePtr (B), Command);
              if (command. pulldnid = z) and not command. hidden then begin
                pulldn. comm := command;
                with pulldown^ do
                  change (nodeptr (z), pulldn, sizeof (pulldn));
                break;
              end;
            end;
          end;

          PickPD := 1;

          if hung then Goto Abort;
          For B := MaxPd downto 1 do Begin
            PullDown^. GetNodeData (PullDown^. NodePtr (B), PullDn);
            With PullDn do
              If B = PickPD Then begin
                putaxy (vaxy);
                Comwrite (antipipe (comm. desc));
              end Else begin
                putaxy (vaxy);
                Comwrite ('|UR' + comm. desc);
              end;
          End;

          NewMenu := False;

          Repeat
            putaxy (saved);
            W := ReadArrow;
            If hung Then Goto Abort;
            Case W of
              kUp, kLeft: Begin
                            With PullDn do begin
                              putaxy (vaxy);
                              Comwrite ('|UR' + comm. desc);
                            end;
                            If PickPD > 1 Then
                              Dec (PickPD)
                            Else
                              PickPD := MaxPD;
                            With PullDown^ do
                              GetNodeData (NodePtr (PickPD), PullDn);
                            With PullDn do begin
                              putaxy (vaxy);
                              Comwrite (antipipe (comm. desc));
                            end;
                          End;
              kDown, kRight: Begin
                               With PullDn do begin
                                 putaxy (vaxy);
                                 Comwrite ('|UR' + comm. desc);
                               end;
                               If PickPD < MaxPD Then
                                 Inc (PickPD)
                               Else
                                 PickPD := 1;
                               With PullDown^ do
                                 GetNodeData (NodePtr (PickPD), PullDn);
                               With PullDn do begin
                                 putaxy (vaxy);
                                 Comwrite (antipipe (comm. desc));
                               end;
                             End;
              kEnter: Break;
              Else With List^ do Begin
                For B := 1 to totalnodes do Begin
                  GetNodeData (NodePtr (B), Command);
                  If Ucase (Chr (Lo (W))) = ucase (Command. keys [1]) Then Break;
                End;
                If Ucase (Chr (Lo (W))) = ucase (Command. keys [1]) Then Begin
                  pulldn. Comm := Command;
                  Break;
                End;
                if w = commandchar then send (#8#32);
              End;
            End;
          Until False;

          if hung then Goto Abort;
          send (attr (7));
          pulldn. Comm. keys := setupper (pulldn. Comm. keys);
          with list^ do for b := 1 to totalnodes do begin
            getnodedata (nodeptr (b), command);
            With Command do
              If pulldn. Comm. keys = setupper (keys) then
                Process (Data, Param, Pause);
            If newmenu Then Break;
            if hung then Goto Abort;
          end;
          If newmenu Then Break;
          continue;
        End;
      End;

      If hung Then Goto Abort;
      If newmenu Then Break;

      S := SetUpper (Strip ('B', ' ', S));
      Val (S, Temp2, Temp);

      If (Copy (S, 1, 4) = '//\\') And HasAcs (Uc. vFastMenuACS) Then Begin
        Delete (S, 1, 4);
        With Command do Begin
          Data := Copy (S, 1, 2);
          Param := Strip ('B', ' ', Copy (S, 3, 255));
        End;

        B := 1;
        With FastMenu^ do While B <= TotalNodes do Begin
          GetNodeData (NodePtr (B), daFast);
          If (Command. Data = daFast. Data) Then Break;
          Inc (B);
        End;

        If (Command. Data = daFast. Data) And Not HasAcs (daFast. Acs) Then Continue;
        With Command do
          Process (Data, Param, False);
        If Hung Then Goto Abort;
        If NewMenu Then Break;
        Comp := True;
      End Else If (S = '?') And (Menu. HelpFile <> '') Then Begin
        If ((AllowGenerics in Menu. MenuFlags) And (CurMenuSet. Path = '!GENERIC'))
        Or (Menu. HelpFile = '!GENERIC') Then
          ShowGenerics (CurMenu, True)
        Else Begin
          ComWriteLn ('');
          If (Pos ('\', Menu. HelpFile) = 0) And (Pos (':', Menu. HelpFile) = 0) Then
            mFile (Menu. HelpFile)
          Else
            ShowFile (Menu. HelpFile, False, True);
        End;
        If hung Then Goto Abort;
        ComWriteLn ('');
        Comp := True;
      End Else Begin
        B := 1;
        With List^ do While B <= TotalNodes do Begin
          GetNodeData (NodePtr (B), Command);

          O := S;
          Z := Pos ('*', Command. Keys);
          If Z <> 0 Then Begin
            Delete (Command. Keys, Z, 255);
            If Length (O) >= Z Then Begin
              WildCardStr := Copy (O, Z, 255);
              Delete (O, Z, 255);
            End Else WildCardStr := '';
          End;

          if (temp = 0) And (Command. Keys = '!NUMBER') then
            wildcardstr := O;

          If (O = Command. Keys) Or ((Temp = 0) And (Command. Keys = '!NUMBER'))
          Or ((O = '') And (Command. Keys = '!ENTER'))
          Or ((O = '! D !!') And (Command. Keys = '!DOWN'))
          Or ((O = '! U !!') And (Command. Keys = '!UP'))
          Or ((O = '! L !!') And (Command. Keys = '!LEFT'))
          Or ((O = '! R !!') And (Command. Keys = '!RIGHT'))
          Then Begin
            With Command do
              Process (Data, Param, Pause);
            If Hung Then Goto Abort;
            If NewMenu Then Break;
            Comp := True;
          End;
          Inc (B);
        End;
      End;

      If NewMenu Then Break;
      if hung then Goto Abort;
      If Comp Then Continue;

      If AllowGlobals In Menu. MenuFlags Then Begin
        B := 1;
        With Global^ do While B <= TotalNodes do Begin
          GetNodeData (NodePtr (B), Command);

          O := S;
          Z := Pos ('*', Command. Keys);
          If Z <> 0 Then Begin
            Delete (Command. Keys, Z, 255);
            If Length (O) >= Z Then Begin
              WildCardStr := Copy (O, Z, 255);
              Delete (O, Z, 255);
            End Else WildCardStr := '';
          End;

          If (O = Command. Keys) Then Begin
            With Command do
              Process (Data, Param, Pause);
            If NewMenu Then Break;
            if hung then Goto Abort;
            Comp := True;
          End;
          Inc (B);
        End;
      End;

      If NewMenu Then Break;
      If hung Then Goto Abort;
      If Comp Then Continue;

      ComWrite (BadCommandStr);

    Until hung;
  Until hung;

  Abort:

  If FastMenu <> Nil Then Dispose (FastMenu, Done);
  If PullDown <> Nil Then Dispose (PullDown, Done);
  If List <> Nil Then Dispose (List, Done);
  If Global <> Nil Then Dispose (Global, Done);
  If One <> Nil Then Dispose (One, Done);
  If FallBack <> Nil Then Dispose (FallBack, Done);
End;

var
  globenum: byte;
  showglobes,
  sgparsed: boolean;
  comr: commandrec;
  comf: file of commandrec;
  cmdlist: pstrdllobj;
  menr: menurec;

procedure showgen (c: char);
var
  b: byte;
  z: boolean;
  s: string;
Begin
  If sgParsed Then Begin
    Case C of
      '%': s := C;
      'D': s := comr. Desc;
      'T': S := menr. name;
      'K': Begin
             repeat
               z := false;
               if eof (comf) then begin
                 if showglobes and (globenum <> Global^. TotalNodes) then begin
                   with global^ do
                     getnodedata (nodeptr  (globenum), comr);
                   inc (globenum);
                 end else begin
                   comr. keys := '';
                   comr. desc := '';
                   comr. hidden := false;
                 end;
               end else
                 read (comf, comr);
               if comr. keys = '' then break;
               comr. keys := setupper (comr. keys);
               if (comr. keys = '!ONCE') or (comr. keys = '!ENTER') or
               (comr. keys = '!NUMBER') or (comr. keys = '!EACH') then
                 comr. hidden := true;
               if not comr. hidden then begin
                 with cmdlist^ do begin
                   for b := 1 to totalnodes do begin
                     z := comr. keys = getstr (nodeptr (b), 1, 255);
                     if z then break;
                   end;
                   if z then continue;
                   add (comr. keys);
                 end;
               end else continue;
               break;
             until false;
             s := comr. keys;
           End;
      Else
        s := '@' + C;
    End;
    comwrite (padd (s));
    sgParsed := False;
  End Else Begin
    If C = '@' Then
      sgParsed := True
    Else
      ComWriteCh (C);
  End;
end;

Procedure ShowGenerics (N: NameStr; globes: boolean);
var
  path: dirstr;
  menf: file of menurec;
Begin
  if exist (curstatset. path + 'Generics.*') then
    Path := curstatset. path
  else
    path := uc. disppath;

  Assign (menf, uc. menupath + N + '.Mnu');
  reset (menf);
  read (menf, menr);
  close (menf);

  sgparsed := false;
  ShowFileProc (path + 'Generics.Top', ShowGen);

  new (cmdlist, init);
  if cmdlist = nil then exit;

  showglobes := globes and (allowglobals in menr. menuflags);
  globenum := 1;
  Assign (comf, uc. menupath + N + '.Cmd');
  reset (comf);
  repeat
    sgparsed := false;
    reallyunabortable := true;
    showfileproc (path + 'Generics.Mid', ShowGen);
  until eof (comf);
  if showglobes then repeat
    sgparsed := false;
    reallyunabortable := true;
    showfileproc (path + 'Generics.Mid', ShowGen);
  until globenum <> 1;
  close (comf);
  dispose (cmdlist, done);
  showFileProc (path + 'Generics.Bot', ShowGen);
End;

End.
