Unit Matrix;
{$I Sys75.Inc}

Interface

Uses
  Acs, Spuds;

Procedure rMatrix (C: Char; P: String);
Function  CheckAccess: Boolean;
Function  GetUserPw: Boolean;

Var
  JustApplied,
  Applied,
  LoginCombo,
  SystemLaunched,
  plParsed: Boolean;

  SysPwError,
  NupError,
  PwError,
  HandleError: Byte;

  axySystemPw,
  axyHandle,
  axyPassword,
  axyLastDate,
  axyLastTime,
  axyUserNote,
  axyPhone,
  axyInput,
  axyNup,
  axyval,
  SaveCursor: axy;

Implementation

Uses
  Dos, Crt,
  TotFast, TotStr, TotDate, TotMisc,
  ApPort, OoCom,
  Users, StatusBar, Misc, Chats, Menus, InfoForm,
  Comm, Emu, RemEmu, HostMode, EmuCodes, Main, Nuv, Regs, BlackLst, fonts;

Var
  TempUser: tUserData;

Procedure ParseLogin (C: Char);
Var
  Test: Boolean;
Begin
  Test := True;
  If plParsed Then Begin
    Case C of
      'S': GetAxy (axySystemPw);
      'H': GetAxy (axyHandle);
      'P': GetAxy (axyPassword);
      'D': GetAxy (axyLastDate);
      'T': GetAxy (axyLastTime);
      'N': GetAxy (axyUserNote);
      '#': GetAxy (axyPhone);
      'I': GetAxy (axyInput);
      'U': GetAxy (axyNup);
      'V': GetAxy (axyval);
      Else Begin
        Comwrite ('@' + C);
        Test := False;
      End;
    End;
    If Test Then Begin
      Inc (_x, 2);
      If _x > Sx2 Then Begin
        _x := _x - Sx2;
        If _y <> Sy2 Then Inc (_y);
      End;
      Send (GoXy (_x, _y));
    End;
    plParsed := False;
  End Else Begin
    If C = '@' Then
      plParsed := True
    Else
      ComWriteCh (C);
  End;
End;

Function GetNup: Boolean;
Var
  Password: PwStr;
  tempb, Display: Boolean;
Begin
  If Uc. Nup = '' Then Begin
    GetNup := True;
    Exit;
  End Else
    GetNup := False;

  If Exist (Uc. DispPath + 'NUP.*') Then Begin
    Display := True;

    FillChar (axyNup, 3, 0);

    plParsed := False;
    ReallyUnabortable := True;
    ShowFileProc (Uc. DispPath + 'NUP.*', ParseLogin);
    If hung Then Exit;

    GetAxy (SaveCursor);

    If axyNup. x = 0 Then Begin
      ComWrite (Cs (54)); {New User Password: }
      If hung Then Exit;
      Display := False;
    End Else
      PutAxy (axyNup);
  End Else Begin
    ComWrite (Cs (54)); {New User Password: }
    If hung Then Exit;
    Display := False;
  End;

  If not spuds. b (uc. options, localsec) Then begin
    If _y = 1 then
      if statbar = 0 then
        SnapShotOff := currentmode
      else
        SnapShotOff := pred (currentmode)
    else
      SnapShotOff := 1;
    Move (Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], SnapShot, 160);
    Screen^. PartClear (1, SnapShotOff, 80, SnapShotOff, $1F, ' ');
    Screen^. WritePlain (68, SnapShotOff, PadRight ('Attempt #' + IntToStr (Succ (NupError)), 12, ' '));
    Screen^. WritePlain (2, SnapShotOff, 'NUP = ' + Uc. Nup + ' ' + Replicate (30, ' ') + '');
    SpecialBar := True;
  end;

  Password := '';
  GetPwStr (10 + Length (Uc. Nup), False, True, Password);
  If hung Then Exit;
  tempb := Password = SetLower (Uc. Nup);

  If not spuds. b (uc. options, localsec) Then
    Move (SnapShot, Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], 160);

  If Not Display Then
    if not tempb then
      ComWriteLn (Cs (13)) {Wrong!}
    else
      ComWriteln ('')
  Else begin
    if not tempb then begin
      PutAxy (axyNup);
      Send (Rep (' ', Length (Password)));
      PutAxy (axyNup);
      ComWrite (Cs (13)); {Wrong!}
    end;
    PutAxy (SaveCursor);
  end;

  SpecialBar := False;
  GetNup := tempb;
  if not tempb then begin
    log (2, 'User at matrix entered incorrect nup');
    log (2, '  Entered: ' + password);
  end;
End;

Function GetVal: Boolean;
Var
  Password: PwStr;
  tempb, Display: Boolean;
Begin
  GetVal := False;

  If Exist (Uc. DispPath + 'AUTOVALP.*') Then Begin
    Display := True;

    FillChar (axyVal, 3, 0);

    plParsed := False;
    ReallyUnabortable := True;
    ShowFileProc (Uc. DispPath + 'AUTOVALP.*', ParseLogin);
    If hung Then Exit;

    GetAxy (SaveCursor);

    If axyVal. x = 0 Then Begin
      ComWrite (Cs (163)); {Auto-val Password: }
      If hung Then Exit;
      Display := False;
    End Else
      PutAxy (axyval);
  End Else Begin
    ComWrite (Cs (163)); {auto-val Password: }
    If hung Then Exit;
    Display := False;
  End;

  If not spuds. b (uc. options, localsec) Then begin
    If _y = 1 then
      if statbar = 0 then
        SnapShotOff := currentmode
      else
        SnapShotOff := pred (currentmode)
    else
      SnapShotOff := 1;
    Move (Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], SnapShot, 160);
    Screen^. PartClear (1, SnapShotOff, 80, SnapShotOff, $1F, ' ');
    Screen^. WritePlain (68, SnapShotOff, PadRight ('Attempt #' + IntToStr (Succ (NupError)), 12, ' '));
    Screen^. WritePlain (2, SnapShotOff, 'Auto-val pw = ' + Uc. autovalpw + ' ' + Replicate (30, ' ') + '');
    SpecialBar := True;
  end;

  Password := '';
  GetPwStr (18 + Length (Uc. autovalpw), False, True, Password);
  If hung Then Exit;
  tempb := Password = SetLower (Uc. autovalpw);

  If not spuds. b (uc. options, localsec) Then
    Move (SnapShot, Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], 160);

  If Not Display Then
    if not tempb then
      ComWriteLn (Cs (13)) {Wrong!}
    else
      ComWriteln ('')
  Else begin
    if not tempb then begin
      PutAxy (axyval);
      Send (Rep (' ', Length (Password)));
      PutAxy (axyval);
      ComWrite (Cs (13)); {Wrong!}
    end;
    PutAxy (SaveCursor);
  end;

  SpecialBar := False;
  Getval := tempb;
  if not tempb then begin
    log (2, 'New user ' + user. handle + ' entered incorrect auto-validation password');
    log (2, '  Entered: ' + password);
  end;
End;

Function ApplyNew: Boolean;
Var
  lui: longint;
  check: PwStr;
  hoe: word;
  valme: boolean;
label
  abort;
Begin
  ApplyNew := False;

  ComWriteLn ('');

  If Applied Then Exit;

  If Totals. tUsers = MaxUsers Then Begin
    ComWriteLn ('|15T|12h|04e |15c|12a|04pacity |15f|12o|04r |15u|12s|04ers |15o|12n |15t|12h|04is |15s|12y|04stem |15h|12a' +
                '|04s |15b|12e|04en |15r|12|e|04ched|08.');
    If Not Registered Then WhyNotReg;
    If Not hung Then PressEnter;
    log (2, 'New user denied due to limited database size.');
    Exit;
  End;

  If Not B (Uc. Options, AllowNewUsers) Then Begin
    ComWriteLn (Cs (51)); {No new users rite now thnx}
    If Not hung Then PressEnter;
    log (1, 'New user denied due to config setting: No New Users.');
    Exit;
  End;

  DefUser;
  user. pagelen := curpagelen;

  ComWrite (Cs (45)); {Hi, welcome to the board}
  If Not hung Then PressEnter;
  If hung Then Exit;

  If Not GetNup Then Begin
    Inc (NupError);
    If NupError = Uc. PwTries Then Begin
      ComWrite (^M^J + Cs (6)); {Try the rite pword next time asshole!}
      hung := True;
      log (2, 'New user failed to enter correct nup and was disconnected.');
    End;
    Exit;
  End;
  If hung Then Exit;

  ComWriteLn ('');

  ComWrite (Cs (46)); {Enter your handle: }
  If hung Then goto abort;
  GetStr (29, False, false, User. handle);
  ComWriteLn ('');
  User. Handle := Strip ('B', ' ', User. Handle);
  If hung Or (User. handle = '') Then goto abort;
  If LookUpUser (User. Handle, user. recnum) Then Begin
    log (1, 'New user attempted to use an existing user''s handle.');
    log (1, '  Tried: ' + user. handle);
    User. handle := '';
    ComWriteLn (Cs (44)); {That name already exists}
    PressEnter;
    goto abort;
  End Else If InBlackList (User. Handle, hoe) Then Begin
    log (2, 'Blacklisted user ' + user. handle + ' attempted to apply.');
    ShowBlackList (hoe);
    Hung := True;
    DefUser;
    user. pagelen := curpagelen;
    goto abort;
  End;

  user. recnum := fSize (uc. datapath + 'users.idx') div sizeof (tuserrec);
  user. usernum := getnextusernum;

  FillIn1 := IntToStr (user. usernum);
  ComWriteLn (Cs (52)); {Your user number is %@1}
  If hung Then goto abort;

  user. pw := MakePw (false, false);
  If hung Then goto abort;

  Repeat
    user. name := '';
    ComWrite (Cs (55));
    GetCapStr (30, 'P', False, false, User. name);
    If hung Then goto abort Else ComWriteLn ('');
  Until user. name <> '';

  Repeat
    user. ph := '';
    ComWrite (Cs (56));
    GetphoneStr (False, User. ph);
    If hung Then goto abort Else ComWriteLn ('');
  Until ValidPhone (user. ph);

  If (Uc. LocalPercent <> 100) And (Pos (Copy (User. ph, 1, 3), Uc. LocalCodes) <> 0) Then Begin
    ComWrite (Cs (113));
    If pcentLocal (true) > Uc. LocalPercent Then Begin
      ComWriteln (^M^J + Cs (88));
      PressEnter;
      Log (2, 'New user ' + user. handle + ' denied: local callers not allowed');
      User. handle := '';
      goto abort;
    End Else ComWriteln ('');
  End;

  ComWrite (Cs (57));
  GetCapStr (30, 'P', False, false, User. street);
  If hung Then goto abort Else ComWriteLn ('');

  ComWrite (Cs (58));
  GetCapStr (30, 'P', False, false, User. citystate);
  If hung Then goto abort Else ComWriteLn ('');

  ComWrite (Cs (101));
  GetStr (30, False, false, User. occupation);
  If hung Then goto abort Else ComWriteLn ('');

  ComWrite (Cs (102));
  GetStr (30, False, false, User. reference);
  If hung Then goto abort Else ComWriteLn ('');

  Repeat
    check := '';
    user. bday := 0;
    ComWrite (Cs (59));
    GetDateStr (False, Check);
    If hung Then goto abort Else ComWriteLn ('');
  Until ValidDateStr (Check);
  user. bday := dateval (Check);

  Repeat
    check := '';
    ComWrite (Cs (60));
    GetLimitStr (False, false, 1, 'MF', Check);
    If hung Then goto abort Else ComWriteLn ('');
    Check := SetUpper (Check);
  Until (Check = 'M') or (Check = 'F');
  If Check = 'M' then with user do
    options := options + [male];

  newaccount (user);
  updateuserrec (user, user. recnum);
  clearallinfoforms (user. recnum);
  ComWriteLn (^M^J);
  Inc (Totals. tUsers);
  Inc (DailyLog. NewUsers);

  FillOutInfoform (0);
  If hung Then goto abort;
  ComWriteLn ('');

  ConfigUser ('NewCfg.*');
  If hung Then goto abort;
  ComWriteLn ('');

  If B (Uc. Options, RequireFeedback) Then ; { Send Letter }
  If hung Then goto abort;
  ComWriteLn ('');

  If B (Uc. Options, RequireUpload) Then ; { Send Upload }
  If hung Then goto abort;
  ComWriteLn ('');

  If uc. autovalpw <> '' then begin
    comwrite (cs (162));
    if litebar (lbno, false, true) = lbyes then begin
      if getval then begin
        ValidateUser (User);
        comwriteln (cs (164));
        log (2, 'New user ' + user. handle + ' was auto-validated.');
        valme := true;
      end else valme := false;
    end else valme := false;
  end;

  If not valme and B (Uc. Options, UseNuv) Then Begin
    AddUserToNuv (User. Handle);
    ComWriteLn (Cs (118));
  End Else If not valme and B (Uc. Options, AutoNuv) Then ValidateUser (User);

  If hung Then goto abort;
  ComWriteLn ('');

  ApplyNew := True;
  Applied := True;
  JustApplied := True;
  UpdateCurUserStat;

  if not valme then ComWriteln (Cs (119));
  log (2, 'New user ' + user. handle + ' completed application.');

  If not valme and B (Uc. Options, HangNewUsers) Then hung := True;

  exit;

  abort:
  log (2, 'User at matrix failed to complete new user applcation.');
  defuser;
  user. pagelen := curpagelen;
End;

Procedure MatrixFeedBack (P: String);
Begin
  log (2, 'User at matrix sent sysop feedback.');
End;

Procedure LaunchSystem (Var P: String);
Var
  Code: Byte;
  It, Temp: PwStr;
Begin
  It := Copy (P, 1, Pred (Pos (',', P)));
  Code := StrToInt (Copy (P, Succ (Pos (',', P)), 3));

  If It <> '' Then Begin
    ComWrite (Cs (97));

    If not spuds. b (uc. options, localsec) Then begin
      If _y = 1 then
        if statbar = 0 then
          SnapShotOff := currentmode
        else
          SnapShotOff := pred (currentmode)
      else
        SnapShotOff := 1;
      Move (Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], SnapShot, 160);
      Screen^. PartClear (1, SnapShotOff, 80, SnapShotOff, $1F, ' ');
      Screen^. WritePlain (2, SnapShotOff, 'PW = ' + It + ' ' + Replicate (30, ' ') + '');
      SpecialBar := True;
    end;

    Temp := '';
    GetPwStr (9 + Length (It), False, True, Temp);

    If not spuds. b (uc. options, localsec) Then
      Move (SnapShot, Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], 160);

    SpecialBar := False;

    If Hung Then Exit;

    ComWriteln ('');

    If SetLower (Temp) <> SetLower (It) Then Begin
      Log (2, 'User at matrix entered wrong password to launch system #' + inttostr (code) + ' from matrix');
      log (2, '  Entered: ' + It);
      Exit;
    End;
  End;

  Log (2, 'User at matrix launched system #' + inttostr (code) + ' from matrix');

  ForceExit := Code;
  SystemLaunched := True;
  If Not LocalOnly Then Uart^. ptOptionsOff (ptRestoreOnClose + ptDropModemOnClose);
  Hung := True;
End;

Procedure MatrixChat;
Var
  S: PwStr;
Begin
  ComWriteLn ('');

  If ChatTries >= Uc. ChatTimes Then Begin
    ComWriteLn (Cs (35)); {Too many pages}
    Exit;
  End;

  ComWriteLn (^M^J + Cs (33)); {Requesting matrix chat}
  If hung Then Exit;

  ComWriteLn ('');

  If Not B (vToggles, 8) Then Begin
    ComWriteLn (Cs (18)); {Sysop is not available}
    ComWrite (Cs (42)); {Is this an emergency?}
    If LiteBar (lbNo, False, true) = lbYes Then Begin
      If Uc. Chatpw <> '' Then Begin
        If not spuds. b (uc. options, localsec) Then begin
          If _y = 1 then
            if statbar = 0 then
              SnapShotOff := currentmode
            else
              SnapShotOff := pred (currentmode)
          else
            SnapShotOff := 1;
          Move (Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], SnapShot, 160);
          Screen^. PartClear (1, SnapShotOff, 80, SnapShotOff, $17, ' ');
          Screen^. WritePlain (1, SnapShotOff, ' Chat pw = ' + Uc. ChatPW + '  ' + Replicate (30, ' ') + ' ');
          specialbar := true;
        end;

        ComWrite (Cs (50)); {Chat password: }
        S := '';
        GetPwStr (14 + Length (Uc. ChatPW), False, True, S);

        If not spuds. b (uc. options, localsec) Then
          Move (SnapShot, Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], 160);

        ComWriteln (^J);

        If S <> SetLower (Uc. ChatPW) Then begin
           Log (2, 'User at matrix entered incorrect emergency chat password');
           Log (2, '  Entered: ' + s);
          Exit;
        end;
      End;
    End Else Exit;
  End;

  ComWrite (Cs (34)); {Chat reason: }
  ChatReason := '';
  GetStr (80, False, false, ChatReason);
  If hung Then Exit;
  ComWriteLn (^M^J);
  If Strip ('A', ' ', ChatReason) = '' Then Exit;

  Inc (ChatTries);
  Log (2, 'User at matrix paged sysop for chat');
  Log (2, '  Reason: ' + ChatReason);
  ComWriteLn (Cs (99)); {Paging sysop...}
  PageSysop (True);
  ComWriteLn (^M^J);
End;

Function GetSysPw: Boolean;
Var
  Password: PwStr;
  Display: Boolean;
Begin
  If Uc. SystemPw = '' Then Begin
    GetSysPw := True;
    Exit;
  End Else
    GetSysPw := False;

  If Exist (Uc. DispPath + 'SYSPASS.*') Then Begin
    Display := True;

    FillChar (axySystemPw, 3, 0);

    plParsed := False;
    ReallyUnabortable := True;
    ShowFileProc (Uc. DispPath + 'SYSPASS.*', ParseLogin);
    If hung Then Exit;

    GetAxy (SaveCursor);

    If axySystemPw. x = 0 Then Begin
      ComWrite (Cs (7)); {System password: }
      If hung Then Exit;
      Display := False;
    End Else
      PutAxy (axySystemPw);
  End Else Begin
    ComWrite (^M^J + Cs (7)); {System password: }
    If hung Then Exit;
    Display := False;
  End;

  If not spuds. b (uc. options, localsec) Then begin
    If _y = 1 then
      if statbar = 0 then
        SnapShotOff := currentmode
      else
        SnapShotOff := pred (currentmode)
    else
      SnapShotOff := 1;
    Move (Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], SnapShot, 160);
    Screen^. PartClear (1, SnapShotOff, 80, SnapShotOff, $1F, ' ');
    Screen^. WritePlain (68, SnapShotOff, PadRight ('Attempt #' + IntToStr (Succ (SysPwError)), 12, ' '));
    Screen^. WritePlain (2, SnapShotOff, 'PW = ' + Uc. SystemPW + ' ' + Replicate (30, ' ') + '');
    SpecialBar := True;
  end;

  Password := '';
  GetPwStr (9 + Length (Uc. SystemPW), False, True, Password);
  If hung Then Exit;

  If not spuds. b (uc. options, localsec) Then
    Move (SnapShot, Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], 160);

  ComWriteln ('');
  If Display Then PutAxy (SaveCursor);

  SpecialBar := False;

  if Password <> SetLower (Uc. SystemPw) then begin
    Log (2, 'User at matrix entered incorrect system password');
    Log (2, '  Entered: ' + Password);
    GetSysPw := false;
  end else GetSysPw := true;
End;

Function GetHandle (AllowNew: Boolean): Boolean;
Var
  Date, Time: String [8];
  th, Handle: HandleStr;
  Apple, Display: Boolean;
  Rec: Word;
  blf: file of dellistrec;
  Error: Integer;
label
  out, out2;
Begin
  GetHandle := False;

  FillChar (axyHandle, 3, 0);
  FillChar (axyPassword, 3, 0);
  FillChar (axyLastDate, 3, 0);
  FillChar (axyLastTime, 3, 0);
  FillChar (axyUserNote, 3, 0);
  FillChar (axyPhone, 3, 0);
  FillChar (axyInput, 3, 0);

  plParsed := False;

  If Exist (Uc. DispPath + 'Login.*') Then Begin
    Display := True;
    LoginCombo := True;

    ReallyUnabortable := True;
    ShowFileProc (Uc. DispPath + 'Login.*', ParseLogin);
    If hung Then Exit;
  End Else If Exist (Uc. DispPath + 'Handle.ans') Then Begin
    Display := True;
    LoginCombo := False;

    ReallyUnabortable := True;
    ShowFileProc (Uc. DispPath + 'Handle.ans', ParseLogin);
    If hung Then Exit;
  End Else
    Display := False;

  If Display Then Begin
    GetAxy (SaveCursor);

    If axyHandle. x = 0 Then Begin
      ComWrite (Cs (8)); {Enter your handle: }
      If hung Then Exit;
      Display := False;
    End Else
      PutAxy (axyHandle);
  End Else Begin
    ComWrite (^M^J + Cs (8)); {Enter your handle: }
    If hung Then Exit;
    Display := False;
  End;

  Handle := '';
  GetStr (30, False, false, Handle);
  If hung Then Exit;

  If Strip ('B', ' ', Handle) = '' Then Exit;

  Val (Handle, Rec, Error);
  If (Error = 0) And (Length (Handle) <= 5) Then Begin
    If LookUpUserNum (Rec, Rec) Then Begin
      ReadUserRec (User, Rec);
      If Display Then
        PutAxy (axyHandle)
      Else
        ComWrite (^M + Cs (8)); {Enter your handle: }
      If Length (User. Handle) < 5 Then
        ComWriteLn (PadLeft (User. Handle, 5, ' '))
      Else
        ComWriteLn (User. Handle);
      Goto out2;
    End;
  End;

  ComWriteln ('');

  If Not LookUpUser (Handle, Rec) Then Begin
    If InBlackList (Handle, Rec) Then Begin
      ShowBlackList (Rec);
      Hung := True;
      Exit;
    End;

    If axyInput. x <> 0 then PutAxy (axyInput);
    ComWriteLn (Cs (9)); {User not found}
    If AllowNew And Not Applied And B (Uc. Options, AllowNewUsers) Then Begin
      ComWrite (Cs (11)); {Apply for access}
      If LiteBar (lbNo,  False, true) = lbYes Then GetHandle := ApplyNew;
    End Else Begin
      PressEnter;
      ComWriteLn ('');
    End;
    Exit;
  End;

  out:

  ReadUserRec (User, Rec);

  out2:

  GetDateTimeStr (User. LastOn, Date, Time);

  If axyLastDate. x <> 0 then Begin
    PutAxy (axyLastDate);
    ComWrite (Date);
  End;

  If axyLastTime. x <> 0 then Begin
    PutAxy (axyLastTime);
    ComWrite (Time);
  End;

  If axyUserNote. x <> 0 then Begin
    PutAxy (axyUserNote);
    ComWrite (User. UsrNote);
  End;

  If Display Then PutAxy (SaveCursor);
  GetHandle := True;
End;

Function GetUserPw: Boolean;
Var
  i: integer;
  Password: PwStr;
  Display: Boolean;
  wl: Byte;
  ws: String;
Begin
  wl := PipeLen (Cs (13));
  ws := cs (13);

  GetUserPw := False;
  PwError := 0;
  If SysAuto Then Begin
    LoginCombo := False;
    Display := true;
  End Else
    Display := (LoginCombo And (axyPassword. x = 0)) or Exist (Uc. DispPath + 'PWORD*.Ans');

  If Display And Not LoginCombo Then Begin
    plParsed := False;
    ReallyUnabortable := True;
    ShowFileProc (Uc. DispPath + 'PWORD.ANS', ParseLogin);
    If axyPassword. x = 0 Then Display := False;
  End;

  If Not Display Then
    ComWrite (Cs (12)) {Password: }
  Else If Not LoginCombo Then
    GetAxy (SaveCursor);

  Repeat
    If not spuds. b (uc. options, localsec) Then begin
      If _y = 1 then
        if statbar = 0 then
          SnapShotOff := currentmode
        else
          SnapShotOff := pred (currentmode)
      else
        SnapShotOff := 1;
      Move (Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], SnapShot, 160);
      Screen^. PartClear (1, SnapShotOff, 80, SnapShotOff, $1F, ' ');
      Screen^. WritePlain (68, SnapShotOff, PadRight ('Attempt #' + IntToStr (Succ (PwError)), 12, ' '));
      Screen^. WritePlain (2, SnapShotOff, 'PW = ' + User. pw + ' ' + Replicate (30, ' ') + '');
      specialbar := true;
    end;

    If Display Then PutAxy (axyPassword);
    Password := '';
    GetPwStr (9 + Length (User. pw), False, not sysauto, Password);
    If hung Then Exit;

    If not spuds. b (uc. options, localsec) Then
      Move (SnapShot, Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], 160);

    If Password = SetLower (User. pw) Then
      Break
    Else Begin
      Inc (User. Illegal);
      Inc (PwError);
      send (Rep (#08, Length (Password)));
      send (Rep (#32, Length (Password)));
      send (Rep (#08, Length (Password)));
      ComWrite (ws);

      notice (user. recnum, 'Hack attempt, tried: ' + password);
      Log (2, 'User at matrix attempting to hack ' + user. handle + '''s account');
      Log (2, '  Entered: ' + password);

      If PwError = Uc. PwTries Then Begin
        Log (2, 'Hack attempt on ' + user. handle + ' terminated via disconnection.');
        notice (1, 'Failed hack attempt on ' + user. handle + '''s account');
        ComWrite (^M^J + Cs (6));
        hung := True;
        AddCaller := False;
        Exit;
      End;
      iDelay (500);
      If Display Then Begin
        PutAxy (axyPassword);
        ComWrite (Rep (' ', wl));
      End Else
        ComWrite (^M^J + Cs (12));
    End;
  Until hung;

  If hung Then Exit;
  ComWriteLn ('');

  If Not SysAuto And B (Uc. Options, PhonePw) Then Begin
    If Display And (axyPhone. x <> 0) then PutAxy (axyPhone);
    ComWrite (Cs (43));

    Repeat
      If not spuds. b (uc. options, localsec) Then begin
        If _y = 1 then
          if statbar = 0 then
            SnapShotOff := currentmode
          else
            SnapShotOff := pred (currentmode)
        else
          SnapShotOff := 1;
        Move (Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], SnapShot, 160);
        Screen^. PartClear (1, SnapShotOff, 80, SnapShotOff, $1F, ' ');
        Screen^. WritePlain (68, SnapShotOff, PadRight ('Attempt #' + IntToStr (Succ (PwError)), 12, ' '));
        Screen^. WritePlain (2, SnapShotOff, 'User''s phone number = ' + User. ph);
        specialbar := true;
      end;

      Password := '';
      GetStr (4, False, false, Password);
      If hung Then Exit;

      If not spuds. b (uc. options, localsec) Then
        Move (SnapShot, Mem [Seg (Screen^. ScreenPtr^):Ofs (Screen^. ScreenPtr^) + Pred (SnapShotOff) * 160], 160);

      If SetLower (Password) = SetLower (Copy (User. Ph, 9, 4)) Then Begin
        ComWriteLn ('');
        Break;
      End Else Begin
        Inc (User. Illegal);
        Inc (PwError);
        ComWrite (Rep (#08, Length (Password)));
        ComWrite (Rep (#32, Length (Password)));
        ComWrite (Rep (#08, Length (Password)));
        ComWrite (ws);

        Log (2, 'User at matrix attempting to hack ' + user. handle + '''s account');
        Log (2, '  Entered: ' + password + ' for phone number');
        notice (user. recnum, 'Hack attempt, tried: ' + password);

        If PwError = Uc. PwTries Then Begin
          Log (2, 'Hack attempt on ' + user. handle + ' terminated via disconnection.');
          notice (1, 'Failed hack attempt on ' + user. handle + '''s account');
          ComWrite (^M^J + Cs (6));
          hung := True;
          AddCaller := False;
          Exit;
        End;
        iDelay (500);
        If Display Then Begin
          ComWrite (Rep (#08, wl));
          ComWrite (Rep (#32, wl));
          ComWrite (Rep (#08, wl));
        End Else
         ComWrite (^M^J + Cs (43));
      End;
    Until hung;
  End;

  If Display Then PutAxy (SaveCursor);
  SpecialBar := False;
  GetUserPw := True;
End;

Function CheckAccess: Boolean;
Var
  Q: LongInt;
  n: datetimerec;
Begin
  CheckAccess := False;

  If User. sl = 0 then begin
    FillIn1 := IntToStr (User. voteyes);
    FillIn2 := IntToStr (User. voteno);
    FillIn3 := IntToStr (Uc. yesvote);
    FillIn4 := IntToStr (Uc. novote);
    ComWriteLn (Cs (65));
    Exit;
  end;

  With User do Begin
    If LockedOut In Options Then Begin
      ComWriteLn (Cs (31));
      Log (2, 'Locked out user ' + user. handle + ' tried to login');
      Exit;
    End;

    If Not HasAcs (LogonACS) Then Begin
      ComWriteLn (Cs (32));
      Log (2, 'User ' + user. handle + ' had inadequate ACS for node #' + inttostr (nodenumber));
      Exit;
    End;

    If (MaxTimesOnADay <> 0) And (CallsToday >= MaxTimesOnADay) Then Begin
      ComWriteLn (Cs (30));
      Log (2, 'User ' + user. handle + ' logged off for calling too many times in one day');
      Exit;
    End;

    If (TimeLimit <> 0) And (TimeLeft = 0) Then Begin
      ComWriteLn (Cs (29));
      Log (2, 'User ' + user. handle + ' logged off due to inadequate remaining time');
      Exit;
    End;

    Now (n);

    If LastOn. d = 0 Then LastOn := n;

    If (expiration <> 0) and (n. d <> LastOn. d) Then Begin
      Q := n. d - LastOn. d;
      if q >= expiration then
        expiration := 0
      else
        dec (expiration, q);
      if expiration = 0 then begin
        comwriteln (cs (121));
        sl := expiretosl;
        dsl := expiretodsl;
        expiretosl := 0;
        expiretodsl := 0;
        if sl = 0 then begin
          Log (2, 'User ' + user. handle + ' has expired and has been locked out of the board');
          comwriteln (cs (104));
          dec (totals. tusers);
          user. sysnote := 'Expired on ' + CurrentDate (True);
{          adduserundel (user);}
          user. handle := '';
          hung := true;
          exit;
        end else begin
          Log (2, 'User ' + user. handle + ' has expired and has had his access lowered to ' + inttostr (expiretosl));
          fillin1 := inttostr (sl);
          comwriteln (cs (103));
          pressenter;
        end;
      end;
    end;
  End;

  CheckAccess := True;
End;

Procedure Login (SysPw, Load: Boolean);
Begin
  FailFlag := True;

  If SysPw Then Begin
    If Not GetSysPw Then Begin
      Inc (SysPwError);
      If SysPwError >= Uc. PwTries Then Begin
        ComWriteLn (Cs (6)); {Try the right password next time!}
        hung := True;
      End;
      Exit;
    End;

    If hung Then Exit;

    ShowFile (Uc. DispPath + 'Prelogon.*', False, True);
    If hung Then Exit;
    PressEnter;
    If hung Then Exit;
  End;

  If Not GetHandle (SysPw) or Hung Then Exit;

  If JustApplied Then Begin
    JustApplied := False;
    Exit;
  End;

  If Not GetUserPw or Hung Then Exit;

  If Not CheckAccess then Begin
    Hung := True;
    AddCaller := False;
  End;
  If Hung Then Exit;

  FailFlag := False;

  If Not Load Then Exit;

  If Not SysPw Then Begin
    If Uc. SystemPw <> '' Then Begin
      FillIn1 := Uc. SystemPw;
      ReallyUnabortable := True;
      ShowFile (Uc. DispPath + 'SysCheck.*', False, True)
    End Else ComWriteln (Cs (109));
    Log (2, 'User ' + user. handle + ' checked the system password');
    ComWrite (Cs (53));
    If LiteBar (lbYes, False, true) = lbNo Then Exit;
    If hung Then Exit;
    ComWriteLn ('');
  End;

  If Hung Then Exit;

  If not Applied then UpdateCurUserStat;

  WriteLn (LogFile, AnsA (Uc. Colors [2], textattr) + '> ' + CurrentTime (False) + '  User ' + user. handle + ' logged on' +
           AnsA (Uc. Colors [1], textattr));
  LoadMenu ('TOP');
End;

Procedure rMatrix (C: Char; P: String);
Begin
  Case C of
    'A': Begin
           ApplyNew;
           JustApplied := False;
         End;
    'C': Login (False, True);
    'D': Login (False, False);
    'F': MatrixFeedBack (P);
    'L': LaunchSystem (P);
    'P': MatrixChat;
    'T': Login (True, False);
    'X': LoadMenu ('TOP');
    '!': Login (True, True);
    Else rError ('{' + C);
  End;
End;

End.
