Unit Login;
{$I Sys75.Inc}

Interface

Uses
  Spuds;

Procedure rLogin (C: Char; P: Str100);

Implementation

Uses
  dos, crt,
  TotMisc, totstr, TotDate, statusbar, emu,
  comm, RemEmu, Users, Menus, Misc, InfoForm, Chats, FileSpon, Sysop, Events;

Procedure CheckBadPwLen;
var
  n: datetimerec;
Begin
  now (n);
  if length (user. pw) < uc. minpwsize then begin
    comwriteln (cs (98));
    user. pw := makepw (false, false);
    user. passwordchanged := n. d;
  end;
End;

Procedure CheckBadPwDate;
var
  n: datetimerec;
Begin
  now (n);
  If (uc. passwordchange <> 0) and (N. d - user. passwordchanged >= uc. passwordchange) then begin
    user. pw := makepw (true, false);
    user. passwordchanged := n. d;
  end;
End;

procedure notices (p: str100);
var
  c: char;
begin
  if p = '' then
    c := #0
  else
    c := ucase (p [1]);

  if exist (uc. datapath + 'usr' + inttostr (user. recnum) + '.not') then begin
    comwriteln (^M^J + cs (170));
    TTYPauser := _y;
    showfile (uc. datapath + 'usr' + inttostr (user. recnum) + '.not', pause in user. options, true);
    comwriteln ('');
    if c = 'P' then comwrite (cs (169));
    if (c = 'D') or ((c = 'P') and (litebar (lbyes, false, true) = lbyes)) then
      deletefile (uc. datapath + 'usr' + inttostr (user. recnum) + '.not');
  end;
end;

Procedure CheckSysCol (B: Boolean);
Var
  W: Byte;
  Z: Boolean;
  n: datetimerec;
Begin
  If User. lastcolorchange < Uc. lastcolorchange Then Begin
    Z := False;
    For W := 1 to 6 do
      Z := Uc. Colors [W] = User. Cols [W];
    If Not Z Then Begin
      if not b then begin
        ComWriteln (^M^J + Cs (116) + ^M^J);
        ComWriteln ('|SR   Regular Color');
        ComWriteln ('  |SS Prompt Color  |SR');
        ComWriteln ('  |SI Input Color   |SR');
        ComWriteln ('  |SS Status Color  |SR');
        ComWriteln ('  |SV Inverse Color |SR');
        ComWriteln ('  |SB Box Color     |SR');
        ComWriteln ('  |SX Box Input     |SR');
        ComWrite (^M^J + Cs (117));
      end;
      If B Or (LiteBar (lbNo, False, True) = lbYes) Then User. Cols := Uc. Colors;
    End;
    Now (n);
    User. lastcolorchange := n. d;
    if not hung then comwriteln ('');
  End;
End;

Procedure rLogin (C: Char; P: Str100);
Var
  W: Word;
Begin
  Case C of
    'S': pFile ('Status.*');
    'M': Unsupported;
    'F': Unsupported;
    'Z': notices (p);
    'A': Unsupported;
    'V': Unsupported;
    'O': Unsupported;
    'W': pFile ('Welcome.*');
    'I': ForceInfoforms;
    'N': Unsupported;
    'C': CheckSysCol (P <> '');
    'B': If B (vToggles, 8) Then
           ComWriteln (Cs (110))
         Else
           ComWriteln (Cs (111));
    'P': If Wanted In User. Options Then Begin
           ChatReason := 'This user has the wanted flag enabled.';
           statbar := 5;
           newstatbar := true;
           showstatus;
           If B (vToggles, 4) Then Begin
             For w := 0 to 7 do Begin
               Crt. Sound (1800 + w * 100);
               iDelay (9);
               Crt. Sound (1900 + w * 100);
               iDelay (11);
               Crt. Sound (2000 + w * 100);
               iDelay (11);
               Crt. Sound (2100 + w * 100);
               iDelay (11);
               Crt. Sound (2200 + w * 100);
               iDelay (11);
               Crt. Sound (2300 + w * 100);
               iDelay (11);
               Crt. Sound (2400 + w * 100);
               iDelay (11);
               Crt. Sound (2500 + w * 100);
               iDelay (11);
             end;
             iDelay (45);
             Crt. NoSound;
           end;
         End;
    'X': CheckBadPwLen;
    'Y': CheckBadPwDate;
    'Q': Begin
           W := Event^. GetNextStrict;
           If (W <> 0) And (W < User. TimeLeft) Then Begin
             FillIn1 := IntToStr (W);
             ComWriteln (Cs (73));
           End;
         End;
    Else rError ('L' + C);
  End;
End;

End.