Unit InfoForm;
{$I Sys75.Inc}

Interface

Uses
  Spuds;

Procedure FillOutInfoform (Num: Byte);
Procedure FillOutFormFile (P: Str100);
Procedure ForceInfoforms;
Procedure ViewInfoform (Num: Byte; Rec: Word);
Procedure ClearInfoform (Num: Byte; Rec: Word);
Procedure ClearAllInfoforms (Rec: Word);

Var
  InfoDump: Text;

Const
  DumpInfo: Boolean = False;

Implementation

Uses
  Dos, TotMisc, TotStr, Users,
  RemEmu, EmuCodes, Comm, misc, emu;

Var
  infoParsed:boolean;
  c1: Char;
  tu: tUserData;
  F: Array ['1'..'5'] of File;
  Save: axy;
  Len, Count: byte;
  Temp: String;
  redo, NoNull, FillItOut: Boolean;

Procedure ListInfo (C: Char); Far;
var
  s: string;
Begin
  if infoparsed then begin
    With Uc. InfoForms [Count] do Case C of
      'N': s := Name;
      '#': s := IntToStr (Count);
      'M': s := ManStr [Force];
      'C': s := CompStr [User. Infoforms [Count] <> 0];
      Else s := '@' + C;
    End;
    comwrite (padd (s));
    infoparsed := false;
  End else if c = '@' then infoparsed := true else comwritech (c);
End;

Procedure DoInfoForm (C: Char); Far;
var
  sp: longint;
Begin
  Case Count of
    0: If C = '%' Then Begin
         NoNull := True;
         Inc (Count)
       End Else If C = '|' Then Begin
         NoNull := False;
         Inc (Count)
       End Else
         ComWriteCh (C);
    1: If Not (C in ['0'..'9']) Then Begin
         Count := 0;
         If NoNull Then
           ComWrite ('%' + C)
         Else
           ComWrite ('|' + C);
       End Else Begin
         Inc (Count);
         Temp := C;
       End;
    2: If C In ['0'..'9'] Then Begin
         Count := 0;
         Temp := Temp + C;
         Len := StrToInt (Temp);
         GetAxy (Save);
         If FillItOut Then Begin
           Repeat
             Temp := '';
             PutAxy (Save);
             if redo then begin
               sp := filepos (f [c1]);
               BlockRead (F [c1], Temp [0], Succ (Len));
               seek (f [c1], sp);
             end;
             GetCoolStr (Len, Temp);
             If Hung Then Exit;
             If Not (NoNull And (Strip ('A', ' ', Temp) = '')) Then Break;
           Until False;
           BlockWrite (F [c1], Temp [0], Succ (Len));
         End Else Begin
           BlockRead (F [c1], Temp [0], Succ (Len));
           ComWrite (Temp);
         End;

         PutAxy (Save);
         Inc (_x, 3);
         If _x > Sx2 Then Begin
           _x := _x - Sx2;
           If _y <> Sy2 Then Inc (_y) else send (^J);
         End;
         Send (GoXy (_x, _y));
       End Else Begin
         Count := 0;
         If NoNull Then
           ComWrite ('%' + Temp + C)
         Else
           ComWrite ('|' + Temp + C);
       End;
  End;
End;

Procedure FillOutInfoform (Num: Byte);
Var
  Path: DirStr;
  Lim: String [5];
  S: String [1];
  Rep: Boolean;
  L: LongInt;
  buf: pointer;
Label
  Top;
Begin
  Rep := Num = 0;

  If Rep Then
    If Exist (CurStatSet. Path + 'Forms.*') Then
      Path := CurStatSet. Path
    Else
      Path := Uc. DispPath;

  FillItOut := True;
  Lim := '';

  If Rep Then For Count := 1 to 5 do
    With Uc. InfoForms [Count] do
      If Name <> '' Then Lim := Lim + Chr (Count + 48);

  if lim = '' then begin
    ComWriteLn ('');
    exit;
  end;

  getmem (buf, 4000);
  fillchar (buf^, 4000, 0);

  Repeat
    If Rep Then Begin
      ShowFile (Path + 'Forms.Top', False, True);
      If hung Then break;
      For Count := 1 to 5 do Begin
        if inputbroke then break;
        infoParsed:=false;
        If Uc. InfoForms [Count]. Name <> '' Then ShowFileProc (Path + 'Forms.Mid', ListInfo);
        If hung Then break;
      End;
      If hung Then break;
      if inputbroke then
        comwriteln ('|UR' + ^M^J)
      else
        ShowFile (Path + 'Forms.Bot', False, True);
      If hung Then break;
      ComWrite (Cs (64));
  Top:
      S := '';
      GetLimitStr (False, false, 1, Lim,  S);
      If hung Then break;
      ComWriteLn ('');
      If S = '' Then Begin
        For Count := 1 to 5 do
          With Uc. InfoForms [Count] do
            If (Name <> '') And Force And (User. Infoforms [Count] = 0) Then Goto Top;
        Break;
      End;
      Num := StrToInt (S);
    End Else S := IntToStr (Num);

    redo := false;
    If User. Infoforms [Num] <> 0 Then Begin
      ComWrite (^M^J + Cs (66));
      If LiteBar (lbNo, False, true) = lbNo Then
        if rep then
          Continue
        else
          break;
      redo := true;
    End;
    if hung then break;

    c1 := '1';
    Assign (F [c1], Uc. DataPath + 'Form' + S + '.Dat');
    {$I-}
    Reset (F [c1], 1);
    {$IFDEF Debug}{$I+}{$ENDIF}
    If IoResult = 2 Then Rewrite (F [c1], 1);
    if User. Infoforms [Num] = 0 then begin
      Seek (F [c1], FileSize (F [c1]));
      BlockWrite (F [c1], Buf^, 4000);
      Seek (F [c1], FilePos (F [c1]) - 4000);
    end else begin
      l := pred (User. Infoforms [Num]);
      Seek (F [c1], l * 4000);
    end;

    repeat
      Count := 0;
      ReallyUnabortable := True;
      ShowFileProc (Uc. DispPath + 'InfoForm.' + S, DoInfoForm);
      Log (1, 'Filled out infoform ' + uc. infoforms [num]. name);
      If Hung Then break;
      User. Infoforms [Num] := FileSize (F [c1]) div 4000;
      comwrite (^M^J + Cs (141));
      if litebar (lbno, false, true) = lbno then break;
      redo := true;
      l := pred (User. Infoforms [Num]);
      Seek (F [c1], l * 4000);
    until hung;
    Close (F [c1]);
    If Not Rep Then Break;
  Until hung;
  freemem (buf, 4000);
  if not hung then ComWriteLn ('');
End;

Procedure FillOutFormFile (P: Str100);
Var
  Num: Byte;
Begin
  DumpInfo := True;
  P := Strip ('A', ' ', P);
  if p = '' then exit;
  Num := Ord (P [1]) - 48;
  If (Num > 5) Or (Num < 1) Then Exit;
  if not exist (uc. disppath + 'infoform.' + p [1]) then exit;
  Delete (P, 1, 2);
  Assign (InfoDump, FExpand (P) + IntToStr (User. RecNum) + '.' + Chr (Num + 48));
  {$I-}
  Rewrite (InfoDump);
  {$IFDEF Debug}{$I-}{$ENDIF}
  If IoResult <> 0 Then Begin
    DumpInfo := False;
    ComWriteLn ('%CR|04Error creating file.');
    Exit;
  End;
  FillOutInfoform (Num);
  Close (InfoDump);
  DumpInfo := False;
End;

Procedure ForceInfoforms;
Var
  B: Byte;
Begin
  For B := 1 to 5 do
    With Uc. Infoforms [B] do Begin
      If (Name <> '') And Force And (User. Infoforms [B] = 0) Then
        FillOutInfoform (B);
      If Hung Then Exit;
    End;
  UpdateUserRec (User, User. RecNum);
End;

Procedure ViewInfoform (Num: Byte; Rec: Word);
Var
  Hand: HandleStr;
  S: String [5];

  Procedure DoIt (Rec: Word);
  Begin
    If Rec = User. RecNum Then
      tu := User
    Else
      ReadUserRec (tu, Rec);

    For C1 := '1' to '5' do If Pos (C1, S) <> 0 Then Begin
      If tu. Infoforms [Ord (C1) - 48] = 0 Then Begin
        if uc. infoforms [Ord (C1) - 48]. name = '' then continue;
        FillIn1 := tu. Handle;
        FillIn2 := C1;
        ComWriteLn (^M + Cs (67));
        If hung Then Exit;
        Continue;
      End;
      Seek (F [C1], 4000 * pred (tu. Infoforms [Ord (C1) - 48]));
      Count := 0;
      ReallyUnabortable := True;
      ShowFileProc (Uc. DispPath + 'InfoForm.' + C1, DoInfoForm);
      Log (0, 'Viewed infoform ' + uc. infoforms [Ord (C1) - 48]. name);
      If hung Then Exit;
      Send (GoXy (1, curPageLen));
      PressEnter;
      If hung Then Exit;
    End;
  End;

Begin
  If Num = 0 Then Begin
    ComWrite (^M^J'|URWhich infoform|UP(|URs|UP)|UR to view |UP[|USCr|UP/|USQuit|UP]: |UI');
    S := '';
    GetLimitStr (False, false, 5, '12345', S);
    If hung Then Exit;
    ComWriteLn ('');
    If S = '' Then Exit;
  End Else S := IntToStr (Num);

  If Rec = 0 Then Begin
    ComWrite ('|URView all users ');
    If LiteBar (lbNo, False, true) = lbNo Then Begin
      If hung Then Exit;
      ComWrite ('|UREnter user handle to view |UP[|USCr|UP/|USQuit|UP]: |UI');
      Hand := '';
      GetStr (30, False, false, Hand);
      hand := strip ('B', ' ', hand);
      comwriteln ('');
      If hung Or (Hand = '') Then Exit;
      If Not LookUpUser (Hand, Rec) Then Begin
        ComWriteln (Cs (9)); {User Not Found}
        PressEnter;
        Exit;
      End;
    End;
  End;

  If hung Then Exit;
  FillItOut := False;

  For C1 := '1' to '5' do If Pos (C1, S) <> 0 Then Begin
    Assign (F [C1], Uc. DataPath + 'Form' + C1 + '.Dat');
    {$I-}
    Reset (F [C1], 1);
    {$IFDEF Debug}{$I+}{$ENDIF}
    If IOResult <> 0 Then ;
  End;

  send (cls);

  If Rec <> 0 Then
    DoIt (Rec)
  Else
    For Rec := 1 to FSize (Uc. DataPath + 'Users.Dat') Div Sizeof (tUserData) do Begin
      DoIt (Rec);
      If hung Then Break;
    End;

  {$I-}
  For C1 := '1' to '5' do If Pos (C1, S) <> 0 Then Begin
    Close (F [C1]);
    If IoResult <> 0 Then ;
  End;
  {$IFDEF Debug}{$I+}{$ENDIF}
End;

Procedure ClearInfoform (Num: Byte; Rec: Word);
Var
  Hand: HandleStr;
  S: String [5];
  Juice: Boolean;

  procedure minilist;
  var
    b: byte;
  begin
    comwriteln ('');
    fillin1 := 'Infoforms';
    pfile ('hdr.ans');
    comwriteln ('');
    for b := 1 to 5 do
      if uc. infoforms [b]. name <> '' then
        comwriteln ('|UR' + chr (48 + b) + ') |US' + uc. infoforms [b]. name);
    comwriteln ('');
  end;

  Procedure DoIt (Rec: Word);
  Var
    B: Byte;
    c: char;
  Begin
    If Rec = User. RecNum Then
      tu := User
    Else
      ReadUserRec (tu, Rec);

    for c := '1' to '5' do
      if pos (c, s) <> 0 then
        tu. infoforms [ord (c) - 48] := 0;

    If Rec = User. RecNum Then
      User. Infoforms := tu. infoforms
    Else
      UpdateUserRec (tu, Rec);
  End;

Begin
  If Num = 0 Then Begin
    minilist;
    ComWrite ('|URWhich infoform(s) to clear |UP[|UICr|UP/|URQuit|UP]: |UI');
    S := '';
    GetLimitStr (False, false, 5, '12345', S);
    If hung Then Exit;
    ComWriteLn ('');
    If S = '' Then Exit;
  End Else S := IntToStr (Num);

  If Rec = 0 Then Begin
    ComWrite ('|URClear all users ');
    If LiteBar (lbNo, False, true) = lbNo Then Begin
      If hung Then Exit;
      ComWrite ('|UREnter user handle to clear |UP[|USCr|UP/|USQuit|UP]: |UI');
      Hand := '';
      GetStr (30, False, false, Hand);
      hand := strip ('B', ' ', Hand);
      comwriteln ('');
      If hung Or (Hand = '') Then Exit;
      If Not LookUpUser (Hand, Rec) Then Begin
        ComWriteln (Cs (9)); {User Not Found}
        PressEnter;
        Exit;
      End;
      Log (2, 'Killed infoforms ' + s + ' for user ' + hand);
    End else Log (2, 'Killed infoforms ' + s + ' for all users');
  End;

  If hung Then Exit;

  For C1 := '1' to '5' do If Pos (C1, S) <> 0 Then Begin
    Assign (F [C1], Uc. DataPath + 'Form' + C1 + '.Dat');
    {$I-}
    Reset (F [C1], 1);
    {$IFDEF Debug}{$I+}{$ENDIF}
    If IoResult <> 0 then ;
  End;

  If Rec <> 0 Then
    DoIt (Rec)
  Else
    For Rec := 1 to FSize (Uc. DataPath + 'Users.Dat') Div Sizeof (tUserData) do Begin
      DoIt (Rec);
      If hung Then Break;
    End;

  For C1 := '1' to '5' do If Pos (C1, S) <> 0 Then begin
    {$I-}
    Close (F [C1]);
    {$IFDEF Debug}{$I+}{$ENDIF}
    If IoResult <> 0 Then ;
  end;
End;

Procedure ClearAllInfoforms (Rec: Word);
Var
  B: Byte;
Begin
  For B := 1 to 5 do
    ClearInfoForm (B, Rec);
End;

End.
