unit fse;
{$A+,B-,E+,N+,G+,P+,T+,V-,X+,F+,O+,Y-}
{$D+,I+,L+,Q+,R+,S+}

interface

const
  maxlength = 800;

type
  str80 = string [80];
  atextdata = array [1..maxlength] of str80;
  ptextdata = ^atextdata;
  tfseopts = (allowabort, allowreply, allowquote, nonull);
  fseopts = set of tfseopts;

function runfse (bottom, used: word; width, top, bot: byte; options: fseopts; textdata: ptextdata): word;

implementation

uses
  spuds,
  totfast, totkey, totstr,
  emu, comm, rememu, emucodes;

function runfse (bottom, used: word; width, top, bot: byte; options: fseopts; textdata: ptextdata): word;
var
  totallines,
  curline: word;
  pagesize,
  curstrlen,
  curstrpos,
  b: byte;
  w: word;
  c: char;
  newstr,
  curstr: str80;
  commandmode: boolean;
  savecur: axy;

  procedure putline (line: word; data: str80);
  begin
    if (line < 1) or (line > bottom) then exit;
    textdata^ [line] := data;
  end;

  procedure getline (line: word; var data: str80);
  begin
    data := '';
    if (line < 1) or (line > bottom) then exit;
    data := textdata^ [line];
  end;

  procedure scrollupline (line: byte);
  var
    b: byte;
    tmpstr: str80;
  begin
    if termavt in detectedemu then begin
      send (^V^J+chr(1)+chr(pred (top+line))+chr(1)+chr(bot)+chr(width));
      send (goxy (1, bot));
      getline (curline + bot, tmpstr);
      send (clr2eol + tmpstr);
    end else for b := line to bot do begin
      getline (curline + b, tmpstr);
      send (goxy (1, b) + clr2eol + tmpstr);
    end;
    send (goxy (1, pred (top + line)));
  end;

  procedure scrolldownline (line: byte);
  var
    b: byte;
    tmpstr: str80;
  begin
    if termavt in detectedemu then
      send (^V^K+chr(1)+chr(pred (top+line))+chr(1)+chr(bot)+chr(width))
    else begin
      for b := succ (line) to bot do begin
        getline (curline + b, tmpstr);
        send (goxy (1, b) + clr2eol + tmpstr);
      end;
      send (goxy (1, line) + clr2eol);
    end;
  end;

  procedure delline (line: word);
  begin
    if (line < 1) or (line >= bottom) then exit;
    move (textdata^ [succ (line)], textdata^ [line], pred (bottom - line) * 81);
    putline (bottom, '');
    scrollupline (line);
    getline (curline, curstr);
    curstrlen := length (curstr);
    curstrpos := _x;
  end;

  procedure insline (line: word; data: str80);
  begin
    if (line < 1) or (line >= bottom) or (totallines >= bottom) then exit;
    move (textdata^ [line], textdata^ [succ (line)], (bottom - line) * 81);
    putline (line, data);
    scrolldownline (line);
    send (^M^J + data + ^M);
  end;

  procedure scrolluppage;
  var
    numlines, b: byte;
    tmpstr: str80;
  begin
    numlines := (bot - top) div 2;
    if termavt in detectedemu then begin
      send (^V^J+chr(numlines)+chr(top)+chr(1)+chr(bot)+chr(width));
      send (goxy (1, succ (numlines)));
      for b := succ (numlines) to bot do begin
        getline (curline + b, tmpstr);
        send (clr2eol + tmpstr + ^M^J);
      end;
    end else for b := top to bot do begin
      getline (curline + numlines + pred (b), tmpstr);
      send (goxy (1, b) + clr2eol + tmpstr);
    end;
  end;

  procedure scrolldownpage;
  var
    numlines, b: byte;
    tmpstr: str80;
  begin
    numlines := (bot - top) div 2;
    if termavt in detectedemu then begin
      send (^V^K+chr(numlines)+chr(top)+chr(1)+chr(bot)+chr(width));
      send (goxy (1, succ (numlines)));
      for b := top to numlines do begin
        getline (curline + b, tmpstr);
        send (clr2eol + tmpstr + ^M^J);
      end;
    end else for b := top to bot do begin
      getline (curline + numlines + pred (b), tmpstr);
      send (goxy (1, b) + clr2eol + tmpstr);
    end;
  end;

  procedure addchar (c: char);
  var
    a: byte;
    w: word;
  begin
{}  screen^. writeat (1, 1, 8, 'cl=' + padright (inttostr (curline),   3, ' '));
{}  screen^. writeat (10,1, 8, 'tl=' + padright (inttostr (totallines),3, ' '));
{}  screen^. writeat (20,1, 8,'csp=' + padright (inttostr (curstrpos), 3, ' '));
{}  screen^. writeat (30,1, 8,'csl=' + padright (inttostr (curstrlen), 3, ' '));

    if pred (curstrpos) > curstrlen then begin
      curstr := curstr + replicate (pred (_x - curstrlen), ' ');
      curstrlen := length (curstr);
    end;

    if insertmode then
      if length (curstr) < pred (width) then insert (c, curstr, curstrpos) else
    else
      curstr [curstrpos] := c;

    if length (curstr) = pred (width) then begin
      getaxy (savecur);

      a := lastpos (' ', curstr);
      if a = length (curstr) then begin
        newstr := curstr;
        repeat
          dec (newstr [0]);
          a := lastpos (' ', newstr);
        until (a <> length (newstr)) or (newstr = '');
      end;

      if ((c = ' ') or (c = '-')) and (length (curstr) = curstrpos) then a := 0;

      if a = 0 then begin
        if insertmode then putline (curline, curstr);
        if curstrpos = succ (curstrlen) then
          send (c)
        else begin
          if insertmode then send (inschar (1));
          send (c);
        end;
        if insertmode then send (clr2eol);
        if totallines < maxlength then begin
          if curstrpos = length (curstr) then begin
            putline (curline, curstr);
            inc (curline);
            if curline > totallines then totallines := curline;
            getline (curline, curstr);
            curstrlen := length (curstr);
            curstrpos := 1;
            send (^M^J);
          end else begin
            inc (curstrpos);
            if insertmode then begin
              newstr := copy (curstr, curstrpos, curstrlen);
              delete (curstr, curstrpos, curstrlen);
              curstrlen := length (curstr);
              insline (succ (curline), newstr);
              inc (totallines);
              inc (savecur. x);
              putaxy (savecur);
            end;
          end;
        end;
      end else if (curstrpos = succ (curstrlen)) and ((c = ' ') or (c = '-')) then begin
        send (c);
        putline (curline, curstr);
        if curline mod pagesize = 0 then
          scrolluppage
        else
          send (^M^J);
        inc (curline);
        getline (curline, curstr);
        curstrlen := length (curstr);
        curstrpos := succ (curstrlen);
      end else begin
        newstr := copy (curstr, succ (a), curstrlen);
        delete (curstr, a, curstrlen);
        send (goxy (a, _y) + clr2eol);
        putline (curline, curstr);
        if curline < maxlength then inc (curline);
        if curline > totallines then inc (totallines);
        for w := curline to totallines do begin
          getline (w, curstr);
          if length (newstr + ' ' + curstr) < pred (width) then begin
            curstr := newstr + ' ' + curstr;
            putline (w, curstr);
            if w mod pagesize <= pagesize then send (goxy (1, top + pred (w mod pagesize)) + inschar (length (newstr))+newstr);
            break;
          end else if length (curstr) = pred (width) then begin
            insline (w, newstr);
            if w mod pagesize <= pagesize then send (goxy (1, top + pred (w mod pagesize)) + newstr + clr2eol);
            break;
          end else begin
            curstr := newstr + curstr;
            a := lastpos (' ', curstr);
            if a = length (curstr) then begin
              dec (curstr [0]);
              a := lastpos (' ', curstr);
            end;
            newstr := copy (curstr, succ (a), curstrlen);
            delete (curstr, a, curstrlen);
            send (goxy (a, _y) + clr2eol);
            putline (curline, curstr);
          end;
        end;
        if curstrpos <> succ (curstrlen) then begin
          putaxy (savecur);
          dec (curline);
          getline (curline, curstr);
          curstrlen := length (curstr);
          curstrpos := _x;
          if insertmode then send (inschar (1));
          send (c);
        end else begin
          curstrpos := _x;
          curstrlen := length (curstr);
        end;
      end;
    end else begin
      if curstrpos = succ (curstrlen) then
        send (c)
      else begin
        if insertmode then send (inschar (1));
        send (c)
      end;
      inc (curstrpos);
      if insertmode then inc (curstrlen);
    end;
  end;

begin
  if textdata = nil then exit;
  curline := 1;
  curstrlen := 0;
  curstrpos := 1;
  totallines := succ (used);
  if bottom > maxlength then bottom := maxlength;
  pagesize := bot - top;
  commandmode := false;

  usercol (1);
  send (goxy (1, pred (top)));
  for b := top to bot do begin
    getline (b, curstr);
    send (^M^J + clr2eol + curstr);
  end;
  send (goxy (1, top));

  repeat
{}  screen^. writeat (1, 1, 8, 'cl='+ padright (inttostr (curline),   3, ' '));
{}  screen^. writeat (10,1, 8, 'tl='+ padright (inttostr (totallines),3, ' '));
{}  screen^. writeat (20,1, 8, 'csp='+padright (inttostr (curstrpos), 3, ' '));
{}  screen^. writeat (30,1, 8, 'csl='+padright (inttostr (curstrlen), 3, ' '));

    w := readarrow;
    if hung then break;
    if w < 256 then begin
      c := chr (lo (w));
      if commandmode then case ucase (c) of
        'S': if nonull in options then begin
               getline (1, newstr);
               if not ((newstr = '') and (totallines = 1)) then break;
             end else
               break;
        'A': if allowabort in options then begin
               totallines := 0;
               break;
             end;
      end else case c of
        #8: if curstrpos > 1 then begin
              if pred (curstrpos) > curstrlen then begin
                curstr := curstr + replicate (pred (_x - curstrlen), ' ');
                curstrlen := length (curstr);
              end;
              dec (curstrlen);
              dec (curstrpos);
              if succ (curstrlen) = curstrpos then begin
                send (#8' '#8);
                dec (curstr [0]);
              end else begin
                delete (curstr, curstrpos, 1);
                send (^H + delchar (1));
              end;
            end else if curline <> 1 then begin
              putline (curline, curstr);
              dec (curline);
              dec (totallines);
              getline (curline, curstr);
              curstrlen := length (curstr);
              curstrpos := succ (curstrlen);
              send (goxy (curstrpos, pred (_y)));
            end;
        ^M: if totallines < bottom then begin
              if pred (curstrpos) < curstrlen then begin
                newstr := copy (curstr, curstrpos, curstrlen);
                curstr [0] := chr (pred (curstrpos));
                send (clr2eol);
              end else newstr := '';
              putline (curline, curstr);
              inc (curline);
              inc (totallines);
              insline (curline, newstr);
              if newstr = '' then
                curstr := ''
              else
                curstr := newstr;
              curstrlen := length (curstr);
              curstrpos := 1;
            end;
        ^Y: begin
              savecur. x := _x;
              delline (curline);
{              if curline = totallines then begin
                getline (curline, curstr);
                curstrlen := length (curstr);
                curstrpos := _x;
              end;}
              if totallines <> 1 then begin
                dec (curline);
                dec (totallines);
                getline (curline, curstr);
                curstrlen := length (curstr);
                curstrpos := _x;
{}              send (cup);
              end;
            end;
        '/': if curstrpos = 1 then
               commandmode := true
             else
               addchar (c);
        #0..#31:;
        else addchar (c);
      end;
    end else begin
      case w of
        kUp: if curline > 1 then begin
               putline (curline, curstr);
               dec (curline);
               getline (curline, curstr);
               curstrlen := length (curstr);
               curstrpos := _x;
               send (cup);
             end;
        kDown: if curline < totallines then begin
                 putline (curline, curstr);
                 inc (curline);
                 getline (curline, curstr);
                 curstrlen := length (curstr);
                 curstrpos := _x;
                 send (cdn);
               end;
        kLeft: if curstrpos <> 1 then begin
                 dec (curstrpos);
                 send (clt);
               end;
        kRight: if curstrpos < width then begin
                 inc (curstrpos);
                 send (crit);
                end;
        kHome: begin
                 curstrpos := 1;
                 send (goxy (1, _y));
               end;
        kEnd: begin
                 curstrpos := succ (curstrlen);
                 send (goxy (curstrpos, _y));
              end;
        kDel: begin
                if curstrlen = 0 then
                  if curline <> totallines then begin
                    delline (curline);
                    dec (totallines);
                  end else
                else if curstrpos = succ (curstrlen) then
                  if curline <> totallines then begin
                    getline (succ (curline), newstr);
                    if length (newstr) < succ (pred (width) - curstrpos) then begin
                      delline (succ (curline));
                      dec (totallines);
                      send (cup + curstr);
                      getaxy (savecur);
                      curstr := curstr + ' ' + newstr;
                      send (' ' + newstr);
                      curstrlen := length (curstr);
                      putaxy (savecur);
                      curstrpos := _x;
                    end;
                  end else
                else begin
                  delete (curstr, curstrpos, 1);
                  dec (curstrlen);
                  send (delchar (1));
                end;
              end;
        kIns: insertmode := not insertmode;
      end;
    end;
  until hung;

  runfse := totallines;
end;

end.