Unit Fonts;
{$I Sys75.INC}

Interface

uses
  dos;

Function LoadFont (T: PathStr; size: word): Boolean;

const
  currentmode: byte = 25;

Implementation

Type
  tFr = Array [1..4096] Of Byte;

Function LoadFont (T: PathStr; size: word): Boolean;
Var
  F: File;
  S: String;
  Fr: ^tFr;
  R: Word;
  Re: Registers;
  point: byte;

  procedure Lines200;
  Inline ($B8/$03/$00/$CD/$10/$B8/$00/$12/$B3/$30/$CD/$10);

  procedure Lines350;
  Inline ($B8/$03/$00/$CD/$10/$B8/$01/$12/$B3/$30/$CD/$10);

  procedure Lines400;
  Inline ($B8/$03/$00/$CD/$10/$B8/$02/$12/$B3/$30/$CD/$10);

Begin
  loadfont := false;
  assign (f, t);
  {$I-}
  reset (f, 1);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then exit;

  GetMem (Fr, SizeOf (tFr));
  If Fr = Nil Then Exit;

  {$I+}
  BlockRead (F, Fr^, 4096, R);
  {$I-}
  Close (F);

  case size of
    25: begin
          point := 16;
          if currentmode = 43 then lines400;
        end;
    28: begin
          point := 14;
          if currentmode = 43 then lines400;
        end;
    30: begin
          point := 13;
          if currentmode = 43 then lines400;
        end;
    43: begin
          point := 8;
          lines350;
        end;
    50: begin
          point := 8;
          if currentmode = 43 then lines400;
        end;
  end;

  re.ax := $1110;
  re.bh := point;                         (* bytes per character *)
  re.bl := 0;                             (* load to block 0 *)
  re.cx := 256;                           (* 256 characters *)
  re.dx := 0;                             (* start with character 0 *)
  re.es := Seg (Fr^);                     (* segment of table *)
  re.bp := Ofs (Fr^);                     (* offset of the table *)
  intr ($10, re);

  FreeMem (Fr, SizeOf (tFr));
  loadfont := true;
End;

End.