Unit EmuCodes;
{$I Sys75.INC}
{$D-,I-,L-,Q-,R-,S-}

Interface

Function aCls: String;
Function Cls: String;
Function Rep (C: Char; B: Byte): String;
Function Attr (A: Byte): String;
Function Cup: String;
Function Cdn: String;
Function Clt: String;
Function Crit: String;
Function Clr2Eol: String;
Function Clr2Sol: String;
Function aGoXY (Row, Col: Byte): String;
Function GoXY (Row, Col: Byte): String;
Function InsertOn: String;
Function ScrollUp (Num, Upper, Left, Lower, Right: Byte): String;
Function ScrollDown (Num, Upper, Left, Lower, Right: Byte): String;
Function ClearSetArea (Attr, Lines, Columns: Byte): String;
Function InitArea (Attr, Lines, Columns: Byte; CH: Char): String;
Function RepPattern (NumChars, Times: Byte; Str: String): String;
Function InsLine (Num: Byte): String;
Function DelLine (Num: Byte): String;
Function InsChar (Num: Byte): String;
Function DelChar (Num: Byte): String;
Function AnsA (A, z: Byte): String;

Implementation

Uses
  TotFast, TotStr,
  RemEmu, Users,
  crt, Spuds;

Const
  aBlink    : Byte =  16;

  aSt       : String [2] = #27'[';
  aEnd      : String [1] = 'm';
  aDef      : String [4] = #27'[0m';

  fgCol     : Array [0..31] Of String [8] =
  ('0;30',   '0;34',   '0;32',   '0;36',
  '0;31',   '0;35',   '0;33',   '0;37',
  '0;1;30', '0;1;34', '0;1;32', '0;1;36',
  '0;1;31', '0;1;35', '0;1;33', '0;1;37',
  '0;5;30', '0;5;34', '0;5;32', '0;5;36',
  '0;5;31', '0;5;35', '0;5;33', '0;5;37',
  '0;1;5;30', '0;1;5;34', '0;1;5;32', '0;1;5;36',
  '0;1;5;31', '0;1;5;35', '0;1;5;33', '0;1;5;37');

  bgCol     : Array [0..7] Of String [4] =
  (';40',   ';44',   ';42',   ';46',   ';41',   ';45',   ';43',   ';47');

Function aCls: String;
Begin
  aCls := #27'[2J';
End;

Function Cls: String;
Begin
  Case highestemu of
    TermANS: Cls := aCls;
    TermTTY,
    TermAvt: Cls := ^L;
  End;
End;

Function Rep (C: Char; B: Byte): String;
Begin
  Case highestemu of
    TermTTY,
    TermANS: Rep := Replicate (B, C);
    TermAVT: Rep := ^Y + C + Chr (B);
  End;
End;

Function AnsA (A, z: Byte): String;
Var
  B: Byte;
  s: string;
Begin
  B := A;
  If A > 127 Then Dec (A, 128);
  If B > 127 Then
    s := fgCol [fattr (a) + 16]
  Else
    s := fgCol [fattr (A)];
  if battr (z) <> battr (a) then s := s + bgCol [battr (a)];
  ansa := aSt + s + aEnd;
End;

Function Attr (A: Byte): String;
Var
  S: String;
  B: Byte;
Begin
  B := A;
  If A > 128 Then Dec (A, 128);
  Case highestemu of
    TermTTY: S := '';
    TermANS: S := AnsA (A, textattr);
    TermAVT: If B > 127 Then
               S := ^V^A + Chr (A) + ^V^B
             Else
               S := ^V^A + Chr (A);
  End;
  Attr := S;
End;

Function Cup: String;
{   <^V> <^C>   -   Move the cursor one line up. Do nothing, if you
                   already are at the top line of the current
                   Window.}
Begin
  Case highestemu of
    TermTTY: CUp := '';
    TermANS: CUp := #27'[A';
    TermAVT: CUp := ^V^C;
  End;
End;

Function Cdn: String;
{   <^V> <^D>   -   Move the cursor one line down. Do nothing if you
                   already are at the bottom line of the current
                   Window.}
Begin
  Case highestemu of
    TermTTY: CDn := '';
    TermANS: CDn := #27'[B';
    TermAVT: CDn := ^V^D;
  End;
End;

Function Clt: String;
{   <^V> <^E>   -   Move the cursor one column to the left. Do nothing
                   if you already are at the leftmost column of the
                   current Window.}
Begin
  Case highestemu of
    TermTTY: CLt := '';
    TermANS: CLt := #27'[D';
    TermAVT: CLt := ^V^E;
  End;
End;

Function Crit: String;
{   <^V> <^F>   -   Move the cursor one column to the right. Do nothing
                   if you already are at the rightmost column of the
                   current Window.}
Begin
  Case highestemu of
    TermTTY: CRit := '';
    TermANS: CRit := #27'[C';
    TermAVT: CRit := ^V^F;
  End;
End;

Function Clr2Eol: String;
Begin
  Case highestemu of
    TermTTY: Clr2Eol := '';
    TermANS: Clr2Eol := #27'[K';
    TermAVT: Clr2Eol := ^V^G;
  End;
End;

Function Clr2Sol: String;
Begin
  Case highestemu of
    TermTTY: Clr2Sol := '';
    TermANS,
    TermAVT: Clr2Sol := #27'[1J';
  End;
End;

Function aGoXY (Row, Col: Byte): String;
Begin
  aGoXy := #27'[' + IntToStr (Col) + ';' + IntToStr (Row) + 'H';
End;

Function GoXY (Row, Col: Byte): String;
Var
  S: String;
Begin
  Case highestemu of
    TermTTY: S := '';
    TermANS: S := aGoXy (Row, Col);
    TermAVT: S := ^V^H + Chr (Col) + Chr (Row);
  End;
  GoXY := S;
End;

Function InsertOn: String;
Begin
  Case highestemu of
    TermTTY,
    TermANS: InsertOn := '';
    TermAVT: InsertOn := ^V^I;
  End;
End;

Function ScrollUp (Num, Upper, Left, Lower, Right: Byte): String;
{   <^V><^J><numlines><upper><left><lower><right> - scroll area up;}
Var
  S: String;
Begin
  Case highestemu of
    TermTTY,
    TermANS: S := '';
    TermAVT: S := ^V^J + Chr (Num) + Chr (Upper) + Chr (Left) + Chr (Lower) + Chr (Right);
  End;
  ScrollUp := S;
End;

Function ScrollDown (Num, Upper, Left, Lower, Right: Byte): String;
{   <^V><^K><numlines><upper><left><lower><right> - scroll area down;}
Var
  S: String;
Begin
  Case highestemu of
    TermTTY,
    TermANS: S := '';
    TermAVT: S := ^V^K + Chr (Num) + Chr (Upper) + Chr (Left) + Chr (Lower) + Chr (Right);
  End;
  ScrollDown := S;
End;

Function ClearSetArea (Attr, Lines, Columns: Byte): String;
{   <^V><^L><attr><lines><columns>  - clear area, set attribute;}
Var
  S: String;
Begin
  Case highestemu of
    TermTTY,
    TermANS: S := '';
    TermAVT: S := ^V^L + Chr (Attr) + Chr (Lines) + Chr (Columns);
  End;
  ClearSetArea := S;
End;

Function InitArea (Attr, Lines, Columns: Byte; CH: Char): String;
{   <^V><^M><attr><Char><lines><columns>  - initialize area, set attribute;}
Var
  S: String;
Begin
  Case highestemu of
    TermTTY,
    TermANS: S := '';
    TermAVT: S := ^V^M + Chr (Attr) + Chr (Lines) + Chr (Columns);
  End;
  InitArea := S;
End;

Function RepPattern (NumChars, Times: Byte; Str: String): String;
{   <^V><^Y><numChars><Char>[...]<count>  -  Repeat pattern.}
Var
  B: Byte;
  T: String;
Begin
  T := '';
  Case highestemu of
    TermTTY,
    TermANS: Begin
               For B := 1 To Times Do
                 T := T + Str;
               RepPattern := T;
             End;
    TermAVT: RepPattern := ^V^Y + Chr (NumChars) + Str + Chr (Times);
  End;
End;

Function InsLine (Num: Byte): String;
Begin
  Case highestemu of
    TermTTY: InsLine := '';
    TermANS,
    TermAVT: InsLine := #27'[' + IntToStr (Num) + 'L';
  End;
End;

Function DelLine (Num: Byte): String;
Begin
  Case highestemu of
    TermTTY: DelLine := '';
    TermANS,
    TermAVT: DelLine := #27'[' + IntToStr (Num) + 'M';
  End;
End;

Function InsChar (Num: Byte): String;
Begin
  Case highestemu of
    TermTTY: InsChar := '';
    TermANS,
    TermAVT: InsChar := #27'[' + IntToStr (Num) + '@';
  End;
End;

Function DelChar (Num: Byte): String;
Begin
  Case highestemu of
    TermTTY: DelChar := '';
    TermANS,
    TermAVT: DelChar := #27'[' + IntToStr (Num) + 'P';
  End;
End;

End.