Unit Emu;
{$I Sys75.INC}
{$O-,F-}
{$D-,I-,L-,Q-,R-,S-}

Interface

Uses Spuds;

Procedure InitEmuVars;
Procedure InitEmulation;
Procedure InitParser;
Procedure ParseStr (Str: String);
Procedure SetColor (C: Byte);
Procedure SetScreenSize (X1, Y1, X2, Y2: Byte);
Procedure UpdateCursor (X1, Y1: Integer);
Procedure ClrScreen (B: Byte);
Procedure BadCode;
Procedure AddChar (C: Char);
Procedure ParseCh (C: Char);

var
  _x, _y: Byte;
  Sx1, Sx2, Sy1, Sy2: Byte;

const
  UsingRip: Boolean = False;
  ParseThatTitty: Boolean = True;
  Scrolled: Byte = 0;
  TTYPauser: Byte = 0;
  TTYPause: Boolean = False;
  nonstop: boolean = false;


Implementation

Uses
  Crt,
  TotFast, totstr,
  oocom,
  ScrSave, ScrBack, Multi, RemEmu, Misc, users, comm, fonts;

Type
  tParseMode = (ParseTTY, ParseANS, ParseAVT, ParseRIP, parserep, parsearep);
  ParserType = (GotEscape, GotBracket, GotSemiColon, GotParm, GotCommand);

Const
  Insert: Boolean = False;
  Esc = ^[;
  DLE = ^P;
  FS = #28;
  GS = #29;
  RS = #30;
  US = #31;
  SP = #32;

  Escape = #27;
  LeftBracket = #91;
  Semicolon = #59;
  EqualSign = #61;

  Inverse : Boolean = False;
  Intense : Boolean = False;
  Blink   : Boolean = False;

  SaveX : Byte = 1;
  SaveY : Byte = 1;
  MaxParms = 5;

Var
  RepCnt,
  RepNum: Byte;
  RepStr: String;

  Parms : Array [1..MaxParms] of String [5];
  ParmInt : Array [1..MaxParms] of Integer;
  ParmDefault : Array [1..MaxParms] of Boolean;
  ParmIndex : Byte;

  ParserState : ParserType;

  pBufCnt: Byte;
  ParseMode: tParseMode;
  ProtectBuf: Array [1..255] of Char;

Procedure InitEmulation;
Begin
  SetScreenSize (1, 1, 80, currentmode);
  UpdateCursor (1, 1);
  SetColor (7);
  InitParser;
End;

Procedure InitEmuVars;
Begin
  Sx1 := 1;
  Sy1 := 1;
  Sx2 := 80;
  Sy2 := currentmode;
  _x := 1;
  _y := 1;
  InitParser;
End;

Procedure WriteChar (C: Char);
Begin
  If ScrBackInst And (_y = Sy2) And ((C = ^J) Or ((_x = Sx2) and (c <> ^M))) Then begin
    Scroll^. AddLine (1, True);
    if scrolled < 255 then inc (scrolled);
  end;

  if not vinscrsave then
    if (c = ^G) and not b (vtoggles, 4) then
    else
      Write (C);

  If TTYPause and not nonstop And (Pause In User. Options) Then Begin
    If (C = ^J) Or ((_x = Sx2) and (c <> ^M)) Then Begin
      inc (ttypauser);
      if ttypauser >= curpagelen then begin
        ttypauser := 1;
        case More (true) of
          mno: InputBroke := true;
          myes: InputBroke := false;
          mcont: nonstop := true;
        End;
      end;
    End;
  End;

  Case C of
    ^J: If _y < Sy2 Then Inc (_y);
    ^M: _x := 1;
    Else If _x < Sx2 Then Inc (_x)
      Else Begin
        _x := 1;
        If _y < Sy2 Then Inc (_y);
      End;
  End;
End;

Procedure SetColor (C: Byte);
Begin
  TextAttr := C;
End;

Procedure SetScreenSize (X1, Y1, X2, Y2: Byte);
Begin
  Sx1 := X1;
  Sy1 := Y1;
  Sx2 := X2;
  Sy2 := Y2;
  Crt. Window (x1, y1, x2, y2);
  crt. windmin := pred (y1) shl 8 + pred (x1);
  crt. windmax := pred (y2) shl 8 + pred (x2);
End;

Procedure UpdateCursor (X1, Y1 : Integer);
Begin
  If X1 < Sx1 Then _x := Sx1 Else If X1 > Sx2 Then _x := Sx2 Else _x := X1;
  If Y1 < Sy1 Then _y := Sy1 Else If Y1 > Sy2 Then _y := Sy2 Else _y := Y1;
{  if scrbackrunnin then
    scroll^. Ss^. GotoXY (_x, _y)
  else
 }   Screen^. GotoXY (_x, _y);
End;

Procedure ClrScreen (B: Byte);
Var
  Q, Z: Byte;
Begin
  If ScrBackInst Then Begin
    Q := FindBottomLine;
    If Q <> sy2 Then Inc (Q);
    For Z := 1 to Q do
      Scroll^. AddLine (Z, True);
  End;
  Screen^. PartClear (Sx1, Sy1, Sx2, Sy2, 0, ' ');
  UpdateCursor (Sx1, Sy1);
  SetColor (B);
  Screen^. Attrib (Sx1, Sy1, Sx2, Sy2, B);
  If Q = sy2 Then Scroll^. AddLine (q, True);
  ttypauser := 1;
End;

Procedure AddChar (C: Char);
Begin
  If pBufCnt = 255 Then Exit;
  Inc (pBufCnt);
  ProtectBuf [pBufCnt] := C;
End;

Procedure BadCode;
Var
  B: Byte;
Begin
  For B := 1 To pBufCnt Do
    writechar (ProtectBuf [B]);
  InitParser;
End;

Procedure InitParser;
Var
  I : Byte;
Begin
  nonstop := false;
  pBufCnt := 0;
  ParseMode := ParseTTY;
  ParseThatTitty := True;
  ParmIndex := 1;
  For I := 1 To MaxParms Do Begin
    Parms [I] := '';
    ParmDefault [I] := False;
  End;
  ParserState := GotEscape;
End;

Procedure ParseStr (Str : String);
Var
  B : Byte;
Begin
  For B := 1 To Length (Str) Do
    ParseCh (Str [B]);
End;

Procedure ConvertParms;
Var
  I, Code : Integer;
Begin
  For I := 1 To MaxParms Do Begin
    Val (Parms [I], ParmInt [I], Code);
    If Code <> 0 Then Begin
      ParmInt [I] := 1;
      ParmDefault [I] := True;
    End;
  End;
End;

var
  B, I, TextFg, TextBk : Byte;

Procedure ParseCh (C: Char);
label
  AnsiErrorExit;
Begin
  case parsemode of
    parseans:
      begin
        AddChar (C);

        Case ParserState of
          GotEscape :
                      If C = LeftBracket Then
                        ParserState := GotBracket
                      Else
                        Goto ansiErrorExit;

          GotParm,
          GotBracket,
          GotSemicolon :
                         If (C >= #48) And (C <= #57) Then Begin
                           Parms [ParmIndex] := Parms [ParmIndex] + C;
                           ParserState := GotParm;
                         End Else If C = EqualSign Then
                         Else If C = '?' Then Else
                         If C = Semicolon Then
                           If ParserState = GotSemicolon Then
                             Goto ansiErrorExit
                           Else Begin
                             ParserState := GotSemicolon;
                             Inc (ParmIndex);
                             If ParmIndex > MaxParms Then
                               Goto ansiErrorExit;
                           End
                         Else Begin
                           ConvertParms;
                           Case C Of
                             'm' : Begin
                                     For I := 1 To ParmIndex Do Begin
                                       If Inverse Then
                                         TextAttr := 16 * (TextAttr Mod 16) + (TextAttr Div 16);

                                       TextFg := TextAttr And $0F;
                                       TextBk := TextAttr And $F0;

                                       Case ParmInt [I] Of
                                         0  : Begin
                                                TextAttr := $07;
                                                Inverse := False;
                                                Intense := False;
                                                Blink := False;
                                              End;
                                         1  : Intense  := True;
                                         4  : Intense  := True;
                                         5  : Blink    := True;
                                         7  : Inverse  := True;
                                         8  : TextAttr := $00;
                                         27 : Inverse  := False;
                                         30 : TextAttr := TextBk or $00;
                                         31 : TextAttr := TextBk or $04;
                                         32 : TextAttr := TextBk or $02;
                                         33 : TextAttr := TextBk or $06;
                                         34 : TextAttr := TextBk or $01;
                                         35 : TextAttr := TextBk or $05;
                                         36 : TextAttr := TextBk or $03;
                                         37 : TextAttr := TextBk or $07;
                                         40 : TextAttr := TextFg;
                                         41 : TextAttr := TextFg or $40;
                                         42 : TextAttr := TextFg or $20;
                                         43 : TextAttr := TextFg or $60;
                                         44 : TextAttr := TextFg or $10;
                                         45 : TextAttr := TextFg or $50;
                                         46 : TextAttr := TextFg or $30;
                                         47 : TextAttr := TextFg or $70;
                                       End;

                                       If Inverse Then
                                         TextAttr := 16 * (TextAttr Mod 16) + (TextAttr Div 16);
                                       If Intense Then
                                         TextAttr := TextAttr or $08;
                                       If Blink Then
                                         TextAttr := TextAttr or $80
                                     End;
                                   End;

                             'f',
                             'H' :  UpdateCursor (ParmInt [2], ParmInt [1]);

                             'A' :  UpdateCursor (_X, _Y - ParmInt [1]);

                             'B' :  If (Current <> Terminal) and (_Y + ParmInt [1] > Sy2) Then
                                       For B := 1 to ParmInt [1] do
                                         WriteChar (#10)
                                     Else
                                       UpdateCursor (_X, _Y + ParmInt [1]);

                             'C' : UpdateCursor (_X + ParmInt [1], _Y);

                             'D' : UpdateCursor (_X - ParmInt [1], _Y);

                             'J' : Begin
                                     If ParmDefault [1] Then
                                       ParmInt [1] := 2;
                                     Case ParmInt [1] Of
                                       2 : ClrScreen (TextAttr);
                                       0 : screen^. partclear (_X, _Y, sx2, sy2, TextAttr, ' ');
                                       1 : screen^. partclear (sx1, sy1, _X, _Y, TextAttr, ' ');
                                     End;
                                   End;
                             'L' : Begin
                                     If ParmInt[1] > 0 then For B := 1 to ParmInt [1] do
                                       Screen^. Scroll (Down, Sx1, _y, Sx2, Sy2);
                                     Screen^. PartClear (Sx1, _y, Sx2, _y + Pred (B), TextAttr, ' ');
                                   End;
                             'M' : Begin
                                     If ParmInt[1] > 0 then For B := 1 to ParmInt [1] do
                                       Screen^. Scroll (Up, Sx1, _y, Sx2, Sy2);
                                     Screen^. PartClear (Sx1, Sy2 - B, Sx2, Sy2, TextAttr, ' ');
                                   End;
                             'P' : begin
                                     If ParmDefault [1] Then
                                       ParmInt [1] := 1;
                                     For B := 1 to ParmInt [1] do
                                       Screen^. Scroll(Left, _x + ParmInt [1] - B, _y, Succ (Sx2) - B, _y);
                                     Screen^. PartClear (Succ (Sx2) - B, _y, Sx2, _y, TextAttr, ' ');
                                   end;
                             '@' : begin
                                     If ParmDefault [1] Then
                                       ParmInt [1] := 1;
                                     For B := 1 to ParmInt [1] do
                                       Screen^. Scroll(Right, _x + Pred (B), _y, Sx2 - Pred (ParmInt [1]) + Pred (B), _y);
                                     Screen^. PartClear (_x, _y, Pred (_x + B), _y, TextAttr, ' ');
                                   end;
                             'K' : Begin
                                     If ParmDefault [1] Then
                                       ParmInt [1] := 0;
                                     Case ParmInt [1] Of
                                       0 : screen^. partclear (_X, _Y, sx2, _Y, TextAttr, ' ');
                                       1 : screen^. partclear (sx1, _Y, _X, _Y, TextAttr, ' ');
                                       2 : screen^. partclear (sx1, _Y, sx2, _Y, TextAttr, ' ');
                                     End;
                                   End;

                             'n' : If Not LocalOnly then case ParmInt [1] of
                                     5 : Uart^. PutString (#27'[0n');
                                     6 : Uart^. PutString (#27'[' + IntToStr (_x) + ';' + IntToStr (_x) + 'R');
                                   end;

                             'l',
                             'h' : Begin
                                      Case ParmInt [1] Of
                                       0 : TextMode (BW40);
                                       1 : TextMode (CO40);
                                       2 : TextMode (BW80);
                                       3 : TextMode (CO80);
                                     End;
                                     Case ParmInt [1] Of
                                       0, 1 : sx2 := Pred (sx1 + 40);
                                       2, 3 : sx2 := Pred (sx1 + 80);
                                     End;
                                   End;

                             's' : Begin
                                     SaveX := _X;
                                     SaveY := _Y;
                                   End;
                             'u' : UpdateCursor (SaveX, SaveY);
                             'S' : ;
                             'z' : Uart^. PutString (#27'[' + inttostr (sy2) + 'Z');
                             Else goto ansierrorexit;
                           End;
                           InitParser;
                         End;
        end;
        Exit;
        AnsiErrorExit:
        BadCode;
        InitParser;
      end;
    parseavt:
      Case pBufCnt Of
        1:
          Begin
            Case C Of
              ^B: TextAttr := TextAttr or 128;
              ^C: UpdateCursor (_x, Pred (_y));
              ^D: UpdateCursor (_x, Succ (_y));
              ^E: UpdateCursor (Pred (_x), _y);
              ^F: UpdateCursor (Succ (_x), _y);
              ^G: ClrEol;
              ^I: Insert := True;
              ^N: Begin
                    Screen^. Scroll (Left, _x, _y, Sx2, _y);
                    Screen^. PartClear (Sx2, _y, Sx2, _y, TextAttr, ' ');
                  End;
              Else if pos (c, ^A^Q^L^M^N^Y^H^J^K) <> 0 then Begin
                AddChar (C);
                Exit;
              End else badcode;
            End;
            InitParser;
          End;
        2:
          Begin
            Case ProtectBuf [2] Of
              ^A: TextAttr := Byte (C);
              ^Q: If not LocalOnly then Case C of
                    ^A, ^B: Uart^. PutString (^V^A + Chr (TextAttr));
                    ^H: Uart^. PutString (^V^H + Chr (_y) + Chr (_x));
                    ^Q: Uart^. PutString ('AVT0, System/75, by Maxwell.Spectre Coding.Mistigris'^M);
                    ^V:;      {  --  This  returns  the appropriate  define window  command
                               describing the active window. (ex: ^V^V#0^G^A^A^Y#80)}
                    ^W:;     { -- This command, similar to the last, returns a  set window
                              command to indicate the current window. (ex: ^V^W#0)}
                    #28, #29:; {--  These queries  indicate wether  or not
                                the interpreter is asleep or not.  They return either a  go to
                                sleep or wake up command.  (ex: ^VGS when awake)}
                    #30, #31:; { --  These two  queries return  the current
                                  status of vertical mode for the current window.   As with  all
                                  the queries, they return the avatar command capable of setting
                                   the current mode.}
                    '#', '"' , '$':; { --   Like  the  last  ones,   these  return   the
                                      appropriate command to set the end of line wrap mode.
                                      (none, normal, zigzag).}
                    '%', '&':; { -- These two return the status of  line feeds.
                               (move up or move down).}
                    '(', ')':; { -- These return wether or not we are in reverse mode.}
                    ':':;  {--  This  returns  the  current  keyboard mode  through a
                            command (ex: ^V:0)}
                    '=':; {  --   This  is  an  important  one for  the server  to pay
                           attention to as the remote terminal  get's the  final decision
                           on wether or not it stays  in cooked  mode.  This  returns the
                           command to set the parser into cooked or raw mode.}
                  End;
              ^L:; {<attr><lines><columns>  - clear area, set attribute;}
              ^M:; {<attr><char><lines><columns>  - initialize area, set attribute;}
              ^N:; {        -  delete character, scroll rest of line left;}
              ^Y: Begin {<numchars><char>[...]<count>  -  repeat pattern.}
                    RepNum := Byte (C);
                    RepCnt := 0;
                    RepStr := '';
                    Parsemode := ParseAREP;
                    Exit;
                  End;
              Else if pos (ProtectBuf [2], ^H^J^K) <> 0 then Begin
                AddChar (C);
                Exit;
              End else badcode;
            End;
            InitParser;
          End;
        3:
          Begin
            Case ProtectBuf [2] Of
              ^H: UpdateCursor (Byte (C), Byte (ProtectBuf [3]))
              Else if pos (ProtectBuf [2], ^J^K) <> 0 then Begin
                AddChar (C);
                Exit;
              End else badcode;
            End;
            InitParser;
          End;
        4:
          Begin
            Case ProtectBuf [2] Of
              #0: ;
              Else if pos (ProtectBuf [2], ^J^K) <> 0 then Begin
                AddChar (C);
                Exit;
              End else badcode;
            End;
            InitParser;
          End;
        5:
          Begin
            Case ProtectBuf [2] Of
              #0: ;
              Else if pos (ProtectBuf [2], ^J^K) <> 0 then Begin
                AddChar (C);
                Exit;
              End else badcode;
            End;
            InitParser;
          End;
        6:
          Begin
            Case ProtectBuf [2] Of
              #0: ;
              ^J:{<numlines><upper><left><lower><right> - scroll area up;}
                for b := 1 to byte (protectbuf [3]) do begin
                  Screen^. Scroll (up, byte (protectbuf [5]), byte (protectbuf [4]), byte (c), byte (protectbuf [6]));
                  Screen^. PartClear (byte (protectbuf [5]), byte (protectbuf [6]), byte (c), byte (protectbuf [6]), TextAttr,
                           ' ');
                end;
              ^K:{<numlines><upper><left><lower><right> - scroll area down;}
                for b := 1 to byte (protectbuf [3]) do begin
                  Screen^. Scroll (down, byte (protectbuf [5]), byte (protectbuf [4]), byte (c), byte (protectbuf [6]));
                  Screen^. PartClear (byte (protectbuf [5]), byte (protectbuf [4]), byte (c), byte (protectbuf [4]), TextAttr,
                           ' ');
                end;
              Else badcode;
            End;
            InitParser;
          End;
      end;
    parsetty:
      Case C Of
        ^H: UpdateCursor (Pred (_x), _y);
        ^I: UpdateCursor (_x + (80 - _x) Mod 8, _y);
        ^L: ClrScreen (TextAttr);
        ^Y: Begin
              ParseMode := ParseRep;
              ParseThatTitty := False;
            End;
        ^[: Begin
              ParseMode := ParseAns;
              AddChar (^[);
              ParseThatTitty := False;
            End;
        ^V: Begin
              ParseMode := ParseAvt;
              AddChar (^V);
              ParseThatTitty := False;
            End;
        Else WriteChar (C);
      end;
    parserip:
      begin
      end;
    parserep:
      begin
        If pBufCnt = 0 Then
          AddChar (C)
        Else Begin
          For B := 1 To Byte (C) Do
            WriteChar (ProtectBuf [1]);
          InitParser;
        End;
      end;
    parsearep:
      begin
        If RepCnt = RepNum Then Begin
          For B := 1 to Byte (C) do
            For I := 1 to Length (RepStr) do
              WriteChar (RepStr [I]);
          InitParser;
          RepCnt := 0;
          RepNum := 0;
          RepStr := '';
        End Else If RepCnt < RepNum Then Begin
          Inc (RepCnt);
          Inc (RepStr [0]);
          RepStr [RepCnt] := C;
        End;
      end;
  end;
End;

Begin
  InitParser;
End.