Unit DumbTerm;
{$I Sys75.INC}
{$D-,I-,L-,Q-,R-,S-}

Interface

Uses
  TotFast;

Type
  pTermObj = ^TermObj;
  TermObj = Object
              Constructor Init;
              Procedure   StatusBar (First: Boolean);
              Procedure   Run;
              Procedure   HangUp;
              procedure   help;
              Procedure   SetScrPtr (P: pScreenObj);
              Destructor  Done;
              Public
                SavIn, SavOut: Word;
                AllowIdle: Boolean;
                OldRts, OldDtr: Boolean;
                SaveMem: LongInt;
              Private
                ScrPtr: pScreenObj;
            End;

Var
  Term: pTermObj;

Implementation

Uses
  Crt, Spuds, Hookers,
  TotMisc, TotInput, TotKey, TotStr, TotWin, TotSys, TotDate,
  ApPort, OoModem, OoCom,
  Emu, Fonts, Clocks, ScrSave, ScrBack, Misc, Protocols;

Constructor TermObj. Init;
Begin
  AllowIdle := True;
End;

Procedure TermObj. StatusBar (First: Boolean);
Var
  S: String;
  Dtr, Rts: Boolean;
Begin
  Clock^. DispLoop;

  With ScrPtr^ do Begin
    SetWinIgnore (True);

    If First Then Begin
      PartClear (1, Monitor^. Depth, 80, Monitor^. Depth, $17, ' ');
      With NodeData do
        WritePlain (27, Monitor^. Depth, ' ' + ComNameString (Port) + ' ' + IntToStr (Baud) +
                             ' ' + IntToStr (Data) + ParityChar [Parity] + IntToStr (Stop));
      WritePlain (70, Monitor^. Depth, '');
      WritePlain (45, Monitor^. Depth, ' hit f1 4 help ');
      SaveMem := Succ (MemAvail);
    End;

    If SaveMem <> MemAvail Then Begin
      WritePlain (61, Monitor^. Depth, ' ' + IntToStr (MemAvail));
      SaveMem := MemAvail;
    End;

    If First Or Uart^. CheckDeltaDSR Then If Uart^. CheckDSR Then
      WritePlain (2, Monitor^. Depth, 'DSR')
    Else
      WritePlain (2, Monitor^. Depth, 'dsr');

    Uart^. GetModem (Dtr, Rts);

    If First Or (Dtr <> OldDtr) Then Begin
      If Dtr Then
        WritePlain (5, Monitor^. Depth, 'DTR')
      Else
        WritePlain (5, Monitor^. Depth, 'dtr');
      OldDtr := Dtr;
    End;

    If First Or Uart^. CheckDeltaCTS Then If Uart^. CheckCTS Then
      WritePlain (9, Monitor^. Depth, 'CTS')
    Else
      WritePlain (9, Monitor^. Depth, 'cts');

    If First Or (Rts <> OldRts) Then Begin
      If Rts Then
        WritePlain (12, Monitor^. Depth, 'RTS')
      Else
        WritePlain (12, Monitor^. Depth, 'rts');
      OldRts := Rts;
    End;

    If First Or Uart^. CheckDeltaDCD Then If Uart^. CheckDCD Then
      WritePlain (16, Monitor^. Depth, 'CD')
    Else
      WritePlain (16, Monitor^. Depth, 'cd');

    If First Or (Uart^. InBuffUsed <> Term^. SavIn) Then Begin
      If Uart^. InBuffUsed <> 0 Then
        WritePlain (19, Monitor^. Depth, 'RD')
      Else
        WritePlain (19, Monitor^. Depth, 'rd');
      Term^. SavIn := Uart^. InBuffUsed;
    End;

    If First Or (Uart^. OutBuffUsed <> Term^. SavOut) Then Begin
      If Uart^. OutBuffUsed <> 0 Then
        WritePlain (21, Monitor^. Depth, 'SD')
      Else
        WritePlain (21, Monitor^. Depth, 'sd');
      Term^. SavOut := Uart^. OutBuffUsed;
    End;

    If First Or Uart^. CheckDeltaRI Then If Uart^. CheckRI Then
      WritePlain (24, Monitor^. Depth, 'RI')
    Else
      WritePlain (24, Monitor^. Depth, 'ri');

    SetWinIgnore (False);
  End;
End;

Procedure TermObj. HangUp;
Var
  W: pWinObj;
Begin
  Screen^. EnableHighBgd;
  Screen^. CursOff;
  New (W, Init);
  If W <> Nil Then Begin
    W^. SetSize (29, 10, 50, 14, 2);
    W^. SetClose (False);
    W^. Draw;
    Screen^. WritePlain (3, 2, 'Dropping Carrier');
  End;
  iDelay (250);
  Modem^. HangUpModem (mHangUp, True);
  iDelay (250);
  If W <> Nil Then Dispose (W, Done);
  Screen^. DisableHighBgd;
  Screen^. CursOn;
End;

Procedure TermObj. Help;
Var
  W: pWinObj;
Begin
  New (W, Init);
  If W = Nil Then exit;
  Screen^. EnableHighBgd;
  Screen^. CursOff;
  with w^ do begin
    SetSize (28, 8, 50, 17, 2);
    settitle (' Terminal Help ');
    SetClose (False);
    Draw;
  end;

  Screen^. WritePlain (3, 2, 'Alt-Q: Quit');
  Screen^. WritePlain (3, 3, 'Alt-H: Hang up');
  Screen^. WritePlain (3, 4, 'Alt-J: Dos Shell');
  Screen^. WritePlain (3, 5, 'Alt-C: Clear');
  Screen^. WritePlain (3, 6, 'Alt-S: Scrollback');
  Screen^. WritePlain (3, 7, 'PgUp : Upload');
  Screen^. WritePlain (3, 8, 'PgDn : Download');
  key^. getkey;
  Dispose (W, Done);
  Screen^. DisableHighBgd;
  Screen^. CursOn;
End;

Procedure TermObj. Run;
Const
  zmHdr = 'rz'#13'**'#24;
Var
  I: Char;
  O: Word;
  zmNdx: Byte;
Begin
  Current := Terminal;
  If ExDispMode Then Setmode (28, false);
  Screen^. DisableHighBgd;
  Screen^. Clear (7, ' ');

  If Not Uart^. CheckDCD Then Begin
    Screen^. WriteAt (1, 1, 9, 'You are now in Terminal Mode.');
    Screen^. WriteAt (1, 2, 1, Replicate (80, #22));
  End;

  If ExDispMode Then Begin
    Screen^. WriteAt (1, 26, 1, Replicate (80, ''));
    Screen^. Attrib (1, 27, 80, Monitor^. Depth, 23);
    Screen^. WriteHi (1, 27, 23, 31, ' Alt~+  ~Q~uit  ~C~lear  ~H~ang up  ~J~ Dos Shell  ~S~croll  ~PgUp~ Upload  ~PgDn~' +
                      ' Download ');
    Screen^. WriteAt (79, 27, $19, ^B);
  End;

  SetScrPtr (Screen);
  ResumeXfer := true;

  Clock^. Change (72, Monitor^. Depth, 23);
  Clock^. Show (True);
  InitEmulation;
  If ExDispMode Then
    SetScreenSize (1, 1, 80, 25)
  else
    SetScreenSize (1, 1, 80, 24);
  UpdateCursor (1, 3);
  Screen^. CursOn;
  Key^. AssignIdleHook (TermIdle);
  Key^. AssignPressedHook (TermPressed);
  StatusBar (True);
  zmNdx := 0;

  Repeat
    If Uart^. CharReady Then Begin
      Uart^. GetChar (I);
      If CheckForString (zmNdx, I, zmHdr, False) Then Begin
        With Proto^ do Begin
          ForceProto (pZmodem);
          DownLoad;
        End;
      End Else ParseCh (I);
    End;

    Key^. vIdleHook;

    If Key^. KeyPressed Then Begin
      O := Key^. GetKey;
      Case O Of
        0: ;
        kUp:   Uart^. PutString (^['[A');
        kDown: Uart^. PutString (^['[B');
        kRight:Uart^. PutString (^['[C');
        kLeft: Uart^. PutString (^['[D');
        kHome: Uart^. PutString (^['[H');
        kEnd:  Uart^. PutString (^['[K');
        kIns:  Uart^. PutChar (^V);
        kDel:  Uart^. PutChar ('');
        kF1:   help;
        kF2:;
        kF3:;
        kF4:;
        kF5:;
        kF6:;
        kF7:;
        kF8:;
        kF9:;
        kF10:;
        kPgUp: Proto^. Upload;
        kPgDn: Proto^. Download;
        kAltA:;
        kAltB:;
        kAltC: ClrScreen (7);
        kAltD:;
        kAltE:;
        kAltF:;
        kAltG:;
        kAltH: HangUp;
        kAltI:;
        kAltK:;
        kAltL:;
        kAltM:;
        kAltN:;
        kAltO:;
        kAltP:;
        kAltQ: Break;
        kAltR:;
        kAltS: Scroll^. Run;
        kAltT:;
        kAltU:;
        kAltV:;
        kAltW:;
        kAltX:;
        kAltY:;
        kAltZ:;
        Else begin
          i := Key^. LastChar;
          if i <> #0 then Uart^. PutChar (i);
        end;
      End;
    End;
  Until False;

  If ExDispMode Then Setmode (25, false);
End;

Procedure TermObj. SetScrPtr (P: pScreenObj);
Begin
  ScrPtr := P;
End;

Destructor TermObj. Done;
Begin
End;

End.
