Unit Comm;
{$I Sys75.INC}

Interface

Uses
  Spuds,
  TotFast;

Type
  Str15 = String [15];
  Str8  = String [8];

Function  ReadInputNW: Word;
Function  ReadInput: Word;
Function  ReadArrow: Word;
Function  ReadInChar: Char;

Procedure GetStr (Len: Byte; Box, Chart: Boolean; Var S: String);
Procedure GetCapStr (Len: Byte; Cap: Char; Box, Chart: Boolean; Var S: String);
Procedure GetLimitStr (Box, Chart: Boolean; Len: Byte; Limit: String; Var S: String);
Procedure GetPwStr (ex: byte; Box, Echo: Boolean; Var S: PwStr);
Procedure GetArrowStr (Len: Byte; Var S: String);
Procedure GetCoolStr (Len: Byte; Var S: String);
Procedure GetPhoneStr (box: boolean; Var S: Str15);
Procedure GetDateStr (box: boolean; Var S: Str8);
Procedure GetHotKeyInput (T, Len: Byte; Var S: String; Echo: Boolean);
Function  LiteBar (lb: LiteBarType; Quit, riteln: Boolean): LiteBarType;
Function  LiteString (P, S: String; q: Byte): Byte;
Procedure PressEnter;
Function  More (cont: boolean): moretype;
Procedure SetInputTimeOut (W, C: Word);
Procedure GetRange (P: Str80; Box: Boolean; LoRange, HiRange, LoDef, HiDef, NullDef: LongInt; Var Low, High: LongInt);
Function  GetNumStr (Def, Box: Boolean; LoRange, HiRange, LoDef, HiDef, NullDef, Num: LongInt): LongInt;
Function  GetQNumStr(Def, Box: Boolean; LoRange, HiRange, LoDef, HiDef, NullDef,Num:LongInt;var qdef:byte;qs:string):LongInt;

Const
  InLock: Boolean = False;
  ClearFirst: Boolean = False;
  LocalOnly: Boolean = True;
  InsertMode: Boolean = True;
  commandcount: byte = 0;

Implementation

Uses
  Crt,
  OoCom,
  TotInput, TotKey, TotStr, TotSys, TotMisc,
  Emu, Users, RemEmu, EmuCodes, StatusBar, Multi, Misc;

Const
  InputTimeOut: Word = 0;
  TimeOutChar: Word = 27;

Procedure SetInputTimeOut (W, C: Word);
Begin
  InputTimeOut := W;
  TimeOutChar := C;
End;

Function ReadInputNW: Word;
Var
  I: Char;
  W: Word;
Begin
  Key^. vIdleHook;
  If hung Then Exit;
  If MacroStr <> '' Then Begin
    W := Ord (MacroStr [1]);
    Delete (MacroStr, 1, 1);
  End Else If Not LocalOnly And OnLine And Not InLock And Uart^. CharReady Then Begin
    Uart^. GetChar (I);
    W := Ord (I);
  End Else If Key^. KeyPressed Then
    W := Key^. GetKey
  Else
    W := 256;

  if hung then exit;
  if W <> 256 then NoKbdPress := 0;
  ReadInputNW := W;
  if online then begin
    if (w = 18) and not outlock then refresh;
    if w = commandchar then inc (commandcount);
    if commandcount = 2 then begin
      uart^. putstringtimeout (#8 + chr (commandchar), 540);
      inc (commandcount);
    end;
    if commandcount = 4 then commandcount := 0;
  end;
  if multitasker <> windows then GiveTimeSlice;
End;

Function ReadInput: Word;
Var
  W: Word;
  L: LongInt;
Begin
  L := BiosTime;
  w := 0;
  Repeat
    W := ReadInputNW;
    If hung Then Exit;
  Until (W <> 256) or ((InputTimeOut > 0) and (Et (L) >= InputTimeOut));

  If (InputTimeOut > 0) And (W = 256) Then W := TimeOutChar;
  ReadInput := W;
  InputTimeOut := 0;
End;

Function ReadArrow: Word;
Var
  I: Char;
  W: Word;
  L: LongInt;
Begin
  w := 0;
  Repeat
    W := ReadInput;
    If Hung Then Exit;

    Case Lo (W) of
      22:
          Begin
            W := kIns;
            Break;
          End;
      19:
          Begin
            W := kLeft;
            Break;
          End;
      4:
          Begin
            W := kRight;
            Break;
          End;
      7:
          Begin
            W := kDel;
            Break;
          End;
      23:
          Begin
            W := kHome;
            Break;
          End;
      16:
          Begin
            W := kEnd;
            Break;
          End;
      5:
          Begin
            W := kUp;
            Break;
          End;
      24:
          Begin
            W := kDown;
            Break;
          End;
      127:
          Begin
            W := kDel;
            Break;
          End;
      27:
          Begin
            L := BiosTime;

            Repeat
              W := ReadInputNW;
              If hung Then Exit;
            Until (W <> 256) Or (Et (L) = 9);

            If W = 256 Then Begin
              W := 27;
              Break;
            End;

            If W <> Ord ('[') Then Break;

            W := ReadInput;
            If Hung Then Exit;

            Case W of
              kSftA: W := kUp;
              kSftB: W := kDown;
              kSftC: W := kRight;
              kSftD: W := kLeft;
              kSftH: W := kHome;
              kSftK: W := kEnd;
              Else Break;
            End;

            Break;
         End;
      0:
         Begin
            W := ReadInput;
            If Hung Then Exit;

            Case W of
              kSftH: W := kUp;
              kSftP: W := kDown;
              kSftM: W := kRight;
              kSftK: W := kLeft;
              kSftG: W := kHome;
              kSftO: W := kEnd;
              kSftR: W := kIns;
              kSftS: W := kDel;
              Else Break;
            End;

            Break;
         End;
      Else Break;
    End;
  Until Hung;

  ReadArrow := W;
End;

Function GetArrow: Word;
Var
  W: Word;
Begin
  W := ReadArrow;
  if hung then exit;
  If lo (W) In [37, 124] Then ComWrite (Chr (Lo (W)));
  GetArrow := W;
End;

Procedure GetStr (Len: Byte; Box, Chart: Boolean; Var S: String);
Var
  I: Word;
  bc, C: Char;
  a, P: Byte;
  ps: String;
  sx, fx, t2: xy;
Begin
  If Len > 254 then len := 254;
  ps := S;
  S := '';
  P := 1;
  getxy (fx);

  If Box Then Begin
    bc := uc. boxchar;
    a := textattr;
    GetXy (t2);
    ComWrite ('|UX' + Rep (bc, Len));
    PutXy (t2);
  End Else bc := ' ';

  Repeat
    if MacroStr <> '' then begin
      I := Ord (MacroStr [1]);
      Delete (MacroStr, 1, 1);
    end else If ps <> '' Then Begin
      I := Ord (ps [1]);
      Delete (ps, 1, 1);
    end else begin
      I := ReadArrow;
      if clearfirst and (i > 31) and (i < 256) then begin
        clearfirst := false;
        putxy (fx);
        send (rep (' ', length (s)));
        putxy (fx);
        s := '';
        p := 1;
      end;
    end;
    If hung Then Exit;

    C := Chr (Lo (I));

    Case I of
      0, 256:;
      1..7:;
      8: If P <> 1 Then Begin
           clearfirst := false;
           If P = Succ (Length (S)) Then Begin
             Dec (S [0]);
             If _x = 1 then
               send (GoXy (80, pred (_y)) + bc + GoXy (80, pred (_y)))
             else
               send (#8 + bc + #8);
           End Else Begin
             Delete (S, Pred (P), 1);
             If _x = 1 then
               send (GoXy (80, pred (_y)))
             else
               send (#8);
             getxy (sx);
             Send (Copy (S, Pred (P), 255) + bc);
             putxy (sx);
           End;
           Dec (P);
         End;
      9..12:;
      13: Break;
      kCtlU: If Chart Then Begin
               ps := ps + ASCii;
               If hung then exit;
               Continue;
             End;
      24: begin
            putxy (fx);
            send (rep (' ', length (s)));
            putxy (fx);
            s := '';
            p := 1;
          end;
      14..31:;
      kLeft: If P <> 1 Then Begin
               clearfirst := false;
               If _x = 1 then
                 Send (GoXy (80, pred (_y)))
               else
                 Send (GoXy (Pred (_x), _y));
               Dec (P);
             End;
      kRight:If P <= Length (S) Then Begin
               clearfirst := false;
               If _x = 80 then
                 Send (GoXy (1, succ (_y)))
               else
                 Send (GoXy (Succ (_x), _y));
               Inc (P);
             End;
      kHome:
             Begin
               clearfirst := false;
               P := 1;
               putxy (fx);
             End;
      kEnd:
             Begin
               clearfirst := false;
               P := Succ (Length (S));
               with fx do
                 if p < sx2 - x then
                   Send (GoXy (x + pred (p), y))
                 else
                   send (goxy (x + pred (p) mod sx2, y + pred (p) div sx2));
             End;
      kIns: InsertMode := Not InsertMode;
      kDel: If P <> Succ (Length (S)) Then Begin
              Delete (S, P, 1);
              getxy (sx);
              Send (Copy (S, P, 255) + bc);
              putxy (sx);
            End;
      Else If I < 256 Then Begin
        If InsertMode Then Begin
          If Length (S) >= Len Then Continue;
          getxy (sx);
          if _x = 80 then begin
            sx. x := 1;
            inc (sx. y);
          end else inc (sx. x);
          Send (C + Copy (S, P, 255));
          S := Copy (S, 1, Pred (P)) + C + Copy (S, P, 255);
          If P <> Length (S) Then
            putxy (sx);
        End Else Begin
          If P > Len Then Continue;
          Send (C);
          S [P] := C;
          If P = Succ (Length (S)) Then Inc (S [0]);
        End;
        Inc (P);
      End;
    End;
  Until Hung;
  If Box Then begin
    sendcolor (a);
    PutXy (t2);
    send (PadLeft (S, Len, ' '));
    PutXy (t2);
  end;
  clearfirst := false;
End;

Procedure GetCapStr (Len: Byte; Cap: Char; Box, Chart: Boolean; Var S: String);
Var
  I: Word;
  bc, C: Char;
  a, sy, sx, P: Byte;
  ps: String;
  fx, t2: xy;
Begin
  If Len > 254 then len := 254;
  ps := S;
  S := '';
  P := 1;
  getxy (fx);

  If Box Then Begin
    a := textattr;
    bc := uc. boxchar;
    ComWrite ('|UX' + Rep (uc. boxchar, Len));
    PutXy (fx);
  End Else bc := ' ';

  Repeat
    if MacroStr <> '' then begin
      I := Ord (MacroStr [1]);
      Delete (MacroStr, 1, 1);
    end else If ps <> '' Then Begin
      I := Ord (ps [1]);
      Delete (ps, 1, 1);
    end else begin
      I := ReadArrow;
      if clearfirst and (i > 31) and (i < 256) then begin
        clearfirst := false;
        putxy (fx);
        send (rep (' ', length (s)));
        putxy (fx);
        s := '';
        p := 1;
      end;
    end;
    If hung Then Exit;

    C := Chr (Lo (I));
    Case Cap of
      'A', 'a': C := uCase (C);
      'N', 'n': C := lCase (C);
      'P', 'p': If (p = 1) Or (S [pred (P)] In [' ', '-']) Then C := uCase (C);
    End;

    Case I of
      kctlf: if allowflagedit then begin
               flagedit;
               If hung then exit;
               Continue;
             end;
      8: If P <> 1 Then Begin
           clearfirst := false;
           If P = Succ (Length (S)) Then Begin
             Dec (S [0]);
             Dec (P);
             If _x = 1 then
               send (GoXy (80, pred (_y)) + bc + GoXy (80, pred (_y)))
             else
               send (#8 + bc + #8);
           End Else Begin
             Dec (P);
             Delete (S, P, 1);
             If _x = 1 then
               send (GoXy (80, pred (_y)))
             else
               send (#8);
             sx := _x;
             If (p = 1) Or (S [pred (P)] In [' ', '-']) Then S [P] := uCase (S [P]);
             Send (Copy (S, P, 255) + bc + GoXy (sx, _y));
           End;
         End;
      13: Break;
      kCtlU: If Chart Then Begin
               ps := ps + ASCii;
               If hung then exit;
               Continue;
             End;
      24: begin
            putxy (fx);
            send (rep (' ', length (s)));
            putxy (fx);
            s := '';
            p := 1;
          end;

      kLeft: If P <> 1 Then Begin
               clearfirst := false;
               If _x = 1 then
                 Send (GoXy (80, pred (_y)))
               else
                 Send (GoXy (Pred (_x), _y));
               Dec (P);
             End;
      kRight:If P <= Length (S) Then Begin
               clearfirst := false;
               If _x = 80 then
                 Send (GoXy (1, succ (_y)))
               else
                 Send (GoXy (Succ (_x), _y));
               Inc (P);
             End;
      kHome:
             Begin
               clearfirst := false;
               P := 1;
               putxy (fx);
             End;
      kEnd:
             Begin
               clearfirst := false;
               P := Succ (Length (S));
               Send (GoXy (Pred (fx. x + P), _y));
             End;
      kIns: InsertMode := Not InsertMode;
      kDel: If P <> Succ (Length (S)) Then Begin
              Delete (S, P, 1);
              sx := _x;
              If (p = 1) Or (S [pred (P)] In [' ', '-']) Then S [P] := uCase (S [P]);
              Send (Copy (S, P, 255) + bc + GoXy (sx, _y));
            End;
      1..31:;
      Else If I < 256 Then Begin
        If InsertMode Then Begin
          If Length (S) >= Len Then Continue;
          sx := Succ (_x);
          sy := _y;
          if _x = 80 then begin
            sx := 1;
            inc (sy);
          end;
          If (Cap = 'P') And (C In ['A'..'Z']) And (S [P] In ['A'..'Z']) Then S [P] := lCase (s [p]);
          Send (C + Copy (S, P, 255));
          S := Copy (S, 1, Pred (P)) + C + Copy (S, P, 255);
          If P <> Length (S) Then
            Send (GoXy (sx, sy));
        End Else Begin
          If P > Len Then Continue;
          Send (C);
          S [P] := C;
          If P = Succ (Length (S)) Then Inc (S [0]);
        End;
        Inc (P);
      End;
    End;
  Until Hung;
  If Box Then begin
    sendcolor (a);
    PutXy (t2);
    send (PadLeft (S, Len, ' '));
    PutXy (t2);
  end;
  clearfirst := false;
End;

Procedure GetLimitStr (Box, Chart: Boolean; Len: Byte; Limit: String; Var S: String);
Var
  I: Word;
  bc, C: Char;
  a, sy, sx, P: Byte;
  ps: String;
  fx, t2: xy;
Begin
  If Len > 254 then len := 254;
  ps := S;
  S := '';
  P := 1;
  getxy (fx);
  limit := setupper (limit);

  If Box Then Begin
    a := textattr;
    bc := uc. boxchar;
    Comwrite ('|UX' + Rep (uc. boxchar, Len));
    PutXy (fx);
  End Else bc := ' ';

  Repeat
    if MacroStr <> '' then begin
      I := Ord (MacroStr [1]);
      Delete (MacroStr, 1, 1);
    end else If ps <> '' Then Begin
      I := Ord (ps [1]);
      Delete (ps, 1, 1);
    end else begin
      I := ReadArrow;
      if clearfirst and (i > 31) and (i < 256) then begin
        clearfirst := false;
        putxy (fx);
        send (rep (' ', length (s)));
        putxy (fx);
        s := '';
        p := 1;
      end;
    end;
    If hung Then Exit;

    C := Chr (Lo (I));

    Case I of
      8: If P <> 1 Then Begin
           clearfirst := false;
           If P = Succ (Length (S)) Then Begin
             Dec (S [0]);
             If _x = 1 then
               send (GoXy (80, pred (_y)) + bc + GoXy (80, pred (_y)))
             else
               send (#8 + bc + #8);
           End Else Begin
             Delete (S, Pred (P), 1);
             If _x = 1 then
               send (GoXy (80, pred (_y)))
             else
               send (#8);
             sx := _x;
             Send (Copy (S, Pred (P), 255) + bc + GoXy (sx, _y));
           End;
           Dec (P);
         End;
      13: Break;
      kCtlU: If Chart Then Begin
               ps := ps + ASCii;
               If hung then exit;
               Continue;
             End;
      kLeft: If P <> 1 Then Begin
               clearfirst := false;
               If _x = 1 then
                 Send (GoXy (80, pred (_y)))
               else
                 Send (GoXy (Pred (_x), _y));
               Dec (P);
             End;
      kRight:If P <= Length (S) Then Begin
               clearfirst := false;
               If _x = 80 then
                 Send (GoXy (1, succ (_y)))
               else
                 Send (GoXy (Succ (_x), _y));
               Inc (P);
             End;
      kHome:
             Begin
               clearfirst := false;
               P := 1;
               putxy (fx);
             End;
      kEnd:
             Begin
               clearfirst := false;
               P := Succ (Length (S));
               Send (GoXy (Pred (fx. x + P), _y));
             End;
      kIns: InsertMode := Not InsertMode;
      kDel: If P <> Succ (Length (S)) Then Begin
              Delete (S, P, 1);
              sx := _x;
              Send (Copy (S, P, 255) + bc + GoXy (sx, _y));
            End;
      24: begin
            putxy (fx);
            send (rep (' ', length (s)));
            putxy (fx);
            s := '';
            p := 1;
          end;
      1..31:;
      Else If I < 256 Then Begin
        If Pos (uCase (C), Limit) = 0 Then Continue;
        If InsertMode Then Begin
          If Length (S) >= Len Then Continue;
          sx := Succ (_x);
          sy := _y;
          if _x = 80 then begin
            sx := 1;
            inc (sy);
          end;
          Send (C + Copy (S, P, 255));
          S := Copy (S, 1, Pred (P)) + C + Copy (S, P, 255);
          If P <> Length (S) Then
            Send (GoXy (sx, sy));
        End Else Begin
          If P > Len Then Continue;
          Send (C);
          S [P] := C;
          If P = Succ (Length (S)) Then Inc (S [0]);
        End;
        Inc (P);
      End;
    End;
  Until Hung;
  If Box Then begin
    sendcolor (a);
    PutXy (t2);
    send (PadLeft (S, Len, ' '));
    PutXy (t2);
  end;
  clearfirst := false;
End;

Procedure GetPwStr (ex: byte; Box, Echo: Boolean; Var S: PwStr);
Var
  I: Word;
  bc, C: Char;
  a, B, sy, sx, P: Byte;
  pwc: string [30];
  ps: String;
  fx, t2: xy;
Begin
  pwc := '';
  ps := S;
  S := '';
  B := 1;
  P := 1;
  getxy (fx);

  If Box Then Begin
    a := textattr;
    bc := uc. boxchar;
    GetXy (t2);
    ComWrite ('|UX' + Rep (uc. boxchar, 30));
    PutXy (t2);
  End Else bc := ' ';

  Repeat
    if MacroStr <> '' then begin
      I := Ord (MacroStr [1]);
      Delete (MacroStr, 1, 1);
    end else If ps <> '' Then Begin
      I := Ord (ps [1]);
      Delete (ps, 1, 1);
    end else begin
      I := ReadArrow;
      if clearfirst and (i > 31) and (i < 256) then begin
        clearfirst := false;
        putxy (fx);
        send (rep (' ', length (s)));
        putxy (fx);
        s := '';
        p := 1;
        If Echo Then
         Screen^. WritePlain (ex, SnapShotOff, PadLeft (S, 30, ' '));
      end;
    end;
    If hung Then Exit;

    C := Chr (Lo (I));

    Case I of
      0, 256:;
      1..7:;
      8: If P <> 1 Then Begin
           clearfirst := false;
           Dec (pwc [0]);
           If P = Succ (Length (S)) Then Begin
             Dec (S [0]);
             If _x = 1 then
               send (GoXy (80, pred (_y)) + bc + GoXy (80, pred (_y)))
             else
               send (#8 + bc + #8);
           End Else Begin
             Delete (S, Pred (P), 1);
             If _x = 1 then
               send (GoXy (80, pred (_y)))
             else
               send (#8);
             sx := _x;
             putxy (fx);
             Send (pwc);
           End;

           If Echo Then
             Screen^. WritePlain (ex, SnapShotOff, PadLeft (S, 30, ' '));

           Dec (P);
           If B > 1 Then
             Dec (B)
           Else
             B := Length (Uc. PasswordChar);
         End;
      9..12:;
      13: Break;
      24: begin
            putxy (fx);
            send (rep (' ', length (s)));
            putxy (fx);
            s := '';
            p := 1;
            If Echo Then
              Screen^. WritePlain (ex, SnapShotOff, PadLeft (S, 30, ' '));
          end;
      14..31:;
      kLeft: If P <> 1 Then Begin
               clearfirst := false;
               If _x = 1 then
                 Send (GoXy (80, pred (_y)))
               else
                 Send (GoXy (Pred (_x), _y));
               Dec (P);
             End;
      kRight:If P <= Length (S) Then Begin
               clearfirst := false;
               If _x = 80 then
                 Send (GoXy (1, succ (_y)))
               else
                 Send (GoXy (Succ (_x), _y));
               Inc (P);
             End;
      kHome:
             Begin
               clearfirst := false;
               P := 1;
               putxy (fx);
             End;
      kEnd:
             Begin
               clearfirst := false;
               P := Succ (Length (S));
               Send (GoXy (Pred (fx. x + P), _y));
             End;
      kIns: InsertMode := Not InsertMode;
      kDel: If P <> Succ (Length (S)) Then Begin
              Delete (S, P, 1);
              sx := _x;
              If B > 1 Then
                Dec (B)
              Else
                B := Length (Uc. PasswordChar);
              Dec (pwc [0]);
              Send (GoXy (fx. x, _y) + pwc + bc);
              If Echo Then
                Screen^. WritePlain (ex, SnapShotOff, PadLeft (S, 30, ' '));
            End;
      Else If I < 256 Then Begin
        If InsertMode Then Begin
          If Length (S) >= 30 Then Continue;
          sx := Succ (_x);
          sy := _y;
          if _x = 80 then begin
            sx := 1;
            inc (sy);
          end;
          pwc := pwc + Uc. PasswordChar [B];
          Send (GoXy (fx. x, _y) + pwc);
          If B = Length (Uc. PasswordChar) Then B := 1 Else Inc (B);
          S := Copy (S, 1, Pred (P)) + C + Copy (S, P, 255);
          If Echo Then
            Screen^. WritePlain (ex, SnapShotOff, PadLeft (S, 30, ' '));
          If P <> Length (S) Then
            Send (GoXy (sx, sy));
        End Else Begin
          If P > 30 Then Continue;
          Send (Uc. PasswordChar [B]);
          S [P] := C;
          If P = Succ (Length (S)) Then Inc (S [0]);
          If Echo Then
            Screen^. WritePlain (ex, SnapShotOff, PadLeft (S, 30, ' '));
          pwc [P] := Uc. PasswordChar [B];
          If P = Succ (Length (pwc)) Then Inc (pwc [0]);
          If B = Length (Uc. PasswordChar) Then B := 1 Else Inc (B);
        End;
        Inc (P);
      End;
    End;
  Until Hung;
  S := SetLower (S);
  If Box Then begin
    sendcolor (a);
    PutXy (t2);
    send (PadLeft (S, 30, ' '));
    PutXy (t2);
  end;
  clearfirst := false;
End;

Procedure GetArrowStr (Len: Byte; Var S: String);
var
  ps: string;
  p: byte;
  I: word;
  c: Char;
  fx: xy;
Begin
  If Len > 254 then len := 254;
  ps := s;
  S := '';
  P := 1;
  getxy (fx);

  Repeat
    if MacroStr <> '' then begin
      I := Ord (MacroStr [1]);
      Delete (MacroStr, 1, 1);
    end else If ps <> '' Then Begin
      I := Ord (ps [1]);
      Delete (ps, 1, 1);
    End Else
      I := ReadArrow;
    If hung Then Exit;

    C := Chr (Lo (I));

    Case I of
      0, 256:;
      1..7:;
      8: If P <> 1 Then Begin
           Dec (S [0]);
           send (#8' '#8);
           Dec (P);
         End;
      9..12:;
      13: Break;
      24: begin
            putxy (fx);
            send (rep (' ', length (s)));
            putxy (fx);
            s := '';
            p := 1;
          end;
      14..31:;
      kDown: If S = '' Then Begin
               S := '! D !!';
               Exit;
             End;
      kUp: If S = '' Then Begin
             S := '! U !!';
             Exit;
           End;
      kLeft: If S = '' Then Begin
               S := '! L !!';
               Exit;
             End;
      kRight: If S = '' Then Begin
                S := '! R !!';
                Exit;
              End;
      Else If I < 256 Then Begin
        If P > Len Then Continue;
        Send (C);
        S := S + C;
        Inc (P);
      End;
    End;
  Until Hung;
End;

Procedure GetCoolStr (Len: Byte; Var S: String);
Type
  woww = array [1..80] of word;
Var
  I: Word;
  C: Char;
  sx, a, P: Byte;
  ps: String;
  fx, t2: xy;
  saved: ^woww;
  b: byte;
Begin
  If Len > 254 then len := 254;
  ps := S;
  S := '';
  P := 1;
  getxy (fx);
  a := textattr;

  getmem (saved, 160);
  move (mem [seg (screen^. screenptr^):Ofs (Screen^. ScreenPtr^) + pred (_y) * 160 + pred (_x) shl 1], saved^, 160);

  Repeat
    if MacroStr <> '' then begin
      I := Ord (MacroStr [1]);
      Delete (MacroStr, 1, 1);
    end else If ps <> '' Then Begin
      I := Ord (ps [1]);
      Delete (ps, 1, 1);
    End Else
      I := ReadArrow;

    If hung Then break;

    C := Chr (Lo (I));

    Case I of
      0, 256:;
      1..7:;
      8: If P <> 1 Then Begin
           Dec (P);
           If P = Length (S) Then Begin
             Dec (S [0]);
             send (#8 + attr (hi (saved^ [p])) + chr (lo (saved^ [p])) + attr (a));
             send (clt);
           End Else Begin
             Delete (S, P, 1);
             send (#8);
             sx := _x;
             Send (Copy (S, P, 255) + attr (hi (saved^ [succ (length (s))])) + chr (lo (saved^ [succ (length (s))])) +
                   attr (a) + GoXy (sx, _y));
           End;
         End;
      9..12:;
      13: Break;
      24: begin
            putxy (fx);
            for b := 1 to len do
              Send (attr (hi (saved^ [b])) + chr (lo (saved^ [b])));
            putxy (fx);
            s := '';
            p := 1;
          end;
      14..31:;
      kLeft: If P <> 1 Then Begin
               If _x = 1 then
                 Send (GoXy (80, pred (_y)))
               else
                 Send (GoXy (Pred (_x), _y));
               Dec (P);
             End;
      kRight:If P <= Length (S) Then Begin
               If _x = 80 then
                 Send (GoXy (1, succ (_y)))
               else
                 Send (GoXy (Succ (_x), _y));
               Inc (P);
             End;
      kHome:
             Begin
               P := 1;
               putxy (fx);
             End;
      kEnd:
             Begin
               P := Succ (Length (S));
               Send (GoXy (Pred (fx. x + P), _y));
             End;
      kIns: InsertMode := Not InsertMode;
      kDel: If P <> Succ (Length (S)) Then Begin
              Delete (S, P, 1);
              sx := _x;
              Send (Copy (S, P, 255) + attr (hi (saved^ [succ (length (s))])) + chr (lo (saved^ [succ (length (s))])) +
                    attr (a) + GoXy (sx, _y));
            End;
      Else If I < 256 Then Begin
        If InsertMode Then Begin
          If Length (S) >= Len Then Continue;
          sx := Succ (_x);
          Send (C + Copy (S, P, 255));
          S := Copy (S, 1, Pred (P)) + C + Copy (S, P, 255);
          If P <> Length (S) Then
            Send (GoXy (sx, _y));
        End Else Begin
          If P > Len Then Continue;
          Send (C);
          S [P] := C;
          If P = Succ (Length (S)) Then Inc (S [0]);
        End;
        Inc (P);
      End;
    End;
  Until Hung;
  freemem (saved, 160);
end;

Procedure GetPhoneStr (box: boolean; Var S: Str15);
Var
  I: Word;
  bc, C: Char;
  b, a, P: Byte;
  ps: String [15];
  fx, t2: xy;
Begin
  ps := S;
  S := '';
  P := 1;
  getxy (fx);

  If Box Then Begin
    bc := uc. boxchar;
    a := textattr;
    GetXy (t2);
    ComWrite ('|UX' + Rep (bc, 15));
    PutXy (t2);
  End Else bc := ' ';

  Repeat
    if MacroStr <> '' then begin
      I := Ord (MacroStr [1]);
      Delete (MacroStr, 1, 1);
    end else If ps <> '' Then Begin
      I := Ord (ps [1]);
      Delete (ps, 1, 1);
    End Else
      I := ReadArrow;
    If hung Then Exit;

    C := Chr (Lo (I));

    Case I of
      0, 256:;
      1..7:;
      8: If P <> 1 Then Begin
           Dec (S [0]);
           Send (#8 + bc + #8);
           Dec (P);
           If ((S <> '') And (S [1] <> '+')) And ((P = 4) Or (P = 8)) Then Begin
             Send (#8 + bc + #8);
             Dec (S [0]);
             Dec (P);
           End;
         End;
      9..12:;
      13: if (S <> '') And (S [1] <> '+') then
          if P > 12 then break else else if p > 10 then break;
      24: begin
            putxy (fx);
            send (rep (' ', length (s)));
            putxy (fx);
            s := '';
            p := 1;
          end;
      14..31:;
      Else If I < 256 Then Begin
        If (P > 15) Or Not (C In ['+', '0'..'9']) Then Continue;
        if (S <> '') And (S [1] <> '+') and (P > 12) then continue;
        Send (C);
        S [P] := C;
        Inc (S [0]);
        Inc (P);
        If ((S <> '') And (S [1] <> '+')) And ((P = 4) Or (P = 8)) Then Begin
          Send ('-');
          S [P] := '-';
          Inc (S [0]);
          Inc (P);
        End;
      End;
    End;
  Until Hung;
  If Box Then begin
    sendcolor (a);
    PutXy (t2);
    send (PadLeft (S, 15, ' '));
    PutXy (t2);
  end;
End;

Procedure GetDateStr (box: boolean; Var S: Str8);
Var
  I: Word;
  bc, C: Char;
  b, a, P: Byte;
  ps: String [8];
  fx, t2: xy;
Begin
  ps := S;
  S := '';
  P := 1;
  getxy (fx);

  If Box Then Begin
    bc := uc. boxchar;
    a := textattr;
    GetXy (t2);
    ComWrite ('|UX' + Rep (bc, 8));
    PutXy (t2);
  End Else bc := ' ';

  Repeat
    if MacroStr <> '' then begin
      I := Ord (MacroStr [1]);
      Delete (MacroStr, 1, 1);
    end else If ps <> '' Then Begin
      I := Ord (ps [1]);
      Delete (ps, 1, 1);
    End Else
      I := ReadArrow;
    If hung Then Exit;

    C := Chr (Lo (I));

    Case I of
      0, 256:;
      1..7:;
      8: If P <> 1 Then Begin
           Dec (S [0]);
           Send (#8 + bc + #8);
           Dec (P);
           If (P = 3) Or (P = 6) Then Begin
             Send (#8 + bc + #8);
             Dec (S [0]);
             Dec (P);
           End;
         End;
      9..12:;
      13: if p = 9 then Break;
      24: begin
            putxy (fx);
            send (rep (' ', length (s)));
            putxy (fx);
            s := '';
            p := 1;
          end;
      14..31:;
      Else If I < 256 Then Begin
        If (P > 8) Or Not (C In ['/', '0'..'9']) Then Continue;
        if c = '/' then
          If (P = 2) Or (P = 5) Then Begin
            Send (#8'0' + s [pred (p)] + c);
            S [P] := S [pred (P)];
            S [pred (P)] := '0';
            Inc (S [0], 2);
            Inc (P);
            S [P] := c;
            Inc (P);
          End else
        else begin
          Send (C);
          S [P] := C;
          Inc (S [0]);
          Inc (P);
          If (P = 3) Or (P = 6) Then Begin
            Send ('/');
            S [P] := '/';
            Inc (S [0]);
            Inc (P);
          End;
        end;
      End;
    End;
  Until Hung;
  If Box Then begin
    sendcolor (a);
    PutXy (t2);
    send (PadLeft (S, 8, ' '));
    PutXy (t2);
  end;
End;

Procedure GetHotKeyInput (T, Len: Byte; Var S: String; Echo: Boolean);
Var
  I: Word;
  C: Char;
  B: LongInt;
  Z: Boolean;
label
  top;
Begin
  S := '';
  Z := True;

  top:

  Repeat
    if MacroStr <> '' then begin
      I := Ord (MacroStr [1]);
      Delete (MacroStr, 1, 1);
    end else I := ReadArrow;
    If hung Then Exit;
  Until Not (Lo (I) In [7, 8, 9, 10, 12]);
  B := BiosTime;

  Repeat
    If Z And (Et (B) >= T) Then Break;
    Case I of
      0, 256:;
      1..7:;
      8: If S [0] <> #0 Then Begin
           Dec (S [0]);
           If echo then
             if _x = 1 then
               send (GoXy (80, pred (_y)) + ' ' + GoXy (80, pred (_y)))
             else
               send (#8 + ' ' + #8);
           if s = '' then goto top
         End;
      9..12:;
      13: Break;
      14..31:;
      kDown: If S = '' Then Begin
               S := '! D !!';
               Exit;
             End;
      kUp: If S = '' Then Begin
             S := '! U !!';
             Exit;
           End;
      kLeft: If S = '' Then Begin
               S := '! L !!';
               Exit;
             End;
      kRight: If S = '' Then Begin
                S := '! R !!';
                Exit;
              End;
      Else If (I < 256) and (Length (S) < Len) then Begin
        C := Chr (Lo (I));
        S := S + C;
        If Echo Then Send (C);
      End;
    End;
    I := ReadInputNW;
    If hung Then Exit;
    If I <> 256 Then B := BiosTime;
    If (S = '/') And (I = 47) Then Z := False;
    If (S <> '') And (I = 32) Then Z := False;
  Until Hung;
End;

Function LiteBar (lb: LiteBarType; Quit, riteln: Boolean): LiteBarType;
Var
  S: String;
  B: Byte;
Begin
  If Quit Then
    S := Cs (24)
  Else
    S := Cs (23);
  If (S = '') Then
    If Quit Then
      S := 'Y~up N~ope Q~uit'
    Else
      S := 'Y~up N~ope';
  B := LiteString ('', S, Succ (Byte (lb)));
  If Hung Then Begin
    LiteBar := lbNo;
    Exit;
  End;
  LiteBar := LiteBarType (Pred (B));
  If riteln then comwriteln ('');
End;

Function LiteString (p, S: String; q: Byte): Byte;
Var
  W: Word;
  s3: string [50];
  s2: string;
  t, a, x, y, Max: Byte;
  c: char;

  procedure draw;
  var
    w: byte;
  begin
    send (goxy (x, y));

    if p <> '' then begin
      comwrite ('|UR' + P + '|UB ');
      send (uc. llinechar);
    end;
    usercol (2);

    for w := 1 to max do
      if w = q then
        comwrite ('|UV ' + extractwords (w, 1, S) + ' |US')
      else
        send (' ' + extractwords (w, 1, S) + ' ');

    if p <> '' then begin
      usercol (6);
      send (uc. rlinechar);
    end;
    send (attr (0) + ' '#8);
  end;

Begin
  Max := WordCnt (S);
  a := textattr;
  s2 := '';
  litestring := 0;

  for w := 1 to max do
    s2 := s2 + ExtractWords (w, 1, S) + ' ';

  dec (s2 [0]);
  s := s2;
  s2 := '';
  s3 := '';

  If {(P <> '') And} (HighestEmu > TermTTY) And (LiteBars In User. Options) Then Begin
    for w := 1 to max do begin
      s3 := s3 + copy (s, pred (pos ('~', s)), 1);
      delete (s, pos ('~', s), 1);
    end;

    s3 := setupper (s3);
    screen^. wherexy (x, y);
    draw;

    Repeat
      W := ReadArrow;
      If hung Then Exit;

      Case W of
        kEnter: Break;
        kSpc, kRight: begin if q <> max then inc (q) else q := 1; draw; end;
        kLeft: begin if q <> 1 then dec (q) else q := max; draw; end;
        Else Begin
          C := ucase (Chr (Lo (W)));
          If (Hi (w) = 0) and (Pos (c, s3) <> 0) Then begin
            q := Pos (c, s3);
            draw;
            break;
          end;
        End;
      End;
    Until Hung;
  End Else Begin
    s2 := '';
    s := s + ' ';

    for w := 1 to max do begin
      t := pos ('~', s);
      if t > 2 then s2 := s2 + '|UR';
      s2 := s2 + copy (s, t - 2, byte (t > 2)) + '|UP[|UI';

      if w = q then
        s2 := s2 + ucase (s [pred (t)])
      else
        s2 := s2 + lcase (s [pred (t)]);

      s2 := s2  + '|UP]';

      s3 := s3 + s [pred (t)];
      delete (s, 1, t);
      s2 := s2 + copy (s, 1, pos (' ', s));
      delete (s, 1, pos (' ', s));
    end;

    s3 := setupper (s3);

    ComWrite ('|UR' + P + ' ' + s2 + '|UP: ');
    usercol (4);

    s := '';
    getlimitstr (false, false, 1, s3, s);
    If hung Then Exit;
    if s <> '' then
      s := uCase (s [1])
    else begin
      s := s3 [q];
      send (s);
    end;
    q := Pos (s [1], s3);
  End;

  send (attr (a));
  LiteString := q;
End;

Procedure PressEnter;
Var
  Q: Byte;
  S: String;
Begin
  Q := TextAttr;
  S := Cs (17); {[PAUSED]}
  If S = '' Then S := '|08[P|07A|15US|07E|08D]';
  ComWrite (S);
  Repeat
  Until (ReadInput = 13) or hung;
  If hung Then exit;
  SendColor (Q);
  send (^M + Rep (' ', Length (S)) + ^M);
End;

Function  More (cont: boolean): moretype;
Var
  B, A: Byte;
  S: String;
Begin
  S := Cs (39);
  If S = '' Then S := '|08M|07O|15R ';
  A := TextAttr;
  ComWrite (S);

  If Cont then begin
    s := cs (133);
    if s = '' then s := 'Y~up N~ope C~ontinuous';
  end else begin
    s := cs (23);
    if s = '' then s := 'Y~up N~ope';
  end;

  B := LiteString ('', S, 1);
  If Hung Then Begin
    More := mNo;
    Exit;
  End;
  More := MoreType (Pred (B));
  send (attr (A) + ^M + Clr2Eol + ^M);
End;

Function GetNumStr (Def, Box: Boolean; LoRange, HiRange, LoDef, HiDef, NullDef, Num: LongInt): LongInt;
Const
  Nums = '1234567890';
Var
  S: String;
Begin
  If Def Then
    S := IntToStr (Num)
  Else
    S := '';

  GetNumStr := 0;
  GetLimitStr (Box, False, Length (IntToStr (HiRange)), Nums, S);
  If Hung Then Exit;

  If S = '' Then Begin
    GetNumStr := NullDef;
    Exit;
  End;

  Num := StrToInt (S);

  If Num > HiRange Then
    Num := HiDef
  Else If Num < LoRange Then
    Num := LoDef;

  GetNumStr := Num;
End;

Function GetQNumStr (Def, Box: Boolean; LoRange, HiRange, LoDef, HiDef, NullDef, Num: LongInt;var qdef:byte;qs:string):LongInt;
Const
  Nums = '1234567890';
Var
  S: String;
Begin
  If Def Then
    S := IntToStr (Num)
  else
    S := '';

  qdef := 0;
  GetQNumStr := 0;
  GetLimitStr (Box, False, Length (IntToStr (HiRange)), Nums + qs, S);
  If Hung Then Exit;

  If (s <> '') and (pos (S [1], qs) <> 0) Then Begin
    GetQNumStr := 0;
    qDef := pos (S [1], qs);
    Exit;
  End;

  If S = '' Then Begin
    GetQNumStr := NullDef;
    Exit;
  End;

  Num := StrToInt (S);

  If Num > HiRange Then
    Num := HiDef
  Else If Num < LoRange Then
    Num := LoDef;

  GetQNumStr := Num;
End;

Procedure GetRange (P: Str80; Box: Boolean; LoRange, HiRange, LoDef, HiDef, NullDef: LongInt; Var Low, High: LongInt);
Var
  S: String;
  B: Byte;
Begin
  FillIn1 := IntToStr (LoRange);
  FillIn2 := IntToStr (HiRange);

  If P = ' ' Then
    ComWrite (Cs (122))
  Else
    ComWrite (P);

  S := '';
  B := Length (IntToStr (HiRange));
  GetLimitStr (Box, False, Succ (B * 2), '1234567890-', S);
  If Hung Then Exit;

  If (CharCount ('-', S) > 1) Or (S = '') Then Begin
    Low := NullDef;
    High := NullDef;
    Exit;
  End;


  If S [1] = '-' Then Insert (IntToStr (LoRange), S, 1);
  If S [Length (S)] = '-' Then S := S + IntToStr (HiRange);

  B := Pos ('-', S);
  If B <> 0 Then Begin
    Low := StrToInt (Copy (S, 1, Pred (B)));
    High := StrToInt (Copy (S, Succ (B), 255));
  End Else Begin
    Low := StrToInt (S);
    High := Low;
  End;

  If High > HiRange Then High := HiDef;
  If Low < LoRange Then Low := LoDef;
End;

Function ReadInChar: Char;
Var
  W: Word;
Begin
  W := ReadInput;
  If W < 256 then
    ReadInChar := Chr (Lo (W))
  Else
    ReadInChar := #0;
End;

End.