{$I Sys75.INC}

Unit Clocks;

Interface

Uses
  TotFast;

Type
  pClockObj         = ^tClockObj;
  tClockObj         = Object
                        Constructor Init;
                        Procedure   Change (X1, Y1, A: Byte);
                        Procedure   Show (S: Boolean);
                        Procedure   DispLoop;
                        Function    Vizzy: Boolean;
                        Procedure   SetScrPtr (P: pScreenObj);
                        Destructor  Done;
                      Private
                        X, Y, Attr: Byte;
                        Viz: Boolean;
                        ScrPtr: pScreenObj;
                      End;

Var
  Clock             : pClockObj;

Implementation

Uses
  Spuds, TotStr, TotMisc;

Constructor tClockObj. Init;
Begin
  Viz := False;
  SetScrPtr (Screen);
  Change (1, 1, 1);
End;

Procedure tClockObj. Change (X1, Y1, A: Byte);
Begin
  Attr := A;
  X := X1;
  Y := Y1;
End;

Procedure tClockObj. Show (S: Boolean);
Begin
  Viz := S;
  If S Then tClockObj. DispLoop;
End;

Function tClockObj. Vizzy: Boolean;
Begin
  Vizzy := Viz;
End;

Procedure tClockObj. DispLoop;
Var
  Time: LongInt;
Begin
  If Not Viz Then Exit;
  With ScrPtr^ do Begin
    SetWinIgnore (True);
    Time := (1365 * BiosTime) Div 24852;
    WriteAt (X, Y, Attr, PadRight (IntToStr (Time Div 3600), 2, '0'));
    WriteAt (X + 2, Y, Attr, ':');
    Time := Time Mod 3600;
    WriteAt (X + 3, Y, Attr, PadRight (IntToStr (Time Div 60), 2, '0'));
    WriteAt (X + 5, Y, Attr, ':');
    WriteAt (X + 6, Y, Attr, PadRight (IntToStr (Time Mod 60), 2, '0'));
    SetWinIgnore (False);
  End;
End;

Procedure tClockObj. SetScrPtr (P: pScreenObj);
Begin
  ScrPtr := P;
End;

Destructor tClockObj. Done;
Begin
End;

End.