Unit Chats;
{$I Sys75.Inc}

Interface

Uses
  Spuds;

Procedure Chat (Num: Byte);
Procedure UpdateChatStats;
Procedure PageSysop (Abortable: Boolean);

Const
  vAllowChat: Boolean = True;
  ChatTries: Byte = 0;
  chatted: boolean = false;
  SysPaged: Boolean = False;

Var
  ChatReason: String [30];

Implementation

Uses
  Crt, Dos,
  OoCom,
  TotFast, TotInput, TotKey, TotStr, TotDate, TotMisc,
  EmuCodes, RemEmu, Emu, Comm, Users, StatusBar, Misc, Menus, filemenu;

Type
  IsChat = (Sysp, User);
  tLine  = Record
             y, fx, lx, a: byte;
           End;
  tLines = Array [1..50] of tLine;
  tGrid = Array [Sysp..User] of Record
            CurX, CurLine, MaxLines: byte;
            ClearEnd: Boolean;
            Lines: tLines;
          End;

Var
  Grid: tGrid;
  ChatElapsed: integer;
  LastSys: Boolean;
  Tim, Dat, Ela: axy;
  SetLines: IsChat;
  chParsed: Boolean;
  stripit: Boolean;
  stripcnt: byte;
  utripit: Boolean;
  utripcnt: byte;

Procedure SetCol (B: Byte);
Begin
  If B <> TextAttr Then Send (attr (B));
End;

Procedure UpdateChatStats;
Var
  wow: axy;
Begin
  If vAllowChat Then Exit;
  Inc (ChatElapsed);
  getaxy (wow);
  If putaxy (ela) Then
    send (PadRight (IntToStr (ChatElapsed), 4, ' '));
  If putaxy (tim) Then
    send (CurrentTime (False));
  If putaxy (dat) Then
    send (CurrentDate (True));
  putaxy (wow);
End;

Procedure ShowChat (C: Char);
Var
  Test: Boolean;
  sx: Byte;
Begin
  Test := True;
  If Not chParsed Then
    If C = '@' Then
      chParsed := True
    Else
      ComWriteCh (C)
  Else Begin
    Case C of
      'B': With Grid [SetLines] do Begin
             If MaxLines < 50 Then Begin
               Inc (MaxLines);
               With Lines [MaxLines] do Begin
                 Screen^. WhereXY (fx, y);
                 a := TextAttr;
               End;
             End;
           End;
      'E': With Grid [SetLines] do Begin
             If MaxLines < 50 Then Begin
               With Lines [MaxLines] do
                 lx := Screen^. WhereX;
             End;
           End;
      'T': GetAxy (Tim);
      'D': GetAxy (Dat);
      'X': GetAxy (Ela);
      '!': Begin
             SetLines := Sysp;
             With Grid [Sysp] do Begin
               CurLine := 1;
               MaxLines := 0;
             End;
           End;
      '@': Begin
             SetLines := User;
             With Grid [User] do Begin
               CurLine := 1;
               MaxLines := 0;
             End;
           End;
      '#': With Grid [Sysp] do
             ClearEnd := True;
      '$': With Grid [User] do
             ClearEnd := True;
      Else Begin
        Comwrite ('@' + C);
        Test := False;
      End;
    End;
    If Test Then Begin
      Inc (_x, 2);
      If _x > Sx2 Then Begin
        _x := _x - Sx2;
        If _y <> Sy2 Then Inc (_y);
      End;
      Send (GoXy (_x, _y));
    End;
    chParsed := False;
  End;
End;

Procedure Chat (Num: Byte);
Var
  ExitCnt: byte;
  I: Char;
  O: Word;

  Procedure ScrlUp (Kind: IsChat);
  Var
    S: String;
    Mid: Byte;
    W: Word;
  Begin
    With Grid [Kind] do Begin
      Mid := Succ (MaxLines Div 2);

      For W := Mid to MaxLines do
      Begin
        With Lines [W] do Begin
          S := Screen^. ReadStr (fx, lx, y);
          Send (GoXy (fx, y));
          If Not ClearEnd Then
            Send (Rep (' ', Succ (lx - fx)))
          Else
            Send (Clr2Eol);
        End;
        With Lines [Succ (W - Mid)] do Begin
          S := PadLeft (S, Succ (lx - fx), ' ');
          Send (GoXy (fx, y));
          SetCol (A);
          Send (S);
        End;
      End;
      If Odd (MaxLines) Then
        With Lines [Succ (Mid)] do Begin
          Send (GoXy (fx, y));
          SetCol (A);
          CurLine := Succ (Mid);
          CurX := fx;
        End
      Else
        With Lines [Mid] do Begin
          Send (GoXy (fx, y));
          SetCol (A);
          CurLine := Mid;
          CurX := fx;
        End;
    End;
  End;

  Procedure LineFeed (Kind: IsChat);
  Begin
    With Grid [Kind] Do Begin
      If CurLine < MaxLines Then Begin
        Inc (CurLine);
        With Lines [CurLine] do Begin
          Send (GoXy (fx, y));
          CurX := fx;
          SetCol (A);
        End;
      End Else ScrlUp (Kind);
    End;
  End;

  Procedure RunFS;
  Var
    tp: byte;
    saveit: axy;
    exitstr: string;
  Begin
    ExitCnt := 0;

    LastSys := True;
    With Grid [Sysp] do Begin
      CurLine := 1;
      With Lines [CurLine] do begin
        CurX := fx;
        Send (GoXy (fx, y) + Attr (a));
      End;
    End;

    With Grid [User] do Begin
      CurLine := 1;
      With Lines [CurLine] do
        CurX := fx;
    End;

    Repeat
      Key^. vIdleHook;
      If hung Then Exit;

      If (MacroStr <> '') or Key^. KeyPressed Then With Grid [Sysp] do Begin
        NoKbdPress := 0;

        If (Length (MacroStr) >= 3) And (MacroStr [1] = '|') then
          If (MacroStr [2] In Digitset) And (MacroStr [3] In Digitset) Then Begin
            SetCol (StrToInt (Copy (MacroStr, 2, 2)));
            Delete (MacroStr, 1, 3);
          End Else If (MacroStr [2] = 'B') Then Begin
            If MacroStr [3] In Digitset Then
              SetCol (fAttr (TextAttr) + (Ord (MacroStr [3]) - 48) * 16)
            Else If (MacroStr [3] = '+') And (TextAttr < 128) Then
              SetCol (TextAttr + 128)
            Else If (MacroStr [3] = '-') And (TextAttr > 127) Then
              SetCol (TextAttr - 128);

            Delete (MacroStr, 1, 3);
          End;

        If MacroStr = '' Then
          O := Key^. GetKey
        Else Begin
          O := Ord (MacroStr [1]);
          Delete (MacroStr, 1, 1);
        End;

        If Not LastSys Then With Lines [CurLine] do begin
          Send (GoXy (CurX, y));
          SetCol (a);
        End;

        LastSys := True;

        Case ExitCnt of
          0: If (_x = Lines [CurLine]. fx) And (O = Ord ('/')) Then
               Inc (ExitCnt);
          1: If (O <> Ord ('Q')) And (O <> Ord ('q')) Then
               if o = Ord ('/') then
                 exitcnt := 3
               else
                 ExitCnt := 0
             Else
               Inc (ExitCnt);
          2: If O = 13 Then
               Break
             Else
               ExitCnt := 0;
          3: if o = Ord ('\') then inc (exitcnt);
          4: if o = Ord ('\') then begin
               inc (exitcnt);
               exitstr := '';
             end;
          5: if o <> 13 then
               exitstr := exitstr + chr (lo (O))
             else begin
               LineFeed (Sysp);
               GetAxy (SaveIt);
               SaveANSi (False, NodeData. TempPath + 'ChatMenu.Tmp');
               Process (copy (exitstr, 1, 2), copy (exitStr, 4, 255), True);
               ReallyUnabortable := True;
               NewStatBar := True;
               ShowStatus;
               ShowFile (NodeData. TempPath + 'ChatMenu.Tmp', False, False);
               PutAxy (SaveIt);
               DeleteFile (NodeData. TempPath + 'ChatMenu.Tmp');
               O := 0;
               exitcnt := 0;
             End;
        end;

        Case o of
          27: Break;
          8: If CurX > Lines [CurLine]. fx Then Begin
               send (#8' '#8);
               Dec (CurX);
             End;
          9:;
          13: LineFeed (Sysp);
          18: if not outlock then refresh;
          Else If (O > 31) And (O < 256) Then Begin
            send (Chr (O));
            With Lines [CurLine] do
              If CurX < lx Then
                Inc (CurX)
              Else
                LineFeed (Sysp);
          End;
        End;
      End;

      Key^. vIdleHook;
      If hung Then Exit;

      If Not LocalOnly and OnLine And Uart^. CharReady Then With Grid [User] Do Begin
        NoKbdPress := 0;

        If LastSys Then With Lines [CurLine] do Begin
          Send (GoXy (CurX, y));
          SetCol (a);
        End;

        LastSys := False;

        Uart^. GetChar (I);

        Case ExitCnt of
          0: If (_x = Lines [CurLine]. fx) And (I = '/') Then Inc (ExitCnt);
          1: If uCase (I) <> 'Q' Then ExitCnt := 0 Else Inc (ExitCnt);
          2: If I = #13 Then
               Break
             Else
               ExitCnt := 0;
        End;

        Case I of
          ^H:If CurX > Lines [CurLine]. fx Then Begin
               send (^H' '^H);
               Dec (CurX);
             End;
          ^M: LineFeed (User);
          ^R: if not outlock then refresh;
          #1..#31:;
          Else Begin
            send (I);
            With Lines [CurLine] do
              If CurX < lx Then
                Inc (CurX)
              Else
                LineFeed (User);
          End;
        End;
      End;

    Until False;
  End;

  Procedure RunLine;
  var
    tp: byte;
    s: string;
    saveit: axy;
  Begin
    Send (attr (uc. SysColor));
    ExitCnt := 0;
    Repeat
      Key^. vIdleHook;
      If hung Then Exit;

      If (MacroStr <> '') Or Key^. KeyPressed Then Begin
        NoKbdPress := 0;

        If (Length (MacroStr) >= 3) And (MacroStr [1] = '|') then
          If (MacroStr [2] In Digitset) And (MacroStr [3] In Digitset) Then Begin
            SetCol (StrToInt (Copy (MacroStr, 2, 2)));
            Delete (MacroStr, 1, 3);
          End Else If (MacroStr [2] = 'B') Then Begin
            If MacroStr [3] In Digitset Then
              SetCol (fAttr (TextAttr) + (Ord (MacroStr [3]) - 48) * 16)
            Else If (MacroStr [3] = '+') And (TextAttr < 128) Then
              SetCol (TextAttr + 128)
            Else If (MacroStr [3] = '-') And (TextAttr > 127) Then
              SetCol (TextAttr - 128);

            Delete (MacroStr, 1, 3);
          End;

        If MacroStr = '' then
          O := Key^. GetKey
        else begin
          o := ord (macrostr [1]);
          delete (macrostr, 1, 1);
        end;

        If hung Then Exit;
        if not stripit then SetCol (uc. SysColor) else begin
          SetCol (uc. Syswc [stripcnt]);
          if stripcnt = 5 then stripcnt := 1 else inc (stripcnt);
        end;

        Case O Of
          0:;
          kBkSp: begin
                   send (#8' '#8);
                   if s <> '' then dec (s [0]);
                 end;
          kTab:  begin
                   send ('     ');
                   if s <> '' then s := s + '     ';
                 end;
          kEnter:Begin
                   send (#13#10);
                   If S <> '' then begin
                     s := setupper (s);
                     if s = '/Q' then
                       break
                     else if copy (s, 2, 3) = 'CLS' then
                       send (cls)
                     else if copy (s, 2, 4) = 'SEND' then
                       sendfiles (copy (s, 7, 255))
                     else if copy (s, 2, 4) = 'TYPE' then
                       showfile (copy (s, 7, 255), false, true)
                     else if s [2] = '?' then begin
                       TTYPauser := 1;
                       showfile (uc. helppath + 'chats.hlp', true, true)
                     end else if copy (s, 2, 3) = 'BYE' then
                       hung := true
                     else if (copy (s, 1, 4) = '//\\') and (length (s) >= 6) then begin
                       GetAxy (SaveIt);
                       SaveANSi (False, NodeData. TempPath + 'ChatMenu.Tmp');
                       delete (s, 1, 4);
                       Process (copy (s, 1, 2), copy (s, 4, 255), True);
                       ReallyUnabortable := True;
                       NewStatBar := True;
                       ShowStatus;
                       ShowFile (NodeData. TempPath + 'ChatMenu.Tmp', False, False);
                       PutAxy (SaveIt);
                       DeleteFile (NodeData. TempPath + 'ChatMenu.Tmp');
                     end;
                   end;
                   s := '';
                 End;
          kEsc:  Break;
          18: if not outlock then refresh;
          26: begin
                sTripIt := Not sTripIt;
                stripcnt := 1;
                if not stripit then SetCol (uc. SysColor);
              end;
          Else If (O > 31) And (O < 256) Then begin
            If (_x = 1) and (O = 47) then
              s := '/'
            else
              if s [1] = '/' then
                s := s + chr (Lo (o))
              else
                s := '';
            send (Chr (O));
          end;
        End;
      End;

      Key^. vIdleHook;
      If hung Then Exit;

      If Not LocalOnly and OnLine Then If Uart^. CharReady Then Begin
        NoKbdPress := 0;
        Uart^. GetChar (I);

        if not utripit then SetCol (uc. userColr) else begin
          SetCol (uc. Usewc [utripcnt]);
          if utripcnt = 5 then utripcnt := 1 else inc (utripcnt);
        end;

        Case ExitCnt of
          0: If (_x = 1) And (I = '/') Then Inc (ExitCnt);
          1: If Ucase (I) <> 'Q' Then ExitCnt := 0 Else Inc (ExitCnt);
          2: If I = #13 Then Break Else ExitCnt := 0;
        End;

        Case I of
          ^H: send (^H' '^H);
          ^I: send ('     ');
          ^M: send (^M^J);
          ^Z: begin
                uTripIt := Not uTripIt;
                utripcnt := 1;
                if not utripit then SetCol (uc. UserColr);
              end;
          ^R: if not outlock then refresh;
          Else If I > #31 Then send (I);
        End;
      End;

    Until False;
  End;

Var
  saved: axy;
  OldTimeLock: Boolean;

Label
  Abort;

Begin
  Chatted := false;
  If Not vAllowChat Then Exit;
  fillchar (ela, 3, 0);
  fillchar (tim, 3, 0);
  fillchar (dat, 3, 0);
  Grid [Sysp]. ClearEnd := False;
  Grid [User]. ClearEnd := False;
  vAllowChat := False;
  OldTimeLock := TimeLock In Users. User. Options;
  If B (Uc. Options, NoTimeInChat) Then
    Users. User. Options := Users. User. Options + [TimeLock];
  SysPaged := False;
  ShowStatus;
  ChatElapsed := -1;
  getaxy (saved);
  SaveANSi (False, NodeData. TempPath + 'ChatSave.Tmp');

  Log (1, 'Sysop chat engaged');

  if num <> 0 then begin
    UserCol (1);
    chparsed := false;
    ReallyUnabortable := True;
    if exist (Uc. DispPath + 'Chat.' + IntToStr (Num)) then begin
      ShowFileProc (Uc. DispPath + 'Chat.' + IntToStr (Num), ShowChat);
      If hung Then Goto Abort;
      UpdateChatStats;
      RunFS;
    end else
      num := 0;
  End;

  If Num = 0 Then Begin
    ComWriteLn (^M^J + Cs (19)); {Sysop wants to chat with you!}
    If hung Then Goto Abort;
    RunLine;
  End;

  If hung Then Goto Abort;

  ReallyUnabortable := True;
  ShowFile (NodeData. TempPath + 'ChatSave.Tmp', False, False);
  If hung Then Goto Abort;
  PutAxy (saved);

  Abort:
  DeleteFile (NodeData. TempPath + 'ChatSave.Tmp');

  If Not OldTimeLock Then
    Users. User. Options := Users. User. Options - [TimeLock];

  newstatbar := true;
  showstatus;
  vAllowChat := True;
  chatted := true;
End;

Procedure PageSysop (Abortable: Boolean);
Var
  A, C: Byte;
  S: String;
Begin
  SysPaged := True;
  StatBar := 6;
  NewStatBar := True;
  ShowStatus;
  chatted := false;

  If Not LocalOnly Then begin
    uart^. drainoutbuffer (36);
    iDelay (50);
    Uart^. FlushInBuffer;
  end;

  For C := 1 to 10 do Begin
    If chatted or hung Or (Abortable And (ReadInputNW = 32)) Then Begin
      chatted := false;
      SysPaged := False;
      ForceStatBar := True;
      ShowStatus;
      Break;
    End;
    ComWrite (Cs (36));
    If B (vToggles, 4) Then Begin
      For A := 0 to 7 do Begin
        Crt. Sound (1800 + A * 100);
        iDelay (9);
        Crt. Sound (1900 + A * 100);
        iDelay (11);
        Crt. Sound (2000 + A * 100);
        iDelay (11);
        Crt. Sound (2100 + A * 100);
        iDelay (11);
        Crt. Sound (2200 + A * 100);
        iDelay (11);
        Crt. Sound (2300 + A * 100);
        iDelay (11);
        Crt. Sound (2400 + A * 100);
        iDelay (11);
        Crt. Sound (2500 + A * 100);
        iDelay (11);
      end;
      iDelay (45);
      Crt. NoSound;
      iDelay (65);
    End Else iDelay (1000);
  End;
  comwriteln ('');
  if syspaged and not chatted then
    comwriteln (cs (95))
  else
    chatted := false;
End;

End.
