Unit BlackLst;
{$I Sys75.Inc}

Interface

Uses
  Spuds, TotDate;

Type
  tDelType = (tdImmediate, tdDate, tdForever);
  DelListRec = Record
    Handle: HandleStr;
    DelType: tDelType;
    disp: String [32];
    theDate: Date;
  End;

Procedure BlackList;
Procedure ShowBlackList (Rec: Word);
Function  InBlackList (Handle: HandleStr; Var Rec: Word): Boolean;
Procedure AddToBlackList (H: HandleStr; td: tDelType; dip: string; da: date);
Procedure RemBlackList (Rec: Word);
Procedure RemDatedBlacks;
Procedure Add2Bl (Handy: HandleStr);

Implementation

Uses
  TotStr,
  Users, RemEmu, Comm, misc;

  Procedure Add2Bl (Handy: HandleStr);
  Var
    rec: word;
    ts: string [8];
    c: char;
    dr: DelListRec;
  Begin
    FillChar (dr, Sizeof (dr), 0);
    with dr do begin
      If Handy = '' Then Begin
        ComWrite (^M^J + '|URHandle|UP: |UI');
        GetStr (HandleLen, False, False, handle);
        handle := strip ('B', ' ', handle);
        if handle = '' then exit;
        if inblacklist (handle, rec) then begin
          ComWrite (^M^J + '|UR' + handle + ' is already in the blacklist, record #' + inttostr (rec) + '.' + ^M^J);
          exit;
        end;
      End Else begin
        handle := handy;
        if inblacklist (handle, rec) then exit;
      end;
      Log (1, 'User ' + handle + ' added to blacklist');
      ComWrite (^M^J + '|URDisplay file|UP: |UI');
      disp := 'BlackLst.Ans';
      GetCapStr (32, 'A', False, False, disp);
      if disp = '' then exit;
      ComWrite (^M^J + '|URExpires |UP[|UII|UP]|URmmediately |UP[|UID|UP]|URate |UP[|UIN|UP]|URever|UP: |UI');
      Repeat
        C := uCase (ReadInChar);
      Until hung or (Pos (C, 'IDN') <> 0) or (c = ^M);
      send (C + ^M^J);
      if hung or (C = ^M) then exit;
      case c of
        'I': DelType := tdImmediate;
        'N': DelType := tdForever;
        'D': Begin
               DelType := tdDate;
               Repeat
                 ts := '';
                 ComWrite ('|URExpire date|UP: |UI');
                 GetDateStr (false, ts);
               Until ValidDateStr (ts);
               theDate := DateVal (ts);
             End;
      end;
      AddToBlackList (handle, DelType, disp, thedate);
    end;
    comwriteln (^M^J);
  End;


Procedure BlackList;
Var
  C: Char;
  dr: DelListRec;
  df: File of DelListRec;

  Procedure Del;
  Var
    ze: word;
    high, low: longint;
  Begin
    if filesize (df) > 0 then begin
      ComWrite (^M^J'|URDelete which record(s)');
      getrange (' ', false, 1, filesize (df), 1, filesize (df), -1, low, high);
      if hung then exit;
      comwriteln ('');
      if low = -1 then exit;
      if low <> high then begin
        comwrite ('|USDelete records |UR' + inttostr (low) + '|UP-|UR' + inttostr (high) + ' ');
        if litebar (lbYes, false, true) = lbno then exit;
      end;

      for ze := high downto low do begin
        if ze = filesize (df) then begin
          seek (df, pred (ze));
          truncate (df);
        end else begin
          seek (df, pred (filesize (df)));
          read (df, dr);
          seek (df, pred (filesize (df)));
          truncate (df);
          seek (df, pred (ze));
          write (df, dr);
        end;
      end;
      comwriteln ('');
      Log (1, 'Deleted records from blacklist');
    End else ComWriteln (^M^J'|URThere are no users in the blacklist.'^M^J);
  End;

  Procedure Lst;
  Var
    Lui: LongInt;
  Begin
    if filesize (df) > 0 then begin
      comwriteln ('');
      seek (df, 0);
      lui := 0;
      while not eof (df) do begin
        read (df, dr);
        inc (lui);
        with dr do begin
          comwrite ('|UB#|UR' + PadRight (IntToStr (Lui), 3, ' ') + '|US   ' + padleft (handle, 26, ' ') + '|UR   Expires ');
          case deltype of
            tdImmediate: comwrite ('immediately');
            tdForever: comwrite ('never      ');
            tdDate: comwrite ('on ' + datestr (theDate));
          end;
          comwriteln ('|UP  ' + Copy (disp, 1, 20));
        end;
        if lui mod pred (curpagelen) = 0 then if more (false) = mno then break;
      end;
      comwriteln ('');
      Log (0, 'Listed users in blacklist');
    End else ComWriteln (^M^J'|URThere are no users in the blacklist.');
  End;

  Procedure Edt;
  Const
    ind: array [0..2] of char = 'IDN';
  Var
    ts: string;
    Lui: LongInt;
  Begin
    if filesize (df) > 0 then begin
      ComWrite (^M^J'|UREdit which record|UP: |UI');
      lui := getnumstr (false, false, 1, filesize (df), 1, filesize (df), -1, 1);
      if hung or (lui = -1) then exit;
      seek (df, pred (lui));
      with dr do begin
        ComWrite (^M^J + '|URHandle|UP: |UI');
        ts := handle;
        GetStr (HandleLen, False, False, ts);
        if ts <> '' then
          handle := ts
        else
          comwrite (handle);

        handle := strip ('B', ' ', handle);
        ComWrite (^M^J + '|URDisplay file|UP: |UI');
        ts := disp;
        GetCapStr (32, 'A', False, False, ts);
        if ts <> '' then
          disp := ts
        else
          comwrite (disp);

        ComWrite (^M^J + '|URExpires |UP[|UII|UP]|URmmediately |UP[|UID|UP]|URate |UP[|UIN|UP]|URever|UP: |UI');
        ComWrite (ind [byte (deltype)] + ^H);
        Repeat
          C := uCase (ReadInChar);
        Until hung or (Pos (C, 'IDN') <> 0) or (c = ^M);
        if hung then begin
          close (df);
          exit;
        end;
        if c = ^M then c := ind [byte (deltype)];
        send (c);
        case c of
          'I': DelType := tdImmediate;
          'D': Begin
                 DelType := tdDate;
                 Repeat
                   ts := DateStr (theDate);
                   ComWrite (^M^J + '|URExpire date|UP: |UI');
                   GetDateStr (false, ts);
                 Until ValidDateStr (ts);
                 theDate := DateVal (ts);
               End;
          'N': DelType := tdForever;
        end;
      end;
      seek (df, pred (lui));
      write (df, dr);
      comwriteln ('');
      Log (2, 'Edited records in blacklist');
    End else ComWriteln (^M^J'|URThere are no users in the blacklist.'^M^J);
  End;

Begin
  comwriteln ('');
  FillIn1 := 'BlackList';
  pFile ('hdr.ans');

  assign (df, uc. datapath + 'BlackLst.Dat');
  {$I-}
  reset (df);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then rewrite (df);

  Repeat
    Lst;
    ComWrite (^M^J'|UP[|UIA|UP]|URdd |UP[|UID|UP]|URelete |UP[|UIC|UP]|URhange |UP[|UIQ|UP]|URuit|UP: |UI');
    Repeat
      C := uCase (ReadInChar);
    Until Hung or (Pos (C, 'ADCQ') <> 0);
    If Hung Then Break;
    Send (C + ^M^J);
    Case C of
      'Q': Break;
      'A': begin
             close (df);
             comwriteln ('');
             FillIn1 := 'Adding to BlackList';
             pFile ('hdr.ans');
             comwriteln ('');
             Add2Bl ('');
             reset (df);
           end;
      'D': Del;
      'C': Edt;
    End;
  Until Hung;
  If Not Hung Then ComWriteln ('');
  {$I-}
  close (df);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then;
End;

Function InBlackList (Handle: HandleStr; Var Rec: Word): Boolean;
var
  blf: file of dellistrec;
  blr: dellistrec;
Begin
  InBlackList := false;
  rec := 0;
  handle := setupper (Strip ('B', ' ', handle));
  assign (blf, uc. datapath + 'BlackLst.Dat');
  {$I-}
  reset (blf);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then exit;
  while not eof (blf) do begin
    inc (rec);
    read (blf, blr);
    if setupper (blr. handle) = handle then begin
      close (blf);
      InBlackList := true;
      exit;
    end;
  end;
  close (blf);
End;

Procedure ShowBlackList (Rec: Word);
var
  blf: file of dellistrec;
  blr: dellistrec;
Begin
  assign (blf, uc. datapath + 'BlackLst.Dat');
  {$I-}
  reset (blf);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then exit;
  dec (rec);
  if filesize (blf) >= rec then begin
    seek (blf, rec);
    read (blf, blr);
    pFile (blr. disp);
  end;
  close (blf);
End;

Procedure AddToBlackList (H: HandleStr; td: tDelType; dip: string; da: date);
var
  dr: DelListRec;
  df: File of DelListRec;
begin
  with dr do begin
    handle := Strip ('B', ' ', h);
    deltype := td;
    disp := dip;
    theDate := da;
  end;
  assign (df, uc. datapath + 'BlackLst.Dat');
  {$I-}
  reset (df);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then rewrite (df);
  seek (df, filesize (df));
  write (df, dr);
  close (df);
End;

Procedure RemBlackList (Rec: Word);
Var
  dr: DelListRec;
  df: File of DelListRec;
Begin
  assign (df, uc. datapath + 'BlackLst.Dat');
  {$I-}
  reset (df);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then exit;

  if rec >= filesize (df) then
  else if rec = filesize (df) then begin
    seek (df, pred (rec));
    truncate (df);
  end else begin
    seek (df, pred (filesize (df)));
    read (df, dr);
    seek (df, pred (filesize (df)));
    truncate (df);
    seek (df, pred (rec));
    write (df, dr);
  end;

  {$I-}
  close (df);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then ;
End;

Procedure RemDatedBlacks;
Var
  dr: DelListRec;
  df: File of DelListRec;
  lui: longint;
  n: datetimerec;
Begin
  assign (df, uc. datapath + 'BlackLst.Dat');
  {$I-}
  reset (df);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then exit;

  now (n);

  while not eof (df) do begin
    read (df, dr);
    if dr. thedate <= n. d then begin
      Log (2, dr. handle + ' removed from blacklist due to the date');
      lui := filepos (df);
      if lui = filesize (df) then begin
        seek (df, pred (lui));
        truncate (df);
      end else begin
        seek (df, pred (filesize (df)));
        read (df, dr);
        seek (df, pred (filesize (df)));
        truncate (df);
        seek (df, pred (lui));
        write (df, dr);
      end;
    end;
  end;
  {$I-}
  close (df);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then ;
End;

End.