Unit Archive;
{$I Sys75.Inc}
{$D-,I-,L-,Q-,R-,S-}

Interface

Uses
  dos, Spuds;

procedure arceditor;

function aarctype (from: pathstr): byte;
function aextract (at: byte; from, too, wild: pathstr): boolean;
function acompress (at: byte; too, wild: pathstr): boolean;
function aaddto (at: byte; too, wild: pathstr): boolean;
function adelfrom (at: byte; too, wild: pathstr): boolean;
function aviewto (at: byte; from, too: pathstr): boolean;
function atest (at: byte; from: pathstr): boolean;
function aaddcom (at: byte; too, comf: pathstr): boolean;

Implementation

Uses
  crt,
  TotStr, TotMisc, totfast, fonts,
  shell,
  Comm, EmuCodes, Menus, Misc, RemEmu, Users, Emu, statusbar;

type
  arctype = (cmp, xtr, vew, dlf, tst, adc, adf);

procedure arceditor;
Var
  B: Byte;
  zf: File of ArcRec;
  zr: ArcRec;

  Procedure EditArc;

    Procedure DrawArcEditor;
    Var
      B: Byte;
    Begin
      ComWrite ('|UB%CS');
      Box (1, 1, 79, 3, User. Cols [6]);
      Box (1, 4, 79, 23, User. Cols [6]);
      ComWriteAt (3, 2, '|URCommand|UP: |UI');
      ComWriteAt (30,2, '|UP[|USQ|UP]|URuit');
      ComWriteAt (54,2, '|15S|07ys|08tem/|157|075 |15A|07r|08chive |15E|07di|08tor');
      ComWriteAt (3, 5, '|UP[|USA|UP]|UR Archiver Name');
      ComWriteAt (3, 6, '|UP[|USB|UP]|UR File Extension');
      ComWriteAt (3, 7, '|UP[|USC|UP]|UR Compress Command');
      ComWriteAt (3, 8, '|UP[|USD|UP]|UR Extract Command');
      ComWriteAt (3, 9, '|UP[|USE|UP]|UR View Command');
      ComWriteAt (3,10, '|UP[|USF|UP]|UR Test Command');
      ComWriteAt (3,11, '|UP[|USG|UP]|UR Del File Command');
      ComWriteAt (3,12, '|UP[|USH|UP]|UR Add File Command');
      ComWriteAt (3,13, '|UP[|USI|UP]|UR Add Comment Com.');
      ComWriteAt (3,14, '|UP[|USJ|UP]|UR Maximum OK Code');
      ComWriteAt (3,15, '|UP[|USK|UP]|UR Signature Offset');
      ComWriteAt (3,16, '|UP[|USL|UP]|UR Signature Text');
      ComWriteAt (3,17, '|UP[|USM|UP]|UR List Prefix');
      ComWriteAt (3,18, '|UP[|USN|UP]|UR Checker Only');
      ComWriteAt(26,18, '|UP[|USO|UP]|UR Use Zip Viewer');
      ComWriteAt(51,18, '|UP[|USP|UP]|UR Swap Out Memory');
      ComWriteAt (3,19, '|UP[|US[|UP]|UR Previous Archiver');
      ComWriteAt (3,20, '|UP[|US]|UP]|UR Next Archiver');
      ComWriteAt (3,21, '|UP[|USZ|UP]|UR Undo Changes');
      with user do
        send (goxy(3,22)+attr(cols[4])+'%1 '+attr(cols[1])+'= archive name, '+attr(cols[4])+'%2 '+attr(cols[1])+
              '= wildcard, '+attr(cols[4])+'%3 '+attr(cols[1])+'= temp path');
      usercol (3);
      For B := 5 To 17 Do
        ComWriteAt (24, B, ':');
      ComWriteAt (19,18, ':');
      ComWriteAt (44,18, ':');
      ComWriteAt (70,18, ':');
    End;

    Procedure FillArcData (C: Char);
    Var
      Z: Char;
      S: String [80];
    Begin
      If Hung Then Exit;
      usercol (2);
      With zr Do Case C Of
        'A': Send (GoXy (26, 5) + PadLeft (Name, 30, ' '));
        'B': Send (GoXy (26, 6) + PadLeft (Ext, 3, ' '));
        'C': Send (GoXy (26, 7) + PadLeft (Comp, 50, ' '));
        'D': Send (GoXy (26, 8) + PadLeft (Extr, 50, ' '));
        'E': Send (GoXy (26, 9) + PadLeft (View, 50, ' '));
        'F': Send (GoXy (26,10) + PadLeft (Test, 50, ' '));
        'G': Send (GoXy (26,11) + PadLeft (Delf, 50, ' '));
        'H': Send (GoXy (26,12) + PadLeft (Addf, 50, ' '));
        'I': Send (GoXy (26,13) + PadLeft (Addc, 50, ' '));
        'J': Send (GoXy (26,14) + PadLeft (IntToStr (Maxok), 3, ' '));
        'K': Send (GoXy (26,15) + PadLeft (IntToStr (sigofs),6, ' '));
        'L': Send (GoXy (26,16) + PadLeft (Sig, 10, ' '));
        'M': Send (GoXy (26,17) + PadLeft (ListPre, 10, ' '));
        'N': Send (GoXy (21,18) + NoYes [checkonly in fags]);
        'O': Send (GoXy (46,18) + NoYes [zipview in fags]);
        'P': Send (GoXy (72,18) + NoYes [swapout in fags]);
         #0: For Z := 'A' To 'P' Do
               FillArcData (Z);
      End;
    End;

  Var
    C: Char;
    lui: byte;
  Begin
    If FileSize (zf) = 0 Then Begin
      ComWriteln ('|URThere are no archivers to change.');
      PressEnter;
      Exit;
    End;

    ComWrite ('|URWhich archiver to change |UP[|US1|UP-|US' + IntToStr (FileSize (zf)) + '|UP]: |UI');
    lui := GetNumStr (False, False, 1, FileSize (zf), 1, FileSize (zf), 0, 0);
    If not hung then comwriteln ('');
    If (Lui = 0) Or Hung Then Exit;
    Seek (zf, Pred (Lui));
    Read (zf, zr);
    DrawArcEditor;
    FillArcData (#0);
    Repeat
      usercol (4);
      Send (Goxy (12, 2) + ' '#8);
      C := uCase (ReadInChar);
      If Hung Then Break;
      If Pos (C, 'ABCDEFGHIJKLMNOPZ[]Q') = 0 Then Continue;
      Send (C);
      usercol (2);

      With zr Do Case C Of
        'A':
             Begin
               Send (GoXy (26, 5));
               GetStr (30, False, False, Name);
{               FillArcData (C);}
             End;
        'B':
             Begin
               Send (GoXy (26, 6));
               GetCapStr (3, 'A', False, False, Ext);
{               FillArcData (C);}
             End;
        'C':
             Begin
               Send (GoXy (26, 7));
               GetStr (50, False, False, comp);
{               FillArcData (C);}
             End;
        'D':
             Begin
               Send (GoXy (26, 8));
               GetStr (50, False, False, extr);
{               FillArcData (C);}
             End;
        'E':
             Begin
               Send (GoXy (26, 9));
               GetStr (50, False, False, view);
{               FillArcData (C);}
             End;
        'F':
             Begin
               Send (GoXy (26,10));
               GetStr (50, False, False, test);
{               FillArcData (C);}
             End;
        'G':
             Begin
               Send (GoXy (26,11));
               GetStr (50, False, False, delf);
{               FillArcData (C);}
             End;
        'H':
             Begin
               Send (GoXy (26,12));
               GetStr (50, False, False, addf);
{               FillArcData (C);}
             End;
        'I':
             Begin
               Send (GoXy (26,13));
               GetStr (50, False, False, addc);
{               FillArcData (C);}
             End;
        'J':
             Begin
               Send (GoXy (26,14));
               maxok := GetNumStr (true, true, 0, 255, 0, 255, maxok, maxok);
{               FillArcData (C);}
             End;
        'K':
             Begin
               Send (GoXy (26,15));
               sigofs := GetNumStr (true, true, -32768, 32767, -32768, 32767, sigofs, sigofs);
{               FillArcData (C);}
             End;
        'L':
             Begin
               Send (GoXy (26,16));
               GetStr (10, False, True, sig);
{               FillArcData (C);}
             End;
        'M':
             Begin
               Send (GoXy (26,17));
               GetStr (10, False, False, listpre);
{               FillArcData (C);}
             End;
        'N':
             Begin
               If CheckOnly in Fags then
                 fags := fags - [checkonly]
               else
                 fags := fags + [checkonly];
               FillArcData (C);
             End;
        'O':
             Begin
               If zipview in Fags then
                 fags := fags - [zipview]
               else
                 fags := fags + [zipview];
               FillArcData (C);
             End;
        'P':
             Begin
               If swapout in Fags then
                 fags := fags - [swapout]
               else
                 fags := fags + [swapout];
               FillArcData (C);
             End;
        'Z':
             Begin
               Seek (zf, Pred (FilePos (zf)));
               Read (zf, zr);
               FillArcData (#0);
             End;
        '[':
             Begin
               Seek (zf, Pred (FilePos (zf)));
               Write (zf, zr);

               Seek (zf, Pred (FilePos (zf)));
               If FilePos (zf) = 0 Then
                 Seek (zf, Pred (FileSize (zf)))
               Else
                 Seek (zf, Pred (FilePos (zf)));
               Read (zf, zr);
               FillArcData (#0);
             End;
        ']':
             Begin
               Seek (zf, Pred (FilePos (zf)));
               Write (zf, zr);

               If FilePos (zf) = FileSize (zf) Then Seek (zf, 0);
               Read (zf, zr);
               FillArcData (#0);
             End;
        'Q':
             Begin
               Seek (zf, Pred (FilePos (zf)));
               Write (zf, zr);

               Break;
             End;
      End;
    Until hung;
    If Not hung Then ComWriteAt (1, 24, '|UR');
  End;

  Procedure AddArc;
  Var
    F: File;
    lui: byte;
  Begin
    If FileSize (zf) >= 255 Then Begin
      ComWriteln ('|URNo more archivers can be added.');
      PressEnter;
      Exit;
    End Else If FileSize (zf) <> 0 Then Begin
      ComWrite ('|URInsert before which archiver |UP[|US1|UP-|US' + IntToStr (Succ (FileSize (zf))) + '|UP]: |UI');
      Lui := GetNumStr (False, False, 1, Succ (FileSize (zf)), 1, Succ (FileSize (zf)), 0, 0);
      If Not Hung Then ComWriteln ('');
      If (Lui = 0) Or Hung Then Exit;
    End Else Lui := 1;
    Close (zf);
    Assign (F, Uc. DataPath + 'Archiver.Dat');
    Reset (F, 1);
    InsertRec (F, Pred (Lui), SizeOf (ArcRec));
    Close (F);
    Reset (zf);
    Seek (zf, Pred (Lui));
    FillChar (zr, Sizeof (zr), 0);
    zr. Name := 'New Archiver';
    zr. fags := [swapout];
    Write (zf, zr);
  End;

  Procedure DeleteArc;
  Var
    F: File;
    ze: word;
    High, Low: LongInt;
  Begin
    If FileSize (zf) = 0 Then Begin
      ComWriteln ('|URThere are no archivers to delete.');
      PressEnter;
      Exit;
    End;
    ComWrite ('|URWhich archiver(s) to delete');
    GetRange (' ', False, 1, FileSize (zf), 1, FileSize (zf), -1, Low, High);
    if hung then exit;
    comwriteln ('');
    if low = -1 then exit;
    if low <> high then begin
      comwrite ('|USDelete archivers |UR' + inttostr (low) + '|UP-|UR' + inttostr (high) + ' ');
      if litebar (lbYes, false, true) = lbno then exit;
    end;

    Close (zf);
    Assign (F, Uc. DataPath + 'Archiver.Dat');
    Reset (F, 1);

    for ze := high downto low do
      RemoveRec (F, pred (ze), SizeOf (ArcRec));

    comwriteln ('');

    Close (F);
    Reset (zf);
  End;

Var
  Ch: Char;

Begin
  Assign (zf, Uc. DataPath + 'Archiver.Dat');
  {$I-}
  Reset (zf);
  {$IFDEF Debug} {$I+} {$ENDIF}
  If IOResult <> 0 Then Begin
    Rewrite (zf);
    If IOResult <> 0 Then Begin
      ComWriteln ('|07Error opening archiver file |15' + Uc. DataPath + 'Archiver.Dat|07');
      ErrorLog ('|07Error opening archiver file |09' + Uc. DataPath + 'Archiver.Dat|07');
      Exit;
    End;
  End;

  Repeat
    B := 0;
    Seek (zf, 0);
    Send (Cls);

    FillIn1 := 'Editing Archivers';
    pFile ('hdr.ans');
    ComWriteln ('');
    B := 0;

    While Not EoF (zf) Do Begin
      Inc (B);
      Read (zf, zr);
      With zr Do
        ComWrite ('|US' + PadRight (IntToStr (B), 3, ' ') + '|UP) |UI' + PadLeft (Name, 33, ' '));
      If B Mod 2 = 0 Then ComWriteln ('');
      If (B Mod 2 = 0) And (_y Mod curpageLen = curPageLen - 2) And (More (false) = mno) Then Break;
      If Hung Then Exit;
    End;

    If B Mod 2 <> 0 Then ComWriteln ('');
    ComWrite (^M^J'|UP[|USA|UP]|URdd, |UP[|USC|UP]|URhange, |UP[|USD|UP]|URelete, |UP[|USQ|UP]|URuit|UP: |UI');

    Repeat
      Ch := uCase (ReadInChar);
      If Hung Then Break;
    Until Pos (Ch, 'ACDQ') <> 0;

    If Hung Then Break;
    ComWriteLn (CH);
    Case Ch Of
      'A': AddArc;
      'C': EditArc;
      'D': DeleteArc;
      'Q': Break;
    End;
  Until Hung;
  {$I-}
  Close (zf);
  {$IFDEF Debug}{$I+}{$ENDIF}
  If IoResult <> 0 Then ;
End;

function aarctype (from: pathstr): byte;
Var
  zf: File of ArcRec;
  b: byte;
  zr: ArcRec;
  f: file;
  buf: str10;
begin
  aarctype := 0;
  assign (zf, uc. datapath + 'Archiver.Dat');
  {$I-}
  reset (zf);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then exit;
  assign (f, from);
  {$I-}
  reset (f, 1);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then exit;
  while not eof (zf) do with zr do begin
    read (zf, zr);
    {$I-}
    if sigofs < 0 then
      seek (f, filesize (f) - sigofs)
    else
      seek (f, sigofs);
    if ioresult <> 0 then continue;
    blockread (f, buf [1], 10);
    {$IFDEF Debug}{$I+}{$ENDIF}
    if ioresult <> 0 then continue;
    buf [0] := chr (length (sig));
    for b := 1 to length (sig) do
      if sig [b] = '?' then sig [b] := buf [b];
    if buf = zr. sig then begin
      aarctype := filepos (zf);
      break;
    end;
  end;
  close (f);
  close (zf);
end;

procedure parseit (var s: string; var p1, p2, p3: pathstr);
var
  t: string;
  b: byte;
begin
  t := '';
  for b := 1 to length (s) do begin
    if (s [b] = '%') and (b <> length (s)) then case s [succ (b)] of
      '1': begin
             t := t + p1;
             inc (b);
           end;
      '2': begin
             t := t + p2;
             inc (b);
           end;
      '3': begin
             t := t + p3;
             inc (b);
           end;
    end else t := t + s [b];
  end;
  s := t;
end;

function all (azt: byte; at: arctype; p1, p2, p3: pathstr): boolean;
Var
  zf: File of ArcRec;
  zr: ArcRec;
  b: byte;
  s: string;
begin
  all := false;
  if azt = 0 then
    b := aarctype (p1)
  else
    b := azt;
  if b = 0 then exit;
  assign (zf, uc. datapath + 'Archiver.Dat');
  {$I-}
  reset (zf);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then exit;
  seek (zf, pred (b));
  read (zf, zr);
  close (zf);
  with zr do case at of
    cmp: s := comp;
    xtr: s := extr;
    vew: s := view;
    tst: s := test;
    dlf: s := delf;
    adf: s := addf;
    adc: s := addc;
    else s := ''
  end;
  parseit (s, p1, p2, p3);
  with zr do
    all := runcomm (s, '|15A|07rc|08hive |15P|07ro|08cessing', swapout in fags, false) <= maxok;
end;

function aextract (at: byte; from, too, wild: pathstr): boolean;
begin
  aextract := all (at, xtr, from, wild, too);
end;

function acompress (at: byte; too, wild: pathstr): boolean;
begin
  acompress := all (at, cmp, too, wild, '');
end;

function aaddto (at: byte; too, wild: pathstr): boolean;
begin
  aaddto := all (at, adf, too, wild, '');
end;

function adelfrom (at: byte; too, wild: pathstr): boolean;
begin
  adelfrom := all (at, dlf, too, wild, '');
end;

function aviewto (at: byte; from, too: pathstr): boolean;
Var
  zf: File of ArcRec;
  zr: ArcRec;
  b: byte;
  s: string;
begin
  aviewto := false;
  if at = 0 then
    b := aarctype (too)
  else
    b := at;
  if b = 0 then exit;
  assign (zf, uc. datapath + 'Archiver.Dat');
  {$I-}
  reset (zf);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then exit;
  seek (zf, pred (b));
  read (zf, zr);
  close (zf);
  s := '>' + too;
  parseit (zr. view, from, s, s);
  with zr do
    aviewto := runcomm (zr. view, '|15A|07rc|08hive |15P|07ro|08cessing', swapout in fags, true) <= maxok;
end;

function atest (at: byte; from: pathstr): boolean;
begin
  atest := all (at, tst, from, '', '');
end;

function aaddcom (at: byte; too, comf: pathstr): boolean;
Var
  zf: File of ArcRec;
  zr: ArcRec;
  b: byte;
  p, s: string;
begin
  aaddcom := false;
  if not exist (comf) then exit;
  if at = 0 then
    b := aarctype (too)
  else
    b := at;
  if b = 0 then exit;

  assign (zf, uc. datapath + 'Archiver.Dat');
  {$I-}
  reset (zf);
  {$IFDEF Debug}{$I+}{$ENDIF}
  if ioresult <> 0 then exit;
  seek (zf, pred (b));
  read (zf, zr);
  close (zf);

  s := '<' + comf;
  p := zr. addc;
  parseit (p, too, s, s);
  with zr do
    aaddcom := runcomm (p, '|15A|07rc|08hive |15P|07ro|08cessing', swapout in fags, true) <= maxok;
end;

End.
