{$S-,R-,V-,I-,B-,F+,O+,A+,G+}

{Conditional defines that may affect this unit}
{$I APDEFINE.INC}

{*********************************************************}
{*                    APPORT.PAS 1.12                    *}
{*     Copyright (c) TurboPower Software 1991.           *}
{* Portions copyright (c) Information Technology 1989,   *}
{*    and used under license to TurboPower Software      *}
{*                 All rights reserved.                  *}
{*********************************************************}

unit ApPort;
  {-Defines an abstract port data block and some common procedures}

interface

uses
  Dpmi,
  {$IFDEF UseOPro}
  OpRoot,
  {$ENDIF}
  {$IFDEF UseTPro}
  TpMemChk,
  {$ENDIF}
  ApMisc,
  Dos;

type
  {Port characteristic constants}
  {$IFNDEF LargeComNameSet}
  ComNameType = (Com0, Com1, Com2, Com3, Com4, Com5, Com6, Com7, Com8);
  {$ELSE}
  ComNameType = (Com0, Com1,  Com2,  Com3,  Com4,  Com5,  Com6,  Com7,  Com8,
                 Com9,  Com10, Com11, Com12, Com13, Com14, Com15, Com16,
                 Com17, Com18, Com19, Com20, Com21, Com22, Com23, Com24,
                 Com25, Com26, Com27, Com28, Com29, Com30, Com31, Com32,
                 Com33, Com34, Com35, Com36);
  {$ENDIF}

  ParityType = (NoParity, OddParity, EvenParity, MarkParity, SpaceParity);
  DataBitType = 5..8;
  StopBitType = 1..2;
  BPtr = ^Byte;
  CharArray = array[0..MaxInt] of Char;

  {Port record pointer type}
  PortRecPtr = ^PortRec;

  {For saving the state of a ComPort}
  PortSaveRec = record
    PicMask : Byte;
    IER     : Byte;
    MCR     : Byte;
    LCR     : Byte;
    BRLR    : Byte;
    BRHR    : Byte;
    FIFO    : Byte;
    Trigger : Byte;
    Vector  : Pointer;
  end;

  {For PS/2 detection}
  PS2Mode = (PS2On, PS2Off, PS2Auto, PS2Ignore);

  {!!.11 moved from OOCOM/APCOM}
  {Possible flow states}
  FlowState = (fsOff, fsClear, fsTransWait, fsRecWait, fsAllWait);

  {Procedure types for "core" procedures}
  InitPortProc = procedure(var P : PortRecPtr; ComName : ComNameType;
                           Baud : LongInt; Parity : ParityType;
                           DataBits : DataBitType; StopBit : StopBitType;
                           InSize, OutSize : Word;
                           Options : Word);
  InitPortKeepProc = procedure(var P : PortRecPtr; ComName : ComNameType;
                               InSize, OutSize : Word);
  DonePortProc = procedure(var P : PortRecPtr);
  SetUartProc = procedure(ComName : ComNameType; NewBase : Word;
                          NewIrq, NewVector : Byte);
  SetLineProc = procedure(P : PortRecPtr; Baud : LongInt; Parity : ParityType;
                          DataBits : DataBitType; StopBits : StopBitType);
  GetLineProc = procedure(P : PortRecPtr; var Baud : LongInt;
                          var Parity : ParityType;
                          var DataBits : DataBitType;
                          var StopBits : StopBitType;
                          FromHardware : Boolean);
  SetModemProc = procedure(P : PortRecPtr; SetDTR, SetRTS : Boolean);
  GetModemProc = procedure(P : PortRecPtr; var DTR, RTS : Boolean);
  GetCharProc = procedure(P : PortRecPtr; var C : Char);
  PeekCharProc = procedure(P : PortRecPtr; var C : Char; PeekAhead : Word);
  PutCharProc = procedure(P : PortRecPtr; C : Char);
  StartTransmitterProc = procedure(P : PortRecPtr);
  CharReadyFunc = function(P : PortRecPtr) : Boolean;
  TransReadyFunc = function(P : PortRecPtr) : Boolean;
  SendBreakProc = procedure(P : PortRecPtr);
  ActivatePortProc = procedure(P : PortRecPtr; Restore : Boolean);
  SavePortProc = procedure(P : PortRecPtr; var PSR);
  GotErrorProc = procedure(P : PortRecPtr; StatusCode : Word);

  {!!.11 new}
  {Core types added for alternate device layers}
  UpdateLineStatusFunc = function(P : PortRecPtr) : Byte;
  UpdateModemStatusFunc = function(P : PortRecPtr) : Byte;
  FlowSetProc = procedure(P : PortRecPtr; Enable : Boolean;
                          BufferFull, BufferResume : Word;
                          Options : Word);
  FlowGetFunc = function(P : PortRecPtr) : FlowState;
  FlowCtlProc = procedure(P : PortRecPtr; OnChar, OffChar : Char;
                          Resume : Boolean);
  BufferStatusProc = procedure(P : PortRecPtr;
                               var InFree, OutFree, InUsed, OutUsed : Word);
  BufferFlushProc = procedure(P : PortRecPtr; FlushIn, FlushOut: Boolean);

  {Procedure type for error handler}
  AsyncErrorProc = procedure(P : Pointer; var StatusCode : Word);

  {Procedure type for all user aborts}
  AbortFunc = function : Boolean;

  PortRec = record
    BaseAddr      : Word;             {Base IO addr of UART}
    Flags         : Word;             {Option flags for port options}
    InBuffLen     : Word;             {Length of input buffer}
    InBuffCount   : Word;             {Current # of chars in buffer}
    OutBuffLen    : Word;             {Length of output buffer}
    OutBuffCount  : Word;             {Current # of chars in buffer}
    LostCharCount : Word;             {Number of lost characters}
    SWFFull       : Word;             {Hi-water mark for xoff}
    SWFResume     : Word;             {Lo-water mark for xon}
    HWFFull       : Word;             {Hi-water mark for auto-handshaking off}
    HWFResume     : Word;             {Lo-water mark for auto-handshaking on}
    CurBaud       : LongInt;          {Baud rate}
    InBuff        : BPtr;             {Addr of input buffer}
    InHead        : BPtr;             {Addr of current head}
    InTail        : BPtr;             {Addr of current tail}
    InBuffEnd     : BPtr;             {Addr of end of buffer}
    OutBuff       : BPtr;             {Addr of output buffer}
    OutHead       : BPtr;             {Addr of current head}
    OutTail       : BPtr;             {Addr of current tail}
    OutBuffEnd    : BPtr;             {Addr of end-of-buffer}
    StatBuff      : BPtr;             {Addr of status buffer}
    StatHead      : BPtr;             {Addr of current status head}
    StatTail      : BPtr;             {Addr of current status tail}
    StatBuffEnd   : BPtr;             {Addr of end of status buffer}
    PortName      : ComNameType;      {"Standard" name (COM1,COM2...)}
    Vector        : Byte;             {Vector number of UART interrupt}
    IrqNumber     : Byte;             {IRQ number for this port}
    IntMask       : Byte;             {Current UART interrupt enable}
    CurrentPort   : Byte;             {Current active port number}
    ISREntryPoint : Byte;             {Entry point number into APUART.ASM}
    ModemStatus   : Byte;             {Current modem status}
    ModemControl  : Byte;             {Current modem control value}
    LineStatus    : Byte;             {Current line status}
    LineControl   : Byte;             {Current line control value}
    SWFState      : Byte;             {Sofware flow control options}   {!!.12}
    SWFGotXoff    : Boolean;          {True if Xoff char received}
    SWFSentXoff   : Boolean;          {True if Xoff char sent}
    SWFOnChar     : Char;             {SW flow on character (def = $11, Xon)}
    SWFOffChar    : Char;             {SW flow off character (def = $13, Xoff)}
    BreakReceived : Boolean;          {True in break received}
    TxReady       : Boolean;          {True if transmitter is available}
    TxInts        : Boolean;          {True if using transmit interrupts}
    TxIntsActive  : Boolean;          {True if transmit ints are active}
    Buffered      : Boolean;          {True if using buffer serial I/O}
    UseStatusBuffer : Boolean;        {True if using status buffer}
    OldUart       : Boolean;          {True if UART is 8250 or 8250B}
    CurParity     : ParityType;       {Parity}
    CurDataBits   : DataBitType;      {Data bits}
    CurStopBits   : StopBitType;      {Stop bits}
    SaveChar      : Char;             {Last known char (used internally only)}
    LastXmitError : Byte;             {Reason for last failed xmit}
    HWFTransMask  : Byte;             {Mask to XOR modem status bits to zero}
    HWFTransHonor : Byte;             {Mask of required modem status bits}
    HWFRecMask    : Byte;             {Mask of "on" modem status bits}
    HWFRecHonor   : Byte;             {Mask of modem status bits we care about}
    HWFRemoteOff  : Boolean;          {True if we have turned off the remote}
    ISRActive     : Boolean;          {True if in debugging mode}
    ProtocolActive : Boolean;         {True if this port is doing a protocol}
    DoneProc      : DonePortProc;     {DonePort proc for this port}
    ErrorProc     : AsyncErrorProc;   {Pointer to error procedure}
    ErrorData     : Pointer;          {Pointer passed to error routine}
    UserAbort     : AbortFunc;        {Hook for user (keyboard) abort}
    OrigPortState : PortSaveRec;      {Record for saving init port config}
    NewFunc       : Boolean;          {Use new FOSSIL init functions}
  end;

  {Line options record}
  LineOptionRecord = record
    Parity        : ParityType;
    DataBits      : DataBitType;
    StopBits      : StopBitType;
    Options       : Word;
    InSize        : Word;
    OutSize       : Word;
  end;

  {For sets of delimiter chars}
  CharSet = Set of Char;

const
  {---- Option codes for ports ----}
  ptReturnPartialGets  = $0001;   {True to return partial strings}
  ptReturnDelimiter    = $0002;   {True to return delim char}
  ptExecutePartialPuts = $0004;   {True to send partial blocks}
  ptIgnoreDelimCase    = $0008;   {True to ignore case on DelimSets}
  ptRestoreOnClose     = $0010;   {True to restore UART on close}
  ptDropModemOnClose   = $0020;   {True to drop modem signals on close}
  ptRaiseModemOnOpen   = $0040;   {True to raise modem signals on open}

  {---- Internal option codes for ports ----}
  ptHiIrq              = $1000;   {True if IRQ > 7}

  {---- Default options ----}
  DefPortOptionsSimple = ptReturnPartialGets +
                         ptReturnDelimiter +
                         ptExecutePartialPuts +
                         ptRaiseModemOnOpen +
                         ptRestoreOnClose +
                         ptDropModemOnClose;

  DefPortOptions : Word = DefPortOptionsSimple;
  BadPortOptions : Word = ptHiIrq;

  MinInBuff = 10;            {Min allowable input buffer size}
  MinOutBuff = 10;           {Min allowable output buffer size}

  {Constants for supported device types}
  NoDevice = 0;
  UartDevice = 1;
  FossilDevice = 2;                                                    {!!.11}
  Digi14Device = 3;                                                    {!!.11}
  Int14Device = 4;

  {Convenient character constants (and aliases)}
  cNul = #0;
  cSoh = #1;
  cStx = #2;
  cEtx = #3;
  cEot = #4;
  cEnq = #5;
  cAck = #6;
  cBel = #7;
  cBS  = #8;
  cTab = #9;
  cLF  = #10;
  cVT  = #11;
  cFF  = #12;
  cCR  = #13;
  cSO  = #14;
  cSI  = #15;
  cDle = #16;
  cDC1 = #17;       cXon  = #17;
  cDC2 = #18;
  cDC3 = #19;       cXoff = #19;
  cDC4 = #20;
  cNak = #21;
  cSyn = #22;
  cEtb = #23;
  cCan = #24;
  cEM  = #25;
  cSub = #26;
  cEsc = #27;
  cFS  = #28;
  cGS  = #29;
  cRS  = #30;
  cUS  = #31;

  ParityString : array[ParityType] of String[5] = (
    'None', 'Odd', 'Even', 'Mark', 'Space');

  ParityChar : array[ParityType] of Char = (
    'N', 'O', 'E', 'M', 'S');

  DefaultXonChar : Char = cXon;    {Standard Xon char (DC1)}
  DefaultXoffChar : Char = cXoff;  {Standard Xoff char (DC3)}

  PS2DetectMode : PS2Mode = PS2Auto;

  DefaultLineOptions : LineOptionRecord =
   (Parity : NoParity;
    DataBits : 8;
    StopBits : 1;
    Options : DefPortOptionsSimple;
    InSize : 2048;
    OutSize : 2048 + 30);                                              {!!.01}

  {$IFDEF Tracing}
  TracingOn : Boolean = False;
  MaxTraceCol : Byte = 78;
  {$ENDIF}

  {Maximum number of simultaneous active (open) ports}
  MaxActivePort = 36;                                                  {!!.11}

  {8250 register designations}
  THreg  = 0;                        {Transmit hold}
  RDreg  = 0;                        {Read data}
  BRLreg = 0;                        {Baud rate least sig}
  BRHreg = 1;                        {Baud rate most sig}
  IEreg  = 1;                        {Int enable reg}
  IIDreg = 2;                        {Int ident reg}
  LCreg  = 3;                        {Line control}
  MCreg  = 4;                        {Modem control}
  LSreg  = 5;                        {Line status}
  MSreg  = 6;                        {Modem status}
  Sreg   = 7;                        {Scratch register}

  {Line control bit masks}
  WordLen0Mask     = $01;        {Word length select 0}
  WordLen1Mask     = $02;        {Word length select 1}
  StopBitsMask     = $04;        {Number of stop bits}
  ParityEnableMask = $08;        {Parity enable}
  EvenParityMask   = $10;        {Even parity select}
  StickParityMask  = $20;        {Stick parity select}
  SetBreakMask     = $40;        {Set break}
  DLABMask         = $80;        {Set divisor latch access}

  {Line status bit masks}
  DataReadyMask    = $01;        {Receive char is ready}
  OverrunErrorMask = $02;        {Overrun error received}
  ParityErrorMask  = $04;        {Parity error received}
  FramingErrorMask = $08;        {Framing error received}
  BreakReceivedMask= $10;        {Break received}
  THREMask         = $20;        {Transmitter holding register is empty}
  TEMask           = $40;        {Transmitter is empty}
  FIFOErrorMask    = $80;        {FIFO error received}

  {Modem control bit masks}
  DTRMask          = $01;        {Data terminal ready}
  RTSMask          = $02;        {Request to send}
  Out1Mask         = $04;        {Output bit 1}
  Out2Mask         = $08;        {Output bit 2}
  LoopbackMask     = $10;        {Loopback testing}

  {Modem status bit masks}
  DeltaCTSMask     = $01;        {CTS changed since last read}
  DeltaDSRMask     = $02;        {DSR changed since last read}
  DeltaRIMask      = $04;        {RI changed since last read}
  DeltaDCDMask     = $08;        {DCD changed since last read}
  CTSMask          = $10;        {Clear to send}
  DSRMask          = $20;        {Data set ready}
  RIMask           = $40;        {Ring indicator}
  DCDMask          = $80;        {Data carrier detect}

  {Interrupt enable bit masks}
  ReceiveIntMask   = $01;        {Interrupt on received data}
  TransmitIntMask  = $02;        {Interrupt on THR empty}
  LineIntMask      = $04;        {Interrupt on line status change}
  ModemIntMask     = $08;        {Interrupt on modem status change}

  {!!.11 moved from OOCOM/APCOM}
  {Hardware flow control options}
  hfUseDTR         = $01;   {Use DTR for receive flow control}
  hfUseRTS         = $02;   {Use RTS for receive flow control}
  hfRequireDSR     = $04;   {Require DSR before transmittting}
  hfRequireCTS     = $08;   {Require CTS before transmittting}
  hfDTRActiveLow   = $10;   {Make DTR active low}
  hfRTSActiveLow   = $20;   {Make RTS active low}
  hfDSRActiveLow   = $40;   {Make DSR active low}
  hfCTSActiveLow   = $80;   {Make CTS active low}

  sfReceiveFlow    = $01;   {Use receiver flow control}                {!!.12}
  sfTransmitFlow   = $02;   {User transmitter flow control}            {!!.12}
  DefSWFOpt        = sfReceiveFlow + sfTransmitFlow;                   {!!.12}

var
  {Array of active ports}
  ActiveComPort : array[1..MaxActivePort] of PortRecPtr;

  {$IFNDEF UseOOP}
  {Low-level procedure ptrs}
  InitPort         : InitPortProc;
  InitPortKeep     : InitPortKeepProc;
  DonePort         : DonePortProc;
  SetLine          : SetLineProc;
  GetLine          : GetLineProc;
  SetModem         : SetModemProc;
  GetModem         : GetModemProc;
  GetChar          : GetCharProc;
  PeekChar         : PeekCharProc;
  PutChar          : PutCharProc;
  StartTransmitter : StartTransmitterProc;
  CharReady        : CharReadyFunc;
  TransReady       : TransReadyFunc;
  SendBreak        : SendBreakProc;
  ActivatePort     : ActivatePortProc;
  DeactivatePort   : ActivatePortProc;
  SavePort         : SavePortProc;
  RestorePort      : SavePortProc;
  GotError         : GotErrorProc;

  {!!.11 new}
  {Procedure pointers needed by alternate device layers}
  UpdateLineStatus  : UpdateLineStatusFunc;
  UpdateModemStatus : UpdateModemStatusFunc;
  {$IFDEF UseHWFlow}
  HWFlowSet         : FlowSetProc;
  HWFlowGet         : FlowGetFunc;
  {$ENDIF}
  {$IFDEF UseSWFlow}
  SWFlowSet         : FlowSetProc;
  SWFlowGet         : FlowGetFunc;
  SWFlowCtl         : FlowCtlProc;
  {$ENDIF}
  BufferStatus      : BufferStatusProc;
  BufferFlush       : BufferFlushProc;

  {$ENDIF}
  SetUart          : SetUartProc;

  {Special procedure pointer for handling required ANSI responses}     {!!.02}
  AnsiOutput       : PutCharProc;                                      {!!.02}

function IsPS2 : Boolean;
  {-Returns True if the current machine is a PS/2}

function ComNameString(ComName : ComNameType) : String;
  {-Returns a displayable comport name string}

function CheckForString(var Index : Byte; C : Char;                    {!!.11}
                        S : String; IgnoreCase : Boolean) : Boolean;   {!!.11}
  {-Checks for string S on consecutive calls, returns True when found} {!!.11}

procedure RotateIrqPriority(Irq : Byte);                               {!!.11}
  {-Rotate priorities to give Irq the highest priority at the PIC}     {!!.11}

{$IFDEF Tracing}
procedure ClearTracing;
  {-Clears the trace buffer}

procedure AbortTracing;
  {-Stops tracing and destroys the tracebuffer}

procedure InitTracing(NumEntries : Word);
  {-Prepare a circular tracing queue}

procedure AddTraceEntry(CurEntry : Char; CurCh : Char);
  {-Add a trace entry to the global TraceQueue}

procedure DumpTrace(FName : PathStr);
  {-Write the TraceQueue to FName}

procedure StartTracing;
  {-Restarts tracing after a StopTracing}

procedure StopTracing;
  {-Stops tracing temporarily}
{$ENDIF}

function NoAbortProc : Boolean;
  {-Empty abort function}

procedure NoErrorProc(P : Pointer; var StatusCode : Word);
  {-Dummy error procedure}

  {====================================================================}

implementation

var
  PortExitSave : Pointer;

{$IFDEF Tracing}
const
  HighestTrace = 32760;
type
  TraceRecord = record
    EventType : Char;
    C : Char;
  end;
  TraceQueueType = array[0..HighestTrace] of TraceRecord;
const
  TraceQueue : ^TraceQueueType = nil;
var
  TraceIndex : Word;
  TraceMax : Word;
  TraceWrapped : Boolean;
{$ENDIF}

function IsPS2 : Boolean;
  {-Returns True if the current machine is a PS/2}
type
  OS = record
    O : Word;
    S : Word;
  end;
  MachineID = record
    Length   : Word;
    Model    : Byte;
    SubModel : Byte;
  end;
var
  ID : ^MachineID;
  Regs : Registers;
  Model : ^Byte; {absolute $FFFF:$E;}                                  {!!.10}
  {$IFDEF DPMI}
  DRegs : DPMIRegisters;
  IDSel : Word;
  {$ENDIF}
begin
  IsPS2 := False;
  Model := Ptr(BiosSele, $FFFE);                                       {!!.10}

  {Exit if machine is pre-AT}
  if Model^ > $FC then                                                 {!!.02}
    Exit;

  {Get the location of the System Config Table}
  {$IFDEF DPMI}
  FillChar(DRegs, SizeOf(DRegs), 0);                                   {!!.10}
  with DRegs do begin
    AX := $C000;

    if SimulateRealModeInt($15, DRegs) = 0 then ;                      {!!.10}

    {Exit if carry set or ES:BX didn't change}                         {!!.10}
    if ((ES = 0) and (BX = 0)) or Odd(Flags) then                      {!!.10}
      Exit;                                                            {!!.10}

    OS(ID).S := ES;
    OS(ID).O := BX;
    if GetSelectorForRealMem(ID, SizeOf(MachineID), IDSel) = 0 then ;
    ID := Ptr(IDSel, 0);
  end;
  {$ELSE}
  with Regs do begin
    AX := $C000;

    {Initialize ES:BX to nil}                                          {!!.10}
    ES := 0;                                                           {!!.10}
    BX := 0;                                                           {!!.10}

    Intr($15, Regs);

    {Exit if carry set or ES:BX didn't change}                         {!!.10}
    if ((ES = 0) and (BX = 0)) or Odd(Flags) then                      {!!.10}
      Exit;                                                            {!!.10}

    OS(ID).S := ES;
    OS(ID).O := BX;
  end;
  {$ENDIF}

  {ID points to system config table}                                  {!!.02}
  with ID^ do begin                                                   {!!.02}
    {Check for BIOS's that set the high order submodel bit}           {!!.02}
    if (SubModel and $80) = $80 then                                  {!!.02}
      Exit;                                                           {!!.02}
    {Check for PS/2s}                                                 {!!.02}
    if (Model < $FC) or                                               {!!.02}
       ((Model = $FC) and (SubModel > $03)) then                      {!!.02}
      IsPS2 := True;                                                  {!!.02}
  end;                                                                {!!.02}

  {$IFDEF DPMI}                                                       {!!.10}
  if FreeLDTDescriptor(IDSel) = 0 then ;                              {!!.10}
  {$ENDIF}                                                            {!!.10}
end;

function ComNameString(ComName : ComNameType) : String;
  {-Returns a displayable comport name string}
var
  S : String[3];
begin
  Str(Ord(ComName), S);
  ComNameString := 'Com'+S;
end;

{!!.11 new}
function CheckForString(var Index : Byte; C : Char;
                        S : String; IgnoreCase : Boolean) : Boolean;
  {-Checks for string S on consecutive calls, returns True when found}
begin
  CheckForString := False;
  Inc(Index);

  {Upcase both data if ignoring case}
  if IgnoreCase then begin
    C := Upcase(C);
    S[Index] := Upcase(S[Index]);
  end;

  {Compare...}
  if C = S[Index] then
    {Got match, was it complete?}
    if Index = Length(S) then begin
      Index := 0;
      CheckForString := True;
    end else
  else
    {No match, reset Index}
    Index := 0;
end;

{!!.11}
procedure RotateIrqPriority(Irq : Byte);
  {-Rotate priorities to give Irq the highest priority at the PIC}
var
  OCW2 : Byte;
begin
  if (Irq >= 0) and (Irq <=7) then begin
    if Irq = 0 then
      Irq := 7
    else
      Dec(Irq);
    OCW2 := $C0 + Irq;
    Port[$20] := OCW2;
  end;
end;

procedure NoErrorProc(P : Pointer; var StatusCode : Word);
  {-Dummy error procedure}
begin
end;

{$IFNDEF UseOOP}
procedure eInitPort(var P : PortRecPtr; ComName : ComNameType;
                    Baud : LongInt;
                    Parity : ParityType; DataBits : DataBitType;
                    StopBits : StopBitType;
                    InSize, OutSize : Word;
                    Options : Word);
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
end;

procedure eInitPortKeep(var P : PortRecPtr; ComName : ComNameType;
                        InSize, OutSize : Word);
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
end;

procedure eDonePort(var P : PortRecPtr);
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
end;


procedure eSetLine(P : PortRecPtr; Baud : LongInt; Parity : ParityType;
                  DataBits : DataBitType; StopBits : StopBitType);
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
end;

procedure eGetLine(P : PortRecPtr; var Baud : LongInt;
                  var Parity : ParityType;
                  var DataBits : DataBitType;
                  var StopBits : StopBitType;
                  FromHardware : Boolean);
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
end;

procedure eSetModem(P : PortRecPtr; SetDTR, SetRTS : Boolean);
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
end;

procedure eGetModem(P : PortRecPtr; var DTR, RTS : Boolean);
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
end;

procedure eGetChar(P : PortRecPtr; var C : Char);
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
end;

procedure ePeekChar(P : PortRecPtr; var C : Char; PeekAhead : Word);
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
end;

procedure ePutChar(P : PortRecPtr; C : Char);
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
end;

procedure eStartTransmitter(P : PortRecPtr);
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
end;

function eCharReady(P : PortRecPtr) : Boolean;
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
  eCharReady := False;
end;

function eTransReady(P : PortRecPtr) : Boolean;
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
  eTransReady := False;
end;

procedure eSendBreak(P : PortRecPtr);
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
end;

procedure eActivatePort(P : PortRecPtr; Restore : Boolean);
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
end;

procedure eDeactivatePort(P : PortRecPtr; Restore : Boolean);
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
end;

procedure eSavePort(P : PortRecPtr; var PSR);
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
end;

procedure eRestorePort(P : PortRecPtr; var PSR);
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
end;

procedure eGotError(P : PortRecPtr; StatusCode : Word);
  {-Error stub}
begin
end;

{!!.11 new}
function eUpdateLineStatus(P : PortRecPtr) : Byte;
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
  eUpdateLineStatus := 0;
end;

{!!.11 new}
function eUpdateModemStatus(P : PortRecPtr) : Byte;
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
  eUpdateModemStatus := 0;
end;

{!!.11 new}
{$IFDEF UseHWFlow}
procedure eHWFlowSet(P : PortRecPtr; Enable : Boolean;
                     BufferFull, BufferResume : Word;
                     Options : Word);
begin
  AsyncStatus := ecNoDevice;
end;

{!!.11 new}
function eHWFlowGet(P : PortRecPtr) : FlowState;
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
  eHWFlowGet := fsOff;
end;
{$ENDIF}

{!!.11 new}
{$IFDEF UseSWFlow}
procedure eSWFlowSet(P : PortRecPtr; Enable : Boolean;
                     BufferFull, BufferResume : Word;
                     Options : Word);
begin
  AsyncStatus := ecNoDevice;
end;

{!!.11 new}
function eSWFlowGet(P : PortRecPtr) : FlowState;
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
  eSWFlowGet := fsOff;
end;

{!!.11 new}
procedure eSWFlowCtl(P : PortRecPtr; OnChar, OffChar : Char;
                     Resume : Boolean);
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
end;
{$ENDIF}

{!!.11 new}
procedure eBufferStatus(P : PortRecPtr;
                        var InFree, OutFree, InUsed, OutUsed : Word);
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
end;

{!!.11 new}
procedure eBufferFlush(P : PortRecPtr; FlushIn, FlushOut: Boolean);
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
end;
{$ENDIF}

procedure eSetUart(ComName : ComNameType; NewBase : Word;
                   NewIrq, NewVector : Byte);
  {-Error stub}
begin
  AsyncStatus := ecNoDevice;
end;

procedure ActivateErrorStubs;
  {-Activate the non-OOP error stubs}
begin
  {$IFNDEF UseOOP}
  InitPort := eInitPort;
  InitPortKeep := eInitPortKeep;
  DonePort := eDonePort;
  SetLine := eSetLine;
  GetLine := eGetLine;
  SetModem := eSetModem;
  GetModem := eGetModem;
  GetChar := eGetChar;
  PeekChar := ePeekChar;
  PutChar := ePutChar;
  StartTransmitter := eStartTransmitter;
  CharReady := eCharReady;
  TransReady := eTransReady;
  SendBreak := eSendBreak;
  ActivatePort := eActivatePort;
  DeactivatePort := eDeactivatePort;
  SavePort := eSavePort;
  RestorePort := eRestorePort;

  {!!.11 new}
  UpdateLineStatus := eUpdateLineStatus;
  UpdateModemStatus := eUpdateModemStatus;
  {$IFDEF UseHWFlow}
  HWFlowSet := eHWFlowSet;
  HWFlowGet := eHWFlowGet;
  {$ENDIF}
  {$IFDEF UseSWFlow}
  SWFlowSet := eSWFlowSet;
  SWFlowGet := eSWFlowGet;
  SWFlowCtl := eSWFlowCtl;
  {$ENDIF}
  BufferStatus := eBufferStatus;
  BufferFlush := eBufferFlush;

  {$ENDIF}
  SetUart := eSetUart;
end;

{$IFDEF Tracing}
procedure ClearTracing;
  {-Clears the trace buffer}
begin
  TraceIndex := 0;
  TraceWrapped := False;
end;

procedure AbortTracing;
  {-Stops tracing and destroys the tracebuffer}
begin
  if TraceQueue <> nil then begin
    TracingOn := False;
    FreeMemCheck(TraceQueue, TraceMax*2);
  end;
end;

procedure InitTracing(NumEntries : Word);
  {-Prepare a circular tracing queue}
begin
  AsyncStatus := ecOk;

  if TraceQueue <> nil then
    {Just clear buffer if already on}
    ClearTracing
  else begin
    {Limit check size of trace buffer}
    if NumEntries > HighestTrace then begin
      AsyncStatus := ecInvalidArgument;
      Exit;
    end;

    {Allocate trace buffer and start tracing}
    TraceMax := NumEntries;
    TraceIndex := 0;
    TraceWrapped := False;
    if not GetMemCheck(TraceQueue, NumEntries*2) then begin
      AsyncStatus := ecOutOfMemory;
      Exit;
    end;
  end;
  TracingOn := True;
end;

procedure AddTraceEntry(CurEntry : Char; CurCh : Char);
  {-Add a trace event to the global TraceQueue}
begin
  TraceQueue^[TraceIndex].EventType := CurEntry;
  TraceQueue^[TraceIndex].C := CurCh;
  Inc(TraceIndex);
  if TraceIndex = TraceMax then begin
    TraceIndex := 0;
    TraceWrapped := True;
  end;
end;

procedure DumpTrace(FName : PathStr);
  {-Write the TraceQueue to FName}
var
  Start, Len : Word;
  TraceFile : Text;
  TraceFileBuffer : array[1..2048] of Char;
  LastEventType : Char;
  First : Boolean;
  Col : Byte;
  I : Byte;
label
  ExitPoint;

  procedure CheckCol(N : Byte);
    {-Wrap if N bytes would exceed column limit}
  begin
    Inc(Col, N);
    if Col > MaxTraceCol then begin
      WriteLn(TraceFile);
      Col := N;
    end;
  end;

begin
  {Make sure we have something to do}
  if TraceQueue = nil then
    Exit;

  {Set the Start and Len markers}
  Len := TraceIndex;
  if TraceWrapped then
    Start := TraceIndex
  else if TraceIndex <> 0 then
    Start := 0
  else
    {No events, just exit}
    goto ExitPoint;

  {Open the file (overwritting any existing trace file)}
  Assign(TraceFile, FName);
  SetTextBuf(TraceFile, TraceFileBuffer, SizeOf(TraceFileBuffer));
  ReWrite(TraceFile);
  if IoResult <> 0 then begin
    AsyncStatus := ecTraceFileError;
    goto ExitPoint;
  end;

  {Write the trace queue}
  LastEventType := #0;
  First := True;
  Col := 0;
  repeat
    {Some formattting}
    with TraceQueue^[Start] do begin
      if EventType <> LastEventType then begin
        if not First then begin
          WriteLn(TraceFile,^M^J);
          Col := 0;
        end;
        First := False;
        case EventType of
          'T' : WriteLn(TraceFile, 'Transmit: ');
          'R' : WriteLn(TraceFile, 'Receive: ');
          else  WriteLn(TraceFile, 'Special-'+EventType+': ');
        end;
        LastEventType := EventType;
      end;

      {Write the current char}
      if (Ord(C) < 32) or (Ord(C) > 126) then begin
        if Ord(C) > 99 then
          I := 5
        else if Ord(C) > 9 then
          I := 4
        else
          I := 3;
        CheckCol(I);
        Write(TraceFile, '[',Ord(C),']')
      end else begin
        CheckCol(1);
        Write(TraceFile, C);
      end;

      {Get the next char}
      Inc(Start);
      if Start = TraceMax then
        Start := 0;
    end;
    First := False;
  until Start = Len;

  {Clean up}
ExitPoint:
  Close(TraceFile);
  if IOResult <> 0 then ;
  AbortTracing;
end;

procedure StartTracing;
  {-Restarts tracing after a StopTracing}
begin
  if TraceQueue <> nil then
    TracingOn := True;
end;

procedure StopTracing;
  {-Stops tracing temporarily}
begin
  TracingOn := False;
end;
{$ENDIF}

function NoAbortProc : Boolean;
  {-Empty abort function}
begin
  NoAbortProc := False;
end;

procedure PortExitProc;
  {-Exit procedure to close any open com ports}
var
  I : Byte;
begin
  ExitProc := PortExitSave;
  for I := 1 to MaxActivePort do
    if ActiveComPort[I] <> nil then
      ActiveComPort[I]^.DoneProc(ActiveComPort[I]);
end;

var
  I : Integer;
begin
  {Install error stubs}
  ActivateErrorStubs;

  {Init all ports as available}
  for I := 1 to MaxActivePort do
    ActiveComPort[I] := nil;

  {Setup exit procedure to close open com ports}
  PortExitSave := ExitProc;
  ExitProc := @PortExitProc;

  {Init ANSI hook}                                                     {!!.02}
  {$IFNDEF UseOOP}                                                     {!!.02}
  AnsiOutput := ePutChar;                                              {!!.02}
  {$ELSE}                                                              {!!.02}
  @AnsiOutput := nil                                                   {!!.02}
  {$ENDIF}                                                             {!!.02}
end.
