{$S-,R-,V-,I-,B-,F+,O+,A+,G+}

{Conditional defines that may affect this unit}
{$I APDEFINE.INC}

{Include OPro's define file if UseOPro is specified}
{$IFDEF UseOPro}
{$I OPDEFINE.INC}
{$ENDIF}

{Activates Standalone mode heap debugging reports}
{.$DEFINE HeapDebug}

{*********************************************************}
{*                   APMISC.PAS 1.12                     *}
{*        Copyright (c) TurboPower Software 1991.        *}
{*                 All rights reserved.                  *}
{*********************************************************}

unit ApMisc;
  {-Error codes, checksumming, date and other miscellaneous routines}

interface

uses
  {$IFDEF DPMI}                                                        {!!.11}
  WinApi,                                                              {!!.11}
  {$ENDIF}                                                             {!!.11}
  {$IFDEF UseOPro}
  OpDate,
  {$ENDIF}
  {$IFDEF UseTPro}
  TpDate,
  {$ENDIF}
  Dos;

{$IFNDEF UseOPro}
{$IFNDEF Ver50}
type
  {Abstract base for all APro objects}
  RootPtr = ^Root;
  Root = object
    constructor Init;
    destructor Done; virtual;
  end;
{$ENDIF}
{$ENDIF}

{$IFDEF Standalone}
  StringPtr = ^String;
{$ENDIF}

function StatusStr(Code : Word) : String;
  {-Returns a one-line msg for Code}

function UpdateChecksum(CurByte : Byte; CheckSum : Word) : Word;
  {-Returns an updated checksum}
function UpdateCrc(CurByte : Byte; CurCrc : Word) : Word;
  {-Returns an updated Crc16}

function UpdateCrcKermit(CurByte : Byte; CurCrc : Word) : Word;
  {-Returns an updated Crc16 (kermit style)}

const
  Crc32Table : array[0..255] of LongInt = (
  $00000000, $77073096, $ee0e612c, $990951ba, $076dc419, $706af48f, $e963a535,
  $9e6495a3, $0edb8832, $79dcb8a4, $e0d5e91e, $97d2d988, $09b64c2b, $7eb17cbd,
  $e7b82d07, $90bf1d91, $1db71064, $6ab020f2, $f3b97148, $84be41de, $1adad47d,
  $6ddde4eb, $f4d4b551, $83d385c7, $136c9856, $646ba8c0, $fd62f97a, $8a65c9ec,
  $14015c4f, $63066cd9, $fa0f3d63, $8d080df5, $3b6e20c8, $4c69105e, $d56041e4,
  $a2677172, $3c03e4d1, $4b04d447, $d20d85fd, $a50ab56b, $35b5a8fa, $42b2986c,
  $dbbbc9d6, $acbcf940, $32d86ce3, $45df5c75, $dcd60dcf, $abd13d59, $26d930ac,
  $51de003a, $c8d75180, $bfd06116, $21b4f4b5, $56b3c423, $cfba9599, $b8bda50f,
  $2802b89e, $5f058808, $c60cd9b2, $b10be924, $2f6f7c87, $58684c11, $c1611dab,
  $b6662d3d, $76dc4190, $01db7106, $98d220bc, $efd5102a, $71b18589, $06b6b51f,
  $9fbfe4a5, $e8b8d433, $7807c9a2, $0f00f934, $9609a88e, $e10e9818, $7f6a0dbb,
  $086d3d2d, $91646c97, $e6635c01, $6b6b51f4, $1c6c6162, $856530d8, $f262004e,
  $6c0695ed, $1b01a57b, $8208f4c1, $f50fc457, $65b0d9c6, $12b7e950, $8bbeb8ea,
  $fcb9887c, $62dd1ddf, $15da2d49, $8cd37cf3, $fbd44c65, $4db26158, $3ab551ce,
  $a3bc0074, $d4bb30e2, $4adfa541, $3dd895d7, $a4d1c46d, $d3d6f4fb, $4369e96a,
  $346ed9fc, $ad678846, $da60b8d0, $44042d73, $33031de5, $aa0a4c5f, $dd0d7cc9,
  $5005713c, $270241aa, $be0b1010, $c90c2086, $5768b525, $206f85b3, $b966d409,
  $ce61e49f, $5edef90e, $29d9c998, $b0d09822, $c7d7a8b4, $59b33d17, $2eb40d81,
  $b7bd5c3b, $c0ba6cad, $edb88320, $9abfb3b6, $03b6e20c, $74b1d29a, $ead54739,
  $9dd277af, $04db2615, $73dc1683, $e3630b12, $94643b84, $0d6d6a3e, $7a6a5aa8,
  $e40ecf0b, $9309ff9d, $0a00ae27, $7d079eb1, $f00f9344, $8708a3d2, $1e01f268,
  $6906c2fe, $f762575d, $806567cb, $196c3671, $6e6b06e7, $fed41b76, $89d32be0,
  $10da7a5a, $67dd4acc, $f9b9df6f, $8ebeeff9, $17b7be43, $60b08ed5, $d6d6a3e8,
  $a1d1937e, $38d8c2c4, $4fdff252, $d1bb67f1, $a6bc5767, $3fb506dd, $48b2364b,
  $d80d2bda, $af0a1b4c, $36034af6, $41047a60, $df60efc3, $a867df55, $316e8eef,
  $4669be79, $cb61b38c, $bc66831a, $256fd2a0, $5268e236, $cc0c7795, $bb0b4703,
  $220216b9, $5505262f, $c5ba3bbe, $b2bd0b28, $2bb45a92, $5cb36a04, $c2d7ffa7,
  $b5d0cf31, $2cd99e8b, $5bdeae1d, $9b64c2b0, $ec63f226, $756aa39c, $026d930a,
  $9c0906a9, $eb0e363f, $72076785, $05005713, $95bf4a82, $e2b87a14, $7bb12bae,
  $0cb61b38, $92d28e9b, $e5d5be0d, $7cdcefb7, $0bdbdf21, $86d3d2d4, $f1d4e242,
  $68ddb3f8, $1fda836e, $81be16cd, $f6b9265b, $6fb077e1, $18b74777, $88085ae6,
  $ff0f6a70, $66063bca, $11010b5c, $8f659eff, $f862ae69, $616bffd3, $166ccf45,
  $a00ae278, $d70dd2ee, $4e048354, $3903b3c2, $a7672661, $d06016f7, $4969474d,
  $3e6e77db, $aed16a4a, $d9d65adc, $40df0b66, $37d83bf0, $a9bcae53, $debb9ec5,
  $47b2cf7f, $30b5ffe9, $bdbdf21c, $cabac28a, $53b39330, $24b4a3a6, $bad03605,
  $cdd70693, $54de5729, $23d967bf, $b3667a2e, $c4614ab8, $5d681b02, $2a6f2b94,
  $b40bbe37, $c30c8ea1, $5a05df1b, $2d02ef8d
  );

var                                                                    {!!.10}
  Crc32TableOfs : Word;                                                {!!.10}

function UpdateCrc32(CurByte : Byte; CurCrc : LongInt) : LongInt;
  {-Returns an updated crc32}

  (* Model for inline code below
  UpdateCrc32 := Crc32Table[Byte(CurCrc xor LongInt(CurByte))] xor
                 ((CurCrc shr 8) and $00FFFFFF);
  *)

Inline(
                         {;Get args -- DX:BX = CurCrc, CX = CurByte;}
  $5B/                   {        POP     BX}
  $5A/                   {        POP     DX}
  $59/                   {        POP     CX}
  $52/                   {        PUSH    DX}
  $53/                   {        PUSH    BX      ;Save original CurCrc}
                         {;CX:AX := Get Crc32Table[CurCrc xor CurByte];} {!!.10}
  $31/$CB/               {        XOR     BX,CX   ;DX:BX = CurCrc xor CurByte}
  $30/$FF/               {        XOR     BH,BH   ;Byte(DX:BX)}
  $D1/$E3/               {        SHL     BX,1    ;LongInt index}
  $D1/$E3/               {        SHL     BX,1}
  { $C4/$87/>CRC32TABLE/           LES     AX,>Crc32Table[BX]}         {!!.10}
  $03/$1E/>CRC32TABLEOFS/{        ADD     BX,[>Crc32TableOfs]}         {!!.10}
  $8B/$07/               {        MOV     AX,[BX]}                     {!!.10}
  $8B/$4F/$02/           {        MOV     CX,[BX+2]}                   {!!.10}
                         {;DX:BX := (CurCrc shr 8) and $00FFFFFF;}
  $5B/                   {        POP     BX      ;Get original CurCrc}
  $5A/                   {        POP     DX}
  $51/                   {        PUSH    CX      ;Save CX}            {!!.10}
  $B9/$08/$00/           {        MOV     CX,8    ;Shift 8 bits}
  $D1/$EA/               {C1:     SHR     DX,1    ;Hi reg into carry}
  $D1/$DB/               {        RCR     BX,1    ;Carry into lo reg}
  $E2/$FA/               {        LOOP    C1      ; for 8 bits}
  $81/$E2/$FF/$00/       {        AND     DX,$00FF}
                         {;DX:AX := ES:AX xor DX:BX (sets function result)}
  $59/                   {        POP     CX}                          {!!.10}
  $31/$D8/               {        XOR     AX,BX}
  $89/$CB/               {        MOV     BX,CX}                       {!!.10}
  $31/$DA);              {        XOR     DX,BX}

{!!.11}
{$IFDEF DPMI}
function GlobalAllocCheck(var P; Flags : Word; Size : LongInt) : Boolean;
  {-Allocate memory under DPMI, returning True if successful}

{!!.11}
procedure GlobalFreeCheck(var P);
  {-Free memory under DPMI}
{$ENDIF}

{$IFDEF Standalone}
function GetMemCheck(var P; Bytes : Word) : Boolean;
  {-Allocate heap space, returning true if successful}

procedure FreeMemCheck(var P; Bytes : Word);
  {-Deallocate heap space}

{$IFDEF StonyBrook}                                                    {!!.03}
procedure SetFlag(var Flags : Word; FlagMask : Word) [inline];         {!!.03}
begin                                                                  {!!.03}
  Flags := Flags or FlagMask;                                          {!!.03}
end;                                                                   {!!.03}
{$ELSE}                                                                {!!.03}
procedure SetFlag(var Flags : Word; FlagMask : Word);
  {-Set the bit(s) specified by FlagMask in Flags}
  inline(
    $58/                     {pop ax        ;FlagMask into AX}
    $5F/                     {pop di}
    $07/                     {pop es        ;ES:DI => Flags}
    $26/$09/$05);            {or es:[di],ax ;Flags := Flags or FlagMask}
{$ENDIF}

{$IFDEF StonyBrook}                                                    {!!.03}
procedure ClearFlag(var Flags : Word; FlagMask : Word) [inline];       {!!.03}
begin                                                                  {!!.03}
  Flags := Flags and not FlagMask;                                     {!!.03}
end;                                                                   {!!.03}
{$ELSE}                                                                {!!.03}
procedure ClearFlag(var Flags : Word; FlagMask : Word);
  {-Clear the bit(s) specified by FlagMask in Flags}
  inline(
    $58/                     {pop ax         ;FlagMask into AX}
    $5F/                     {pop di}
    $07/                     {pop es         ;ES:DI => Flags}
    $F7/$D0/                 {not ax         ;FlagMask := not FlagMask}
    $26/$21/$05);            {and es:[di],ax ;Flags := Flags and not FlagMask}
{$ENDIF}

{$IFDEF StonyBrook}                                                    {!!.03}
function FlagIsSet(Flags : Word; FlagMask : Word) : Boolean [inline];  {!!.03}
begin                                                                  {!!.03}
  FlagIsSet := (Flags and FlagMask) <> 0;                              {!!.03}
end;                                                                   {!!.03}
{$ELSE}                                                                {!!.03}
function FlagIsSet(Flags, FlagMask : Word) : Boolean;
  {-Returns True if the bit specified by FlagMask is set in Flags}
  inline(
    $5A/                     {pop dx    ;FlagMask into DX}
    $58/                     {pop ax    ;Flags into AX}
    $21/$D0/                 {and ax,dx ;Mask out everything not in FlagMask}
    $74/$02/                 {jz  Exit}
    $B0/$01);                {mov al,1  ;AL = Ord(True)}
                             {Exit:}
{$ENDIF}

{#Z+}
function Search(var Buffer; BufLength : Word;
                var Match; MatLength : Word) : Word;
 {-Search through Buffer for Match. BufLength is length of range to search.
   MatLength is length of string to match. Returns number of bytes searched
   to find Match, $FFFF if not found.}

function StringToHeap(S : string) : StringPtr;                         {!!.02}
  {-Allocate space for s and return pointer}                           {!!.02}

procedure DisposeString(P : StringPtr);                                {!!.02}
  {-Deallocate space for string at p}                                  {!!.02}
{$ENDIF}

function CheckRange(Value, Low, High : Word) : Boolean;
  {-Range check Value against Low and High}

function MakeLongInt(H, L : Word) : LongInt;
  {-Constructs a LongInt from two Words}
  inline(
    $58/                     {pop ax  ;low word into AX}
    $5A);                    {pop dx  ;high word into DX}

{#Z-}

const
  {Error types}
  etFatal          = 0;          {Fatal errors}
  etNonFatal       = 1;          {Non-fatal I/O errors}
  etWarning        = 2;          {Warning messages (currently not used)}
  etMessage        = 3;          {Status information (generally should
                                  not be acted on by an error handler)}

  {Error prefixes}
  epFatal          = etFatal * 10000;
  epNonFatal       = etNonFatal * 10000;
  epWarning        = etWarning * 10000;
  epMessage        = etMessage * 10000;

  {Error/status code constants}
  ecOk                     = 0;     {Reset value for AsyncStatus}

  {DOS errors}
  ecUnknownError           = 0001;  {Unknown}
  ecFileNotFound           = 0002;  {File not found}
  ecPathNotFound           = 0003;  {Path not found}
  ecTooManyFiles           = 0004;  {Too many open files}
  ecAccessDenied           = 0005;  {File access denied}
  ecInvalidHandle          = 0006;  {Invalid file handle}
  ecTotFastError           = 0007;  {Error in TotFast}
  ecOutOfMemory            = 0008;  {Insufficient memory}
  ecTotListError           = 0009;  {Error in TotList}
  ecTotWinError            = 0010;  {Error in TotWin}
  ecModemNoHangup          = 0011;  {Modem won't hangup after 30 sex}
  ecModemRinging           = 0012;  {Modem rang for 10 continuous sex}
  ecInvalidDrive           = 0015;  {Invalid drive}
  ecNoMoreFiles            = 0018;  {No more files}

  {Turbo Pascal I/O errors}
  ecDiskRead               = 0100;  {Attempt to read beyond end of file}
  ecDiskFull               = 0101;  {Disk is full}
  ecNotAssigned            = 0102;  {File not Assign-ed}
  ecNotOpen                = 0103;  {File not open}
  ecNotOpenInput           = 0104;  {File not open for input}
  ecNotOpenOutput          = 0105;  {File not open for output}
  ecInvalidFormat          = 0106;  {Invalid format for packed window}

  {DOS critical errors}
  ecWriteProtected         = 0150;  {Disk is write-protected}
  ecUnknownUnit            = 0151;  {Unknown disk unit}
  ecDriveNotReady          = 0152;  {Drive is not ready}
  ecUnknownCommand         = 0153;  {Unknown command}
  ecCrcError               = 0154;  {Data error}
  ecBadStructLen           = 0155;  {Bad request structure length}
  ecSeekError              = 0156;  {Seek error}
  ecUnknownMedia           = 0157;  {Unknown media type}
  ecSectorNotFound         = 0158;  {Disk sector not found}
  ecOutOfPaper             = 0159;  {Printer is out of paper}
  ecDeviceWrite            = 0160;  {Device write error}
  ecDeviceRead             = 0161;  {Device read error}
  ecHardwareFailure        = 0162;  {General failure}
  ecDivisionbyzero         = 200;
  ecRangecheck             = 201;
  ecStackoverflow          = 202;
  ecHeapoverflow           = 203;
  ecInvalidpointerop       = 204;
  ecFPoverflow             = 205;
  ecFPunderflow            = 206;
  ecInvalidFPop            = 207;
  ecOverlaysnotinstalled   = 208;
  ecOverlayfilereaderror   = 209;
  ecObjectnotinitialized   = 210;
  ecCalltoabstractmethod   = 211;
  ecStreamregerror         = 212;
  ecCollectionindexoutofrange = 213;
  ecCollectionoverflowerror  = 214;
  ecArithmeticoverflowerror = 215;
  ecGeneralProtectionfault  = 216;

  {+++Capacity or environmental errors (2900-2999)+++}

  {APUART port errors}
  ecNoMorePorts            = 2900;  {Can't open port, no slots available}
  ecOverrunError           = 2901;  {UART receiver overrun}
  ecParityError            = 2902;  {UART receiver parity error}
  ecFramingError           = 2903;  {UART receiver framing error}

  {APINT14 port errors}
  ecTransmitFailed         = 2910;  {Int14 transmit failed}
  ecUartError              = 2911;  {Int14 receive failed}

  {APCOM/OOCOM errors/status}
  ecBlockIncomplete        = 2920;  {Block shorter than requested}
  ecBufferIsFull           = 2921;  {No room for new char in buffer}
  ecBufferIsEmpty          = 2922;  {No characters to get}
  ecTimeout                = 2923;  {Timed out waiting for something}
  ecStringIncomplete       = 2924;  {String shorter than requested}
  ecStringOverrun          = 2925;  {String longer than 255}
  ecUserAbort              = 2926;  {User aborted during "wait"}

  {APMODEM/OOMODEM errors}
  ecTableFull              = 2930;  {No room in table to add new entry}
  ecNullCommand            = 2931;  {Modem - no command registered}

  {Tracing/EventFile file errors}
  ecEventFileError         = 2940;  {Failed to open or write to the event file}
  ecTraceFileError         = 2941;  {Failed to open or write to the trace file}

  ecNoFossil               = 2950;  {No device layer installed}
  ecDigiFailure            = 2960;  {Generic Digiboard failure code}
  {+++Warnings or user errors (7900-7999)+++}
  {This category not current used by Async Professional}

  {+++Programmer errors (8900-8999)+++}

  {APCOM/OOCOM port errors}
  ecBadPortNumber          = 8900;  {Out-of-range port number}
  ecOutofRange             = 8901;  {General out-of-range error}
  ecPortNotOpen            = 8902;  {Port not open}
  ecInvalidBaudRate        = 8903;  {Bad baud rate for this device}
  ecInvalidArgument        = 8904;  {General programming error}
  ecNoDevice               = 8905;  {No device layer installed}
  ecNotaUart               = 8906;  {Couldn't find a uart at this address}
  ecInvalidParity          = 8907;  {Bad parity option for this device}
  ecBadFileList            = 8909;  {No end of list marker found in file list}
  ecNotBuffered            = 8910;  {Operation only allowed on buffered ports}
  ecNotSupported           = 8911;  {Function not supported by device-layer}

  {+++Status codes (9800-9999)+++}

  {APABSPCL/OOABSPCL status codes}
  ecInitFail               = 9900;  {Xmodem init failed}
  ecInitCancel             = 9901;  {Xmodem init was canceled on request}
  ecCancelRequested        = 9902;  {Cancel requested}
  ecDuplicateBlock         = 9903;  {Duplicate block received}
  ecSequenceError          = 9904;  {Wrong block number received}
  ecDirNotFound            = 9905;  {Directory not found in protocol transmit}
  ecNoMatchingFiles        = 9906;  {No matching files in protocol transmit}
  ecLongPacket             = 9907;  {Long packet received during protocol}
  ecEndFile                = 9908;  {End of transmitted file}
  ecHandshakeInProgress    = 9909;  {Initial protocol handshake in progress}
  ecFileRenamed            = 9910;  {Incoming file was renamed}
  ecFileAlreadyExists      = 9911;  {Incoming file already exists}
  ecInvalidFilesize        = 9912;  {Ymodem header has bad file size}
  ecInvalidDateTime        = 9913;  {Ymodem header has bad date/time}
  ecUnexpectedChar         = 9914;  {Unexpected char during protocol}
  ecBlockCheckError        = 9915;  {Incorrect CRC or checksum received}
  ecNoSearchMask           = 9916;  {No search mask specified for transmit}
  ecNoFilename             = 9917;  {No filename specifed in xmodem download}
  ecAsciiReceiveInProgress = 9918;  {Ascii receive in progress}
  ecFileRejected           = 9919;  {Receiver rejected file}
  ecTooManyErrors          = 9920;  {Too many errors received during protocol}

  {APZMODEM/OOZMODEM status codes}
  ecGotCrcE                = 9925;  {Zmodem - got CrcE DataSubpacket}
  ecGotCrcW                = 9926;  {Zmodem - got CrcW DataSubpacket}
  ecGotCrcQ                = 9927;  {Zmodem - got CrcQ DataSubpacket}
  ecGotCrcG                = 9928;  {Zmodem - got CrcG DataSubpacket}
  ecGarbage                = 9929;  {Zmodem - got garbage from remote}
  ecSkipFile               = 9930;  {Zmodem - skip file}
  ecBadPosition            = 9931;  {Zmodem - bad file position}
  ecFileDoesntExist        = 9932;  {Zmodem - specified file doesn't exist}
  ecCantWriteFile          = 9933;  {Zmodem - not allowed to overwrite file}
  ecFailedToHandshake      = 9934;  {Zmodem - never got proper handshake}
  ecNoFilesToReceive       = 9935;  {Zmodem - no files to receive}     {!!.02}
  ecBuffersTooSmall        = 9936;  {ZModem - port buffers too small}  {!!.02}
  ecGotHeader              = 9937;  {Zmodem - got a complete header}   {!!.03}
  ecNoHeader               = 9938;  {Zmodem - (internal) no header yet}{!!.03}
  ecGotData                = 9939;  {Kermit - got packet}              {!!.12}
  ecNoData                 = 9955;  {Kermit - no data yet}             {!!.12}

  {APMODEM/OOMODEM status codes}
  ecUnknownModemResult     = 9940;  {Unexpected char in modem result string}
  ecConnect                = 9941;  {Modem response - CONNECT}
  ecRing                   = 9942;  {Modem response - RING}
  ecNoCarrier              = 9943;  {Modem response - NO CARRIER}
  ecNoDialTone             = 9944;  {Modem response - NO DIALTONE}
  ecBusy                   = 9945;  {Modem response - BUSY}
  ecNoAnswer               = 9947;  {Modem response - NO ANSWER}
  ecRinging                = 9948;  {Modem response - RINGING}
  ecVoice                  = 9949;  {Modem response - VOICE}
  ecError                  = 9950;  {Modem response - ERROR}

  {Archive status messages}
  ecUnknownMethod          = 9960;  {Unknown compression method}
  ecFileEncrypted          = 9961;  {Cannot extract--file is encrypted}
  ecBadFileCRC             = 9962;  {Bad CRC--file is probably corrupted}
  ecCannotCreate           = 9963;  {Unable to create output file}
  ecBadFileFormat          = 9964;  {Bad archive file format}          {!!.03}
  ecNotAnLzhFile           = 9965;  {Not an LZH file}
  ecNotAZipFile            = 9966;  {Not a ZIP file}
  ecEmptyFileMaskList      = 9967;  {File mask list is empty}          {!!.02}

  {CaptureTerminalWindow error codes}
  ecScrollBackTooBig       = 9980;  {Scroll back buffer > 64k}

  {$IFDEF UseStreams}
  {--- object type codes for streams ---}
  otUartPort           = 400;
  otInt14Port          = 401;
  otFossilPort         = 402;                                          {!!.10}
  otDigi14Port         = 403;                                          {!!.10}
  otAbstractProtocol   = 410;
  otXmodemProtocol     = 411;
  otYmodemProtocol     = 412;
  otZmodemProtocol     = 413;
  otKermitProtocol     = 414;
  otAsciiProtocol      = 415;
  otAbstractModem      = 420;
  otHayesModem         = 421;
  otCourierModem       = 422;
  otMicrocomModem      = 423;
  otNullModem          = 424;

  otTerminalEmulator   = 440;
  otAnsiEmulator       = 441;

  otSmartVirtScreen    = 450;
  otTerminalWindow     = 451;
  otCaptureTerminalWindow
                       = 452;

  {--- object version codes for streams ---}
  veUartPort           = 0;
  veInt14Port          = 0;
  veFossilPort         = 0;                                            {!!.10}
  veDigi14Port         = 0;                                            {!!.10}
  veAbstractProtocol   = 1;                                            {!!.03}
  veXmodemProtocol     = 1;                                            {!!.03}
  veYmodemProtocol     = 1;                                            {!!.03}
  veZmodemProtocol     = 1;                                            {!!.03}
  veKermitProtocol     = 0;
  veAsciiProtocol      = 0;
  veAbstractModem      = 0;
  veHayesModem         = 0;
  veCourierModem       = 0;
  veMicrocomModem      = 0;
  veNullModem          = 0;

  veTerminalEmulator   = 0;
  veAnsiEmulator       = 0;

  veSmartVirtScreen    = 0;
  veTerminalWindow     = 0;
  veCaptureTerminalWindow = 0;

  {--- pointer codes for streams ---}
  ptErrorProc         = 400;   {User supplied port error procedure}
  ptAbortProc         = 401;   {User supplied port abort procedure}
  ptNoErrorProc       = 402;   {Default error procedure for ports}
  ptNoAbortProc       = 403;   {Default abort procedure for ports}
  ptWaitCharProc      = 404;   {User supplied port waitchar procedure}
  ptNoWaitCharProc    = 405;   {Default waitchar procedure for ports}

  ptUserStatus        = 410;   {User supplied protocol status procedure}
  ptNextFile          = 411;   {User supplied next file procedure}
  ptLogFile           = 412;   {User supplied log file procedure}
  ptAcceptFile        = 414;   {User supplied accept file procedure}
  ptNoUserStatus      = 415;   {Default status procedure}
  ptNextFileMask      = 416;   {Default next file procedure}
  ptNoLogFile         = 417;   {Default log file procedure}
  ptNoAcceptFile      = 418;   {Default accept file procedure}
  ptPortPtr           = 419;   {AbstractPortPtr code}
  ptUserBack          = 420;   {User supplied protocol background proc}  {!!.03}
  ptNoUserBack        = 421;   {Default userback procedure for protocols}{!!.03}
  {$ENDIF}

var
  AsyncStatus : Word;      {holds errors for async code}
var
  ArchiveStatus : Word;    {holds errors for archive code}

const
  {The following table is used internally only. It is interfaced so
   that other programmers can use them with their own CRC routines}

  CrcTable: array[0..255] of Word = (
    $0000,  $1021,  $2042,  $3063,  $4084,  $50a5,  $60c6,  $70e7,
    $8108,  $9129,  $a14a,  $b16b,  $c18c,  $d1ad,  $e1ce,  $f1ef,
    $1231,  $0210,  $3273,  $2252,  $52b5,  $4294,  $72f7,  $62d6,
    $9339,  $8318,  $b37b,  $a35a,  $d3bd,  $c39c,  $f3ff,  $e3de,
    $2462,  $3443,  $0420,  $1401,  $64e6,  $74c7,  $44a4,  $5485,
    $a56a,  $b54b,  $8528,  $9509,  $e5ee,  $f5cf,  $c5ac,  $d58d,
    $3653,  $2672,  $1611,  $0630,  $76d7,  $66f6,  $5695,  $46b4,
    $b75b,  $a77a,  $9719,  $8738,  $f7df,  $e7fe,  $d79d,  $c7bc,
    $48c4,  $58e5,  $6886,  $78a7,  $0840,  $1861,  $2802,  $3823,
    $c9cc,  $d9ed,  $e98e,  $f9af,  $8948,  $9969,  $a90a,  $b92b,
    $5af5,  $4ad4,  $7ab7,  $6a96,  $1a71,  $0a50,  $3a33,  $2a12,
    $dbfd,  $cbdc,  $fbbf,  $eb9e,  $9b79,  $8b58,  $bb3b,  $ab1a,
    $6ca6,  $7c87,  $4ce4,  $5cc5,  $2c22,  $3c03,  $0c60,  $1c41,
    $edae,  $fd8f,  $cdec,  $ddcd,  $ad2a,  $bd0b,  $8d68,  $9d49,
    $7e97,  $6eb6,  $5ed5,  $4ef4,  $3e13,  $2e32,  $1e51,  $0e70,
    $ff9f,  $efbe,  $dfdd,  $cffc,  $bf1b,  $af3a,  $9f59,  $8f78,
    $9188,  $81a9,  $b1ca,  $a1eb,  $d10c,  $c12d,  $f14e,  $e16f,
    $1080,  $00a1,  $30c2,  $20e3,  $5004,  $4025,  $7046,  $6067,
    $83b9,  $9398,  $a3fb,  $b3da,  $c33d,  $d31c,  $e37f,  $f35e,
    $02b1,  $1290,  $22f3,  $32d2,  $4235,  $5214,  $6277,  $7256,
    $b5ea,  $a5cb,  $95a8,  $8589,  $f56e,  $e54f,  $d52c,  $c50d,
    $34e2,  $24c3,  $14a0,  $0481,  $7466,  $6447,  $5424,  $4405,
    $a7db,  $b7fa,  $8799,  $97b8,  $e75f,  $f77e,  $c71d,  $d73c,
    $26d3,  $36f2,  $0691,  $16b0,  $6657,  $7676,  $4615,  $5634,
    $d94c,  $c96d,  $f90e,  $e92f,  $99c8,  $89e9,  $b98a,  $a9ab,
    $5844,  $4865,  $7806,  $6827,  $18c0,  $08e1,  $3882,  $28a3,
    $cb7d,  $db5c,  $eb3f,  $fb1e,  $8bf9,  $9bd8,  $abbb,  $bb9a,
    $4a75,  $5a54,  $6a37,  $7a16,  $0af1,  $1ad0,  $2ab3,  $3a92,
    $fd2e,  $ed0f,  $dd6c,  $cd4d,  $bdaa,  $ad8b,  $9de8,  $8dc9,
    $7c26,  $6c07,  $5c64,  $4c45,  $3ca2,  $2c83,  $1ce0,  $0cc1,
    $ef1f,  $ff3e,  $cf5d,  $df7c,  $af9b,  $bfba,  $8fd9,  $9ff8,
    $6e17,  $7e36,  $4e55,  $5e74,  $2e93,  $3eb2,  $0ed1,  $1ef0
  );

  {==========================================================================}

implementation

  {$I APMISC.PA1}         {StatusStr procedure with default messages}

{$IFDEF HeapDebug}
var
  HDebug : Text;
  SaveExit : Pointer;
{$ENDIF}

{$IFNDEF UseOPro}
{$IFNDEF Ver50}
  constructor Root.Init;
    {-Root constructor for all objects}
  begin
    {nothing to do}
  end;

  destructor Root.Done;
    {-Root destructor for all objects}
  begin
    {nothing to do}
  end;
{$ENDIF}
{$ENDIF}

{$IFDEF Standalone}
const
  DosDelimSet : set of Char = ['\', ':', #0];
  Digits : array[0..$F] of Char = '0123456789ABCDEF';
{$ENDIF}

  function UpdateChecksum(CurByte : Byte; CheckSum : Word) : Word;
    {-Returns an updated checksum}
  begin
    UpdateCheckSum := CheckSum + CurByte;
  end;

  function UpdateCrc(CurByte : Byte; CurCrc : Word) : Word;
    {-Returns an updated CRC16}
  begin
    UpdateCrc := CrcTable[((CurCrc shr 8) and 255)] xor
                 (CurCrc shl 8) xor CurByte;
  end;

  function UpdateCrcKermit(CurByte : Byte; CurCrc : Word) : Word;
    {-Returns an updated Crc16 (kermit style)}
  var
    I : Integer;
    Temp : Integer;
  begin
    for I := 0 to 7 do begin
      Temp := CurCrc xor CurByte;
      CurCrc := CurCrc shr 1;
      if Odd(Temp) then
        CurCrc := CurCrc xor $8408;
      CurByte := CurByte shr 1;
    end;
    UpdateCrcKermit := CurCrc;
  end;

  {$IFDEF Standalone}
  function Search(var Buffer; BufLength : Word;
                  var Match; MatLength : Word) : Word;
   {-Search through Buffer for Match. BufLength is length of range to search.
     MatLength is length of string to match. Returns number of bytes searched
     to find Match, $FFFF if not found.}
  begin
    inline(
      $1E/                   {PUSH DS                 ;Save DS}
      $FC/                   {CLD                     ;Go forward}
      $C4/$7E/<Buffer/       {LES  DI,[BP+<Buffer]    ;ES:DI => Buffer}
      $89/$FB/               {MOV  BX,DI              ;BX = Ofs(Buffer)}
      $8B/$4E/<BufLength/    {MOV  CX,[BP+<BufLength] ;CX = Length of range to scan}
      $8B/$56/<MatLength/    {MOV  DX,[BP+<MatLength] ;DX = Length of match string}
      $85/$D2/               {TEST DX,DX              ;Length(Match) = 0?}
      $74/$24/               {JZ   Error              ;If so, we're done}
      $C5/$76/<Match/        {LDS  SI,[BP+<Match]     ;DS:SI => Match buffer}
      $AC/                   {LODSB                   ;AL = Match[1]; DS:SI => Match[2]}
      $4A/                   {DEC  DX                 ;DX = MatLength-1}
      $29/$D1/               {SUB  CX,DX              ;CX = BufLength-(MatLength-1)}
      $76/$1B/               {JBE  Error              ;Error if BufLength is less}
                             {;Search for first character in Match}
                             {Next:}
      $F2/$AE/               {REPNE SCASB             ;Search forward for Match[1]}
      $75/$17/               {JNE  Error              ;Done if not found}
      $85/$D2/               {TEST DX,DX              ;If Length = 1 (DX = 0) ...}
      $74/$0C/               {JZ   Found              ; the "string" was found}
                             {;Search for remainder of Match}
      $51/                   {PUSH CX                 ;Save CX}
      $57/                   {PUSH DI                 ;Save DI}
      $56/                   {PUSH SI                 ;Save SI}
      $89/$D1/               {MOV  CX,DX              ;CX = Length(Match) - 1}
      $F3/$A6/               {REPE CMPSB              ;Does rest of string match?}
      $5E/                   {POP  SI                 ;Restore SI}
      $5F/                   {POP  DI                 ;Restore DI}
      $59/                   {POP  CX                 ;Restore CX}
      $75/$EC/               {JNE  Next               ;Try again if no match}
                             {;Calculate number of bytes searched and return}
                             {Found:}
      $4F/                   {DEC  DI                 ;DX = Offset where found}
      $89/$F8/               {MOV  AX,DI              ;AX = Offset where found}
      $29/$D8/               {SUB  AX,BX              ;Subtract starting offset}
      $EB/$03/               {JMP  SHORT SDone        ;Done}
                             {;Match was not found}
                             {Error:}
      $31/$C0/               {XOR  AX,AX              ;Return $FFFF}
      $48/                   {DEC  AX}
                             {SDone:}
      $1F/                   {POP  DS                 ;Restore DS}
      $89/$46/<Search);      {MOV [BP+<Search],AX     ;Set func result}
  end;

  {$IFDEF HeapDebug}
  const
    ExtraSize = 10;
    MarkValue = $AA;
  type
    ByteArray = array[1..65521] of Byte;
    OS = record
      O : Word;
      S : Word;
    end;

  procedure DebugExit;
    {-Exit procedure to close the debug file}
  begin
    ExitProc := SaveExit;
    WriteLn(HDebug);
    WriteLn(HDebug, 'Ending MemAvail: ', MemAvail);
    WriteLn(HDebug, 'Ending MaxAvail: ', MaxAvail);
    Close(HDebug);
  end;

  procedure LogError(P : Pointer; Size : LongInt; Bound : Word);
    {-Log memory overwrite errors}
  var
    F : Text;
  begin
    Assign(F, 'HEAPERR.RPT');
    if ExistFile('HEAPERR.RPT') then
      Append(F)
    else
      ReWrite(F);
    if IOResult = 0 then begin
      if Size = -1 then
         WriteLn(F, '  also at ', Bound)
      else
        WriteLn(F, 'Out of bounds occurred on ', HexPtr(P), ' (', Size, ') variable at ', Bound);
      if IOResult = 0 then ;
      Close(F);
      if IOResult = 0 then ;
    end;
  end;
  {$ENDIF}


  function GetMemCheck(var P; Bytes : Word) : Boolean;
    {-Allocate heap space, returning true if successful}
  var
    Pt : Pointer absolute P;
    {$IFDEF HeapDebug}
    X : Pointer;
    {$ENDIF}
  begin
    {$IFDEF HeapDebug}
    Inc(Bytes, ExtraSize);
    GetMem(Pt, Bytes);
    if (Pt <> nil) then begin
      FillChar(Pt^, Bytes, MarkValue);
      GetMemCheck := True;
    end else
      GetMemCheck := False;

    {Log the allocation}
    X := Pointer(Pointer(LongInt(@Bytes)-4)^);
    Dec(OS(X).S, PrefixSeg+$10);
    WriteLn(HDebug, 'from ', HexPtr(X),
                    '  allocate: ', HexPtr(Pointer(P)), ' ', Bytes-ExtraSize);
    {$ELSE}
    GetMem(Pt, Bytes);
    GetMemCheck := (Pt <> nil);
    {$ENDIF}
  end;

  procedure FreeMemCheck(var P; Bytes : Word);
    {-Deallocate heap space}
  var
    Pt : Pointer absolute P;
    {$IFDEF HeapDebug}
    X : Pointer;
    Found : Boolean;
    I : Word;
    {$ENDIF}
  begin
    {$IFDEF HeapDebug}
    X := Pointer(Pointer(LongInt(@Bytes)-4)^);
    Dec(OS(X).S, PrefixSeg+$10);
    WriteLn(HDebug, 'from ', HexPtr(X),
                    '  free:     ', HexPtr(Pointer(P)), ' ', Bytes);

    if (Pt <> nil) then begin
      I := Bytes + 1;
      Found := False;
      while (I <= Bytes + ExtraSize) do begin
        if (ByteArray(Pt^)[I] <> MarkValue) then begin
          if not Found then begin
            Found := True;
            LogError(Pointer(P), Bytes, I);
          end else
            LogError(Pointer(P), -1, I);
        end;
        Inc(I);
      end;

      Inc(Bytes, ExtraSize);
      FreeMem(Pt, Bytes);
      Pt := nil;
    end;
    {$ELSE}
    if Pt <> nil then begin
      FreeMem(Pt, Bytes);
      Pt := nil;
    end;
    {$ENDIF}
  end;

  {!!.02}
  function StringToHeap(S : string) : StringPtr;
    {-Allocate space for s and return pointer}
  var
    L : Word;
    P : Pointer;
  begin
    L := Succ(Word(Length(S)));
    if MaxAvail < L then
      StringToHeap := nil
    else begin
      GetMem(P, L);
      Move(S, P^, L);
      StringToHeap := P;
    end;
  end;

  {!!.02}
  procedure DisposeString(P : StringPtr);
    {-Deallocate space for string at p}
  begin
    if P <> nil then
      FreeMem(P, Succ(Word(Byte(P^[0]))));
  end;

  {$F+}
  function HeapFunc(Size : Word) : Integer;
    {-Return nil pointer if insufficient memory}
  begin
    {$IFDEF Heap6}
    if Size = 0 then
      HeapFunc := 2
    else
    {$ENDIF}
    HeapFunc := 1;
  end;
  {$F-}
  {$ENDIF}

  {!!.11}
  {$IFDEF DPMI}
  function GlobalAllocCheck(var P; Flags : Word; Size : LongInt) : Boolean;
    {-Allocate memory under DPMI, returning True if successful}
  var
    Pt : Pointer absolute P;
  begin
     Pt := GlobalAllocPtr(Flags, Size);
     GlobalAllocCheck := Pt <> nil;
   end;

  {!!.11}
  procedure GlobalFreeCheck(var P);
    {-Free memory under DPMI}
  var
    Pt : Pointer absolute P;
  begin
    if Pt <> nil then begin
      if GlobalFreePtr(Pt) <> 0 then ;
      Pt := nil;
    end;
  end;
  {$ENDIF}

  function CheckRange(Value, Low, High : Word) : Boolean;
    {-Range check Value}
  begin
    if (Value < Low) or (Value > High) then begin
      CheckRange := False;
    end else
      CheckRange := True;
  end;

begin
  {$IFDEF Standalone}
  HeapError := @HeapFunc;
  {$ENDIF}

  {$IFDEF HeapDebug}
  {Delete old heap error report}
  Assign(HDebug, 'HEAPERR.RPT');
  Erase(HDebug);
  if IOResult <> 0 then ;

  {Open new heap allocation report file}
  Assign(HDebug, 'HEAP.RPT');
  Rewrite(HDebug);
  WriteLn(HDebug, 'Initial MemAvail: ', MemAvail);
  WriteLn(HDebug, 'Initial MaxAvail: ', MaxAvail);
  WriteLn(HDebug);
  if IOResult <> 0 then ;

  SaveExit := ExitProc;
  ExitProc := @DebugExit;
  {$ENDIF}

  Crc32TableOfs := Ofs(Crc32Table);                                    {!!.10}
end.
