(****************************************************************************

               P32IDE - 32bit Pascal Compiler with IDE

 ---------------------------------------------------------------------------
                   Michael Goddard - magnesium@hehe.com (IDE)
                       Johan Prins - jprins@knoware.nl (P32)
 ==========================================================================
 Main-program for IDE version (v0.02b)                        P32IDE (c)'98
 http://www.cryogen.com/p32
 http://surf.to/p32
 --------------------------------------------------------------------------
 Use: TP 7.0 to compile. And yes we all know the irony of a Pascal compiler
      in Pascal so no need to point it out again.

 Note: This is a VERY early version, and I encourage everyone to make up
       their own, Todo/Wishlist for the IDE. Because the more Idea's we
       have the better it'll become. (Send to magnesium@hehe.com)

 Run Note: Some ProtectMode programs cannot be run from TP but most can run
           under P32IDE, IME. ('In My Experience' if you didn't know)
           That's if you don't run out of memory.

 Email: magnesium@hehe.com (no attachments)
        cgoddard@ozemail.com.au (for attachments)
        jprins@knoware.nl (To do with the compiler)

  P32IDE is now part of P32, an IDE attachment for this Free Pascal
 compiler. And your reading the sources right now. All I (and probably
 johan) ask is that you learn from this, help us in this, and write
 good programs in this. The Compiler is a later version so is neater.
 Plus it generates pretty tight code compared with other compilers.
 The IDE uses Object's, see P32IDEU.PAS for a better view. Ok, enough
 typing, just read the sources and rulez on changing. Oh yeah, and read
 johan's DOC files if you havn't already.

 Rulez: (Some rulez when adding to the code)
  1. Mark your code like so
     {** <Your Name, and an email if you wish> }
     This is so I (& others) can find the changes. (via Find '**')
  2. Only comment the previous code if changed.
     After we all make sure it works the old stuff can be removed
  3. Email the files you change to Johan if it's part of the
     compiler, or me (cgoddard@ozemail.com.au/magnesium@hehe.com)
     if it's MMOUSE.PAS, KEY_UNIT.PAS, P32IDE.PAS or P32IDEU.PAS.
     If you don't get a reply within a week ask the other one of us.
  4. Remember! The code must be compilable in either the Command
     Line version or the IDE by changing the compiler directive
     only. (and using P32.PAS not P32IDE.PAS)
  5. If your not sure you should do something just ask, there is
     a reason for some things but most of the IDE welcomes
     improvements, all you need to do is ask :)
  6. Your name goes in the contributors (unless you don't want it in)
     if you write a sizable part, ie. don't expect much for two lines
     of code apart from a thankyou. (unless it's a _really_ big bug)
  7. Obey the last 6, or shall ye be struck down by a bolt of lightning!
     ZZZZ, oh I deserved that. Yeah, and this is FREE for anything
     except selling it or slight modifications etc. etc. You know.
  8. Visit the web site, www.cryogen.com/p32/ for the latest release
     and make your changes to that one to avoid doubling up.

 TODO:
  - Bracket Highlighting, incl () & [] separately
     Rewrite Highlighting to store some info like
       CP_Long (Where Cursor is)
       ??       If it's a (/[/)/] IsHighlight
                & the Position of the matching one
       ??       Same as above for BEGIN/END as word
                position's
  - Allow nested comments when it's set in the compiler
  - Add a GREP and FC Command
  - Ctrl-Enter opens ???.PAS at cursor pos.
  - Alt/Ctrl-F9 to Compile/Run . . . like TP, F9 Makes
  - Fix File window to use the scroll Bar
  - Fix the SourceWindow to -Xs/Ys from the Scroll size to scroll properly
    from the fix to get end of scroller = end of text, not page below

 Bugs:
  - It's forever running out of memory.
  - When changing ScreenSize the Mouse isn't re-inited always to fit in
    new screen size, DOIT.
  - On a highlighted word like BEGIN/END/CASE/RECORD the end will not be
    highlighted if the initial BEGIN.. is above the top displayed line
    This is fixable, scanning backwards through the file if an END is
    found but it's just not done yet.
  - Something strange is occuring during highlighting the first word if
    comments preceed it, only on some words sometimes, strange.
  - On Errors, if there is no semicolon, the error appears on the wrong
    line, a new variable in the compiler is needed to store pre-parsing
    position, I think.

****************************************************************************)

{- You may need the stack set to 65520, the first number here -}
{$M 48000 0 655360}

{$DEFINE P32IDE}

Uses P32IDEU, P32_cfg, P32_scan, P32_err, Dos;

 Function STR_Trim(St: String): String;
 begin

  {- Remove leading Spaces/Tabs . . . -}
  If (St[1] in [#0,#8..#13,#32,#255]) and (St <> '') then
   repeat
    Delete(St, 1, 1);
   until (not (St[1] in [#0,#8..#13,#32,#255])) or (St='');
  {- Remove trailing Spaces/Tabs -}
  if (St[Length(St)] in [#0,#8..#13,#32,#255]) and (St <> '') then
   repeat
    Dec(St[0]);
   until (not (St[Length(St)] in [#0,#8..#13,#32,#255])) or (St='');

  STR_Trim := St;
 end;


{-
  Function to convert ANY number string to a Real number.
   ie. Decimal     2, 4k, 8Mb, 4.2kb
       Binary      0110b, %100k, %1001.101
       Hex         0xA0, $B4, 0Dhk
       Octal       73o, 3.5oMb
       Ternary     1021t
       Multipliers k/Kb = *1024, m/Mb = * 1024*1024 . . .
-}
Var BCP_StrToNum_LastError: Integer;

Function BCP_StrToNumR(St: String): Real;
Const HexTable: String = ('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ');
 {* Converts a string to UpperCase *}
 Function UCase(St: String): String;
 Var i: byte;
 Begin
  for i:=1 to length(St) do St[i] := UpCase(St[i]);
  UCase := St;
 End;
Label BCP_NumberProcessed;
Var nType: (None, Dec, Hex, Bin, Oct, Chr, Ter); NewNum: Real;
    i: byte;Mult: Longint;dp, nchmul: Longint;
begin
 BCP_StrToNumR := 0;NewNum := 0;St := UCase(St); Mult := 1;
 nchmul := 10; BCP_StrToNum_LastError := 0; dp := 0;

 {- Find Multipliers -}
 If (St[Length(St)] = 'K') then begin;Delete(St, Length(St), 1);Mult := 1024;end;
 If (St[Length(St)] = 'M') then begin;Delete(St, Length(St), 1);Mult := 1024 * 1024;end;
 If (St[Length(St)] = 'G') then begin;Delete(St, Length(St), 1);Mult := 1024 * 1024 * 1024;end;
 If (St[Length(St)-1] = 'K') and (St[Length(St)] = 'B') and (Length(St) > 2) then
     begin;Delete(St, Length(St)-1, 2);Mult := 1024;end;
 If (St[Length(St)-1] = 'M') and (St[Length(St)] = 'B') and (Length(St) > 2) then
     begin;Delete(St, Length(St)-1, 2);Mult := 1024 * 1024;end;
 If (St[Length(St)-1] = 'G') and (St[Length(St)] = 'B') and (Length(St) > 2) then
     begin;Delete(St, Length(St)-1, 2);Mult := 1024 * 1024 * 1024;end;

 {- Decimals have no signature so we check for non-decimal chars -}
 nType := Dec;
 For i:=1 to length(St) do
  if not (St[i] in ['0'..'9','.']) then nType := None;
 {- Check for FirstChar Number types first - like Pascal -}
 if (nType = none) then
 Case St[1] of
   '0': if St[2] = 'x' then begin;nType := Hex;Delete(St, 1, 2);end;
   '$': begin;nType := Hex;Delete(St, 1, 1);end;
   '%': begin;nType := Bin;Delete(St, 1, 1);end;
 end;
 {- Now check Assembler style number -}
 if (nType = none) then
 Case St[Length(St)] of
   'H': begin;nType := Hex;Delete(St, Length(St), 1);end;
   'B': begin;nType := Bin;Delete(St, Length(St), 1);end;
   'O': begin;nType := Oct;Delete(St, Length(St), 1);end;
   'T': begin;nType := Ter;Delete(St, Length(St), 1);end;
 end;

 {- Get the Base of the number -}
 Case nType of
  Dec: nchmul := 10;
  Hex: nchmul := 16;
  Oct: nchmul := 8;
  Ter: nchmul := 3;
  Bin: nchmul := 2;
 end;

 {- Convert the chars to a Real, upto Base36, INCLUDING FRACTIONAL! -}
 for i:=1 to Length(St) do
 begin
  Case St[i] of
   '.': dp := nchmul; {- You can even use 1011.101b -}
  else
   if (dp = 0) then
    NewNum := NewNum * nchmul + (Pos(St[i], HexTable)-1)
   else
    begin
     NewNum := NewNum + ((Pos(St[i], HexTable)-1) / dp);
     dp := dp * nchmul;
    end;
  end;

  {- Process errors - like a 2 in a binary string or G in Hex -}
  if ((Pos(St[i], HexTable)-1) > nchmul) then
  begin
   BCP_StrToNum_LastError := i;
   BCP_StrToNumR := 0;
   exit;
  end;

 end;
 {- Use multiplies to output in correct units (Kb/Mb/Gb...) -}
 BCP_StrToNumR := NewNum * Mult;
end;




Procedure ReadINI(St: String);
 function UCase(St:String):String;var i:byte;begin;for i:=1 to length(St) do St[i] := UpCase(St[i]);UCase := St;end;
 Function IsTrueST(St: String): Boolean;
 begin
  St := UCase(St);
  if (St = 'YES') then IsTrueST := True else
  if (St = 'TRUE') then IsTrueST := True else
  if (St = 'ON') then IsTrueST := True else
  if (St = 'NO') then IsTrueST := False else
  if (St = 'FALSE') then IsTrueST := False else
  if (St = 'OFF') then IsTrueST := False else
   Writeln('Error parsing P32.INI');
 end;
 Function Trim(St: String): STring;
 begin;
  While (St[1] in [#0,#32,#255]) and (St[0]<>#0) do Delete(St, 1, 1);
  While (St[Length(St)] in [#0,#32,#255]) and (St[0]<>#0) do Delete(St, Length(St), 1);
  Trim := St;
 end;
 Procedure SetValB(var b: Byte; St: String);
 var BNum: Longint;
 begin
  St := Trim(St);
  BNum := Round(BCP_StrToNumR(St));
  if BCP_StrToNum_LastError = 0 then b := bnum;
 end;
var cSt, ParST: String; Th: Text;cSEC: (_none, _Colour, _IDE, _P32);
begin
 Assign(Th, St);
 Reset(Th);
  Repeat
   Readln(Th, cSt);
   While (cSt[1] in [#0,#32,#255]) and (cSt[0]<>#0) do Delete(cSt, 1, 1);
   if Pos(';', cSt)>0 then cSt[0] := Chr(Pos(';', cSt)-1);

   ParST := '';
   if Pos('=', cSt)>0 then
    begin
     ParST := cSt;
     cSt[0] := Chr(Pos('=', cSt)-1);
     Delete(ParSt, 1, Length(cSt)+1);
     cSt := Trim(cSt);
     ParST := Trim(ParSt);
    end;

cSt := UCase(cSt);

   Case cSt[1] of
    '[': begin
          cSEC := _none;
          if (cSt = '[IDE]') then cSEC := _IDE;
          {- COLOR for the Americans who spell it wrong -}
          if (cSt = '[COLOR]') then cSEC := _Colour;
          if (cSt = '[COLOUR]') then cSEC := _Colour;
         end;
     else
      if ParST <> '' then
      Case cSEC of
       _IDE: begin
              if cSt = 'NONAME' then IDE.P32.NoName := ParST;
              if cSt = 'EXT' then IDE.P32.Ext := ParST;
              if cSt = 'SMALLFONT' then IDE.SmallFont := IsTrueST(ParST);
              if Copy(cSt,1,9) = 'NESTEDCOM' then IDE.NestComment := IsTrueST(ParST);
              if Copy(cSt,1,7) = 'NESTCOM' then IDE.NestComment := IsTrueST(ParST);

             end;
       _Colour: begin
                 {- Saves time in typing SYNTAX all the time -}
                 if Copy(cSt, 1, 2) = 'S.' then Insert('YNTAX', cSt, 2);

                 {- Least amount of chars required to ID the string -}
                 if Copy(cSt,1,9) = 'SYNTAX.CO' then SetValB(IDE.c.Syntax.Comment    , ParST);
                 if cSt = 'SYNTAX.RESERVED'     then SetValB(IDE.c.Syntax.Reserved   , ParST);
                 if cSt = 'SYNTAX.RES'          then SetValB(IDE.c.Syntax.Reserved   , ParST);
                 if cSt = 'SYNTAX.RESERVED2'    then SetValB(IDE.c.Syntax.Reserved2  , ParST);
                 if cSt = 'SYNTAX.RES2'         then SetValB(IDE.c.Syntax.Reserved2  , ParST);
                 if Copy(cSt,1,9) = 'SYNTAX.ID' then SetValB(IDE.c.Syntax.Identifiers, ParST);
                 if Copy(cSt,1,9) = 'SYNTAX.SY' then SetValB(IDE.c.Syntax.Symbols    , ParST);
                 if Copy(cSt,1,9) = 'SYNTAX.ST' then SetValB(IDE.c.Syntax.Strings    , ParST);
                 if Copy(cSt,1,8) = 'SYNTAX.N'  then SetValB(IDE.c.Syntax.Numbers    , ParST);
                 if Copy(cSt,1,8) = 'SYNTAX.A'  then SetValB(IDE.c.Syntax.AsmSrc     , ParST);
                 if cSt = 'SYNTAX.NONE'         then SetValB(IDE.c.Syntax.None       , ParST);

                 if cSt = 'ERROR'               then SetValB(IDE.c.Error             , ParST);

                 if cSt = 'BUTTON'              then SetValB(IDE.c.Button            , ParST);
                 if Copy(cSt,1,7) = 'BUTTONH'   then SetValB(IDE.c.ButtonH           , ParST);


                end;
      end;
   end;
  Until Eof(Th);
 Close(Th);
end;

{- Reads the command line checking for valid filenames and loads them -}
Procedure ReadParams;
var i  : word;
    s  : string;
   _D  : DirStr;
   _N  : NameStr;
   _E  : ExtStr;

begin
 for i:=1 to ParamCount do
 begin
{johan}
   s:=ToUpper(ParamStr(i));
   if FileExists(s) then
     begin {file with no extension, that exists}
       cmSend_St := s;
       cmSend(cm_LoadEdit);
     end
   else    {file with no extension, ADD .pas}
     begin
       fsplit(s, _D, _N, _E);
       if _E='' then _E:='.PAS';
       s:=_D+_N+_E;
       if FileExists(s) then
         begin {file with added .pas extension, that exists}
           cmSend_St := s;
           cmSend(cm_LoadEdit);
         end;
     end;
 end;
end;

begin
  writeln('P32 ' + P32_version + ' by Johan Prins, jprins@knoware.nl    [' + compiledate+']');
  writeln('P32IDE '+ P32IDE_Ver + ' by Michael Goddard, cgoddard@ozemail.com.au');

  if FileExists('P32.INI') then
   ReadINI('P32.INI')
    else
   ReadINI(FSearch('P32.INI','.'+GetEnv('P32')+';'+GetEnv('PATH')));

 IDE_Init;

 ReadParams;

 IDE.Quit := False;
 repeat

  ProcessEvents;

 until IDE.Quit;

 IDE_Done;
{$IFNDEF PMODE}
 Release(HeapOrg);
{$ENDIF}
end.
