program HORIZSCROLL;
{program: Smooth Pixel by Pixel Horizontal Scrolling in Text mode         }
{programmer: Brent Hostetler                                              }
{email: brenth@kaiwan.com                                                 }
{                                                                         }
{  This source code is distributed as is, no waranty to work at all. Due  }
{ to the nature of the code, Direct VGA card port accesing I will not     }
{ gurantee this to work on all computers, there is the possibilty it could}
{ screw up your video hardware. I have tested this although on my Compaq  }
{ 486, with Cirrus Logic Video chip and everything works fine. If you have}
{ any problems, code not working, whatever, let me know I'd be interested }
{ in whether it is a software bug or hardware not to specs.               }
{                                                                         }
{  On the lighter side. Enjoy, and hopefully learn something. I know I    }
{ I did!! :> You may use this code however you like as long as if you     }
{ modify this code you mention me!!                                       }
{  Do not redistribute withought included comments please!!               }

const
      VirtualWidth      = 160;   {This is width of screen in bytes}
                                 {keep in mind this doesnt account for}
                                 {attributes}
      VirtualHeight     = 25;    {This is the height of our virtual Screen}
type
      VirSCR = array[1..VirtualWidth*VirtualHeight*2] of char;
                                 {This defines a array type the size of our}
                                 {Virtual Screen but X 2 to account for Attribute}
var
      VirtualScreen : VirSCR absolute $B800:0000; {This mirrors our array to}
                                                  {video memory allowin direct}
                                                  {video writes through array}
      OFFSINC       : byte;      {keeps track of current character position}
      PIXEL         : byte;      {keeps track of which pixel is started with}

{$I MYTEXT.PAS}     {include file contains MYTEXT array of our display screen}

procedure SetupScreen;
var       a, yloop,xloop : integer;
begin
      {The following two lines access the vga cards registers}
      {and program in the width of our virtual display.      }
      {We have to divide by two because it expects the size in words not bytes}

      port[$3D4] := $13;               {set CRTC INDEX reg to CRTC OFFSET REG}
      port[$3D5] := VirtualWidth div 2;{Set Screen width in number of words}

      {lets clear out the whole display to be safe of no garbage}
      a := 1;
      while a < VirtualWidth*VirtualHeight do
        begin
            VirtualScreen[a] := ' '; {clear character}
            inc(a,1);
            VirtualScreen[a] := #0;  {clear attribute}
            inc(a,1);
        end;

      {This simply loops through the memory again.. I know theres better ways :>}
      {and puts our message in display}
      a := 1;
      for yloop := 0 to MYTEXT_DEPTH-1 do {loop the length of our message}
        begin
          for xloop := 1 to 160 do        {there are 80 char & attr per line}
            begin
              VirtualScreen[a] := MYTEXT[yloop*160+xloop];
              inc(a,1);
            end;
          a := a+ 160;                    {this increments past the extra 80 blank chars}
        end;
end;

procedure Shutdown;
{restores VGA registers}
begin
      port[$3D4] := $13;             {set CRTC INDEX reg to CRTC OFFSET REG}
      port[$3D5] := 40;              {Set Screen width in number of words}
      port[$03D4] := $C;             {start address low}
      port[$03D5] := 0;
      port[$03D4] := $D;             {start address high}
      port[$03D5] := 0;
      port[$3C0] := $20 or $13;
      port[$3C0] := 8;
end;

procedure ScrollLeft;
begin
 repeat
  asm
        mov     dx, $03DA            {Wait for Display Enable}
     @@20:
        in      al, dx               {This makes sure where in a display}
        and     al, 1                {mode before we screw with anything}
        jnz     @@20                 {otherwise changes could go in effect}
  end;                               {half way through a display. BAD!}
  if PIXEL = 7 then
    begin                            {if ready to pan by new character}
      inc(OFFSINC,1);                {increment the start address}
      port[$03D4] := $C; {start address low}
      port[$03D5] := 0;
      port[$03D4] := $D; {start address high}
      port[$03D5] := OFFSINC;        {make it so}

      pixel := 8;                    {reset pixel to normal pixel shift}
      port[$3C0] := $20 or $13;      {select Horizontal Pixel Pan register}
      port[$3C0] := pixel;           {store it}
    end
  else                               {else we must be in the middle of }
    begin                            {smooth pixel adjusting}
      if pixel = 8 then              {if we are at no pan set to shift 1}
        pixel := 0
      else
        inc(pixel,1);                {increment number of pixel shirt}

      port[$3C0] := $20 or $13;      {select horizontal pixel pan register}
      port[$3C0] := pixel;           {store it}

    end;
  asm
       mov      dx, $03DA            {wait vertical retrace}
    @@10:
       in       al, dx               {give changes some time to take effect}
       and      al, 8                {before we do anything else}
       jnz      @@10
    @@20:
       in       al, dx
       and      al, 8
       jz       @@20
  end;
 until offsinc = 80;                {keep scrolling untill we scrolled whole page}

end;

procedure ScrollRight; {same as above procedure just in reverse}
begin
 repeat
  asm
        mov     dx, $03DA
     @@20:
        in      al, dx
        and     al, 1
        jnz     @@20
  end;
  if PIXEL = 8 then
    begin
      dec(OFFSINC,1);
      port[$03D4] := $C; {start address low}
      port[$03D5] := 0;
      port[$03D4] := $D; {start address high}
      port[$03D5] := OFFSINC;

      pixel := 7;
      port[$3C0] := $20 or $13;
      port[$3C0] := pixel;
    end
  else
    begin
      if pixel = 0 then
        pixel := 8
      else
        dec(pixel,1);

      port[$3C0] := $20 or $13;
      port[$3C0] := pixel;

    end;
  asm
       mov      dx, $03DA
    @@10:
       in       al, dx
       and      al, 8
       jnz      @@10
    @@20:
       in       al, dx
       and      al, 8
       jz       @@20
  end;
 until (offsinc = 0) and (pixel = 8);


end;


begin
     offsinc := 0;      {set inital character scroll to zero}
     pixel   := 8;      {initialize pixel to no pixel shift}
     SetupScreen;       {setup screen message and virtual width}
     ScrollLeft;        {scroll message left/ (acctually pan right)}
     ScrollRight;       {scroll message right}
     readln;            {wait key}
     ShutDown;          {restore all modified registers. }
end.