program msgView;

uses Dos, DateTime, Misc;

type
   tFidoHeadRec = record
      maFrom,
      maTo           : array[1..36] of Char;
      maSubject      : array[1..72] of Char;
      maDate         : array[1..20] of Char;
      maTimesRead,
      nodeDest,
      nodeOrig,
      maCost,
      netOrig,
      netDest         : Integer;
      dateWritten,
      dateArrived     : LongInt;
      maRef           : Integer;
      maAttr          : Word;
      UnReply         : Integer;
   end;

var H : tFidoHeadRec;
    fH : file;
    S : String;
    Z : Word;

begin
   Assign(fH,ParamStr(1));
   {$I-}
   Reset(fH,1);
   {$I+}
   if ioResult <> 0 then
   begin
      WriteLn('File not found.');
      Halt(255);
   end;
   BlockRead(fH,H,SizeOf(H));
   Z := H.maAttr;
   S := '';
   if mGetBit(Lo(Z),00) then S := S+'Private ';
   if mGetBit(Lo(Z),01) then S := S+'Crash ';
   if mGetBit(Lo(Z),02) then S := S+'Received ';
   if mGetBit(Lo(Z),03) then S := S+'Sent ';
   if mGetBit(Lo(Z),04) then S := S+'FileAttch ';
   if mGetBit(Lo(Z),05) then S := S+'InTransit ';
   if mGetBit(Lo(Z),06) then S := S+'Orphan ';
   if mGetBit(Lo(Z),07) then S := S+'KillSent ';
   if mGetBit(Hi(Z),00) then S := S+'Local ';
   if mGetBit(Hi(Z),01) then S := S+'Hold ';
   if mGetBit(Hi(Z),02) then S := S+'Unused ';
   if mGetBit(Hi(Z),03) then S := S+'FileReq ';
   if mGetBit(Hi(Z),04) then S := S+'ReceiptReq ';
   if mGetBit(Hi(Z),05) then S := S+'IsReceipt ';
   if mGetBit(Hi(Z),06) then S := S+'AuditReq ';
   if mGetBit(Hi(Z),07) then S := S+'UpdateReq ';
   if S = '' then S := 'None' else Delete(S,Length(S),1);
   WriteLn('From        : ',H.maFrom);
   WriteLn('To          : ',H.maTo);
   WriteLn('Subject     : ',H.maSubject);
   WriteLn('Date        : ',H.maDate);
   WriteLn;
   WriteLn('TimesRead   : ',H.maTimesRead);
   WriteLn('DestNode    : ',H.nodeDest);
   WriteLn('OrigNode    : ',H.nodeOrig);
   WriteLn('Cost        : ',H.maCost);
   WriteLn('OrigNet     : ',H.netOrig);
   WriteLn('DestNet     : ',H.netDest);
   WriteLn;
   WriteLn('DateWritten : ',H.dateWritten,' ('+dtJulianToDate(H.dateWritten)+')');
   WriteLn('DateArrived : ',H.dateArrived,' ('+dtJulianToDate(H.dateArrived)+')');
   WriteLn('Msg Ref     : ',H.maRef);
   WriteLn('Attributes  : ',S);
   WriteLn('UnReply?    : ',H.unReply);
   WriteLn;
   Close(fH);
end.