{$F-,A+,O+,G+,R-,S+,I+,Q-,V-,B-,X+,T-,P-,D-,L-,N-,E+}
unit Transfer;

interface

uses Global;

function  xferGood(Fn : String; Send : Boolean) : Boolean;
procedure xferLoadProt(N : Byte);
function  xferReceive(Fn : String; Pt : tProtFlagSet) : Boolean;
procedure xferSaveProt(N : Byte);
function  xferSelectProtocol(pt : tProtFlagSet) : Byte;
function  xferSend(Fn : String; Pt : tProtFlagSet) : Boolean;

implementation

uses Dos,
     Files, Strings, BBSinit, ShowFile, Output, Input, Misc, Comm;

procedure xferLoadProt(N : Byte);
var F : file of tProtRec;
begin
   FillChar(Prot^,SizeOf(Prot^),0);
   Assign(F,Cfg^.pathData+fileProt);
   {$I-}
   Reset(F);
   {$I-}
   if (ioResult <> 0) then
   begin
      resetProtocols;
      Reset(F);
   end;
   if FileSize(F) <> maxProt then
   begin
      Close(F);
      resetProtocols;
      Reset(F);
   end;
   Seek(F,N-1);
   Read(F,Prot^);
   Close(F);
end;

procedure xferSaveProt(N : Byte);
var F : file of tProtRec;
begin
   Assign(F,Cfg^.pathData+fileProt);
   {$I-}
   Reset(F);
   {$I-}
   if (ioResult <> 0) then
   begin
      resetProtocols;
      Reset(F);
   end;
   if FileSize(F) <> maxProt then
   begin
      Close(F);
      resetProtocols;
      Reset(F);
   end;
   Seek(F,N-1);
   Write(F,Prot^);
   Close(F);
end;

function xferGood(Fn : String; Send : Boolean) : Boolean;
var F : Text; S, Lg, Tp, logFn, logStat : String; Found, xok, ok : Boolean; Z : Byte;
begin
   xferGood := False;
   Tp := fTempPath('F');
   Lg := strReplace(Prot^.Log,'%TD',Copy(Tp,1,Length(Tp)-1));
   Lg := strReplace(Lg,'%ND',St(Node));
   Assign(F,Lg);
   {$I-}
   Reset(F);
   {$I+}
   if ioResult <> 0 then Exit;

   Found := False;
   while (not Found) and (not Eof(F)) do
   begin
      ReadLn(F,S);
      logStat := Copy(S,Prot^.posStat,255);
      if Pos(' ',logStat) > 0 then Delete(logStat,Pos(' ',logStat),255);
      logFn := Copy(S,Prot^.posFile,255);
      if Pos(' ',logFn) > 0 then Delete(logFn,Pos(' ',logFn),255);
      Found := UpStr(strFilename(logFn)) = UpStr(strFilename(Fn));
   end;
   Close(F);
   if not Found then Exit;
   xOk := Prot^.codeIs = xferOk;
   Ok := not xOk;
   if Send then
   begin
      for Z := 1 to 6 do if Pos(Prot^.codeDL[Z],logStat) > 0 then Ok := xOk;
   end else
   begin
      for Z := 1 to 6 do if Pos(Prot^.codeUL[Z],logStat) > 0 then Ok := xOk;
   end;
   xferGood := Ok;
end;

function xferSend(Fn : String; Pt : tProtFlagSet) : Boolean;
var Ex, Lg, Tp, env : String; Batch : Boolean; P : Byte;
begin
   xferSend := False;
   P := xferSelectProtocol(pt);
   if P = 0 then Exit;
   xferLoadProt(P);
   Tp := fTempPath('F');
   Batch := protBatch in Prot^.Flag;
   if (Prot^.cmdDL = '') or ((Batch) and (not fExists(Tp+fileTempDL))) then Exit;
   Lg := strReplace(Prot^.Log,'%TD',Copy(Tp,1,Length(Tp)-1));
   Lg := strReplace(Lg,'%ND',St(Node));
   fDeleteFile(Lg);
   env := strReplace(Prot^.cmdEnv,'%LF',Lg);
   Ex := Prot^.cmdDL;
   Ex := strReplace(Ex,'%CP',St(Modem^.ComPort+1));
   Ex := strReplace(Ex,'%BR',St(Modem^.BaudRate));
   Lg := strReplace(Prot^.listDL,'%TD',Copy(Tp,1,Length(Tp)-1));
   Lg := strReplace(Lg,'%ND',St(Node));
   if Batch then Ex := strReplace(Ex,'%FL',Lg) else
                 Ex := strReplace(Ex,'%FN',Fn);
   if (Batch) and (not (fCopyFile(Tp+fileTempDL,Lg))) then Exit;
   if Prot^.cmdEnv <> '' then Ex := Ex+#1+env;
   fShellDos(Cfg^.pathProt+Ex,Cfg^.ProtocolSwap,False,True);
   cInitFossil;
   xferSend := (Batch) or (xferGood(Fn,True));
end;

function xferReceive(Fn : String; Pt : tProtFlagSet) : Boolean;
var env, Ex, Lg, Tp : String; Batch : Boolean; P : Byte;
begin
   xferReceive := False;
   P := xferSelectProtocol(pt);
   if P = 0 then Exit;
   xferLoadProt(P);
   Tp := fTempPath('F');
   Batch := protBatch in Prot^.Flag;
   if (Prot^.cmdUL = '') then Exit;
   Lg := strReplace(Prot^.Log,'%TD',Copy(Tp,1,Length(Tp)-1));
   Lg := strReplace(Lg,'%ND',St(Node));
   fDeleteFile(Lg);
   env := strReplace(Prot^.cmdEnv,'%LF',Lg);
   Ex := Prot^.cmdUL;
   Ex := strReplace(Ex,'%CP',St(Modem^.ComPort+1));
   Ex := strReplace(Ex,'%BR',St(Modem^.BaudRate));
   Lg := strReplace(Prot^.listDL,'%TD',Copy(Tp,1,Length(Tp)-1));
   Lg := strReplace(Lg,'%ND',St(Node));
{  if (Fn = '') and (not Batch) then strReplace(Ex,'%FN','');}
   if not Batch then Ex := strReplace(Ex,'%FN',Fn);
   if Prot^.cmdEnv <> '' then Ex := Ex+#1+env;
   fShellDos(Cfg^.pathProt+Ex,Cfg^.ProtocolSwap,False,True);
   cInitFossil;
   xferReceive := (Batch) or (xferGood(Fn,False));
end;

function xferSelectProtocol(pt : tProtFlagSet) : Byte;
 var Ans : Boolean; F : file of tProtRec; N, R, X, W : Word;
    pk : array[1..maxProt] of record Key : Char; Rec : Byte; end;
    Ch : Char; pts : String;
begin
   xferSelectProtocol := 0;
   Ans := (sfGetTextFile(txListProtTop,ftTopLine) <> '') and
          (sfGetTextFile(txListProtMid,ftListProt) <> '') and
          (sfGetTextFile(txListProtBot,ftNormal) <> '');
   PausePos := 1;
   PauseAbort := False;
   if Ans then
   begin
      sfShowTextFile(txListProtTop,ftTopLine);
      oUpPause(ansiRows-1);
      sfGotoPos(1);
      sfLoadRepeat(txListProtMid);
   end else
   begin
      oDnLn(1);
      oUpPause(1);
   end;
   FillChar(Prot^,SizeOf(Prot^),0);
   Assign(F,Cfg^.pathData+fileProt);
   {$I-}
   Reset(F);
   {$I-}
   if (ioResult <> 0) then
   begin
      resetProtocols;
      Reset(F);
   end;
   if FileSize(F) <> maxProt then
   begin
      Close(F);
      resetProtocols;
      Reset(F);
   end;
   N := 0;
   R := 0;
   while (not PauseAbort) and (not Eof(F)) do
   begin
      Read(F,Prot^);
      Inc(R,1);
      if (acsOk(Prot^.Acs)) and (Prot^.Flag = pt) then
      begin
         Inc(N,1);
         pk[N].Key := Prot^.Key;
         pk[N].Rec := R;
         pts := '';
         if protBiDir  in Prot^.Flag then pts := 'BiDir/';
         if protBatch  in Prot^.Flag then pts := pts+'Batch/' else
         if protActive in Prot^.Flag then pts := pts+'Normal' else
                                      pts := pts+'Disabled';
         if pts[Length(pts)] = '/' then Delete(pts,Length(pts),1);
         if Ans then
         begin
            sfStr[1] := Prot^.Key;
            sfStr[2] := Prot^.Desc;
            sfStr[3] := pts;
            sfStr[4] := St(N);
            sfShowRepeat(ftListProt);
            if oWhereX <> 1 then oDnLn(1);
            oUpPAuse(1);
         end else
         begin
            oCwriteLn(' |U2[|U3'+Prot^.Key+'|U2] |U1'+Prot^.Desc);
            oUpPause(1);
         end;
      end;
   end;
   sfKillRepeat;
   Close(F);
   if Ans then
   begin
      sfShowTextFile(txListProtBot,ftNormal);
      oUpPause(ansiRows);
   end else
   begin
      oDnLn(1);
      oUpPause(1);
   end;
   PausePos := 0;
   if N < 1 then Exit;
   oString(strXferSelectProtocol);
   repeat
      Ch := UpCase(iReadKey);
      W := 0;
      for X := 1 to N do if Ch = pk[X].Key then W := X;
   until (Ch in [#27,#13]) or (HangUp) or (W <> 0);
   if (HangUp) or (Ch in [#27,#13]) then
   begin
      oWriteLn('Abort');
      Exit;
   end else oWriteLn(Ch);
   xferSelectProtocol := pk[W].Rec;
end;

end.