{$F-,A+,O+,G+,R-,S+,I+,Q-,V-,B-,X+,T-,P-,D-,L-,N-,E+}
unit FastIO;

interface

uses Crt,
     Global, Misc;

Const
  NormalCursor = $0D0E; (* Might be different on some systems *)
  BlankCursor  = $2000;
  maxWin       = 4;
  Blank : record C : Char; A : Byte end = (C:' ';A:$07);

Type
  ScrBuffer   = array[0..2047] of Word;
  pWins       = ^tWins;
  tWins       = array[1..maxWin] of ScrBuffer;

Var
  DirectVideoGUI: Boolean; (* define as TRUE if direct-video writing *)
  Screen : array[0..7] of ScrBuffer Absolute $B800:0000;
  ioWin  : pWins;
  pageAct, pageVis : Byte;

  posUpdate : Boolean;

procedure ioClrEol;
procedure ioClrScr;
procedure ioCwrite(s : String);
procedure ioCwriteLn(s : String);
function  ioGetAttr(F,B : Byte; Blink : Boolean) : Byte;
procedure ioGetColor(Color : Byte; Var BackGr : Byte; Var ForeGr : Byte; var Bl : Boolean);
procedure ioGotoXY(X,Y : Byte);
procedure ioHighVideo;
procedure ioInitFastIO;
procedure ioLowVideo;
procedure ioPageActive(Page : Byte);
procedure ioPageVisual(Page : Byte);
procedure ioScreenOn;
procedure ioScrollDown;
procedure ioTextAttr(Color : Byte);
procedure ioTextBack(Back : Byte);
procedure ioTextBlink(Blink : Boolean);
procedure ioTextColor(F,B : Byte; Bl : Boolean);
procedure ioTextColRec(C : tColorRec);
procedure ioTextFore(Fore : Byte);
procedure ioUpdatePos;
function  ioWhereX : Byte;
function  ioWhereY : Byte;
procedure ioWrite(S : String);
procedure ioWriteLn(S : String);
procedure ioWriteChar(Ch : Char);



Procedure ScrollWindowUp (NoLines, Attrib, ColUL, RowUL, ColLR, RowLR: Byte);
Procedure ScrollWindowDn (NoLines, Attrib, ColUL, RowUL, ColLR, RowLR: Byte);
Procedure HLineCharAttrib (Page: Byte; CharAttrib: Word; xFrom, xTo, Y: Byte);
Procedure VLineCharAttrib (Page: Byte; CharAttrib: Word; X, yFrom, yTo: Byte);
Function  GetCharAttribXY (Page, X, Y: Byte): Word;
Function  GetCharAttrib (Page: Byte): Word;
Procedure PutCharAttrib (Page: Byte; CharAttrib: Word; NoChar: Word);
Procedure CWriteXY (Page, attrib, X, Y: Byte; n: String);
Procedure WriteXY (Page, attrib, X, Y: Byte; Var n: String);
Procedure WriteXYCh (Page, attrib, X, Y, c: Byte);
Procedure SetCursorPos (Page, Column, Row: Byte);
Procedure GetCursorPos (Var Page, Column, Row: Byte);
Procedure SetCursorType (ctype: Word);
Function  GetCursorType (Page: Byte): Word;

Procedure SavScr (Page: Byte; Var S: ScrBuffer);
Procedure ResScr (Page: Byte; Var S: ScrBuffer);

Function  GetKeyCode: Word; (* Wait for Key from Buffer *)
Function  GetKeyFlags: Byte;
Function  PollKey (Var Status: Word): Word;
Function  GetKeyStroke: Word;  (* Enhanced Keyboard? *)
Function  CheckKeyBoard: Word; (* Enhanced Keyboard? *)
Procedure WriteKey (KeyCode: Word; Var Status: Byte);

Procedure WaitOnUser (Var Code, X, Y, Button: Word);
Function  InitMouse: Word;
Procedure ShowMouseCursor;
Procedure HideMouseCursor;
Procedure SetMouseWindow (X1, Y1, X2, Y2: Word);
Procedure GetMousePos (Var X, Y, button: Word);
Procedure SetMousePos (X, Y: Word);
Procedure GetButtonPressInfo (Var X, Y, Button, NumberOfPresses: Word);
Procedure GetButtonRelInfo (Var X, Y, Button, NumberOfReleases: Word);

Procedure Frame (Page, X1, Y1, X2, Y2, c: Byte; Title: String);
Procedure Shadow (Page, X1, Y1, X2, Y2, cc: Byte);
Procedure FHLine (Page, Attrib, xFrom, xTo, Y: Byte);
Procedure FVLine (Page, Attrib, X, yFrom, yTo: Byte);
Procedure FrameReadLN (Var T: String; Page, X1, Y1, X2, Y2, cc: Byte);
Procedure Dialogue (Var T: String; Page, X1, Y1, X2, Y2, cc: Byte; Title: String);

IMPLEMENTATION

uses DOS, StatBar;

Const
  NUL    = #00;
  DEL    = #08;
  LF     = #10;
  CR     = #13;
  SP     = #32;

  VIO    = $10;  (* BIOS Video Interrupt *)
  KBIO   = $16;  (* BIOS Keyboard        *)
  MIO    = $33;  (* Mouse Services       *)

Var reg: registers;
    DTemp: ScrBuffer;

procedure ioInitFastIO;
begin
   DirectVideoGUI := Cfg^.DirectWrites;
   posX := 1;
   posY := 1;
   Col.Fore := 7;
   Col.Back := 0;
   Col.Blink := False;
   colAttr := $0F;
   posUpdate := True;
   ioScreenOn;
end;

procedure ioScreenOn;
begin
   ioPageActive(0);
   ioPageVisual(0);
   ScreenOff := False;
end;

procedure ioPageActive(Page : Byte);
begin
   pageAct := Page;
end;

procedure ioPageVisual(Page : Byte);
begin
   pageVis := Page;
   asm
     MOV AH, $05
     MOV AL, Page
     Int VIO
   end;
   ioGotoXY(posX,posY);
end;

procedure ioClrScr;
var N : Byte; Blank : record C : Char; A : Byte end;
begin
   Blank.C := ' '; Blank.A := colAttr;
   for N := Hi(windMin) to Hi(windMax) do
   { mFillWord(Screen[pageAct],SizeOf(Screen[pageAct]) div 2,Word(Blank));}
       mFillWord(Screen[pageAct,N*80],80,Word(Blank));
   posX := 1;
   posY := 1;
   ioGotoXY(posX,posY);
end;

procedure ioClrEol;
begin
   mFillWord(Screen[pageAct,(posY-1)*80+(posX-1)],80-posX+1,Word(Blank));
end;

procedure ioUpdatePos;
begin
   posUpdate := True;
   ioGotoXY(posX,posY);
end;

procedure ioWriteChar(Ch : Char);
var Cl : record C : Char; A : Byte; end;
 procedure dwDown;
 begin
    Inc(posY,1);
    if posY > Hi(WindMax)-Hi(windMin)+1 then
    begin
       posY := Hi(WindMax)-Hi(windMin)+1;
       ioScrollDown; {mScroll(Lo(WindMin)+1,Hi(WindMin)+1,Lo(WindMax)+1,Hi(WindMax)+1,-1);}
    end;
 end;
begin
   case Ch of
     #13 : posX := Lo(WindMin)+1;
     #10 : dwDown;
     #7  : if (not Cfg^.soundRestrict) or (mSysOpAvail) then Write(#7);
     #8  : ioGotoXY(posX-1,posY);
     else begin
             Cl.C := Ch;
             Cl.A := colAttr;
             Screen[pageAct,(Hi(WindMin)+posY-1)*80+(posX-1)] := Word(Cl);
             Inc(posX);
             if posX > Lo(WindMax)+1 then
             begin
                posX := Lo(WindMin)+1;
                dwDown;
             end;
          end;
   end;
   ioGotoXY(posX,posY);
end;

procedure ioWrite(S : String);
var Z : Byte;
begin
   posUpdate := False;
   for Z := 1 to Length(S) do ioWriteChar(S[Z]);
   ioUpdatePos;
end;

procedure ioCwrite(s : String);
var C1, C2 : Char; N, CP : Integer; CS : String; upd : Boolean;
begin
   upd := posUpdate;
   posUpdate := False;
   CP := 0; C1 := ' '; C2 := ' '; CS := '';
   for N := 1 to Length(S) do
   begin
      case S[N] of
        '|' : CP := 1;
        else if CP = 0 then ioWriteChar(S[N]) else
             if CP = 1 then
             begin
                C1 := S[N];
                Inc(CP);
             end else
             if CP = 2 then
             begin
                C2 := S[N];
                CS := C1+C2;
                if CS = '00' then ioTextAttr($00) else
                if CS = '01' then ioTextAttr($01) else
                if CS = '02' then ioTextAttr($02) else
                if CS = '03' then ioTextAttr($03) else
                if CS = '04' then ioTextAttr($04) else
                if CS = '05' then ioTextAttr($05) else
                if CS = '06' then ioTextAttr($06) else
                if CS = '07' then ioTextAttr($07) else
                if CS = '08' then ioTextAttr($08) else
                if CS = '09' then ioTextAttr($09) else
                if CS = '10' then ioTextAttr($0A) else
                if CS = '11' then ioTextAttr($0B) else
                if CS = '12' then ioTextAttr($0C) else
                if CS = '13' then ioTextAttr($0D) else
                if CS = '14' then ioTextAttr($0E) else
                if CS = '15' then ioTextAttr($0F) else
                ioWrite('|'+CS);
                CP := 0;
             end;
      end;
   end;
   posUpdate := upd;
end;

procedure ioCwriteLn(s : String);
begin
   ioCwrite(s);
   ioWrite(#13#10);
end;

procedure ioScrollDown;
var N : Word;
Begin
{ Asm
    MOV AH, $07
    MOV AL, NoLines
    MOV BH, Attrib
    MOV CH, RowUL
    MOV CL, ColUL
    MOV DH, RowLR
    MOV DL, ColLR
    Int VIO
  End;}
    for N := Hi(WindMin) to Hi(WindMax)-1 do
       Move(Screen[pageAct,(N+1)*80],Screen[pageAct,N*80],160);
    mFillWord(Screen[pageAct,Hi(windMax)*80],80,Word(Blank));
End;

procedure ioWriteLn(S : String);
begin
   ioWrite(S+#13#10);
end;

procedure ioGotoXY(X,Y : Byte);
begin
  if X < 1 then X := 1 else if X > Lo(WindMax)-Lo(windMin)+1 then X := Lo(WindMax)-Lo(windMin)+1;
  if Y < 1 then Y := 1 else if Y > Hi(WindMax)-Hi(windMin)+1 then Y := Hi(WindMax)-Hi(windMin)+1;
  posX := X;
  posY := Y;
  Inc(x,Lo(windMin));
  Inc(y,Hi(windMin));
  if posUpdate then
  asm
    MOV DH, Y    { DH = Row (Y) }
    MOV DL, X    { DL = Column (X) }
    DEC DH       { Adjust For Zero-based Bios routines }
    DEC DL       { Turbo Crt.GotoXY is 1-based }
    MOV BH,pageAct     { Display page 0 }
    MOV AH,2     { Call For SET CURSOR POSITION }
    INT 10h
  end;
end;

function ioWhereX : Byte;
(*
asm
  MOV     AH,3      {Ask For current cursor position}
  MOV     BH,pageAct      { On page 0 }
  INT     10h       { Return inFormation in DX }
  INC     DL        { Bios Assumes Zero-based. Crt.WhereX Uses 1 based }
  MOV     AL, DL    { Return X position in AL For use in Byte Result }
*)
begin
   ioWhereX := posX;
end;

function ioWhereY : Byte;
(*
asm
  MOV     AH,3     {Ask For current cursor position}
  MOV     BH,pageAct     { On page 0 }
  INT     10h      { Return inFormation in DX }
  INC     DH       { Bios Assumes Zero-based. Crt.WhereY Uses 1 based }
  MOV     AL, DH   { Return Y position in AL For use in Byte Result }
  *)
begin
   ioWhereY := posY;
end;

procedure ioGetColor(Color : Byte; Var BackGr : Byte; Var ForeGr : Byte; var Bl : Boolean);
begin
  BackGr := Color shr 4;
  ForeGr := Color xor (BackGr shl 4);
  if BackGr > 7 then
  begin
     Dec(BackGr,8);
     Bl := True;
  end else Bl := False;
end;

function ioGetAttr(F,B : Byte; Blink : Boolean) : Byte;
begin
   if Blink then Inc(B,8);
   ioGetAttr := (B Shl 4) or F;
end;

procedure ioTextAttr(Color : Byte);
begin
   colAttr := Color;
   ioGetColor(Color,Col.Back,Col.Fore,Col.Blink);
end;

procedure ioHighVideo;
begin
   if Col.Fore < 8 then Inc(Col.Fore,8);
   colAttr := ioGetAttr(Col.Fore,Col.Back,Col.Blink)
end;

procedure ioLowVideo;
begin
   if Col.Fore > 7 then Dec(Col.Fore,8);
   colAttr := ioGetAttr(Col.Fore,Col.Back,Col.Blink)
end;

procedure ioTextFore(Fore : Byte);
begin
   Col.Fore := Fore;
   colAttr := ioGetAttr(Col.Fore,Col.Back,Col.Blink)
end;

procedure ioTextBack(Back : Byte);
begin
   Col.Back := Back;
   colAttr := ioGetAttr(Col.Fore,Col.Back,Col.Blink)
end;

procedure ioTextBlink(Blink : Boolean);
begin
   Col.Blink := Blink;
   colAttr := ioGetAttr(Col.Fore,Col.Back,Col.Blink)
end;

procedure ioTextColor(F,B : Byte; Bl : Boolean);
begin
   Col.Fore := F;
   Col.Back := B;
   Col.Blink := Bl;
   colAttr := ioGetAttr(Col.Fore,Col.Back,Col.Blink)
end;

procedure ioTextColRec(C : tColorRec);
begin
   Col := C;
   colAttr := ioGetAttr(Col.Fore,Col.Back,Col.Blink)
end;

function x80(y: word): word;
begin
  asm
    MOV AX,y
    MOV BX,AX
    MOV CL,4
    SHL BX,CL
    MOV CL,6
    SHL AX,CL
    ADD AX,BX
    MOV @Result, AX
  end
end;

function x80p(y,x: word): word;
begin
  asm
    MOV AX,y
    MOV BX,AX
    MOV CL,4
    SHL BX,CL
    MOV CL,6
    SHL AX,CL
    ADD AX,BX
    ADD AX,x
    MOV @Result, AX
  end
end;

Procedure PutCharAttrib (Page: Byte; CharAttrib: Word; NoChar: Word);
Begin
  Asm
    MOV AX, CharAttrib
    MOV BL, AH
    MOV AH, $09
    MOV BH, Page
    MOV CX, NoChar
    Int VIO
  End;
End;

Function GetCharAttrib (Page: Byte): Word;
Begin
  Asm
    MOV AH, $08
    MOV BH, Page
    Int VIO
    MOV @Result, AX
  End;
End;

Function GetCharAttribXY (Page, X, Y: Byte): Word;
Begin
  If DirectVideoGUI
  Then GetCharAttribXY := Screen [Page] [ x80p(Y,X)]
  Else Begin
    Asm
      MOV AH, $02
      MOV BH, Page
      MOV DH, Y
      MOV DL, X
      Int VIO
      MOV AH, $08
      MOV BH, Page
      Int VIO
      MOV @Result, AX
    End
  End;
End;

Procedure ScrollWindowUp (NoLines, Attrib, ColUL, RowUL, ColLR, RowLR: Byte);
  Assembler;
Asm
  MOV AH, $06
  MOV AL, NoLines
  MOV BH, Attrib
  MOV CH, RowUL
  MOV CL, ColUL
  MOV DH, RowLR
  MOV DL, ColLR
  Int VIO
End;

Procedure ScrollWindowDn (NoLines, Attrib, ColUL, RowUL, ColLR, RowLR: Byte);
Begin
  Asm
    MOV AH, $07
    MOV AL, NoLines
    MOV BH, Attrib
    MOV CH, RowUL
    MOV CL, ColUL
    MOV DH, RowLR
    MOV DL, ColLR
    Int VIO
  End;
End;

Procedure GetCursorPos (Var Page, Column, Row: Byte);
Var p, X, Y: Byte;
Begin
  p := Page;
  Asm
    MOV AH, $03
    MOV BH, p
    Int VIO
    MOV p, BH
    MOV X, DL
    MOV Y, DH
  End;
  Page := p;
  Column := X;
  Row := Y;
End;

Function GetCursorType (Page: Byte): Word;
Begin
  Asm
    MOV AH, $03;
    MOV BH, Page
    Int VIO
    MOV @Result, CX
  End;
End;

Procedure SetCursorPos (Page, Column, Row: Byte);
Begin
  Asm
    MOV AH, $02
    MOV BH, Page
    MOV DH, Row
    MOV DL, Column
    Int VIO
  End;
End;

Procedure SetCursorType (ctype: Word);
Begin
  Asm
    MOV AH, $01
    MOV CX, ctype
    Int VIO
  End;
End;

Procedure WriteXYCh (Page, attrib, X, Y, c: Byte);
Begin
  If DirectVideoGUI
  Then Screen [Page] [ x80p(Y,X) ] :=
    (attrib ShL 8) + c
  Else Begin
    Asm
      MOV AH, $02
      MOV BH, Page
      MOV DL, X
      MOV DH, Y
      Int VIO
      MOV AL, c
      MOV BL, Attrib
      MOV AH, $09
      MOV CX, 1
      Int VIO
    End
  End
End;

Procedure WriteXY (Page, attrib, X, Y: Byte; Var n: String);
Var i: byte;
Begin
  If n [0] <> #0
  Then If DirectVideoGUI
  Then Begin
    For i := 1 To Length (n)
    Do Screen [Page] [ x80p(Y,X+Pred (i)) ] := (attrib ShL 8) + Ord (n [i] );
  End
  Else Begin
   for i:=1 to Length(n)
    do
     WriteXYCh(Page,Attrib,X+pred(i),y,ord(n[i]));
End
End;

Procedure CWriteXY (Page, attrib, X, Y: Byte; n: String);
Begin
  WriteXY (Page, attrib, X, Y, n);
End;

Procedure HLineCharAttrib (Page: Byte; CharAttrib: Word; xFrom, xTo, Y: Byte);
var X : Byte;
Begin
  If DirectVideoGUI
  Then For X := x80p(Y, xFrom) To x80p(Y, xTo)
    Do Screen [Page] [X] := CharAttrib
  Else Begin
    SetCursorPos (Page, xFrom, Y);
    PutCharAttrib (Page, CharAttrib, (xTo - xFrom) + 1)
  End
End;

Procedure VLineCharAttrib (Page: Byte; CharAttrib: Word; X, yFrom, yTo: Byte);
Var Y: Byte;
Begin
  For Y := yFrom To yTo
  Do If DirectVideoGUI
  Then Screen [Page] [ x80p(Y, X)] := CharAttrib
  Else Begin
    SetCursorPos (Page, X, Y);
    PutCharAttrib (Page, CharAttrib, 1)
  End
End;

Procedure Frame (Page, X1, Y1, X2, Y2, c: Byte; Title: String);
var X, Y : Byte;
Begin
  ScrollWindowUP (0, c, X1, Y1, X2, Y2); (* Must be on correct Page! *)
  For X := X1 To X2
  Do Begin
    WriteXYCh (Page, c, X, Y1, 196);
    WriteXYCh (Page, c, X, Y2, 196)
  End;
  For Y := Y1 To Y2
  Do Begin
    WriteXYCh (Page, c, X1, Y, 179);
    WriteXYCh (Page, c, X2, Y, 179)
  End;
  WriteXYCh (Page, c, X1, Y1, 218);
  WriteXYCh (Page, c, X2, Y1, 191);
  WriteXYCh (Page, c, X1, Y2, 192);
  WriteXYCh (Page, c, X2, Y2, 217);
  If title <> ''
  Then CWriteXY (Page, c, ( (X2 - X1) - (Length (title) + 2) ) Div 2, Y1, SP+Title);
End;

Procedure FHLine (Page, Attrib, xFrom, xTo, Y: Byte);
Begin
  HLineCharAttrib (Page, (Attrib ShL 8) + 196, Succ (xFrom), Pred (xTo), Y);
  WriteXYCh (Page, Attrib, xFrom, Y, 195);
  WriteXYCh (Page, Attrib, xTo, Y, 180);
End;

Procedure FVLine (Page, Attrib, X, yFrom, yTo: Byte);
Begin
  VLineCharAttrib (Page, (Attrib shl 8) + 179, X, Succ (yFrom), Pred (yTo) );
  WriteXYCh (Page, Attrib, X, yFrom, 194);
  WriteXYCh (Page, Attrib, X, yTo, 193);
End;


Procedure SavScr (Page: Byte; Var S: ScrBuffer);
Begin
  If DirectVideoGUI
  Then Move (Screen, S [Page], 4000)
  Else
    asm
      MOV DL, 79
@I1:  MOV DH, 24
@I0:  MOV BH, Page
      MOV AH,02
      INT VIO
      MOV AH,08
      INT VIO

      XCHG AX, DI
      XOR AX, AX
      MOV AL, DH
      MOV BX, AX
      MOV CL,4
      SHL BX,CL
      MOV CL,6
      SHL AX,CL
      ADD AX,BX
      CLC
      ADD AL,DL
      ADC AH,00
      SHL AX,1
      LDS SI, S
      ADD SI,AX

      XCHG AX, DI
      MOV WORD PTR [SI],AX
      DEC DH
      CMP DH,-1
      JNE @I0
      DEC DL
      CMP DL,-1
      JNE @I1
    end;
End;

Procedure ResScr (Page: Byte; var S: ScrBuffer);
Begin
  If DirectVideoGUI
  Then Move (S, Screen [Page], 4000)
  Else
    asm
      MOV DL, 79
@I1:  MOV DH, 24
@I0:  MOV BH, Page
      MOV AH,02
      INT VIO
      XOR AX, AX
      MOV AL, DH
      MOV BX, AX
      MOV CL,4
      SHL BX,CL
      MOV CL,6
      SHL AX,CL
      ADD AX,BX
      CLC
      ADD AL,DL
      ADC AH,00
      SHL AX,1

      LDS SI, S
      ADD SI,AX

      MOV AX,WORD PTR [SI]
      MOV BL, AH
      MOV BH, Page
      MOV AH, 09
      MOV CX, 1
      int VIO
      DEC DH
      CMP DH,-1
      JNE @I0
      DEC DL
      CMP DL,-1
      JNE @I1
    end;
End;

Function GetKeyCode: Word;
Begin
  Asm
    MOV AH, $00
    Int KBIO
    MOV @Result, AX
  End;
End;

Function PollKey (Var Status: Word): Word;
var s: word;
Begin
  asm
    MOV AH, 01
    INT KBIO
    MOV @Result, AX
    LAHF
    AND AX, 64
    MOV S, AX
  end;
  Status:=s;
End;

Function GetKeyStroke: Word;
Begin
  Asm
    MOV AH, $10
    Int KBIO
    MOV @Result, AX
  End;
End;

Function CheckKeyBoard: Word;
Begin
  Asm
    MOV AH, $11
    Int KBIO
    MOV @Result, AX
  End;
End;

Function GetKeyFlags: Byte;
Begin
  Asm
    MOV AH, $02
    Int KBIO
    MOV @Result, AL
  End;
End;

Function GetKeyStatus: Word;
Begin
  Asm
    MOV AH, $12
    Int KBIO
    MOV @Result, AX
  End;
End;

Procedure WriteKey (KeyCode: Word; Var Status: Byte);
Var s: Byte;
Begin
  Asm
    MOV AH, $05
    MOV CX, KeyCode
    Int KBIO
    MOV s, AL
  End;
  Status := s;
End;

Procedure WaitOnUser (Var Code, X, Y, Button: Word);
 (* wait for key or mouse click *)
Var Status: Word;
Begin
  Repeat
    Code := PollKey (Status);
    GetMousePos (X, Y, Button);
  Until (Button <> 0) Or (Status = 0);
End;

Function InitMouse: Word;
Begin
  Asm
    MOV AX, $0000
    Int MIO
    MOV @Result, AX
  End;
End;

Procedure ShowMouseCursor; Assembler;
Asm
  MOV AX, $0001
  Int MIO
End;

Procedure HideMouseCursor; Assembler;
Asm
  MOV AX, $0002
  Int MIO
End;

Procedure GetMousePos (Var X, Y, Button: Word);
Var X1, Y1, b: Word;
Begin
  Asm
    MOV AX, $0003
    Int MIO
    MOV b,  BX
    MOV X1, CX
    MOV Y1, DX
  End;
  X := X1;
  Y := Y1;
  Button := b;
End;

Procedure SetMousePos (X, Y: Word); Assembler;
Asm
  MOV AX, $0004
  MOV CX, X
  MOV DX, Y
  Int MIO
End;

Procedure GetButtonPressInfo (Var X, Y, Button, NumberOfPresses: Word);
Begin
  reg. AX := $0005;
  reg. BX := Button;
  Intr (MIO, reg);
  Button := reg. AX;
  X := reg. CX;
  Y := reg. DX;
  NumberOfPresses := reg. BX
End;

Procedure GetButtonRelInfo (Var X, Y, Button, NumberOfReleases: Word);
Begin
  reg. AX := $0006;
  reg. BX := Button;
  Intr (MIO, reg);
  Button := reg. AX;
  X := reg. CX;
  Y := reg. DX;
  NumberOfReleases := reg. BX
End;

Procedure SetMouseWindow (X1, Y1, X2, Y2: Word);
Begin
  reg. AX := $0007;
  reg. CX := X1;
  reg. DX := X2;
  Intr ($33, reg);
  Inc (reg. AX, 1);
  reg. CX := Y1;
  reg. DX := Y2;
  Intr (MIO, reg)
End;


Procedure Shadow (Page, X1, Y1, X2, Y2, cc: Byte);
Begin
  HLineCharAttrib (Page, (cc * $100) + $B1, Succ (X1), Succ (X2), Succ (Y2) );
  VLineCharAttrib (Page, (cc * $100) + $B1, Succ (X2), Succ (Y1), Succ (Y2) );
End;

Procedure Dialogue (Var T: String; Page, X1, Y1, X2, Y2, cc: Byte; Title: String);
Begin
  SavScr (Page, DTemp);
  Frame (Page, X1, Y1, X2, Y2, cc, ''); Title := SP + Title + SP;
  WriteXY (Page, cc, Succ (X1), Y1, Title);
  FrameReadLN (T, Page, Succ (X1), Succ (Y1), Pred (X2), Pred (Y2), cc);
  ResScr (Page, DTemp)
End;

Procedure FrameReadLN (Var T: String; Page, X1, Y1, X2, Y2, cc: Byte);
Var i, X, Y, z: Byte;
  Code: Word;
  C: Char;
Begin
  X := X1; Y := Y1;
  If T [0] <> #0
  Then For i := 0 To Pred (Ord (T [0] ) )
    Do WriteXYCh (Page, cc, (i Mod (X2 - X1) ) + X1, (i Div (X2 - X1) ) + Y1, Ord(T[0]));
  SetCursorType (NormalCursor);
  i := 0;
  Repeat
    SetCursorPos (Page, X, Y);
    Code := GetKeyCode;
    C := Chr (Lo (Code) );
    If C = NUL
    Then Begin
      Case Hi (Code) Of
        $4B: If i <> 0 Then Dec (i);
        $4D: If i < Ord (T [0] ) Then Inc (i);
        $47: i := 0;
        $4F: i := Ord (T [0] );
        {   $53:if i<ord(T[0]) then begin
        if i>1
        then T:=Copy(T,1,pred(i))+Copy(T,succ(i),255)
        else if i<>ord(T[0])
        then T:=Copy(T,2,255)
        else T:=Copy(T,1,pred(i));
        for z:=i to ord(T[0])
        do WriteXY(Page,cc,(z mod (x2-x1))+x1,(z div (x2-x1))+y1,T[z]);
        WriteXY(Page,cc,(succ(z) mod (x2-x1))+x1,
        (succ(z) div (x2-x1))+y1,SP);
        end;    }
      End;
      X := (i Mod (X2 - X1) ) + X1;
      Y := (i Div (X2 - X1) ) + Y1
    End
    Else If C <> CR
    Then If (i < 255) And (Y <= Y2)
    Then If C <> DEL
    Then Begin
      Inc (i);
      T [i] := C;
      If i > Ord (T [0] )
      Then Inc (T [0], 1);
      WriteXYCh (Page, cc, X, Y, Ord (C) );
      Inc (X);
      If X = X2
      Then Begin
        Inc (Y);
        X := X1
      End
    End
    Else If (i <> 0) And (i = Ord (T [0] ) )
    Then Begin
      {  if i<ord(T[0])
      then T:=Copy(T,1,pred(i))+Copy(T,succ(i),255);}
      Dec (i);
      Dec (T [0], 1);
      If X = X1
      Then Begin
        X := Pred (X2);
        Dec (Y)
      End
      Else Dec (X);
      If i = Ord (T [0] )
      Then WriteXYCh (Page, cc, X, Y, 32)
        {   else begin
        for z:=i to ord(T[0])
        do WriteXY(Page,cc,(z mod (x2-x1))+x1,(z div (x2-x1))+y1,T[z]);
        WriteXY(Page,cc,(succ(z) mod (x2-x1))+x1,
        (succ(z) div (x2-x1))+y1,SP);
        x:=(i mod (x2-x1))+x1;
        y:=(i div (x2-x1))+y1
        end  }
    End
  Until C = CR;
  SetCursorType (BlankCursor);
End;

End.
