{$F-,A+,O+,G+,R-,S+,I+,Q-,V-,B-,X+,T-,P-,D-,L-,N-,E+}
unit FileSort;

interface

procedure fsSortfileAreas(Par : String);

implementation

uses Dos,
     Global, FileArea, Strings, DateTime, Output, Input, Misc;

var fD : file of tFileRec;
    bubblesortend : Integer;

procedure fsSwitch(a, b : Integer);
var f1, f2 : tFileRec;
begin
   Seek(fD,a); Read(fD,f1);
   Seek(fD,b); Read(fD,f2); Seek(fD,b); Write(fD,f1);
   Seek(fD,a); Write(fD,f2);
end;

function fsGreater(islesser, isequ : Boolean; r1, r2 : Integer) : Boolean;
var f1, f2 : tFileRec; b, c : Boolean;
 procedure figure1;
 begin
    case fArea^.SortType of
  sortFilename : if isequ then b := f1.Filename <= f2.Filename
                          else b := f1.Filename < f2.Filename;
 sortExtension : if isequ then b := strFileExt(f1.Filename) <= strFileExt(f2.Filename)
                          else b := strFileExt(f1.Filename) < strFileExt(f2.Filename);
      sortSize : if isequ then b := f1.Size <= f2.Size
                          else b := f1.Size < f2.Size;
      sortDate : if isequ then b := dtDatetoJulian(f1.Date) <= dtDatetoJulian(f2.Date)
                          else b := dtDatetoJulian(f1.Date) < dtDatetoJulian(f2.Date);
    sortULDate : if isequ then b := dtDatetoJulian(f1.ulDate) <= dtDatetoJulian(f2.ulDate)
                          else b := dtDatetoJulian(f1.ulDate) < dtDatetoJulian(f2.ulDate);
  sortUploader : if isequ then b := f1.Uploader <= f2.Uploader
                          else b := f1.Uploader < f2.Uploader;
 sortDownloads : if isequ then b := f1.Downloads <= f2.Downloads
                          else b := f1.Downloads < f2.Downloads;
    end;
  end;

  procedure figure2;
  begin
    case fArea^.SortType of
  sortFilename : if isequ then b := f1.Filename >= f2.Filename
                          else b := f1.Filename > f2.Filename;
 sortExtension : if isequ then b := strFileExt(f1.Filename) >= strFileExt(f2.Filename)
                          else b := strFileExt(f1.Filename) > strFileExt(f2.Filename);
      sortSize : if isequ then b := f1.Size >= f2.Size
                          else b := f1.Size > f2.Size;
      sortDate : if isequ then b := dtDatetoJulian(f1.Date) >= dtDatetoJulian(f2.Date)
                          else b := dtDatetoJulian(f1.Date) > dtDatetoJulian(f2.Date);
    sortULDate : if isequ then b := dtDatetoJulian(f1.ulDate) >= dtDatetoJulian(f2.ulDate)
                          else b := dtDatetoJulian(f1.ulDate) > dtDatetoJulian(f2.ulDate);
  sortUploader : if isequ then b := f1.Uploader >= f2.Uploader
                          else b := f1.Uploader > f2.Uploader;
 sortDownloads : if isequ then b := f1.Downloads >= f2.Downloads
                          else b := f1.Downloads > f2.Downloads;
    end;
  end;

begin
   if (r1 < r2) then
   begin
      Seek(fD,r1); Read(fD,f1);
      Seek(fD,r2); Read(fD,f2);
   end else
   begin
      Seek(fD,r2); Read(fD,f2);
      Seek(fD,r1); Read(fD,f1);
   end;

   if fArea^.SortAcen then islesser := not islesser;
   if islesser then figure1 else figure2;
   fsGreater := b;
end;

procedure fsMainSort(pl : Integer);
label 10,20,30,40,50,60,70,80;
const maxSortRec = 2000;
var hold, pass : array[1..maxSortRec] of Integer;
    a, b, c, d, e, f, x : Integer;
begin
   a := pl; b := 0; c := 0; d := 1; e := 1; f := 0;
10:
   if (a-e < 9) then goto 70;
   b := e; c := a;
20:
   if (fsGreater(True,False,b,c)) then
   begin
      fsSwitch(c,b);
      goto 60;
   end;
30:
   Dec(c);
   if (c > b) then goto 20;
   Inc(c);
40:
   Inc(d);
   if (b-e < a-c) then
   begin
      hold[d] := c; pass[d] := a;
      a := b;
      goto 10;
   end;
   hold[d] := e; pass[d] := b;
   e := c;
   goto 10;
50:
   if (fsGreater(False,False,c,b)) then
   begin
      fsSwitch(c,b);
      goto 30;
   end;
60:
   Inc(b);
   if (c > b) then goto 50;
   Inc(c);
   goto 40;
70:
   if (a-e+1 = 1) then goto 80;
   for b := e+1 to a do for c := e to (b-1) do
   begin
      f := b-c+e-1;
      if (fsGreater(True,False,f,f+1)) then
      begin
         x:=f+1;
         fsSwitch(f,x);
      end;
   end;
80:
   e := hold[d]; a := pass[d];
   Dec(d);
   if (d = 0) then Exit;
   goto 10;
end;

procedure fsFlipit(pl : Integer);
var i : Integer;
begin
   for i := 1 to pl div 2 do fsSwitch(i,(pl-i)+1);
end;

procedure fsBubbleSort(pl : Integer);
var f1, f2 : tFileRec; i, j, numDone : Integer;
    foundIt : Boolean;
begin
   if (bubblesortend > pl) then bubblesortend := pl;
   numDone:=0;
   repeat
      i := (bubblesortend+1)-numDone;
      foundIt := False;
      while ((i <= pl) and (not foundIt)) do
      if (fsGreater(False,True,1,i)) then foundIt := True else Inc(i);

{    while ((i<=pl) and (not greater(FALSE,TRUE,1,i))) do inc(i);}
      Seek(fD,1); Read(fD,f1);

{                   (i-1) __(i)               }
{                     |  /                    }
      { x O + + + + + + + x x x x x x x ..... }
      { x + + + + + + +   x x x x x x x ..... }
      for j := 1 to i-2 do
      begin
         Seek(fD,j+1); Read(fD,f2);
         Seek(fD,j); Write(fD,f2);
      end;

      { x + + + + + + + O x x x x x x x ..... }
      Seek(fD,i-1); Write(fD,f1);
      Inc(numDone);
   until ((numDone >= bubblesortend));
end;

function fsAnalysis(pl : Integer) : Integer;
var i, j : Integer; c1, c2 : Boolean;
begin
   fsAnalysis := 1;
   c1 := True; c2 := True;
   for i := 1 to pl-1 do
   begin
      if (not fsGreater(True,True,i,i+1)) then c1 := False;    { a }
      if (not fsGreater(False,True,i,i+1)) then c2 := False;   { d }
   end;
   if (c1) then fsAnalysis := 2;     { list is backwards, so flip it }
   if (c2) then fsAnalysis := 0;     { list is already sorted }
   if ((not c1) and (not c2)) then
   begin
      c1 := False; j:=0;
      i := pl-1;
      while ((i >= 1) and (not c1)) do
      begin
         if (not fsGreater(False,True,i,i+1)) then
         begin
            c1 := True; j := i;
         end;
         Dec(i);
      end;
      if ((c1) and (j/pl < 0.15)) then
      begin
         fsAnalysis := 3;
         bubblesortend := j;
      end;
   end;
end;

procedure fsSortFileArea;
var sType : Integer;
begin
   Assign(fD,Cfg^.pathData+fArea^.Filename+extFileDir);
   {$I-}
   Reset(fD);
   {$I+}
   if ioResult <> 0 then Exit;
   oStr(strCode(strCode(Strs^[strFaSortStart],1,fArea^.Name),2,St(fArea^.Files)));
   fArea^.Files := FileSize(fD);
   Seek(fD,fArea^.Files+1); Truncate(fD);
   sType := fsAnalysis(fArea^.Files);
{  case sType of
      0 : s := '.';
      1 : s := #3#0+'*';
      2 : s := #3#9+'x';
      3 : s := #3#9+'*';
   end;
    sprint(s);}
   case sType of
      0 :;
      1 : fsMainSort(fArea^.Files);
      2 : fsFlipit(fArea^.Files);
      3 : fsBubbleSort(fArea^.Files);
   end;
   Close(fD);
   oStrLn(strCode(strCode(Strs^[strFaSortEnd],1,fArea^.Name),2,St(fArea^.Files)));
end;

procedure fsSortfileAreas(Par : String);
var F : tFileRec;
    All : Boolean; Num : Word; oldArea : Word;
begin
   oDnLn(1);
   oldArea := User^.curFileArea;
   All := False;
   Num := 0;
   if Par <> '' then
   begin
      Par := UpStr(Par);
      All := (Par[1] = 'A');
      if not All then Num := StrToInt(Par);
   end;
   if (not All) and (Num = 0) then
   begin
      oString(strFaSortAskAll);
      All := iYesNo(True);
      if not All then Num := User^.curFileArea;
      oDnLn(1);
   end;

   if (not All) then
   begin
      User^.curFileArea := Num;
      faLoad;
      fsSortFileArea;
   end else
   begin
      User^.curFileArea := 0;
      while ((User^.curFileArea <= numFileArea) and (not Hangup)) do
      begin
         Inc(User^.curFileArea);
         faLoad;
         if ((faIsSponsor) or (acsOk(Cfg^.acsCoSysOp))) then fsSortFileArea;
      end;
   end;

   User^.curFileArea := oldArea;
   faLoad;
end;

end.
